/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.text.edits.TextEditGroup;

public enum UpdateProperty {
    FILE_ENCODING("file.encoding", Charset.class, "defaultCharset", "displayName", null, null, UpdateProperty::defaultvisitor, UpdateProperty::defaultRewrite),
    PATH_SEPARATOR("path.separator", null, null, null, File.class, "pathSeparator", UpdateProperty::defaultvisitor, UpdateProperty::pathRewrite),
    FILE_SEPARATOR("file.separator", FileSystems.class, "getDefault", "getSeparator", File.class, "separator", UpdateProperty::defaultvisitor, UpdateProperty::defaultRewrite),
    LINE_SEPARATOR("line.separator", System.class, "lineSeparator", null, null, null, UpdateProperty::defaultvisitor, UpdateProperty::defaultRewrite),
    BOOLEAN_PROPERTY(null, null, "getBoolean", null, Boolean.class, null, UpdateProperty::parseboolean_visitor, UpdateProperty::boolintlongRewrite),
    INTEGER_PROPERTY(null, null, "getInteger", null, Integer.class, null, UpdateProperty::parseinteger_visitor, UpdateProperty::boolintlongRewrite),
    LONG_PROPERTY(null, null, "getLong", null, Long.class, null, UpdateProperty::parselong_visitor, UpdateProperty::boolintlongRewrite);

    public static Object UNUSED;
    String key;
    Class<?> cl;
    String simplename;
    String simplename2;
    Class<?> alternativecl;
    String constant;
    IFinder myfinder;
    IRewriter myrewriter;
    static final TargetSourceRangeComputer computer;

    static {
        UNUSED = new Object();
        computer = new TargetSourceRangeComputer(){

            public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                    return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                }
                return super.computeSourceRange(nodeWithComment);
            }
        };
    }

    private UpdateProperty(String key, Class<?> cl, String simplename, String simplename2, Class<?> alternativecl, String constant, IFinder myfinder, IRewriter myrewriter) {
        this.key = key;
        this.cl = cl;
        this.simplename = simplename;
        this.simplename2 = simplename2;
        this.alternativecl = alternativecl;
        this.constant = constant;
        this.myfinder = myfinder;
        this.myrewriter = myrewriter;
    }

    static void defaultvisitor(final UpdateProperty upp, CompilationUnit compilationUnit, final Set<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations, final Set<ASTNode> nodesprocessed) {
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(MethodInvocation visited) {
                Expression expression;
                Object propertykey;
                if (nodesprocessed.contains(visited)) {
                    return false;
                }
                if (ASTNodes.usesGivenSignature(visited, System.class.getCanonicalName(), "getProperty", String.class.getCanonicalName()) && (propertykey = (expression = (Expression)visited.arguments().get(0)).resolveConstantExpressionValue()) instanceof String && upp.key.equals(propertykey)) {
                    operations.add(upp.rewrite(visited, null, expression, null));
                    nodesprocessed.add(visited);
                    return false;
                }
                return true;
            }
        });
    }

    static void parseboolean_visitor(final UpdateProperty upp, CompilationUnit compilationUnit, final Set<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations, final Set<ASTNode> nodesprocessed) {
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(MethodInvocation visited) {
                if (nodesprocessed.contains(visited)) {
                    return false;
                }
                if (ASTNodes.usesGivenSignature(visited, System.class.getCanonicalName(), "getProperty", String.class.getCanonicalName())) {
                    MethodInvocation parent;
                    Expression expression = (Expression)visited.arguments().get(0);
                    Object propertykey = expression.resolveConstantExpressionValue();
                    if (propertykey instanceof String && visited.getParent() instanceof MethodInvocation && ASTNodes.usesGivenSignature(parent = (MethodInvocation)visited.getParent(), Boolean.class.getCanonicalName(), "parseBoolean", String.class.getCanonicalName())) {
                        operations.add(upp.rewrite(parent, (String)propertykey, expression, null));
                        nodesprocessed.add(visited);
                        return false;
                    }
                } else if (ASTNodes.usesGivenSignature(visited, System.class.getCanonicalName(), "getProperty", String.class.getCanonicalName(), String.class.getCanonicalName())) {
                    MethodInvocation parent;
                    Expression expression = (Expression)visited.arguments().get(0);
                    Expression expression2 = (Expression)visited.arguments().get(1);
                    Object propertykey = expression.resolveConstantExpressionValue();
                    Object propertykey2 = expression2.resolveConstantExpressionValue();
                    if (propertykey instanceof String && propertykey2 instanceof String && visited.getParent() instanceof MethodInvocation && ASTNodes.usesGivenSignature(parent = (MethodInvocation)visited.getParent(), Boolean.class.getCanonicalName(), "parseBoolean", String.class.getCanonicalName()) && ((String)propertykey2).toLowerCase().equals("false")) {
                        operations.add(upp.rewrite(parent, (String)propertykey, expression, UNUSED));
                        nodesprocessed.add(visited);
                        return false;
                    }
                }
                return true;
            }
        });
    }

    static void parseinteger_visitor(final UpdateProperty upp, CompilationUnit compilationUnit, final Set<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations, final Set<ASTNode> nodesprocessed) {
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(MethodInvocation visited) {
                if (nodesprocessed.contains(visited)) {
                    return false;
                }
                if (ASTNodes.usesGivenSignature(visited, System.class.getCanonicalName(), "getProperty", String.class.getCanonicalName())) {
                    MethodInvocation parent;
                    Expression expression = (Expression)visited.arguments().get(0);
                    Object propertykey = expression.resolveConstantExpressionValue();
                    if (propertykey instanceof String && visited.getParent() instanceof MethodInvocation && ASTNodes.usesGivenSignature(parent = (MethodInvocation)visited.getParent(), Integer.class.getCanonicalName(), "parseInt", String.class.getCanonicalName())) {
                        operations.add(upp.rewrite(parent, (String)propertykey, expression, null));
                        nodesprocessed.add(visited);
                        return false;
                    }
                } else if (ASTNodes.usesGivenSignature(visited, System.class.getCanonicalName(), "getProperty", String.class.getCanonicalName(), String.class.getCanonicalName())) {
                    Expression expression = (Expression)visited.arguments().get(0);
                    Expression expression2 = (Expression)visited.arguments().get(1);
                    Object propertykey = expression.resolveConstantExpressionValue();
                    Object propertykey2 = expression2.resolveConstantExpressionValue();
                    if (propertykey instanceof String && propertykey2 instanceof String && visited.getParent() instanceof MethodInvocation) {
                        MethodInvocation parent = (MethodInvocation)visited.getParent();
                        if (ASTNodes.usesGivenSignature(parent, Integer.class.getCanonicalName(), "parseInt", String.class.getCanonicalName()) && ((String)propertykey2).toLowerCase().equals("0")) {
                            operations.add(upp.rewrite(parent, (String)propertykey, expression, UNUSED));
                            nodesprocessed.add(visited);
                            return false;
                        }
                        if (ASTNodes.usesGivenSignature(parent, Integer.class.getCanonicalName(), "parseInt", String.class.getCanonicalName())) {
                            operations.add(upp.rewrite(parent, (String)propertykey, expression, Integer.valueOf((String)propertykey2)));
                            nodesprocessed.add(visited);
                            return false;
                        }
                    }
                }
                return true;
            }
        });
    }

    static void parselong_visitor(final UpdateProperty upp, CompilationUnit compilationUnit, final Set<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations, final Set<ASTNode> nodesprocessed) {
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(MethodInvocation visited) {
                if (nodesprocessed.contains(visited)) {
                    return false;
                }
                if (ASTNodes.usesGivenSignature(visited, System.class.getCanonicalName(), "getProperty", String.class.getCanonicalName())) {
                    MethodInvocation parent;
                    Expression expression = (Expression)visited.arguments().get(0);
                    Object propertykey = expression.resolveConstantExpressionValue();
                    if (propertykey instanceof String && visited.getParent() instanceof MethodInvocation && ASTNodes.usesGivenSignature(parent = (MethodInvocation)visited.getParent(), Long.class.getCanonicalName(), "parseLong", String.class.getCanonicalName())) {
                        operations.add(upp.rewrite(parent, (String)propertykey, expression, null));
                        nodesprocessed.add(visited);
                        return false;
                    }
                } else if (ASTNodes.usesGivenSignature(visited, System.class.getCanonicalName(), "getProperty", String.class.getCanonicalName(), String.class.getCanonicalName())) {
                    Expression expression = (Expression)visited.arguments().get(0);
                    Expression expression2 = (Expression)visited.arguments().get(1);
                    Object propertykey = expression.resolveConstantExpressionValue();
                    Object propertykey2 = expression2.resolveConstantExpressionValue();
                    if (propertykey instanceof String && propertykey2 instanceof String && visited.getParent() instanceof MethodInvocation) {
                        MethodInvocation parent = (MethodInvocation)visited.getParent();
                        if (ASTNodes.usesGivenSignature(parent, Long.class.getCanonicalName(), "parseLong", String.class.getCanonicalName()) && ((String)propertykey2).toLowerCase().equals("0")) {
                            operations.add(upp.rewrite(parent, (String)propertykey, expression, UNUSED));
                            nodesprocessed.add(visited);
                            return false;
                        }
                        if (ASTNodes.usesGivenSignature(parent, Long.class.getCanonicalName(), "parseLong", String.class.getCanonicalName())) {
                            operations.add(upp.rewrite(parent, (String)propertykey, expression, Long.valueOf((String)propertykey2)));
                            nodesprocessed.add(visited);
                            return false;
                        }
                    }
                }
                return true;
            }
        });
    }

    CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation rewrite(final MethodInvocation visited, final String propertykey, final Expression expression, final Object object) {
        return new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation(){

            @Override
            public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
                TextEditGroup group = this.createTextEditGroup(Messages.format(MultiFixMessages.ConstantsCleanUp_description, UpdateProperty.this.toString()), cuRewrite);
                cuRewrite.getASTRewrite().setTargetSourceRangeComputer(computer);
                UpdateProperty.this.myrewriter.computeRewriter(UpdateProperty.this, visited, propertykey, expression, cuRewrite, group, object);
            }
        };
    }

    private static void boolintlongRewrite(UpdateProperty upp, MethodInvocation visited, String propertykey, Expression expression, CompilationUnitRewrite cuRewrite, TextEditGroup group, Object object) throws CoreException {
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        AST ast = cuRewrite.getRoot().getAST();
        ImportRewrite importRewrite = cuRewrite.getImportRewrite();
        importRewrite.addImport(upp.alternativecl.getCanonicalName());
        MethodInvocation newMethodInvocation = ast.newMethodInvocation();
        newMethodInvocation.setExpression((Expression)ASTNodeFactory.newName(ast, upp.alternativecl.getSimpleName()));
        newMethodInvocation.setName(ast.newSimpleName(upp.simplename));
        List arguments = newMethodInvocation.arguments();
        if (object != null) {
            StringLiteral sl = ast.newStringLiteral();
            sl.setLiteralValue(propertykey);
            arguments.add(sl);
            if (object != UNUSED) {
                NumberLiteral newNumberLiteral = ast.newNumberLiteral();
                newNumberLiteral.setToken(object.toString());
                arguments.add(newNumberLiteral);
            }
            MethodInvocation replace_with_Call = newMethodInvocation;
            ASTNodes.replaceAndRemoveNLS(rewrite, (ASTNode)visited, (ASTNode)replace_with_Call, group, cuRewrite);
        } else {
            arguments.add(ASTNodes.createMoveTarget(cuRewrite.getASTRewrite(), ASTNodes.getUnparenthesedExpression(expression)));
            MethodInvocation replace_with_Call = newMethodInvocation;
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)visited, (ASTNode)replace_with_Call, group);
        }
    }

    private static void defaultRewrite(UpdateProperty upp, MethodInvocation visited, String propertykey, Expression expression, CompilationUnitRewrite cuRewrite, TextEditGroup group, Object object) throws CoreException {
        MethodInvocation replace_with_Call;
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        AST ast = cuRewrite.getRoot().getAST();
        if (JavaModelUtil.is1d7OrHigher(cuRewrite.getCu().getJavaProject())) {
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            importRewrite.addImport(upp.cl.getCanonicalName());
            MethodInvocation firstCall = ast.newMethodInvocation();
            firstCall.setExpression((Expression)ASTNodeFactory.newName(ast, upp.cl.getSimpleName()));
            firstCall.setName(ast.newSimpleName(upp.simplename));
            if (upp.simplename2 == null) {
                replace_with_Call = firstCall;
            } else {
                MethodInvocation secondCall = ast.newMethodInvocation();
                secondCall.setExpression((Expression)firstCall);
                secondCall.setName(ast.newSimpleName(upp.simplename2));
                replace_with_Call = secondCall;
            }
        } else {
            if (upp.alternativecl == null) {
                return;
            }
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            importRewrite.addImport(upp.alternativecl.getCanonicalName());
            FieldAccess fieldaccess = ast.newFieldAccess();
            fieldaccess.setExpression((Expression)ASTNodeFactory.newName(ast, upp.alternativecl.getSimpleName()));
            fieldaccess.setName(ast.newSimpleName(upp.constant));
            replace_with_Call = fieldaccess;
        }
        ASTNodes.replaceAndRemoveNLS(rewrite, (ASTNode)visited, (ASTNode)replace_with_Call, group, cuRewrite);
    }

    private static void pathRewrite(UpdateProperty upp, MethodInvocation visited, String propertykey, Expression expression, CompilationUnitRewrite cuRewrite, TextEditGroup group, Object object) throws CoreException {
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        AST ast = cuRewrite.getRoot().getAST();
        ImportRewrite importRewrite = cuRewrite.getImportRewrite();
        importRewrite.addImport(upp.alternativecl.getCanonicalName());
        FieldAccess fieldaccess = ast.newFieldAccess();
        fieldaccess.setExpression((Expression)ASTNodeFactory.newName(ast, upp.alternativecl.getSimpleName()));
        fieldaccess.setName(ast.newSimpleName(upp.constant));
        FieldAccess replace_with_Call = fieldaccess;
        ASTNodes.replaceAndRemoveNLS(rewrite, (ASTNode)visited, (ASTNode)replace_with_Call, group, cuRewrite);
    }

    public void findOperations(CompilationUnit compilationUnit, Set<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations, Set<ASTNode> nodesprocessed) {
        this.myfinder.finder(this, compilationUnit, operations, nodesprocessed);
    }

    static interface IFinder {
        public void finder(UpdateProperty var1, CompilationUnit var2, Set<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> var3, Set<ASTNode> var4);
    }

    static interface IRewriter {
        public void computeRewriter(UpdateProperty var1, MethodInvocation var2, String var3, Expression var4, CompilationUnitRewrite var5, TextEditGroup var6, Object var7) throws CoreException;
    }
}

