/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.visualization.util.svg;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.app4mc.visualization.util.svg.AbstractDiagram;

public class GraphvizDiagram
extends AbstractDiagram {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String renderToSvg() throws IOException {
        String source = this.getDiagramText();
        if (source == null || source.isEmpty()) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>(2);
        command.add(this.getGraphvizPath());
        command.add("-Tsvg");
        Process process = new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.PIPE).start();
        StringBuilder sb = new StringBuilder();
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            OutputStreamWriter writer = new OutputStreamWriter(process.getOutputStream());
            try {
                try (InputStreamReader reader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);){
                    int len;
                    writer.append(source);
                    writer.close();
                    char[] buf = new char[1024];
                    while ((len = reader.read(buf)) >= 0) {
                        sb.append(buf, 0, len);
                    }
                    reader.close();
                }
                if (writer == null) return sb.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            writer.close();
            return sb.toString();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void runGraphviz(String ... args) throws IOException {
        String source = this.getDiagramText();
        if (source == null || source.isEmpty()) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>(args.length + 1);
        command.add(this.getGraphvizPath());
        command.addAll(Arrays.asList(args));
        Process process = new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.PIPE).start();
        OutputStreamWriter writer = new OutputStreamWriter(process.getOutputStream());
        writer.append(source);
        writer.close();
    }
}

