/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.contribution.registry;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.app4mc.amalthea.model.editor.contribution.registry.RegistryServiceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelServiceRegistry<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelServiceRegistry.class);
    private ConcurrentHashMap<String, Map<String, RegistryServiceWrapper<T>>> registry = new ConcurrentHashMap();

    protected void bindService(T service, Map<String, Object> properties) {
        String modelClassName = this.getModelClassName(service, properties);
        if (modelClassName != null) {
            String id;
            Map services = this.registry.computeIfAbsent(modelClassName, key -> new ConcurrentHashMap());
            if (!services.containsKey(id = (String)properties.getOrDefault("id", service.getClass().getName()))) {
                services.put(id, new RegistryServiceWrapper<T>(id, service, (String)properties.getOrDefault("name", service.getClass().getSimpleName()), properties.getOrDefault("description", null), modelClassName));
            } else {
                LOGGER.error("A contribution service with the ID {} already exists!", (Object)id);
            }
        } else {
            LOGGER.error("Unable to extract model class name for contribution service {}", (Object)service.getClass().getName());
        }
    }

    protected void unbindService(T service, Map<String, Object> properties) {
        String className = this.getModelClassName(service, properties);
        String id = (String)properties.getOrDefault("id", service.getClass().getName());
        if (className != null) {
            Map services = this.registry.getOrDefault(className, Collections.emptyMap());
            services.remove(id);
        }
    }

    public RegistryServiceWrapper<T> getService(String modelClassName, String id) {
        return (RegistryServiceWrapper)this.registry.getOrDefault(modelClassName, Collections.emptyMap()).get(id);
    }

    public List<RegistryServiceWrapper<T>> getServices(List<?> objects) {
        return this.getCommonClasses(objects).stream().flatMap(clazz -> this.registry.getOrDefault(clazz.getName(), Collections.emptyMap()).values().stream()).collect(Collectors.toList());
    }

    public boolean hasServices(List<?> objects) {
        return this.getCommonClasses(objects).stream().anyMatch(clazz -> !this.registry.getOrDefault(clazz.getName(), Collections.emptyMap()).values().isEmpty());
    }

    private List<Class<?>> getCommonClasses(List<?> objects) {
        if (objects == null || objects.isEmpty()) {
            return Collections.emptyList();
        }
        List classes = objects.stream().filter(Objects::nonNull).map(Object::getClass).distinct().collect(Collectors.toList());
        if (classes.isEmpty()) {
            return Collections.emptyList();
        }
        List<Class<Class<?>>> commonClasses = this.getAllClasses((Class)classes.get(0));
        int i = 1;
        while (i < classes.size()) {
            commonClasses.retainAll(this.getAllClasses((Class)classes.get(i)));
            ++i;
        }
        return commonClasses;
    }

    private List<Class<?>> getAllClasses(Class<?> clazz) {
        ArrayList allClasses = new ArrayList();
        allClasses.add(clazz);
        allClasses.addAll(ClassUtils.getAllSuperclasses(clazz));
        allClasses.addAll(ClassUtils.getAllInterfaces(clazz));
        return allClasses;
    }

    private String getModelClassName(T service, Map<String, Object> properties) {
        String modelClassName = properties.getOrDefault("modelClass", null);
        if (modelClassName == null) {
            Method[] methods;
            Class<?> creationClass = service.getClass();
            Method[] methodArray = methods = creationClass.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?>[] parameterTypes;
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(PostConstruct.class) && (parameterTypes = method.getParameterTypes()).length > 0) {
                    if (Collection.class.isAssignableFrom(parameterTypes[0])) {
                        Type[] genericParameterTypes = method.getGenericParameterTypes();
                        if (!(genericParameterTypes[0] instanceof ParameterizedType)) break;
                        Type[] typeArguments = ((ParameterizedType)genericParameterTypes[0]).getActualTypeArguments();
                        modelClassName = typeArguments.length > 0 ? typeArguments[0].getTypeName() : null;
                        break;
                    }
                    modelClassName = parameterTypes[0].getName();
                    break;
                }
                ++n2;
            }
        }
        return modelClassName;
    }
}

