/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualization.hw.templates;

import java.util.HashSet;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.HwAccessElement;
import org.eclipse.app4mc.amalthea.model.HwConnection;
import org.eclipse.app4mc.amalthea.model.HwDestination;
import org.eclipse.app4mc.amalthea.model.HwModule;
import org.eclipse.app4mc.amalthea.model.HwPort;
import org.eclipse.app4mc.amalthea.model.HwStructure;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.visualization.util.svg.PlantUmlDiagram;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class HWBlockGenerator {
    public static void updateDiagram(PlantUmlDiagram diagram, List<HwStructure> structures) {
        diagram.resetDiagramData();
        State state = new State();
        HashSet<String> commands = new HashSet<String>();
        CharSequence result = HWBlockGenerator.generateStructures(structures, commands, state);
        boolean _success = state.success();
        if (_success) {
            diagram.append(result);
        } else {
            diagram.append(HWBlockGenerator.error(state.errorMessage));
        }
    }

    private static CharSequence error(String message) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@startuml");
        _builder.newLine();
        _builder.append("left to right direction");
        _builder.newLine();
        _builder.append("actor User");
        _builder.newLine();
        _builder.append("rectangle Visualization {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("usecase \"Invalid Input\" as ii");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("User ---> ii");
        _builder.newLine();
        _builder.append("note top of ii");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(message, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("end note");
        _builder.newLine();
        _builder.append("@enduml");
        _builder.newLine();
        return _builder;
    }

    private static CharSequence generateStructures(List<HwStructure> structures, HashSet<String> commands, State state) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@startuml");
        _builder.newLine();
        boolean _isEmpty = structures.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.newLine();
            _builder.append("' ===== FRAMES =====");
            _builder.newLine();
            for (HwStructure s : structures) {
                CharSequence _generateLevels = HWBlockGenerator.generateLevels(s, commands, state);
                _builder.append((Object)_generateLevels);
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("' ===== ROUTES =====");
            _builder.newLine();
            for (HwStructure s_1 : structures) {
                CharSequence _generateRoutes = HWBlockGenerator.generateRoutes(s_1, commands, state);
                _builder.append((Object)_generateRoutes);
                _builder.newLineIfNotEmpty();
            }
        } else {
            state.errorFlag = true;
            _builder.append((Object)true);
            _builder.newLineIfNotEmpty();
            state.errorMessage = " No Structure in the model. ";
            _builder.append(" No Structure in the model. ");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("skinparam component {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("backgroundColor<<ProcessingUnit>> #8CACFF");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("borderColor<<ProcessingUnit>> #000000");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("backgroundColor<<ConnectionHandler>> #FFFFA0");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("borderColor<<ConnectionHandler>> #000000");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("backgroundColor<<Memory>> #60FF82");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("borderColor<<Memory>> #000000");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("backgroundColor<<Cache>> #C8FFA6");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("borderColor<<Cache>> #000000");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ArrowFontColor #C0C0C0");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@enduml");
        _builder.newLine();
        return _builder;
    }

    private static CharSequence generateLevels(HwStructure s, HashSet<String> commands, State state) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _not = s != null && !StringExtensions.isNullOrEmpty((String)s.getName());
        if (_not) {
            boolean _not_1;
            _builder.newLine();
            _builder.append("\t");
            _builder.append("frame \"");
            String _name = s.getName();
            _builder.append(_name, "\t");
            _builder.append("\" as ");
            String _convertString = HWBlockGenerator.convertString(s.getName());
            _builder.append(_convertString, "\t");
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            boolean _isEmpty = s.getModules().isEmpty();
            boolean bl2 = _not_1 = !_isEmpty;
            if (_not_1) {
                _builder.append("\t");
                _builder.newLine();
                EList _modules = s.getModules();
                for (HwModule m : _modules) {
                    boolean _not_2;
                    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)m.getName());
                    boolean bl3 = _not_2 = !_isNullOrEmpty;
                    if (_not_2) {
                        _builder.append("\t");
                        _builder.append("\t");
                        CharSequence _addLevel = HWBlockGenerator.addLevel(m, commands);
                        _builder.append((Object)_addLevel, "\t\t");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    state.errorFlag = true;
                    _builder.append((Object)true, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    state.errorMessage = " Missing HW Module name. ";
                    _builder.append(" Missing HW Module name. ", "\t\t");
                    _builder.newLineIfNotEmpty();
                }
            }
            EList _structures = s.getStructures();
            for (HwStructure su : _structures) {
                _builder.append("\t");
                CharSequence _generateLevels = HWBlockGenerator.generateLevels(su, commands, state);
                _builder.append((Object)_generateLevels, "\t");
                _builder.newLineIfNotEmpty();
            }
        } else {
            state.errorFlag = true;
            _builder.append((Object)true);
            _builder.newLineIfNotEmpty();
            state.errorMessage = " Name of HwStructure is missing. ";
            _builder.append(" Name of HwStructure is missing. ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private static CharSequence addLevel(HwModule m, HashSet<String> commands) {
        String _xblockexpression = null;
        String name = HWBlockGenerator.convertString(m.getName());
        String _name = m.eClass().getName();
        String _plus = "[" + name + "] as " + name + " <<" + _name;
        String command = String.valueOf(_plus) + ">>";
        String _xifexpression = null;
        boolean _contains = commands.contains(command);
        if (_contains) {
            _xifexpression = "";
        } else {
            String _xblockexpression_1 = null;
            commands.add(command);
            _xifexpression = _xblockexpression_1 = command;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private static CharSequence generateRoutes(HwStructure s, HashSet<String> commands, State state) {
        boolean _not_3;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _not = s != null && !s.getConnections().isEmpty();
        if (_not) {
            _builder.newLine();
            _builder.append("' add physical connections of structure ");
            String _name = s.getName();
            _builder.append(_name);
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            EList _connections = s.getConnections();
            for (HwConnection c : _connections) {
                _builder.newLine();
                _builder.append("\t");
                HwPort _port1 = c.getPort1();
                EObject _eContainer = null;
                if (_port1 != null) {
                    _eContainer = _port1.eContainer();
                }
                HwPort _port2 = c.getPort2();
                EObject _eContainer_1 = null;
                if (_port2 != null) {
                    _eContainer_1 = _port2.eContainer();
                }
                CharSequence _addRoute = HWBlockGenerator.addRoute((INamed)_eContainer, (INamed)_eContainer_1, (INamed)c, " -- ", commands);
                _builder.append((Object)_addRoute, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl2 = _not_1 = s != null && !s.getModules().isEmpty();
        if (_not_1) {
            EList _modules = s.getModules();
            for (HwModule m : _modules) {
                boolean _not_2;
                if (!(m instanceof ProcessingUnit)) continue;
                ProcessingUnit pUnit = (ProcessingUnit)m;
                _builder.newLineIfNotEmpty();
                boolean _isEmpty = pUnit.getAccessElements().isEmpty();
                boolean bl3 = _not_2 = !_isEmpty;
                if (!_not_2) continue;
                _builder.newLine();
                _builder.append("' add logical connections of processing unit ");
                String _name_1 = pUnit.getName();
                _builder.append(_name_1);
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                EList _accessElements = pUnit.getAccessElements();
                for (HwAccessElement ae : _accessElements) {
                    boolean _tripleNotEquals;
                    HwDestination _destination = ae.getDestination();
                    boolean bl4 = _tripleNotEquals = _destination != null;
                    if (_tripleNotEquals) {
                        _builder.newLine();
                        _builder.append("\t");
                        CharSequence _addRoute_1 = HWBlockGenerator.addRoute((INamed)pUnit, (INamed)ae.getDestination(), (INamed)ae, " ..>", commands);
                        _builder.append((Object)_addRoute_1, "\t");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    state.errorFlag = true;
                    _builder.append((Object)true);
                    _builder.newLineIfNotEmpty();
                    state.errorMessage = " Missing Destination of AccessElement. ";
                    _builder.append(" Missing Destination of AccessElement. ");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        boolean bl5 = _not_3 = s != null && !s.getStructures().isEmpty();
        if (_not_3) {
            EList _structures = s.getStructures();
            for (HwStructure su : _structures) {
                CharSequence _generateRoutes = HWBlockGenerator.generateRoutes(su, commands, state);
                _builder.append((Object)_generateRoutes);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private static CharSequence addRoute(INamed source, INamed destination, INamed con, String conType, HashSet<String> commands) {
        String _xblockexpression = null;
        String name1 = HWBlockGenerator.convertString(HWBlockGenerator.name(source));
        String name2 = HWBlockGenerator.convertString(HWBlockGenerator.name(destination));
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)con.getName());
        _xifexpression = _isNullOrEmpty ? con.toString() : con.getName();
        String conLabel = _xifexpression;
        String command = String.valueOf(name1) + conType + name2 + " : " + conLabel;
        String _xifexpression_1 = null;
        boolean _contains = commands.contains(command);
        if (_contains) {
            _xifexpression_1 = "";
        } else {
            String _xblockexpression_1 = null;
            commands.add(command);
            _xifexpression_1 = _xblockexpression_1 = command;
        }
        _xblockexpression = _xifexpression_1;
        return _xblockexpression;
    }

    private static String name(INamed obj) {
        if (obj == null) {
            return "<undefined>";
        }
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)obj.getName());
        if (_isNullOrEmpty) {
            return "?";
        }
        return obj.getName();
    }

    private static String convertString(String str) {
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)str);
        _xifexpression = _isNullOrEmpty ? "<no name>" : HWBlockGenerator.convertGenericString(str, "_");
        return _xifexpression;
    }

    private static String convertGenericString(String instring, String replacestring) {
        String tmpstr0 = instring.replaceAll("/", replacestring);
        String tmpstr1 = tmpstr0.replaceAll(" ", replacestring);
        String tmpstr2 = tmpstr1.replaceAll("\\(", replacestring);
        String tmpstr3 = tmpstr2.replaceAll("\\)", replacestring);
        String tmpstr4 = tmpstr3.replaceAll("-", replacestring);
        String tmpstr5 = tmpstr4.replaceAll("\\+", replacestring);
        String tmpstr6 = tmpstr5.replaceAll("%2f", replacestring);
        String tmpstr7 = tmpstr6.replaceAll("\\(", replacestring);
        String tmpstr8 = tmpstr7.replaceAll("\\)", replacestring);
        String tmpstr9 = tmpstr8.replaceAll("%2b", "plus");
        String tmpstr10 = tmpstr9.replaceAll("%3a%3a", replacestring);
        String tmpstr11 = tmpstr10.replaceAll("\\.", replacestring);
        String tmpstr12 = tmpstr11.replaceAll("#", replacestring);
        String tmpstr13 = tmpstr12.replaceAll("\"", replacestring);
        String tmpstr14 = tmpstr13.replaceAll("$", replacestring);
        String tmpstr15 = tmpstr14.replaceAll("~", replacestring);
        String tmpstr16 = tmpstr15.replaceAll("%", replacestring);
        String tmpstr17 = tmpstr16.replaceAll("&", replacestring);
        return tmpstr17;
    }

    private static class State {
        private boolean errorFlag;
        private String errorMessage;

        private State() {
        }

        public boolean State() {
            this.errorFlag = false;
            return false;
        }

        public boolean getErrorFlag() {
            return this.errorFlag;
        }

        public boolean setErrorFlag(boolean flag) {
            this.errorFlag = flag;
            return this.errorFlag;
        }

        public boolean error() {
            return this.errorFlag;
        }

        public boolean success() {
            return !this.errorFlag;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String message) {
            this.errorMessage = message;
        }
    }
}

