/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualization.runnabledependency;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.visualization.runnabledependency.GraphvizGenerator;
import org.eclipse.app4mc.amalthea.visualization.runnabledependency.GraphvizGeneratorConfig;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=Runnable Data Dependencies", "description=Runnable Label Access Visualization for Software Models"})
public class RunnableDependencyVisualization
implements Visualization {
    private static GraphvizGeneratorConfig config = new GraphvizGeneratorConfig();
    private GraphvizGenerator graphvizGenerator;
    private String dotPath;
    private SWModel model;
    private int svgWidth;
    private int svgHeight;
    private CLabel scaleLabel;
    private Browser browser;

    @PostConstruct
    public void createVisualization(SWModel model, Composite parent, @Preference(nodePath="net.sourceforge.plantuml.eclipse", value="graphvizPath") String dotPath, IEventBroker broker) {
        this.graphvizGenerator = new GraphvizGenerator(config, true, true);
        this.model = model;
        this.setDotPath(dotPath);
        Composite pane = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(pane);
        Composite buttonArea = new Composite(pane, 0);
        this.browser = new Browser(pane, 0);
        if (broker != null) {
            this.setupElementNavigation(broker);
        }
        this.addToggleButton(buttonArea, "Horizontal Layout", config::setHorizontalLayout, config.isHorizontalLayout());
        this.addToggleButton(buttonArea, "Show Labels", config::setShowLabels, config.isShowLabels());
        this.addToggleButton(buttonArea, "Show R/W dependencies", config::setShowLabelDependencies, config.isShowLabelDependencies());
        this.addToggleButton(buttonArea, "Show Control Flow", config::setShowCallDependencies, config.isShowCallDependencies());
        this.addToggleButton(buttonArea, "Show Tasks", config::setShowTasks, config.isShowTasks());
        this.addPushButton(buttonArea, "Export", () -> {
            FileDialog fd = new FileDialog(parent.getShell(), 8192);
            fd.setFilterNames(new String[]{"Scalable Vector Graphics (*.svg)", "Portable Document Format (*.pdf)", "Portable Network Graphics (*.png)", "all files (*.*)"});
            fd.setFilterExtensions(new String[]{"*.svg", "*.pdf", "*.png", "*.*"});
            String path = fd.open();
            if (path != null) {
                this.export(path);
            }
        });
        this.addZoomBox(buttonArea);
        RowLayoutFactory.swtDefaults().fill(true).applyTo(buttonArea);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.browser);
        this.visualize();
    }

    private void setDotPath(String dotPathFromPreferences) {
        if (dotPathFromPreferences != null && !dotPathFromPreferences.isEmpty()) {
            this.dotPath = dotPathFromPreferences;
            return;
        }
        String dotPath2 = System.getenv("GRAPHVIZ_DOT");
        if (dotPath2 != null && !dotPath2.isEmpty()) {
            this.dotPath = dotPath2;
            return;
        }
        this.dotPath = Platform.getOS().equals("win32") ? "dot.exe" : "dot";
    }

    private void setupElementNavigation(IEventBroker broker) {
        this.browser.addLocationListener(LocationListener.changingAdapter(c -> {
            c.doit = true;
            Object target = null;
            int idx = c.location.indexOf(35);
            if (idx >= 0) {
                target = this.graphvizGenerator.getObjectById(c.location.substring(idx + 1));
            }
            if (target != null) {
                HashMap<String, List<Object>> data = new HashMap<String, List<Object>>();
                data.put("modelElements", Collections.singletonList(target));
                broker.send("org/eclipse/app4mc/amalthea/editor/SELECT", data);
            }
        }));
    }

    private void addToggleButton(Composite parent, String text, Consumer<Boolean> f, boolean initialSelected) {
        Button btn = new Button(parent, 0x800002);
        btn.setText(text);
        btn.setSelection(initialSelected);
        btn.addListener(13, e -> {
            f.accept(btn.getSelection());
            this.visualize();
        });
    }

    private void addPushButton(Composite parent, String text, Runnable cmd) {
        Button btn = new Button(parent, 0x800008);
        btn.setText(text);
        btn.addListener(13, e -> cmd.run());
    }

    private void addZoomBox(Composite buttonArea) {
        Composite zoomArea = new Composite(buttonArea, 0);
        RowLayoutFactory.fillDefaults().margins(1, 1).applyTo(zoomArea);
        Composite box = new Composite(zoomArea, 2048);
        Button btnLeft = new Button(box, 0x804004);
        this.scaleLabel = new CLabel(box, 0x1800000);
        this.scaleLabel.setText(" ___ % ");
        Button btnRight = new Button(box, 8519684);
        RowLayoutFactory.fillDefaults().fill(true).applyTo(box);
        btnLeft.addListener(13, e -> {
            boolean changed = config.decrementScale();
            if (changed) {
                this.updateSvgScale(config.getScale());
            }
        });
        btnRight.addListener(13, e -> {
            boolean changed = config.incrementScale();
            if (changed) {
                this.updateSvgScale(config.getScale());
            }
        });
    }

    private void visualize() {
        new Thread(() -> {
            String result;
            String dot = this.graphvizGenerator.createDot(this.model);
            try {
                result = this.runGraphviz(dot, "-Tsvg");
            }
            catch (IOException e) {
                result = this.prepareErrorMessage(e);
                Platform.getLog(RunnableDependencyVisualization.class).error(result, (Throwable)e);
            }
            if (result != null && !this.browser.isDisposed()) {
                String browserContent = this.cacheOriginalSvgSizeAndUpdate(result, config.getScale());
                this.browser.getDisplay().asyncExec(() -> {
                    if (!this.browser.isDisposed()) {
                        this.scaleLabel.setText(String.format("%d %%", config.getScale()));
                        this.browser.setText(browserContent);
                    }
                });
            }
        }).start();
    }

    private String prepareErrorMessage(IOException e) {
        return "Error invoking Graphviz: \"" + e.getMessage() + "\". Make sure you have configured the path to the dot executable properly in the PlantUML preferences.";
    }

    private void export(String path) {
        Display display = Display.getCurrent();
        Shell shell = display != null ? display.getActiveShell() : null;
        new Thread(() -> {
            block12: {
                String ext = path.substring(path.lastIndexOf(46) + 1);
                String dot = new GraphvizGenerator(config, !"dot".equals(ext), false).createDot(this.model);
                try {
                    if ("dot".equals(ext)) {
                        Throwable throwable = null;
                        Object var6_8 = null;
                        try (PrintWriter writer = new PrintWriter(path);){
                            writer.append(dot);
                            break block12;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    this.runGraphviz(dot, "-T" + ext, "-o", path);
                }
                catch (IOException e) {
                    String msg = this.prepareErrorMessage(e);
                    Platform.getLog(RunnableDependencyVisualization.class).error(msg, (Throwable)e);
                    MessageDialog.openError((Shell)shell, (String)"Error during export", (String)msg);
                }
            }
        }).start();
    }

    private String runGraphviz(String dot, String ... args) throws IOException {
        int len;
        ArrayList<String> command = new ArrayList<String>(args.length + 1);
        command.add(this.dotPath);
        command.addAll(Arrays.asList(args));
        Process process = new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.PIPE).start();
        OutputStreamWriter writer = new OutputStreamWriter(process.getOutputStream());
        InputStreamReader reader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
        writer.append(dot);
        writer.close();
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        while ((len = reader.read(buf)) >= 0) {
            sb.append(buf, 0, len);
        }
        return sb.toString();
    }

    private String cacheOriginalSvgSizeAndUpdate(String svg, int scale) {
        Pattern pattern = Pattern.compile("<svg width=\"(\\d+)pt\" height=\"(\\d+)pt\"");
        Matcher matcher = pattern.matcher(svg);
        if (matcher.find()) {
            this.svgWidth = Integer.valueOf(matcher.group(1));
            this.svgHeight = Integer.valueOf(matcher.group(2));
            if (scale != 100) {
                int newWidth = this.svgWidth * scale / 100;
                int newHeight = this.svgHeight * scale / 100;
                String newSvgSize = "<svg width=\"" + newWidth + "pt\" height=\"" + newHeight + "pt\"";
                return matcher.replaceFirst(newSvgSize);
            }
        }
        return svg;
    }

    private void updateSvgScale(int newScale) {
        if (this.scaleLabel != null) {
            this.scaleLabel.setText(String.format("%d %%", newScale));
        }
        if (this.browser != null) {
            String setNewSvgSize = String.format("svg = document.getElementsByTagName('svg')[0]; svg.width.baseVal.valueAsString = '%dpt'; svg.height.baseVal.valueAsString = '%dpt';", this.svgWidth * newScale / 100, this.svgHeight * newScale / 100);
            this.browser.execute(setNewSvgSize);
        }
    }
}

