/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl.javasupport;

import com.google.inject.Inject;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.builder.impl.ToBeBuiltComputer;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.common.types.ui.notification.TypeResourceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.ChangedResourceDescriptionDelta;
import org.eclipse.xtext.ui.resource.JarEntryLocator;
import org.eclipse.xtext.ui.resource.PackageFragmentRootWalker;

public class JdtToBeBuiltComputer
extends ToBeBuiltComputer {
    private static final Logger log = Logger.getLogger(JdtToBeBuiltComputer.class);
    @Inject
    private TypeURIHelper typeURIHelper;
    @Inject
    private QueuedBuildData queuedBuildData;

    public ToBeBuilt updateProject(IProject project, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        final ToBeBuilt toBeBuilt = super.updateProject(project, (IProgressMonitor)progress.newChild(1));
        if (!project.isAccessible() || progress.isCanceled()) {
            return toBeBuilt;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject.exists()) {
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            progress.setWorkRemaining(roots.length);
            final JarEntryLocator locator = new JarEntryLocator();
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    final IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (progress.isCanceled()) {
                        return toBeBuilt;
                    }
                    if (this.shouldHandle(root)) {
                        try {
                            new PackageFragmentRootWalker<Void>(){

                                protected Void handle(IJarEntryResource jarEntry, PackageFragmentRootWalker.TraversalState state) {
                                    URI uri = locator.getURI(root, jarEntry, state);
                                    if (JdtToBeBuiltComputer.this.isValid(uri, (IStorage)jarEntry)) {
                                        toBeBuilt.getToBeDeleted().add(uri);
                                        toBeBuilt.getToBeUpdated().add(uri);
                                    }
                                    return null;
                                }
                            }.traverse(root, false);
                        }
                        catch (JavaModelException ex) {
                            if (ex.isDoesNotExist()) break block7;
                            log.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
                progress.worked(1);
                ++n2;
            }
        }
        return toBeBuilt;
    }

    private boolean shouldHandle(IPackageFragmentRoot root) {
        try {
            return !"org.eclipse.jdt.launching.JRE_CONTAINER".equals(root.getRawClasspathEntry().getPath().toString()) && (root.isArchive() || root.isExternal());
        }
        catch (JavaModelException ex) {
            if (!ex.isDoesNotExist()) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            return false;
        }
    }

    public boolean removeStorage(IProgressMonitor monitor, ToBeBuilt toBeBuilt, IStorage storage) {
        if (!this.isHandled(storage)) {
            return true;
        }
        URI uri = this.getUri(storage);
        if (uri != null) {
            toBeBuilt.getToBeDeleted().add(uri);
        } else if (storage instanceof IFile && JavaCore.isJavaLikeFileName((String)storage.getFullPath().lastSegment())) {
            IJavaElement element = JavaCore.create((IResource)((IFile)storage).getParent());
            String fileName = storage.getFullPath().lastSegment();
            String typeName = fileName.substring(0, fileName.lastIndexOf(46));
            if (element instanceof IPackageFragmentRoot) {
                this.queueJavaChange(typeName);
            } else {
                IPackageFragment packageFragment = (IPackageFragment)element;
                this.queueJavaChange(String.valueOf(packageFragment.getElementName()) + "." + typeName);
            }
        }
        return true;
    }

    protected void queueJavaChange(String typeName) {
        URI typeURI = this.typeURIHelper.createResourceURIForFQN(typeName);
        TypeResourceDescription oldDescription = new TypeResourceDescription(typeURI, Collections.emptyList());
        ChangedResourceDescriptionDelta delta = new ChangedResourceDescriptionDelta((IResourceDescription)oldDescription, null);
        this.queuedBuildData.queueChanges(Collections.singleton(delta));
    }

    protected boolean isHandled(IStorage resource) {
        return resource instanceof IJarEntryResource || super.isHandled(resource);
    }
}

