/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.InspectPopupDialog;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextManager;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaExceptionBreakpoint;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class ExceptionInspector
implements IDebugContextListener,
Preferences.IPropertyChangeListener {
    static /* synthetic */ Class class$0;

    public ExceptionInspector() {
        Preferences pluginPreferences = JDIDebugUIPlugin.getDefault().getPluginPreferences();
        pluginPreferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        if (pluginPreferences.getBoolean(IJDIPreferencesConstants.PREF_OPEN_INSPECT_POPUP_ON_EXCEPTION)) {
            DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
        }
    }

    public void debugContextChanged(DebugContextEvent event) {
        Object firstElement;
        IStructuredSelection ss;
        ISelection selection;
        IWorkbenchPage page;
        IWorkbenchPartSite site;
        IWorkbenchPart part;
        if ((event.getFlags() & 1) > 0 && (part = event.getDebugContextProvider().getPart()) != null && (site = part.getSite()) != null && "org.eclipse.debug.ui.DebugView".equals(site.getId()) && (page = site.getWorkbenchWindow().getActivePage()) != null && page.isPartVisible(part) && (selection = event.getContext()) instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (firstElement = ss.getFirstElement()) instanceof IAdaptable) {
            IJavaStackFrame frame;
            IAdaptable iAdaptable = (IAdaptable)firstElement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((frame = (IJavaStackFrame)iAdaptable.getAdapter((Class)clazz)) != null) {
                IJavaThread thread = (IJavaThread)frame.getThread();
                try {
                    IJavaExceptionBreakpoint exception;
                    IJavaObject lastException;
                    IBreakpoint[] breakpoints;
                    if (frame.equals(thread.getTopStackFrame()) && (breakpoints = thread.getBreakpoints()).length == 1 && breakpoints[0] instanceof IJavaExceptionBreakpoint && (lastException = ((JavaExceptionBreakpoint)(exception = (IJavaExceptionBreakpoint)breakpoints[0])).getLastException()) != null) {
                        JavaInspectExpression exp = new JavaInspectExpression(exception.getExceptionTypeName(), (IJavaValue)lastException);
                        Tree tree = (Tree)((IDebugView)part).getViewer().getControl();
                        TreeItem[] selection2 = tree.getSelection();
                        Rectangle bounds = selection2[0].getBounds();
                        Point point = tree.toDisplay(bounds.x, bounds.y + bounds.height);
                        InspectPopupDialog dialog = new InspectPopupDialog(part.getSite().getShell(), point, "org.eclipse.jdt.debug.ui.commands.Inspect", (IExpression)exp);
                        dialog.open();
                    }
                }
                catch (DebugException debugException) {}
            }
        }
    }

    public void contextChanged(ISelection selection, IWorkbenchPart part) {
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (IJDIPreferencesConstants.PREF_OPEN_INSPECT_POPUP_ON_EXCEPTION.equals(event.getProperty())) {
            IDebugContextManager manager = DebugUITools.getDebugContextManager();
            if (JDIDebugUIPlugin.getDefault().getPluginPreferences().getBoolean(IJDIPreferencesConstants.PREF_OPEN_INSPECT_POPUP_ON_EXCEPTION)) {
                manager.addDebugContextListener((IDebugContextListener)this);
            } else {
                manager.removeDebugContextListener((IDebugContextListener)this);
            }
        }
    }
}

