/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.acore.edit.commands.test;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.amp.amf.acore.edit.commands.test.CommandTransformer;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.metaabm.SContext;
import org.metaabm.act.provider.MetaABMActItemProviderAdapterFactory;
import org.metaabm.function.FFunction;
import org.metaabm.function.FLibrary;
import org.metaabm.function.provider.MetaABMFunctionItemProviderAdapterFactory;
import org.metaabm.provider.MetaABMItemProviderAdapterFactory;
import org.metaabm.tests.BasePersistTest;
import org.metaabm.tests.Transformer;
import org.metaabm.xsd.MetaABMPersist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandTest
extends BasePersistTest {
    private EditingDomain domain;
    private AdapterFactory adapterFactory;
    public boolean trace = false;
    public boolean execOnly = false;
    boolean undo;
    protected static SContext lib;
    protected static FLibrary library;
    protected static FLibrary funcLog;
    protected static FLibrary funcNum;
    protected static FFunction funcAdd;
    protected static FFunction funcEq;
    protected static FFunction funcNot;

    public CommandTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        BasicCommandStack commandStack;
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new MetaABMFunctionItemProviderAdapterFactory());
        factories.add(new MetaABMItemProviderAdapterFactory());
        factories.add(new MetaABMActItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        if (this.trace) {
            commandStack = new BasicCommandStack(){
                int level = 0;

                public void execute(Command command) {
                    System.out.println(String.valueOf(StringUtils.repeat((String)"    ", (int)this.level)) + "Executing: " + command);
                    ++this.level;
                    super.execute(command);
                    --this.level;
                    System.out.println(String.valueOf(StringUtils.repeat((String)"    ", (int)this.level)) + "Executed : " + command);
                }
            };
            commandStack.addCommandStackListener(new CommandStackListener(){

                public void commandStackChanged(EventObject event) {
                    System.out.println("                                   Cmd Event: " + event);
                }
            });
        } else {
            commandStack = new BasicCommandStack();
        }
        this.domain = new AdapterFactoryEditingDomain(this.adapterFactory, (CommandStack)commandStack, new HashMap());
        MetaABMPersist libPersist = MetaABMPersist.createURI((URI)URI.createURI((String)"http://metaabm.org/core_library.metaabm"));
        lib = libPersist.load();
        library = (FLibrary)lib.getLibrary().get(0);
        funcLog = library.findSub("operators").findSub("logicalOperators");
        funcNum = library.findSub("operators").findSub("numericOperators");
        funcAdd = funcNum.findFunction("add");
        funcEq = funcLog.findFunction("equal");
        funcNot = funcLog.findFunction("not");
        super.setUp();
    }

    protected void execTransform(Transformer transformer) {
        Command command = ((CommandTransformer)transformer).getCommand();
        if (command instanceof CompoundCommand) {
            for (Command subCmd : ((CompoundCommand)command).getCommandList()) {
                CommandTest.assertTrue((String)("Couldn't execute: " + subCmd.getLabel()), (boolean)subCmd.canExecute());
            }
        }
        CommandTest.assertTrue((boolean)command.canExecute());
        super.execTransform(transformer);
    }

    public void executeTests(List<CommandTransformer> commandList) {
        int commandIndex = 0;
        for (CommandTransformer transformer : commandList) {
            transformer.setDomain(this.getDomain());
            transformer.setTestCase(this);
            this.execTransform(transformer, commandIndex);
            if (!this.execOnly) {
                this.undo = true;
                this.undoTransform(transformer, commandIndex);
                this.undo = false;
                this.redoTransform(transformer, commandIndex);
            }
            this.domain.getCommandStack().flush();
            ++commandIndex;
        }
    }

    public boolean isUndo() {
        return this.undo;
    }

    public EditingDomain getDomain() {
        return this.domain;
    }

    public void setDomain(EditingDomain domain) {
        this.domain = domain;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    protected void tearDown() throws Exception {
    }

    public static void assertEqualNull(String str0, String str1) {
        if (StringUtils.isEmpty((String)str0) && StringUtils.isEmpty((String)str1)) {
            return;
        }
        CommandTest.assertEquals((String)str0, (String)str1);
    }
}

