/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.replaydebugging.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.debug.replaydebugging.ReplayNavigator;
import org.eclipse.fordiac.ide.debug.replaydebugging.ui.CollapsableComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;

public class TimelineWidget
extends Composite {
    private Canvas lineCanvas;
    private Slider timelineSlider;
    private Button previousButton;
    private Button jumpBackButton;
    private Button jumpForwardButton;
    private Button nextButton;
    private static final String PREVIOUS_BUTTON_TEXT = "<";
    private static final String JUMP_BACK_BUTTON_TEXT = "|<";
    private static final String JUMP_FORWARD_BUTTON_TEXT = ">|";
    private static final String NEXT_BUTTON_TEXT = ">";
    private Label positionLabel;
    private static final int SLIDER_THUMB_SIZE = 1;
    private boolean mouseDownOnCanvas = false;
    private List<Integer> highlightPositions = new ArrayList<Integer>();
    private final ReplayNavigator replayNavigator;

    public TimelineWidget(String name, ReplayNavigator replayNavigator, Composite parent, int style, CollapsableComposite.CollapseListener collapsableListener) {
        super(parent, style);
        this.replayNavigator = replayNavigator;
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 128, true, false));
        this.createControlGroup(name, collapsableListener);
        this.updateCurrentPositionInfo();
    }

    public boolean setFocus() {
        return this.lineCanvas.setFocus();
    }

    public void setHighlightPositions(String datapointOfInterest) {
        this.highlightPositions = this.replayNavigator.getEventsThatTouch(datapointOfInterest);
        this.lineCanvas.redraw();
    }

    private void setEventToCanvasX(int x) {
        this.replayNavigator.moveToEvent(this.getEventFromCanvasX(x));
        this.timelineSlider.setSelection(this.replayNavigator.getCurrentEventNumber());
        this.updateCurrentPositionInfo();
    }

    private int getEventFromCanvasX(int x) {
        int maxEvent = this.timelineSlider.getMaximum() - this.timelineSlider.getThumb();
        if (maxEvent <= 0) {
            return 0;
        }
        int width = this.lineCanvas.getSize().x;
        double singleEventStepInPixels = (double)width / (double)maxEvent;
        return (int)Math.round((double)x / singleEventStepInPixels);
    }

    private CollapsableComposite createControlGroup(String name, CollapsableComposite.CollapseListener collapsableListener) {
        CollapsableComposite controlGroup = new CollapsableComposite(this, name, collapsed -> {
            this.layout(true, true);
            collapsableListener.onCollapse(collapsed);
        });
        Composite contentsParent = controlGroup.getContentsParent();
        this.lineCanvas = new Canvas(contentsParent, 0);
        this.lineCanvas.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.lineCanvas.addPaintListener((PaintListener)new TimesliderPainter());
        this.lineCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TimelineWidget.this.mouseDownOnCanvas = true;
                TimelineWidget.this.setEventToCanvasX(e.x);
            }

            public void mouseUp(MouseEvent e) {
                TimelineWidget.this.mouseDownOnCanvas = false;
                TimelineWidget.this.setEventToCanvasX(e.x);
            }
        });
        this.lineCanvas.addMouseMoveListener(e -> {
            if (this.mouseDownOnCanvas) {
                this.setEventToCanvasX(e.x);
            }
        });
        this.lineCanvas.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) != 0) {
                    if (e.keyCode == 0x1000004 && TimelineWidget.this.jumpForwardButton.isEnabled()) {
                        TimelineWidget.this.jumpForwardButton.notifyListeners(13, new Event());
                    } else if (e.keyCode == 0x1000003 && TimelineWidget.this.jumpBackButton.isEnabled()) {
                        TimelineWidget.this.jumpBackButton.notifyListeners(13, new Event());
                    }
                } else if (e.keyCode == 0x1000004 && TimelineWidget.this.nextButton.isEnabled()) {
                    TimelineWidget.this.nextButton.notifyListeners(13, new Event());
                } else if (e.keyCode == 0x1000003 && TimelineWidget.this.previousButton.isEnabled()) {
                    TimelineWidget.this.previousButton.notifyListeners(13, new Event());
                }
            }
        });
        this.timelineSlider = new Slider(contentsParent, 256);
        this.timelineSlider.setThumb(1);
        this.timelineSlider.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.timelineSlider.setMinimum(0);
        this.timelineSlider.setMaximum(this.replayNavigator.getAmountOfEvents() + this.timelineSlider.getThumb());
        this.timelineSlider.setEnabled(true);
        this.timelineSlider.setSelection(this.replayNavigator.getCurrentEventNumber());
        this.timelineSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimelineWidget.this.setFocus();
                TimelineWidget.this.replayNavigator.moveToEvent(TimelineWidget.this.timelineSlider.getSelection());
                TimelineWidget.this.updateCurrentPositionInfo();
            }
        });
        this.positionLabel = new Label(contentsParent, 0);
        GridData positionLayoutData = new GridData(0x1000000, 0x1000000, true, false);
        int maxHintLength = String.valueOf(this.timelineSlider.getMaximum() - this.timelineSlider.getThumb()).length() * 2 + 3;
        positionLayoutData.widthHint = maxHintLength * 12;
        this.positionLabel.setLayoutData((Object)positionLayoutData);
        this.positionLabel.setAlignment(0x1000000);
        Composite buttonComposite = new Composite(contentsParent, 0);
        buttonComposite.setLayout((Layout)new GridLayout(4, false));
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.jumpBackButton = this.createNavButton(buttonComposite, JUMP_BACK_BUTTON_TEXT, () -> this.replayNavigator.moveToEvent(this.getBackwardsJump()));
        this.previousButton = this.createNavButton(buttonComposite, PREVIOUS_BUTTON_TEXT, () -> ((ReplayNavigator)this.replayNavigator).moveOneEventBackwards());
        this.nextButton = this.createNavButton(buttonComposite, NEXT_BUTTON_TEXT, () -> ((ReplayNavigator)this.replayNavigator).moveOneEventForward());
        this.jumpForwardButton = this.createNavButton(buttonComposite, JUMP_FORWARD_BUTTON_TEXT, () -> this.replayNavigator.moveToEvent(this.getForwardJump()));
        Composite highlightComposite = new Composite(contentsParent, 0);
        highlightComposite.setLayout((Layout)new GridLayout(2, false));
        highlightComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        return controlGroup;
    }

    private Button createNavButton(Composite parent, String text, final SliderMover action) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimelineWidget.this.setFocus();
                action.moveSlider();
                TimelineWidget.this.timelineSlider.setSelection(TimelineWidget.this.replayNavigator.getCurrentEventNumber());
                TimelineWidget.this.updateCurrentPositionInfo();
            }
        });
        return button;
    }

    private int getForwardJump() {
        if (this.highlightPositions.isEmpty()) {
            return this.timelineSlider.getMaximum() - this.timelineSlider.getThumb();
        }
        int current = this.timelineSlider.getSelection();
        int left = 0;
        int right = this.highlightPositions.size() - 1;
        int result = -1;
        while (left <= right) {
            int mid = left + (right - left) / 2;
            int value = this.highlightPositions.get(mid);
            if (value > current) {
                result = value;
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        if (result != -1) {
            return result;
        }
        return this.timelineSlider.getMaximum() - this.timelineSlider.getThumb();
    }

    private int getBackwardsJump() {
        if (this.highlightPositions.isEmpty()) {
            return 0;
        }
        int current = this.timelineSlider.getSelection();
        int left = 0;
        int right = this.highlightPositions.size() - 1;
        int result = -1;
        while (left <= right) {
            int mid = left + (right - left) / 2;
            int value = this.highlightPositions.get(mid);
            if (value < current) {
                result = value;
                left = mid + 1;
                continue;
            }
            right = mid - 1;
        }
        if (result != -1) {
            return result;
        }
        return 0;
    }

    private void updateCurrentPositionInfo() {
        int current = this.timelineSlider.getSelection();
        int total = this.timelineSlider.getMaximum() - this.timelineSlider.getThumb();
        this.positionLabel.setText(current + " / " + total);
        this.lineCanvas.redraw();
        if (current == total) {
            this.nextButton.setEnabled(false);
            this.jumpForwardButton.setEnabled(false);
            this.jumpBackButton.setEnabled(true);
            this.previousButton.setEnabled(true);
        } else if (current == 0) {
            this.nextButton.setEnabled(true);
            this.jumpForwardButton.setEnabled(true);
            this.jumpBackButton.setEnabled(false);
            this.previousButton.setEnabled(false);
        } else {
            this.jumpBackButton.setEnabled(true);
            this.previousButton.setEnabled(true);
            this.nextButton.setEnabled(true);
            this.jumpForwardButton.setEnabled(true);
        }
    }

    private static interface SliderMover {
        public void moveSlider();
    }

    private class TimesliderPainter
    implements PaintListener {
        private static final int NUMBER_OF_SECTIONS_IN_CANVAS = 10;
        private static final int TEXT_Y_OFFSET_IN_CANVAS = 15;
        private static final int TEXT_X_OFFSET_IN_CANVAS = 2;
        private static final int TEXT_X_OFFSET_IN_CANVAS_LAST = -10;
        private static final int DIVITIONS_COLOR = 2;
        private static final int HIGHTLIGHT_COLOR = 3;
        private static final int CURRENT_POSITION_COLOR = 9;

        private TimesliderPainter() {
        }

        public void paintControl(PaintEvent paintEvent) {
            String label;
            int x;
            int maxEvent = TimelineWidget.this.timelineSlider.getMaximum() - TimelineWidget.this.timelineSlider.getThumb();
            if (maxEvent <= 0) {
                return;
            }
            int width = TimelineWidget.this.lineCanvas.getSize().x;
            int height = TimelineWidget.this.lineCanvas.getSize().y;
            int singleEventStepInPixels = width / maxEvent;
            int divisions = Math.min(maxEvent, 10);
            if (maxEvent / divisions * divisions != maxEvent) {
                divisions = maxEvent / (int)Math.ceil((double)maxEvent / (double)divisions);
            }
            int eventDivisionStep = maxEvent / divisions;
            divisions = maxEvent / eventDivisionStep;
            paintEvent.gc.setForeground(TimelineWidget.this.getDisplay().getSystemColor(2));
            int i = 0;
            while (i < divisions) {
                int eventPosition = i * eventDivisionStep;
                x = eventPosition * singleEventStepInPixels;
                paintEvent.gc.drawLine(x, 0, x, height);
                label = String.valueOf(eventPosition);
                paintEvent.gc.drawString(label, x + 2, height - 15, true);
                ++i;
            }
            paintEvent.gc.drawLine(width - 1, 0, width - 1, height);
            paintEvent.gc.drawString(String.valueOf(divisions * eventDivisionStep), width - 1 + -10, height - 15, true);
            paintEvent.gc.setForeground(TimelineWidget.this.getDisplay().getSystemColor(3));
            for (Integer pos : TimelineWidget.this.highlightPositions) {
                if (pos < 0 || pos > maxEvent) continue;
                x = pos * singleEventStepInPixels;
                paintEvent.gc.drawLine(x, 0, x, height);
                label = String.valueOf(pos);
                paintEvent.gc.drawString(label, x + 2, 15, true);
            }
            paintEvent.gc.setForeground(TimelineWidget.this.getDisplay().getSystemColor(9));
            int current = TimelineWidget.this.timelineSlider.getSelection();
            int x2 = current * singleEventStepInPixels;
            String label2 = String.valueOf(current);
            if (current == TimelineWidget.this.timelineSlider.getMaximum() - TimelineWidget.this.timelineSlider.getThumb()) {
                paintEvent.gc.drawLine(width - 1, 0, width - 1, height);
                paintEvent.gc.drawString(label2, x2 + -10, height / 2, true);
            } else {
                paintEvent.gc.drawLine(x2, 0, x2, height);
                paintEvent.gc.drawString(label2, x2 + 2, height / 2, true);
            }
        }
    }
}

