/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.api.CommitMessageWithCaretPosition;
import org.eclipse.egit.ui.api.ICommitMessageProvider;
import org.eclipse.egit.ui.api.ICommitMessageProvider2;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jgit.lib.Repository;

class CommitMessageBuilder {
    private static final String COMMIT_MESSAGE_PROVIDER_ID = "org.eclipse.egit.ui.commitMessageProvider";
    private static final String MESSAGE_SEPARATOR = "\n\n";
    private final IResource[] resourcesArray;
    private boolean isMessageEmpty;

    CommitMessageBuilder(Repository repository, Collection<String> paths) {
        this.resourcesArray = this.toResourceArray(repository, paths);
    }

    CommitMessageWithCaretPosition build() {
        StringBuilder finalMessage = new StringBuilder();
        int caretPosition = -1;
        this.isMessageEmpty = true;
        for (ICommitMessageProvider provider : this.getCommitMessageProviders()) {
            String message = "";
            try {
                if (provider instanceof ICommitMessageProvider2) {
                    CommitMessageWithCaretPosition commitMessageWithPosition = ((ICommitMessageProvider2)provider).getCommitMessageWithPosition(this.resourcesArray);
                    if (commitMessageWithPosition != null) {
                        caretPosition = this.updateCaretPosition(finalMessage, caretPosition, commitMessageWithPosition, (ICommitMessageProvider2)provider);
                    }
                    message = this.getCommitMessage(commitMessageWithPosition);
                } else {
                    message = this.append(provider.getMessage(this.resourcesArray));
                }
            }
            catch (RuntimeException e) {
                Activator.logError(e.getMessage(), e);
            }
            finalMessage.append(message);
            boolean bl = this.isMessageEmpty = finalMessage.length() == 0;
        }
        return new CommitMessageWithCaretPosition(finalMessage.toString(), Math.max(0, caretPosition));
    }

    private String getCommitMessage(CommitMessageWithCaretPosition messageWithPosition) {
        if (messageWithPosition == null) {
            return "";
        }
        return this.append(messageWithPosition.message());
    }

    private String append(String msg) {
        StringBuilder returnMsg = new StringBuilder();
        if (msg != null && !msg.trim().isEmpty()) {
            if (!this.isMessageEmpty) {
                returnMsg.append(MESSAGE_SEPARATOR);
            }
            returnMsg.append(msg);
        }
        return returnMsg.toString();
    }

    private int updateCaretPosition(StringBuilder currentMessage, int currentCaretPosition, CommitMessageWithCaretPosition messageWithPosition, ICommitMessageProvider2 provider) {
        int pos = currentCaretPosition;
        if (currentCaretPosition == -1) {
            String providedMessage = messageWithPosition.message();
            if (providedMessage == null || providedMessage.trim().isEmpty()) {
                return pos;
            }
            int providedCaretPosition = messageWithPosition.caretPosition();
            if (providedCaretPosition == -1) {
                return pos;
            }
            if (providedCaretPosition > providedMessage.length() || providedCaretPosition < 0) {
                Activator.logWarning(MessageFormat.format(UIText.CommitDialog_CaretPositionOutOfBounds, provider.getClass().getName(), providedCaretPosition), null);
                return -1;
            }
            pos = currentMessage.length();
            if (currentMessage.length() > 0) {
                pos += MESSAGE_SEPARATOR.length();
            }
            pos += providedCaretPosition;
        } else {
            Activator.logWarning(MessageFormat.format(UIText.CommitDialog_IgnoreCaretPosition, provider.getClass().getName()), null);
        }
        return pos;
    }

    List<ICommitMessageProvider> getCommitMessageProviders() {
        IConfigurationElement[] configs;
        ArrayList<ICommitMessageProvider> providers = new ArrayList<ICommitMessageProvider>();
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(COMMIT_MESSAGE_PROVIDER_ID);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            String contributorName = "<unknown>";
            String extensionId = "<unknown>";
            try {
                extensionId = config.getDeclaringExtension().getUniqueIdentifier();
                contributorName = config.getContributor().getName();
                Object provider = config.createExecutableExtension("class");
                if (provider instanceof ICommitMessageProvider) {
                    providers.add((ICommitMessageProvider)provider);
                } else {
                    Activator.logError(MessageFormat.format(UIText.CommitDialog_WrongTypeOfCommitMessageProvider, extensionId, contributorName), null);
                }
            }
            catch (RuntimeException | CoreException e) {
                Activator.logError(MessageFormat.format(UIText.CommitDialog_ErrorCreatingCommitMessageProvider, extensionId, contributorName), e);
            }
            ++n2;
        }
        return providers;
    }

    private IResource[] toResourceArray(Repository repository, Collection<String> paths) {
        if (repository == null || repository.isBare()) {
            return new IResource[0];
        }
        HashSet<IProject> resources = new HashSet<IProject>();
        for (String path : paths) {
            IFile file = null;
            if (path != null) {
                file = ResourceUtil.getFileForLocation((Repository)repository, (String)path, (boolean)false);
            }
            if (file == null) continue;
            resources.add(file.getProject());
        }
        if (resources.isEmpty()) {
            resources.addAll(Arrays.asList(ProjectUtil.getProjects((Repository)repository)));
        }
        return resources.toArray(new IResource[0]);
    }
}

