/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.deployment.debug.Messages;
import org.eclipse.fordiac.ide.deployment.debug.breakpoint.DeploymentWatchpoint;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchUtils;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.typelibrary.SystemEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public final class DeploymentLaunchConfigurationAttributes {
    public static final String ID = "org.eclipse.fordiac.ide.deployment.debug.deployLaunch";
    public static final String SYSTEM = "org.eclipse.fordiac.ide.deployment.debug.system";
    public static final String SELECTION = "org.eclipse.fordiac.ide.deployment.debug.selection";
    public static final String POLLING_INTERVAL = "org.eclipse.fordiac.ide.deployment.debug.pollingInterval";
    public static final int POLLING_INTERVAL_DEFAULT = 300;
    public static final String ALLOW_TERMINATE = "org.eclipse.fordiac.ide.deployment.debug.allowTerminate";
    public static final String ALLOW_TERMINATE_DEFAULT = AllowTerminate.DEBUG_ONLY.name();
    public static final String WATCH_TARGET_NAME = "org.eclipse.fordiac.ide.deployment.debug.watch.targetName";
    public static final String WATCH_TARGET_TYPE = "org.eclipse.fordiac.ide.deployment.debug.watch.targetType";
    public static final String WATCH_FORCE_VALUE = "org.eclipse.fordiac.ide.deployment.debug.watch.forceValue";

    public static IResource getSystemResource(ILaunchConfiguration configuration) throws CoreException {
        String systemAttribute = configuration.getAttribute(SYSTEM, "");
        if (systemAttribute != null && !systemAttribute.isEmpty()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(systemAttribute));
        }
        return null;
    }

    public static SystemEntry getSystemEntry(ILaunchConfiguration configuration) throws CoreException {
        IResource systemResource = DeploymentLaunchConfigurationAttributes.getSystemResource(configuration);
        if (systemResource instanceof IFile) {
            TypeEntry typeEntry;
            IFile systemFile = (IFile)systemResource;
            if (systemResource.exists() && (typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(systemFile)) instanceof SystemEntry) {
                SystemEntry systemEntry = (SystemEntry)typeEntry;
                return systemEntry;
            }
        }
        return null;
    }

    public static AutomationSystem getSystem(ILaunchConfiguration configuration) throws CoreException {
        SystemEntry systemEntry = DeploymentLaunchConfigurationAttributes.getSystemEntry(configuration);
        if (systemEntry != null) {
            return systemEntry.getSystem();
        }
        return null;
    }

    public static Set<INamedElement> getSelection(ILaunchConfiguration configuration, AutomationSystem system) throws CoreException {
        Set selectionAttribute = configuration.getAttribute(SELECTION, Collections.emptySet());
        if (selectionAttribute != null && system != null) {
            return selectionAttribute.stream().map(qualifiedName -> DeploymentLaunchConfigurationAttributes.findSelectedElement(qualifiedName, system)).flatMap(Optional::stream).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static Optional<INamedElement> findSelectedElement(String qualifiedName, AutomationSystem system) {
        int separatorIndex = qualifiedName.indexOf(46);
        if (separatorIndex <= 0) {
            return Optional.ofNullable(system.getSystemConfiguration().getDeviceNamed(qualifiedName));
        }
        String deviceName = qualifiedName.substring(0, separatorIndex);
        String resourceName = qualifiedName.substring(separatorIndex + 1);
        Device device = system.getSystemConfiguration().getDeviceNamed(deviceName);
        if (device != null) {
            return Optional.ofNullable(device.getResourceNamed(resourceName));
        }
        return Optional.empty();
    }

    public static Duration getPollingInterval(ILaunchConfiguration configuration) throws CoreException {
        return Duration.ofMillis(configuration.getAttribute(POLLING_INTERVAL, 300));
    }

    public static AllowTerminate getAllowTerminate(ILaunchConfiguration configuration) throws CoreException {
        String allowTerminate = configuration.getAttribute(ALLOW_TERMINATE, ALLOW_TERMINATE_DEFAULT);
        return AllowTerminate.valueOf(allowTerminate);
    }

    public static List<DeploymentLaunchWatchpoint> getWatches(ILaunchConfiguration configuration) throws CoreException {
        List targetNames = configuration.getAttribute(WATCH_TARGET_NAME, List.of());
        List targetTypes = configuration.getAttribute(WATCH_TARGET_TYPE, List.of());
        List forceValues = configuration.getAttribute(WATCH_FORCE_VALUE, List.of());
        if (targetNames.size() != targetTypes.size() || targetNames.size() != forceValues.size()) {
            throw new CoreException(Status.error((String)"Invalid watches in launch configuration: Lists must have the same size"));
        }
        return IntStream.range(0, targetNames.size()).mapToObj(index -> new DeploymentLaunchWatchpoint((String)targetNames.get(index), (String)targetTypes.get(index), (String)forceValues.get(index))).toList();
    }

    public static void setWatches(ILaunchConfigurationWorkingCopy configuration, List<DeploymentLaunchWatchpoint> watches) {
        if (watches == null || watches.isEmpty()) {
            configuration.removeAttribute(WATCH_TARGET_NAME);
            configuration.removeAttribute(WATCH_TARGET_TYPE);
            configuration.removeAttribute(WATCH_FORCE_VALUE);
            return;
        }
        configuration.setAttribute(WATCH_TARGET_NAME, watches.stream().map(DeploymentLaunchWatchpoint::targetName).toList());
        configuration.setAttribute(WATCH_TARGET_TYPE, watches.stream().map(DeploymentLaunchWatchpoint::targetType).map(EcoreUtil::getURI).map(Object::toString).toList());
        configuration.setAttribute(WATCH_FORCE_VALUE, watches.stream().map(DeploymentLaunchWatchpoint::forceValue).toList());
    }

    private DeploymentLaunchConfigurationAttributes() {
        throw new UnsupportedOperationException();
    }

    public static enum AllowTerminate {
        NEVER(Messages.DeploymentLaunchConfigurationAttributes_AllowTerminate_Never),
        DEBUG_ONLY(Messages.DeploymentLaunchConfigurationAttributes_AllowTerminate_DebugOnly),
        ALWAYS(Messages.DeploymentLaunchConfigurationAttributes_AllowTerminate_Always);

        private final String displayString;

        private AllowTerminate(String displayString) {
            this.displayString = displayString;
        }

        public String getDisplayString() {
            return this.displayString;
        }
    }

    public record DeploymentLaunchWatchpoint(String targetName, EClass targetType, String forceValue) {
        public DeploymentLaunchWatchpoint {
            Objects.requireNonNull(targetName);
            Objects.requireNonNull(targetType);
            Objects.requireNonNull(forceValue);
        }

        public DeploymentLaunchWatchpoint(String targetName, String targetTypeUri, String forceValue) {
            this(targetName, URI.createURI((String)targetTypeUri), forceValue);
        }

        public DeploymentLaunchWatchpoint(String targetName, URI targetTypeUri, String forceValue) {
            this(targetName, DeploymentLaunchWatchpoint.getTargetType(targetTypeUri), forceValue);
        }

        public DeploymentLaunchWatchpoint(DeploymentWatchpoint watchpoint) {
            this(watchpoint.getLocation(), watchpoint.getTargetType().orElse(LibraryElementPackage.Literals.INAMED_ELEMENT), watchpoint.isForceSupported() && watchpoint.isForceEnabled() ? watchpoint.getForceValue() : "");
        }

        public Optional<INamedElement> getTarget(Device device) {
            return this.getTargets(device.getAutomationSystem()).filter(target -> device.equals(DeploymentDebugWatchUtils.getDevice(target))).findFirst();
        }

        public Optional<INamedElement> getTarget(AutomationSystem system) {
            return this.getTargets(system).findFirst();
        }

        public Stream<INamedElement> getTargets(AutomationSystem system) {
            if (this.targetName == null || this.targetName.isEmpty() || this.targetType == null) {
                return Stream.empty();
            }
            return system.findByQualifiedName(this.targetName).filter(element -> this.targetType.equals(element.eClass()));
        }

        public boolean isForceEnabled() {
            return !this.forceValue.isEmpty();
        }

        private static EClass getTargetType(URI targetTypeUri) {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(targetTypeUri.trimFragment().toString());
            if (ePackage == null) {
                throw new IllegalArgumentException("Not a valid package: " + String.valueOf(targetTypeUri));
            }
            return (EClass)ePackage.eResource().getEObject(targetTypeUri.fragment());
        }
    }
}

