/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.watch;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.deployment.devResponse.Data;
import org.eclipse.fordiac.ide.deployment.devResponse.FB;
import org.eclipse.fordiac.ide.deployment.devResponse.Port;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.deployment.devResponse.Watches;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;

public class DeploymentDebugWatchData {
    private final Map<String, Map<String, Port>> data;

    public DeploymentDebugWatchData(Response response) {
        this.data = Optional.ofNullable(response.getWatches()).map(Watches::getResources).stream().flatMap(Collection::stream).collect(Collectors.toUnmodifiableMap(org.eclipse.fordiac.ide.deployment.devResponse.Resource::getName, DeploymentDebugWatchData::collectPorts));
    }

    protected static Map<String, Port> collectPorts(org.eclipse.fordiac.ide.deployment.devResponse.Resource resource) {
        return resource.getFbs().stream().map(FB::getPorts).flatMap(Collection::stream).collect(Collectors.toUnmodifiableMap(DeploymentDebugWatchData::getPortString, Function.identity()));
    }

    protected static String getPortString(Port port) {
        EObject eObject = port.eContainer();
        if (eObject instanceof FB) {
            FB fb = (FB)eObject;
            return fb.getName() + "." + port.getName();
        }
        return port.getName();
    }

    public Port getPort(Resource resource, String portString) {
        return (Port)this.data.getOrDefault(resource.getName(), Map.of()).get(portString);
    }

    public Data getLastData(Resource resource, String portString) {
        Port port = this.getPort(resource, portString);
        if (port != null && !port.getDataValues().isEmpty()) {
            return (Data)port.getDataValues().getLast();
        }
        return null;
    }
}

