/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.p4route;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.mrtree.TreeLayoutPhases;
import org.eclipse.elk.alg.mrtree.TreeUtil;
import org.eclipse.elk.alg.mrtree.graph.TEdge;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.mrtree.options.EdgeRoutingMode;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.alg.mrtree.p4route.MultiLevelEdgeNodeNodeGap;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.core.util.Triple;

public class EdgeRouter
implements ILayoutPhase<TreeLayoutPhases, TGraph> {
    private final double oneHalf = 0.5;
    private final double steepEndEdgeTheresholdDistance = 50.0;
    private final double steepEndEdgeRatio = 5.3;
    private final double steepEndEdgeSampleHeight = 40.0;
    private static final LayoutProcessorConfiguration<TreeLayoutPhases, TGraph> INTERMEDIATE_PROCESSING_CONFIG = LayoutProcessorConfiguration.create().before((Enum)TreeLayoutPhases.P4_EDGE_ROUTING).add((ILayoutProcessorFactory)IntermediateProcessorStrategy.LEVEL_COORDS).add((ILayoutProcessorFactory)IntermediateProcessorStrategy.COMPACTION_PROC).add((ILayoutProcessorFactory)IntermediateProcessorStrategy.GRAPH_BOUNDS_PROC);

    public LayoutProcessorConfiguration<TreeLayoutPhases, TGraph> getLayoutProcessorConfiguration(TGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIG;
    }

    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Edge routing", 1.0f);
        EdgeRoutingMode mode = (EdgeRoutingMode)((Object)tGraph.getProperty(MrTreeOptions.EDGE_ROUTING_MODE));
        if (mode == EdgeRoutingMode.MIDDLE_TO_MIDDLE) {
            this.middleToMiddle(tGraph);
        } else if (mode == EdgeRoutingMode.AVOID_OVERLAP) {
            this.avoidOverlap(tGraph);
            for (TEdge e : tGraph.getEdges()) {
                if (e.getBendPoints().size() >= 2) continue;
                this.middleToMiddleEdgeRoute(e);
            }
        }
        progressMonitor.done();
    }

    private void middleToMiddle(TGraph tGraph) {
        for (TEdge tEdge : tGraph.getEdges()) {
            this.middleToMiddleEdgeRoute(tEdge);
        }
    }

    private void middleToMiddleEdgeRoute(TEdge tEdge) {
        KVectorChain bendPoints = tEdge.getBendPoints();
        TNode source = tEdge.getSource();
        TNode target = tEdge.getTarget();
        KVector sourcePoint = new KVector(source.getPosition().x + source.getSize().x / 2.0, source.getPosition().y + source.getSize().y / 2.0);
        KVector targetPoint = new KVector(target.getPosition().x + target.getSize().x / 2.0, target.getPosition().y + target.getSize().y / 2.0);
        bendPoints.addFirst((Object)sourcePoint);
        bendPoints.addLast((Object)targetPoint);
        TreeUtil.toNodeBorder(sourcePoint, (KVector)bendPoints.get(1), tEdge.getSource().getSize());
        TreeUtil.toNodeBorder(targetPoint, (KVector)bendPoints.get(bendPoints.size() - 2), tEdge.getTarget().getSize());
    }

    private void avoidOverlap(TGraph tGraph) {
        TNode root = TreeUtil.getRoot(tGraph);
        double nodeBendpointPadding = (Double)tGraph.getProperty(MrTreeOptions.SPACING_EDGE_NODE);
        double edgeEndTexturePadding = (Double)tGraph.getProperty(MrTreeOptions.EDGE_END_TEXTURE_LENGTH);
        Direction d = (Direction)tGraph.getProperty(MrTreeOptions.DIRECTION);
        this.avoidOverlapSetStartPoints(tGraph, d, nodeBendpointPadding);
        this.avoidOverlapSpecialEdges(tGraph, root, d, nodeBendpointPadding, edgeEndTexturePadding);
        this.avoidOverlapSetEndPoints(tGraph, d, nodeBendpointPadding, edgeEndTexturePadding);
    }

    private void avoidOverlapSpecialEdges(TGraph tGraph, TNode root, Direction d, double nodeBendpointPadding, double edgeEndTexturePadding) {
        int sideOneEdges = 0;
        int sideTwoEdges = 0;
        HashMap<Long, MultiLevelEdgeNodeNodeGap> nodeGaps = new HashMap<Long, MultiLevelEdgeNodeNodeGap>();
        int maxLevel = tGraph.getNodes().stream().map(x -> (Integer)x.getProperty(MrTreeOptions.TREE_LEVEL)).max(Integer::compare).get() + 1;
        int[] outsPerLevel = new int[maxLevel];
        int[] insPerLevel = new int[maxLevel];
        int i = 0;
        while (i < maxLevel) {
            outsPerLevel[i] = 0;
            insPerLevel[i] = 0;
            ++i;
        }
        List distictEdges = tGraph.getEdges().stream().distinct().collect(Collectors.toList());
        for (TEdge e : distictEdges) {
            int levelDiff;
            int targetLevel;
            int sourceLevel;
            block17: {
                sourceLevel = (Integer)e.getSource().getProperty(MrTreeOptions.TREE_LEVEL);
                targetLevel = (Integer)e.getTarget().getProperty(MrTreeOptions.TREE_LEVEL);
                levelDiff = targetLevel - sourceLevel;
                if (levelDiff <= 1) break block17;
                int curLevel = sourceLevel + 1;
                while (curLevel < targetLevel) {
                    block20: {
                        MultiLevelEdgeNodeNodeGap gap;
                        int i2;
                        List nextLevelNodes;
                        block19: {
                            KVector first;
                            KVector last;
                            KVector start;
                            block18: {
                                int finalCurlevel = curLevel;
                                nextLevelNodes = tGraph.getNodes().stream().filter(x -> (Integer)x.getProperty(MrTreeOptions.TREE_LEVEL) == finalCurlevel).collect(Collectors.toList());
                                i2 = 0;
                                if (!d.isHorizontal()) break block18;
                                nextLevelNodes.sort((x, y) -> Double.compare(x.getPosition().y, y.getPosition().y));
                                i2 = 0;
                                while (i2 < nextLevelNodes.size()) {
                                    double interpolation = (double)(curLevel - sourceLevel) / (double)(targetLevel - sourceLevel);
                                    if (((TNode)((Object)nextLevelNodes.get((int)i2))).getPosition().y > e.getSource().getPosition().y * (1.0 - interpolation) + e.getTarget().getPosition().y * interpolation) break;
                                    ++i2;
                                }
                                if (nextLevelNodes.size() <= 0) break block19;
                                start = e.getBendPoints().size() == 0 ? e.getSource().getPosition().clone() : (KVector)e.getBendPoints().getLast();
                                last = ((TNode)((Object)nextLevelNodes.get(nextLevelNodes.size() - 1))).getPosition().clone().add(((TNode)((Object)nextLevelNodes.get(nextLevelNodes.size() - 1))).getSize());
                                first = ((TNode)((Object)nextLevelNodes.get(0))).getPosition().clone().add(((TNode)((Object)nextLevelNodes.get(0))).getSize());
                                if (!(i2 >= nextLevelNodes.size() - 1 && start.y > last.y && e.getTarget().getPosition().y > last.y) && (i2 > 0 || !(start.y < first.x) || !(e.getTarget().getPosition().y < first.y))) break block19;
                                break block20;
                            }
                            nextLevelNodes.sort((x, y) -> Double.compare(x.getPosition().x, y.getPosition().x));
                            i2 = 0;
                            while (i2 < nextLevelNodes.size()) {
                                double interpolation = (double)(curLevel - sourceLevel) / (double)(targetLevel - sourceLevel);
                                if (((TNode)((Object)nextLevelNodes.get((int)i2))).getPosition().x > e.getSource().getPosition().x * (1.0 - interpolation) + e.getTarget().getPosition().x * interpolation) break;
                                ++i2;
                            }
                            if (nextLevelNodes.size() <= 0) break block19;
                            start = e.getBendPoints().size() == 0 ? e.getSource().getPosition().clone() : (KVector)e.getBendPoints().getLast();
                            last = ((TNode)((Object)nextLevelNodes.get(nextLevelNodes.size() - 1))).getPosition().clone().add(((TNode)((Object)nextLevelNodes.get(nextLevelNodes.size() - 1))).getSize());
                            first = ((TNode)((Object)nextLevelNodes.get(0))).getPosition().clone().add(((TNode)((Object)nextLevelNodes.get(0))).getSize());
                            if (i2 >= nextLevelNodes.size() - 1 && start.x > last.x && e.getTarget().getPosition().x > last.x || i2 <= 0 && start.x < first.x && e.getTarget().getPosition().x < first.x) break block20;
                        }
                        KVector bend1 = new KVector();
                        KVector bend2 = new KVector();
                        e.getBendPoints().add((Object)bend1);
                        e.getBendPoints().add((Object)bend2);
                        Triple bendTriple = new Triple((Object)bend1, (Object)bend2, (Object)e);
                        long key = TreeUtil.getUniqueLong(curLevel, i2);
                        if (!nodeGaps.containsKey(key)) {
                            gap = new MultiLevelEdgeNodeNodeGap(i2 == 0 ? null : (TNode)((Object)nextLevelNodes.get(i2 - 1)), i2 == nextLevelNodes.size() ? null : (TNode)((Object)nextLevelNodes.get(i2)), (Triple<KVector, KVector, TEdge>)bendTriple, tGraph);
                            nodeGaps.put(key, gap);
                        } else {
                            gap = (MultiLevelEdgeNodeNodeGap)nodeGaps.get(key);
                            gap.addBendPoints((Triple<KVector, KVector, TEdge>)bendTriple);
                        }
                        if (!d.isHorizontal()) {
                            if (gap.isOnFirstNodeSide() && gap.getNeighborTwo().getPosition().x <= (Double)tGraph.getProperty(InternalProperties.GRAPH_XMIN)) {
                                ++sideOneEdges;
                            }
                            if (gap.isOnLastNodeSide() && gap.getNeighborOne().getPosition().x + gap.getNeighborOne().getSize().x >= (Double)tGraph.getProperty(InternalProperties.GRAPH_XMAX)) {
                                ++sideTwoEdges;
                            }
                        } else {
                            if (gap.isOnFirstNodeSide() && gap.getNeighborTwo().getPosition().y <= (Double)tGraph.getProperty(InternalProperties.GRAPH_YMIN)) {
                                ++sideOneEdges;
                            }
                            if (gap.isOnLastNodeSide() && gap.getNeighborOne().getPosition().y + gap.getNeighborOne().getSize().y >= (Double)tGraph.getProperty(InternalProperties.GRAPH_YMAX)) {
                                ++sideTwoEdges;
                            }
                        }
                    }
                    ++curLevel;
                }
                continue;
            }
            if (levelDiff == 0) {
                this.middleToMiddleEdgeRoute(e);
                continue;
            }
            if (levelDiff >= 0) continue;
            int n = sourceLevel;
            outsPerLevel[n] = outsPerLevel[n] + 1;
            int n2 = targetLevel;
            insPerLevel[n2] = insPerLevel[n2] + 1;
            Pair<Integer, Integer> sides = this.avoidOverlapHandleCycleInducingEdges(e, d, tGraph, (Pair<Integer, Integer>)new Pair((Object)sideOneEdges, (Object)sideTwoEdges), nodeBendpointPadding, edgeEndTexturePadding, (Pair<Integer, Integer>)new Pair((Object)insPerLevel[targetLevel], (Object)outsPerLevel[sourceLevel]));
            sideOneEdges = (Integer)sides.getFirst();
            sideTwoEdges = (Integer)sides.getSecond();
        }
    }

    private Pair<Integer, Integer> avoidOverlapHandleCycleInducingEdges(TEdge e, Direction d, TGraph tGraph, Pair<Integer, Integer> sideEdges, double nodeBendpointPadding, double edgeEndTexturePadding, Pair<Integer, Integer> inOuts) {
        int sideOneEdges = (Integer)sideEdges.getFirst();
        int sideTwoEdges = (Integer)sideEdges.getSecond();
        TNode s = e.getSource();
        TNode t = e.getTarget();
        double bendTmp = 0.0;
        double middleTree = 0.0;
        if (d.isHorizontal()) {
            middleTree = tGraph.getNodes().stream().map(x -> x.getPosition().y + x.getSize().y / 2.0).mapToDouble(Double::doubleValue).average().getAsDouble();
            if (s.getPosition().y + s.getSize().y / 2.0 > middleTree) {
                int finalSideTwoEdges = ++sideTwoEdges;
                bendTmp = tGraph.getNodes().stream().map(x -> x.getPosition().y + x.getSize().y + nodeBendpointPadding * (double)finalSideTwoEdges).max(Double::compare).get();
            } else {
                int finalSideOneEdges = ++sideOneEdges;
                bendTmp = tGraph.getNodes().stream().map(x -> x.getPosition().y - nodeBendpointPadding * (double)finalSideOneEdges).min(Double::compare).get();
            }
        } else {
            middleTree = tGraph.getNodes().stream().map(x -> x.getPosition().x + x.getSize().x / 2.0).mapToDouble(Double::doubleValue).average().getAsDouble();
            if (s.getPosition().x + s.getSize().x / 2.0 > middleTree) {
                int finalSideTwoEdges = ++sideTwoEdges;
                bendTmp = tGraph.getNodes().stream().map(x -> x.getPosition().x + x.getSize().x + nodeBendpointPadding * (double)finalSideTwoEdges).max(Double::compare).get();
            } else {
                int finalSideOneEdges = ++sideOneEdges;
                bendTmp = tGraph.getNodes().stream().map(x -> x.getPosition().x - nodeBendpointPadding * (double)finalSideOneEdges).min(Double::compare).get();
            }
        }
        if (d == Direction.LEFT) {
            e.getBendPoints().add((Double)s.getProperty(InternalProperties.LEVELMIN) - nodeBendpointPadding, bendTmp);
            e.getBendPoints().add(t.getPosition().x + t.getSize().x + nodeBendpointPadding + edgeEndTexturePadding, bendTmp);
            e.getBendPoints().add(t.getPosition().x + t.getSize().x + nodeBendpointPadding + edgeEndTexturePadding, t.getPosition().y + t.getSize().y / 2.0);
            e.getBendPoints().add(t.getPosition().x + t.getSize().x, t.getPosition().y + t.getSize().y / 2.0);
        } else if (d == Direction.RIGHT) {
            e.getBendPoints().add((Double)s.getProperty(InternalProperties.LEVELMAX) + nodeBendpointPadding, s.getPosition().y + s.getSize().y / 2.0);
            e.getBendPoints().add(s.getPosition().x + s.getSize().x + nodeBendpointPadding, bendTmp);
            e.getBendPoints().add(t.getPosition().x - nodeBendpointPadding - edgeEndTexturePadding, bendTmp);
            e.getBendPoints().add(t.getPosition().x - nodeBendpointPadding - edgeEndTexturePadding, t.getPosition().y + t.getSize().y / 2.0);
            e.getBendPoints().add(t.getPosition().x, t.getPosition().y + t.getSize().y / 2.0);
        } else if (d == Direction.UP) {
            e.getBendPoints().add(bendTmp, (Double)s.getProperty(InternalProperties.LEVELMIN) - nodeBendpointPadding);
            e.getBendPoints().add(bendTmp, t.getPosition().y + t.getSize().y + nodeBendpointPadding + edgeEndTexturePadding);
            e.getBendPoints().add(t.getPosition().x + t.getSize().x / 2.0, t.getPosition().y + t.getSize().y + nodeBendpointPadding + edgeEndTexturePadding);
            e.getBendPoints().add(t.getPosition().x + t.getSize().x / 2.0, t.getPosition().y + t.getSize().y + nodeBendpointPadding);
        } else {
            if (!e.getBendPoints().isEmpty()) {
                ((KVector)e.getBendPoints().getLast()).y = (Double)s.getProperty(InternalProperties.LEVELMAX) + nodeBendpointPadding * (double)((Integer)inOuts.getSecond()).intValue();
            }
            e.getBendPoints().add(bendTmp, (Double)s.getProperty(InternalProperties.LEVELMAX) + nodeBendpointPadding * (double)((Integer)inOuts.getSecond()).intValue());
            e.getBendPoints().add(bendTmp, t.getPosition().y - nodeBendpointPadding * (double)((Integer)inOuts.getFirst()).intValue() - edgeEndTexturePadding);
        }
        return new Pair((Object)sideOneEdges, (Object)sideTwoEdges);
    }

    private void avoidOverlapSetStartPoints(TGraph tGraph, Direction d, double nodeBendpointPadding) {
        for (TNode n : tGraph.getNodes()) {
            if (n.getLabel().equals("SUPER_ROOT")) continue;
            List<TEdge> outs = TreeUtil.getAllOutgoingEdges(n, tGraph);
            if (d.isHorizontal()) {
                outs.sort((x, y) -> Double.compare(TreeUtil.getFirstPoint((TEdge)x).y, TreeUtil.getFirstPoint((TEdge)y).y));
            } else {
                outs.sort((x, y) -> Double.compare(TreeUtil.getFirstPoint((TEdge)x).x, TreeUtil.getFirstPoint((TEdge)y).x));
            }
            int num = outs.size();
            int i = 0;
            while (i < num) {
                TNode tar = outs.get(i).getTarget();
                if (tar.getLabel().equals("n11")) {
                    this.getClass();
                }
                if (!((Boolean)n.getProperty(InternalProperties.COMPACT_LEVEL_ASCENSION)).booleanValue() || TreeUtil.isCycleInducing(outs.get(i), tGraph)) {
                    double interpolation;
                    double d2 = interpolation = num == 1 ? 0.5 : (double)(i + 1) / (double)(num + 1);
                    if (d == Direction.LEFT) {
                        levelEndCoord = (Double)n.getProperty(InternalProperties.LEVELMIN);
                        y = n.getPosition().y + n.getSize().y * interpolation;
                        outs.get(i).getBendPoints().addFirst(Math.min(levelEndCoord, n.getPosition().x - nodeBendpointPadding), y);
                        outs.get(i).getBendPoints().addFirst(n.getPosition().x, y);
                    } else if (d == Direction.RIGHT) {
                        levelEndCoord = (Double)n.getProperty(InternalProperties.LEVELMAX) + nodeBendpointPadding;
                        y = n.getPosition().y + n.getSize().y * interpolation;
                        outs.get(i).getBendPoints().addFirst(levelEndCoord, y);
                        outs.get(i).getBendPoints().addFirst(n.getPosition().x + n.getSize().x, y);
                    } else if (d == Direction.UP) {
                        levelEndCoord = (Double)n.getProperty(InternalProperties.LEVELMIN);
                        x = n.getPosition().x + n.getSize().x * interpolation;
                        outs.get(i).getBendPoints().addFirst(x, Math.min(n.getPosition().y - nodeBendpointPadding, levelEndCoord));
                        outs.get(i).getBendPoints().addFirst(x, n.getPosition().y);
                    } else {
                        levelEndCoord = (Double)n.getProperty(InternalProperties.LEVELMAX) + nodeBendpointPadding;
                        x = n.getPosition().x + n.getSize().x * interpolation;
                        outs.get(i).getBendPoints().addFirst(x, levelEndCoord);
                        outs.get(i).getBendPoints().addFirst(x, n.getPosition().y + n.getSize().y);
                    }
                }
                ++i;
            }
        }
    }

    private void avoidOverlapSetEndPoints(TGraph tGraph, Direction d, double nodeBendpointPadding, double edgeEndTexturePadding) {
        for (TNode n : tGraph.getNodes()) {
            if (n.getLabel().equals("SUPER_ROOT")) continue;
            List ins = TreeUtil.getAllIncomingEdges(n, tGraph).stream().collect(Collectors.toList());
            if (d.isHorizontal()) {
                ins.sort((x, y) -> Double.compare(TreeUtil.getLastPoint((TEdge)x).y, TreeUtil.getLastPoint((TEdge)y).y));
            } else {
                ins.sort((x, y) -> Double.compare(TreeUtil.getLastPoint((TEdge)x).x, TreeUtil.getLastPoint((TEdge)y).x));
            }
            int num = ins.size();
            int i = 0;
            while (i < num) {
                double interpolation;
                double d2 = interpolation = num == 1 ? 0.5 : (double)(1 + i) / (double)(num + 1);
                if (d == Direction.LEFT) {
                    levelStartCoord = (Double)n.getProperty(InternalProperties.LEVELMAX);
                    if (n.getPosition().x + n.getSize().x + edgeEndTexturePadding < levelStartCoord) {
                        ((TEdge)((Object)ins.get(i))).getBendPoints().add(levelStartCoord + nodeBendpointPadding, n.getPosition().y + n.getSize().y * interpolation);
                    } else if (((TEdge)((Object)ins.get(i))).getBendPoints().size() > 0) {
                        lastX = ((KVector)((TEdge)((Object)ins.get((int)i))).getBendPoints().getLast()).x;
                        nextX = n.getPosition().x + n.getSize().x / 2.0;
                        lastY = ((KVector)((TEdge)((Object)ins.get((int)i))).getBendPoints().getLast()).y;
                        nextY = n.getPosition().y + n.getSize().y / 2.0;
                        if (edgeEndTexturePadding > 0.0 && Math.abs(lastY - nextY) / (Math.abs(lastX - nextX) / 40.0) > 50.0) {
                            if (nextY > lastY) {
                                ((TEdge)((Object)ins.get(i))).getBendPoints().add(n.getPosition().x + n.getSize().x + edgeEndTexturePadding / 5.3, n.getPosition().y + n.getSize().y * interpolation - edgeEndTexturePadding / 2.0);
                            } else {
                                ((TEdge)((Object)ins.get(i))).getBendPoints().add(n.getPosition().x + n.getSize().x + edgeEndTexturePadding / 5.3, n.getPosition().y + n.getSize().y * interpolation + edgeEndTexturePadding / 2.0);
                            }
                        }
                    }
                    ((TEdge)((Object)ins.get(i))).getBendPoints().add(n.getPosition().x + n.getSize().x, n.getPosition().y + n.getSize().y * interpolation);
                } else if (d == Direction.RIGHT) {
                    levelStartCoord = (Double)n.getProperty(InternalProperties.LEVELMIN);
                    if (n.getPosition().x - edgeEndTexturePadding > levelStartCoord) {
                        ((TEdge)((Object)ins.get(i))).getBendPoints().add(levelStartCoord - nodeBendpointPadding, n.getPosition().y + n.getSize().y * interpolation);
                    } else if (((TEdge)((Object)ins.get(i))).getBendPoints().size() > 0) {
                        lastX = ((KVector)((TEdge)((Object)ins.get((int)i))).getBendPoints().getLast()).x;
                        nextX = n.getPosition().x + n.getSize().x / 2.0;
                        lastY = ((KVector)((TEdge)((Object)ins.get((int)i))).getBendPoints().getLast()).y;
                        nextY = n.getPosition().y + n.getSize().y / 2.0;
                        if (edgeEndTexturePadding > 0.0 && Math.abs(lastY - nextY) / (Math.abs(lastX - nextX) / 40.0) > 50.0) {
                            if (nextY > lastY) {
                                ((TEdge)((Object)ins.get(i))).getBendPoints().add(n.getPosition().x - edgeEndTexturePadding / 5.3, n.getPosition().y + n.getSize().y * interpolation - edgeEndTexturePadding / 2.0);
                            } else {
                                ((TEdge)((Object)ins.get(i))).getBendPoints().add(n.getPosition().x - edgeEndTexturePadding / 5.3, n.getPosition().y + n.getSize().y * interpolation + edgeEndTexturePadding / 2.0);
                            }
                        }
                    }
                    ((TEdge)((Object)ins.get(i))).getBendPoints().add(n.getPosition().x, n.getPosition().y + n.getSize().y * interpolation);
                } else if (d == Direction.UP) {
                    levelStartCoord = (Double)n.getProperty(InternalProperties.LEVELMAX);
                    if (n.getPosition().y + n.getSize().y + edgeEndTexturePadding < levelStartCoord) {
                        ((TEdge)((Object)ins.get(i))).getBendPoints().add(n.getPosition().x + n.getSize().x * interpolation, levelStartCoord + nodeBendpointPadding);
                    } else if (((TEdge)((Object)ins.get(i))).getBendPoints().size() > 0) {
                        lastX = ((KVector)((TEdge)((Object)ins.get((int)i))).getBendPoints().getLast()).x;
                        nextX = n.getPosition().x + n.getSize().x / 2.0;
                        lastY = ((KVector)((TEdge)((Object)ins.get((int)i))).getBendPoints().getLast()).y;
                        nextY = n.getPosition().y + n.getSize().y / 2.0;
                        if (edgeEndTexturePadding > 0.0 && Math.abs(lastX - nextX) / (Math.abs(lastY - nextY) / 40.0) > 50.0) {
                            if (nextX > lastX) {
                                ((TEdge)((Object)ins.get(i))).getBendPoints().add(n.getPosition().x + n.getSize().x * interpolation - edgeEndTexturePadding / 2.0, n.getPosition().y + edgeEndTexturePadding / 5.3 + n.getSize().y);
                            } else {
                                ((TEdge)((Object)ins.get(i))).getBendPoints().add(n.getPosition().x + n.getSize().x * interpolation + edgeEndTexturePadding / 2.0, n.getPosition().y + edgeEndTexturePadding / 5.3 + n.getSize().y);
                            }
                        }
                    }
                    ((TEdge)((Object)ins.get(i))).getBendPoints().add(n.getPosition().x + n.getSize().x * interpolation, n.getPosition().y + n.getSize().y);
                } else {
                    levelStartCoord = (Double)n.getProperty(InternalProperties.LEVELMIN);
                    if (TreeUtil.isCycleInducing((TEdge)((Object)ins.get(i)), tGraph)) {
                        ((TEdge)((Object)ins.get(i))).getBendPoints().add(n.getPosition().x + n.getSize().x * interpolation, ((KVector)((TEdge)((Object)ins.get((int)i))).getBendPoints().getLast()).y);
                    } else if (n.getPosition().y - edgeEndTexturePadding > levelStartCoord) {
                        ((TEdge)((Object)ins.get(i))).getBendPoints().add(n.getPosition().x + n.getSize().x * interpolation, levelStartCoord - nodeBendpointPadding);
                    } else if (((TEdge)((Object)ins.get(i))).getBendPoints().size() > 0) {
                        lastX = ((KVector)((TEdge)((Object)ins.get((int)i))).getBendPoints().getLast()).x;
                        nextX = n.getPosition().x + n.getSize().x / 2.0;
                        lastY = ((KVector)((TEdge)((Object)ins.get((int)i))).getBendPoints().getLast()).y;
                        nextY = n.getPosition().y + n.getSize().y / 2.0;
                        if (edgeEndTexturePadding > 0.0 && Math.abs(lastX - nextX) / (Math.abs(lastY - nextY) / 40.0) > 50.0) {
                            if (nextX > lastX) {
                                ((TEdge)((Object)ins.get(i))).getBendPoints().add(n.getPosition().x + n.getSize().x * interpolation - edgeEndTexturePadding / 2.0, n.getPosition().y - edgeEndTexturePadding / 5.3);
                            } else {
                                ((TEdge)((Object)ins.get(i))).getBendPoints().add(n.getPosition().x + n.getSize().x * interpolation + edgeEndTexturePadding / 2.0, n.getPosition().y - edgeEndTexturePadding / 5.3);
                            }
                        }
                    }
                    ((TEdge)((Object)ins.get(i))).getBendPoints().add(n.getPosition().x + n.getSize().x * interpolation, n.getPosition().y);
                }
                ++i;
            }
        }
    }

    private void cyrusBeck(TGraph tGraph) {
        TNode root = TreeUtil.getRoot(tGraph);
        double nodeBendpointPadding = (Double)tGraph.getProperty(MrTreeOptions.SPACING_EDGE_NODE);
        for (TEdge edge : tGraph.getEdges()) {
            this.middleToMiddleEdgeRoute(edge);
        }
        for (TEdge edge : tGraph.getEdges()) {
            KVectorChain bends = edge.getBendPoints();
            int i = 0;
            while (i < bends.size() - 1) {
                KVector start = (KVector)bends.get(i);
                KVector end = (KVector)bends.get(i + 1);
                KVector delta = start.clone().sub(end.clone());
                if (delta.x != 0.0 || delta.y != 0.0) {
                    for (TNode node : tGraph.getNodes()) {
                        boolean el;
                        if (node.getLabel().equals(edge.getSource().getLabel()) || node.getLabel().equals(edge.getTarget().getLabel())) continue;
                        ArrayList<KVector> clip = new ArrayList<KVector>();
                        double xmin = node.getPosition().x;
                        double xmax = node.getPosition().x + node.getSize().x;
                        double ymin = node.getPosition().y;
                        double ymax = node.getPosition().y + node.getSize().y;
                        boolean so = start.y < ymin;
                        boolean su = start.y > ymax;
                        boolean sr = start.x > xmax;
                        boolean sl = start.x < xmin;
                        boolean eo = end.y < ymin;
                        boolean eu = end.y > ymax;
                        boolean er = end.x > xmax;
                        boolean bl = el = end.x < xmin;
                        if (edge.getSource().getLabel().equals("n8") && node.getLabel().equals("n6")) {
                            this.getClass();
                        }
                        if (!(!(so & eo) & !(su & eu) & !(sr & er) & !(sl & el))) continue;
                        if (delta.x == 0.0) {
                            clip.add(new KVector(start.x, ymin));
                            clip.add(new KVector(start.x, ymax));
                        } else if (delta.y == 0.0) {
                            clip.add(new KVector(xmin, start.y));
                            clip.add(new KVector(xmax, start.y));
                        } else {
                            KVector s;
                            double t;
                            ArrayList<Triple> pclips = new ArrayList<Triple>();
                            if (so | eo) {
                                t = (ymin - start.y) / (end.y - start.y);
                                s = start.clone().add(delta.clone().scale(t));
                                pclips.add(new Triple((Object)t, (Object)s, (Object)(-delta.y)));
                            }
                            if (su | eu) {
                                t = (ymax - start.y) / (end.y - start.y);
                                s = start.clone().add(delta.clone().scale(t));
                                pclips.add(new Triple((Object)t, (Object)s, (Object)delta.y));
                            }
                            if (sl | el) {
                                t = (xmin - start.x) / (end.x - start.x);
                                s = start.clone().add(delta.clone().scale(t));
                                pclips.add(new Triple((Object)t, (Object)s, (Object)(-delta.x)));
                            }
                            if (sr | er) {
                                t = (xmax - start.x) / (end.x - start.x);
                                s = start.clone().add(delta.clone().scale(t));
                                pclips.add(new Triple((Object)t, (Object)s, (Object)delta.x));
                            }
                            pclips.sort((x, y) -> Double.compare((Double)x.getThird(), (Double)y.getThird()));
                            int j = 0;
                            while (j < pclips.size()) {
                                if ((Double)((Triple)pclips.get(j)).getThird() > 0.0) {
                                    clip.add((KVector)((Triple)pclips.get(j)).getSecond());
                                    clip.add((KVector)((Triple)pclips.get(j - 1)).getSecond());
                                    break;
                                }
                                ++j;
                            }
                        }
                        clip.sort((x, y) -> Double.compare(delta.clone().dotProduct(x.clone()), delta.clone().dotProduct(y.clone())));
                        KVector middle = ((KVector)clip.get(0)).clone().add(((KVector)clip.get(1)).clone()).scale(0.0);
                        bends.addAll(0, clip);
                        i += 32;
                        break;
                    }
                }
                ++i;
            }
        }
    }
}

