/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.globalconstantseditor.ui.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.globalconstantseditor.ui.properties.GlobalConstantsPropertySheetPage;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class GlobalConstantsEditor
extends XtextEditor
implements CommandStackEventListener,
ITabbedPropertySheetPageContributor {
    private final CommandStack commandStack = new CommandStack();
    private final ActionRegistry actionRegistry = new ActionRegistry();

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.commandStack.addCommandStackEventListener((CommandStackEventListener)this);
    }

    public void dispose() {
        this.actionRegistry.dispose();
        this.commandStack.removeCommandStackEventListener((CommandStackEventListener)this);
        super.dispose();
    }

    public void stackChanged(CommandStackEvent event) {
        this.updateActions();
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return super.isDirty() || this.commandStack.isDirty();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        this.commandStack.markSaveLocation();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.commandStack.flush();
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        this.commandStack.flush();
    }

    protected void createActions() {
        super.createActions();
        this.actionRegistry.registerAction((IAction)new UndoAction((IEditorPart)this));
        this.actionRegistry.registerAction((IAction)new RedoAction((IEditorPart)this));
    }

    private void updateActions() {
        this.actionRegistry.getActions().forEachRemaining(action -> {
            if (action instanceof UpdateAction) {
                UpdateAction updateAction = (UpdateAction)action;
                updateAction.update();
            }
        });
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == IPropertySheetPage.class) {
            return key.cast((Object)new GlobalConstantsPropertySheetPage(this));
        }
        if (key == CommandStack.class) {
            return key.cast(this.getCommandStack());
        }
        if (key == ActionRegistry.class) {
            return key.cast(this.getActionRegistry());
        }
        return (T)super.getAdapter(key);
    }

    protected final CommandStack getCommandStack() {
        return this.commandStack;
    }

    protected final ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public String getContributorId() {
        return this.getLanguageName();
    }
}

