/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.commons.util.BlacklistedExceptions;
import org.junit.platform.commons.util.Preconditions;
import org.opentest4j.MultipleFailuresError;

class AssertAll {
    private AssertAll() {
    }

    static void assertAll(Executable ... executables) {
        AssertAll.assertAll(null, executables);
    }

    static void assertAll(String heading, Executable ... executables) {
        Preconditions.notEmpty((Object[])executables, (String)"executables array must not be null or empty");
        Preconditions.containsNoNullElements((Object[])executables, (String)"individual executables must not be null");
        AssertAll.assertAll(heading, Arrays.stream(executables));
    }

    static void assertAll(Stream<Executable> executables) {
        AssertAll.assertAll(null, executables);
    }

    static void assertAll(String heading, Stream<Executable> executables) {
        Preconditions.notNull(executables, (String)"executables must not be null");
        ArrayList failures = new ArrayList();
        executables.forEach(executable -> {
            try {
                executable.execute();
            }
            catch (Throwable t) {
                BlacklistedExceptions.rethrowIfBlacklisted((Throwable)t);
                failures.add(t);
            }
        });
        if (!failures.isEmpty()) {
            throw new MultipleFailuresError(heading, failures);
        }
    }
}

