/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.util.ElementSelector;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.graphics.Point;

public class PasteCommand
extends Command {
    private static final int DEFAULT_DELTA = 20;
    private final List templates;
    private final FBNetwork dstFBNetwork;
    private final Map<String, FBNetworkElement> copiedElements = new HashMap<String, FBNetworkElement>();
    private final List<FBNetworkElement> elementsToCopy = new ArrayList<FBNetworkElement>();
    private final Set<Connection> connectionsToCopy = new HashSet<Connection>();
    private final CompoundCommand connCreateCmds = new CompoundCommand();
    private int xDelta;
    private int yDelta;
    private boolean calcualteDelta = false;
    private Point pasteRefPos;

    public PasteCommand(List templates, FBNetwork destination, Point pasteRefPos) {
        this.templates = templates;
        this.dstFBNetwork = destination;
        this.pasteRefPos = pasteRefPos;
        this.calcualteDelta = true;
    }

    public PasteCommand(List templates, FBNetwork destination, int copyDeltaX, int copyDeltaY) {
        this.templates = templates;
        this.dstFBNetwork = destination;
        this.xDelta = copyDeltaX;
        this.yDelta = copyDeltaY;
    }

    public boolean canExecute() {
        return this.templates != null && this.dstFBNetwork != null;
    }

    public void execute() {
        if (this.dstFBNetwork != null) {
            this.gatherCopyData();
            this.copyFBs();
            this.copyConnections();
            new ElementSelector().selectViewObjects(this.copiedElements.values());
        }
    }

    public void undo() {
        this.connCreateCmds.undo();
        this.dstFBNetwork.getNetworkElements().removeAll(this.copiedElements.values());
        new ElementSelector().selectViewObjects((Collection)this.templates);
    }

    public void redo() {
        this.dstFBNetwork.getNetworkElements().addAll(this.copiedElements.values());
        this.connCreateCmds.redo();
        new ElementSelector().selectViewObjects(this.copiedElements.values());
    }

    private void gatherCopyData() {
        int x = Integer.MAX_VALUE;
        int y = Integer.MAX_VALUE;
        for (Object object : this.templates) {
            if (object instanceof FBNetworkElement) {
                FBNetworkElement element = (FBNetworkElement)object;
                this.elementsToCopy.add(element);
                x = Math.min(x, element.getX());
                y = Math.min(y, element.getY());
                continue;
            }
            if (!(object instanceof Connection)) continue;
            this.connectionsToCopy.add((Connection)object);
        }
        if (this.calcualteDelta) {
            if (this.pasteRefPos != null) {
                this.xDelta = this.pasteRefPos.x - x;
                this.yDelta = this.pasteRefPos.y - y;
            } else {
                this.xDelta = 20;
                this.yDelta = 20;
            }
        }
    }

    private void copyFBs() {
        for (FBNetworkElement element : this.elementsToCopy) {
            FBNetworkElement copiedElement = this.createElementCopyFB(element);
            this.copiedElements.put(element.getName(), copiedElement);
            this.dstFBNetwork.getNetworkElements().add((Object)copiedElement);
            copiedElement.setName(NameRepository.createUniqueName((INamedElement)copiedElement, (String)element.getName()));
        }
    }

    private FBNetworkElement createElementCopyFB(FBNetworkElement element) {
        FBNetworkElement copiedElement = (FBNetworkElement)EcoreUtil.copy((EObject)element);
        for (IInterfaceElement ie : copiedElement.getInterface().getAllInterfaceElements()) {
            if (ie.isIsInput()) {
                ie.getInputConnections().clear();
                continue;
            }
            ie.getOutputConnections().clear();
        }
        Point pastePos = this.calculatePastePos(element);
        copiedElement.setX(pastePos.x);
        copiedElement.setY(pastePos.y);
        copiedElement.setMapping(null);
        return copiedElement;
    }

    private void copyConnections() {
        for (Connection conn : this.connectionsToCopy) {
            FBNetworkElement copiedSrc = this.copiedElements.get(conn.getSourceElement().getName());
            FBNetworkElement copiedDest = this.copiedElements.get(conn.getDestinationElement().getName());
            if (copiedSrc == null && copiedDest == null) continue;
            EventConnectionCreateCommand cmd = null;
            if (conn instanceof EventConnection) {
                cmd = new EventConnectionCreateCommand(this.dstFBNetwork);
            } else if (conn instanceof DataConnection) {
                if (copiedDest != null) {
                    cmd = new DataConnectionCreateCommand(this.dstFBNetwork);
                }
            } else if (conn instanceof AdapterConnection && copiedSrc != null && copiedDest != null) {
                cmd = new AdapterConnectionCreateCommand(this.dstFBNetwork);
            }
            if (cmd == null) continue;
            this.copyConnection(conn, (AbstractConnectionCreateCommand)cmd);
            if (!cmd.canExecute()) continue;
            this.connCreateCmds.add((Command)cmd);
        }
        this.connCreateCmds.execute();
    }

    private void copyConnection(Connection conn, AbstractConnectionCreateCommand cmd) {
        FBNetworkElement copiedSrc = this.copiedElements.get(conn.getSourceElement().getName());
        FBNetworkElement copiedDest = this.copiedElements.get(conn.getDestinationElement().getName());
        IInterfaceElement source = PasteCommand.checkForCopiedInterfaceElement(copiedSrc != null ? copiedSrc : conn.getSourceElement(), conn.getSource());
        IInterfaceElement destination = PasteCommand.checkForCopiedInterfaceElement(copiedDest != null ? copiedDest : conn.getDestinationElement(), conn.getDestination());
        cmd.setSource(source);
        cmd.setDestination(destination);
        cmd.setArrangementConstraints(conn.getDx1(), conn.getDx2(), conn.getDy());
    }

    private static IInterfaceElement checkForCopiedInterfaceElement(FBNetworkElement targetElement, IInterfaceElement orig) {
        Assert.isNotNull((Object)targetElement);
        return targetElement.getInterfaceElement(orig.getName());
    }

    private Point calculatePastePos(FBNetworkElement element) {
        return new Point(element.getX() + this.xDelta, element.getY() + this.yDelta);
    }
}

