**Note:** This file is automatically generated. Please see the [developer
documentation](doc/development/changelog.md) for instructions on adding your own
entry.

## 17.3.5 (2024-10-09)

### Fixed (1 change)

- [Ensure levels is an array](https://gitlab.com/gitlab-org/security/gitlab/-/commit/74594891f31984feaaae6a069f057d6f48a489a6)

### Security (8 changes)

- [Do not create a pipeline on MR refresh if source branch was deleted](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c36869b2e5cb0f88793bec7e20ded3e4d005f942) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4523))
- [Escape OAuth application name on authorize page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b5a704563f746e5c61301d3a7db0eab68d434e24) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4518))
- [Prevent guest access to project templates](https://gitlab.com/gitlab-org/security/gitlab/-/commit/92d177e2c5aaafb4f74bc2ceafe39b9a068e803d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4449))
- [Remove access to local requests via cube query service](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7043d0116cbf2051907dfd88d56ed3f847ab95b2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4493))
- [External webhook token should be set](https://gitlab.com/gitlab-org/security/gitlab/-/commit/77c2a678acfc6fded56c6e10147701b6ef7aaeb5) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4511))
- [Skip content when listing conflict files with types](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2b559425cb195a78007db930cbbf8450b5254c89) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4514))
- [Hide version info from unauthorized users](https://gitlab.com/gitlab-org/security/gitlab/-/commit/94e70d423789a50fc8e172b002bf1428593bbc51) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4501))
- [Prevent deploy keys from pushing code to an archived project](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3cd52356b4b1194e7108af832d5da4087e4be05c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4487))

## 17.3.4 (2024-09-24)

### Security (3 changes)

- [Implement input sanitization for SummarizeComments](https://gitlab.com/gitlab-org/security/gitlab/-/commit/034f25d7a760c8027f3c7426ca57ee49459f866f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4411))
- [Hide system notes with invalid references](https://gitlab.com/gitlab-org/security/gitlab/-/commit/484a80474d1f262b45923de365e288140605333e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4483))
- [Reset dependency proxy maven credentials when registry url is changed](https://gitlab.com/gitlab-org/security/gitlab/-/commit/74a4ae92cbb1e74e9e1e6858d6d3b0cf9daa4d09) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4458))

## 17.3.3 (2024-09-16)

No changes.

## 17.3.2 (2024-09-11)

### Fixed (3 changes)

- [Update Access data on sync even if data didn’t changed](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4ef29892400e4cfd9d77ae2ed11d577cf94bf026)
- [Fix Sidekiq crashing when GITLAB_LOG_LEVEL set to debug](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e2eba0a9279b9f92d0adda8653474efb0ca1014a)
- [Fix issue when resizing images in RTE](https://gitlab.com/gitlab-org/security/gitlab/-/commit/812f117e1fc8260121c1dfbeb5e503552aedca37)

### Changed (1 change)

- [Backport OpenSSL v3 callout to 17.3](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ba9718022b12e627375e166a8731e9cb83fd632b)

### Security (19 changes)

- [Revert "Merge branch 'security-psk-fix-external-wiki-integration-dos-17-3' into '17-3-stable-ee'"](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4adb684182baacf3d351090265c94899b5db1eb3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4453))
- [Fix the vulnerability in the glm_source parameter](https://gitlab.com/gitlab-org/security/gitlab/-/commit/878cda6f69865a8a61d0a3e431ed365bb01fd7a0) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4436))
- [Improve GraphQL log security](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8ab77ecaffab94c02d4d8054dd900ef853ddb492) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4400))
- [Add permissions check to project creations from a project template](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9aaaaf465c69b9cf80f7b3906338a822f31adadd) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4443))
- [Fix credentials disclosure in mirroring failure](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0c2d3c9417a1fccea08bdc817943685f058c7fa5) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4446))
- [Redirect url in the link validated for being external](https://gitlab.com/gitlab-org/security/gitlab/-/commit/219cfd97cc2771266d2e92c9bd2e87bad2cdceb4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4440))
- [[17.3] Update edit permissions for DAST profiles](https://gitlab.com/gitlab-org/security/gitlab/-/commit/44638f2465398883881de00a84fea1f724bc3456) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4372))
- [Commit information visible through release atom endpoint for guest users](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7e4451c5eb6f7ae20ff9400660d9c8072d378522) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4437))
- [Execute environment stop actions as the owner of the action](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e160b472c887a33122f9ef2894551b167a321377) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4404))
- [Prevent code injection in Product Analytics funnels YAML](https://gitlab.com/gitlab-org/security/gitlab/-/commit/04ee196cf8dde5621404345a35a85c600e294536) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4431))
- [Prevent users with admin_group_member custom ab. to manage custom roles](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8a5aae28a61f67ccaf5a2c2fe7c24c4cc123d427) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4425))
- [Fixed frontend regex to parse URI](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ae7d2fddff8fe064bde1bd9ab01bf10e219cbfa8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4419))
- [Use session instead of params for identity linking](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7ae3008fd84476d8995fe9fa7ec0800219cd1370) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4369))
- [Fix external wiki integration DoS by changing request to HEAD](https://gitlab.com/gitlab-org/security/gitlab/-/commit/20a6c608712831e7e9b072fbe0de61bb61105cdf) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4381))
- [Restrict IPs for packages dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b894f3ca69858cceb80362e9f6a8c3d10bafe42a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4391))
- [Strip out Set-Cookie header from dependencyproxy auth response](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cafae257663e5e0e2c410fd642c18c2b549b3451) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4399))
- [Fix open redirect due to additional slash added](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4fe66b1075a6023fcb2b5ce219b7ce0037a183b1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4374))
- [Group Developers can view group runners](https://gitlab.com/gitlab-org/security/gitlab/-/commit/084025e6a0ee601f4509ab2f9541d5a9a2c91d44) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4378))
- [Enforce Pipeline execution policy variables for template rules](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5dd7d992fcdcb23dfc32a47977b51303042b1be8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4393))

## 17.3.1 (2024-08-20)

### Fixed (3 changes)

- [Merge branch '444926-fix-bug-in-resolve-vulnerabilities-migration' into 'master'](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ac8a0cdc00b76c5ad84e8d18f3a7e49ebea2a538)
- [Turn NotFound from Gitaly into 404 for InfoRefs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3566c2625d62857246b215e191fb137091de1650)
- [Fix timeout when checking group dependencies](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3f3bdb24b185196875a3989f0378d237243e80f6) **GitLab Enterprise Edition**

### Changed (1 change)

- [Include language server version in code suggestions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5b4b98955c5fa55911631800c3cd48f6224bf664) **GitLab Enterprise Edition**

### Security (4 changes)

- [Do not run pipelines when resolving vulnerability](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ef9c251b19c1ad7aedb591870158fc0085ee5fd9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4360))
- [Add Octokit::ResponseValidation middleware](https://gitlab.com/gitlab-org/security/gitlab/-/commit/08d547262c574b00135fb71105e52f03dc3ca8c0) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4375))
- [IP restriction to prevent all group permissions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e080f2d2c5a578df52f202505e993c560fec6cb2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4368))
- [Destroy associated releases when removing a tag via Git CLI](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b79ada987b82fa756e6ae74f7527dcde8c30d08f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4365))

## 17.3.0 (2024-08-14)

### Added (143 changes)

- [Trigger a Flux reconciliation from the cluster UI](https://gitlab.com/gitlab-org/gitlab/-/commit/be261dabcf80bb62aeec0ecbb7f8d7182e1bcea8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162017))
- [Add REST API invited groups in a group](https://gitlab.com/gitlab-org/gitlab/-/commit/7340e9d4fd361520da764924c8924e74e7a78aab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161792))
- [Sync finished pipelines to ClickHouse](https://gitlab.com/gitlab-org/gitlab/-/commit/fc536baba08a5df805424ccf6c04a90a93a16e3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162145))
- [Add subscription_history to Namespace GraphQL Type](https://gitlab.com/gitlab-org/gitlab/-/commit/0557753c50b8c4a142b16016f43b733335efd546) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162042))
- [Add common phrases copy to the password](https://gitlab.com/gitlab-org/gitlab/-/commit/4251bc65f2506121e1e244dccdb4ed4c0d299b7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158789)) **GitLab Enterprise Edition**
- [Set project_id when creating Packages::Dependency](https://gitlab.com/gitlab-org/gitlab/-/commit/47a58a87252853c5743243cedf9c39b3f2c87318) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161039))
- [Extend deprecation properties with custom scan action](https://gitlab.com/gitlab-org/gitlab/-/commit/13626c77eacdea11360434c53e2f93dfe5840afa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162026)) **GitLab Enterprise Edition**
- [Protected containers: Badge "protected" in container registry list](https://gitlab.com/gitlab-org/gitlab/-/commit/f6f61289cd1ebefccaa0993e265786e743e57244) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158600))
- [Add a shared avatar image for security policy bots](https://gitlab.com/gitlab-org/gitlab/-/commit/e32392893acc6531fc06bca68b3f36c0f8428ff8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160803))
- [Add backend support for multiple Vue list filters](https://gitlab.com/gitlab-org/gitlab/-/commit/98184fee58bde0c25a7f87b239a2a95f33947e47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160938)) **GitLab Enterprise Edition**
- [Add EPSS to GitLab database](https://gitlab.com/gitlab-org/gitlab/-/commit/1e1d3d03038ea74054cf9d6e662727ff6e8395d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158908)) **GitLab Enterprise Edition**
- [Script to update Topology Service Gem](https://gitlab.com/gitlab-org/gitlab/-/commit/4ecbc79341a0e0c8af290e964b174bf79fc971c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161064))
- [Add TLS support for Redis Sentinel](https://gitlab.com/gitlab-org/gitlab/-/commit/e161ba73e46386101338317f7587c393f02784a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162132))
- [Create events to measure Branch rule edit adoption](https://gitlab.com/gitlab-org/gitlab/-/commit/2ddb31d3c03cb19f3a6963f28382ccec69fa1b4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160591)) **GitLab Enterprise Edition**
- [Allow the restriction of Kubernetes agent access to protected branches](https://gitlab.com/gitlab-org/gitlab/-/commit/7781be08bea6fe0c774b282f7abff6d22ba5bef9) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156626))
- [Add compliance_checks and compliance_requirements tables](https://gitlab.com/gitlab-org/gitlab/-/commit/b2a57db58eb817eac96235724ce99cd54dcbda1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161382))
- [Cleanup sync_audit_events_to_new_tables feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/155ed664f2252c45e95e8ac1ef4e248b8e136ad1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161982))
- [Add setting for max_artifact_archive_size_bytes](https://gitlab.com/gitlab-org/gitlab/-/commit/5785b4e21bf90f56107a6282280790f84ffec9a8) by @danlamanna ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148554))
- [Add MR mergeability check for locked paths](https://gitlab.com/gitlab-org/gitlab/-/commit/e746530ad02b3734878b18a6e560f554e78b1df0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160929))
- [Refactor Modal form to use native submit](https://gitlab.com/gitlab-org/gitlab/-/commit/177f9524721a3ad0820b717f3f348c3e89f3c456) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161787))
- [Adapt seat assignment logic for both Duo add-ons](https://gitlab.com/gitlab-org/gitlab/-/commit/4523ee88992dce87f44ecd2b3f1106aaf06194ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161473)) **GitLab Enterprise Edition**
- [Add GraphQL PMG to MR widget](https://gitlab.com/gitlab-org/gitlab/-/commit/09d08d4cc8b521a12969d95a60494a6d63c35a8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160776))
- [Add field enterprise_users_extensions_marketplace_enabled for groups](https://gitlab.com/gitlab-org/gitlab/-/commit/4f5e0dd020289d57a28c6a1354db3487ad1ee788) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161728))
- [Add  CSV upload modal for user contribution reassignments](https://gitlab.com/gitlab-org/gitlab/-/commit/144a02b3c9a5b642974edcf8ffac6e0f3e92f4bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156906))
- [Frontend for zoekt search results - part 1](https://gitlab.com/gitlab-org/gitlab/-/commit/0d2a2db569ef773acd3506e90d7904875586233c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160957)) **GitLab Enterprise Edition**
- [Provide connect command for agent cluster](https://gitlab.com/gitlab-org/gitlab/-/commit/5102deddc07fc30e661b12bac9981472de46fd9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161092))
- [Async FK for p_ci_builds.upstream_pipeline_id](https://gitlab.com/gitlab-org/gitlab/-/commit/acd118b8d2e6edcd62b13bd2f4b526aaadf05571) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161868))
- [Async FK for ci_pipelines.auto_canceled_by_id](https://gitlab.com/gitlab-org/gitlab/-/commit/15f7246e555a2d9fb4f0a342e28509240ec3b78f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161872))
- [Clean up duo_chat_disabled_button feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4d208f29079a9f57459374b236c9df70247d764a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161889)) **GitLab Enterprise Edition**
- [Add new internal API for credit card validation](https://gitlab.com/gitlab-org/gitlab/-/commit/b0fe49904b187fbf637f4ce14ea67787217ad7ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160540)) **GitLab Enterprise Edition**
- [Add MR mergeability check for locked LFS files](https://gitlab.com/gitlab-org/gitlab/-/commit/518897664a2887f189c01f6efacff955d9ed7bef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158773))
- [VSD Usage Overview - Display alert if background aggregations disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/a91ff26ddfb0f935143cbe8676e2801172ba66ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161529)) **GitLab Enterprise Edition**
- [List owned runners via :admin_runners permission](https://gitlab.com/gitlab-org/gitlab/-/commit/09c78c1f3ea217cc68c1fc9f8e906b956bb82e38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161385)) **GitLab Enterprise Edition**
- [Add endpoint with standard roles and members count for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/2580b03ba6be3f8868980e2d6cdd4ba79604d946) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161802)) **GitLab Enterprise Edition**
- [Add work items hierarchy reorder mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/780029ce8f9c757ed68eb5e0c240818b79428224) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161319)) **GitLab Enterprise Edition**
- [Trigger workItemUpdated GQL subscription on MR update](https://gitlab.com/gitlab-org/gitlab/-/commit/489955a7e708ea6e9f77583efdeaa9a702f323f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161103))
- [Frontend for zoekt search results - part 1](https://gitlab.com/gitlab-org/gitlab/-/commit/5961964f5d8c9ffe122fe3da74f21e9432f0e522) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160955)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/b54d4d9654c6e56098ccb925f60998ab5e2e42b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161755))
- [Allow users to customize their JWT sub claim](https://gitlab.com/gitlab-org/gitlab/-/commit/30e17df70d91c1171b89a8576bfdb1b8b95ac3ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160562))
- [Add the DB migration to backfill reserved_storage_bytes in zoekt_indices](https://gitlab.com/gitlab-org/gitlab/-/commit/c42abed8575fee7de7ba020c496eb820f0796b77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160302))
- [Add show_on_profile to UserAchievement](https://gitlab.com/gitlab-org/gitlab/-/commit/b5fcad26f840ec2e45ff340482304b7e5f8fa80c) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161225))
- [Add merge request dependency GET endpoints for REST](https://gitlab.com/gitlab-org/gitlab/-/commit/3a06379314e2afaa25da62cb161e7a58ed83a737) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160432))
- [Add project_id to merge_request_diff_commits_b5377a7a34](https://gitlab.com/gitlab-org/gitlab/-/commit/a50df2a88aa487adfddd7c28b6f9badbb6df3641) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156090))
- [Add project_id to merge_request_diff_files_99208b8fac](https://gitlab.com/gitlab-org/gitlab/-/commit/ed292883a1ac8911e1e96c3d97ff4c59392f7dac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156091))
- [Add GIN index to sbom_components](https://gitlab.com/gitlab-org/gitlab/-/commit/b87435af3e4589074a272f436ef608a56f1f5006) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161654))
- [Add Duo Pro seats panel to AI impact analytics dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/a95b42dca5ea792a476d82812dd2d0dc64b6f8a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161638)) **GitLab Enterprise Edition**
- [Show SBOM reports ingestion errors on the project dependency list](https://gitlab.com/gitlab-org/gitlab/-/commit/4d35b7c54cf86efe7773f47e753a724294e1a159) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160270)) **GitLab Enterprise Edition**
- [Add code suggestions acceptance rate tile](https://gitlab.com/gitlab-org/gitlab/-/commit/13c6e01ee111a596102214faa1f864393562e5b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160882)) **GitLab Enterprise Edition**
- [Support custom Redis usernames](https://gitlab.com/gitlab-org/gitlab/-/commit/bd4e9d2067afdc96d4870672a597b437744110d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161495))
- [Make RCA generally available](https://gitlab.com/gitlab-org/gitlab/-/commit/2105ae370cfa30afbf94ebd0e0d166737dd0ab04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161371))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/47021899a01731473bf1025d1264ce39861e2f24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161483))
- [Add trendlines to the AI Impact analytics dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/289cdebd8629c9686d0a0fa6afeff80116844b32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160437)) **GitLab Enterprise Edition**
- [Add new table to connect issues to metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/1607b659d8d837beb5704d15d5c7e7bfb6e44cd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160713)) **GitLab Enterprise Edition**
- [Improve logging and Prometheus metrics of Workhorse endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/d5f902ecc43f00c052140033c3500e858b65ed92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160461))
- [Add observability APIs](https://gitlab.com/gitlab-org/gitlab/-/commit/61bcf01781e143982c233fa0e7a7ad9b30db286f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161069))
- [Adds the code suggestions unique users tile](https://gitlab.com/gitlab-org/gitlab/-/commit/8e5bef6b97be5a6d7980edb814a96f92adf598c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155444)) **GitLab Enterprise Edition**
- [Enable store_sbom_report_ingestion_errors FF by default](https://gitlab.com/gitlab-org/gitlab/-/commit/753a8994c3e7dd354cd1112e306dd203295b33fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161379)) **GitLab Enterprise Edition**
- [Update shared groups params](https://gitlab.com/gitlab-org/gitlab/-/commit/70ca4b2d81be567b516169ca834b3d06cd4f5f39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159628))
- [Remove feature flag wiki_redirection](https://gitlab.com/gitlab-org/gitlab/-/commit/db049b459e3a20d97abb6c88a0cfe19d203908e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161305))
- [Allow Duo add-on upgrade and downgrade for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/d3641b19ad998d1b01c43170bc62546fef81c4ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160608)) **GitLab Enterprise Edition**
- [Expose can_modify_blob_with_web_ide](https://gitlab.com/gitlab-org/gitlab/-/commit/afd7d8012b7c72c84ba4296d81dbe1d241bf5490) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161346))
- [Add merge trains viz link](https://gitlab.com/gitlab-org/gitlab/-/commit/ed938702aa9a05107a3014c12b381b00496468e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161219)) **GitLab Enterprise Edition**
- [Add style for `<mark>` in rendered markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/76f607f07fc15786a03a337846694b9ec3778911) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161091))
- [Add .NET tutorial for O11y usage](https://gitlab.com/gitlab-org/gitlab/-/commit/12810b304d17f113ff4d690e8f58e94708233ea4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161193))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/04f43b9bd9ddb00446d46fed0e9aaca70ef1b014) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161306))
- [Add project_id column to packages_dependencies table](https://gitlab.com/gitlab-org/gitlab/-/commit/adcd83b78a2c2c9418513cb23e86b6a8930f44be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160830))
- [Remove FF enterprise_disable_personal_access_tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/9cbffecbdd34bcfb1467795eb6c2c4ff4d6a0b48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160816))
- [Add terraform module graphql type](https://gitlab.com/gitlab-org/gitlab/-/commit/dcd032cd573effa730976f64ef1120949bd7b064) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157305))
- [Added the countable connection to the todo type](https://gitlab.com/gitlab-org/gitlab/-/commit/a32cf8070f8bb24f60d5b3ec8e5b26266bf8bdf8) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159635))
- [Protected containers: Badge "protected" in container detail page](https://gitlab.com/gitlab-org/gitlab/-/commit/b18e8e659ab10a99d57d149799ec8cc9170af026) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156539))
- [Cloud Connector status: Add end-to-end probe](https://gitlab.com/gitlab-org/gitlab/-/commit/930d589bee547142bb598da24afa72e133afc13d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161147)) **GitLab Enterprise Edition**
- [Cloud Connector: Add VerificationService](https://gitlab.com/gitlab-org/gitlab/-/commit/1e72d2326a462ae81832a1d6151f8d70628fcc2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159579)) **GitLab Enterprise Edition**
- [Added field to query memberApprovals for group/project](https://gitlab.com/gitlab-org/gitlab/-/commit/abc4139d47e471c94968fad24d2cb5bb178c2c2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159926)) **GitLab Enterprise Edition**
- [Add id attribute to uploads API](https://gitlab.com/gitlab-org/gitlab/-/commit/c636690b118851c9e0f5e76c9a7bfc0a24aa9912) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161160))
- [Do not allow creating epic notes when synced work item is locked](https://gitlab.com/gitlab-org/gitlab/-/commit/a9f82bfd9faabe611e2b86c9b4b824f7d1e740de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160570)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/51dbcc5ef6055d8453df59b77b171e0804c6d847) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161146))
- [Add org to source package](https://gitlab.com/gitlab-org/gitlab/-/commit/a3f990293dca7c9ebb5aaa2ac2ba292895745d85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159026)) **GitLab Enterprise Edition**
- [Trigger `workItemUpdated` with `WorkItemAddClosingMergeRequest`](https://gitlab.com/gitlab-org/gitlab/-/commit/6ab284bf14a4c40383441b019c6792356e74609c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161083))
- [Audit group modifications to CI_JOB_TOKEN](https://gitlab.com/gitlab-org/gitlab/-/commit/90e006ac69a25bb1692609e70ed92f69715228df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159754)) **GitLab Enterprise Edition**
- [Add group settings sections to command mode results](https://gitlab.com/gitlab-org/gitlab/-/commit/bfa14310fb3d5657beed8bb74327a5390d7cf676) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158228))
- [Add support for xterm background colors](https://gitlab.com/gitlab-org/gitlab/-/commit/4c33ccd48cdae213730a4cb2970e68337e2f2234) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161030))
- [Add Arkose email intelligence service](https://gitlab.com/gitlab-org/gitlab/-/commit/2b4c3c993751c5c2f12cef5f9b703f91ab145e3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160308)) **GitLab Enterprise Edition**
- [Add contact support links in identity verification page](https://gitlab.com/gitlab-org/gitlab/-/commit/4798606ddd8d840c9d460b55f8e30be769a73955) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160187)) **GitLab Enterprise Edition**
- [Add new merge trains link](https://gitlab.com/gitlab-org/gitlab/-/commit/aea2c40248fdc2e6edc7ba56b84c59d2e14acb8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160757)) **GitLab Enterprise Edition**
- [Add drag and drop feature to work items page](https://gitlab.com/gitlab-org/gitlab/-/commit/df829d03e639426b010f67f979c25f2eca536a2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157541))
- [Integrate Topology Service Gem into GitLab](https://gitlab.com/gitlab-org/gitlab/-/commit/85b5ebad3270be134664b32fff6abc9f1aa5faba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159778))
- [Add Disable Personal Access Tokens setting to Admin Settings UI](https://gitlab.com/gitlab-org/gitlab/-/commit/69e79c2417768d587d46f165f061d291264b9a8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159953)) **GitLab Enterprise Edition**
- [Add job count metric for pipeline execution policy](https://gitlab.com/gitlab-org/gitlab/-/commit/c6a9782fc3fd616be39bae139d63bc422ba73236) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159957)) **GitLab Enterprise Edition**
- [Add Mattermost version 9.10 to releases table](https://gitlab.com/gitlab-org/gitlab/-/commit/58f8ae203a7dbdd951ee4a93d3e90465ee624952) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160782))
- [Remove search_add_fork_filter_to_zoekt FF](https://gitlab.com/gitlab-org/gitlab/-/commit/2fd10fdc2b7695939593d807e0f242d1399ba316) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159434)) **GitLab Enterprise Edition**
- [Add mutation to convert note to thread](https://gitlab.com/gitlab-org/gitlab/-/commit/4be15fe60571de2b98d35f7e355cab9d4c3ffd88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160556))
- [Filter merge requests by target branch](https://gitlab.com/gitlab-org/gitlab/-/commit/0d0aa0bd462ee7b11f534960fcab199668316c0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160210)) **GitLab Enterprise Edition**
- [Add Virtual Registry cached responses table](https://gitlab.com/gitlab-org/gitlab/-/commit/a40e49525546072bf8cbeece8d6b1c2bf6996361) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157055))
- [Add models for Virtual Registries, part 1/2](https://gitlab.com/gitlab-org/gitlab/-/commit/3df26ae0cd0dde0d189a9d9bae491ee68992ba7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157793))
- [Add Duo Enterprise to cloud connector configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/551d12fd2be730b98333195412cc0775a1b6aaa0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159749)) **GitLab Enterprise Edition**
- [Set reserved_storage_bytes in the node_assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/b8fccf89e0a13c895217d38b32c7f704d3380c99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159736)) **GitLab Enterprise Edition**
- [Add pull_frequency to control the tasks pulling frequency](https://gitlab.com/gitlab-org/gitlab/-/commit/8b9a2db425f36bf253311f9c270591be4c30f9a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160575)) **GitLab Enterprise Edition**
- [Adds support for Matrix notification integration](https://gitlab.com/gitlab-org/gitlab/-/commit/8b5e7fb6fe8434b2f79bcef9b5ed2521217e8ea5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160223))
- [Adds last_dormant_member_review_at to namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/99e270842d83ba399de05c627c409f5c911d7152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157924))
- [Add "source" property of jobs to Jobs API, GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/05b7f5664fc67215585e2b1c394f27d5a8238c36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159798))
- [Add delete pod functionality](https://gitlab.com/gitlab-org/gitlab/-/commit/058e7216a3f7163f33c9c40b707199f3e6ebf7f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160299))
- [Allow custom roles to be assigned to invited groups](https://gitlab.com/gitlab-org/gitlab/-/commit/e5405a6262003bee18f28977dbf85131e5045212) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159213)) **GitLab Enterprise Edition**
- [Remove wiki front matter related feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/03318de85c6af137a07db0a4671a4e4f4eda73f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160557))
- [Add approval policy rules and projects link table](https://gitlab.com/gitlab-org/gitlab/-/commit/09b792ba4927003588f71bc919f82207750d7b40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158441)) **GitLab Enterprise Edition**
- [Add Java Spring tutorial for o11y usages](https://gitlab.com/gitlab-org/gitlab/-/commit/c37f32a3a7594a449d4eb262f9d3a80d9c5888f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159922))
- [Rollout code_suggestions_skip_dependency_descriptions ff](https://gitlab.com/gitlab-org/gitlab/-/commit/b9c3b7dae4c5655865d560491df920d6a60f13de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160572)) **GitLab Enterprise Edition**
- [Persist all policy types for security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/6187254025fc727ba49f1c6f13f1f660084ef238) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159891)) **GitLab Enterprise Edition**
- [Support organization_path for determining current organization](https://gitlab.com/gitlab-org/gitlab/-/commit/c2863a831ed823d46f9e649ae29b22583c7dc3bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160543))
- [Add delete pod functionality](https://gitlab.com/gitlab-org/gitlab/-/commit/2cc1c7d3d60341e5093cc68727f646a3ab4c6f6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160117))
- [Remove merge_trains_viz flag](https://gitlab.com/gitlab-org/gitlab/-/commit/93f2ac6ef3647a6c601100da4dd57fce97622a8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160262)) **GitLab Enterprise Edition**
- [Show SBOM reports ingestion errors on the vulnerability report](https://gitlab.com/gitlab-org/gitlab/-/commit/55657c338f2074e2d7599602233ec860abb2dbcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158672)) **GitLab Enterprise Edition**
- [Reindex issues from database](https://gitlab.com/gitlab-org/gitlab/-/commit/91dea118cd2d686b69351792d82aaeceb2947442) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158039)) **GitLab Enterprise Edition**
- [Skip the tasks with same project_identifier](https://gitlab.com/gitlab-org/gitlab/-/commit/3bcad7cec1dccf668c8b5842850122c6baa29ddc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160240)) **GitLab Enterprise Edition**
- [Schedule DORA DF score recalculation](https://gitlab.com/gitlab-org/gitlab/-/commit/4a915e05d7642bdbc1993eb48d2670dec2f303bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160259)) **GitLab Enterprise Edition**
- [Add Django tutorial for observability tooling](https://gitlab.com/gitlab-org/gitlab/-/commit/9870eeabc48249acb2dee16e2830e1bbd4dbf1b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159440))
- [Show Flux resource details](https://gitlab.com/gitlab-org/gitlab/-/commit/f4797359bc9b842544dfac6b4516a6a51197cb20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158461))
- [Add CreateSecurityPolicyProjectAsync mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/d054075713dd54c1a00a3d9de281be1a8fb686a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158028)) **GitLab Enterprise Edition**
- [Emit audit event for agent creation and deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/ad7c7231ca2f2f3731e45f8e04f59c16973219b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159593)) **GitLab Enterprise Edition**
- [Add for_occurrences and with_advisory scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/2e79bcccb8c2be27688ad1baa6b96971e248581e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158791)) **GitLab Enterprise Edition**
- [This MR adds new column to external status checks](https://gitlab.com/gitlab-org/gitlab/-/commit/e1ba61f12574d8e0a31f9bbdc108d04448b3aa7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159745)) **GitLab Enterprise Edition**
- [Add the syntax decoration for multi_match](https://gitlab.com/gitlab-org/gitlab/-/commit/9ff6b14262e9605ce863f9d4cbf82bf844272606) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160046)) **GitLab Enterprise Edition**
- [Add filtering by max role on members pages](https://gitlab.com/gitlab-org/gitlab/-/commit/b099444065af138549d19958f5cfa15a11f53b32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158651))
- [Expose source_url in API::Entities::BulkImport](https://gitlab.com/gitlab-org/gitlab/-/commit/719b157f365f360849944b751b486e23fec2c35a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159756))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/05d22b38a15b24a539e205a2893775c7ba29cca6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160009))
- [Add metrics for pipeline execution policy usage](https://gitlab.com/gitlab-org/gitlab/-/commit/8a12f0b6d087f2e4296b6f41af7c15752fa3257c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158675)) **GitLab Enterprise Edition**
- [Add pagination support for Hierarchy widget](https://gitlab.com/gitlab-org/gitlab/-/commit/2f294b429cbde49b27be93d4f610f3ca47685413) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159598))
- [Add index for purl_type and package_name on](https://gitlab.com/gitlab-org/gitlab/-/commit/8bcc04073e3dcb8f54eeff496cc6f68e74083311) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158792))
- [Feat: manual variables tab frontend part one](https://gitlab.com/gitlab-org/gitlab/-/commit/2d4e7c27ad3fe9cbdb60461fe05b07fd9298d4a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159206))
- [Release inheritance feature for Integrations API](https://gitlab.com/gitlab-org/gitlab/-/commit/b28f767ea3e4788c1cbc5decc72f9ea78ba1c1c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159773))
- [Add filtering active and human users in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/ae7620b37f89b30dc37be3085211545a16261691) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159200))
- [Sync namespace_settings seat_control with new_user_signups_cap](https://gitlab.com/gitlab-org/gitlab/-/commit/49c816f9b628caf97d0c373d16b8446625fc671a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159466))
- [Add job action mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/6280733dc6485b26476974fafb213ddfb9781cae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159750))
- [Add nodejs tutorial to Observability docs](https://gitlab.com/gitlab-org/gitlab/-/commit/2747dcf1046391de17faa5a8c4963fa6b4898188) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159321))
- [Add detumbled_email column to emails table](https://gitlab.com/gitlab-org/gitlab/-/commit/920d107da487537522e2e76afd05963c8dc1a460) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159658))
- [Deprecation alert for Needs tab](https://gitlab.com/gitlab-org/gitlab/-/commit/da2eae2e81830e4ecc095be890375ce1e6aaadb0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159636))
- [Adds fix slash command](https://gitlab.com/gitlab-org/gitlab/-/commit/df8449bdb0427c43d9a363b831c32a7e760b0347) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158918)) **GitLab Enterprise Edition**
- [Add org to sbom source](https://gitlab.com/gitlab-org/gitlab/-/commit/1715cedb49c2506d5fca15d704d3f86d36821477) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158485)) **GitLab Enterprise Edition**
- [Add member_role_id to group_group_links](https://gitlab.com/gitlab-org/gitlab/-/commit/85cd7275e9c3d8bf00e03a3cd75cd978345a2f44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157256))
- [Add filters to import source users Graphql resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/4367038ba3b29ffbd35adb2c05d560ee87770e12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157710))
- [Added .cjs & .mjs matching to SAST CI templates](https://gitlab.com/gitlab-org/gitlab/-/commit/1c9bc1bdd489a05571f49ee2c49feadff76f203b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158767))
- [Access runners via `admin_runners` permission](https://gitlab.com/gitlab-org/gitlab/-/commit/6a49cd658821da314c257b4664965a93bec0a0bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156840)) **GitLab Enterprise Edition**
- [Add job action mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/d3acd6b46aa6d4ee3883c1d9ed2cf84bce82bb2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159143))
- [Add mergeTrainCar to MergeRequestType](https://gitlab.com/gitlab-org/gitlab/-/commit/f85136af4fcb10b3c0c2be3f692a8f9bbdd23a0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158832)) **GitLab Enterprise Edition**

### Fixed (143 changes)

- [Revert "Refactor lavel filter to use labelName attr"](https://gitlab.com/gitlab-org/gitlab/-/commit/a9940b2fdadc92945033a672ad7013f2761afab1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162463)) **GitLab Enterprise Edition**
- [Fix empty dependency list page](https://gitlab.com/gitlab-org/gitlab/-/commit/d6e287a8105b9b82df47901dfb2afccd842d7a0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162352)) **GitLab Enterprise Edition**
- [Fix bug with pasting retina images](https://gitlab.com/gitlab-org/gitlab/-/commit/b6b5d92918da5101d6247d984abdf6e9b7a3785a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161676))
- [Hide invalid closing issues on merge request](https://gitlab.com/gitlab-org/gitlab/-/commit/fb158fa6ae8e2203afb4bd4ac8c82854dc064835) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161940))
- [Fix text on badge for health check](https://gitlab.com/gitlab-org/gitlab/-/commit/0e35d794ea5f0ea1ddc9401702b85ce8b6e5d782) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162309)) **GitLab Enterprise Edition**
- [Kubernetes agent access for protected branches: Mention feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9eca5ac0b5544050f69557245c1cb7b5de0fb5dd) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162221))
- [Fix repo instructions border radius](https://gitlab.com/gitlab-org/gitlab/-/commit/ca58515ac6ea566f04cd8ac54d3ef7c1fcfd2db2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162210))
- [Project Admin - Fix delete project after email message](https://gitlab.com/gitlab-org/gitlab/-/commit/6e68238a418b05cbfec6cda8e4fe79056dde58ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162095))
- [Unify branch protection on rules details with repository settings](https://gitlab.com/gitlab-org/gitlab/-/commit/35bfcc2fa4ba9f6d5abc016988391a9faf372e7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161924)) **GitLab Enterprise Edition**
- [Fix wrong project in the connect command](https://gitlab.com/gitlab-org/gitlab/-/commit/ffab6b684b4a2309fba41b5c240eda718e91037d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162025))
- [Fix installable scope for inherited classes](https://gitlab.com/gitlab-org/gitlab/-/commit/9db09c1ed732c5ddbef44a3ec4dfb56dc9311683) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161203))
- [Prevent re-enabling project sharing when user cap is set](https://gitlab.com/gitlab-org/gitlab/-/commit/42a9fc58c416ca2c6a81df5ed4e93994014c785b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161655)) **GitLab Enterprise Edition**
- [Add Heading 5 and 6 to text style dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/834f2ce2e15b05dabc1c736b4ae01f95bfefb0ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162090))
- [Fix model artifact upload bug](https://gitlab.com/gitlab-org/gitlab/-/commit/4713c757ed46320eb41bcf58d60a035a2cb51f02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162080))
- [Properly handle empty repository.ff_merge in FromTrainRef merge strategy](https://gitlab.com/gitlab-org/gitlab/-/commit/e76a9f9e773459e338b69557ef813cbe626216d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162077)) **GitLab Enterprise Edition**
- [Update synthetic note](https://gitlab.com/gitlab-org/gitlab/-/commit/a286542db4637a333ff79f9c56851777cb795be3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161815))
- [Frecent Items - Use fullPath over webUrl](https://gitlab.com/gitlab-org/gitlab/-/commit/7d2ff723041450d47634e57c34be436d774e06eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161024))
- [Fix feature flag check for](https://gitlab.com/gitlab-org/gitlab/-/commit/dfe1ea1c64dffcbf9c12f409a198cc2cc264a77d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161764)) **GitLab Enterprise Edition**
- [Fix policy scope checker for multiple project compliance frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/22a09c812866fad423333c220d48b3b97d62a8b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162058)) **GitLab Enterprise Edition**
- [Fix quick action urls in work items](https://gitlab.com/gitlab-org/gitlab/-/commit/5c89d2b552bc7ba59cdd9b0a8f2ac843bdc79f31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160202))
- [Catch BlockedUrlError when dispatching external status check](https://gitlab.com/gitlab-org/gitlab/-/commit/fc6e01679ca2cfa8967551e7ddfddacfbf5f13a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161652)) **GitLab Enterprise Edition**
- [Add correct check method for ga ai features](https://gitlab.com/gitlab-org/gitlab/-/commit/d3a92a962900782f1f8fca700c62c87169740c1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161779)) **GitLab Enterprise Edition**
- [Add license check to cs for registry](https://gitlab.com/gitlab-org/gitlab/-/commit/ae0a44e86a5ff061d0082b5f5bd1df84ffa2a83e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161771)) **GitLab Enterprise Edition**
- [Fix work item parent links namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ab928d1dcd2eedbdcf3d9dbe60637cf9e98c2878) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160264))
- [Delete existing policy reads for invalidating policy edits](https://gitlab.com/gitlab-org/gitlab/-/commit/af6ddb0a40f529916d875fa80bffcb6664176ea9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161324)) **GitLab Enterprise Edition**
- [Fix removing conan manifest recipe file by cleanup policy](https://gitlab.com/gitlab-org/gitlab/-/commit/225d6dd534f1a91b5472608bed748294e81bea79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160728))
- [Fix timestamp values in Arkose Data Exchange payload](https://gitlab.com/gitlab-org/gitlab/-/commit/bcf4a3a219eb7cf26dd1f9b914a23f1e79b09711) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161562)) **GitLab Enterprise Edition**
- [Handle invalid webhhook receiver gzip response](https://gitlab.com/gitlab-org/gitlab/-/commit/25ac407627261ceb02167cc5aa60685281652c1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161842))
- [Adjust alignment of codeblock "Copy code" button](https://gitlab.com/gitlab-org/gitlab/-/commit/2a6897e0a177267c85e058c372c46e03ead03e2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161835))
- [Make full log viewer section parsing more strict](https://gitlab.com/gitlab-org/gitlab/-/commit/ce307719f1c556e70925d855d9621c720863f5fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161158))
- [Exclude deleted projects from GetProjectsQuery](https://gitlab.com/gitlab-org/gitlab/-/commit/7313f4f624d9b983c212751d08ab38535e7a1662) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161762))
- [Fix vulnerability statistics bug](https://gitlab.com/gitlab-org/gitlab/-/commit/aef900932dbb52e8669719c7b13425e6351d9ecb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160541)) **GitLab Enterprise Edition**
- [Fix missing dependency project dropdown on narrow screen width](https://gitlab.com/gitlab-org/gitlab/-/commit/335412bf3aadabdeaf77207140d1d658f3cc8f70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161153)) **GitLab Enterprise Edition**
- [Backfill verification state table only for enabled replicators](https://gitlab.com/gitlab-org/gitlab/-/commit/0935b5f1c632980c134f3a15a1807949eb956e3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161378)) **GitLab Enterprise Edition**
- [Enable project_daily_statistic_counter_attribute_fetch FF by default](https://gitlab.com/gitlab-org/gitlab/-/commit/2617928c9542ce5d44a00251a510269815058edb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161498))
- [Mark projects as vulnerable in CVS logic](https://gitlab.com/gitlab-org/gitlab/-/commit/461023e6a28b04734c4ef5e96a44e60a2eac28ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161178)) **GitLab Enterprise Edition**
- [Fix train removal toast](https://gitlab.com/gitlab-org/gitlab/-/commit/cfbea1c00b83deea20b45c5bb74c9667a4feccd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161080)) **GitLab Enterprise Edition**
- [Fix SBOM merge report service when merging tools of mixed structure](https://gitlab.com/gitlab-org/gitlab/-/commit/49c68f2033407b0ebf6c129ae57e9c1e31b0d74b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161066)) **GitLab Enterprise Edition**
- [Fixes `output_safety` in integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/3df8c5399a59af1c2d5bb15fc42f20df869e93b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161443))
- [Fixes disable style ANSI sequences in full log viewer](https://gitlab.com/gitlab-org/gitlab/-/commit/16502a77d87ade28d14578ef0895dc078a4e90ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161438))
- [Atomically refresh branch/tag cache in PostReceive](https://gitlab.com/gitlab-org/gitlab/-/commit/d19fbcf8f0a0f7fa059720e0b61e8ee280066c69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160946))
- [Handle error when create directory params are missing](https://gitlab.com/gitlab-org/gitlab/-/commit/79ff2da0a892a1f7eea28a3f42f2eeee0fc96c9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161038))
- [Add a batch migration to nullify organization_id for Project snippets](https://gitlab.com/gitlab-org/gitlab/-/commit/a1a7caeff584797876a64671ee32ba3c8a0f363a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160838))
- [Project Topics - Allow new topics created always](https://gitlab.com/gitlab-org/gitlab/-/commit/b3c8922ebbbfc21d2fbf303225562fd35d8ffef3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160759))
- [Fix broken docs links in the UI](https://gitlab.com/gitlab-org/gitlab/-/commit/0c502a88a54a12c14b588536ec26a5922ea58de2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160965))
- [Fix segmented export zero division error](https://gitlab.com/gitlab-org/gitlab/-/commit/1f4379f4be883b6dbc90e2467099d538e833b017) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161294)) **GitLab Enterprise Edition**
- [Fix custom role name for admin user views](https://gitlab.com/gitlab-org/gitlab/-/commit/385c945918b821956c6214b3a87af4ff20836069) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160366)) **GitLab Enterprise Edition**
- [Break words in legacy user dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/5d3ae67dcfb9e86e64742902264d611cc30d37f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161220))
- [Use generated identifier for chart range data](https://gitlab.com/gitlab-org/gitlab/-/commit/7761273551a9d7d13a0416a816725399dd4cd442) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161138)) **GitLab Enterprise Edition**
- [Allow to edit files from a commit or tag with WebIDE](https://gitlab.com/gitlab-org/gitlab/-/commit/cf6e2631e509259dc4d4ca63dca765e693817618) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159557))
- [Ensure DiffCollection is not empty when applying each_gitaly_patch](https://gitlab.com/gitlab-org/gitlab/-/commit/d516b1c598271ebfa55549e2d1b56f7f27cf9904) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160120))
- [Fix cluster check metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/d101b7b50d36e4d68617d79cef91fc5d88f1fb58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161042)) **GitLab Enterprise Edition**
- [Fix missing CSS variables in jira_connect app](https://gitlab.com/gitlab-org/gitlab/-/commit/340652cf2fdf0bef6d6a8208e4864423ad77b0d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160998))
- [Fix toggle replies widget regression](https://gitlab.com/gitlab-org/gitlab/-/commit/05621599c66336b00abdba8b41f85083b0d643ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161136))
- [Update graphql specs in preparation of gem upgrade](https://gitlab.com/gitlab-org/gitlab/-/commit/5a133c589ef180d0237bd1b81efab2d1d76a23a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160406))
- [Cleanup allow_custom_root_folder_name_in_npm_upload FF](https://gitlab.com/gitlab-org/gitlab/-/commit/5b6b6659dec396e0c9facd94186aaa185dbda9f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161004))
- [Fix upload after comment preview bug](https://gitlab.com/gitlab-org/gitlab/-/commit/eebcd541b2b9b3685a7026c0306d30df3aa7b7c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161085))
- [Do not index associated issues that are epic work item type](https://gitlab.com/gitlab-org/gitlab/-/commit/fad44730896ff5920f3b89c7f7a5df554579a280) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160656)) **GitLab Enterprise Edition**
- [Re-add no-enforce-focus prop on checkout modal](https://gitlab.com/gitlab-org/gitlab/-/commit/2adad9bdc19b6b836ae7fbee19bcc0eaffb8b7a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161059))
- [Internationalize dates within issues](https://gitlab.com/gitlab-org/gitlab/-/commit/e8f58926e4f9b17fc998b3e09e17903975df3a14) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161058))
- [Fix tooltip for suggested similar issue state icon](https://gitlab.com/gitlab-org/gitlab/-/commit/bdc2287eb511c1f20fe65563b46e40b8dbcb4e1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161062))
- [Add a validation for default branch name in group settings](https://gitlab.com/gitlab-org/gitlab/-/commit/09c12b0d76231cedec2288c10212c838fad1612f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160220))
- [Mark project as vulnerable while creating vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/b3d83e367d12584b3b39a5c597de9616f4c18f05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160851)) **GitLab Enterprise Edition**
- [Ignore not search params which are not hashes](https://gitlab.com/gitlab-org/gitlab/-/commit/fb65f91d89d823a33ff1dd96aeb03f77d5d7f0b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160801))
- [Fix help icon shrinks when there are many code owners](https://gitlab.com/gitlab-org/gitlab/-/commit/69741fd1307e49d800d130885b494c9b369e512d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161006)) **GitLab Enterprise Edition**
- [Fix clear bug in create view for health status widget](https://gitlab.com/gitlab-org/gitlab/-/commit/001c2b00045996c3ed888dcafa44841e058f2ff8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160863))
- [Add clipboard btn hover state to checkout MR instructions](https://gitlab.com/gitlab-org/gitlab/-/commit/202759422141aac7fc5940ac2ba22bcda5d77eb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160901))
- [Fix Explain vulnerabilities with AI loading state](https://gitlab.com/gitlab-org/gitlab/-/commit/da739d45d24b8f0f32e24d90aa5e52270728062a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160295))
- [Fixes `output_safety` in integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/25826806ac0eb5a8afc25ed4a4e65be66717306b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160889))
- [Use explicit rule names to avoid flaky specs](https://gitlab.com/gitlab-org/gitlab/-/commit/accc6b0a9bb40c59dcf3b5598d38bf7a69de7e49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160436)) **GitLab Enterprise Edition**
- [Fix GraphQL query returning less than expected projects](https://gitlab.com/gitlab-org/gitlab/-/commit/cc852530b1cef3cdea49ddeb941c3483c6ea55dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160592))
- [Update specs for upcoming graphql upgrade](https://gitlab.com/gitlab-org/gitlab/-/commit/2982d156ae61506528f040b7aeaee6c6c4acf1b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160768)) **GitLab Enterprise Edition**
- [Update publish a new release docs link](https://gitlab.com/gitlab-org/gitlab/-/commit/c6e22939a560e089d31e562700b487ac17d34663) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160298))
- [Make sure broadcast notifications do not affect broadcast message height](https://gitlab.com/gitlab-org/gitlab/-/commit/9d4d284a27b016cdb9733b210b8699988f99d537) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160787))
- [Reset request data on each filter](https://gitlab.com/gitlab-org/gitlab/-/commit/2063f10ea6248b68b9e481ccf128bcfba70764d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160789))
- [Fix Roadmap not loading when epics have private parents](https://gitlab.com/gitlab-org/gitlab/-/commit/9804dc275b031fb562ce9ef4ddebbc2030a26ae6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160785)) **GitLab Enterprise Edition**
- [Fix new epic work item email](https://gitlab.com/gitlab-org/gitlab/-/commit/d59aaf9efebdfda702d39d750e711af11161e7a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159153))
- [Add missing breadcrumb items to several admin edit pages](https://gitlab.com/gitlab-org/gitlab/-/commit/5bd35d91018780ea85d66b6e8d0f467d7fff4f41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160584))
- [Update graphql specs for coming upgrade](https://gitlab.com/gitlab-org/gitlab/-/commit/8f18df634e45c5fe4b7b39f589a18fcb03b028f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160256))
- [Fix badges in runners admin area](https://gitlab.com/gitlab-org/gitlab/-/commit/dbeb6854984f16d9590cad145a86ffcaccbb8ea9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160201))
- [bug: Fix template error due to divided by zero](https://gitlab.com/gitlab-org/gitlab/-/commit/6932a73ea7174eb718c41dd0f743aba7d3f9b133) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160628))
- [Use autolinker filter for commit descriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/88559d7f2cb9f3360f336f8bab86735ed95e3150) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160653))
- [Drop sequences that should no longer exist in database](https://gitlab.com/gitlab-org/gitlab/-/commit/5bc47e37a4a3e624f3b1eacb722b712e1f76a978) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160624))
- [Ignore unknown sequences in sequence fix migration](https://gitlab.com/gitlab-org/gitlab/-/commit/61497ca0b7591a3791c2fef46ac3356438301b38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160609))
- [Fixed Zoekt forks filter behavior](https://gitlab.com/gitlab-org/gitlab/-/commit/805a046c5bb39e04e233bc20219a1ebd9f8cd761) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159893))
- [Scrub non-UTF characters from context chunk](https://gitlab.com/gitlab-org/gitlab/-/commit/85997d78685e1af62ef5c5c7e8970f517579eb07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160580))
- [Add support for redirects to go-get middleware](https://gitlab.com/gitlab-org/gitlab/-/commit/41104091f54467e5cb0f8a144b1d88e29845229f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160571))
- [Update postgres_sequences view](https://gitlab.com/gitlab-org/gitlab/-/commit/a001714616c26794c658ceacff0f360730ee02a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160555))
- [Break words in code blocks in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/f8a4afd302a195949ab23df03e44c89eb88ee6de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160550))
- [Fixes `output_safety` in integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/25169f31d4f1797943337fbdcd7cd2e6e35ffca3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160535))
- [Fix project name truncation in dependency project count dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/100812c841c252385d6f360c7b87a866fcf2a40d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160363)) **GitLab Enterprise Edition**
- [Fix SQL query for finding sequences owned by table](https://gitlab.com/gitlab-org/gitlab/-/commit/8273652656c573060f403864c123f46128873f4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160528))
- [Use a separate Redis key for rescheduling jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/83584a23b2de403dd7d86a3c07aa8ae96339ebae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159215))
- [Prevent CS SBOM to be parsed as ready for License Scanning rules](https://gitlab.com/gitlab-org/gitlab/-/commit/19c0c8025de3c20510a7a4c22f4f49d3646019d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158831)) **GitLab Enterprise Edition**
- [Clear Gitlab::Geo.proxied_site memoization](https://gitlab.com/gitlab-org/gitlab/-/commit/23e6703d77d0164a8ac78c18d39834f9872956aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160479)) **GitLab Enterprise Edition**
- [Fix clear button in deprecated jQuery dropdown filter](https://gitlab.com/gitlab-org/gitlab/-/commit/47160352e1c0c080f74622881f092657eb7e3550) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160419))
- [Restrict project ID parameters for GAR setup scripts](https://gitlab.com/gitlab-org/gitlab/-/commit/a1d0936d27905409436ea27331e5ee044c1ffbf9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156701)) **GitLab Enterprise Edition**
- [Connect null data points in Value Stream Dashboard sparklines](https://gitlab.com/gitlab-org/gitlab/-/commit/681a79ee8bae85910a6790f5ba88c2fac868555f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160444)) **GitLab Enterprise Edition**
- [Skip issue due date validation on work item epics](https://gitlab.com/gitlab-org/gitlab/-/commit/da9436fd59253b263f6808bc4d6144ce2e101522) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160442)) **GitLab Enterprise Edition**
- [Update graphql specs in preparation of gem upgrade](https://gitlab.com/gitlab-org/gitlab/-/commit/42b63e3b66a9691660411320109b064cf8694d29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160421))
- [Restore collapsible sections in job log viewer](https://gitlab.com/gitlab-org/gitlab/-/commit/5ccb81bb681661056ebed90c0aa56607f40e9d8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160403))
- [Improve image resizing in rich text editor](https://gitlab.com/gitlab-org/gitlab/-/commit/21afdd759ad5b38cc0380614c68742baa357723d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160357))
- [Fix auditor permission in group VSA](https://gitlab.com/gitlab-org/gitlab/-/commit/5a9cb9f6e1be36c18933040d1b30aa0292e53ddb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159530)) **GitLab Enterprise Edition**
- [Fixed empty tooltips in usage trends count charts](https://gitlab.com/gitlab-org/gitlab/-/commit/085d947a0626d0a29afae2af4cb55501d7cf68c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159906))
- [Keep hover effect on section title when flyout is hovered](https://gitlab.com/gitlab-org/gitlab/-/commit/7d6865ec054d109b07352747d41d6d6c51ddb301) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160233))
- [Fix missing spdx licenses in the policy editor](https://gitlab.com/gitlab-org/gitlab/-/commit/c95a042e5ad9cac89c30d71d18bd8aadde570789) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159889)) **GitLab Enterprise Edition**
- [Fix duplicated projects in listbox](https://gitlab.com/gitlab-org/gitlab/-/commit/412a8488278f13c29461c4015f6739a4b54e69e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160065))
- [Status badge: Fix use of icon](https://gitlab.com/gitlab-org/gitlab/-/commit/5296f6d0a605bd1bf3e0c2ec2cc714ea47cf5a20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160028))
- [Fix bug with deployment score calculation](https://gitlab.com/gitlab-org/gitlab/-/commit/5b047ec1624d65cb61b47c02c14fe3cd4456c7f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159875)) **GitLab Enterprise Edition**
- [Fix approval policy to include group level protected branch](https://gitlab.com/gitlab-org/gitlab/-/commit/a5e6851bd08555219e538718c00331722186b074) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157301)) **GitLab Enterprise Edition**
- [Fix publishing npm package with custom root folder name](https://gitlab.com/gitlab-org/gitlab/-/commit/cd68d1cfa9c3458edf7e14daa2ef63c687326e76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159095))
- [Handle Browser::Error exception](https://gitlab.com/gitlab-org/gitlab/-/commit/72ac5e90bb88c9f28f16b11c9653cf06249ce074) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158800))
- [Remove project_ref_name_in_variables FF](https://gitlab.com/gitlab-org/gitlab/-/commit/966cad99bf60f18ea0f2a2c8080829dfb5bcbd64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160190))
- [Fix missing/incorrect linked work items from other namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/cd8e42f29ac741f54c9ed290020fd8f64627b8fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160181))
- [Fix SBOM export when tools property has different structure](https://gitlab.com/gitlab-org/gitlab/-/commit/f0197f5a9fb5b085288ae3cee9f0627b14f05c4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159456)) **GitLab Enterprise Edition**
- [Fix PEP when SEC is available](https://gitlab.com/gitlab-org/gitlab/-/commit/ca0d7833a0c6d47484428d7ec3dc30bb51389d29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159845)) **GitLab Enterprise Edition**
- [Add validation for vulnerability identifiers](https://gitlab.com/gitlab-org/gitlab/-/commit/c96afeb84597ad77eb91e4ca4e66faa7ab31d040) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160011)) **GitLab Enterprise Edition**
- [Improve printing functionality](https://gitlab.com/gitlab-org/gitlab/-/commit/678ea62e707229b257aaa8f7b4361ce687827487) by @yanglb ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157906))
- [Added Instance scope as valid audit entity type](https://gitlab.com/gitlab-org/gitlab/-/commit/15e37257e930e862678c916e23027c3ea2081506) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157271)) **GitLab Enterprise Edition**
- [fix: Only run advanced SAST job when Ultimate license present](https://gitlab.com/gitlab-org/gitlab/-/commit/7f932fed45120a5ac122e513651e3ee78b185ece) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159238)) **GitLab Enterprise Edition**
- [Pipeline dropdown: Fix spacing and border-radius](https://gitlab.com/gitlab-org/gitlab/-/commit/486b7eb4159f23abe1d07f96d8f02859e7a8ef66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159760))
- [Add copy timelog logic when moving issue](https://gitlab.com/gitlab-org/gitlab/-/commit/352306f235d22a7a56338df397791fddea46d663) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159860))
- [Use SpinnerComponent in users groups/projects view](https://gitlab.com/gitlab-org/gitlab/-/commit/b3f354bef03c94a57a2d72abc6d6052c6eab824b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159820))
- [Remove padding if sections settings have no border](https://gitlab.com/gitlab-org/gitlab/-/commit/46962e77d9c8544a94459d5a86df186f30955b26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159791))
- [Fix merge request list icon alignment in Safari](https://gitlab.com/gitlab-org/gitlab/-/commit/28092994d3a91183c059e6ab97e3a157a1284abe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159788))
- [Updates container registry set up cleanup link](https://gitlab.com/gitlab-org/gitlab/-/commit/9f0f237a3c59aadb844a46bb38ba874528ede8db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158015))
- [Fix invalid X-Next-Page header for the first page](https://gitlab.com/gitlab-org/gitlab/-/commit/4b56a5d22e781f80ab1545f430ee472d3ac0e72d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159747))
- [Provide a full commit sha to `CommitReferences` query](https://gitlab.com/gitlab-org/gitlab/-/commit/3d0c244844cd0beae6dc34c816d8f5dbff49b5b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159719))
- [Remove full screen button at ML Model creation](https://gitlab.com/gitlab-org/gitlab/-/commit/1099e7ae1e30149478bd5e7f3f2f130832c238ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159554))
- [Remove uplaods and redirects file results from wiki basic search](https://gitlab.com/gitlab-org/gitlab/-/commit/b2f141946446f70d2c3ddd0ad36c9a3e8a7d35e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159219))
- [Ignore default before and after_script for Scan Execution Policies](https://gitlab.com/gitlab-org/gitlab/-/commit/0e2d85a7875cac86767cbe4d7f083f31adfadfda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159486)) **GitLab Enterprise Edition**
- [Prevent dragging board list if not editable](https://gitlab.com/gitlab-org/gitlab/-/commit/c08b156ae647b446a36e0b31378713d67a191ac5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159605))
- [Prevent export finalisation from overrunning the expected duration](https://gitlab.com/gitlab-org/gitlab/-/commit/c5cab9f41e62c38382435447a2b1b78990bc29da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159546)) **GitLab Enterprise Edition**
- [Release jira_connect_proxy_create_branch](https://gitlab.com/gitlab-org/gitlab/-/commit/554284bd4fb94e6f15f8a68f682643139eca1087) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159413))
- [Display all seats user banner when there is an overage](https://gitlab.com/gitlab-org/gitlab/-/commit/8db6684a285f4bfed1014d7c0bb17670ec9a6452) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158718))
- [Revert "Align the visual presentation of the action between groups and projects"](https://gitlab.com/gitlab-org/gitlab/-/commit/88b48fc9d3c7bd12265d37dfb288ea39852cd374) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159499))
- [Your Work Projects - Fix improper index import](https://gitlab.com/gitlab-org/gitlab/-/commit/e38ffb1b3520e94b1744dbfa27ee98b91f45d657) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159465))
- [Make sure group path is used for getting list of frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/114fb8a7f17917a0d8234830c3f52017359a4b72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159367)) **GitLab Enterprise Edition**
- [Fix pending members member link](https://gitlab.com/gitlab-org/gitlab/-/commit/98d559247cf5dc0d4febdc5f12e90d6261766999) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159134)) **GitLab Enterprise Edition**
- [Show download button in narrow viewports in repo directory view](https://gitlab.com/gitlab-org/gitlab/-/commit/7f8a534bcb1b890c7bdb8e56c5ba24ca395a6fe7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159157))
- [Fix namespace path in pending members page](https://gitlab.com/gitlab-org/gitlab/-/commit/272a00240a33fd79a4bcf784eb3793fda1784ccf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159132)) **GitLab Enterprise Edition**
- [Use shared lock for SBoM ingestion and sync workers](https://gitlab.com/gitlab-org/gitlab/-/commit/f1cb744debcf70d4c963da5e720d7b894fa647e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158816)) **GitLab Enterprise Edition**
- [Fix Changelog error on Non-encoded Commit Trailers](https://gitlab.com/gitlab-org/gitlab/-/commit/8a650540c9b5489dc4113d837107637052cb73ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158191))

### Changed (226 changes)

- [Ignore unused columns in onboarding_progress and remove all references](https://gitlab.com/gitlab-org/gitlab/-/commit/698a09cd4fe20ae5dc5ebdc071787b5a35419d81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160892))
- [Enable self-managed UI bulk assignment/unassignment feature by default](https://gitlab.com/gitlab-org/gitlab/-/commit/883062561bee9758dc58d1389a0c66adcf1da0d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162405))
- [Enable traversal_ids for all project search queries](https://gitlab.com/gitlab-org/gitlab/-/commit/8875e07dc46f47c2ef9850bb958f131d5c27c00b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162198)) **GitLab Enterprise Edition**
- [Improve Cloud Connector status host probe](https://gitlab.com/gitlab-org/gitlab/-/commit/9f8b013f28da0a4c79a80443a5e9c9ae364717f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162141)) **GitLab Enterprise Edition**
- [Transition dast_site_tokens to loose foreign keys](https://gitlab.com/gitlab-org/gitlab/-/commit/06123667885295db935337ab8427c19e73982199) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160996))
- [Lower sync event table partition cleanup threshold to 30 days](https://gitlab.com/gitlab-org/gitlab/-/commit/1a46844e42523294f5230b6a944602da7748dd49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162273))
- [Hide search panel when user has no groups](https://gitlab.com/gitlab-org/gitlab/-/commit/202b36099a2c405302972e97ac5c13c3234c4c4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162034))
- [Requeue backfilling of work_item_dates_sources](https://gitlab.com/gitlab-org/gitlab/-/commit/7ab3e1ccd60899b7f90a0cd1fd38f8d8d0197a0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161847))
- [Show empty state also in workspace tab](https://gitlab.com/gitlab-org/gitlab/-/commit/c2cec3dc520a517eb5e9e06e46e0982c138b5c55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161690))
- [Migrate title and cards in ssh key detail page](https://gitlab.com/gitlab-org/gitlab/-/commit/af3934ac4e70ce8a70a5d1838e7151d4d4f22fae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162340))
- [Add database index on emails to detumbled_email column](https://gitlab.com/gitlab-org/gitlab/-/commit/f0b244c043f4a37b17dd35261f09c6a05eced163) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162336))
- [Find zoekt index through repository if exists](https://gitlab.com/gitlab-org/gitlab/-/commit/dff4adad7a479232c6872f0ea0119d06788ed768) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161212)) **GitLab Enterprise Edition**
- [Groups Projects - Consistent pending delete alert](https://gitlab.com/gitlab-org/gitlab/-/commit/a247405bce52d3b55daa84f07c1670d68f902d29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161653))
- [Makes job log color palettes consistent](https://gitlab.com/gitlab-org/gitlab/-/commit/691ad73b603e3e119ac4f20b5f90a027b2f1d278) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161742))
- [Remove redirect to clear settings for self-managed provider](https://gitlab.com/gitlab-org/gitlab/-/commit/9f1600129a4ace031258439d2a029f2c30625804) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160669)) **GitLab Enterprise Edition**
- [Scheduling service skips cache in non prod environments](https://gitlab.com/gitlab-org/gitlab/-/commit/406e1b9820fb609dab033456bb086978f610f014) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161104)) **GitLab Enterprise Edition**
- [Add framework id popover](https://gitlab.com/gitlab-org/gitlab/-/commit/2b65c268bb82c4a0f8608e9dfcc6aaa8799ad9b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162037)) **GitLab Enterprise Edition**
- [Update redis-store gem and drop custom patch](https://gitlab.com/gitlab-org/gitlab/-/commit/0463deff4d61c5c2017983061041898e3c30999d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162257))
- [Expose pre_receive_secret_detection_enabled in the API](https://gitlab.com/gitlab-org/gitlab/-/commit/e740fe906623db3184ca26ddbbe8b601a0df5374) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160960))
- [Remove gl-new-card-body from terms card](https://gitlab.com/gitlab-org/gitlab/-/commit/7dd7bc64c0e13ca414e1797c910b168370d8c862) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162204))
- [Migrate branch rule details cards to crud components](https://gitlab.com/gitlab-org/gitlab/-/commit/6b3507fce557908e4c3259f1befb46c28155ba6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161965))
- [Remove `Security::ReportFetchService` and refactor tests](https://gitlab.com/gitlab-org/gitlab/-/commit/6fdfd67dab49af358fe288684827234c470a6f9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161944)) **GitLab Enterprise Edition**
- [Default-enable Cloud Connector status FF](https://gitlab.com/gitlab-org/gitlab/-/commit/4362d74ea185b10ada3bbe1661ca44c5eb4d4ec8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161997)) **GitLab Enterprise Edition**
- [Enable rewrite_history_ui feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/d0876ad33fdf10e0bc6bb7713d8153b7c4fd04ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162057))
- [Adjust the visual styling of health check](https://gitlab.com/gitlab-org/gitlab/-/commit/c8697c35679108f467286e3e3371ba48802d272b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161928)) **GitLab Enterprise Edition**
- [This MR adds an icon for disabled policies](https://gitlab.com/gitlab-org/gitlab/-/commit/5b767435aaa8dc97299117ddf43455d89e6b0ec7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162040)) **GitLab Enterprise Edition**
- [This MR adds new badge to status check table](https://gitlab.com/gitlab-org/gitlab/-/commit/93f8988fe2caa22346144b3ddc6ac03aed57b5ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160652)) **GitLab Enterprise Edition**
- [Quarantine spec for old background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/54ff5d0fbb9f9d0e1e23b4dd455657eb9aafa86f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162167)) **GitLab Enterprise Edition**
- [Update terraform empty state illustration](https://gitlab.com/gitlab-org/gitlab/-/commit/bd6e1d28f62002e296b56b67d304101f42b680ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162164))
- [Notifications page: Migrate components used](https://gitlab.com/gitlab-org/gitlab/-/commit/5920871c2472b94dba3f2b6b5bedc1dfc9885669) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161592))
- [Update tags page](https://gitlab.com/gitlab-org/gitlab/-/commit/eb40d8e51dab2d4a906bf11daf9d4c079dcc6f29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162045))
- [Update blocked and blocking icons based on new direction](https://gitlab.com/gitlab-org/gitlab/-/commit/19b73359acbeb7fb43188ab2723abc5806e6e4bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161348))
- [Remove gl-new-card from permanent group deletion card](https://gitlab.com/gitlab-org/gitlab/-/commit/c772ee673ccdd704c2d3f1dfe385f11600b94834) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162104))
- [Move work item note loader above comment box](https://gitlab.com/gitlab-org/gitlab/-/commit/2d15743b9ba81ebe30f6db136a1580ba09a7050b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161604))
- [Remove gl-new-card from failed jobs card](https://gitlab.com/gitlab-org/gitlab/-/commit/c749280c64383d1cdce65f30fc758c1cf7d374ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161897))
- [Switch back to charlock_holmes gem](https://gitlab.com/gitlab-org/gitlab/-/commit/5caab73fb59a5e8d7c5f76a3c87037204b9bbd80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162078))
- [Set vulnerability_finding_links schema to `gitlab_sec`](https://gitlab.com/gitlab-org/gitlab/-/commit/46969d0b2709ac910dd73a20b7e5a15d096de738) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159122)) **GitLab Enterprise Edition**
- [Replace subtle text color style with description label default style](https://gitlab.com/gitlab-org/gitlab/-/commit/ce07132763cb187d1d2c93dafd05cd8caa344c45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162053)) **GitLab Enterprise Edition**
- [Remove gl-new-card from pipeline editor card](https://gitlab.com/gitlab-org/gitlab/-/commit/5b94235f6fcd255f7df0a35ab792db0ad2e53269) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161941))
- [Distinguish index on tags](https://gitlab.com/gitlab-org/gitlab/-/commit/13eb9e4cac6f818a22aefe725c06d4783ede7d8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161644))
- [Remove gl-new-card from group advanced settings](https://gitlab.com/gitlab-org/gitlab/-/commit/40a0b210d920389fbccf9e3c20344b24fce9739c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161838))
- [Rephrase policy bot message errors](https://gitlab.com/gitlab-org/gitlab/-/commit/0ba0f9c1c018bfd1bef97fd2360c843447756bfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161920)) **GitLab Enterprise Edition**
- [Removes the note about billing quotas on the PA GitLab managed provider](https://gitlab.com/gitlab-org/gitlab/-/commit/344ada30e40c3bd856217c8b9665f70e971ed4f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161921)) **GitLab Enterprise Edition**
- [Decrease space between log lines](https://gitlab.com/gitlab-org/gitlab/-/commit/2dfff64d856f3cda3a682039deb67e961b94ed75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161912))
- [Avoid TemplateFinder instantiations](https://gitlab.com/gitlab-org/gitlab/-/commit/6c0766720ebb27e36499dd05a78dbc6492a93736) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157781)) **GitLab Enterprise Edition**
- [Remove search_issue_refactor feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/567bbc5e97bbe2f2aa2c5c717e400a45b5adeb26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161521)) **GitLab Enterprise Edition**
- [Unbox the add license section](https://gitlab.com/gitlab-org/gitlab/-/commit/722f7fe1347ea9e34eeb6943e0ade7441de79f65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161852)) **GitLab Enterprise Edition**
- [Move provider selection component error state inline](https://gitlab.com/gitlab-org/gitlab/-/commit/d163db4412b742978bce724dae7d67eb52f4e026) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161109)) **GitLab Enterprise Edition**
- [Add header to contributor analytics page](https://gitlab.com/gitlab-org/gitlab/-/commit/017a8d9686c4ec029aa6bcbab0110d620171cdb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161831))
- [Sentence case access tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/7365a54f6a894383cb92a18b8a4920bb860df38f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161074))
- [Refine the activation modal](https://gitlab.com/gitlab-org/gitlab/-/commit/61df41e649bc52e7dc0af2b4e5c1a33dc5a25d30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160314)) **GitLab Enterprise Edition**
- [Migrate terraform states GlCard to CrudComponent](https://gitlab.com/gitlab-org/gitlab/-/commit/09f23a94404c980b55309f37fbc62ccc5d09d7a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161520))
- [Release page: Add page title and migrate to Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/665fd2c65a8e62e51c928ce0c499db3cc0fc5f98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161568))
- [Sign-out deletes only GitLab site data, not all subdomains](https://gitlab.com/gitlab-org/gitlab/-/commit/29e70fb405d8fdbf91bc3bf89dadd5250692a734) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156213))
- [Add email template for source_user rejects](https://gitlab.com/gitlab-org/gitlab/-/commit/7369619d5a390e7fabc9e15c145260440b7449ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161811))
- [Cleanup "add_validation_for_push_rules" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c4fd830334ca39e90a28de77c960cbdd6661930c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161800)) **GitLab Enterprise Edition**
- [Make color palettes in logs consistent](https://gitlab.com/gitlab-org/gitlab/-/commit/7e5232715a3aaa17786825a07766a937be7f7248) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161461))
- [Fix dark mode support in minimal and devise_empty](https://gitlab.com/gitlab-org/gitlab/-/commit/58e1cc3430f6b6671309cc0e73cdd6a34c54afd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161780))
- [Replace click with select on add license](https://gitlab.com/gitlab-org/gitlab/-/commit/2180a21b05465d8f5c62860eedecde8b42b7ffc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161499)) **GitLab Enterprise Edition**
- [Migrate workspace variables card to CrudComponent](https://gitlab.com/gitlab-org/gitlab/-/commit/8937f5c9e770e80ec7fba10e3c763fccc4c1e10d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161650))
- [Remove new-card classes from legacy cards](https://gitlab.com/gitlab-org/gitlab/-/commit/c6c71116c85f78a262151b9df652e704fea251c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161637))
- [Fetch product analytics project settings via GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/313ab63ccbdb8b563b054a31fc9c64236a8d4d6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160657)) **GitLab Enterprise Edition**
- [Hide /type quick action on epic work items](https://gitlab.com/gitlab-org/gitlab/-/commit/d9bf8cb58041ff9fb707965366ab150549f1c384) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160735)) **GitLab Enterprise Edition**
- [Simplify atomic cache/tag clear code in PostReceive](https://gitlab.com/gitlab-org/gitlab/-/commit/095a409a5e58806b8ae43d6f48f07d77a739f2a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161673))
- [Migrate dashboard projects to filtered search and sort](https://gitlab.com/gitlab-org/gitlab/-/commit/fc0906105ebfa2795b05462bcc2eaf128c815fec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159462))
- [Refactor DuoChat error display](https://gitlab.com/gitlab-org/gitlab/-/commit/3f0856245771bfd7c50ab89b7e6315af65ed370b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161508)) **GitLab Enterprise Edition**
- [Fix broadcast message dismissals cookie not restoring upon login](https://gitlab.com/gitlab-org/gitlab/-/commit/39a47e6ea6c5c1aa2103a809ec310282c0a040cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161363))
- [Update review started icon in MR sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/3418c7e6e673271fe788450c30362f0da9e1b51e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161617))
- [feat: Transition sbom_component_versions to gitlab_sec schema](https://gitlab.com/gitlab-org/gitlab/-/commit/3959cfcf93682c141465592416b36ce52c61fe83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160583)) **GitLab Enterprise Edition**
- [Deploy freeze table migration to Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/f79db328fd1c02d0020db5d333c35bed77140ee7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161339))
- [Update visualization designer type selector](https://gitlab.com/gitlab-org/gitlab/-/commit/bfe99c1ae785c14041cfd37daddb93db7a77ac79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161314)) **GitLab Enterprise Edition**
- [This MR updated dispatch service](https://gitlab.com/gitlab-org/gitlab/-/commit/e4933958b7d7115774f032f11beb9e7b2af49bc1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160507)) **GitLab Enterprise Edition**
- [Comments templates: Migrates components used](https://gitlab.com/gitlab-org/gitlab/-/commit/5976954c3935387921b834403574dd78fb41d70e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161301))
- [This MR adds new field to status check form](https://gitlab.com/gitlab-org/gitlab/-/commit/bb41b50f586a4636e7edee110293aeda4183c9d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159822)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.100.2](https://gitlab.com/gitlab-org/gitlab/-/commit/6d6d2e4f85a6688ac958d862691c864434574093) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161554))
- [Transition dast_site_tokens to loose foreign keys](https://gitlab.com/gitlab-org/gitlab/-/commit/b4d0172260ee9d6f5577358c3ae5122883a3fe49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160199))
- [Update CI/CD Details tab order](https://gitlab.com/gitlab-org/gitlab/-/commit/14bd72dd7aac1e4d166f3180ead7b9c266d09bff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161548))
- [Use locale date format on the custom emoji page](https://gitlab.com/gitlab-org/gitlab/-/commit/b6245df118994558bc8ec8edd0e27ac784f91074) by @NIKU-SINGH ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161361))
- [Migrate wiki history card to crud component](https://gitlab.com/gitlab-org/gitlab/-/commit/8a56eb0c5f71ee98d0625580737cb92693972878) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161528))
- [Migrate branch rules card to CrudComponent](https://gitlab.com/gitlab-org/gitlab/-/commit/dc3180bac8336a2ef62084db533c682009fa2cbd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161460))
- [Update work item parent labels](https://gitlab.com/gitlab-org/gitlab/-/commit/9fc03497ef12ee95a8df23e9c92ba8c875ccd26e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161070))
- [Show warnings for rendered as markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/3679ede136173bfbd3b9e99f5acc64de0f87628d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160431))
- [Update gitaly servers card to CrudComponent](https://gitlab.com/gitlab-org/gitlab/-/commit/44060e9ea82de216cb7e96916075127b71f5f19f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161344))
- [Display error when LLM determines false positive](https://gitlab.com/gitlab-org/gitlab/-/commit/66c998b228e2c8c3e4abb843a4a1e7124199423c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161190)) **GitLab Enterprise Edition**
- [Update cleanup policies page](https://gitlab.com/gitlab-org/gitlab/-/commit/b6010fd7151214d1718df2a102174510616d42a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161313))
- [Migrate badges card to crud component](https://gitlab.com/gitlab-org/gitlab/-/commit/421861f25380548e26617487f7a63c1f7746bf90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161229))
- [Add `fallback_behavior` usage metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/cddeb2e9a797b37cb8a460803eac1d48a51fb600) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155718)) **GitLab Enterprise Edition**
- [Update welcome page question order](https://gitlab.com/gitlab-org/gitlab/-/commit/643b26800c6780f0a5babc0d039b36876ac60cc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159444)) **GitLab Enterprise Edition**
- [Migrate secure files to cardcomponent](https://gitlab.com/gitlab-org/gitlab/-/commit/6d2a08fb01c607b97b7db25762fe1aa21ad04991) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161374))
- [Update prompt for Duo Vulnerability Resolution](https://gitlab.com/gitlab-org/gitlab/-/commit/1ac066bbe73f72b954966be411f6ba7f964d3c4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160098)) **GitLab Enterprise Edition**
- [Reverse order of recent month columns in VSD](https://gitlab.com/gitlab-org/gitlab/-/commit/8ca9d55964e39bfa031a51dd72dd82ed2c1ee501) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154954)) **GitLab Enterprise Edition**
- [Update google-cloud-core and google-cloud-env gems](https://gitlab.com/gitlab-org/gitlab/-/commit/4e1867aeebb2a4342691a85b47282f6105eda4d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161377))
- [Migrate monitor alerts to crudcomponent](https://gitlab.com/gitlab-org/gitlab/-/commit/a99e38028de1517e03f4db29cc2fe9a2ed5306d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161370))
- [Duo Chat Retry Attempts Update](https://gitlab.com/gitlab-org/gitlab/-/commit/1d5a1735577206b317c8496d716d03aead64676c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160476)) **GitLab Enterprise Edition**
- [Does not load SSF data for disabled replicators](https://gitlab.com/gitlab-org/gitlab/-/commit/55b8934563926e368f5c4a0cd6050e4867e34976) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160623)) **GitLab Enterprise Edition**
- [Update security policies graphql API to filter policies by scope](https://gitlab.com/gitlab-org/gitlab/-/commit/2a2958de528d65757fbb4de08289e75240bf8106) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160477)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.100.1](https://gitlab.com/gitlab-org/gitlab/-/commit/6cc2f06dff1a02a8e89631259a07af5a53f5b055) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161347))
- [Set vulnerability_flags schema to gitlab_sec](https://gitlab.com/gitlab-org/gitlab/-/commit/64e2b22478352cea29e4ef2b5697bf029fd6d725) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159115)) **GitLab Enterprise Edition**
- [Update cached commit signatures when a gpg key is recreated](https://gitlab.com/gitlab-org/gitlab/-/commit/0894447ad584ef1413266a3d63e8e0ed651a99bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160928))
- [Reverify externally verified gpg keys](https://gitlab.com/gitlab-org/gitlab/-/commit/4c311635e7496889282fb78782fdcf8d463ce925) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160910))
- [Add DuoChat helper menu](https://gitlab.com/gitlab-org/gitlab/-/commit/55ffd22a8dd35ade39ceea260d25c41d711089fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161025)) **GitLab Enterprise Edition**
- [Fix issue on terms page with mermaid plots](https://gitlab.com/gitlab-org/gitlab/-/commit/f37420f31c3c87052a35658c89a7b4954b3625c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161152))
- [Update user pages empty states in admin area](https://gitlab.com/gitlab-org/gitlab/-/commit/d4a00c6321d4a9a8fd53f9462bb4e32be39beca1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161216))
- [Add tmp index on vulnerability_reads for bbm](https://gitlab.com/gitlab-org/gitlab/-/commit/f754febe795aa5b4b6f545ca6c9b367b65c39069) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161296)) **GitLab Enterprise Edition**
- [Update merge request template copy](https://gitlab.com/gitlab-org/gitlab/-/commit/2ff26859ba57d2e7e8841f0dd75e2c3b17510c06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161283)) **GitLab Enterprise Edition**
- [General improvements in the terms pages](https://gitlab.com/gitlab-org/gitlab/-/commit/e5920242c4864c063b51b9a39027ac9e6c1045d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142685))
- [Change the alert message for the invalid invite](https://gitlab.com/gitlab-org/gitlab/-/commit/11287453ffe669db3df40a50375af9aecc1109c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160950))
- [This MR updates approval selector](https://gitlab.com/gitlab-org/gitlab/-/commit/bad89d95f0dac575068509d3c49cbb89729f9c0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160809)) **GitLab Enterprise Edition**
- [Migrate Analyze page headings](https://gitlab.com/gitlab-org/gitlab/-/commit/71c2ca629bce456430346ef364cd4ceebee98841) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160726))
- [Update BBM status](https://gitlab.com/gitlab-org/gitlab/-/commit/17c45e8fcbfb86a9e00ec66f8743026822af85dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160630))
- [Use `gl-text-subtle` instead of `gl-text-secondary` in crud component](https://gitlab.com/gitlab-org/gitlab/-/commit/8821e026827589c125bfc20314a58d6f07bd9b90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161077))
- [Migrate header components in tags and compare revisions](https://gitlab.com/gitlab-org/gitlab/-/commit/875d821590c89f9a077e052e9abae95d25ff5561) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161028))
- [Add "Why GitLab Duo?" section to Duo Pro trial discover page](https://gitlab.com/gitlab-org/gitlab/-/commit/f8ebda46dc5686524aa0f491a72ae33916ea9bcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158977)) **GitLab Enterprise Edition**
- [Refactors primary keys validations](https://gitlab.com/gitlab-org/gitlab/-/commit/3ea64fe7089678eb5cde609d008eb18d13dcb18f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160953)) **GitLab Enterprise Edition**
- [Labels: Migrate label-badge](https://gitlab.com/gitlab-org/gitlab/-/commit/8d2a4747b7edae00afdb154b037e809c23f497e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160833))
- [Remove MemberRole ignored columns](https://gitlab.com/gitlab-org/gitlab/-/commit/ab060799371aa52a269f18f82f90488d31ce4ffa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161194)) **GitLab Enterprise Edition**
- [Issue closing pattern works with work items](https://gitlab.com/gitlab-org/gitlab/-/commit/a9d873c24cca2a764fbebd66ed4091c73b354b43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160324))
- [Update runner edit form](https://gitlab.com/gitlab-org/gitlab/-/commit/33b05d6188f771e27257e9288c33912a42a60bd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159733))
- [ViewComponent documentation: Adds missing shared components](https://gitlab.com/gitlab-org/gitlab/-/commit/ced85c7d8521c2b14d45860820a6bc8dc6618f6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161176))
- [Humanize chart units for Value stream analytics](https://gitlab.com/gitlab-org/gitlab/-/commit/ce546a174ae20738fd6ef1e6d3d492cd345823a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160907)) **GitLab Enterprise Edition**
- [Hide pending todos authored by banned users](https://gitlab.com/gitlab-org/gitlab/-/commit/fb81783ed470d4daf9d3139797df4a79d531fa48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159542))
- [Hide rollup weight when null](https://gitlab.com/gitlab-org/gitlab/-/commit/3d1cdd20f6d6a5c9e474c66b6de2856a202f8176) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160198))
- [Returning multiple compliance frameworks in project api](https://gitlab.com/gitlab-org/gitlab/-/commit/cbcaa2a0049eae52c47fa30c8eb2b9a5cefa4e19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160530)) **GitLab Enterprise Edition**
- [This MR adds new arguments for graphql mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/da72b64f0d963d5ae3cb14bc17fe5824820f0c22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160225)) **GitLab Enterprise Edition**
- [Check for feature flag for user autocomplete in command palette](https://gitlab.com/gitlab-org/gitlab/-/commit/d311e2c52503a64ae9dffb3deecf2eef8cab78c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160780))
- [Put groups_direct field in CI JWT tokens behind feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/88080c3c48ee15f62b5603e82126478e05d63470) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161075))
- [Sentence case pipeline editor](https://gitlab.com/gitlab-org/gitlab/-/commit/b86778f66b3c1d22913fa9bf95d343fb515557b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161054))
- [Issue Analytics: Migrate title and optimize loading state](https://gitlab.com/gitlab-org/gitlab/-/commit/e7ef12569b97d179f27cf00c929cefd9ff071b94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160723))
- [Switching default_enabled: true for RCA troubleshoot](https://gitlab.com/gitlab-org/gitlab/-/commit/36490f7a84aecee3b9cb625c5bd1fa97e507ae03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160771)) **GitLab Enterprise Edition**
- [Ensure Current.organization is set in REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/4ef855e8b2807e8701c68ec6e3ea01cb8ac65d3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161008))
- [Add delimiter to label counters](https://gitlab.com/gitlab-org/gitlab/-/commit/628c71dc278373010a02d7b554a23d028fa1aa27) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161026))
- [Open k8s details drawer on the pod name click](https://gitlab.com/gitlab-org/gitlab/-/commit/8324e9b4670c2c6243e24a29adab31966cd3178e) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160684))
- [Set schema to gitlab_sec](https://gitlab.com/gitlab-org/gitlab/-/commit/0d39800d66aff7e2fbdbc1d79d687aea73f7d3ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159111)) **GitLab Enterprise Edition**
- [Use header components and sentence case in code section](https://gitlab.com/gitlab-org/gitlab/-/commit/65ff3eb7a22a507c8d35ce91f5a4dfe22f1fddd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160926))
- [Update error pages](https://gitlab.com/gitlab-org/gitlab/-/commit/adc5ab9e2fa5f97b4c197750373821e301f3baa0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160374))
- [Pipeline mini graph clean up](https://gitlab.com/gitlab-org/gitlab/-/commit/cdc96fc55810d49dacb063af7110175d3106b91a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160807))
- [Use page heading component for new snippet](https://gitlab.com/gitlab-org/gitlab/-/commit/b05ea722a1168f8293822c5701ab48e584fcc474) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160923))
- [Update pipeline editor to replace external link icon with catalog icon](https://gitlab.com/gitlab-org/gitlab/-/commit/a7430167da4ae15891dd03ada46e796a80c65b33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160873))
- [Search bar: Migrate buttons to GlButton](https://gitlab.com/gitlab-org/gitlab/-/commit/87054eb6b7348077bc9341540100cfd75c212609) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160717))
- [Use CrudComponent for labels lists](https://gitlab.com/gitlab-org/gitlab/-/commit/85f8ca06b7ae3dbb9e1ada1e4c77af70b8db05c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160613))
- [Applys pending promotion requests](https://gitlab.com/gitlab-org/gitlab/-/commit/4c469555ae07d92b2c7cb7fdcfceb6e9dee67d7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157783)) **GitLab Enterprise Edition**
- [Move glab ask endpoint to AI gateway](https://gitlab.com/gitlab-org/gitlab/-/commit/390a9ae4b7039ceb48d6177fd90ccbe39a0defcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159150)) **GitLab Enterprise Edition**
- [Update stackprof to v0.2.26](https://gitlab.com/gitlab-org/gitlab/-/commit/cfe5d3fb7cbd1828149257a7cff3bc849d29d846) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160760))
- [Remove add_gitlab_tier_cookie feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/aa42f38d513a85dc04a4fbfcec614bf95536243c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160651)) **GitLab Enterprise Edition**
- [This MR adds new field for update service](https://gitlab.com/gitlab-org/gitlab/-/commit/3e50f7947ecb448968c57d7562cc65418d04e4ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160542)) **GitLab Enterprise Edition**
- [Applications group settings: Migrate components](https://gitlab.com/gitlab-org/gitlab/-/commit/347de302c259da7b78e4e4199d34a5836a8dd0be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159712))
- [Hooks: Update components](https://gitlab.com/gitlab-org/gitlab/-/commit/61cfd3475c458246eab94163c6899f44a740ced6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159438))
- [Redirect to group page upon user acceptance](https://gitlab.com/gitlab-org/gitlab/-/commit/9eae662aa4835699e06b41235b682ee15af52e6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157233))
- [User permissions for ML model registry & experiments](https://gitlab.com/gitlab-org/gitlab/-/commit/b77dc5b6d54f29430bd7426c2fa863ca5790fdf3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160074))
- [Update user achievements](https://gitlab.com/gitlab-org/gitlab/-/commit/67ecce4a20eabb4b16d40813cd662a69244d4f47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160318))
- [Switch indexing button to background job](https://gitlab.com/gitlab-org/gitlab/-/commit/61fbea70bd9ed76c9b99a46482abeb5b4c8ce963) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160231)) **GitLab Enterprise Edition**
- [Set default state of web_ide_oauth flag to enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/7f8199c85286ccd3178381ce4128bd8f18597a85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160597))
- [Migrates to use SettingsSection and Crud Components](https://gitlab.com/gitlab-org/gitlab/-/commit/486b652a96a9d90b83ad657639a115e3c80c1d2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159737)) **GitLab Enterprise Edition**
- [Configure ignoring default before and after_script for policies](https://gitlab.com/gitlab-org/gitlab/-/commit/e8a8dca501c4d558cd9164269dfab403c05f79c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160466)) **GitLab Enterprise Edition**
- [Remove updated at from work items](https://gitlab.com/gitlab-org/gitlab/-/commit/7d83705189ff4445fa0dd07ca2beb11f8cc50ed3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160126))
- [Replace toggle by radio buttons in the CI/CD settings](https://gitlab.com/gitlab-org/gitlab/-/commit/a63702b0f539c47743c7a1cd2fb1287f84b0e4d6) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160078))
- [Repository settings: Migrate components](https://gitlab.com/gitlab-org/gitlab/-/commit/948b57de3f2f6179da988755f3d0b0037c95df37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159543))
- [Update help text for job token setting](https://gitlab.com/gitlab-org/gitlab/-/commit/554b690091b4f8b047a43f730ef31633d2ffb631) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160523))
- [Cleanup `prevent_registration_from_china` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8e19ddd00908a47135801d680dc75607d21098e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160495)) **GitLab Enterprise Edition**
- [This MR adds new field for external_status_check model](https://gitlab.com/gitlab-org/gitlab/-/commit/e2a314d44af156bae5bdab8741166e94359ff4a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159983)) **GitLab Enterprise Edition**
- [Update OpenID and OAuth2 gems](https://gitlab.com/gitlab-org/gitlab/-/commit/ac734f14580a8d7df75bc95626c26cbc856144c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160480))
- [Clean up SafelyChangeColumnDefault for policy concurrency](https://gitlab.com/gitlab-org/gitlab/-/commit/b5a7d97318e1571ca5b4f80135fdffefcd7da190) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160467)) **GitLab Enterprise Edition**
- [Update illustration for work item empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/55263d1ac13565534ae7079a3260a739cad6bc26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160294))
- [Remove default value from `organization_id` field for snippets](https://gitlab.com/gitlab-org/gitlab/-/commit/d30d70d32d624b567d771886c1baf70fb02b4ef1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160048))
- [Add approval rule: Move action buttons to content](https://gitlab.com/gitlab-org/gitlab/-/commit/d173febd0f2c03e2191038e5c786a9474f84bb65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159883))
- [Fix icons on commit page](https://gitlab.com/gitlab-org/gitlab/-/commit/beaf426c4f43592c924e1e9f6e0e8625b34986fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160396))
- [Cleanup bigint conversions](https://gitlab.com/gitlab-org/gitlab/-/commit/ddab2c93d7e5be7f6c4d13fb162b187d2b096c0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159364))
- [Fix profile passed to API Security analyzer](https://gitlab.com/gitlab-org/gitlab/-/commit/8949379ff133b45876edaa545b77fa1c9bb90bb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160373)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.100.0](https://gitlab.com/gitlab-org/gitlab/-/commit/f68d99a66e9cc2bd35cfe368e8029f6b338c679f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160350))
- [Lock logger version to 1.5.x series](https://gitlab.com/gitlab-org/gitlab/-/commit/e8139571b743d4574ef842e1f76bdab8f65f989d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160349))
- [Apply a daily limit for duplicate credit card validations](https://gitlab.com/gitlab-org/gitlab/-/commit/2f1e488617f0a8271f926b5e8107b0565ff238c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159151))
- [Remove gl-block class on badge](https://gitlab.com/gitlab-org/gitlab/-/commit/1cc0125fc322919ee037a2e87daf943095f1a4d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160336))
- [Validate presence of Organization on Namespace model](https://gitlab.com/gitlab-org/gitlab/-/commit/525dc03ccae2e67a76be4e25a58eb9abca3b56dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155732))
- [Shows releases on group milestones](https://gitlab.com/gitlab-org/gitlab/-/commit/e56ec6fd67e2442f77e680573e66451c9e132857) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159276)) **GitLab Enterprise Edition**
- [Auto close issues for group level issues defaults to false](https://gitlab.com/gitlab-org/gitlab/-/commit/0ade607e188e6abd2301d632929f909c3f38f8c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159459))
- [Analytics settings: Migrate to use SettingsSection](https://gitlab.com/gitlab-org/gitlab/-/commit/edbb0dd6596d6300777098c8c7ae1e6c85a6d15d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159689))
- [Use FrameworkBadge as item for the Frameworks Select](https://gitlab.com/gitlab-org/gitlab/-/commit/bded3141057241479aa70465beda7503c6891a70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159374)) **GitLab Enterprise Edition**
- [Extract authz classes to fetch permitted abilities](https://gitlab.com/gitlab-org/gitlab/-/commit/69be0c77b9ae62570b579e188072037c34d8a3b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159603)) **GitLab Enterprise Edition**
- [Remove deprecated observability_tracing feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/fa72bf51cfb0f223325de5dc8a04670f3a1bc98d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159775))
- [Enable sorting by published_at for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/59e4b952861c9095e93d374576875e90e8a977a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158701))
- [Clarifies the availability of dormant user feature](https://gitlab.com/gitlab-org/gitlab/-/commit/6b3d67fdd45dab0891fe4caf87fa69ba7f3e58ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160235))
- [Remove `optimized_vulnerability_report_export` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9c24e864cb897dc11cd110fa09ee685befc3f98e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160071)) **GitLab Enterprise Edition**
- [Update Duo Pro card on Usage Quotas page for trials](https://gitlab.com/gitlab-org/gitlab/-/commit/ec4501c475c1138534ea98a21107a03e1dcb41d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158497)) **GitLab Enterprise Edition**
- [Show newest linked items first](https://gitlab.com/gitlab-org/gitlab/-/commit/268104cda6d2abe906a646ceeda6c731911642bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160068))
- [Add ai_custom_models_prompts_migration FF](https://gitlab.com/gitlab-org/gitlab/-/commit/f058a82aceea43613f7e762393d75e084544c7f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160050)) **GitLab Enterprise Edition**
- [Migrate Integrations settings pages](https://gitlab.com/gitlab-org/gitlab/-/commit/af38e396c271c57a6a272c0d5241a0a2123ebaeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159411))
- [Update source_users/show copy and UI](https://gitlab.com/gitlab-org/gitlab/-/commit/6aa9a2c335ec023b74a9159a57e527374b757556) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159209))
- [This MR updates dropdown text](https://gitlab.com/gitlab-org/gitlab/-/commit/ce338e329084ef1b22236905aa30b8fac5ec3f13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159487)) **GitLab Enterprise Edition**
- [Rename Gitlab::Geo. replication_enabled_replicator_classes](https://gitlab.com/gitlab-org/gitlab/-/commit/0796156fa17cf1b8eb2014e27bfc961ecdcea7f5) by @sahilsarawagi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160140))
- [Reduce the verbosity of package_metadata logs](https://gitlab.com/gitlab-org/gitlab/-/commit/b5f5cf636ad917f376bc319f88693bc4fbe6b042) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157809))
- [Add new child work items to the start](https://gitlab.com/gitlab-org/gitlab/-/commit/5b152445c612ca9296293804c2db7319e0499185) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159854))
- [Update the tooltip text on the deployment limits message](https://gitlab.com/gitlab-org/gitlab/-/commit/1a6cb618f6a286035ffdd047feb11cbdd4dde1fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160019)) **GitLab Enterprise Edition**
- [Don't send commit messages from the FE if they're untouched](https://gitlab.com/gitlab-org/gitlab/-/commit/5611eb006ecb4056b538f13c15310761c7bb37b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158881))
- [Update gems for Faraday 2 compatibility](https://gitlab.com/gitlab-org/gitlab/-/commit/49edae93a40429f6ca0311a812463488542b6952) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159692))
- [Update dependency auto-deploy-image to v2.99.0](https://gitlab.com/gitlab-org/gitlab/-/commit/cbdaaaf807718350e9cee5f9e2b3187ba478f3d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156164))
- [Group: Migrate project settings](https://gitlab.com/gitlab-org/gitlab/-/commit/a165f27fdbe2374b6b9f6b35a2aa3c03a1823d14) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159534))
- [Backfill label_ids for merge request](https://gitlab.com/gitlab-org/gitlab/-/commit/22bf678b695df0b4048e11904557e633983accfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159404)) **GitLab Enterprise Edition**
- [Migrate axios call to GraphQL mutation for jobPlay](https://gitlab.com/gitlab-org/gitlab/-/commit/4c64f4f58e93e9013b9b6f812dee83f737d1b6b1) by @missy-davies ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/140016))
- [Hides job logs timestamps on mobile size screens](https://gitlab.com/gitlab-org/gitlab/-/commit/b31c62850820c802753da8b0bcadbe184958e04f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159865))
- [Display current user's username in Identity Verification page](https://gitlab.com/gitlab-org/gitlab/-/commit/f71217ffd9ea2ba3ce2fcd286a9d2260ac33ae3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159509)) **GitLab Enterprise Edition**
- [Update dependency auto-build-image to v4.3.0](https://gitlab.com/gitlab-org/gitlab/-/commit/a13ca973d0c514bbde2a0a44785ae36950d7b470) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159826))
- [Remove elastic_index_use_trigger_indexing FF](https://gitlab.com/gitlab-org/gitlab/-/commit/00c7f57f680234b59d1a78423e6d34fad1e10442) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159435)) **GitLab Enterprise Edition**
- [Set Claude 3.5 Sonnet as code generation default](https://gitlab.com/gitlab-org/gitlab/-/commit/aaef1adb574aa6096dc03824211f52b3a44bccfc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159757))
- [Usage quotas: Use PageHeadingComponent for heading and description](https://gitlab.com/gitlab-org/gitlab/-/commit/26da70bf847fe6410e3fb8352bcf676aea305da3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159739))
- [Use tertiary  button for admin area](https://gitlab.com/gitlab-org/gitlab/-/commit/41bcbc0d3c3a908acd0aca549af45ecc4548b978) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159236))
- [Update project report for multi frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/eecfc1931ec84206b01f14a79c071238c4a33d1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158227)) **GitLab Enterprise Edition**
- [Update link to the help page on Geo health help icon](https://gitlab.com/gitlab-org/gitlab/-/commit/6c39a5a5a5bfdec053dfff4cf889e600c724ca8c) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159606)) **GitLab Enterprise Edition**
- [Fix double border at the 'Child items' widget on the Issues page](https://gitlab.com/gitlab-org/gitlab/-/commit/4e82666781f33728b4c01ab244d999cfded6d526) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158055))
- [Add new observability feature and policy](https://gitlab.com/gitlab-org/gitlab/-/commit/be32f492e66e1e99160178ff7f1b21a1aaa1ebd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158786))
- [Set vulnerability_export_part schema to `gitlab_sec`](https://gitlab.com/gitlab-org/gitlab/-/commit/683a98dc793e72c5e98e5e9efb846f741a3a09a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159118)) **GitLab Enterprise Edition**
- [CI/CD Settings: Migrates settings blocks to SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/c189858b846649bafb6bcc5a36be493dbe4c87f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159553))
- [Filter merge requests by author](https://gitlab.com/gitlab-org/gitlab/-/commit/1205630fec8d433e74f78cd3ac2fc3e70d7affaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159218)) **GitLab Enterprise Edition**
- [Project general settings: Add sr-only h1](https://gitlab.com/gitlab-org/gitlab/-/commit/f1d696da2a2c10442e50100557f1cc779c98d5ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155454))
- [Update dependency ai-gateway to v1.12.0](https://gitlab.com/gitlab-org/gitlab/-/commit/cbfa16bea6a78e8d56e9fc8148a8b2ead6a1cce6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159514))
- [Sticky header color alignment between color modes](https://gitlab.com/gitlab-org/gitlab/-/commit/082bed0368fcc2a7ad6133235aa745c38f4e27ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159508))
- [Change page title for subscription page](https://gitlab.com/gitlab-org/gitlab/-/commit/1f261e7e8d7a1f9b93b413c366211b50e994d2a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159488)) **GitLab Enterprise Edition**
- [Update UI text for require auth in MR policies](https://gitlab.com/gitlab-org/gitlab/-/commit/1f00813a763eb370e281cb64c39d256988b700f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159386)) **GitLab Enterprise Edition**
- [Advanced Search: Index label_ids for merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/dcf45f20591ed7eef522b03ca820863a8e157d98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159377)) **GitLab Enterprise Edition**
- [Update admin push rules](https://gitlab.com/gitlab-org/gitlab/-/commit/f9afe5efc4c041d6544fde876695939cc40a3fc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159007))
- [Show group stats when deleting from the Admin Area](https://gitlab.com/gitlab-org/gitlab/-/commit/80ae05fcb109bf1a6f30ae50c20654e2c4121abe) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157627))
- [Remove code behind preserve_unchanged_markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/c308788f5e1c5cb9b01c674ee2e7415b9baecdde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158759))
- [Docs: Add Cloudflare IP range info for Duo](https://gitlab.com/gitlab-org/gitlab/-/commit/10048ed55d3384fa3c69c1bfb5dbf56601464f54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159388)) **GitLab Enterprise Edition**
- [Update deploy keys pages](https://gitlab.com/gitlab-org/gitlab/-/commit/dde6d240811a37d0b9adaa7be7111580c3792380) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159142))
- [Finalizing batchedBackgroundMigration of CiPipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/10924343ec966646be32c69e63b2e26a12a0abca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158377))
- [Make policy migration context aware](https://gitlab.com/gitlab-org/gitlab/-/commit/5ad335c87e8e9b26b241bca43f7df4b55a17d1b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159244)) **GitLab Enterprise Edition**
- [Delete requires_input.js behavior](https://gitlab.com/gitlab-org/gitlab/-/commit/e24f1d5d110648cfa2326d20b6c82488177ea354) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157796))

### Deprecated (1 change)

- [Stop using PrometheusAlertPresenter from graphql and remove class](https://gitlab.com/gitlab-org/gitlab/-/commit/9cd7badde943e0f90d1ea4bbdcd43220da81a464) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160504))

### Removed (30 changes)

- [Remove required_instance_ci_template column](https://gitlab.com/gitlab-org/gitlab/-/commit/3dd223d26442309346bb8dd8977eb6d9f683789c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161992))
- [Remove link_existing_lfs_object feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c2705ed71bf177322578b6e50c57baee5cef3a29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162369))
- [Revert index on web_hook_logs](https://gitlab.com/gitlab-org/gitlab/-/commit/dca0e967fdc584c06fff069a3cb7c6cf0bd44712) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162255))
- [Delete the `enable_environments_search_within_folder` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/06f1e2d81f6ba4191c7ee3505ac43c5ac8015c2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161723))
- [Remove free-tier workspaces pages](https://gitlab.com/gitlab-org/gitlab/-/commit/a4e75fdcf098a695465041c9693ecce5a3c1ce2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161986))
- [Cleanup compliance_pipeline_in_policies feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2a713620d34a3622be245ddb2cd0c6c6315c6d3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160647)) **GitLab Enterprise Edition**
- [Delete the `changelog_commits_limitation` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/68c5a31e09320a6cc87601ea8320096e678c495a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161125))
- [Deprecated and remove continuous vulnerability](https://gitlab.com/gitlab-org/gitlab/-/commit/f7ad1897c2a05d0ac813e165498eea72ae29f90e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161337)) **GitLab Enterprise Edition**
- [Remove dependency list alerts](https://gitlab.com/gitlab-org/gitlab/-/commit/c1976aa80be607f56506056617456c1ca4736e2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161512)) **GitLab Enterprise Edition**
- [Delete the `json_wrapper_legacy_mode` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/23fb42216fd7d996d68546e34519c5c4fa0b035a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161727))
- [Delete the `order_builds_for_group_runner` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d0c8ff354c1ef4010ece31cae10edf0e3e6b35b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161725))
- [Remove gitlab_main_clusterwide and connection](https://gitlab.com/gitlab-org/gitlab/-/commit/cb0abad1ac6b11b72b412490e0b98ef36f40b646) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161017))
- [Remove custom CI action from Scan execution policies UI](https://gitlab.com/gitlab-org/gitlab/-/commit/d025790ef56689a7fd53cd07a24955408f061e72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160053)) **GitLab Enterprise Edition**
- [Removing unused project frameworks controller](https://gitlab.com/gitlab-org/gitlab/-/commit/2b32015c5275cade69ff76a175ab5347a1580900) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160531)) **GitLab Enterprise Edition**
- [Remove composer cache files related code and database records](https://gitlab.com/gitlab-org/gitlab/-/commit/428ebd23fb23f6f1add33af587b4ae129afdcc71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159861))
- [Remove wiki_size index on project statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/ada613abeedff8a55aafa08ca01ee9ab4d79c14d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158623))
- [Remove packages_size index from project_statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/51b3f7b033024a9bce769ad3c1e4363635a25dbb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158620))
- [Cleanup traces of old cron job](https://gitlab.com/gitlab-org/gitlab/-/commit/cc78eec270846f03db837c442cd05808525b5696) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160394))
- [Remove cloud license promotion banner](https://gitlab.com/gitlab-org/gitlab/-/commit/926ad333bd5ff9dbca4190c612c9b638a7d8bbd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159243)) **GitLab Enterprise Edition**
- [Chore: remove the feature flag default](https://gitlab.com/gitlab-org/gitlab/-/commit/71109150539e62321e6d6ea6592ed188655b453c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160292)) **GitLab Enterprise Edition**
- [Remove simplified_badges feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8cb69907eca0d4d8bac5396c17a53f72e4042ce1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160203))
- [Remove custom CI action from processing](https://gitlab.com/gitlab-org/gitlab/-/commit/d603f29c5366d3e6476a7b08fd75eaea0b5ac995) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159607)) **GitLab Enterprise Edition**
- [Clean up phone_verification_for_low_risk_users experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/6d5bcdf0b22f88c8456861a76c39d77361efea6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159872)) **GitLab Enterprise Edition**
- [Remove store first reviwer assignment timestamp FF](https://gitlab.com/gitlab-org/gitlab/-/commit/c3bfba614ed569c1957d09d02cfbb597af886ef6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159190))
- [Remove pipeline execution action experiment from group settings](https://gitlab.com/gitlab-org/gitlab/-/commit/bed46e0ebce7c925c8e7eea78b8ddc690b94c3c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159420)) **GitLab Enterprise Edition**
- [Remove geo_use_clone_on_first_sync feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/53ee82629c5e539eeac4c57914218b7bbb69756c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158633)) **GitLab Enterprise Edition**
- [Removes unused index on project statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/f95a5d1a59c3f0a81ed0e5844eb9953c732abd9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158614))
- [Drop temporary index on `vulnerability_occurrences` table](https://gitlab.com/gitlab-org/gitlab/-/commit/2c988d3c362b81734d22c3e95a50f641eec52497) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158726))
- [Remove Ramon related code](https://gitlab.com/gitlab-org/gitlab/-/commit/50e0327de210ccba4484e54eee23b08b4044f927) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158940)) **GitLab Enterprise Edition**
- [Remove unused arkose_labs_verify_api_url col from application_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/c250b62df565bf32c7b052b239b666a27cfb97cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159379))

### Security (22 changes)

- [Filter parameters in Rack::Attack logs](https://gitlab.com/gitlab-org/gitlab/-/commit/4565d96be79f64541c7aab68ab27f27cd58d6184)
- [Fix Possible asciidoctor include:: directive DOS](https://gitlab.com/gitlab-org/gitlab/-/commit/73f3ea94b844fbc3dfe4e6a4ef9edf3375e67360)
- [Show correct file content](https://gitlab.com/gitlab-org/gitlab/-/commit/56c91e5510ab52f5e74be40f4672ca879babfa2a)
- [Fix the catastrophic backtracking](https://gitlab.com/gitlab-org/gitlab/-/commit/9757b254a51dac68951ac12951f2e1a1e870d02a)
- [Update audit payload](https://gitlab.com/gitlab-org/gitlab/-/commit/82726dd897601e1212641d2c4d1975a4f63b1032)
- [Limit access to project accessed by Security Policy Bot](https://gitlab.com/gitlab-org/gitlab/-/commit/0de6ffe017e4b400641889ac1ea83d903265c10a)
- [Show alert about not rendering files due to path encoding](https://gitlab.com/gitlab-org/gitlab/-/commit/ba3360000e58eb8a0633cfddf94c0743b009b948)
- [Add a project scope to LfsTokens](https://gitlab.com/gitlab-org/gitlab/-/commit/de2022b4a5ee5a708454626bcadce1c50467c812)
- [Security fixes for banzai pipeline part 2](https://gitlab.com/gitlab-org/gitlab/-/commit/9a5b8ae2305b905f4ff6d92041294273b1dda4d4)
- [Remove xhtml extensions from snippets blobs](https://gitlab.com/gitlab-org/gitlab/-/commit/09d9235e3ebdff1af49863701b718a365f2baede)
- [Fix ReDoS in RefMatcher](https://gitlab.com/gitlab-org/gitlab/-/commit/71a408dd12b9a96d6713644938f59d3e7d36f738)
- [Enforce `require_password_to_approve` MR approval policy property](https://gitlab.com/gitlab-org/gitlab/-/commit/42526d753dc6ea54beb7ed7e73a222befbe3ee00)
- [Remove verify authentication token skip in cdot proxy controller](https://gitlab.com/gitlab-org/gitlab/-/commit/c34f64202a013bb6460b40c346d05120ab4182b4)
- [Fix ReDoS when parsing git push options](https://gitlab.com/gitlab-org/gitlab/-/commit/1286b58893505391bb33e915f25bcc00ea1184e2)
- [Attribute BulkImport::Export to a particular user](https://gitlab.com/gitlab-org/gitlab/-/commit/ab8e4a0d4c413daa52d65810d4fb849e03617c91)
- [Refactor import_export_upload to be user-based](https://gitlab.com/gitlab-org/gitlab/-/commit/29d4e4570f642bf0f6697a584bf4eb24be6d60e5)
- [Don't include project-level analytics settings in DOM](https://gitlab.com/gitlab-org/gitlab/-/commit/9925a8a3989b8bda4ca0c76b1002c25a911c2326)
- [Remove prohibited tags after import](https://gitlab.com/gitlab-org/gitlab/-/commit/638447ecfe01cd0c35713ec7a29350f6fde021df)
- [Fix for private dotenv artifacts not accessible to downstream jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/a52656303b62340f8cfe56bd9c9442c30973b6a7)
- [Do not allow script execution on dependency responses](https://gitlab.com/gitlab-org/gitlab/-/commit/2b160f8fa7ac30f840e38b11098499762f351f07)
- [Fix for private txt artifacts being accessible through the artifacts/browse link](https://gitlab.com/gitlab-org/gitlab/-/commit/049e1a244d4ab0d113694c878ff5a7ad0e16f4bc)
- [Disable system hooks on GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/commit/dbb3b7dc3298b67c68545e17f387e91fc7da62a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159437))

### Performance (10 changes)

- [Add preloads to AddOnPurchasesResolver](https://gitlab.com/gitlab-org/gitlab/-/commit/cf1c82daeb7c6643e872a89695841bca5710a1f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162232)) **GitLab Enterprise Edition**
- [Remove `segmented_vulnerability_report_export` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f32a63f6bb7621aac6eb0a821f1a532062ea9b10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161448)) **GitLab Enterprise Edition**
- [Do not attempt to upsert existing cvs scanners](https://gitlab.com/gitlab-org/gitlab/-/commit/71785e5153bcb06d88d24d7115a9c1f844e49e4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161360))
- [Only wait for contribution mapping related exports](https://gitlab.com/gitlab-org/gitlab/-/commit/a7c79a2304403809ae7cf33d9235166356b24db0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160398))
- [Prevent timeouts in group autocomplete query](https://gitlab.com/gitlab-org/gitlab/-/commit/b4a70fa2ec90382713f542fbc7b9931a8e28a2b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160836))
- [Skip updates for existing components and versions](https://gitlab.com/gitlab-org/gitlab/-/commit/e4f6455cea823b0c63e5c143728d7ccc5568a3d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160777)) **GitLab Enterprise Edition**
- [Refactor Nuget SearchResultsPresenter](https://gitlab.com/gitlab-org/gitlab/-/commit/8840bdb22157df8544897e707c2802153fb751d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159895))
- [Adjust Bitbucket Cloud issues worker to be resumable](https://gitlab.com/gitlab-org/gitlab/-/commit/5da77cea6b385dcc75644bf1eb56f521170cbc2b) by @ivantedja ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158472))
- [Bulk insert CVS vulnerability scanners](https://gitlab.com/gitlab-org/gitlab/-/commit/067d8440852104040c110a82c438801d8005436b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159968))
- [Remove skip_sbom_occurrences_update_on_pipeline_id_change feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8325878a2da2883fbe1af685957bfc4f855a3bb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159637)) **GitLab Enterprise Edition**

### Other (124 changes)

- [Remove double quotes](https://gitlab.com/gitlab-org/gitlab/-/commit/955a83fad07a25f7e248550589a8efe3da3a0f2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162024)) **GitLab Enterprise Edition**
- [Remove group_multi_select_tokens feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/80e2355efa8b125ef50c027a18d52a933e1058d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159187))
- [Backfill audit events into new audit events table](https://gitlab.com/gitlab-org/gitlab/-/commit/fa79983cc48ec3e8f5de4fc0e7ba67a449eae1f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158316))
- [Improve documentation for the work items reordering mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/d2c382453f0a0bba407997000cd6a8875fafb125) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162041))
- [Fix regex bug](https://gitlab.com/gitlab-org/gitlab/-/commit/873cdb555bc5a85fac76227a9ae2659d70aa7679) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162286))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1f705d566e3184bf1db0cd64949e6453c8d243d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161670))
- [Add background migration for duplicates LFS object projects](https://gitlab.com/gitlab-org/gitlab/-/commit/d6a5d684b015b322d6eb166940580eb5462d6a4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154323))
- [Use Ci::Tag model for autocomplete search](https://gitlab.com/gitlab-org/gitlab/-/commit/4b20d2a9360ff4585b14e14689cc5013cfc8bb63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161788))
- [Add PullMirrors::UpdateService](https://gitlab.com/gitlab-org/gitlab/-/commit/4fb7fb15ea47bc6decdc219d43f2571552e9813c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159240)) **GitLab Enterprise Edition**
- [Alter webhook deleted audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/6a63d4100379451da69545893a90edf80264d3a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161320))
- [Add & backfill multiple sharding keys for compliance_framework_security_](https://gitlab.com/gitlab-org/gitlab/-/commit/d2c5ad64153fdfc8d5b007f628c3c9897b122fcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160211))
- [Add resolve vulns migration](https://gitlab.com/gitlab-org/gitlab/-/commit/aa08924e3f5aa44d3ab9db3ac477bbdd31f91d78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157776))
- [Add indexed_bytes in zoekt_nodes](https://gitlab.com/gitlab-org/gitlab/-/commit/0560eef0c55622cdb37a7e656e2b567242c3cdfc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161466))
- [Add the columns size_bytes and index_file_count](https://gitlab.com/gitlab-org/gitlab/-/commit/46c29f0af0c536e5b290ccbbee1b7949e0b8afe5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161774))
- [Remove ActsAsTaggableOn from DAST profiles](https://gitlab.com/gitlab-org/gitlab/-/commit/868f2441b3a051f7c544b1390fc38b9853cddf1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161876))
- [Remove redundant test](https://gitlab.com/gitlab-org/gitlab/-/commit/fb2f26127b23974724d0de2086846fa0898fe0a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162036))
- [refactor: Avoid importing string literals in tests](https://gitlab.com/gitlab-org/gitlab/-/commit/a81d4a1ad190a691b3a873053385f256c9af5955) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161933))
- [Clean up pipeline_execution_policy_type feature flag from backend](https://gitlab.com/gitlab-org/gitlab/-/commit/086df500e9adc5f9340ecbe32a86741d447d93ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161892)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/6b0a00b44e07e839e47b33bc70b5bb73622f8520) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159314))
- [Enable ensure_lfs_object_project_uniqueness FF by default](https://gitlab.com/gitlab-org/gitlab/-/commit/76cddb8c534a2ac3fbd75cb88b721aad04c4e0b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161980))
- [Add dev widget to task work item type](https://gitlab.com/gitlab-org/gitlab/-/commit/446ac39075177ab9a2748787b495c6d924e87d54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161967))
- [Add migration for updating current value of max_yaml_size_bytes](https://gitlab.com/gitlab-org/gitlab/-/commit/f24ce23d91c7e176d4f022e0d0142f3a533bce59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161431))
- [Removes GlCarousel from the app](https://gitlab.com/gitlab-org/gitlab/-/commit/fef89135d35952a8f213393e559f4cc0a80f82d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161297)) **GitLab Enterprise Edition**
- [Validate migration schema message](https://gitlab.com/gitlab-org/gitlab/-/commit/3098145d53072df2df77d0fd718ba4d07c251863) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161884))
- [Check if columns exist before running credit card hashing migration](https://gitlab.com/gitlab-org/gitlab/-/commit/623c29e7603a1ed43c72a96e90ba5e2d15a51253) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161776))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c437ddaf05d6c3f840e2e5287fbdbe359f638fe5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161550))
- [Replace `text-tertiary` with `gl-text-tertiary`](https://gitlab.com/gitlab-org/gitlab/-/commit/b4754c76d4b5bb84ea7d3ecebc3e58bdd263566a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160615))
- [Replace cdark with gl-text-default](https://gitlab.com/gitlab-org/gitlab/-/commit/c4db50e97a20a30447d57ce89b0e159b25f7abfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160335))
- [Remove ci_canceling_status feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/299369d4bd87aba76b8b81ccdb9e2f894f1376c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160762))
- [Replace cgreen with gl-text-green-600](https://gitlab.com/gitlab-org/gitlab/-/commit/62bbd46e963dd10e272ca79c5507e350ce4bcd49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160334))
- [Replace `bg-white` with `gl-bg-white`](https://gitlab.com/gitlab-org/gitlab/-/commit/c94c4017c1f57c03eb984065b1c8f393b110218b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160636))
- [workhorse: refactor access to Gitaly Sidechannel](https://gitlab.com/gitlab-org/gitlab/-/commit/fb6f06248da06dcbef2d1aefff28055d70b72b35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161770))
- [Support expected_old_oid for UserApplyPatch](https://gitlab.com/gitlab-org/gitlab/-/commit/adfe87357d70be249df9c1e37979d2ba3c744572) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161743))
- [Enhance hand raise modal button layout for mobile](https://gitlab.com/gitlab-org/gitlab/-/commit/f51ead3ed0813535f64fc50c400db917989f4afb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161621)) **GitLab Enterprise Edition**
- [Add NOT NULL for sharding key on deployment_approvals](https://gitlab.com/gitlab-org/gitlab/-/commit/14d9a0312936dc53153dd9a7ab5cd165c6981bd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161603))
- [Add the default value for reserved_storage_bytes](https://gitlab.com/gitlab-org/gitlab/-/commit/7b6a2bca20cfb11379214c5e9b99fb3c71afdf78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161202))
- [Add and backfill project_id for error_tracking_error_events](https://gitlab.com/gitlab-org/gitlab/-/commit/18bda569ac7232cabf6d2defdb11e19cc875effc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161341))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/fb643a26d3a373088cc9100ca907dc01d870e223) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159999))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a68a2657b83bd3152bed39bed8fe25097c72b041) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161411))
- [Guard PAT last_used_at updates with exclusive lease](https://gitlab.com/gitlab-org/gitlab/-/commit/bdf32e81d10255e373586330d6709d40d2cc1d1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158577))
- [Add and backfill project_id for vulnerability_occurrence_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/6034f424aa07de35e5eb8bc6aa9ff81bd929e17b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161221))
- [Replace `text-success` with `gl-text-success`](https://gitlab.com/gitlab-org/gitlab/-/commit/cc7b971a077e624632828d870fcfce2f08d5290c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160625))
- [Add and backfill project_id for vulnerability_occurrence_identifiers](https://gitlab.com/gitlab-org/gitlab/-/commit/4dfc87cc2a59d3b5f8d73f736e4492d34d467d3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161217))
- [Update default max_yaml_size_bytes to 2 MB](https://gitlab.com/gitlab-org/gitlab/-/commit/437da1dfae66a999e5de01b05a7ade7bad57687c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160826))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2a1752df29b404ce4331bc4b81962076f97d5fdd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156998))
- [Protected packages: Push protection for deploy token](https://gitlab.com/gitlab-org/gitlab/-/commit/34eb73ead4363a37829cec0704599be9692240e9) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157098))
- [Mark 20230724070100 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/4eafef93213f45614f2dbaf10d6fc655d2de6143) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159912)) **GitLab Enterprise Edition**
- [Override for assign_resource_worker_deduplicate_until_executing](https://gitlab.com/gitlab-org/gitlab/-/commit/894eb23dbfb995a74d2e659f9c67294d2ace6f1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160564))
- [Remove unused text-metric class](https://gitlab.com/gitlab-org/gitlab/-/commit/004227e0b0643005de330d07a9d9a08381a98149) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160800))
- [Use `gl-fill-icon-subtle` for close icon on Dismissible Container](https://gitlab.com/gitlab-org/gitlab/-/commit/d76b653de44c00c6df9a2b1a5710b5ea01579d50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161084))
- [Remove 'text-plain' util class from common.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/65f53bee12e6e8bda205ff6b446cdbb9d393e1e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160599))
- [Add and backfill project_id for packages_package_files](https://gitlab.com/gitlab-org/gitlab/-/commit/0a6f33a9638f8a48a96a6ef214bb54f820bf817b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161035))
- [Add and backfill project_id for vulnerability_finding_links](https://gitlab.com/gitlab-org/gitlab/-/commit/e90c4e049ee025f4f330c66db2fdb857c912be42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161040))
- [Add jacoco file limit](https://gitlab.com/gitlab-org/gitlab/-/commit/1c5d3cec507a62929f1d6a01e166a165173bbb88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159696))
- [Add and backfill project_id for approvals](https://gitlab.com/gitlab-org/gitlab/-/commit/92b7b92dc233baf5b9f7d2f751fbec895406f726) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160035))
- [Replace cgray with gl-text-primary](https://gitlab.com/gitlab-org/gitlab/-/commit/c34af890dc11ffb54fb1257ae2c50306f40b6bf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160330))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/db9cfb6b20a6a062a1df4f80ddd12b1dce8b5eae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160818))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/51b794d023444297f5fbf79a96502bd3b67e9810) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160519))
- [Replace `bold` class with `gl-font-bold`](https://gitlab.com/gitlab-org/gitlab/-/commit/67c75a76a9baf08d6f592868607f0bf90b0f3da0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160640))
- [Replace 'text-danger' with 'gl-text-danger'](https://gitlab.com/gitlab-org/gitlab/-/commit/3694121ff4426e6b8137ac43b55dac279a3e527b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160631))
- [Add and backfill project_id for merge_request_user_mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/7f40079c6b8d194694f11bb2cf9734442efbb46f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160773))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2bd5850996a4df7ce6a79fa39955dc98dbfd5704) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160521))
- [Add and backfill sharding keys for deploy_tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/82c34fedaccf67017f35e52168cbf24c84c2aa34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160526))
- [test: Add missing feature category](https://gitlab.com/gitlab-org/gitlab/-/commit/5410ab83c86828ab9a1d07b88661cc3abe6ffb8c) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160708))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/9e22a038dda206da801d4783522d1efcd3ee31c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160135))
- [Remove feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/17fdfb4b279345860b31829e20249108239eecf0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160560)) **GitLab Enterprise Edition**
- [Use tailwind util classes for semantic color usage in What's New](https://gitlab.com/gitlab-org/gitlab/-/commit/858fd16a6c30f24081ceb01057d6b264c74f7b21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160284))
- [Add and backfill namespace_id for epic_issues](https://gitlab.com/gitlab-org/gitlab/-/commit/603139d33634388d28c061e0a0fccaadc8fe6e3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156640))
- [Use semantic link color in app/assets/stylesheets/errors.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/5bcf82e99f2fd815a6c68943b06524a24b130568) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160288))
- [Remove index_vulnerability_occurrences_on_primary_identifier_id](https://gitlab.com/gitlab-org/gitlab/-/commit/c83cf3b55d4ae2997e6beae744f93a1ebb9dac7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157283))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2cd077790465ca9cdab7d819001bfbc20c5e9bde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160346))
- [Replace fgray with gl-fill-gray-500 and remove fwhite](https://gitlab.com/gitlab-org/gitlab/-/commit/ed19dc09419722a541d05202de1197b2ae7b0fbd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160471))
- [Move PolicyScopeService to lib](https://gitlab.com/gitlab-org/gitlab/-/commit/539d115b813170dd7cc2a0582c76902d20e83f2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160453)) **GitLab Enterprise Edition**
- [Mark 20230823154049 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/bf74792475b90211b6fb0c3d0b5aa8ae15d81502) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159913)) **GitLab Enterprise Edition**
- [Use semantic token in bootstrap_migration_reset.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/83472694d859f8f2ffad0c0c8148475af8ab1d47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160257))
- [Add advisory lock to lfs_objects_project model](https://gitlab.com/gitlab-org/gitlab/-/commit/b07d6e6a716f88f28b9ab32614aacaa8e0e47349) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159264))
- [Add regex argument](https://gitlab.com/gitlab-org/gitlab/-/commit/a1536d0db90ed6d8757c99e5cb80e129ab783af1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159623)) **GitLab Enterprise Edition**
- [Remove unused fetch method and add Storybook entry](https://gitlab.com/gitlab-org/gitlab/-/commit/54542e4dbf1e9d8e7a332629f24bb3f6af15f4f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160367))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/82efe7fd0dcba5a1e7f3e9b90b3a1789e5816b4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157842))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/87826c022a026e2e8dd4d75bb6e647606951f5ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160185))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/d44bb35ffb6b9e6c05b60dba12e779e6ce87b698) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159836))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/411fcdb893b136d99b254ecae0bd6362102acbf8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160137))
- [Add and backfill project_id for evidences](https://gitlab.com/gitlab-org/gitlab/-/commit/f58dabc1a63a95db49bb739a65adc5f4052833a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159580))
- [Use semantic tokens in broadcast_messages.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/27efd7b48056d5a398c4e37ca2ea599733bbe016) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160301))
- [Use semantic tokens in calendar.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/c3f9992d8719e77873ceea79877b205a594897fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160313))
- [Use semantic tokens in app/assets/stylesheets/framework/blocks.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/7dcb4105a536e1e9e272e7939714af36b8537377) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160297))
- [Mark 20230719211400 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/cc87297ec4560f49acc0db40bb00b57af62cc2e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159448)) **GitLab Enterprise Edition**
- [Add basic methods to abuse report note model](https://gitlab.com/gitlab-org/gitlab/-/commit/f456593cce451c6e9c823328de60c0ccbcd50cda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157823))
- [Mark 20230824114205 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/74788dc020ab64dc04d4642a2b846319e05dd359) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159914)) **GitLab Enterprise Edition**
- [Backfills the user_details records for users that do not have one](https://gitlab.com/gitlab-org/gitlab/-/commit/abbb128b6d684dcec252161a25c3901b2a294e6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159632))
- [Mark 20230908120634 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/3e0b006eb56548d0ae7f57d297288b453a79fddd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159918)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/43038670ff3487aa81aecc43dfbae82818a86785) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160138))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/d17ee14a16f548d2a2ecb30f069edc1fddf2180c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160146))
- [Mark 20230722212041 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/3c5e677e781066093b57d6607c536952b67b756a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159911)) **GitLab Enterprise Edition**
- [Mark 20230901120542 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/9bc0c9430297510607127459a11ff0a4cbf5c42a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159916)) **GitLab Enterprise Edition**
- [Mark 20230720000000 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/fe575e92862660ffd08e4faae853088f566106d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159568)) **GitLab Enterprise Edition**
- [Refactor MirrorsController: move pull mirror code to EE](https://gitlab.com/gitlab-org/gitlab/-/commit/dce63533bb3dd481aef413ba0b87e5f437e4139b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159237)) **GitLab Enterprise Edition**
- [Mark 20230831152648 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/d7fc5ee59dc56ea2360cbf064ab2eb4c33ba6f1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159915)) **GitLab Enterprise Edition**
- [Remove the references of FF zoekt_exact_search](https://gitlab.com/gitlab-org/gitlab/-/commit/d9234e85de05674490cc00380c3b439f96b82a51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159698))
- [Add reserved_storage_bytes to zoekt_indices](https://gitlab.com/gitlab-org/gitlab/-/commit/1665ca684d63a1cb73fd1f486675be298a6680a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159382))
- [Mark 20230911205548 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/74317fc4beb57afd3a98d63b85ecc0ff4ce43783) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159919)) **GitLab Enterprise Edition**
- [Use semantic tokens in diff_file_component.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/60f552aea42f63896bb79869b61a3e9e6006fa2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159976))
- [Use semantic tokens in app/assets/stylesheets/components/avatar.scss](https://gitlab.com/gitlab-org/gitlab/-/commit/1cf5c1dc88d88942f6453eef8f21f74e47327ac6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159587))
- [Requeue partitioning backfill for build group reports](https://gitlab.com/gitlab-org/gitlab/-/commit/5dae18628c2cb770f9e6d80bdce6fd70b85c48aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159702))
- [Implement index addition](https://gitlab.com/gitlab-org/gitlab/-/commit/93b4bb1e9960bbb0f9be2dcef9e9f4d5ddce8c52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158901))
- [Add and backfill group_id for approval_group_rules_protected_branches](https://gitlab.com/gitlab-org/gitlab/-/commit/d673868a1762e218b31c0ed352c14c982cd98e67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159584))
- [Remove diff_preview_in_email feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/89c5a9ba49d09a16e119d6f9be44e6f166dc80b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155140))
- [Remove move_issue_children feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/38a05979dd59f3e3e5674ce186efee6843ea4afe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159779))
- [Remove NOT NULL on policy_id for scan_result_policy_violations](https://gitlab.com/gitlab-org/gitlab/-/commit/0f9ab096685b9b00604de32147d970cbe38455d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158372))
- [Add index for owasp_top_10 group level reports](https://gitlab.com/gitlab-org/gitlab/-/commit/6b2454f65ce020c226003f832c86641bba826803) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158219))
- [Replace flag synced_epic_work_item_editable with work_item_epics](https://gitlab.com/gitlab-org/gitlab/-/commit/44eb338d3582e696999610a6e5add2a1abde795b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158921)) **GitLab Enterprise Edition**
- [GitLab pages: Improve test pages_domain_spec.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/35884c636e25123aad202868f39b0c4da6548bf4) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156192))
- [Add p_ci_builds upstream_pipeline_partition_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ae183dd5d18f0417513ae1a694bc1a17e0c4906e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158622))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/efd0c1ca19367678a1a71cc118d50d0673ac32d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159672))
- [Introduce lock-free rescheduling for duplicate job](https://gitlab.com/gitlab-org/gitlab/-/commit/259ada02ebf00acb867d1b08857677b0e39d7038) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159215))
- [Remove ignores for imported column](https://gitlab.com/gitlab-org/gitlab/-/commit/0495e2c8dda0a3dd05e84c8fb1f9f47a334473db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159599))
- [Add and backfill group_id for approval_group_rules_users](https://gitlab.com/gitlab-org/gitlab/-/commit/9627199cf51d03571292bf9149c603ec0b05f1e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159585))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/605dc2a81004fe30dd302bc31420b3fd5c184676) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159511))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/b0e6df690dd8ef4851e22eb33b73f3abbef7579d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159177))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/118f7f3e7ede695d13a2c91a117e0d9f3d52ae38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159185))
- [Run cron job daily](https://gitlab.com/gitlab-org/gitlab/-/commit/e9b2b91420d6f5a018a976c287fa1bee3464a87e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159442))
- [Protected packages: Cleanup renaming of protected_up_to_access_level](https://gitlab.com/gitlab-org/gitlab/-/commit/c84c1efb2b0d204765ba121e9ad523d44fdb3712) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/146173))
- [Dynamically gets the column type for assertion](https://gitlab.com/gitlab-org/gitlab/-/commit/1389a3daffd104925cce71776903cbf527723222) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159099))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c94fca35b909440ec66ea35c97ab11aa847dde58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158180))

## 17.2.2 (2024-08-06)

### Fixed (2 changes)

- [bug: Fix template error due to divided by zero](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a09aab977c287262a07bec5a267d611c56bf4f9c)
- [Ignore unknown sequences in sequence fix migration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7aa835983a46af9edd1ac4699593017e66979e1d)

### Changed (2 changes)

- [Reverify externally verified gpg keys](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a390e0347e8bd5565d6c324c82221a0f7cccedfc)
- [Put groups_direct field in CI JWT tokens behind feature flag](https://gitlab.com/gitlab-org/security/gitlab/-/commit/59f2133beed57e99c0f8ebab31ea77bb892fef36)

### Security (13 changes)

- [Show correct file content](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1357224fea289ba708f30f528c04e213b29e0b23) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4334))
- [Fix Possible asciidoctor include:: directive DOS](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9762e4636b3dd69edac8b235b4706db515e65e79) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4329))
- [Filter parameters in Rack::Attack logs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/401bdc5202d7b083f750361a2f1ef57466bc919f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4272))
- [Update audit payload](https://gitlab.com/gitlab-org/security/gitlab/-/commit/864194bebe8a5b2e2187d04a65e0e2b530c7b779) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4325))
- [Limit access to project accessed by Security Policy Bot](https://gitlab.com/gitlab-org/security/gitlab/-/commit/100a915754d858cd18cfb7851c80944c8fda640b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4343))
- [Show alert about not rendering files due to path encoding](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d8533d727a1c036560df59282bf62ab561258a13) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4337))
- [Fix the catastrophic backtracking](https://gitlab.com/gitlab-org/security/gitlab/-/commit/001aab470cfc14b4c1655de2382d0aa4c39a4fac) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4289))
- [Security fixes for banzai pipeline part 2](https://gitlab.com/gitlab-org/security/gitlab/-/commit/266c315f6e825881c36aa78f0203bf6a2c36a132) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4283))
- [Remove xhtml extensions from snippets blobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/73b5fc95468dcc35d796737ebb1a6c11d88ebf64) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4300))
- [Add a project scope to LfsTokens](https://gitlab.com/gitlab-org/security/gitlab/-/commit/943c7867ce0d9dc98929af322ecd422438c9f9c6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4319))
- [Fix ReDoS when parsing git push options](https://gitlab.com/gitlab-org/security/gitlab/-/commit/798466f7574554358d770d28df036f60eff31e41) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4312))
- [Fix ReDoS in RefMatcher](https://gitlab.com/gitlab-org/security/gitlab/-/commit/87d308caed2a1ec7f5ae7ddc1131f5c7abbffdbd) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4315))
- [Enforce `require_password_to_approve` MR approval policy property](https://gitlab.com/gitlab-org/security/gitlab/-/commit/129139c6eebd257bc5eae142c52267bb83a71307) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4277))

### Other (1 change)

- [Introduce lock-free rescheduling for duplicate job](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9a15c696b06e4240b02bc54b0c36ed10450c7244)

## 17.2.1 (2024-07-24)

### Fixed (1 change)

- [Fix PEP when SEC is available](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5cbd3187cab87e736c260d374f75cf849997d66c) **GitLab Enterprise Edition**

### Security (7 changes)

- [Refactor import_export_upload to be user-based](https://gitlab.com/gitlab-org/security/gitlab/-/commit/07257efc00d8f4984eddf9576debd62edc6d485d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4269))
- [Fix for private txt artifacts being accessible through the artifacts/browse link](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4ccfc7bb6d3b2aca48e6c9ab5580c92cb2df85f9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4295))
- [Attribute BulkImport::Export to a particular user](https://gitlab.com/gitlab-org/security/gitlab/-/commit/53f8ad67517a92f1e914858c07829ec57e261cc1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4284))
- [Don't include project-level analytics settings in DOM](https://gitlab.com/gitlab-org/security/gitlab/-/commit/639bf845ed2537e44487d8c9e804ec9ac4844045) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4271))
- [Fix for private dotenv artifacts not accessible to downstream jobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/49a4b36f4155702f8277e043d1d1c146b5a52e01) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4275))
- [Do not allow script execution on dependency responses](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e1a84f999c73dab1ce45e9027738a59be977304e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4276))
- [Remove prohibited tags after import](https://gitlab.com/gitlab-org/security/gitlab/-/commit/41db34926ea53f45215294138da716fba4ec03dd) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4268))

## 17.2.0 (2024-07-17)

### Added (159 changes)

- [Add status to scan result policy violations](https://gitlab.com/gitlab-org/gitlab/-/commit/0a0ae8f1088928daa6b432d9179b0daf9a6feba1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158203)) **GitLab Enterprise Edition**
- [Add new run keyword under job](https://gitlab.com/gitlab-org/gitlab/-/commit/928bb79fccefe9d52ae30272bc333116b9ca3f1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/146333))
- [Protected containers: Add PATCH REST API for container protection rules](https://gitlab.com/gitlab-org/gitlab/-/commit/481080c01de97ded95e7d5182a6f2302aaac89cc) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158756))
- [Added filters for multiple compliance frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/280906c08eb0df45e8fd89dd6e957ded70fbed04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158229)) **GitLab Enterprise Edition**
- [Add Duo Enterprise to provision service for add-ons](https://gitlab.com/gitlab-org/gitlab/-/commit/f053e045f3eb066c3c6a2b4f915616554ea07126) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158969)) **GitLab Enterprise Edition**
- [Add Duo Pro end trial widget](https://gitlab.com/gitlab-org/gitlab/-/commit/bf8e86288372c1c18335105d11dbfefc511016bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155614)) **GitLab Enterprise Edition**
- [Add RoR tutorial to Observability docs](https://gitlab.com/gitlab-org/gitlab/-/commit/25c507c7a5c10fd111407225d6735692a7d17ba5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158625))
- [Enable container scanning for registry](https://gitlab.com/gitlab-org/gitlab/-/commit/ccda3ca324318a8825fa032e1a2b853a95929e13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156247))
- [Add willAutoCloseByMergeRequest field to work items API](https://gitlab.com/gitlab-org/gitlab/-/commit/8ea220794cd74f59876a798cdf58ba294af3836f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158145))
- [Add Duo Enterprise to provision service for add-ons](https://gitlab.com/gitlab-org/gitlab/-/commit/ecf4a2c3df04db0105966313e3f4d5b8c81a2963) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158963)) **GitLab Enterprise Edition**
- [Add models for Virtual Registries, part 1/2](https://gitlab.com/gitlab-org/gitlab/-/commit/a7638db2d3bea91d1db1219df57add5986d11169) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156930))
- [Add the API to return the multi_matches in a single file](https://gitlab.com/gitlab-org/gitlab/-/commit/c90c284bc2e9a0f304ab6410866ab0a49862eec1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155984)) **GitLab Enterprise Edition**
- [Ensure uniqueness p_ci_job_annotation](https://gitlab.com/gitlab-org/gitlab/-/commit/760b22da62461eebaae7325c7651cf040349a97a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159071))
- [Add job action button to PMG](https://gitlab.com/gitlab-org/gitlab/-/commit/f3a916e6ba9ee27b345526914a3652fe2915b8fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159004))
- [Add migration to add seat control column to namespace settings table](https://gitlab.com/gitlab-org/gitlab/-/commit/deb3e5bda554bbbfd9341a91e9221b569852627e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158819))
- [Display ratios instead of counts in CI/CD Analytics](https://gitlab.com/gitlab-org/gitlab/-/commit/9cbe9da793af51cb171289f8f505581ec3494988) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158957))
- [Add Importer User for imports user mapping](https://gitlab.com/gitlab-org/gitlab/-/commit/9051ecf67b14924bea3b8df52e24dad141e03b5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157979))
- [Workhorse: HTTP endpoint for bidirectional SSH git-receive-pack data](https://gitlab.com/gitlab-org/gitlab/-/commit/bd2f882c422de105ff2bba6b8011fd6270f65651) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155590)) **GitLab Enterprise Edition**
- [Add GraphQL API for Duo Pro seats assigned and used](https://gitlab.com/gitlab-org/gitlab/-/commit/16bed9c42c1bcb03d5a6e0c1591e92ce8b7a5fbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157936)) **GitLab Enterprise Edition**
- [Enable direct code completions by default](https://gitlab.com/gitlab-org/gitlab/-/commit/257c07f0bc44606e4ef54f4ba1fc6bbb26cbf83b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158733)) **GitLab Enterprise Edition**
- [Added mutation for updating frameworks of projects](https://gitlab.com/gitlab-org/gitlab/-/commit/9f9fdd2b4e329b02695880734b534f38cb5593b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157893)) **GitLab Enterprise Edition**
- [Updates AI merge commit message to be GA](https://gitlab.com/gitlab-org/gitlab/-/commit/d207449f66baa0c31943c4a28164683f2bca11fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158339))
- [Add gitlab-advanced-sast as a SAST job template](https://gitlab.com/gitlab-org/gitlab/-/commit/c5a2613a6dc4158a71f78a085e80af28b3c8314c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158533)) **GitLab Enterprise Edition**
- [Update the search code according to the replica](https://gitlab.com/gitlab-org/gitlab/-/commit/1e93b4695a64366da9ac8afa62a4fb425eb4a867) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158371)) **GitLab Enterprise Edition**
- [Add the API to return the multi_matches in a single file](https://gitlab.com/gitlab-org/gitlab/-/commit/9ed731cf614b1fc0d2a345791a096d6c08c93eda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155984)) **GitLab Enterprise Edition**
- [Add merge_request.squash git push option](https://gitlab.com/gitlab-org/gitlab/-/commit/6db3affce8e9bf36aef55a632ae18f3850cfbf24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158778))
- [Add by_pipeline_ids scope for occurrences](https://gitlab.com/gitlab-org/gitlab/-/commit/056008f7418e1b45d2c616bf7da4e09dfea309f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158790))
- [Release secret push protection for self-managed instances](https://gitlab.com/gitlab-org/gitlab/-/commit/b214790b5a358248b38bec911b97fefa0c27f6d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156907)) **GitLab Enterprise Edition**
- [Add ability to delete task list items](https://gitlab.com/gitlab-org/gitlab/-/commit/1b12e01908c312b302096c591266b73afd56471b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158243))
- [Enable store first reviewer FF by default](https://gitlab.com/gitlab-org/gitlab/-/commit/a167164de15c9c7212ad83bba26c1b863e4b869a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158919))
- [Add support for LDAP group sync with custom roles](https://gitlab.com/gitlab-org/gitlab/-/commit/03c57818738fd8628a7e6561b07483bea7c0b56d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157145)) **GitLab Enterprise Edition**
- [Add delete mutation for deleting self-hosted models](https://gitlab.com/gitlab-org/gitlab/-/commit/55f5a09298d0b5bae2a8bddb920ae1a9f4abe53c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158319)) **GitLab Enterprise Edition**
- [Add REST API endpoints to manage uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/65fc96866782de44427e17c7f21964775e4dbd36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157066))
- [This MR adds performance warning modal](https://gitlab.com/gitlab-org/gitlab/-/commit/6e684693e4cc527976c8f8509e84b7c8f7b9a32c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157745)) **GitLab Enterprise Edition**
- [Protected containers: New GraphQL field "protectionRuleExists"](https://gitlab.com/gitlab-org/gitlab/-/commit/25615f524198cb6e08afabf6e22120d146b1e901) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156741))
- [Add ci_component_source_policy](https://gitlab.com/gitlab-org/gitlab/-/commit/ae3418523c5b20c57becd3426a54fda7240eeb12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157351))
- [Add support for comments in rich text editor](https://gitlab.com/gitlab-org/gitlab/-/commit/2b7c21095ada7258e98ecbdf308e978332e18de1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158618))
- [Add the API to return the multi_matches in a single file](https://gitlab.com/gitlab-org/gitlab/-/commit/975ea866d9f8ff1376f25849286f573ad1d2aacf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155984)) **GitLab Enterprise Edition**
- [Add reviewer first assigned at VSA stage event](https://gitlab.com/gitlab-org/gitlab/-/commit/dcb264ff24fa7822062c736d27fc1f28a3de4900) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158716)) **GitLab Enterprise Edition**
- [Add page metadata to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/d889cbd4339e228193c7011973cf7821aa76b150) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157456))
- [Create p_ci_finished_pipeline_ch_sync_events table](https://gitlab.com/gitlab-org/gitlab/-/commit/9a4b6ad800019e49efc1c4d4f0bc92591b30c33f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158060))
- [Add Rake task to show token expiration info](https://gitlab.com/gitlab-org/gitlab/-/commit/f05e2dcd79b4d0d90074aad4db7dab87da2dc5ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157855))
- [Add and set uploaded_by_user_id on Upload records](https://gitlab.com/gitlab-org/gitlab/-/commit/0321e29e47e24f0b6eeff464a1e16740fbf72ffc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157574))
- [Set first MR assigned for review timestamp metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/c9a1d1bcc59979f4e7968d89e1281fc1254219b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158422))
- [Expose VSD overview counts for projects](https://gitlab.com/gitlab-org/gitlab/-/commit/aa767f85cd6f5e9ada27dc560160614047ec9942) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158017)) **GitLab Enterprise Edition**
- [Create country_access_logs table](https://gitlab.com/gitlab-org/gitlab/-/commit/8e35bd87d23d60547907918f6a938cab88b614a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157480)) **GitLab Enterprise Edition**
- [Show real page title in wiki sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/6c14327fd2fe5d69bf42c90ddb18f477bafa99f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158679))
- [GraphQL: Add PipelineAnalyticsPeriod type](https://gitlab.com/gitlab-org/gitlab/-/commit/baba2199561365b0cd95b025d6a63f147be9871b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157293))
- [CI/CD Catalog: Add description, type to components](https://gitlab.com/gitlab-org/gitlab/-/commit/410bc05a2315afe16dbffefa8b32c7b4a6c376ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157985))
- [Protected containers: POST REST API for container protection rules](https://gitlab.com/gitlab-org/gitlab/-/commit/afee9075d1387525ad6138eb9a7ee69f8ec777cc) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157925))
- [Add Users::ActivityEvent and pub/sub logic](https://gitlab.com/gitlab-org/gitlab/-/commit/8fcab5a27db9a4d127c0165e83b32a0e4f938a7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155559))
- [Add status column to duo workflows](https://gitlab.com/gitlab-org/gitlab/-/commit/7d0440e97dd609453f5a1d87450a413a5c4c5906) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158036)) **GitLab Enterprise Edition**
- [Enables inheritance field param via the Integrations API](https://gitlab.com/gitlab-org/gitlab/-/commit/dc7b1b96f97e4d9f361f98f698922259b5d27362) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158218))
- [Add hasParent field to hierarchy widget](https://gitlab.com/gitlab-org/gitlab/-/commit/96e70f6c713e829baf7a2ff0ed252206e34e7bdb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156041))
- [Add UI for CI_JOB_TOKEN permission settings](https://gitlab.com/gitlab-org/gitlab/-/commit/0a663c231314259a70a74acebeec62bb05115939) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156752))
- [Document SPP known limitation](https://gitlab.com/gitlab-org/gitlab/-/commit/c6aa84da756e078b228b4dd78cc9ec5233d11b87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157699))
- [Remove ci_expand_variables_in_compare_to FF](https://gitlab.com/gitlab-org/gitlab/-/commit/b3358f2d75daeb810eb06e4b473249de2fb0e8ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158183))
- [Separate wiki page title and URL fields](https://gitlab.com/gitlab-org/gitlab/-/commit/a8f32279fcf6e17d747b8648d705d37af5abfc3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150646))
- [Remove the `gitlab_duo_usage_menu_item` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6b8de4adb6b8387ef65e34f22a4162ebbcd225b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158388)) **GitLab Enterprise Edition**
- [Remove references to hamilton_seat_management feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/00fee8b1853ac7af78c799054052e983bd894402) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156961)) **GitLab Enterprise Edition**
- [Add FK to VSA stage event hashes organization_id](https://gitlab.com/gitlab-org/gitlab/-/commit/44e0f713faa6ef866ed829b523921b9bc1d95929) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158322))
- [Release pipeline execution policy type](https://gitlab.com/gitlab-org/gitlab/-/commit/c7f9bb825eb2db6c480e557f0af92470c3618eea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158338)) **GitLab Enterprise Edition**
- [Update Analytics Dashboards' viewed/created/edited tracking events](https://gitlab.com/gitlab-org/gitlab/-/commit/f1bf9efbb2e0c358efa133e521352e10ff4155e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157680)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/81abcdb13c823e82e5d416df6ed2f9aa1f93e59f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158248))
- [Add owners internal endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/0e45f6bdf283916ff5a2f8f70195a0b99a5a62cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157620)) **GitLab Enterprise Edition**
- [Add banned/blocked indicator to card matches admin page](https://gitlab.com/gitlab-org/gitlab/-/commit/43ac9f69a4fa42b4720183096ec39d49504a2e95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157220)) **GitLab Enterprise Edition**
- [Recreate ci_finished_pipelines ClickHouse table](https://gitlab.com/gitlab-org/gitlab/-/commit/3db8c2909e09590b47d148a24fb938cb4fb16acc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158246))
- [Add endpoint to update list of X-Ray dependencies](https://gitlab.com/gitlab-org/gitlab/-/commit/22f296b34c92e85c1f417f25faa87323daca4b9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156179)) **GitLab Enterprise Edition**
- [Add imported_from value to github importer](https://gitlab.com/gitlab-org/gitlab/-/commit/a29fc47f948df472a21f5a7f056eb3703905f7d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157760))
- [Create ci_finished_pipelines ClickHouse table](https://gitlab.com/gitlab-org/gitlab/-/commit/da90a98e359c6eb0ae7f053bdf26de6929200e34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158078))
- [Add compliance center for premium customers](https://gitlab.com/gitlab-org/gitlab/-/commit/6e68bc862fbcfd78620732995bafe0af5edf36ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156632)) **GitLab Enterprise Edition**
- [Add badge for feedback on new epics](https://gitlab.com/gitlab-org/gitlab/-/commit/e542ebca350e494f7e1b131f164ccc2a726a3424) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157324))
- [Add a validation about project assignment to a replica](https://gitlab.com/gitlab-org/gitlab/-/commit/6ffd1aaa10b9f23a2d0668882369ece60e2400f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157758)) **GitLab Enterprise Edition**
- [Add support for LDAP group sync with custom roles](https://gitlab.com/gitlab-org/gitlab/-/commit/b426f3af63b07e64310f92733107b7891a47db52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155680)) **GitLab Enterprise Edition**
- [Create audit event when deploying to protected environment](https://gitlab.com/gitlab-org/gitlab/-/commit/87909ef70f040653c8be4c2dd226dd5580568fa1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156111)) **GitLab Enterprise Edition**
- [Add new namespaces/namespace_id route](https://gitlab.com/gitlab-org/gitlab/-/commit/8410d97a8c10317b4e776303cc0e5abfbe5f84c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157341)) **GitLab Enterprise Edition**
- [Add support for groups in policy scope](https://gitlab.com/gitlab-org/gitlab/-/commit/62cd071153e3cf03a5878da052fbab99817f428b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157083)) **GitLab Enterprise Edition**
- [Show TOC of a wiki page in sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/2e9921fc57e378437db033ae6f4efeca75d6bba5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154050))
- [Add table to record placeholder contributions](https://gitlab.com/gitlab-org/gitlab/-/commit/347fe084d384dd850dec45dc76d48af6bdd2b8cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156241))
- [Migration to populate vulnerability_reads.identifier_external_ids](https://gitlab.com/gitlab-org/gitlab/-/commit/07a5d22507ca7b7d9c072398c9e93d7e2de388d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157639))
- [Add runner fleet dashboard visit metric](https://gitlab.com/gitlab-org/gitlab/-/commit/99554f12c4eb77ffd328de84a73392f0a8bcbe6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157589)) **GitLab Enterprise Edition**
- [Add more log fields in 401 Unauthorized requests](https://gitlab.com/gitlab-org/gitlab/-/commit/eaa8ab73884b9504156e2e2aef1a8c506dbb3f86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157277))
- [Add imported_from to bb cloud resources](https://gitlab.com/gitlab-org/gitlab/-/commit/2b2a583c8e96454a5ccc12f4ff27445b8bcc0e9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157582))
- [Integration for Beyond Identity exclusions by groups](https://gitlab.com/gitlab-org/gitlab/-/commit/5f0492a248e962139237fb40f023ed6f4f1b48ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153957))
- [Add hybrid search query for issues](https://gitlab.com/gitlab-org/gitlab/-/commit/b48f5b540741be978869c50c585794f659724edd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156904)) **GitLab Enterprise Edition**
- [Add job item to pipeline mini graph](https://gitlab.com/gitlab-org/gitlab/-/commit/724852d20740a65a61eeafc6b95c97810c11ee7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157798))
- [Add imported_from value to gitea imported resources](https://gitlab.com/gitlab-org/gitlab/-/commit/0a1528a6cbcecc4d071fe04fa517334ff8864ba9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157333))
- [Add GraphQL API for AI Acceptance Rate](https://gitlab.com/gitlab-org/gitlab/-/commit/ba677efb561d0984af5c850ef7b1536702ca4bd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157035)) **GitLab Enterprise Edition**
- [Create audit event for container repository tag deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/0c61c1eb09e9c76acf4093c2c25e3427f119a7b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156066)) **GitLab Enterprise Edition**
- [Add tracking to metric drill-down links in VSD and AI Impact tables](https://gitlab.com/gitlab-org/gitlab/-/commit/85ee54f6b8a3a59e516d35be7c9e05e9055f48bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157363)) **GitLab Enterprise Edition**
- [Perform chat requests via new endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/139b88d87cf26a25c24848d2e807aa66c88afa56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150529)) **GitLab Enterprise Edition**
- [Added mutation for updating MemberApprovals](https://gitlab.com/gitlab-org/gitlab/-/commit/cbcd2bf16233b16ac9065ec7889abeae21711630) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155284)) **GitLab Enterprise Edition**
- [Add new internal users endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/eece4b86cca0ddb603540d54667c8fb0e752800c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156759)) **GitLab Enterprise Edition**
- [Add imported_from value to bb server resources](https://gitlab.com/gitlab-org/gitlab/-/commit/5a6b7359beade96a4110126c70ffaef2bd575cc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157507))
- [Add support for legacy epic references in workItemsByReference query](https://gitlab.com/gitlab-org/gitlab/-/commit/4be3f387fa992071c0a0d82cf1af7739b58696f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157787)) **GitLab Enterprise Edition**
- [Add in pipeline stage dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/a55564a041751e6fed4b0accfa84053a7439bdc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157506))
- [Add branch_filter_strategy to system, group and project hooks](https://gitlab.com/gitlab-org/gitlab/-/commit/a120d1f89e4920634c58dc444ec4ac83f2d5454c) by @clxrx ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145970))
- [Add duo enterprise add-on type](https://gitlab.com/gitlab-org/gitlab/-/commit/b4de88cb4d1366991b7ecddca4459ee84983e16a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157730)) **GitLab Enterprise Edition**
- [Add update mutation for the self-hosted models Vue client to leverage](https://gitlab.com/gitlab-org/gitlab/-/commit/1e3ae1075a486c6cd85c93145336f3c6ea6d3d62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156899))
- [Protected packages: Add label "protected" to package list on group level](https://gitlab.com/gitlab-org/gitlab/-/commit/63e733df54f0a5ad24f67115d4b83aa53d26d979) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154809))
- [Protected containers: Add GET to REST API for container protection rules](https://gitlab.com/gitlab-org/gitlab/-/commit/215c18a415bc2dfbafb6bb81a3f5a404e8b2d5b2) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155798))
- [Add gitlab_sec db connection and application record](https://gitlab.com/gitlab-org/gitlab/-/commit/c93d2b4e1112ed682c4690fe0c19b78a5dd51141) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157462))
- [Fill out fields on InputType](https://gitlab.com/gitlab-org/gitlab/-/commit/92da7caa9f4148d1d611e3f1e6eda5a24d8f6164) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156328))
- [Adds configurable default Service Desk ticket visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/39be1cc96b11451030e06efea06d956f220b796c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156884))
- [Add error message for failed association deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/a6408f97c1af7e54d63a26edcd65d0fd27a6dd21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157625))
- [Allow `admin_runner` to create a runner linked to a user](https://gitlab.com/gitlab-org/gitlab/-/commit/98564f789a47c63a33387ebdd4a8e262d8da377c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156559)) **GitLab Enterprise Edition**
- [Allow push to the own repo using CI_JOB_TOKEN](https://gitlab.com/gitlab-org/gitlab/-/commit/5c8b0440f95ab67f5503220ba63173f248c9054c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154111))
- [Adds reusable SettingsSection component](https://gitlab.com/gitlab-org/gitlab/-/commit/d66062058592ca8b25f10395546706f8a44e39ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157270))
- [Enable runner dashboard for groups](https://gitlab.com/gitlab-org/gitlab/-/commit/2dbe985b8822a3a5f56da73e4f30387710b7eb2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157423)) **GitLab Enterprise Edition**
- [GraphQL: Add job execution status to runner manager](https://gitlab.com/gitlab-org/gitlab/-/commit/8036c15b59b4194ef3c4dfe491c0f5200ced13bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157429))
- [Auditing framework assign and unassign to a project](https://gitlab.com/gitlab-org/gitlab/-/commit/01e758131649a64b9e925bedf933c5b3d311b501) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156605)) **GitLab Enterprise Edition**
- [Add runner CSV export metrics at project and group level](https://gitlab.com/gitlab-org/gitlab/-/commit/c2c334e0f211370dbde828ca05b8c55321df3ab6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157197)) **GitLab Enterprise Edition**
- [WorkItems: Fix rolledup dates when removing child](https://gitlab.com/gitlab-org/gitlab/-/commit/dfc2d692cfc9da9d5b3470d9b90aaa390729bcc1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157334)) **GitLab Enterprise Edition**
- [feat: Add configuration for sec DB](https://gitlab.com/gitlab-org/gitlab/-/commit/faf789e010b264e31c6db729be8cdff9ed325421) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156952))
- [GraphQL: API for retrieving most used runners](https://gitlab.com/gitlab-org/gitlab/-/commit/1ea8a9d0c44968bc38e64dc6e6dbe85dd0abd9c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157436)) **GitLab Enterprise Edition**
- [GraphQL: Add percentiles to QueueingHistoryTimeSeries](https://gitlab.com/gitlab-org/gitlab/-/commit/2dec0f10284ab11266564c511632ecfb0ba6a67f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157435)) **GitLab Enterprise Edition**
- [GraphQL: Add upgradeStatus field to RunnerType](https://gitlab.com/gitlab-org/gitlab/-/commit/6ecc972d8b5e75a8ac580eca16d9fa2297750b94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157434)) **GitLab Enterprise Edition**
- [Add support for Claude 3.5 Sonnet for code generation](https://gitlab.com/gitlab-org/gitlab/-/commit/b793848806ec66dbf779d000d6c4adb94565dc36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157336)) **GitLab Enterprise Edition**
- [Bump rouge to 4.3.0 with the new IEC 61131-3 Structured Text lexer](https://gitlab.com/gitlab-org/gitlab/-/commit/e8289a931d6cf482c1feac3c0e4a9af9f9b643c2) by @bufferoverflow ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157252))
- [Add secure schemas version 15.1.4 and 5.1.3](https://gitlab.com/gitlab-org/gitlab/-/commit/f37ff659e20c823989d6f78f2d7b343b57c785c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157282))
- [Add metadata to group work item page](https://gitlab.com/gitlab-org/gitlab/-/commit/1d065451d1b6677b8e9e2c16f6032ebfd4865e45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157049))
- [Add NOT NULL on merge_request_id](https://gitlab.com/gitlab-org/gitlab/-/commit/fe28d0267fdc2230d59a00cb7841cf17f65d23d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156170))
- [Add merge and closed user ids to MR metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/c9b115a010ad681eb1c57ce31fb333ebdc25e843) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157206))
- [Pass org in export part creation](https://gitlab.com/gitlab-org/gitlab/-/commit/2e8c605e61e1e3ae7a13828ede9e541ec7e44266) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157074)) **GitLab Enterprise Edition**
- [Add support for child pipelines to SBOM ingestion](https://gitlab.com/gitlab-org/gitlab/-/commit/6eab3a93690af0b73d4dd32e431a19c6bacedd78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151814)) **GitLab Enterprise Edition**
- [Add option to sort Pipeline Schedules to frontend](https://gitlab.com/gitlab-org/gitlab/-/commit/3573dec857ad905f2de64ee3498ddab78cc5aec4) by @schurzi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157224))
- [Add ability to create label in work item labels widget](https://gitlab.com/gitlab-org/gitlab/-/commit/d327d4ce3ffc63c8b3ba63b1d1742c2324cd6031) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156524))
- [Allow `admin_runner` ability to change stale runner pruning setting](https://gitlab.com/gitlab-org/gitlab/-/commit/d903b29f8a0c48475c6045349c4964c1381f9801) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155497)) **GitLab Enterprise Edition**
- [Adds type to issue webhook attributes](https://gitlab.com/gitlab-org/gitlab/-/commit/e6e6017ad32d0b74b224dfaffabaae3db832be84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156760))
- [Add button for adding additional seats to error messages](https://gitlab.com/gitlab-org/gitlab/-/commit/a1c37cf4c5ff40506c0043a752aec1d2fc5e8412) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155737)) **GitLab Enterprise Edition**
- [Adds the CRUD Container component](https://gitlab.com/gitlab-org/gitlab/-/commit/313ca91904b092475e4d62ff90a90dbe17ca9c01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156749))
- [Add variables field into PipelineType](https://gitlab.com/gitlab-org/gitlab/-/commit/a6d441fc18e1df2c8c5bd9e44ae5bd6cf3d93a01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155418))
- [Show latest version on version creation](https://gitlab.com/gitlab-org/gitlab/-/commit/752ff4db28ec6c38eff135bc99953d8173388ddb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155978))
- [Backfills gitlab group issue embeddings on gitlab.com](https://gitlab.com/gitlab-org/gitlab/-/commit/9101e4229aba3224e4916b5557f8d0766885ad4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154940)) **GitLab Enterprise Edition**
- [Enforce rate limits for notification emails](https://gitlab.com/gitlab-org/gitlab/-/commit/4d990b60e1a4341add14437d24398a07b3ce6a7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156945))
- [Release CI/CD popularity count and sort](https://gitlab.com/gitlab-org/gitlab/-/commit/ccc6b38cb6dc01f9f9c2f2b6d168a10c92218095) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156654))
- [Remove ci_expand_nested_resource_group_variables FF](https://gitlab.com/gitlab-org/gitlab/-/commit/cb194188d3540d141d4d21aa679c3bb9485db840) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157146))
- [Protected packages: REST API PATCH package protection rules](https://gitlab.com/gitlab-org/gitlab/-/commit/883ad288d8a131398c8c744432aba919d2278866) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153577))
- [Add api to return group's shared groups](https://gitlab.com/gitlab-org/gitlab/-/commit/a015acefff8c8bceaca21193a8c576bf5fe8ec11) by @imskr ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155251))
- [Protected containers: Allow nil value for fields `minimum_access_level`](https://gitlab.com/gitlab-org/gitlab/-/commit/430374098a1e8b078f38585219ba012fb914f996) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/146997))
- [Add maintenance mode banner to edit frameworks UI](https://gitlab.com/gitlab-org/gitlab/-/commit/d67604b6a6b900bfda49002d8b3690afaa384239) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155887)) **GitLab Enterprise Edition**
- [Add cargo to supported sbom and sync types](https://gitlab.com/gitlab-org/gitlab/-/commit/114c6191291c84bb3f2fe0a37701ab9604389cf7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156072))
- [Add disabled_direct_code_suggestions setting](https://gitlab.com/gitlab-org/gitlab/-/commit/57c2bf6c68e86711699c76c41ff9717c69d0f22c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156147)) **GitLab Enterprise Edition**
- [AI impact analytics dashboard is now generally available](https://gitlab.com/gitlab-org/gitlab/-/commit/b23a75f987231d1b882e6460a57109230c604dfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154148)) **GitLab Enterprise Edition**
- [Adds inheritance settings to API::Integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/56a2f1da6ead60b6ae42633a6263595813576c3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154915))
- [Remove identity_verification_arkose_challenge feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b882650e842bc4b82b7af44507418bd414da396b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156862)) **GitLab Enterprise Edition**
- [Added include_forked filter to the zoek search](https://gitlab.com/gitlab-org/gitlab/-/commit/dda457f63b5b0546ca9e3ab449e0dc902156655c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154099))
- [Extend organization to snippets table](https://gitlab.com/gitlab-org/gitlab/-/commit/1b14e34b38fb9b26c3737a93c189804464ca88fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155580))
- [Include required backend data for the Project Header](https://gitlab.com/gitlab-org/gitlab/-/commit/28c0badf0bead0768a092fb298d1b8cc39162548) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156049))
- [Added create and delete apis for instance level namespace filters](https://gitlab.com/gitlab-org/gitlab/-/commit/cd588f8794c57f1b87f899429ff5febdb43f6699) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153156)) **GitLab Enterprise Edition**
- [Add approval_policy_rule_id index and foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/05c2f382674e5951bdd4eb771a14bb203eb286ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155256))
- [Add pod logs buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/7446d3fe32cbb1cb9876714805125640fc5b19cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156544))
- [Add support for rendering readme in terraform package details page](https://gitlab.com/gitlab-org/gitlab/-/commit/67d63b74dff09e7a4fefdfe5e8e77e74bf073bdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155025))
- [Create container_repository_deletion_marked audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/130adeb5bea20ed3934820fd223c58e045110342) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152967)) **GitLab Enterprise Edition**
- [Protected packages: REST API POST package protection rule](https://gitlab.com/gitlab-org/gitlab/-/commit/07af56ad982ac40656fdd907f6626f2bb4f93b1e) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153571))
- [Adjust logic to add org to export](https://gitlab.com/gitlab-org/gitlab/-/commit/1b9cea92f6e3cb3317c36388acffd109638b835f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156367)) **GitLab Enterprise Edition**
- [Add mediaType as a field to Tag](https://gitlab.com/gitlab-org/gitlab/-/commit/8bfa8d8f130ca74127e99f85e99c5c5f1bcb3d9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156303))
- [Adds List-Unsubscribe-Post header to notification emails](https://gitlab.com/gitlab-org/gitlab/-/commit/2f6f362ae293171da5882592ef93f2e5e99ca585) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156414))
- [Add member_role_id to ldap_group_links](https://gitlab.com/gitlab-org/gitlab/-/commit/83684890db91add42b8651f0562a7d9a7a868152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155676)) **GitLab Enterprise Edition**

### Fixed (162 changes)

- [Exclude scripts from coherence check when publishing npm packages](https://gitlab.com/gitlab-org/gitlab/-/commit/9a6daba70e91fbcc0b46cc5bd50e37de63a58eee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159427))
- [Relax the version comparison for NPM uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/450f299f822649d8772b88d516cd982d46a81bde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159327))
- [Fix worker when record not found](https://gitlab.com/gitlab-org/gitlab/-/commit/ce9477c4c6d2a78d1b270eb4453e5157bbc8170a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158973)) **GitLab Enterprise Edition**
- [Fix Content-Disposition not working for Azure in API download](https://gitlab.com/gitlab-org/gitlab/-/commit/b3c547feccf134234284514d641b2dea42bd50d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159292))
- [Display error when delete framework fails](https://gitlab.com/gitlab-org/gitlab/-/commit/571492480ace5b8e3ad5dbb5fd6df29dd0473545) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159207)) **GitLab Enterprise Edition**
- [Cobertura parser: Extract filename OS-agnostically](https://gitlab.com/gitlab-org/gitlab/-/commit/ad34f313de7ae59910f3b0bbeff6da89ee5199eb) by @bmarconato ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159263))
- [Fixed Productivity Analytics date range calculations](https://gitlab.com/gitlab-org/gitlab/-/commit/3e6f3a9a0f612d1b73a17487fa265a3a7f8505e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158664)) **GitLab Enterprise Edition**
- [Fix IDE Duo Chat timeout](https://gitlab.com/gitlab-org/gitlab/-/commit/bb885d2da7e208424e3f9100b5de78ae5c03a5b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159201)) **GitLab Enterprise Edition**
- [Support auth credentials from URI for pull mirror validation](https://gitlab.com/gitlab-org/gitlab/-/commit/9d5f6d4bd03ef6cc8282ea539b3a50e7383b42f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158076))
- [Remove invalid foreign key fk_87f4cefcda_p](https://gitlab.com/gitlab-org/gitlab/-/commit/8ff55f5255757dcca5f7ec776720f8e6c4e40d62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158585))
- [Fix calculations for predefined date ranges in Value Stream Analytics](https://gitlab.com/gitlab-org/gitlab/-/commit/1a0f0fabf271268e7272d01ba3370985915c34e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156355))
- [Use sentence case for work items "Linked items" header](https://gitlab.com/gitlab-org/gitlab/-/commit/8cd3212b168810bda633c8078250aadc4050ce8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159148))
- [Fix custom emoji display](https://gitlab.com/gitlab-org/gitlab/-/commit/d4d9005c15a6c1d97812b0daf667d4aa2d0a2499) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159136))
- [Fix pipeline subscription error flash message display](https://gitlab.com/gitlab-org/gitlab/-/commit/e21661bfde2afabe49af4e86384eb203664678af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158151)) **GitLab Enterprise Edition**
- [Remove zoekt dependency from elasticsearch](https://gitlab.com/gitlab-org/gitlab/-/commit/cb1027397db9249bd359adec7cdc5b6fb8ea5101) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157921)) **GitLab Enterprise Edition**
- [Fix custom role bug with requirements](https://gitlab.com/gitlab-org/gitlab/-/commit/9f1ddccc5712bf0a346952d666fbf71da675d3ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157115)) **GitLab Enterprise Edition**
- [Fix issues with quick action explanations](https://gitlab.com/gitlab-org/gitlab/-/commit/025d14c15e7ec0c1dfe813730a9194cf2f16b410) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158990))
- [Fix notification emails not being sent when using external authorization](https://gitlab.com/gitlab-org/gitlab/-/commit/6a140058c3e0fb99eaeb1298a357200e319e6d67) by @pR0Ps ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/110709))
- [Clear seat assignments cache on bulk upsert](https://gitlab.com/gitlab-org/gitlab/-/commit/068b498bc5072b95c4d7a88db3bb0fad9723f820) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159065)) **GitLab Enterprise Edition**
- [Fix how maven dependency proxy credentials are sent](https://gitlab.com/gitlab-org/gitlab/-/commit/9bc5abe412a364eeb46f811f9b77092839ee3ed1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158593)) **GitLab Enterprise Edition**
- [Remove validation for ProtectedRef access levels](https://gitlab.com/gitlab-org/gitlab/-/commit/42d475a1314f2301c24501f3b7e2e1e3b4f89bf0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158296))
- [Make `complianceFrameworks` field work for subgroups](https://gitlab.com/gitlab-org/gitlab/-/commit/3cf82399f3ee900869dfc75f0b9142cf7feb87d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159055)) **GitLab Enterprise Edition**
- [Introduce dedup lock for rescheduling jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/7e469afe690bb59b45456dcb426242e0d07279a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158329))
- [Fix GitHub Import when importing from GHE](https://gitlab.com/gitlab-org/gitlab/-/commit/ea2d574785ac7f080577c64b37864b8c4e214eb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158503))
- [Fix alignment of admin groups header](https://gitlab.com/gitlab-org/gitlab/-/commit/decf1f008d63edd582b5bf6fbc1627269cb209c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158805))
- [Parse the package.json file entirely for NPM uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/6d91ce9ca96b68f720e232582b3ab6d4cdb7f5b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158978))
- [Authenticate the GitLab Duo usage controller](https://gitlab.com/gitlab-org/gitlab/-/commit/2540a50b105bf4971a1501e16d594548ea3b9491) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158758)) **GitLab Enterprise Edition**
- [Fix new issue note for group level issues](https://gitlab.com/gitlab-org/gitlab/-/commit/f41a2e170fc0df8969e4404f992994b97e25963e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158496))
- [Remove milestone truncation on issues/merge requests dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/1d6db3dcc9deda7d456735ab2e0920c52bf9e2cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158375))
- [Protected packages: Npm package push protection for admin user](https://gitlab.com/gitlab-org/gitlab/-/commit/7622de8c7eb77596cd4486e16cbe3887e9a6cf5c) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156439))
- [Work Item Epic feedback close on click](https://gitlab.com/gitlab-org/gitlab/-/commit/a83a354db835594945f3b6a68cd7a53144725aa0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158900))
- [Fix work item sticky header](https://gitlab.com/gitlab-org/gitlab/-/commit/57fd28472e239445bc8a12fc0722857c42adbc36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158896))
- [Fix bug with achievements path when feature flag not globally enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/951b4aa67a1ebbb4124274b46456dee1f243c095) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158895))
- [Protected packages: Fix documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/327f7009058a3dfe11dfc652b27bed787e0a084e) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158894))
- [Add workItemType check for weight widget for epics](https://gitlab.com/gitlab-org/gitlab/-/commit/a14fc4ee58210c2accd95c141625d8fdcc2db81f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158878))
- [Exclude disabled custom permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/94a33e125508a13734a62a39ae702e5ce560dba4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158848)) **GitLab Enterprise Edition**
- [Prevent modal close on comment submission](https://gitlab.com/gitlab-org/gitlab/-/commit/eb2277960ec3bf66623fa1d77670fc451823f2f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158478))
- [Remove empty minimum_should_match from query](https://gitlab.com/gitlab-org/gitlab/-/commit/731a7e4953bcc2575d2cb7bd6a7708c1d9d5df2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158645)) **GitLab Enterprise Edition**
- [Prevent running scans from execution policies after downgrading license](https://gitlab.com/gitlab-org/gitlab/-/commit/2f6536064b1d214c268ac78d53e10cbad97ce123) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158817)) **GitLab Enterprise Edition**
- [Fix wildcard package.json search in npm upload](https://gitlab.com/gitlab-org/gitlab/-/commit/917899322e2074f2cd4468a6f5ec3b120e0d6ede) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158806))
- [Fix sync failure retry backoff](https://gitlab.com/gitlab-org/gitlab/-/commit/75b31d017ab5f8bb420e7bb23279131b81d5c590) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157805)) **GitLab Enterprise Edition**
- [Exclude last page link from projects/id/repository/commits endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/f1eca9272f911e1c4c0f2b4e2a67f0c53cc3e4d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158278))
- [Unify spacing in group and project item components](https://gitlab.com/gitlab-org/gitlab/-/commit/aadf1e2079cf96c17de27253d8e07d4f8304f3d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158639))
- [Fix MR approval policy `prevent_pushing_and_force_pushing` enforcement](https://gitlab.com/gitlab-org/gitlab/-/commit/b479126b59dd39b1fc0d738665044ece0e4c8110) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158435)) **GitLab Enterprise Edition**
- [Update static_holmes to v0.7.11](https://gitlab.com/gitlab-org/gitlab/-/commit/6cacaf56940ab272c34a515f2fbaa8f9c388ae8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158714))
- [Fix meta.root_namespace not logging for groups API requests](https://gitlab.com/gitlab-org/gitlab/-/commit/8413bde199dbe4395ceb599cb88aa5d4ffb91f13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158671))
- [Remove `fix_sso_enforcement_for_web_activity` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/29f566014199d4ca90feb26a1dcae982743a82f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158655)) **GitLab Enterprise Edition**
- [Fix layout of filtered search for pipelines page on mobile](https://gitlab.com/gitlab-org/gitlab/-/commit/5085921f9bebccf2b8f03c2be711b02805581216) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158649))
- [Fix cached introspection query and graphql-explorer](https://gitlab.com/gitlab-org/gitlab/-/commit/5bab3b90d3d440ae5ee44e8fb937a81deca0c7fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158260))
- [Ignore object pool already exists creation errors](https://gitlab.com/gitlab-org/gitlab/-/commit/cd5c559d81fcbeed4781666eea23ff88624e52a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158412))
- [Fix approval policy type detection for policies list](https://gitlab.com/gitlab-org/gitlab/-/commit/9464813b2a7dcd480f6304f8f1963e5127aae7f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158528)) **GitLab Enterprise Edition**
- [Fix polling when retrying status check](https://gitlab.com/gitlab-org/gitlab/-/commit/9c9a7427d39481ae993fba572b379634b7ead720) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158527)) **GitLab Enterprise Edition**
- [Fix NoMethodError in PathLocksController](https://gitlab.com/gitlab-org/gitlab/-/commit/6b66490ff71e4aa311afe05e541ac69854e6c565) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158434)) **GitLab Enterprise Edition**
- [Protected packages: Remove developer as an example from documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/7d191795eb9413b998d73b1985c02997d999cd88) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158433))
- [Ignore selected project if adding epic](https://gitlab.com/gitlab-org/gitlab/-/commit/3fe3078b6fce5c41c1431c15ef3c053f1b07ef30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158241))
- [Remove Bad spacing in pending comment](https://gitlab.com/gitlab-org/gitlab/-/commit/641ecd1b8134c1d0af00f7a2f9094f4ec07a44af) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158429)) **GitLab Enterprise Edition**
- [Fix merge train merge availability when pipeline is canceling](https://gitlab.com/gitlab-org/gitlab/-/commit/99dfd60511346c843950c911c482b08e19644904) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158126)) **GitLab Enterprise Edition**
- [Fix broken schema path](https://gitlab.com/gitlab-org/gitlab/-/commit/e94b26c861f80efd63361f15da8964a6d62c3093) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157228)) **GitLab Enterprise Edition**
- [Fix incorrect retry warning when merge trains are enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/7e576e008ef04bf7bcefe917e4c33256caa17196) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158283)) **GitLab Enterprise Edition**
- [Fix Zoekt exact match](https://gitlab.com/gitlab-org/gitlab/-/commit/d893df66119a92d4b0bb89c73c841050a4af14b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158379)) **GitLab Enterprise Edition**
- [Forking project to groups with restricted visibility levels](https://gitlab.com/gitlab-org/gitlab/-/commit/fb0a1bf330d184eb0b5901b7a3e39a2c7f273d52) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157202))
- [Title returns a default value if no advisory title](https://gitlab.com/gitlab-org/gitlab/-/commit/31ba4d52d0a7e0a39b454dc8177175fa2e40158d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155841)) **GitLab Enterprise Edition**
- [When activity token is cleared set query to all values](https://gitlab.com/gitlab-org/gitlab/-/commit/e26eeb648b8249684aec6d8d2f461eaa8ebc472f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158098)) **GitLab Enterprise Edition**
- [Fix issues mailer for group level issues](https://gitlab.com/gitlab-org/gitlab/-/commit/b474a0465bbe9c8818a11ea32e8985e33db66cf2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156360))
- [Display unverified badge for signed commits without a signature](https://gitlab.com/gitlab-org/gitlab/-/commit/1aceccdb4b372a16a7e8cb71c26666388fa5c7b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153407))
- [Fix related items header in dark mode](https://gitlab.com/gitlab-org/gitlab/-/commit/298622b5f009c518701835a3f79fee3d13f73fab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158169))
- [Reduce getPipelineDetails query complexity below 200](https://gitlab.com/gitlab-org/gitlab/-/commit/42a009b95acd9df7f78f42eb7afcf6ba9789ec3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158158))
- [Fix issue description task actions focus bug](https://gitlab.com/gitlab-org/gitlab/-/commit/0ab321a080cde133f39971dfc6cb2c96085a1a75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157495))
- [Reset form error when tokens change after submission failure](https://gitlab.com/gitlab-org/gitlab/-/commit/365f13032ca4c186aebfaee78de9cdf407a3631a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157792))
- [Do not create empty rule for branch specific rules](https://gitlab.com/gitlab-org/gitlab/-/commit/e765f4ea1ad6b6f9d97a835e7f4c8eba0985a6d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157723)) **GitLab Enterprise Edition**
- [Reinstate dt disabled message](https://gitlab.com/gitlab-org/gitlab/-/commit/2f8110a741e85ee65f73e6c738260b6475d08fe4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156744))
- [Fix submit keyboard shortcut on commit page](https://gitlab.com/gitlab-org/gitlab/-/commit/ff4782d2fd23b5d4ce7cb240e783d9fccc9b3f3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157998))
- [Remove custom CSS to fix modal background color](https://gitlab.com/gitlab-org/gitlab/-/commit/caf6a6e388a98c71a3331ee70b9155222dc94a4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158064))
- [Fix badge issues and sticky header](https://gitlab.com/gitlab-org/gitlab/-/commit/99e5372454a66afa98e65a9b26f00a6438135c0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158047))
- [Skip approval updates for merged MRs](https://gitlab.com/gitlab-org/gitlab/-/commit/bc90a50bc57f11bc252cbc57e7ff4f887d5571c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158042)) **GitLab Enterprise Edition**
- [Fix ambiguous namespace_id in query](https://gitlab.com/gitlab-org/gitlab/-/commit/2f9aa3a181ff09af45b226f72d0e6d1847b481f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157780))
- [Pass session_id to nested sidekiq calls](https://gitlab.com/gitlab-org/gitlab/-/commit/08a9a012054dbd9fdafc48e74165f992e3523255) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157566)) **GitLab Enterprise Edition**
- [Prevent redudant finalisations of segmented exports](https://gitlab.com/gitlab-org/gitlab/-/commit/e51c3bbbadb487a4d64508314fda4a152279706e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157695)) **GitLab Enterprise Edition**
- [Allow Developers to create projects from templates](https://gitlab.com/gitlab-org/gitlab/-/commit/52e43952ea7987940fb07724589b1f6caf8930ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157401))
- [Fix flaky test in SyncFunnelsWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/a2e34f649d3c3c3dfe22721013ee2f2385a5f07d) by @max.woolf ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157763)) **GitLab Enterprise Edition**
- [Fix URL generation for links with spaces](https://gitlab.com/gitlab-org/gitlab/-/commit/23293597ecf724218349450527a1f64f87611d59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157942))
- [Fix Link header for Tree API requests](https://gitlab.com/gitlab-org/gitlab/-/commit/2ef5030ba61668fc00ff83cb088d30902af0f60b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157914))
- [Fix issue creation on board with scope set to No iteration](https://gitlab.com/gitlab-org/gitlab/-/commit/bba2d2b4d030f1ad420ae3472612d0301749255b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157892)) **GitLab Enterprise Edition**
- [Fix setting the `organization_id` for vulnerability exports](https://gitlab.com/gitlab-org/gitlab/-/commit/bb6b92a2d7ab40e5df07bf8b02b0f5f036bf96fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157889)) **GitLab Enterprise Edition**
- [Field needs to be called Url](https://gitlab.com/gitlab-org/gitlab/-/commit/bd553868ae635267f1615927ca7a6656406d16df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157884))
- [Fix bulk_import history prop type check](https://gitlab.com/gitlab-org/gitlab/-/commit/abae316f7bcefaa01afce3bfdf55e6bbff9bf337) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157856))
- [Upgrade graphql-client GEM](https://gitlab.com/gitlab-org/gitlab/-/commit/8ddbcd44cde498b7fb21bf29b550a4a0bc0a1c60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157772))
- [Fix Milestone collapsed sidebar, adjust some aspects of issue sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/947b0449ac1bc882b14c4ed90d3e82dcefc1ce42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157676))
- [Add safeguard for author](https://gitlab.com/gitlab-org/gitlab/-/commit/f63aa04e88334c28958abbfdda1157214cdec008) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157814)) **GitLab Enterprise Edition**
- [Geo: Update the host to build the replication details links](https://gitlab.com/gitlab-org/gitlab/-/commit/9e244068428fa02253cac7edf0514f4338d6d562) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157671)) **GitLab Enterprise Edition**
- [Add missing "Deploy Keys" breadcrumb item](https://gitlab.com/gitlab-org/gitlab/-/commit/fbe188dc81095116f8d7306e7abf10cc6968ff82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157445))
- [Allow viewing hook logs with admin_hook permission](https://gitlab.com/gitlab-org/gitlab/-/commit/4d52095187268809685043493e3b322fb437e22a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153806)) **GitLab Enterprise Edition**
- [Recreate records when moving issues](https://gitlab.com/gitlab-org/gitlab/-/commit/d4b0a967100e83bd22392105f4a46f215fa8f880) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157332)) **GitLab Enterprise Edition**
- [Authenticate agent requests using Gitlab-Agentk-Api-Request header](https://gitlab.com/gitlab-org/gitlab/-/commit/cdaca4495de42c17d34f7b06928e52d2f53d08ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157703))
- [Fix Verification concurrency limit](https://gitlab.com/gitlab-org/gitlab/-/commit/58c8f5c0cfaffb54698df5f8bfabe8a05ce29924) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157553)) **GitLab Enterprise Edition**
- [SSO enforcement for web activity should only apply to current_user](https://gitlab.com/gitlab-org/gitlab/-/commit/72c0ce28c980e39c825604fb1ee1f2c593f13ac8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156934)) **GitLab Enterprise Edition**
- [Display the number of rules for a given branch only](https://gitlab.com/gitlab-org/gitlab/-/commit/6a4e41dda7ef955a29ef1d5b20b1b49cc3efbbe1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157292)) **GitLab Enterprise Edition**
- [Fix sticky header badges shrinking](https://gitlab.com/gitlab-org/gitlab/-/commit/df2dfef866565edf5c05496548d2dd0321782c5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157580))
- [Fix DML not allowed error when creating views](https://gitlab.com/gitlab-org/gitlab/-/commit/c87295b3a65e6d95b9fb3b50917781347b877589) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156986))
- [Use pajamas default left and right spacings on Roadmap page](https://gitlab.com/gitlab-org/gitlab/-/commit/cd64bfb1757fba9f5a5179ce3fe3f1f9a230060c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156550)) **GitLab Enterprise Edition**
- [Fix orphaned work item parent links](https://gitlab.com/gitlab-org/gitlab/-/commit/811dafe0d4ace122674f20f364f552f6d473d809) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156657)) **GitLab Enterprise Edition**
- [Add jwt for jira connect branches](https://gitlab.com/gitlab-org/gitlab/-/commit/dba8992cad989ff4717058a1c945db8a2b1f3d0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149377))
- [Do not wrap flex parent of verified badge and commit copy button](https://gitlab.com/gitlab-org/gitlab/-/commit/db8a0c4c742223639196f18672b44a339dfe3b1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156673))
- [Protected packages: NPM push protection for deploy token](https://gitlab.com/gitlab-org/gitlab/-/commit/c6931921bb6dad26cad0c2868dab57744c4e9e84) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156610))
- [Use universal_stylesheet_link_tag in app layout head haml](https://gitlab.com/gitlab-org/gitlab/-/commit/2b5f004d4e2a91f7b6f8ed611734e672afea37d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157356))
- [Improve error message when setting parent of a work item](https://gitlab.com/gitlab-org/gitlab/-/commit/b933e6349919b84a1f6f2571d175eabbf344bd08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154557))
- [Fix search bar accessibility issues](https://gitlab.com/gitlab-org/gitlab/-/commit/ad6f231039e87dd6c6096eccd2c33e0de39f1166) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155091))
- [Allow to set "No one" level for branch protection defaults](https://gitlab.com/gitlab-org/gitlab/-/commit/097cfcc599122e4c43f022f51096ce38713077bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157315))
- [Fix MailRoom not loading in Omnibus](https://gitlab.com/gitlab-org/gitlab/-/commit/802a87d2fea4603d3eb4ac3848ae7c0a83cf14c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157339))
- [Change fixture order](https://gitlab.com/gitlab-org/gitlab/-/commit/2f51e7f4d1383039ebe0c9a391f9453897b9420a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157309))
- [Don't trigger edit wiki shortcut when using search](https://gitlab.com/gitlab-org/gitlab/-/commit/0e2078fec2a8f2ad9e1adcd0be99fb96ec7f8e35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157303))
- [Include action in webhook test payloads](https://gitlab.com/gitlab-org/gitlab/-/commit/3eac576afdfc3a72e1c2750b9640bbcef390a1cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156856))
- [Fix issue using multiple contact quick actions at the same time](https://gitlab.com/gitlab-org/gitlab/-/commit/6965459cba26119b6c0909d6f026dfde6a985312) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157299))
- [Correct finalize migration for BackfillEpicBasicFieldsToWorkItemRecord](https://gitlab.com/gitlab-org/gitlab/-/commit/44d3563325e6e58248b92dcdcba75dd114aa6c32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157295))
- [Remove extra gap when 0 roadmap epics have children](https://gitlab.com/gitlab-org/gitlab/-/commit/d2e4c436b848c40d75087a08a294c7752a9cf0b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156694)) **GitLab Enterprise Edition**
- [Fix finding name in regards to image name](https://gitlab.com/gitlab-org/gitlab/-/commit/6fc93a0fc23ce1b3b21630b7225997181a5c24e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157070)) **GitLab Enterprise Edition**
- [Validate provided group parameters](https://gitlab.com/gitlab-org/gitlab/-/commit/97775beb0d5ebcd535758ee2d9033e4ecf7b1a87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156977)) **GitLab Enterprise Edition**
- [Vertically align group and project header](https://gitlab.com/gitlab-org/gitlab/-/commit/642efcacfc1806a09fae2dfcafb7ee3471b6af63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157097))
- [Fix undefined method error for invalid ref](https://gitlab.com/gitlab-org/gitlab/-/commit/34aed5beeb5dd85fb0236cf80635dfb6a082529a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157180))
- [Fix NoMethodError for Files API](https://gitlab.com/gitlab-org/gitlab/-/commit/756ab645265f272b30afc340cc26427f5cd77dcf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157193))
- [Do not show minimal access role as option](https://gitlab.com/gitlab-org/gitlab/-/commit/38f785705ef873e7b869f5f76a288f709ce21181) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156882))
- [Include pagination values in request](https://gitlab.com/gitlab-org/gitlab/-/commit/d48821a5f2aff9acb63a7a8ca47c043fecfbfd1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157158))
- [DAST Scan library: Fix Tailwind classname](https://gitlab.com/gitlab-org/gitlab/-/commit/26a52654f5b5ab7530f6b52096e9b0d4db3787f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157170))
- [Fix line number for larger numbers](https://gitlab.com/gitlab-org/gitlab/-/commit/6308ab66ca7ab4bb90d3659cc98e8cd58dc557be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156820))
- [Fix 500 on Changelog config](https://gitlab.com/gitlab-org/gitlab/-/commit/fbf5c11464a6a462542a3ee7e273dc8a846c7be1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156938))
- [Fix spacing info popover icon on dependencies table](https://gitlab.com/gitlab-org/gitlab/-/commit/64b8b263e68d19e57113c708da2250cc365e0588) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157148)) **GitLab Enterprise Edition**
- [Revert "Merge branch '430915-enhance-permission-selector' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/642d945976e52049db6115742a57cce413a881c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157142)) **GitLab Enterprise Edition**
- [Do not show cluster image scanning vulnerabilities on development tab](https://gitlab.com/gitlab-org/gitlab/-/commit/08d6018da94e28bb4371be7974a486b5795848ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157018)) **GitLab Enterprise Edition**
- [Cap vulnerability report tab count if it exceeds cap count limit](https://gitlab.com/gitlab-org/gitlab/-/commit/f355e1e6b328ee9853ba646fe7f2d358515ddb20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157116)) **GitLab Enterprise Edition**
- [Enable the query workItemsByReference to accept a group path](https://gitlab.com/gitlab-org/gitlab/-/commit/1332f34e8f9acc5e3809e0ae8f7f7a2ea2ea9ca1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156881)) **GitLab Enterprise Edition**
- [Improve work item query when sorting by updated_at](https://gitlab.com/gitlab-org/gitlab/-/commit/d0a53cb7cb857d799536aeb00e4d97b3c4ba09e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157075))
- [Don't introduce Unicode null character while escaping it](https://gitlab.com/gitlab-org/gitlab/-/commit/cecc43e3618913788465fd9c9689fd6ee321ff32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157060)) **GitLab Enterprise Edition**
- [Fix related work item links syncing](https://gitlab.com/gitlab-org/gitlab/-/commit/e111fd6754d54c0c9946db008113ec83344d36a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157045)) **GitLab Enterprise Edition**
- [Fix extra blank space above drawer work item attributes sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/c44960893e0942a16034e7a194e2bb50407fb6cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155156))
- [Only enumerate commits in pre-receive check if push came from Web](https://gitlab.com/gitlab-org/gitlab/-/commit/ce85e857b4542999907b7826ce66e4daab26c59d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156965))
- [Fix layout of issue list top area on small viewports](https://gitlab.com/gitlab-org/gitlab/-/commit/24bcaba38df863e2a6ab609655f97e08b46a3f61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156972))
- [Fix the workItemType to be valid](https://gitlab.com/gitlab-org/gitlab/-/commit/0662cbfcbabbf54a1f4f65435f1919474460dce9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156879))
- [Ensure all analytics breadcrumbs display](https://gitlab.com/gitlab-org/gitlab/-/commit/8917292f05cc9f9edeabba64d382491360c76dca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156454)) **GitLab Enterprise Edition**
- [Fix missing forked_from_project in projects API for unauth users](https://gitlab.com/gitlab-org/gitlab/-/commit/ebc53851c0b9e0d627eb84a628612e79480ddf85) by @_ZN3val ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154289))
- [Fixes notebook markdown failing to render](https://gitlab.com/gitlab-org/gitlab/-/commit/ae191bc941275d408475271473b03117167b6a2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156908))
- [Fixed Numpad enter key event](https://gitlab.com/gitlab-org/gitlab/-/commit/b855762ffefb354ce697c47c843ee9c776646824) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156636))
- [Fix error message when adding confidential epic to public issue](https://gitlab.com/gitlab-org/gitlab/-/commit/95ede989758b6db216d0afe82c3189d6bfb5e5eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152972)) **GitLab Enterprise Edition**
- [Include empty groups in mentions autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/38c719cc94eee2165cbae364c1a45780ed960866) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156795))
- [Fix Bitbucket importer MR reviewers](https://gitlab.com/gitlab-org/gitlab/-/commit/dbc9b292da6686335baf1ce784840fb26ee008fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156383))
- [Use widget presence check for rendering Hierarchy widget](https://gitlab.com/gitlab-org/gitlab/-/commit/f449e168011917d571fc018e7ed0c4c2bb79509f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156836)) **GitLab Enterprise Edition**
- [Skip IP lookups in validating URLs on certain conditions](https://gitlab.com/gitlab-org/gitlab/-/commit/e8190bd3d0ad87b98f920f144e098a6a2e08cca0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156547))
- [Add missing ResourceLinkEvent#synthetic_note_class](https://gitlab.com/gitlab-org/gitlab/-/commit/e55071ecfb409e1b7561c0b68f33b6eb90c0d317) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156204))
- [Fix missing require_reauthentication_to_approve in API](https://gitlab.com/gitlab-org/gitlab/-/commit/a0a0f4a5900f5db22d3f2d9c68bf1423910742f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156554)) **GitLab Enterprise Edition**
- [Fix Inactive Project Deletion reset deletion date](https://gitlab.com/gitlab-org/gitlab/-/commit/a5268a1b0b0991464c82aacda538c9054612516e) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156036))
- [Remove the `deduplicate_security_report_ingestion_jobs` FF](https://gitlab.com/gitlab-org/gitlab/-/commit/e5c3e03ae4c6cd916fce92d1d06bbd9317ed42fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156374)) **GitLab Enterprise Edition**
- [Apply `gl-break-word` to test file name in Pipeline test suite detail](https://gitlab.com/gitlab-org/gitlab/-/commit/da5605827e28ce50d88c3c3f7b59459a36ca1d0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156668))
- [Remove null bytes when importing diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/c3a333d5d4995108be679b2a90762f55cd3b70a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156659))
- [Fix resolving namespace conflicts on creating internal user](https://gitlab.com/gitlab-org/gitlab/-/commit/46c2d55b45babf686012ab40077353bb319eb868) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156643))
- [Fix redirect to docs.gitlab.com when no custom doc_url is configured](https://gitlab.com/gitlab-org/gitlab/-/commit/44e5d9c9cb3ece3351ca73514b0138011f15e25b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156642))
- [Quarantine metrics_test_fetches_top_job_data](https://gitlab.com/gitlab-org/gitlab/-/commit/b6984b9f600cebee691c81aae8c3f7b798ac4db3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156606))
- [Fix rename functionality using "Edit single file"](https://gitlab.com/gitlab-org/gitlab/-/commit/cd94fc7b67c1e46e4879c4f935ba2f74b3e798c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156512))
- [Resolve pagination issue](https://gitlab.com/gitlab-org/gitlab/-/commit/8bf5e49bd5c9d21ab9229505f4893d192d9e3718) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156391))
- [Read more: Fix background color in darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/ab86f679430f905647da84f3cd026eea4fd40a6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156483))
- [Use LocalStorage for frequently used emoji](https://gitlab.com/gitlab-org/gitlab/-/commit/b464009dd1682e3946a94b2a504944fdb66b143c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156569))
- [Fix alignment of commit in admin jobs page](https://gitlab.com/gitlab-org/gitlab/-/commit/d630ecb9c8fe9013fced4e2c0df5a4594f56e0a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156565))
- [Fix kubernetes tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/33cf2695a8c4f0980fd11c556cf5766c9cd9b850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156508))
- [Skip conflict check when adding to merge train on pipeline success](https://gitlab.com/gitlab-org/gitlab/-/commit/ff44e19a433d6e2e00be36fd600b59ecf40f9d19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156079)) **GitLab Enterprise Edition**

### Changed (231 changes)

- [Change schema for sbom_sources](https://gitlab.com/gitlab-org/gitlab/-/commit/f3b79455de4cc16d95579f0448e33be91ae72e89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158597))
- [Disables remaining prometheus integration endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/216e81eca14044b99eeb1bf5dca27dec3b8f3e8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158356))
- [Change format of iteration dates](https://gitlab.com/gitlab-org/gitlab/-/commit/b95bd4c7ae6032fffcd6f58f324c1daf00226402) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155894)) **GitLab Enterprise Edition**
- [Use sentence case for security and compliance](https://gitlab.com/gitlab-org/gitlab/-/commit/02c120454f547a081a5e6482e81df0f3ab2bc761) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159260))
- [Rename DAG feature to needs](https://gitlab.com/gitlab-org/gitlab/-/commit/805a9f5fb0237f935a7ac5da0917296d061c22a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157899))
- [Clarifies error text for confidentiality](https://gitlab.com/gitlab-org/gitlab/-/commit/121f9773af11ff71f5272699bfae03bc3e203ad3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159024))
- [Improve AI impact analytics dashboard trend indicator tooltips](https://gitlab.com/gitlab-org/gitlab/-/commit/7e0f21055af23dad7badfabc991a5b5c97ec30ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159128)) **GitLab Enterprise Edition**
- [Update admin health check page UI](https://gitlab.com/gitlab-org/gitlab/-/commit/11a7b3adc2ed5928562c96b73a56ce9924cd0a78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158355))
- [Update scheduled_scans_max_concurrency for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/67dd42dbe5df22c7fa7b2a68bb6d9f7901961032) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157828)) **GitLab Enterprise Edition**
- [Defaulting Duo Chat to use Sonnet 3.5 and updating related documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/9607104202f2614c09b189dc9678060ccee1906f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159248)) **GitLab Enterprise Edition**
- [Cleanup telesign_high_risk_cc_validation feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8c8d22d2462b3984cac418ba6b2c155e47a4f8ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159279)) **GitLab Enterprise Edition**
- [Updating LooseForeignKey cleaner service to not raise](https://gitlab.com/gitlab-org/gitlab/-/commit/c17516763c4ea1e8cee50b697f3f874f93877fb0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154185))
- [Backfill zoekt replicas on zoekt indices](https://gitlab.com/gitlab-org/gitlab/-/commit/11a0e166b214ca057de5b47d58ff57efefe59507) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157849))
- [Use sentence case for Admin area](https://gitlab.com/gitlab-org/gitlab/-/commit/f7dd3d965a91736f4b8ca7edd8d3a1c227f860d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158935))
- [Use group organization for import user personal namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/ee2aa8f23885690452627c428ba162d7d648d351) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159222))
- [Update background jobs header](https://gitlab.com/gitlab-org/gitlab/-/commit/9f3f0235736b4fe1121e5f098ec489d3fecdf3e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158983))
- [Remove pages from navigation when disabled in settings](https://gitlab.com/gitlab-org/gitlab/-/commit/c81e6fbd69ba5f5532e0b54f3dc716ec96e0f6d9) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158488))
- [Remove view summary experiment label](https://gitlab.com/gitlab-org/gitlab/-/commit/09bdb4dcd7d7ed97b5a2f518426e81795a5c3e37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159139)) **GitLab Enterprise Edition**
- [This MR adds new option for group dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/65b61d7c3b887c1f1b9d5de95c1f547b48b829ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158080)) **GitLab Enterprise Edition**
- [Migrate os sbom occurrences to correct components](https://gitlab.com/gitlab-org/gitlab/-/commit/6015871347123c24c1566e4c0165af887d256675) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152585))
- [Use monospace font for code inputs in Pages setup](https://gitlab.com/gitlab-org/gitlab/-/commit/26a838eeb8563805216faf1ac983d4aa2f0b996f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158673))
- [Add or text between conditions sections for scan result policy](https://gitlab.com/gitlab-org/gitlab/-/commit/dbf35f870009a38f88b5fa2fb5e3092d6edcdb0e) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158508)) **GitLab Enterprise Edition**
- [Move CI lint button](https://gitlab.com/gitlab-org/gitlab/-/commit/8063ab8e34e1c569dee7c828144ac9b407ff057a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158827))
- [Separate terminated workspaces into a new tabbed list view](https://gitlab.com/gitlab-org/gitlab/-/commit/9557c80c736627e0fb28a3dbc078a94f6eb3e429) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153322)) **GitLab Enterprise Edition**
- [Summarize issues using Anthropic](https://gitlab.com/gitlab-org/gitlab/-/commit/2885c45ff2feb15c7333342dd0548fdd31a59dd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159133))
- [Add details to client-side secret detection warnings](https://gitlab.com/gitlab-org/gitlab/-/commit/908d14efd49f636e1fc6a3163dd77d3765e69149) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156503))
- [Enforce job uniqueness with pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/382207a516c91312c9b481f3cf4e17c1e55a3016) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158949)) **GitLab Enterprise Edition**
- [Use sentence case for audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/4231b823a9c173089c4257384e053ad8aeafb09f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158996))
- [Renames TanukiBot to GenerateEmbeddingsCompletionsService](https://gitlab.com/gitlab-org/gitlab/-/commit/77db17e1db5c7d3c2d99abf8aba67137d8c633ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158209)) **GitLab Enterprise Edition**
- [Merge notes unification FF under more generic unification FF](https://gitlab.com/gitlab-org/gitlab/-/commit/270a0d9df6d76d86ad4ef7ea2ad6f46754d12bc1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158764))
- [Author admin permissions for PersonalSnippet notes](https://gitlab.com/gitlab-org/gitlab/-/commit/e78544866cec31950d38ba39b540335eca466a30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158715))
- [Merge Request auto close issues now checked on merge](https://gitlab.com/gitlab-org/gitlab/-/commit/22905c5f0808e2b20ecb9d0daadc4cf8227a63be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158395))
- [Verify replicable after create/update](https://gitlab.com/gitlab-org/gitlab/-/commit/358f6dae5e65de9194b313dd5458faadc3bafef3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157697)) **GitLab Enterprise Edition**
- [Add Notify mutation to resend email](https://gitlab.com/gitlab-org/gitlab/-/commit/2b510a42398afbf069c7fe4b4245e80b49f7bf73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159073))
- [feat: Decompose sbom_source_packages from sbom_occurrences](https://gitlab.com/gitlab-org/gitlab/-/commit/b90f4b6e36209c7aa009ecdf5fb916f3518fc02c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158143)) **GitLab Enterprise Edition**
- [Use Duo for summarize comments](https://gitlab.com/gitlab-org/gitlab/-/commit/49499622ba1f4dd3231bff134a329e4c85bf4201) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156650))
- [GraphQL: Rename CiRunnerJobExecutionStatus RUNNING to ACTIVE](https://gitlab.com/gitlab-org/gitlab/-/commit/b27d0d92dce5dd10d2986b666c6cd46e4662880e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159002))
- [Update health check page](https://gitlab.com/gitlab-org/gitlab/-/commit/35b777c4e28d6c5e6cb2dc1aaeaf8a01686237e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158986))
- [Update usage trends feature to sentence case](https://gitlab.com/gitlab-org/gitlab/-/commit/c4ea05a622c8d3d21e99bd25eb5b49f15c2e00cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158979))
- [Use sentence case for background migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/d4a6eea7c63e694cb3b25f22f1156c9062f44614) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158981))
- [Used new process to gen gitleaks.toml](https://gitlab.com/gitlab-org/gitlab/-/commit/bc1ca822c2d863df8935121782ce15863f759ade) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158259))
- [Merge labels unification FF under more generic unification FF](https://gitlab.com/gitlab-org/gitlab/-/commit/ca57ef643232626642582c2051cc5bdab533049e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158643))
- [Show selected work item labels at top of the list](https://gitlab.com/gitlab-org/gitlab/-/commit/02b81f94c42213d9d9b21ec10be89cc43d558c3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158005))
- [Migrate groups dashboard to filtered search and sort](https://gitlab.com/gitlab-org/gitlab/-/commit/a46b96c154fb88eb533cf9f59fe44a8ed974f0cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157667))
- [Use Active badge instead of Running badge in runners list](https://gitlab.com/gitlab-org/gitlab/-/commit/12fbcaa099cb483fc19b8338ee3303b2e6e949dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157935))
- [Update admin background jobs page](https://gitlab.com/gitlab-org/gitlab/-/commit/653a55a2906304bd647a25a75d0dcdb414d070d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158351))
- [Add license type to overview](https://gitlab.com/gitlab-org/gitlab/-/commit/228878e85b2515faf21c2d188a2db31118d60860) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158245)) **GitLab Enterprise Edition**
- [Update dependency ai-gateway to v1.10.0](https://gitlab.com/gitlab-org/gitlab/-/commit/72ad1b5a449a65297b73e45666960010926f78c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158590))
- [Add title and subtitle on the standalone GitLab Duo settings page](https://gitlab.com/gitlab-org/gitlab/-/commit/7229273fd5694916aad10cd94512564efa90ce2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158482)) **GitLab Enterprise Edition**
- [Exclude archived projects from dependency list search filter](https://gitlab.com/gitlab-org/gitlab/-/commit/504cbe3f2d1627e270d63b643e476dfbd0d28bf6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158799)) **GitLab Enterprise Edition**
- [Hide Service Desk from navigation if disabled in settings](https://gitlab.com/gitlab-org/gitlab/-/commit/b93b46a577c2bc952a0dfabbb824d33d0b6dcf40) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158483))
- [Remove Gitlab.com check for last_published_at](https://gitlab.com/gitlab-org/gitlab/-/commit/73a027be56a2f1c12b10dd1cd29e60f00fa9c82f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156423))
- [Always allow license sorting for group dependency list](https://gitlab.com/gitlab-org/gitlab/-/commit/5271ec0ec5c4faf627cbd36c4ac2437c5e239758) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158684)) **GitLab Enterprise Edition**
- [Update spam logs UI](https://gitlab.com/gitlab-org/gitlab/-/commit/1ab4f62f1cd09b8c88a64a738a7a0bdf02a41085) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156950))
- [feat: Add doorkeeper device auth support](https://gitlab.com/gitlab-org/gitlab/-/commit/b33cfbc4d56c1ae808949012dc1dc791b6467080) by @johnwparent ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155622))
- [Explain quick actions inline in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/c4fcb325c334eaa81cd6b2952a34190b3fd1ad60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158367))
- [Add linked projects to framework](https://gitlab.com/gitlab-org/gitlab/-/commit/be668ec4482846931c6da8d3a6de058c292e169c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158403)) **GitLab Enterprise Edition**
- [Enable submit button by default](https://gitlab.com/gitlab-org/gitlab/-/commit/dedda453d11fcf5590723c3dc5dbb684c8a7f6b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158249)) **GitLab Enterprise Edition**
- [AI impact analytics dashboard: Add tooltip when there is no % change](https://gitlab.com/gitlab-org/gitlab/-/commit/f3447df4b029a9fdb443c409326a62ec8d0e6e48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158376)) **GitLab Enterprise Edition**
- [Remove search_merge_request_query_builder FF](https://gitlab.com/gitlab-org/gitlab/-/commit/f3326fa520bfff0751a1821f3c70277e50b1946d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158135)) **GitLab Enterprise Edition**
- [Move merge request files now shown warning to diff panel](https://gitlab.com/gitlab-org/gitlab/-/commit/39f82a3a72ddd33f9f2be15342588f5266d66994) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157597))
- [Notify Admin re: the hierarchy limits in displaying Group(s) statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/47cea8c39958630931cfa294b280eb433cafa64b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155554))
- [Allow filtering Resource Access Tokens by state in the REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/c78720efd9285328a5a653820ed3509a0b29e41b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158155))
- [Add `seats_in_use` to GitlabSubscriptionHistory trarcked attributes](https://gitlab.com/gitlab-org/gitlab/-/commit/a2b3e7bdd7123e46836c4df94efcfcfe84151e07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157311)) **GitLab Enterprise Edition**
- [Sets elaticsearch_issue_upsert flag as default enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/9b81c92337a7d933b221f2a9b253ec6633834b34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158194)) **GitLab Enterprise Edition**
- [Add placeholder data to member tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/6b4f5fae5a564da827b00f47c4de69be52ae1248) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158569))
- [Prohibit "default" as compliance framework name](https://gitlab.com/gitlab-org/gitlab/-/commit/9828c418eb60a7fb5a79e46de4dee70b80bd3099) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149548)) **GitLab Enterprise Edition**
- [Backfilling null project_id for p_ci_builds](https://gitlab.com/gitlab-org/gitlab/-/commit/bb06971eb127222b320b8950583c136fc8fe77f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158480))
- [Switch deployment approvals group view to Vue](https://gitlab.com/gitlab-org/gitlab/-/commit/402b8f34d28c6481031de9121c4a1ed00c60d952) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158052)) **GitLab Enterprise Edition**
- [Update protected environments to handle group view](https://gitlab.com/gitlab-org/gitlab/-/commit/52452c34b9d2073acdc982461b3c5873d99ffa19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157686)) **GitLab Enterprise Edition**
- [Add trial and update users_over_license_count in CurrentLicenseType](https://gitlab.com/gitlab-org/gitlab/-/commit/a576f08847f6b2db61cfc18c66f66281c1b45c9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155473)) **GitLab Enterprise Edition**
- [List selector component for groups can fetch project only groups](https://gitlab.com/gitlab-org/gitlab/-/commit/18b39712043b895b1b980a681c355c2fc899ff36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158253)) **GitLab Enterprise Edition**
- [Update admin credentials page](https://gitlab.com/gitlab-org/gitlab/-/commit/b3b59e785ea9a6f389cfe121e0d2a93cdb0d0ab6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158451))
- [Update Tools Injector Image, PAT scope with additional ENV](https://gitlab.com/gitlab-org/gitlab/-/commit/228a9ccdab705a96e7513fb8f049e455dcdf07f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156714))
- [Update Cloud Connector architecture docs](https://gitlab.com/gitlab-org/gitlab/-/commit/16dddfacbef791ac45712e3a10ad543b2ea21349) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157911)) **GitLab Enterprise Edition**
- [Update admin background migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/618e7c72b88d42275ae53b5dba5e05deccf67ece) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158349))
- [Clarify CI Job Token wording](https://gitlab.com/gitlab-org/gitlab/-/commit/cc67e266a9502e95f1b0cd7dbf3f9741362e9332) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156989))
- [Adds info alert about cleanup policy regexp anchors](https://gitlab.com/gitlab-org/gitlab/-/commit/597e1c2d15f0e533f431a5c7eaf815dc06016f0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157888))
- [Remove unicode_escaped_blob feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b97da58a57d56c8116b342ae1959be8afb825597) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158370))
- [Update admin topic page](https://gitlab.com/gitlab-org/gitlab/-/commit/3a6f47bc121c454f6d0b778790b1eef7e93b177e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157848))
- [Added Promotion Management for CreatorService](https://gitlab.com/gitlab-org/gitlab/-/commit/326329a5d856609a1f9e97aec9caa363af67f209) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156891)) **GitLab Enterprise Edition**
- [Allow access token access to usage_data API](https://gitlab.com/gitlab-org/gitlab/-/commit/4bcea84dfecd37e25c532c53bb571ed5634255ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158085))
- [Default cube analytics queries to the last 7 days](https://gitlab.com/gitlab-org/gitlab/-/commit/ff012ea2897764f741c1dc268daf13f61f86e45c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158206)) **GitLab Enterprise Edition**
- [Refactors QueueExistingMemberService](https://gitlab.com/gitlab-org/gitlab/-/commit/61f33606c8661f1cd64c27d8bbd5d0c539941de7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156801)) **GitLab Enterprise Edition**
- [Enable custom dashboards by default on projects](https://gitlab.com/gitlab-org/gitlab/-/commit/80138e0b971eda439ad9f9a38197f7d74c8b6884) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157917)) **GitLab Enterprise Edition**
- [Fixing target_table_name for build_name foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/e77f8bc31e151f1180045bcf88f21126062a36a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158300))
- [Make filter based visualization designer generally available](https://gitlab.com/gitlab-org/gitlab/-/commit/698ef8c44436233ddfa77335ebbdf4291ceb7283) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158072)) **GitLab Enterprise Edition**
- [Ignore `confidence` column on Security::Finding](https://gitlab.com/gitlab-org/gitlab/-/commit/4003634ceb0ed0e4301adb861d0249478559689a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158035)) **GitLab Enterprise Edition**
- [Remove DuoChat from Help center](https://gitlab.com/gitlab-org/gitlab/-/commit/db279dde3ea6c08a74a5bd0e66c42277af6b7452) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157759)) **GitLab Enterprise Edition**
- [Remove wiki sidebar limit](https://gitlab.com/gitlab-org/gitlab/-/commit/6fe5c48e96617b5a201e2ce5bb7df0e8359f9f23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158084))
- [Improve token access add form](https://gitlab.com/gitlab-org/gitlab/-/commit/baabb747fcf91b4c303eb31fcbe372d61e3ac6e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151730))
- [Move create repo position](https://gitlab.com/gitlab-org/gitlab/-/commit/1178913de16f344a5486106377b31f70dd3ebe22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157707))
- [Fix CI icons shape](https://gitlab.com/gitlab-org/gitlab/-/commit/4b3a40e406c3138882bb52c6d880b21a90271524) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158204))
- [Support expanding references for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/603ece973f525e7609f42e6f84304fc69b36089d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157963))
- [Align the visual presentation of the action between groups and projects](https://gitlab.com/gitlab-org/gitlab/-/commit/08c107ecde68b41339eb711c2b7d0a610904b376) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157727)) **GitLab Enterprise Edition**
- [Update admin project layout](https://gitlab.com/gitlab-org/gitlab/-/commit/e76d5ba332f8599570560c66fb7c854d23eaf5ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157529))
- [Align admin users account content](https://gitlab.com/gitlab-org/gitlab/-/commit/e33210ac0324bffa770e5a573d6472ce0e9d8a76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158067))
- [Clean up signup_intent_step_one experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/78d7591000f0ab105df35017e0a7c608633751d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157181)) **GitLab Enterprise Edition**
- [Show wiki sidebar on a 404 page](https://gitlab.com/gitlab-org/gitlab/-/commit/164db2e91935ac1469f42e1a6597e28408900217) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158088))
- [This MR adds validation for policy action](https://gitlab.com/gitlab-org/gitlab/-/commit/f14353e720e45e59f698309cb8a9c885b53ccac1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156528)) **GitLab Enterprise Edition**
- [Update welcome screen](https://gitlab.com/gitlab-org/gitlab/-/commit/aa1f14c90596e595426c7c841041156fcc5ab47e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156514))
- [Update users page for admin view](https://gitlab.com/gitlab-org/gitlab/-/commit/f55b68653c9c39e9c172e1ea069f637507977ad8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157314))
- [Update concurrency_limit for CreatePipelineWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/169acd04ead7833127f0340dc3330d0de65704f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158075)) **GitLab Enterprise Edition**
- [Added Finder, and correponding scope](https://gitlab.com/gitlab-org/gitlab/-/commit/7269bbba6850f4e791eebc969853b7fe669f1401) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154555)) **GitLab Enterprise Edition**
- [Zoekt: Add ctags support](https://gitlab.com/gitlab-org/gitlab/-/commit/fa8d2e1db1ccdc39b6de6b5f1955ae29e7eef992) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158049)) **GitLab Enterprise Edition**
- [Remove creating framework at sub-group level](https://gitlab.com/gitlab-org/gitlab/-/commit/cde82e647ab065dd61fbc8c8e67aa9e42a89e0a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157868)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint for `remote_mirrors.project_id`](https://gitlab.com/gitlab-org/gitlab/-/commit/19daf7b6c5386dc282490f9240708d64ef778e76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153959))
- [Add `taskCompletionStatus` to the work item UI](https://gitlab.com/gitlab-org/gitlab/-/commit/22a7a948a5a87db3440efee764734ab8674daddf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156589))
- [Update semver_dialects gem version](https://gitlab.com/gitlab-org/gitlab/-/commit/9cfb70e0df3503e4d3d83faa343ffb647ae5503f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157521))
- [Default enable FF group_level_vulnerability_report_grouping](https://gitlab.com/gitlab-org/gitlab/-/commit/3f5973054c408d9abe137cf150d54d43985f72d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157949))
- [Update abuse reports list view](https://gitlab.com/gitlab-org/gitlab/-/commit/3a15b7fa01bb2baaaffcfc735b81f2c3c7991ee1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157681))
- [Use SettingsBlockComponent for admin push rules](https://gitlab.com/gitlab-org/gitlab/-/commit/a79bec61becdd9d306e9ec835cd690b050226a11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157611))
- [Sync epic work items to legacy epic by default](https://gitlab.com/gitlab-org/gitlab/-/commit/f2c68d054ae098cf54d37421f0952d838fad5ecd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157789)) **GitLab Enterprise Edition**
- [Add organization_id to stage event hashes table](https://gitlab.com/gitlab-org/gitlab/-/commit/16494994cb8544388fd068b9b0396f3a63c8ac12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156621))
- [Admin groups: Improve display of content](https://gitlab.com/gitlab-org/gitlab/-/commit/8014ea9fcbd2232da04fcdf02f3e35c6aedccf98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157420)) **GitLab Enterprise Edition**
- [Update PMG architecture blueprint](https://gitlab.com/gitlab-org/gitlab/-/commit/d782d03cb892334bd1e7142ac1569d4c98b14a16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157806))
- [Fix required approvers validation](https://gitlab.com/gitlab-org/gitlab/-/commit/388f43277c5f82ea00a37ee2e155a8154c1490f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157777)) **GitLab Enterprise Edition**
- [Update graphiql-rails gem](https://gitlab.com/gitlab-org/gitlab/-/commit/313046daf347a0455ca7eab430fcb3b8b5d08af3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135010))
- [Modified UX of command palette](https://gitlab.com/gitlab-org/gitlab/-/commit/4c2f759439605e210980ef1816b756bd2f7e2d08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157015))
- [Admin settings: Migrate network settings to SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/4a7b408efa1375c8d5196b288d2d323c4579f835) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157051))
- [Migrate oauth applications to use CRUD container](https://gitlab.com/gitlab-org/gitlab/-/commit/b5348d678230f1201ec50b71077e939b0e3411fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156903))
- [Migrate broadcast messages page](https://gitlab.com/gitlab-org/gitlab/-/commit/093159d629902435e92561d9bcceb5771ca4576c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156895))
- [Remove the data preview option from the visualization desinger](https://gitlab.com/gitlab-org/gitlab/-/commit/644d80d912d522194ede40687430430008e9b24f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157744)) **GitLab Enterprise Edition**
- [Update dependency ai-gateway to v1.8.0](https://gitlab.com/gitlab-org/gitlab/-/commit/9fbdaef10c2324ea2453e2f87be57f1cde0f06a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157736))
- [Extract SSoT for pipeline sources for which SEP should be enforced](https://gitlab.com/gitlab-org/gitlab/-/commit/c716fd84ceb2db0556918e14dfbe63911d0fec08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157588)) **GitLab Enterprise Edition**
- [Move Mermaid too large alert to the beginning](https://gitlab.com/gitlab-org/gitlab/-/commit/2c21c66ee910b4e07e8a978a0b06609dcfc9564d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157735))
- [Update bulk create service for custom software licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/31025b8cb969cc45ce7f11c1b1b75d714b1c770e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155588)) **GitLab Enterprise Edition**
- [Raising error in mutation when more than 1 frameowrks for project](https://gitlab.com/gitlab-org/gitlab/-/commit/cdad457636d8d7ad0de5ed065ac0fb4efa1460fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155854)) **GitLab Enterprise Edition**
- [Update vendor/spdx.json to v3.24](https://gitlab.com/gitlab-org/gitlab/-/commit/74af77ec2263d9ff12164933cae35c086d40aaf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157653))
- [Add search_type param to SearchService](https://gitlab.com/gitlab-org/gitlab/-/commit/065d10f065ed76394a7e0f17ae8d4c7605911d90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157022))
- [Update wording for pipeline deprecation banner](https://gitlab.com/gitlab-org/gitlab/-/commit/d89e8c6510b3fef6c3404374e29357d542181e95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157595)) **GitLab Enterprise Edition**
- [Route resolve vulnerability through the Anthropic client](https://gitlab.com/gitlab-org/gitlab/-/commit/854029222599e6288722b294811274872738796a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156671)) **GitLab Enterprise Edition**
- [Add read_runners custom ability](https://gitlab.com/gitlab-org/gitlab/-/commit/a0f8c3098e87b8fa09bca3ca6838511a07efdd28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156798)) **GitLab Enterprise Edition**
- [Migrates deploy keys to use CRUD container](https://gitlab.com/gitlab-org/gitlab/-/commit/6652d0ef24c4eafd866011a267ba3eb2b35263e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156909))
- [Allow blob window size to be specified](https://gitlab.com/gitlab-org/gitlab/-/commit/1b472b9a753771ec77bddc3e67cbf2aa7b9785a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157168))
- [Remove ":" for drawer title: overwritten part](https://gitlab.com/gitlab-org/gitlab/-/commit/12a479b2f361049980afc7c4da9f01a77d23f11a) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157550)) **GitLab Enterprise Edition**
- [Adds snowplow form error events](https://gitlab.com/gitlab-org/gitlab/-/commit/2546c6284592d4649a6e66f84603f0969e63a9a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157543)) **GitLab Enterprise Edition**
- [Adjust layout of iteration report issues table](https://gitlab.com/gitlab-org/gitlab/-/commit/0028e3fc79a7bfeb4c62be91c25261327bcd54c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157377)) **GitLab Enterprise Edition**
- [Remove "+" icon and add word "new" to button](https://gitlab.com/gitlab-org/gitlab/-/commit/e01d8f7eaac2dddfa4cf5a3a94028d122a1d7dd9) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157394)) **GitLab Enterprise Edition**
- [Update admin groups layout](https://gitlab.com/gitlab-org/gitlab/-/commit/a1af6477a95333aaf63f46a4a884e8b7840df809) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157201))
- [Add support for parsing CI log timestamps](https://gitlab.com/gitlab-org/gitlab/-/commit/76f92b62bbb4c378212372cec41c7704039c7164) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155695))
- [Reduce the amount of variants for GitLab UI badges](https://gitlab.com/gitlab-org/gitlab/-/commit/499a179102694e0ac7c2e1a7d45a207641dbd151) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156880))
- [Duo Chat cancel button integration](https://gitlab.com/gitlab-org/gitlab/-/commit/3f12dc8a3d330d357d5e142b25c53457f8b694ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156880)) **GitLab Enterprise Edition**
- [Remove "scan" word from execution variable](https://gitlab.com/gitlab-org/gitlab/-/commit/e2026f16ed7890dd76181d805b71fd29878e3718) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156415)) **GitLab Enterprise Edition**
- [Update admin product analytics settings](https://gitlab.com/gitlab-org/gitlab/-/commit/d713b19f316db1a69a9a49aa4e8c2ea32380fb7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157088))
- [Allow assigning compliance frameworks at sub-group level](https://gitlab.com/gitlab-org/gitlab/-/commit/08c7ab96dc50691819a0a98da0d9177dc2e595fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157412)) **GitLab Enterprise Edition**
- [Migrate CI/CD Variables settings to CRUD container](https://gitlab.com/gitlab-org/gitlab/-/commit/caba42c7f858e66f859270803669c72672a8c3cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157276))
- [Update admin license and compliance layout](https://gitlab.com/gitlab-org/gitlab/-/commit/384c5ef0f03a996bd73fb8dc887ae0a06d733d0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157095))
- [Remove drill-down link for code suggestions usage metric](https://gitlab.com/gitlab-org/gitlab/-/commit/8a9b34bb78361f818b4fd8ca6b91c1ad4fa12285) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156984)) **GitLab Enterprise Edition**
- [Change History links to 'View import history' buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/609af389f719a76b4c758ec5e0bf668088167961) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156373))
- [Update tools injector image](https://gitlab.com/gitlab-org/gitlab/-/commit/8cb33746ed2a41060e51ab226309da5516be40ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156918)) **GitLab Enterprise Edition**
- [Admin labels: Migrate to use CRUD container](https://gitlab.com/gitlab-org/gitlab/-/commit/6fb5e3e24e9d2fce5978d1898c8a9455549ec2ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156923))
- [Admin settings: Migrate reporting section to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/ac82c7fdcb612e8ebbc5bb7704478bae7051a618) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157047))
- [Admin settings: Migrates repository page to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/058017c2bfd57cecaaa34d031eaafb89ac92360c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157039))
- [Admin settings: Migrate analytics section to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/a0c84238d13d5bd3eec550898a2084690ffef4b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157054))
- [Admin settings: Migrate preferences to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/1443c2bef7c0598888ae3480cd95380f7d939517) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157053))
- [Admin settings: Migrate metrics settings to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/af2e67d8ce93db82586ef8aac4ea088efda73aa2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157050))
- [Admin settings: Migrate templates section to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/9ceddc16cd553a45aaecdc2c4399d6399f18e7d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157048))
- [Admin settings: Migrate CI/CD settings to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/6ea284f56c218f06f6400c43cc434197c565ec6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157040))
- [Admin settings: Migrate settings blocks of general settings](https://gitlab.com/gitlab-org/gitlab/-/commit/f73caead94a079d98b9c487b87e513a98240f24b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157033))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/3c6a6b7270d07856a38dcef472640ece462b2337) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156723))
- [Pipeline graph dropdowns: Use GlBadge for indicating jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/cfcab231757af7fa07ccd5e23fd617140e1013c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156160))
- [Update projects page for admin view](https://gitlab.com/gitlab-org/gitlab/-/commit/30ee894176c4fc42b1c943a4a222a3f395c2bc00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156790))
- [Require user to solve Arkose challenge on every PN verification attempt](https://gitlab.com/gitlab-org/gitlab/-/commit/8d9db028c231f4dc594e78dd5ac35cc69701fcca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156865)) **GitLab Enterprise Edition**
- [Migrates File Hooks to use CRUD Component](https://gitlab.com/gitlab-org/gitlab/-/commit/39b218efe1edae7ca6d05e28d39cf45840a16593) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156900))
- [Admin settings: Migrate advanced search to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/25f6ce6fc714129beeb1d5c4070fbc35d16ce717) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157038))
- [This MR updated approve layout](https://gitlab.com/gitlab-org/gitlab/-/commit/5d184548cc8224176f0764a9b0e32001b817418c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156628)) **GitLab Enterprise Edition**
- [Conditionally handle AuthorizationsChangedEvent when policies exists](https://gitlab.com/gitlab-org/gitlab/-/commit/0b94a9895a58607246b47258cf641ae1d72240e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156775)) **GitLab Enterprise Edition**
- [Add report_type to Approval Rules APIs](https://gitlab.com/gitlab-org/gitlab/-/commit/e67fbe0b7de9bc40c9de2c8218faba608b8ba592) by @PatrickRice ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155772)) **GitLab Enterprise Edition**
- [Update locked application setting popover](https://gitlab.com/gitlab-org/gitlab/-/commit/48b93da24c1cf9c143e73a29bc5c6e2f5176c866) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156926))
- [Enable assign resource v2 by default](https://gitlab.com/gitlab-org/gitlab/-/commit/3bdac40f8c0ebd77a7e4a14fcae063e45bcfb312) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157156))
- [Update admin geo page](https://gitlab.com/gitlab-org/gitlab/-/commit/2008e21509833c30718c592e8798352493ae7cf8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157080))
- [Refetch job list when an artifactless job remains](https://gitlab.com/gitlab-org/gitlab/-/commit/6e4e17193691300e40f99298bd5cf18221fc3bda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127632))
- [Add start trial CTA to duo pro usage tab](https://gitlab.com/gitlab-org/gitlab/-/commit/2149ae090f50d351e95b2d5d015af779b7c2ac8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155902)) **GitLab Enterprise Edition**
- [Provide consistent interface across scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/3128f3d5f86b11b24d0d0cc7bf37a8de17c90281) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144067)) **GitLab Enterprise Edition**
- [Update snippets empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/637554379ce6e03928dada47d8260792bb4047f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156785))
- [Remove ignored `toggle_security_policies_policy_scope` setting](https://gitlab.com/gitlab-org/gitlab/-/commit/e105c938a7cd849decb95798ecdc0d044725cbd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153266))
- [Update naming of duo group settings](https://gitlab.com/gitlab-org/gitlab/-/commit/3a979af4ccba5da09b2d97bc5ccd90dd632d512f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157010))
- [Add UserStarredProjectsResolver sort argument](https://gitlab.com/gitlab-org/gitlab/-/commit/077ca496eaadc0a9383a552ed32294233de2f7e7) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153651))
- [Migrates gl-display-inline-flex to gl-inline-flex](https://gitlab.com/gitlab-org/gitlab/-/commit/3aa4f990bde82a9c6fb59d7c726a02bddc693cea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154887))
- [Multiple frameworks labels](https://gitlab.com/gitlab-org/gitlab/-/commit/ca5a43e01aadde03cf32218f62f7e56eb5709f05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156570)) **GitLab Enterprise Edition**
- [Add permissions checking to AI impact dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/23bf0938f52424ec382ba745b57375234b769949) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156555)) **GitLab Enterprise Edition**
- [Admin settings: Migrate security settings to use SettingsBlock](https://gitlab.com/gitlab-org/gitlab/-/commit/467df2db45835010a9b4210982fe662f2f30e8b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157043))
- [Externalize strings on ldap_group_links](https://gitlab.com/gitlab-org/gitlab/-/commit/2fcc3e2fd12ea0c6813e7c88a1548c90cecf24e0) by @MAlvarez32 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155271))
- [Improve usability of environment folders](https://gitlab.com/gitlab-org/gitlab/-/commit/076d3d3a212c3a93ec60863090c3a0fa185ecd05) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157104))
- [Display capped results for large datasets](https://gitlab.com/gitlab-org/gitlab/-/commit/d1d8005ef78e12f960dcf5ddde6b9dcc2266087d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156026)) **GitLab Enterprise Edition**
- [Update GitLab logo on deploy page](https://gitlab.com/gitlab-org/gitlab/-/commit/f3f6e87a1ef799024b4a9e76f88afe9f3cc384d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156261))
- [Update groups page for admin view](https://gitlab.com/gitlab-org/gitlab/-/commit/64125d73f2485bdb6f2400e2db99df134975ce8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156800))
- [Update admin subscription page UI](https://gitlab.com/gitlab-org/gitlab/-/commit/0f48e27e338908ff0935c6024de2bbf8db037560) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156839)) **GitLab Enterprise Edition**
- [Add placeholder actions to table](https://gitlab.com/gitlab-org/gitlab/-/commit/dd77d0d5f36c2cffba601a0544ea28727ee5b13a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156533))
- [Update visualization type selection with validation state](https://gitlab.com/gitlab-org/gitlab/-/commit/f7e5cdd2aa4d7eabb99d4490976844d6a111e369) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156976)) **GitLab Enterprise Edition**
- [User friendly date formatting in Container tags_list_row](https://gitlab.com/gitlab-org/gitlab/-/commit/8721191f9f5f3c314d84e28f5e25682abf3116b7) by @Saurabh-Daware ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156376))
- [Remove extra space in board cards](https://gitlab.com/gitlab-org/gitlab/-/commit/49d00c28e62c0550838cb12734651b3f54788d42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156113))
- [Check deploy_key exists during ProtectedRefDeployKeyAccess#valid?](https://gitlab.com/gitlab-org/gitlab/-/commit/d9c9f033c8be3e9ee9e6ad3ca21f8f623f6f046d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155745))
- [Implement AR validations for ProtectedRefAccess](https://gitlab.com/gitlab-org/gitlab/-/commit/849784e42d78d25aa83e9c83b787c98178cad254) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156002)) **GitLab Enterprise Edition**
- [This MR updates yaml schema](https://gitlab.com/gitlab-org/gitlab/-/commit/154b2da8aefb489cae1d42cf3afd04a89138fa3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156363)) **GitLab Enterprise Edition**
- [Remove showcase_free_security_features experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/e9eea5f2cff7648915c6bdec58af9ceae9a56e00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156803)) **GitLab Enterprise Edition**
- [Reverse make_synced_work_item_read_only FF check logic](https://gitlab.com/gitlab-org/gitlab/-/commit/1046966e152bed6adfbb147d248ce92ae8694472) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156648)) **GitLab Enterprise Edition**
- [Renamed autocomplete scopes to use plural form](https://gitlab.com/gitlab-org/gitlab/-/commit/cb4d38de54c7cf1fd8bf3804a1e9675b5f379b9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156492))
- [Show dependency location count if `occurrenceCount` field is present](https://gitlab.com/gitlab-org/gitlab/-/commit/44bc09dbc7339fe9c056153808fa60660a6a3f84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156557)) **GitLab Enterprise Edition**
- [This MR removes loading state](https://gitlab.com/gitlab-org/gitlab/-/commit/e7880922f54023e32063fcf0e97ef1783497ce6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156793)) **GitLab Enterprise Edition**
- [Add concurrency_limit to AddApproversToRulesWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/790ff68c27495f69be533660910df98909476b33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156778)) **GitLab Enterprise Edition**
- [Update gitaly servers page](https://gitlab.com/gitlab-org/gitlab/-/commit/db83949fb9ab1e1355cbc9648dd42ab8b014f123) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156536))
- [Update trial terms](https://gitlab.com/gitlab-org/gitlab/-/commit/a6d5bc395710a1bf7c45ed4f95aad72937ba5a01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156341))
- [Enable zoekt_exact_search by default](https://gitlab.com/gitlab-org/gitlab/-/commit/741fb8a8dc06422f09a4c75c6146a311182f63b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156748)) **GitLab Enterprise Edition**
- [Remove ai_claude_3_for_docs feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4935a53bca171971c5844a53544725a704bc073e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155281)) **GitLab Enterprise Edition**
- [Increase max body limit for AI GW requests](https://gitlab.com/gitlab-org/gitlab/-/commit/fa2732f43cd308e3a178332a14223a05162aa8b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156738)) **GitLab Enterprise Edition**
- [Remove GCP WLIF setup script API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/b637037095f224eee419ef8518db13d7a6704525) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156699)) **GitLab Enterprise Edition**
- [Drop ci_job_artifacts_use_primary_to_authenticate feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3157d57733edbeff16488d545e497d26503c0c0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156697))
- [This MR updates yaml schema](https://gitlab.com/gitlab-org/gitlab/-/commit/26ea84d39e87d36f0b0b97b7b1b6f85d79f9b1c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156325)) **GitLab Enterprise Edition**
- [Adds Zoekt::Replica](https://gitlab.com/gitlab-org/gitlab/-/commit/888775a1207cfeae18dafc62ceaf8ff1d9f2ba00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155317))
- [Update admin system info page](https://gitlab.com/gitlab-org/gitlab/-/commit/13f5c11eed8a8386b76c705105f88f6ea460b3a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156567))
- [Replace approval modal with link to approval page](https://gitlab.com/gitlab-org/gitlab/-/commit/9d00cfb79edfdbac48142147eb24694049813a3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156656))
- [This MR refactors multi select text](https://gitlab.com/gitlab-org/gitlab/-/commit/944cd45e0b61a39408b79b72f8766fe31f16c387) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156641)) **GitLab Enterprise Edition**
- [This MR updated user approver dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/283832501708409b15b210c260749a04bfb8a7d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155611)) **GitLab Enterprise Edition**
- [Remove :notify_owners_of_finished_dt FF](https://gitlab.com/gitlab-org/gitlab/-/commit/6f1cfc427a1ef7a22e5afce825bf545e9934cc47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156633))
- [Cleanup the duo_pro_trials feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/172f26857626b38e114792d8a6d0f425d934bc83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156132)) **GitLab Enterprise Edition**
- [Change unit primitive for text embeddings](https://gitlab.com/gitlab-org/gitlab/-/commit/e90f96b6b63e907bfb6ecec11e6351b1ed2682e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155835)) **GitLab Enterprise Edition**
- [Extend error-alert Vue component with buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/4a97c359cc09a20e3764ed25001083b34eba0483) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156206)) **GitLab Enterprise Edition**
- [Add external Stripe IDs to CreditCardValidation](https://gitlab.com/gitlab-org/gitlab/-/commit/7bc3183c75dab0616a6fe2431d9820eacbdcec76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156505)) **GitLab Enterprise Edition**
- [Improve compliance center for subgroups](https://gitlab.com/gitlab-org/gitlab/-/commit/d57d6295907736e3c4d99b22ee3a8c026b358c31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156260)) **GitLab Enterprise Edition**
- [Use static AWS credentials for indexer if set](https://gitlab.com/gitlab-org/gitlab/-/commit/14207a5ebee99111fc8696c2ee7d6925acbc2005) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155960)) **GitLab Enterprise Edition**
- [Remove transaction opening for non-basic search count](https://gitlab.com/gitlab-org/gitlab/-/commit/dcf811f417b7910c7aaaf5ff1c08dd77e118bfa1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156321))
- [Remove overflow:hidden from card component](https://gitlab.com/gitlab-org/gitlab/-/commit/8af3832ba271bbb766c2b0a19c8a1f2cd3ab892f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156548))
- [Display usage quota tab during duo pro trial even group on free plan](https://gitlab.com/gitlab-org/gitlab/-/commit/5dbeb1485d4fd777104bf72cc87160d9f3a9f879) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155767)) **GitLab Enterprise Edition**
- [Allow self-signed CC tokens in development](https://gitlab.com/gitlab-org/gitlab/-/commit/c7c60323dd09e415533b737d01c92548f375dc95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156496)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint to ci_runner_namespaces.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ba16f8e7548147c4b74867458e11efa361d09457) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156318))
- [Add NOT NULL constraint to ci_runner_projects.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/412604bf443e427faf57497cb1858bd1d1f4fe92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156314))
- [Update create label UI in labels widget](https://gitlab.com/gitlab-org/gitlab/-/commit/920e418ac45df7b2d8b95f135f34b3a7b2d0fca4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156056))
- [Change help link text copy](https://gitlab.com/gitlab-org/gitlab/-/commit/6e7ed1176ae2236ae74ffc6645645eeb084e4fbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156029))
- [Update dependency auto-build-image to v4.2.0](https://gitlab.com/gitlab-org/gitlab/-/commit/62133c84cd65559717213f735d36e9d92382689c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155945))

### Removed (22 changes)

- [Remove triggers and old columns for bigint p_ci_builds](https://gitlab.com/gitlab-org/gitlab/-/commit/944155c2596919d5d70ab5491116cd43f5a1bf93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158711))
- [Removes storage_size index on project statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/6c685a9fb1b35e46d3e2f8354d25fc8f815773cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158616))
- [Remove MR review summaries table](https://gitlab.com/gitlab-org/gitlab/-/commit/0b13bb2a53ad6ec8320e1c71934401a818762713) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157572))
- [Drop `index_vulnerability_occurrences_for_issue_links_migration`](https://gitlab.com/gitlab-org/gitlab/-/commit/518ad733fb27471edaf7fc15605a0bc9a2962135) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158736))
- [Reverts 112527 as no longer required](https://gitlab.com/gitlab-org/gitlab/-/commit/3336394f92d8916175b7c4679d4bbf7de54dc300) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158609))
- [Remove EnsureStageService and prep for removal of `stage`](https://gitlab.com/gitlab-org/gitlab/-/commit/f6aaabeff28e897d7f91aa5aed448e7b82f91160) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156892))
- [Drop legacy geo_repositories_changed_events table](https://gitlab.com/gitlab-org/gitlab/-/commit/876d67fadd97b5124f4c54fd2988eaf873c05e53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158660))
- [Remove SafelyChangeColumnDefault include](https://gitlab.com/gitlab-org/gitlab/-/commit/37bf0d05bc6d949e59371706b5901429bb061e5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154212))
- [Remove `issues_mrs_empty_state` feature](https://gitlab.com/gitlab-org/gitlab/-/commit/e63ee4fb40f484ddc6c04876a3ec31c074b3b52c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156693)) **GitLab Enterprise Edition**
- [Remove create_user_details_all_user_creation feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7eeb9d74630925207a3699e6f6cc83fceb0b8e3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157958))
- [Remove the template auto fill AI feature](https://gitlab.com/gitlab-org/gitlab/-/commit/15db60a024c937a52036e64b78f5403320194f7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156766))
- [Removes project stats index on packages size](https://gitlab.com/gitlab-org/gitlab/-/commit/7feef107a4e051799be9f632f55a08265acf8ca3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156008))
- [Chore: Remove the ai editor assistant feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ae1fd20a598a2c4515ae3ad9f2b456831dd6cb3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157837)) **GitLab Enterprise Edition**
- [Removes storage size idx on project_statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/8ff61ea7a5debf8979fe9fc7c87127b125b09c8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156005))
- [Drop unused DAST tables](https://gitlab.com/gitlab-org/gitlab/-/commit/c76555c4a9840b72384ecc428f4222cc107d8232) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153443)) **GitLab Enterprise Edition**
- [Removes project stats index on wiki size](https://gitlab.com/gitlab-org/gitlab/-/commit/e6a2a5a4e31ae200530dc7434c90a3734db06b00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156010))
- [Remove track_ai_metrics_in_usage_data feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d426fa2fe74208662ca3d8c0a3c93e24f9501743) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157196))
- [Removes index on project_statistics async](https://gitlab.com/gitlab-org/gitlab/-/commit/12ffa83842508c0be03fef1842b17beb3bcdd074) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155999))
- [Remove obsolete codeSuggestionsUsageRate field](https://gitlab.com/gitlab-org/gitlab/-/commit/19d17c281d9b76756b1dd86e7e2e149c89067d9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156750)) **GitLab Enterprise Edition**
- [Remove sep batching configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/3030bb11d7535ca2950429fe573dedc0e09634b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156835)) **GitLab Enterprise Edition**
- [Removes temp index from project statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/158acf6c0a54d5bb79530f7e43822e2bddaa89a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155997))
- [Cleanup prominent_create_board_btn feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/43d17697e2b38cf7f8f0d23b7e1800f7d040d167) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156324))

### Security (23 changes)

- [Check npm package name, version and scripts coherence](https://gitlab.com/gitlab-org/gitlab/-/commit/14ce36e7045252dd74dc59a71a5acc348ceadf13)
- [Disallow serving Pages over disabled custom domains with deployments](https://gitlab.com/gitlab-org/gitlab/-/commit/08a5faf3c92d34407a96b03d6a44c12db00ee1f2)
- [Prevent privilege escalation via custom role](https://gitlab.com/gitlab-org/gitlab/-/commit/30cc4e834c300d18d4e30f052de18f999065ae85)
- [Check if user has ban_group_member access before banning in namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/81594e06ccef46c19dbb2b9e760d3422a9bdf4eb)
- [Check for create_deploy_token policy before creating deploy token](https://gitlab.com/gitlab-org/gitlab/-/commit/38d7fcbde55100c6eb63a1c8babd379cb4d205a3)
- [Prevent using quick actions for some bot users](https://gitlab.com/gitlab-org/gitlab/-/commit/a08eaa3dac0eb76fd4135eda412572f24fb28578)
- [Disable raw HTML for quick action pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/049504cecf622189f69b14dbc8895e6f36af0af4)
- [Disable quick actions unless description changed](https://gitlab.com/gitlab-org/gitlab/-/commit/3d20fd45ec2b24ff02a06eea0ef1558f522a211d)
- [Remove comment support from shrug and tableflip](https://gitlab.com/gitlab-org/gitlab/-/commit/8cf683d6f1cea2ac3f0975bcf7d6e156f40a37ba)
- [Pass SSO session data to Sidekiq](https://gitlab.com/gitlab-org/gitlab/-/commit/c7eabd8a76e035e439d27734310dd3d6c83bc2c0)
- [Do not run a new pipeline on re-target](https://gitlab.com/gitlab-org/gitlab/-/commit/7db0608a8e0e76c3a697edf052a9e603367161b0)
- [Remove search results from public projects with unauthorized repos](https://gitlab.com/gitlab-org/gitlab/-/commit/d38ed3d433f51060c7c7daa793ce9aaf14beb513)
- [Reject deletion of security policy project approval rules](https://gitlab.com/gitlab-org/gitlab/-/commit/69d6113572c1515f46ddfb1990aa746ae123c518)
- [Add limits on autolinker regex](https://gitlab.com/gitlab-org/gitlab/-/commit/74014108b6811c8ea40813e0981915115742a1d4)
- [Fix for Private job artifacts can be accessed by any user](https://gitlab.com/gitlab-org/gitlab/-/commit/50bd3b7b0cdcedf7efdf3b8b1d8808a4e0aaab76)
- [Prevent non-members from using promote_to quick action for quick actions](https://gitlab.com/gitlab-org/gitlab/-/commit/ff425064c3d22341d520fff8abf829a812c5c14f)
- [Fix the catastrophic backtracking in openapi regex](https://gitlab.com/gitlab-org/gitlab/-/commit/faa5c6e04b47aa618ef2fdf7b1242272896d134c)
- [Use permitted_params for standalone and multiplex queries](https://gitlab.com/gitlab-org/gitlab/-/commit/b5afa91ae27c8d9b11461ebeb03b25a230f5bc54)
- [Fix clickjacking on OAuth application page](https://gitlab.com/gitlab-org/gitlab/-/commit/5073499734aa260dc96a6329ff913ae72a3e2e62)
- [Remove collapseLongCommitList method](https://gitlab.com/gitlab-org/gitlab/-/commit/4c970a3095e06a3406bb0cbcc2286d637ee3128c)
- [Security fixes for banzai pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/b32d3189758c48afc0621a806645cb20f83b9864)
- [Hide branch merge request if merge requests are private](https://gitlab.com/gitlab-org/gitlab/-/commit/c376da8991401b8748048cc11e6bdbd61c253724)
- [Mitigate ReDoS attacks via `method_call_regex`](https://gitlab.com/gitlab-org/gitlab/-/commit/ee4cac0f6ca99cbf90724d75d42a9e03137e5ddc)

### Performance (3 changes)

- [Parse affected ranges only once](https://gitlab.com/gitlab-org/gitlab/-/commit/e6867b4399e085f47f76d96501d1e5b72db6ee87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158842))
- [Adjust Bitbucket server importer to be resumable](https://gitlab.com/gitlab-org/gitlab/-/commit/47b0c08f41b8ed39c57959f8bb6523cfc213da6f) by @ivantedja ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156797))
- [Remove group-level vulnerability report performance improvements FF](https://gitlab.com/gitlab-org/gitlab/-/commit/f4fb8398fbbc1d36811634c9fe5777c26cd80daa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157786)) **GitLab Enterprise Edition**

### Other (150 changes)

- [Finalize DeleteOrphansApprovalMergeRequestRules2](https://gitlab.com/gitlab-org/gitlab/-/commit/a92c8f39a61117bf3962689bce8fb77d3c846e76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159017))
- [Update display_work_item_epic_issue_sidebar to work_item_epics](https://gitlab.com/gitlab-org/gitlab/-/commit/2cbeed7a47a56f659f0defe1e99f90bdc5f5aa07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158613)) **GitLab Enterprise Edition**
- [Remove bitbucket_cloud_convert_mentions_to_users ff](https://gitlab.com/gitlab-org/gitlab/-/commit/368af21b0ecc97e0c5fb334724b7306bd8f33a20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157957))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/e6f582894a15d68d96b1da99e1f8377d884a4f1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159033))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c51b47f0d371e8b75a74367d7ffa1099762eceab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158874))
- [Remove filter_deleted_groups feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8e97da759c8330158fa467313e414adb766f1f15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159214))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/aae6917b0dcc8bafeaafe62a3ce96c420429c92f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159184))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2df953b7f5176226d1301c0874786523b21f2d75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159178))
- [Remove unused index with namespace_id on vulnerability_reads](https://gitlab.com/gitlab-org/gitlab/-/commit/9f2e060a8daa90b8f9ed517eccec76ca6ca0f46d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158941))
- [Sync approval settings for groups for reauth setting](https://gitlab.com/gitlab-org/gitlab/-/commit/2d483935d991f72bb0f712ae77ac2b1569a20144) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158648))
- [Remove self_managed_code_suggestions feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0b19feae781cfbc6127f2cc1cc2f0685b8ae35cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158440)) **GitLab Enterprise Edition**
- [Create table p_ci_build_tags](https://gitlab.com/gitlab-org/gitlab/-/commit/fd0f7a053d2c4953a57bc48ad54290313ba2e60e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158327))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8e737f615f3165c284ab24b6fab14067a7bf9fe2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158710))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a1d73b25b38a1921b1a27bb9b80b37eab21e9eb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159034))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f0ec39f8a3d7e47a98ccca9f6da9955277de3535) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159031))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1344908bc4b839baefee9c2d8833ffb00d3bf9bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159030))
- [Remove reference to BBD ODS FF](https://gitlab.com/gitlab-org/gitlab/-/commit/e248a83b765bbdd5fe0c313581445575b3d287ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157902)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/614e6402a938a00524dd7317776a1d5e827fb6d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158871))
- [Remove `rewrite_sbom_occurrences_query` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/915bf7b04257f005312f43ba893f5b8b99486855) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158772)) **GitLab Enterprise Edition**
- [Fix forgotten ability](https://gitlab.com/gitlab-org/gitlab/-/commit/739a6964a41bfb3ee735a8721a8417aa872973b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158698)) **GitLab Enterprise Edition**
- [Fix <Layouts/LineLength> offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/290db2121b2155f3517861c3e6556a0f823851d8) by @Rohit.Kala ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158783))
- [Fix flaky test "#protected_branch_exists?"](https://gitlab.com/gitlab-org/gitlab/-/commit/9fbc1dfd6a04e8a0f4af63e0ac91fc3cbf7cfaa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158779))
- [Implement delete car mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/97e567c212d65890952bd6232a6b747ff72c58b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156488)) **GitLab Enterprise Edition**
- [Rollout Filtered Search on Vulnerability Report](https://gitlab.com/gitlab-org/gitlab/-/commit/3870780a825594d474d7b33523821f9b2eae13e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157172)) **GitLab Enterprise Edition**
- [Fix pipeline schedule error handling](https://gitlab.com/gitlab-org/gitlab/-/commit/4c0152e2428685af535cdc56e57d36eb565f9fb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158436))
- [Remove temp index](https://gitlab.com/gitlab-org/gitlab/-/commit/f7211e0c62b1533f0fb16d69cdda8ff82ba5199c) by @TamsilAmani ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139271))
- [Add a `pending_delete` column to mark namespaces deleted by user](https://gitlab.com/gitlab-org/gitlab/-/commit/03871fbcbed7cde24eb2d80eb2ddd8b7b9126603) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158309))
- [Add partitioned FK from ci_pipeline_artifacts to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/16d0cd7c4edec447d52562d72a8fb7844ad51797) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158086))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/b81f0aadb99a88ecfbdd0367da33411390280df1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158506))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/018d27c0cfa54483ff0de92581bbae897a6de4b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158507))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/4dd720ee04b03cf4676f936df292c40ac90f318d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158558))
- [Finalize migration CreateComplianceStandardsAdherence](https://gitlab.com/gitlab-org/gitlab/-/commit/8d280d0605411dda077e329b5962be8670346d65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158148))
- [Rspec Test order: run test in random order](https://gitlab.com/gitlab-org/gitlab/-/commit/41360018cefed51bc0edaf49b888929922b2e9c5) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157845))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/20e296a10c1787ce22c5082c357bfcc28b606919) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158181))
- [Refactor SAX document to cobertura](https://gitlab.com/gitlab-org/gitlab/-/commit/60b7d09861b6afe93d5c796123e3c4d312e03bdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158341))
- [Release jira_connect_remove_branches](https://gitlab.com/gitlab-org/gitlab/-/commit/8f2d020a40dbc523afc86291c25f27b12938434f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158224))
- [Finalize BackfillWorkItemHierarchyForEpics migration](https://gitlab.com/gitlab-org/gitlab/-/commit/44702df1c97d0e01c7eb8a25141f16789f2d030d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157981))
- [Improve accessibility of remove icon buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/5c9976313973900497654370de97221c8a1d3153) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157929))
- [Persist all policies instead of active policies](https://gitlab.com/gitlab-org/gitlab/-/commit/dd249a70ec5b944371e27ff517b650877b2b91b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156735)) **GitLab Enterprise Edition**
- [Remove set_ip_address feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f3bdbedf8b6ba727c706e4102ecce306d8c02216) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158418))
- [Finalize re-syncing basic epic attribute migration](https://gitlab.com/gitlab-org/gitlab/-/commit/6e7cd743b12fcd155634d82af2247360ac4e23ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158384))
- [Finalize BackfillEpicDatesToWorkItemDatesSources](https://gitlab.com/gitlab-org/gitlab/-/commit/71eefb084e9c9cd34d8687ab693ebde92c87d936) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158037))
- [Enable parallel_project_export feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/64374dc941d86a0e9845cc34d5bb3a4b0963f08f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158369))
- [Add weight widget definition options](https://gitlab.com/gitlab-org/gitlab/-/commit/7c85c228ee21072c318e3117535c1543a316947f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157705))
- [Add partitioned FK from p_ci_builds_execution_configs to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/faf68ca11c79289938d08e2ca1e7800ac2489c43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157908))
- [Sync create index and swap columns](https://gitlab.com/gitlab-org/gitlab/-/commit/8852ca7059369db1a5449e96ec48a496cb5f801f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149671))
- [Fix Style/Lambda offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/cf3980a5712da1d17bb3c6409cc129533ebb5418) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157265)) **GitLab Enterprise Edition**
- [Add index for listing uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/f07a817427e63a9fec4816204d00c04bccd4f9d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157139))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/e9abb2af481bee29ca0bda114ba340348c4ff0f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158178))
- [Protected packages: Batch load matching protection rules](https://gitlab.com/gitlab-org/gitlab/-/commit/463982894a3ac7ee871f373c98c4f45c0cf5fe72) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154595))
- [Extend a troubleshooting section to cover Xcode SSH keys problem](https://gitlab.com/gitlab-org/gitlab/-/commit/f54883e42feb25cca1d1cd8932384f336d9d4efb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158215))
- [Add partitioned FK from ci_pipeline_chat_data to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/cdfec4f6b7e4953d18beac1e7eeaf48480b8a0b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157938))
- [Rspec Test Order:Run spec/graphql/types in random order](https://gitlab.com/gitlab-org/gitlab/-/commit/0cf119cc43ce8facb883ed33e1eaeb2e323f2d4b) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158172))
- [Add partitioned FK from ci_pipelines_config to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/b42f9a1e167f103a2cd118f678df685677da66d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158065))
- [Finalize backfilling of related epic links on issue links](https://gitlab.com/gitlab-org/gitlab/-/commit/e0fda69bb3a89228d860fb81d0381dabbb0df482) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157492))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/7fa3c9217a0b0c0e5d5f1a9a1c14d58d40a89642) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158174))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/569ec66e5b1866de254374383fdd83c4e9987625) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158008))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1c1ac1e3efe1d68fb304225a18d599c69a3585d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157711))
- [Fix Layout/LineBreakAfterFinalMixin offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/a710a4065fd660008138594cc603b8fa8f9c6364) by @m.bortlik ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158123))
- [Protected containers: Enable multi-line errors in GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/f11d937169c2b061ae65d0d3444a6d7264239417) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148838))
- [Fix Layout/ExtraSpacing offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/c71dfae62eb6bc9ed9e682b1d0c64b0486cf9482) by @miha-prehcm ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158083))
- [Add partitioned FK from ci_pipeline_messages to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/2cb83573d6127c0b15344a24156e8dee4c7a9d05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158065))
- [Add partitioned FK from ci_pipeline_metadata to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/15d7fadcc85054caf17d76d0d940c1b9f24e6f8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158065))
- [Mark 20230615101400 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/65ecf2b70c32c4f4b41a20cc54c4a984aa9bc9ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157366)) **GitLab Enterprise Edition**
- [Change table ownership](https://gitlab.com/gitlab-org/gitlab/-/commit/d12b8a7105d8f17550ce5a2e221c328e0fa78983) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158030))
- [Add and backfill group_id for packages_debian_group_architectures](https://gitlab.com/gitlab-org/gitlab/-/commit/38dba13a0c77b1d814d231a0764fca724cba077e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158027))
- [Add partitioned FK from p_ci_pipeline_variables to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/f0d1874de344f6b6ef6fc7dc139cd9013ab75b60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157747))
- [Regenerate rubocop todo files](https://gitlab.com/gitlab-org/gitlab/-/commit/bb1b277f6d338ea63d81c6f836d5249a04e9ab2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157740))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c0871506caa5e628605add1bf040546d7b788468) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157246))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c4b1fc1e8a5a275135f27061235dfa825c12f488) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156993))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/fb5441026837dd5bbaa048136e8d44e6e6180b6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157712))
- [Prepare ci_pipelines.autocancel_by_id for composite primary key](https://gitlab.com/gitlab-org/gitlab/-/commit/818302e3c6bd466acafdfa5062d74e84c98d53cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157619))
- [Finalize BackfillEpicIssuesIntoWorkItemParentLinks migration](https://gitlab.com/gitlab-org/gitlab/-/commit/95898c8f7b2329fb0c854c8a5b179496dea9391d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157974))
- [refactor: Increase test code quality for package controller test](https://gitlab.com/gitlab-org/gitlab/-/commit/b40706054a43e93f17016061d1d5b34265abe29c) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149383))
- [Add partitioned FK from ci_sources_pipelines to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/3d19f526f0deee5ef049df819f92fbe82493fef8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157947))
- [Remove default values for ci_sources_projects#partition_id](https://gitlab.com/gitlab-org/gitlab/-/commit/84427538e86c952dd4da3e6121795925ee0ef83d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157909))
- [Add and backfill group_id for packages_debian_group_components](https://gitlab.com/gitlab-org/gitlab/-/commit/a610218dd24bd0589ffb8d197fbd79254829f5f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157905))
- [Add spec to verify FeatureFlagReferenceFilter N+1](https://gitlab.com/gitlab-org/gitlab/-/commit/6a57b5d86957ca675debd1f684c7629dbadcb30f) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157866))
- [Finalize migration ConvertCreditCardValidationDataToHashes](https://gitlab.com/gitlab-org/gitlab/-/commit/c55d426e46aebcd4dd786a7705668bac8b0b1d45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157836))
- [Add test for N+1 query for VulnerabilityReferenceFilter](https://gitlab.com/gitlab-org/gitlab/-/commit/ae717f7d3b513c9cc94a0051905a25f31b0e6778) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157853)) **GitLab Enterprise Edition**
- [Rspec Test Order:Run spec in random order](https://gitlab.com/gitlab-org/gitlab/-/commit/32dd8048a8ecdb4397502171130fbb2b4d101696) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157844))
- [Revert "Merge branch 'bwill/optimize-top-bound-lineage-search' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/05d6aa37ff18eb424567b3631bce94ca12a2d7c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157799))
- [Mark 20230719094243 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/04189615cbf59008f3faca617333ab94523b3a91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157373)) **GitLab Enterprise Edition**
- [Resolve Layout/ArgumentAlignment offenses 76](https://gitlab.com/gitlab-org/gitlab/-/commit/0780a7089def55a53cfabbd815b1c9258d50ece8) by @gauravmarwal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151273))
- [Create Dependencies::DependencyListExport::Part model](https://gitlab.com/gitlab-org/gitlab/-/commit/611693796c17c26017925e8284024a286f7d5923) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157638))
- [Add and backfill project_id for packages_debian_project_architectures](https://gitlab.com/gitlab-org/gitlab/-/commit/31b760f990afd45856d6b9b453e2cce0437d8ff7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157767))
- [Add partitioned FK from p_ci_stages to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/764b3d35fdfda65d8f53a69764cd43618e478c63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157753))
- [Add partitioned FK from p_ci_builds to ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/e70f1a202ee685a29473b7c19a7af1f5d6f9bf57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157750))
- [Mark 20230719144243 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/69194636e77626e80f69f41b626da7fea2e712a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157375)) **GitLab Enterprise Edition**
- [Mark 20230628094243 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/69ebc4a04186d13151807c587d53ccc8aca3bb83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157367)) **GitLab Enterprise Edition**
- [Mark 20230702000000 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/af4b7fb6a2d92fa6e0521809cca5a7891d186d69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157369)) **GitLab Enterprise Edition**
- [Mark 20230711140500 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/aeb55e4c74b5cf5382377d23d30462139cfda6fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157372)) **GitLab Enterprise Edition**
- [Add and backfill project_id for packages_debian_project_components](https://gitlab.com/gitlab-org/gitlab/-/commit/3a2d5db6f51b0bf98b3a3e53bb0ded82ee92e206) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157626))
- [Mark 20230719142200 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/a884e64586bfe172d2d7fd17628172a33856c71a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157374)) **GitLab Enterprise Edition**
- [Mark 20230703112233 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/4c875ae756b3849756fe1385a8cb84db743d4ecd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157370)) **GitLab Enterprise Edition**
- [Remove ignored MemberRole columns](https://gitlab.com/gitlab-org/gitlab/-/commit/6bb23bcf406e5e7956d66b3c4ac28ddc04be7ee4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156264))
- [Set internal bots profiles to be private and confirmed](https://gitlab.com/gitlab-org/gitlab/-/commit/f7602f946c819b60e3a54826caa84ee146262826) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157557))
- [Finalize migration BackfillSbomOccurrencesTraversalIdsAndArchived](https://gitlab.com/gitlab-org/gitlab/-/commit/dda5e8c948fa9fb5c481a8673dc81c2bde079d5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157235))
- [Mark 20230628094700 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/7e1286ec975ad0f14341be82b52fc934800309b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157368)) **GitLab Enterprise Edition**
- [Add and backfill project_id for ml_candidate_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/c3e5edf00691b71c71b7531e067713fa72f0cd3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157484))
- [Add and backfill project_id for packages_dependency_links](https://gitlab.com/gitlab-org/gitlab/-/commit/0fc3dbc2be113adb6e36dd330f4a01c67dad708c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157483))
- [Add not null constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/49fee3d2b8383a6731771126f24298279d6edd2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156893)) **GitLab Enterprise Edition**
- [refactor: Apply best practices to feature test new project](https://gitlab.com/gitlab-org/gitlab/-/commit/65cbde5ccd5684f04d803bc83b95c2625cf591ba) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154086))
- [Rspec Test order: run test in random order](https://gitlab.com/gitlab-org/gitlab/-/commit/58eafbe8bd0ec62cf1654ba691faf9f965b0b419) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157178))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/664b950a95565920a92202dfe46f0d7ee8996dce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156997))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/dd31ad79eab6af213aa840eb093df5bceab693cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157395))
- [Mark 20230710142700 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/25bd3ba8c783dcc885d6373cc09400a659cfe888) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157371)) **GitLab Enterprise Edition**
- [Remove initialize_processable from Seed::Build](https://gitlab.com/gitlab-org/gitlab/-/commit/38fd3829c473eca7f851eb38110e4c993fd72ff6) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157260))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/b39d6cf95cd307b3fad5de9b36fc8d201f3b0bf8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157247))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/5c6062bae55449c954f9eb37e11f0d811f740efa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157245))
- [Remove unused deployments indexes on .com](https://gitlab.com/gitlab-org/gitlab/-/commit/f8389ff2d52178bd0be63dabb5dc95f8135c3c3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157136))
- [Implement cars resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/041224188e2c073a4023d81c7331ee0594b1ed5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156145)) **GitLab Enterprise Edition**
- [Add and backfill project_id for ml_model_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/f8cdfcee0b0276be4099c34512572aebb224f1cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157191))
- [Add and backfill project_id for merge_requests_closing_issues](https://gitlab.com/gitlab-org/gitlab/-/commit/1ec02dca526dc018a2de5d978b28afc10dd6f362) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157186))
- [Add and backfill project_id for vulnerability_external_issue_links](https://gitlab.com/gitlab-org/gitlab/-/commit/4228c0d5f787b0fac105895bf845fb04d7877e98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157179))
- [Add and backfill project_id for packages_conan_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/11ecfcd0a9bb13be235e91949bfacfa2d933a74d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156254))
- [Finalize migration BackfillProjectStatisticsStorageSizeWithRecentSize](https://gitlab.com/gitlab-org/gitlab/-/commit/34511dfdee1149d549f9ce5aea44afa3c0afa98f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155152))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2642174f2cc89fb8fe8f94f2cb4808328078c3da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157005))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/aff7cb9815d4497d005185efba1bd7fd6ddceb1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157107))
- [Check for N+1 in IssueReferenceFilter](https://gitlab.com/gitlab-org/gitlab/-/commit/a39910d8e7deed3e4f60ee7e014467c0271e6ddc) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157110))
- [Drop `security_findings_confidence_idx` index from `security_findings`](https://gitlab.com/gitlab-org/gitlab/-/commit/2809cb8dd101755f59ae19ef2d87d93900baaa52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157071))
- [Add and backfill project_id for packages_maven_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/a03846af1541deaab1ebc9341d12193231f1d879) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157034))
- [Add and backfill project_id for vulnerability_finding_evidences](https://gitlab.com/gitlab-org/gitlab/-/commit/8709db853647b5d2afa117c34d1ffda55dde47d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157032))
- [Add and backfill project_id for merge_request_reviewers](https://gitlab.com/gitlab-org/gitlab/-/commit/ddd51bad31a2ab6ede4eb532a2e11e907291dccc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157031))
- [Finalize migration BackfillUsersColorModeId](https://gitlab.com/gitlab-org/gitlab/-/commit/570f26edab95ec24120e8fdbde7f6d4ca33ff1bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157013))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2d68f1a36f6e899d587eda74156571128c95d5c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156994))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/4081d47da3c5a1d96f79a0ace12ac792711392d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156992))
- [Merge ExtractsRef into ExtractsPath](https://gitlab.com/gitlab-org/gitlab/-/commit/6a6aa68de80b2abaf8fd0329000d423d04ff5805) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155245))
- [Add new column to store organization project & group sorting options](https://gitlab.com/gitlab-org/gitlab/-/commit/9f8081fe25dc8f3a11c628b3bc83768bbc1debab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154899))
- [Remove imported column from relevant tables](https://gitlab.com/gitlab-org/gitlab/-/commit/42623a62be2315ad601e1fb88f314a29c649a7b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156540))
- [Add and backfill namespace_id for vulnerability_finding_signatures](https://gitlab.com/gitlab-org/gitlab/-/commit/0586512f2b76761a30f551a508e1ff7738c071d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156794))
- [Add post_migrate to remove invalid record](https://gitlab.com/gitlab-org/gitlab/-/commit/1107cd52bf22de3fcd2e7cb1f400d858b136217e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156518)) **GitLab Enterprise Edition**
- [Remove default values ci_pipeline_messages#partition_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ea6d8bc0acb8e1f4866d08738c8fdb219cd0f94f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155397))
- [Drop merge_requests_closing_issues.closes_work_item column](https://gitlab.com/gitlab-org/gitlab/-/commit/9f920558b3a917d2775a608f75864ec666893f17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156677))
- [Resolve Layout/ArgumentAlignment offenses 88](https://gitlab.com/gitlab-org/gitlab/-/commit/6f30b452ccb6c137340cf5d4694f5c71f680b631) by @gauravmarwal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151289))
- [Add a new model that will handle abuse report notes](https://gitlab.com/gitlab-org/gitlab/-/commit/33f329bec6779bb8a50f6aac28e4859483e973ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156146))
- [Add and backfill project_id for protected_tag_create_access_levels](https://gitlab.com/gitlab-org/gitlab/-/commit/35ec77d7d15cb131bde663ac124c5e9e5cc7326a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156637))
- [Add and backfill project_id for vulnerability_findings_remediations](https://gitlab.com/gitlab-org/gitlab/-/commit/a03c4ff338e3aaa2cf601301d9058a5d3a427256) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156634))
- [refactor: Remove rubocop issues](https://gitlab.com/gitlab-org/gitlab/-/commit/dba1531363d33bef26bed333ffb28507dbbab9a4) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154189))
- [Change catalog resource last 30-day count updated_at](https://gitlab.com/gitlab-org/gitlab/-/commit/91194027ef72015493c3c8288506a333683c9bdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156575))
- [Finalize BackfillPartitionIdCiPipelineMessage](https://gitlab.com/gitlab-org/gitlab/-/commit/d2591c0ed7caa0e5bfc012eb5b9859a7afe8d4b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155219))
- [Protected packages: Shorten GraphQL field `protectionRuleExists` Part 3](https://gitlab.com/gitlab-org/gitlab/-/commit/13e610a4c2437d24597338829f43b5fcfd1c9217) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152376))
- [Add and backfill project_id for vulnerability_flags](https://gitlab.com/gitlab-org/gitlab/-/commit/a5d8dae907e70bee6d66d67a2c55eef3e4a04fce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156323))
- [Add and backfill project_id for merge_request_context_commits](https://gitlab.com/gitlab-org/gitlab/-/commit/b1860549c3328b6c864c99ad1f952297e18ca643) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156255))
- [Add and backfill namespace_id for issue_links](https://gitlab.com/gitlab-org/gitlab/-/commit/d0c9b0f5fe1c316a51b209a8f0679de24c52bc2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156257))
- [Add and backfill group_id for related_epic_links](https://gitlab.com/gitlab-org/gitlab/-/commit/69d1111d555041a6d3b1086b5cbdaae119c2d33c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156251))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f1913e6a3bfa16d996c053073e3b3dca2fb5ff1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155940))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/121d4e81b497b6795650aef58122a92222d91894) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155349))
- [Remove "use_remote_mirror_destroy_service" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/74e1e921d003960afd6f259384aee2dfec18f30e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155852))
- [Protected containers: Cleanup renaming of protected_up_to_access_level](https://gitlab.com/gitlab-org/gitlab/-/commit/4606b5ef64f75acdd581258a0b93034195626e83) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/146177))

## 17.1.4 (2024-08-06)

### Changed (2 changes)

- [Reverify externally verified gpg keys](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e11bfa6bdfcf0b40f440bf50e104d5d4e4496d74)
- [Put groups_direct field in CI JWT tokens behind feature flag](https://gitlab.com/gitlab-org/security/gitlab/-/commit/024945347ea0b433de65c0ecb80c50cc031cbc52)

### Security (13 changes)

- [Show correct file content](https://gitlab.com/gitlab-org/security/gitlab/-/commit/59df2cc3758c03aff024151f5dfd59fa3263ac7b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4335))
- [Fix Possible asciidoctor include:: directive DOS](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6fcbfba6119fcadff61dc4550d244b56f5fe6c70) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4330))
- [Filter parameters in Rack::Attack logs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9b807312a2029e6a341962591dcdcfd21ea8ef0c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4273))
- [Update audit payload](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7beb230f12ec6270523a269dad39dba42fdc108e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4326))
- [Limit access to project accessed by Security Policy Bot](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b58cad5e32c2b9f399742719006a4e527f773e2d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4344))
- [Show alert about not rendering files due to path encoding](https://gitlab.com/gitlab-org/security/gitlab/-/commit/274a7177f5eea11e258534e5155f878334bf48ca) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4338))
- [Fix the catastrophic backtracking](https://gitlab.com/gitlab-org/security/gitlab/-/commit/88e2d71de74d04e29a8a62527bb147208c86fc29) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4290))
- [Security fixes for banzai pipeline part 2](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8167c0e9225c5893043ea34bfc1353035f173924) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4282))
- [Remove xhtml extensions from snippets blobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8ba1a3f5a36820995e512b4ec846d57df54ed9c4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4301))
- [Add a project scope to LfsTokens](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9e684758e31af25bdb69a8d4f95e8e0821bfc40b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4320))
- [Fix ReDoS when parsing git push options](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f49a979105bdfd365738d42406e94f7cabba4601) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4313))
- [Fix ReDoS in RefMatcher](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ec18bbdcb19f831d3732e2ffebe87740982baf24) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4316))
- [Enforce `require_password_to_approve` MR approval policy property](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d9769f6d7a11c2ae23f8816483358f7da3e729be) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4260))

## 17.1.3 (2024-07-24)

### Fixed (2 changes)

- [Fix wildcard search for package.json in npm upload](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f319a2257eca7ef742367b9b4636645ad4781ea2)
- [Ignore object pool already exists creation errors](https://gitlab.com/gitlab-org/security/gitlab/-/commit/01c080264ccb25ec17c04eeb470014389a916cfa)

### Security (7 changes)

- [Refactor import_export_upload to be user-based](https://gitlab.com/gitlab-org/security/gitlab/-/commit/70145f096f59d1729df3f0e1244a039c6e14f0b7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4264))
- [Fix for private txt artifacts being accessible through the artifacts/browse link](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8889c5c795eb2bd19b1bbcf7e05050c009843f82) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4293))
- [Attribute BulkImport::Export to a particular user](https://gitlab.com/gitlab-org/security/gitlab/-/commit/68eb8994474a9b0fdd15d03ae2f0a75a61eecd1f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4285))
- [Don't include project-level analytics settings in DOM](https://gitlab.com/gitlab-org/security/gitlab/-/commit/caf6a3a26a0bedfc309f8ba45bea605fc37e70f7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4185))
- [Fix for private dotenv artifacts not accessible to downstream jobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ed6d149e28b4c8aafe36d6c6ff2824e1d459c651) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4242))
- [Do not allow script execution on dependency responses](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f412b11cacce187d0d7c463fdba0a3c1d4d378ad) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4254))
- [Remove prohibited tags after import](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fda79ce08be8700a75eadaf9641e1ee00b0d92ec) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4249))

## 17.1.2 (2024-07-09)

### Fixed (2 changes)

- [Update dependency slack-messenger to v2.3.5](gitlab-org/security/gitlab@e21a4599ab21cc6f6b89ca432d9557ed72169c85)
- [Fix MailRoom not loading in Omnibus](gitlab-org/security/gitlab@5547c1164c494705bf29595062124ff8cb266cb3)

### Security (9 changes)

- [Disallow serving Pages over disabled custom domains with deployments](gitlab-org/security/gitlab@176442d616a111667481f22186560925d1175c67) ([merge request](gitlab-org/security/gitlab!4245))
- [Check npm package name, version and scripts coherence](gitlab-org/security/gitlab@917d805ce57e5d0439b4a4c757967d494014a97d) ([merge request](gitlab-org/security/gitlab!4212))
- [Check for create_deploy_token policy before creating deploy token](gitlab-org/security/gitlab@8ae4e9b0b25bec92561698da3c7d0495d6ba61bc) ([merge request](gitlab-org/security/gitlab!4209))
- [Check if user has ban_group_member access before banning in namespace](gitlab-org/security/gitlab@eefb608987d64b9cf58411b8520f260d1fb9b1c3) ([merge request](gitlab-org/security/gitlab!4091))
- [Prevent privilege escalation via custom role](gitlab-org/security/gitlab@a618e86dc4585b0fef049f75f13acf0eec00656d) ([merge request](gitlab-org/security/gitlab!4199))
- [Prevent using quick actions for some bot users](gitlab-org/security/gitlab@5789cc333d04d76ffb4c79239e71be1910f12229) ([merge request](gitlab-org/security/gitlab!4231))
- [Disable raw HTML for quick action pipeline](gitlab-org/security/gitlab@7db9b002b803cb6b53a3e6ce3f8d9b15107e7464) ([merge request](gitlab-org/security/gitlab!4235))
- [Disable quick actions unless description changed](gitlab-org/security/gitlab@a1800c591b38df0e2d143df3ee56f76b4f3a914f) ([merge request](gitlab-org/security/gitlab!4234))
- [Remove comment support from shrug and tableflip](gitlab-org/security/gitlab@fb6bcef1935dc3a7dd60def448a652769c86ee62) ([merge request](gitlab-org/security/gitlab!4229))

## 17.1.1 (2024-06-25)

### Fixed (1 change)

- [Only enumerate commits in pre-receive check if push came from Web](gitlab-org/security/gitlab@09fac947735945114db37b482035ffe8f605a1ad)

### Security (14 changes)

- [Security fixes for banzai pipeline](gitlab-org/security/gitlab@bb484256fab53f248450f49350d44ec246f05e49) ([merge request](gitlab-org/security/gitlab!4184))
- [Fix the catastrophic backtracking in openapi regex](gitlab-org/security/gitlab@d9f51d836d290fc90f6bbfd50937e28ac4382ad6) ([merge request](gitlab-org/security/gitlab!4135))
- [Use permitted_params for standalone and multiplex queries](gitlab-org/security/gitlab@624758559c2ffa452c7d118b4bf438783bf22b96) ([merge request](gitlab-org/security/gitlab!4173))
- [Fix for Private job artifacts can be accessed by any user](gitlab-org/security/gitlab@4c5ac0433595920d2e9e1a0887461fbf9ea58476) ([merge request](gitlab-org/security/gitlab!4194))
- [Remove search results from public projects with unauthorized repos](gitlab-org/security/gitlab@74bebdd2a20be50c13d3696b0cc2ba815fd9e95b) ([merge request](gitlab-org/security/gitlab!4210))
- [Do not run a new pipeline on re-target](gitlab-org/security/gitlab@0a90eb06107fce3a6c2e15dcead5ec9fc0302967) ([merge request](gitlab-org/security/gitlab!4187))
- [Add limits on autolinker regex](gitlab-org/security/gitlab@4854ff9db1ee52c37cab05d5be1eb02b4e5e93b0) ([merge request](gitlab-org/security/gitlab!4126))
- [Fix clickjacking on OAuth application page](gitlab-org/security/gitlab@3620cdabd780c08754f48df7a81b0ed41924f75e) ([merge request](gitlab-org/security/gitlab!4186))
- [Hide branch merge request if merge requests are private](gitlab-org/security/gitlab@551999ae405109144906d3b0fbd254553ba10baa) ([merge request](gitlab-org/security/gitlab!4200))
- [Remove collapseLongCommitList method](gitlab-org/security/gitlab@35a86b9d0cec107e06d56ced48ecbf5ac108250c) ([merge request](gitlab-org/security/gitlab!4203))
- [Pass SSO session data to Sidekiq](gitlab-org/security/gitlab@143598720f040450de58440be4266337278fb87f) ([merge request](gitlab-org/security/gitlab!4197))
- [Prevent non-members from using promote_to quick action for quick actions](gitlab-org/security/gitlab@ce44d723af3e7c117f56e1539da2c12ee1892b90) ([merge request](gitlab-org/security/gitlab!4190))
- [Reject deletion of security policy project approval rules](gitlab-org/security/gitlab@926855938a4a92251b0631b67cad330888e17909) ([merge request](gitlab-org/security/gitlab!4172))
- [Mitigate ReDoS attacks via `method_call_regex`](gitlab-org/security/gitlab@350aa934a38aa9aae0b4216dcaa51e6a17463e4e) ([merge request](gitlab-org/security/gitlab!4174))

## 17.1.0 (2024-06-19)

### Added (180 changes)

- [Allow `admin_runner` ability to change shared runner setting](gitlab-org/gitlab@f8a4a504e3b04875bed19bdef66f7cdcaae7e462) ([merge request](gitlab-org/gitlab!155505)) **GitLab Enterprise Edition**
- [Update services to create custom software license](gitlab-org/gitlab@fef112e156bf0f37f8b1dbd310cd2a2ddc629eb2) ([merge request](gitlab-org/gitlab!155325)) **GitLab Enterprise Edition**
- [Protected containers: Add help text for repository path pattern input](gitlab-org/gitlab@e710daa4b59d0ae74d608490c1cd563437c4ca74) by @gerardo-navarro ([merge request](gitlab-org/gitlab!154932))
- [Move document for CS for registry](gitlab-org/gitlab@06d2a6d2b6cdcb7cffd7ffc81b0706485d5967c2) ([merge request](gitlab-org/gitlab!156259)) **GitLab Enterprise Edition**
- [Add new duo pro discover page](gitlab-org/gitlab@ca64b696dbd33b8cddcd1f887d31afb4290853bf) ([merge request](gitlab-org/gitlab!154478)) **GitLab Enterprise Edition**
- [Changed association of frameworks with projects](gitlab-org/gitlab@ecaf61939432fe08eb7fa8fe48925d04c4685a68) ([merge request](gitlab-org/gitlab!153664)) **GitLab Enterprise Edition**
- [Add support for new placeholders](gitlab-org/gitlab@679bf3a203e041300daf200de432c81d70062b72) by @TamsilAmani ([merge request](gitlab-org/gitlab!155804))
- [Add `admin_runners` custom ability](gitlab-org/gitlab@860f5cc09eca6679d90184fd33a855086f31ac4e) ([merge request](gitlab-org/gitlab!154848)) **GitLab Enterprise Edition**
- [Add worker to aggregate last 30-day catalog resource usage data](gitlab-org/gitlab@56f45cfdc1fa3a94f0e850d54970ac3936ca622a) ([merge request](gitlab-org/gitlab!155001))
- [Add cargo to supported sbom and sync types](gitlab-org/gitlab@11d3dfa2c8385a1d9400b9522d75047735630f4b) ([merge request](gitlab-org/gitlab!155751))
- [Add project settings sections to command mode results](gitlab-org/gitlab@e3d6d8a451ec86581cf04ad24eda35cdd63dbb49) ([merge request](gitlab-org/gitlab!153452))
- [Configuring Topology Service in Rails](gitlab-org/gitlab@8a21caa58fbbbba98451e729f4ed4c3163d0b685) ([merge request](gitlab-org/gitlab!154960))
- [Add ML Model filters to the "package files" screen](gitlab-org/gitlab@24693cd19d01cf068d1583ecaaaafa7b3a435332) ([merge request](gitlab-org/gitlab!155979))
- [Include SAST Advanced in configuration UI allowlist](gitlab-org/gitlab@0f3e2a4bd3615d84560a16ed8135dff8e9f2a836) ([merge request](gitlab-org/gitlab!155008))
- [Group level work items support group level references](gitlab-org/gitlab@d1d21618d3a4b09505237af330d8503316b745f4) ([merge request](gitlab-org/gitlab!155637))
- [Add search in wiki sidebar](gitlab-org/gitlab@88a691503f1b92d90fd4783f677ed99af0763bbc) ([merge request](gitlab-org/gitlab!156054))
- [Render icons beside suggestions](gitlab-org/gitlab@264f9e3fd3578996a697ed8c93f33b77f050ba5c) ([merge request](gitlab-org/gitlab!155976))
- [Display temporary extension expiration banner](gitlab-org/gitlab@eb9ac6e66e76b5a9422c3780f0106300ad265bab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155634)) **GitLab Enterprise Edition**
- [Add logs header details](gitlab-org/gitlab@554fdb0265d264131c7423c02fbea7fa6f3586f6) ([merge request](gitlab-org/gitlab!155970))
- [Cleanup index terraform module archive FF](gitlab-org/gitlab@849296529460dd8dc1660398d4e40c6fc942926a) ([merge request](gitlab-org/gitlab!156156))
- [Create new custom Permission: read_crm_contact](gitlab-org/gitlab@13916c1997d7337fe282d739c33815a5e262c5db) by @ChaelCodes ([merge request](gitlab-org/gitlab!154017)) **GitLab Enterprise Edition**
- [Use custom models for duo chat features](gitlab-org/gitlab@bc3255cc5fb1c190fdd300f05b21bf426f5669aa) ([merge request](gitlab-org/gitlab!155849)) **GitLab Enterprise Edition**
- [Add ssh-upload-pack endpoint to handle Git over SSH requests](gitlab-org/gitlab@611a6b6eb9a1036748612d343b188b43c68212ac) ([merge request](gitlab-org/gitlab!152950)) **GitLab Enterprise Edition**
- [Add embedding reference and call it on condition](gitlab-org/gitlab@2afc4344343a7664884f2661f4b29427284324ca) ([merge request](gitlab-org/gitlab!154297)) **GitLab Enterprise Edition**
- [Add related issues to Merge Request API](gitlab-org/gitlab@d8e0674a01430f6aaf5fb55b3f8399ab72b054ad) by @zzaakiirr ([merge request](gitlab-org/gitlab!155422))
- [Add partition_id to Ci::Sources::Project](gitlab-org/gitlab@0e8c5e2d3c1274442b18c5ed74c92bd042c7afc7) ([merge request](gitlab-org/gitlab!153798))
- [Expose configuration in API and UI](gitlab-org/gitlab@20cf75de599c2310eef2d9acc648256931185a21) ([merge request](gitlab-org/gitlab!155791))
- [Filter projects by marked for deletion](gitlab-org/gitlab@221286e98b3f2649ae488259924449f7c3462990) by @imskr ([merge request](gitlab-org/gitlab!155006)) **GitLab Enterprise Edition**
- [Add urls to generated changelogs](gitlab-org/gitlab@5ecf224b05928c27a0d1497547c3b9d6bc3f85e1) by @Taucher2003 ([merge request](gitlab-org/gitlab!155806))
- [Add count field to WorkItemConnection](gitlab-org/gitlab@709210626b80013a6149ae2cb002a1f26b792d12) ([merge request](gitlab-org/gitlab!154951))
- [Progress bar & status to model artifact importer](gitlab-org/gitlab@0d73432f51793db73e1695439438f826a6ff80b7) ([merge request](gitlab-org/gitlab!154729))
- [Exposed note body first line on GraphQL](gitlab-org/gitlab@3931abe5e167f9e31daf214ba60178240a6d8f51) by @zillemarco ([merge request](gitlab-org/gitlab!148829))
- [Add external MR diffs to `gitlab-backup` task](gitlab-org/gitlab@7c1ce75666229ff0a84d92a8cc16c5644421af7c) by @zzaakiirr ([merge request](gitlab-org/gitlab!154914))
- [Add support for rendering icons](gitlab-org/gitlab@84feccba79c9f7d60376f82a25f8d4f926177af6) ([merge request](gitlab-org/gitlab!155244))
- [Add identifier_external_ids column to vulnerability_reads](gitlab-org/gitlab@314fadea6cce393c7634a01519af129a0141b130) ([merge request](gitlab-org/gitlab!153131))
- [Protected packages: Label "protected" for package detail page on group](gitlab-org/gitlab@3573a068ed23fb94efb28bfeb38d93c40cc399a8) by @gerardo-navarro ([merge request](gitlab-org/gitlab!154811))
- [Clean up duo_chat_display_source feature flag](gitlab-org/gitlab@2baf06a40fae34cdbcd0a7e4150ed5f831fe75ec) ([merge request](gitlab-org/gitlab!155863)) **GitLab Enterprise Edition**
- [Adds sort by publish date for container registry tags list](gitlab-org/gitlab@8407cb55de456ee43f57f84e2b84b9e95ccf650d) ([merge request](gitlab-org/gitlab!153383))
- [GraphQL changes to fetch vulnerability severities count with limits](gitlab-org/gitlab@a950ea5d8a4226b1f07486deba823ee486fb2b55) ([merge request](gitlab-org/gitlab!155452)) **GitLab Enterprise Edition**
- [Allow actor override when GitHub and BBS disabled](gitlab-org/gitlab@01943ffd96aa3cc132bc3114f80f1e776b0b42d7) ([merge request](gitlab-org/gitlab!155796))
- [Early access program participation checkbox](gitlab-org/gitlab@ecf2c7dbf650100803a4b70e1549659ac59dfebd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154957)) **GitLab Enterprise Edition**
- [Add approval_policy_rule_id to approval rules and related tables](gitlab-org/gitlab@e4451d35b8f3f77dcfa72f6af0ed4991064591fe) ([merge request](gitlab-org/gitlab!155232))
- [Add organization to vuln export for sharding](gitlab-org/gitlab@2fbe359eb14671f2a7abf62da760ea11ad91ab9b) ([merge request](gitlab-org/gitlab!154994)) **GitLab Enterprise Edition**
- [Add verified creator badge](gitlab-org/gitlab@c56408a830bc0f765d2340a64d38dc6d6c07bedc) ([merge request](gitlab-org/gitlab!154179))
- [Protected packages: REST API GET package protection rules](gitlab-org/gitlab@8484e6af92d8e4e994c0f1bbb6b66dfa30c1d395) by @nwittstruck ([merge request](gitlab-org/gitlab!153436))
- [Improves empty state on model registry model page](gitlab-org/gitlab@4783ee0070324bb2e3d06df0af3aaf447cfac061) ([merge request](gitlab-org/gitlab!155399))
- [Add star count as sorting option for CICD Catalog](gitlab-org/gitlab@1253250db1b70012b8c122792cb16ca49916ea89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155240))
- [Validate form input for version and model name](gitlab-org/gitlab@072d8c889ad57c1dee9feed9131488d307db5a62) ([merge request](gitlab-org/gitlab!154728))
- [Create partitions for new audit event tables](gitlab-org/gitlab@336efc87b0d0de1fc68a4de318bd471e313ff49c) ([merge request](gitlab-org/gitlab!154418))
- [Add support for Redis extra config command to ActionCable](gitlab-org/gitlab@9ace9e8f59a9dfcd6fe01ff87321e5196e87da44) ([merge request](gitlab-org/gitlab!155546))
- [Filter projects by marked for deletion](gitlab-org/gitlab@67543b86542d6e3216c4c06a22cf48303c14b6d8) by @imskr ([merge request](gitlab-org/gitlab!154770)) **GitLab Enterprise Edition**
- [Allow selecting project for project level items](gitlab-org/gitlab@1c81a23f21b51453283f1c9b3e8076ca5877385f) ([merge request](gitlab-org/gitlab!154554))
- [Protected containers: Update protection rules in project settings ui](gitlab-org/gitlab@dc31dfc0a71cf69ffbf5de4a14cde87fca60c60b) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146623))
- [Handle declined event for bitbucket server importer](gitlab-org/gitlab@241112be0455dc585ee9f7469c30cdaec754a27c) by @ivantedja ([merge request](gitlab-org/gitlab!153298))
- [Adding gcp audit event destination validator](gitlab-org/gitlab@b01fbc9f6cd3d983187f1868f373528efa4c24c1) ([merge request](gitlab-org/gitlab!151662)) **GitLab Enterprise Edition**
- [Add pmg README.md](gitlab-org/gitlab@124334406446c27fdbb9364fe783763bdbc05a09) ([merge request](gitlab-org/gitlab!154964))
- [Add `admin_runners` custom ability](gitlab-org/gitlab@ab0cebe39ec53f99633c09016691e4dfe80f9bf1) ([merge request](gitlab-org/gitlab!151825)) **GitLab Enterprise Edition**
- [Add support for Sentinel usernames in Workhorse](gitlab-org/gitlab@c2da33720ce47d4c13912dbd5acb818640b5577f) ([merge request](gitlab-org/gitlab!155209))
- [Default enable diff_preview_in_email](gitlab-org/gitlab@20ab134ba94807467a25a1b22f30810e3ef6a81d) ([merge request](gitlab-org/gitlab!155143))
- [Add CVS for CS document](gitlab-org/gitlab@bef3d803b03bc7769324fb5402b554d4c07635b5) ([merge request](gitlab-org/gitlab!154388)) **GitLab Enterprise Edition**
- [Add security policies projects join table](gitlab-org/gitlab@6825da6e2ee80412084ccdb101913f7fb23a2b41) ([merge request](gitlab-org/gitlab!154742)) **GitLab Enterprise Edition**
- [Display timestamp in log lines](gitlab-org/gitlab@5d79019ee98f65a69c3b450eee09edd605fa616a) ([merge request](gitlab-org/gitlab!153851))
- [GraphQL: Add fullPath argument in runnerUsage query](gitlab-org/gitlab@b6cd9a3a27c3b2fec6dcb07896a671e0bb57d702) ([merge request](gitlab-org/gitlab!154462)) **GitLab Enterprise Edition**
- [Add sorting by `component_name` to dependency list aggregations](gitlab-org/gitlab@1d5d98f41ded8c8695be033c527821af1df6352e) ([merge request](gitlab-org/gitlab!154779))
- [Backfill work_item_dates_sources with epic dates data](gitlab-org/gitlab@3ab4c15e1db9a58e3ff5d820522a52e1b1e3120e) ([merge request](gitlab-org/gitlab!153115))
- [Add confirmation message on manual job with confirmation message](gitlab-org/gitlab@12525d358bc5a60f27d37706a4f245f59473a4f9) by @lifez ([merge request](gitlab-org/gitlab!151978))
- [Remove `repository_tree_gitaly_pagination` feature flag](gitlab-org/gitlab@f5b4a1f811fd1934d01a7e061003acec3ebeed40) ([merge request](gitlab-org/gitlab!154897))
- [Add source code to `/explain_vulnerability` tool](gitlab-org/gitlab@58410808e409f920d6c66cb1792797b86aed8148) ([merge request](gitlab-org/gitlab!154229)) **GitLab Enterprise Edition**
- [Add Restore Pages Deployment Mutation](gitlab-org/gitlab@1bdb5dafc0520d68a7241daa73206e0077915697) ([merge request](gitlab-org/gitlab!155283))
- [Enable integration API for admin integrations custom ability](gitlab-org/gitlab@59b0d3b699233ffd876fcec058cdfc1cd48b5a38) ([merge request](gitlab-org/gitlab!155228)) **GitLab Enterprise Edition**
- [Add PagesDeployment to deletePagesDeployment Mutation](gitlab-org/gitlab@40b7b2c8032e23248d86a0e18acc21c256028c1f) ([merge request](gitlab-org/gitlab!154399))
- [Adjust the mistral promprt for 22b](gitlab-org/gitlab@d35b60b18f3a4f0ea8c74668793f91639bd8c2d1) ([merge request](gitlab-org/gitlab!155083)) **GitLab Enterprise Edition**
- [GraphQL: Add fullPath argument in runnerUsageByProject query](gitlab-org/gitlab@4f0a1f7665f753c34de10ce7a54b97ce2865f964) ([merge request](gitlab-org/gitlab!154300)) **GitLab Enterprise Edition**
- [Filter by marked_for_deletion_on in groups graphql](gitlab-org/gitlab@3b56b2acdfb4869b30d89c0f9c9f3b0bcbbe19a3) by @imskr ([merge request](gitlab-org/gitlab!154846)) **GitLab Enterprise Edition**
- [Add support for latest_tag](gitlab-org/gitlab@d3791921420e3c253d1ff2dd0d0cf01a2c0727e0) by @TamsilAmani ([merge request](gitlab-org/gitlab!153525))
- [Add PagesDeployments to Project type](gitlab-org/gitlab@0c67d1f5687e11869370a0497d861e2a53d66e13) ([merge request](gitlab-org/gitlab!154104))
- [Enable show_container_registry_tag_signatures feature flag by default](gitlab-org/gitlab@3d600c9a74c75d04257f2ff4baa6d49d8b5b5b54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154706)) **GitLab Enterprise Edition**
- [Add admin integrations custom permission](gitlab-org/gitlab@431c9f7392b282686470ef6e1073d7df62c28348) ([merge request](gitlab-org/gitlab!154601)) **GitLab Enterprise Edition**
- [Improve observability by various Git LFS metrics](gitlab-org/gitlab@06350c606ddc8303d2bd0244754cb65ed9933b57) ([merge request](gitlab-org/gitlab!138920))
- [Add GraphQL mutation `projectTextReplace`](gitlab-org/gitlab@f2333f5e6f370301c64d43687e98209789a6e47a) ([merge request](gitlab-org/gitlab!152522))
- [Adds published message for each container registry image repository](gitlab-org/gitlab@a88eac528860f927001ae47d448a1e15c1585f5d) ([merge request](gitlab-org/gitlab!153947))
- [Create separate elastic queue for embeddings](gitlab-org/gitlab@5bd81d3a7449d90ddd43b86d272e80be45b1be3a) ([merge request](gitlab-org/gitlab!154269)) **GitLab Enterprise Edition**
- [Log token info for GraphQL requests](gitlab-org/gitlab@88608f725c17dc6b6a6a50c34ccab16682e3f83a) ([merge request](gitlab-org/gitlab!148885))
- [Add Limit for CVS for CS](gitlab-org/gitlab@b7bfbd0fcc31f7dfd6a879397c3b775199db47c5) ([merge request](gitlab-org/gitlab!154925)) **GitLab Enterprise Edition**
- [Add a new task initial_indexing for Zoekt::SchedulingService](gitlab-org/gitlab@454840f907735112f685d26f9e58244b8cb52298) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149365)) **GitLab Enterprise Edition**
- [Add option to add custom html header tags via gitlab.yml config](gitlab-org/gitlab@8136229ad7f3e95f5ba0e924c8d636a94e2f10b7) by @bufferoverflow ([merge request](gitlab-org/gitlab!153877))
- [Add support for custom headers in webhook API](gitlab-org/gitlab@b79f616bd307b73f6b7cf704a68d4fb6854de85e) by @Taucher2003 ([merge request](gitlab-org/gitlab!153768))
- [Audit when product analytics settings are changed](gitlab-org/gitlab@a454e70e03308842f62cac378442f52032aa471e) ([merge request](gitlab-org/gitlab!154407)) **GitLab Enterprise Edition**
- [Protected packages: REST API DELETE package protection rules](gitlab-org/gitlab@8d65804581cb692c0518710479ba6761675b6962) by @nwittstruck ([merge request](gitlab-org/gitlab!151741))
- [Remove single_relation_import feature flag](gitlab-org/gitlab@83284db7430c50671d129d86399fe5cadbc6c5b3) ([merge request](gitlab-org/gitlab!154786))
- [Add audit event for web hook creation](gitlab-org/gitlab@8f564e9ef7df4c1685427b14d88bb751cf10f3ea) ([merge request](gitlab-org/gitlab!154046)) **GitLab Enterprise Edition**
- [Include custom role name in members exports](gitlab-org/gitlab@c08cfd868522426fa79069629fdeb11d2d6539ca) ([merge request](gitlab-org/gitlab!153980)) **GitLab Enterprise Edition**
- [GraphQL: Add runnerManager field to CiJob](gitlab-org/gitlab@88c0a6d08afd20d2d7d55cdda7bba9750f7ce30a) ([merge request](gitlab-org/gitlab!154737))
- [GraphQL: Add managers field to CiRunner](gitlab-org/gitlab@5c4a13f5d02bf1157e20c0b50c2b658cac3ea06f) ([merge request](gitlab-org/gitlab!154737))
- [Add trigram indexes on email column](gitlab-org/gitlab@46ddd7a42253b6275a3ec55323268b1f567c8b62) by @zzaakiirr ([merge request](gitlab-org/gitlab!152249))
- [Add partition_id to Ci::PipelineMessage](gitlab-org/gitlab@6fe5f634263520dbd6e17a7bfd18377270303584) ([merge request](gitlab-org/gitlab!153391))
- [Backfilling of work_item_parent_links from epics parent_id](gitlab-org/gitlab@98cc1d3cf0561a1154474ee775464418057c228d) ([merge request](gitlab-org/gitlab!153442))
- [Introduce ci_pipeline_variables_minimum_role](gitlab-org/gitlab@79bc51d82b86ae8d000ae947f322d90e3cdb95e3) ([merge request](gitlab-org/gitlab!149343))
- [Finalize BackfillPartitionIdCiDailyBuildGroupReportResult](gitlab-org/gitlab@104bbe7723a86a12c1cdde48b9172ed64a3ca155) ([merge request](gitlab-org/gitlab!154530))
- [Created blueprint for pipeline mini graph](gitlab-org/gitlab@012b8a80f6938465068c80b8f087fb6a736def19) ([merge request](gitlab-org/gitlab!154313))
- [Add explain vulnerability tool](gitlab-org/gitlab@b614184ad6abafe8abeb5a91602851b554fe329f) ([merge request](gitlab-org/gitlab!153961)) **GitLab Enterprise Edition**
- [Add a cleanup worker for removable add-on purchases](gitlab-org/gitlab@9d37fe4c8cef6105530e1df74b82bd4fe6824863) ([merge request](gitlab-org/gitlab!153713)) **GitLab Enterprise Edition**
- [Add WorkItemAddClosingMergeRequest mutation to GQL API](gitlab-org/gitlab@465160c7a5d46bcb02b5559271a6723928cdc421) ([merge request](gitlab-org/gitlab!153775))
- [Audit when product analytics settings are changed](gitlab-org/gitlab@73f397b384a1bfacfd59881c63b1c1620e52d681) ([merge request](gitlab-org/gitlab!154101)) **GitLab Enterprise Edition**
- [Filter groups by marked_for_deletion_on](gitlab-org/gitlab@d80f9c8f2c163b494aba80c538eb177ac28c7f51) by @imskr ([merge request](gitlab-org/gitlab!153873))
- [Add spec for the `handleClusterError` helper](gitlab-org/gitlab@6ef18cfafcbe9639268cafd5a1d55c5d990641cb) by @antonkalmykov ([merge request](gitlab-org/gitlab!153695))
- [Add resolver for product analytics project settings](gitlab-org/gitlab@5438f948a050c210c76c6db3f05503ee1e81cacf) ([merge request](gitlab-org/gitlab!153796)) **GitLab Enterprise Edition**
- [Update doc for single_relation_import flag status](gitlab-org/gitlab@40bd6a923bf53e323fd504e496c223355172ce4c) ([merge request](gitlab-org/gitlab!154355))
- [Add API-Security CI template](gitlab-org/gitlab@99592285a6f1ebd35b0d69c6552c51472c6b0b73) ([merge request](gitlab-org/gitlab!147183)) **GitLab Enterprise Edition**
- [Add index for sorting by highest severity](gitlab-org/gitlab@851c61ebf39e810ff0492a21eeb18bb57dc2d438) ([merge request](gitlab-org/gitlab!154054))
- [Add projects dropdown to work_item_links_form component](gitlab-org/gitlab@b4756440354deb6f9e79cd5d9cfb548e77bae441) ([merge request](gitlab-org/gitlab!150711))
- [Adds support for dynamic schemas with date range filters](gitlab-org/gitlab@817e8cf030cf3ef3278358bf8ff27744f2d79bce) ([merge request](gitlab-org/gitlab!153803)) **GitLab Enterprise Edition**
- [Include none argument owasp_top_10 filter](gitlab-org/gitlab@645e4bdf8aa332295772c60b2069f7cd9fd11c5e) ([merge request](gitlab-org/gitlab!146344)) **GitLab Enterprise Edition**
- [Filter the pods list be clicking at the pod stat](gitlab-org/gitlab@2e693cad136692c44abb569ab1d636b896e1e0a4) ([merge request](gitlab-org/gitlab!153467))
- [feature: Create a new model and version and upload artifacts](gitlab-org/gitlab@309031660104fdd77caafa9cf677c59a520113fa) ([merge request](gitlab-org/gitlab!154079))
- [Send configured API key to AI Gateway](gitlab-org/gitlab@68efd36fba9d4ee9d0d0a35cda4970f8cc0ddcb4) ([merge request](gitlab-org/gitlab!154231)) **GitLab Enterprise Edition**
- [Adds a mergeTrainIndex field to merge requests](gitlab-org/gitlab@4670104daf3a94f5f633382a27fd5d35fa4b91fb) ([merge request](gitlab-org/gitlab!153954)) **GitLab Enterprise Edition**
- [Introduce data source for overtime DORA metrics](gitlab-org/gitlab@c066a28049d3a143731288d591422e923d67f1ca) ([merge request](gitlab-org/gitlab!151885)) **GitLab Enterprise Edition**
- [Add partition_id to Ci::DailyBuildGroupReportResult](gitlab-org/gitlab@58276af81f68f248d075c2bf7ebe00797d078dc0) ([merge request](gitlab-org/gitlab!153236))
- [feature: Create new model version & import artifacts](gitlab-org/gitlab@e82a775276ce13e7b391ec7d5d23ba97de92c265) ([merge request](gitlab-org/gitlab!153522))
- [Adds last_activity_on to Members table](gitlab-org/gitlab@e1b1e2b8040969b5dfa4045e3ed73f707a90d527) ([merge request](gitlab-org/gitlab!153593))
- [Add capability to support error codes on Duo Chat backend](gitlab-org/gitlab@5868366e912c8839b6e89eab7236d6598d0f7e7a) ([merge request](gitlab-org/gitlab!152698)) **GitLab Enterprise Edition**
- [[Feature Flag] Cleans up large_ipynb_diffs](gitlab-org/gitlab@3adb923bcfed405c73e06d4737d23d3837863138) ([merge request](gitlab-org/gitlab!153689))
- [Backfill related epic links to issue links](gitlab-org/gitlab@2f4c73943e238d510a7208805e104c29775dbc84) ([merge request](gitlab-org/gitlab!152104))
- [Add security policy scheduled scans concurrency limit](gitlab-org/gitlab@74f4cd3b72a9513dc9e83ccc1a402447889c37d6) ([merge request](gitlab-org/gitlab!152855)) **GitLab Enterprise Edition**
- [Add graphql mutation endpoint to run VerifyNamespaceService](gitlab-org/gitlab@4e7843e4a3c638fbfeee16d34ecae0ce239c005c) ([merge request](gitlab-org/gitlab!152641)) **GitLab Enterprise Edition**
- [Add not valid foreign key to namespaces.parent_id](gitlab-org/gitlab@6ec6f6754702c2d176d9e0b2dc68be92c5aed887) ([merge request](gitlab-org/gitlab!153402))
- [Expose Vulnerabilities::StateTransition ID in GraphQL](gitlab-org/gitlab@172cc775744f51be39ba655376a6624cd5687f63) ([merge request](gitlab-org/gitlab!153842)) **GitLab Enterprise Edition**
- [Extend label GraphQL search with field list](gitlab-org/gitlab@ab0e019723ef80c7d998cfc9c5f49e295236636f) ([merge request](gitlab-org/gitlab!152761))
- [Add GraphQL filters by deployments](gitlab-org/gitlab@45a20b939bb4e1389672d186c136756aee174019) ([merge request](gitlab-org/gitlab!153660))
- [Add migration helpers (un)prepare_partitioned_async_index](gitlab-org/gitlab@bb069b392968a3c4dac33faf06268e097334d205) ([merge request](gitlab-org/gitlab!153064))
- [Add calendar endpoint for PATs](gitlab-org/gitlab@50f6045b078f86cfc4eb2e6bfa4a4c59d2910df3) ([merge request](gitlab-org/gitlab!153093))
- [Audit event tables](gitlab-org/gitlab@5177e5e9c65c65fb45951b7c9f4581ea29b6acd7) ([merge request](gitlab-org/gitlab!152035))
- [Add two options to configure target availability check in API Security](gitlab-org/gitlab@e8a121c5710487ebecabfeb80be623918d5cdc8f) ([merge request](gitlab-org/gitlab!153779))
- [Add project level filter](gitlab-org/gitlab@d862de1e7165b2eeed22e23bc1b123ee2dcb5981) ([merge request](gitlab-org/gitlab!152045)) **GitLab Enterprise Edition**
- [Create a GraphQL query for contributed projects](gitlab-org/gitlab@185cc42e5719cb58e170dcaa3fd49b9df1f9fb2a) by @yasuk ([merge request](gitlab-org/gitlab!151979))
- [Simplify wiki print functionality](gitlab-org/gitlab@9f5c2958872c6711287aae891d84d3ee85138e7b) ([merge request](gitlab-org/gitlab!153419))
- [Create car type](gitlab-org/gitlab@a62aa62f755d94e2b24280d5eb5f872ea6fd0695) ([merge request](gitlab-org/gitlab!152742)) **GitLab Enterprise Edition**
- [Displays the last published date for container repository](gitlab-org/gitlab@49e76171e1f3c718a6f9cc7db9154f96c5be4062) ([merge request](gitlab-org/gitlab!153274))
- [Render solution html in vulnerability modal](gitlab-org/gitlab@7d338c61f33156ec51809afabb5f24f3ec5d2bf1) ([merge request](gitlab-org/gitlab!153361)) **GitLab Enterprise Edition**
- [Downscale pasted retina images](gitlab-org/gitlab@5dd91aa354b117e6ac278f6293846761b52d2f7c) ([merge request](gitlab-org/gitlab!153043))
- [Add delete_user ability to OrganizationUser permission type](gitlab-org/gitlab@ee2cac1ee9e17841f839afb5ed35e85eb894edbd) ([merge request](gitlab-org/gitlab!153555))
- [Add hand raise lead to the duo pro trial widget popover](gitlab-org/gitlab@a157f949ea97799ef1dd26501c997c885a134ccc) ([merge request](gitlab-org/gitlab!153487)) **GitLab Enterprise Edition**
- [Validate work item presence in epics](gitlab-org/gitlab@26c593853c2883f8098ca61c6d06f09c22102a6d) ([merge request](gitlab-org/gitlab!153157))
- [Add pipeline validator to check identity verification](gitlab-org/gitlab@6678989ee82cb945745a5383310f933252414f66) ([merge request](gitlab-org/gitlab!152126)) **GitLab Enterprise Edition**
- [Remove `google_cloud_support_feature_flag` feature flag](gitlab-org/gitlab@572e7c67c232fe10c2fb714b940ddf32da3f451d) ([merge request](gitlab-org/gitlab!150472))
- [Add Rake task to update project storage](gitlab-org/gitlab@5bd5027ac232ec002f4dd85a80b83cec8601c6a2) ([merge request](gitlab-org/gitlab!153008))
- [Update type of subscription_add_on_purchases started_at column](gitlab-org/gitlab@141350051e319f0783b7fc533d37b387f697eea6) ([merge request](gitlab-org/gitlab!153764)) **GitLab Enterprise Edition**
- [Add GraphQL mutation `projectBlobsRemove`](gitlab-org/gitlab@5bdc99962ad929a48581adeb7d57fa08de31a499) ([merge request](gitlab-org/gitlab!152642))
- [Add BulkImport cancel API for instance admins](gitlab-org/gitlab@f1db82fb4db620ce0cff4f3a9e2ff4277caaca48) ([merge request](gitlab-org/gitlab!153120))
- [Add AI telemetry endpoint](gitlab-org/gitlab@087ae82c5ed794c3998ee7d139002c36e22c82ee) ([merge request](gitlab-org/gitlab!152946)) **GitLab Enterprise Edition**
- [Allow adding members by username](gitlab-org/gitlab@71591d3636d7d7723279ea004e3c935535901155) by @imskr ([merge request](gitlab-org/gitlab!147080))
- [Trigger GraphQl subscription when WorkItem hierarchy change](gitlab-org/gitlab@e53f65c6d16149153e776b0203e1cafcf16c85a8) ([merge request](gitlab-org/gitlab!153136))
- [feature: Delete model version](gitlab-org/gitlab@d2c9a6f0b779dda4391b90d4f602a1ec6afaf66a) ([merge request](gitlab-org/gitlab!152990))
- [Sync unique index creation for ci_pipelines.partition_id](gitlab-org/gitlab@470b65ac74e0ffc15bf1860f1443d6cdece529c0) ([merge request](gitlab-org/gitlab!153552))
- [Create audit events when deployments are approved or rejected](gitlab-org/gitlab@c11dd26b758e87c4d499c837d92e03051cfe8fd0) ([merge request](gitlab-org/gitlab!153375)) **GitLab Enterprise Edition**
- [Upload artifacts to an existing machine learning model version](gitlab-org/gitlab@743cb89e24c3accf6b279212be06e16b9e4d4270) ([merge request](gitlab-org/gitlab!152163))
- [Support directory structure in generic package registry](gitlab-org/gitlab@6a5bc3a417492b9325002f59126a97636e7e049b) ([merge request](gitlab-org/gitlab!153449))
- [Add pipeline validator to check identity verification](gitlab-org/gitlab@3582f4ee00e267012ed38e95125a4d5decff0477) ([merge request](gitlab-org/gitlab!151834)) **GitLab Enterprise Edition**
- [Release Silent Admin Exports feature](gitlab-org/gitlab@17bbff63c91b522bc01176dbadff8a86d8e95922) ([merge request](gitlab-org/gitlab!153351))
- [Added the featureFlagEnabled query field](gitlab-org/gitlab@f57ff57353b028a1b391eb2fdaa2ac2ae3b0d377) ([merge request](gitlab-org/gitlab!152638))
- [Create migration to add started_at to subscription_add_on_purchases](gitlab-org/gitlab@5eaf2667c2091503a67589d067ab4e35221e3ccc) ([merge request](gitlab-org/gitlab!152857)) **GitLab Enterprise Edition**
- [Add new option to filter projects in GraphQL](gitlab-org/gitlab@9e9f0eff9f2a170dcfb656fefdb47bef65d0ae92) ([merge request](gitlab-org/gitlab!153271))
- [Zoekt: Add callback service](gitlab-org/gitlab@d3c0a5d97399709156998abbf80b3dcb2ee4cf2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150157)) **GitLab Enterprise Edition**
- [Use the zoekt_settings in the Admin settings](gitlab-org/gitlab@da21dcea9dac757ad1468291a0d9c1bb5b7821e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148378))
- [Sync funnels when config project changes](gitlab-org/gitlab@07af6dee57361be87446527ede83c34e193ed506) ([merge request](gitlab-org/gitlab!150683)) **GitLab Enterprise Edition**
- [Add X-Gitlab-Version to Cloud Connector headers](gitlab-org/gitlab@8794a28812ba1a97d8af3c2143afb0e3298a7ec1) ([merge request](gitlab-org/gitlab!153065)) **GitLab Enterprise Edition**
- [Run migrations in milestone order](gitlab-org/gitlab@b807a0bae611a0845279270ef22ceb4c8326dc9a) ([merge request](gitlab-org/gitlab!137190))
- [Skip audit event on download of export, if silent](gitlab-org/gitlab@9d1bcbe792437a9aab42f88b20eda9f12b032563) ([merge request](gitlab-org/gitlab!152143))
- [Redirect wiki pages on renaming them](gitlab-org/gitlab@0662fa5b075f175ef6887ad2e0b674df795e448d) ([merge request](gitlab-org/gitlab!150727))
- [Add GraphQL mutation for product analytics project settings](gitlab-org/gitlab@c2f5fc85778555fdb2d6df31eb2d0b7cc4f5f99b) ([merge request](gitlab-org/gitlab!152721)) **GitLab Enterprise Edition**
- [Add initial duo pro trial status popover](gitlab-org/gitlab@8ddbf9005549974956e875deb6ed3af4561015fd) ([merge request](gitlab-org/gitlab!152538)) **GitLab Enterprise Edition**
- [Feature to delete artifacts from a model version](gitlab-org/gitlab@ff055b026489c947176c129fb220f6ebdfff5e88) ([merge request](gitlab-org/gitlab!152606))
- [Add a new IndexingTaskWorker](gitlab-org/gitlab@4722385a497bdb40697f80c70ac97d051dc2ee98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150036)) **GitLab Enterprise Edition**
- [Adds custom API server support for Telegram](gitlab-org/gitlab@8209b308112d1e41764ccd8343999f04c78c1487) ([merge request](gitlab-org/gitlab!152732))
- [Backend code for self-hosted LLM server instance configuration](gitlab-org/gitlab@1820afec649761ec888dd257afe50b9b3e462278) ([merge request](gitlab-org/gitlab!151793))
- [Add API for trigger group test webhook](gitlab-org/gitlab@1714db7b9cc40438a1f5bf61bef07ce45d33e207) by @lifez ([merge request](gitlab-org/gitlab!150486)) **GitLab Enterprise Edition**
- [Prepare async index for ci_pipelines.partition_id related](gitlab-org/gitlab@450c40ebde30bd25a501f3411b024275f1f9f7b3) ([merge request](gitlab-org/gitlab!147860))
- [Add manage_merge_request_settings custom permission](gitlab-org/gitlab@0b75a9ad563f7299ad900dd1994933884f85a242) ([merge request](gitlab-org/gitlab!151586))
- [Add custom software licenses table](gitlab-org/gitlab@4e12e0027592cb573bc059c8b11c209edb781b4a) ([merge request](gitlab-org/gitlab!151445)) **GitLab Enterprise Edition**

### Fixed (191 changes)

- [Check email confirmation status of active users](gitlab-org/gitlab@88e6c6adf8eeb23deff848e277fcf964e5c4a19e) ([merge request](gitlab-org/gitlab!156560)) **GitLab Enterprise Edition**
- [Fix the multiple zoekt_tasks creation for delete_repo](gitlab-org/gitlab@2e5860e05b1fb33db1c9c6bf98e409c3b7c87b2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156125)) **GitLab Enterprise Edition**
- [Force UTF-8 encoding on CSV export files](gitlab-org/gitlab@b22570929ba99f81a8b41ee3b2483bbad86def4c) ([merge request](gitlab-org/gitlab!156517)) **GitLab Enterprise Edition**
- [Ensure Workhorse log writers are closed to avoid Goroutine leaks](gitlab-org/gitlab@c9e7fbb94dc18ac6f9a914635365d41ae55d3a86) ([merge request](gitlab-org/gitlab!156420))
- [Update replication troubleshooting snippets](gitlab-org/gitlab@20fbbbda36292eef3b43c73871ce113c015d4a12) ([merge request](gitlab-org/gitlab!150743)) **GitLab Enterprise Edition**
- [Fix fork badge always shown in pipelines page](gitlab-org/gitlab@e73c4239287c3965f7c1f29d2a26a7a83a962342) ([merge request](gitlab-org/gitlab!156315))
- [Increase JWT expiration from 1 to 10 mins](gitlab-org/gitlab@104ed976d1ae6e44203fb43978f5b007bddb837b) ([merge request](gitlab-org/gitlab!154474)) **GitLab Enterprise Edition**
- [Fixed issue with command palette shortcut](gitlab-org/gitlab@09f50f501f494b2610ed31c13e8b40eaeeb3d754) ([merge request](gitlab-org/gitlab!156012))
- [Remove performance bar from jira connect](gitlab-org/gitlab@73d317ba31738e90cd14be33337a16df77e43704) ([merge request](gitlab-org/gitlab!156277))
- [Update Bitbucket Cloud Importer to map users by uuid](gitlab-org/gitlab@2dc625018b7b2aa0f13149ea2ec7a7c375eef05d) ([merge request](gitlab-org/gitlab!156163))
- [Fix product analytics manager offering UI](gitlab-org/gitlab@9020ae165c484b5f48841e0e509afaa3c00a2dac) ([merge request](gitlab-org/gitlab!156150)) **GitLab Enterprise Edition**
- [Implement segmented vulnerability export mechanism for large groups](gitlab-org/gitlab@a720e41522551d635c9955f0d1d6cd97a6ec7ae9) ([merge request](gitlab-org/gitlab!152517)) **GitLab Enterprise Edition**
- [Create worker to store security reports by project](gitlab-org/gitlab@c96bdc59f4fe7918ae6478b7451cec44622038c6) ([merge request](gitlab-org/gitlab!151541)) **GitLab Enterprise Edition**
- [Work item hierarchy change system notes use full references](gitlab-org/gitlab@d7a15fce8d0d35a0f85ea99725194ddea6da37f5) ([merge request](gitlab-org/gitlab!156080))
- [Allow labels to be specified with absolute path](gitlab-org/gitlab@55070060010d998769cd88fbf846a025fd343f75) ([merge request](gitlab-org/gitlab!152100))
- [Change FF to beta and default enable](gitlab-org/gitlab@1768bc1509610026afe3e8984d82222c3de571b8) ([merge request](gitlab-org/gitlab!155730)) **GitLab Enterprise Edition**
- [Show wiki sidebar content in history and changes](gitlab-org/gitlab@bc1ae03799e9145e4c313bf426d11eceb1d5753d) ([merge request](gitlab-org/gitlab!156089))
- [Increase SQL query threashold on work_items test](gitlab-org/gitlab@fa205fed2286474be4372201e2dcf13bc0eb2ce2) ([merge request](gitlab-org/gitlab!156171))
- [MR widget: Fix alignment](gitlab-org/gitlab@ee9dd4a96fa755416656f82e14da94fcb8ab96fb) ([merge request](gitlab-org/gitlab!156137))
- [Wiki: Fix last edited author](gitlab-org/gitlab@3cee102f59fc2e9c1884e31bafc71f9572404aa2) ([merge request](gitlab-org/gitlab!156143))
- [Remove unused issue card weight filtering functionality](gitlab-org/gitlab@c2a0ff663df5c76a545d42aaaea81a0f73f5eeea) ([merge request](gitlab-org/gitlab!155627))
- [Fix publishing npm package with custom root folder name](gitlab-org/gitlab@85a76d6dca39438755c39df5104266b866339698) ([merge request](gitlab-org/gitlab!155842))
- [Fixed overflowing layout on the compare revisions page](gitlab-org/gitlab@7b0a3e09d055c7a568504122779e9824e7c025c6) by @zillemarco ([merge request](gitlab-org/gitlab!155744))
- [Wiki: Fix header spacings on published pages and create page](gitlab-org/gitlab@a8a4ae87afbc6ecd5cd3b0a93a88faf565ad906f) ([merge request](gitlab-org/gitlab!156131))
- [Delete project_ref_name_in_pipeline feature flag](gitlab-org/gitlab@8263838e425d80a2ecb17641fa9529fda21a4d20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156110))
- [Wrap wiki history commit message](gitlab-org/gitlab@58664e791ef41a530a28eaa75236a96e1761b57e) ([merge request](gitlab-org/gitlab!156082))
- [Fix approvals text alignment](gitlab-org/gitlab@84dae5a9e7c06da98140fd9d0fadaf390049935a) ([merge request](gitlab-org/gitlab!156025))
- [Use gl-background-color-default for .gl-new-card-add-form background](gitlab-org/gitlab@52a9f9cc9564baf32887f63326f930c5ee1cb3b1) ([merge request](gitlab-org/gitlab!155108))
- [Sync updated_at attribute when updating epic](gitlab-org/gitlab@963c0850aa9c26b7f62dee9d1cadd3f3ec36814b) ([merge request](gitlab-org/gitlab!156059)) **GitLab Enterprise Edition**
- [Fix inviting members with a custom role](gitlab-org/gitlab@e441cfea7ad315ca3b3f9c9c1648df65aca899ec) ([merge request](gitlab-org/gitlab!155864)) **GitLab Enterprise Edition**
- [Remove the archived projects from the security dashboard](gitlab-org/gitlab@31eabb2a173455de2ffe5f6a3b7d1322412bc4fb) ([merge request](gitlab-org/gitlab!154330)) **GitLab Enterprise Edition**
- [Remove branch on jira when deleted on gitlab](gitlab-org/gitlab@221f138b09c7873d21ada8e875e18ed97d6c42c9) ([merge request](gitlab-org/gitlab!148712))
- [Update "shared runners enabled" setting on subgroup builds](gitlab-org/gitlab@48a012d87b132962c6ce4bebf56c37175a15d06a) ([merge request](gitlab-org/gitlab!154928))
- [Ignore wiki links that have missing href](gitlab-org/gitlab@8d570b29032133080cce1fb73dde203dcb41a842) ([merge request](gitlab-org/gitlab!155877))
- [Hide Exact code search in preferences when zoekt setting is disabled](gitlab-org/gitlab@06288e9256a1e3a841bef3f098f96ddc5f268e70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155586)) **GitLab Enterprise Edition**
- [This MR fixes project selection](gitlab-org/gitlab@cf845c45504d000294da1f10b4ada9dc0e77b0ce) ([merge request](gitlab-org/gitlab!155862)) **GitLab Enterprise Edition**
- [fix: Add zero-padded mapping for OWASP 2021 vuln categories](gitlab-org/gitlab@51350bfa6aa8ef4a5d6569f31b65729a90b47513) ([merge request](gitlab-org/gitlab!155860)) **GitLab Enterprise Edition**
- [Fix links and tree drag and drop on FF](gitlab-org/gitlab@ce592ead2f2fb5ec17faa1e4c8350b2ba1cd5a03) ([merge request](gitlab-org/gitlab!154787))
- [Update Merge train system note](gitlab-org/gitlab@d71fd369baee49cce5bbe38576a7e1b77f2b7d22) ([merge request](gitlab-org/gitlab!155551))
- [Fix calculating direct_members count](gitlab-org/gitlab@e8a438c3c92c93599de58c0a292b15f6a5e58600) ([merge request](gitlab-org/gitlab!155838)) **GitLab Enterprise Edition**
- [Fix the limit logic for containing refs requests](gitlab-org/gitlab@ae365c5d59713bd5780ef244dca5880a9743fc4c) ([merge request](gitlab-org/gitlab!155735))
- [Add reject_non_dco_commits to push rules REST API](gitlab-org/gitlab@ce371744d27ea0a463b0a221eb6888ce57814a74) ([merge request](gitlab-org/gitlab!155005)) **GitLab Enterprise Edition**
- [Use primary DB for authenticating artifacts downloads](gitlab-org/gitlab@db4e7f82c379296b1bdbafc5a41f4977a559fb81) ([merge request](gitlab-org/gitlab!155684))
- [Cleanup ci_runner_projects records with null project_id](gitlab-org/gitlab@5fc53aea1399ee8e4d0fb025193482d465f7f656) ([merge request](gitlab-org/gitlab!155760))
- [Cleanup ci_runner_namespaces records with null namespace_id](gitlab-org/gitlab@757d1ec2d1335e3d91d99be0d70fadd3115a6fd9) ([merge request](gitlab-org/gitlab!155761))
- [Take broadcast message height into account in board height](gitlab-org/gitlab@50d8593755d0ae3d9eba74d755566846b08404f8) ([merge request](gitlab-org/gitlab!155326))
- [Use blue color for subscribed state and active todo](gitlab-org/gitlab@1eb3453bd230bb89394b2286c157cb310668a3c5) ([merge request](gitlab-org/gitlab!155623))
- [Fix Epics::UpdateService to only sync changed attributes](gitlab-org/gitlab@c13b5b850af2c9795529de59d5a1337b16c1047a) ([merge request](gitlab-org/gitlab!155468)) **GitLab Enterprise Edition**
- [Respect carraige return in new job log viewer](gitlab-org/gitlab@6c6c829426ed17ed499d302ca5f8a1dd20240642) ([merge request](gitlab-org/gitlab!153704))
- [Update an expired test certificate](gitlab-org/gitlab@5c21cdd681b61e718654b73bb05befc3cb161423) ([merge request](gitlab-org/gitlab!155694))
- [Do not error when assigning issue to same epic](gitlab-org/gitlab@8f1692dbc66079c337971b3fa963a8f57af6b2f0) ([merge request](gitlab-org/gitlab!155632)) **GitLab Enterprise Edition**
- [Restrict GraphQL API to only documented token types](gitlab-org/gitlab@d69685b32dfb38f8e28b20bc4c010443ec0cd5d2) ([merge request](gitlab-org/gitlab!152130))
- [Fix fullPath for cross projects work items](gitlab-org/gitlab@3ac7eb13159b488d7828b67ed4a714112b4cc6c2) ([merge request](gitlab-org/gitlab!155247))
- [This MR fix bottom loader](gitlab-org/gitlab@159c0d82a246282f6bfd0f404f5474eccad222c7) ([merge request](gitlab-org/gitlab!155651)) **GitLab Enterprise Edition**
- [Fix missing filename when downloading generic package in release page](gitlab-org/gitlab@1bbbe8c569abb40052545029057f990d787da007) ([merge request](gitlab-org/gitlab!155013))
- [Verify the namespace_id on duo pro trial service layer](gitlab-org/gitlab@592ca38dfdee21c543e0a86aacb9875b0739f283) ([merge request](gitlab-org/gitlab!155321)) **GitLab Enterprise Edition**
- [Add spacing between framework pill and title in adherence list](gitlab-org/gitlab@beed63822b9533b57afd4936e3b27f91a6d40d0d) ([merge request](gitlab-org/gitlab!155517))
- [Execute the task even the repo is not found](gitlab-org/gitlab@518e5af14afd3ea968b0287f05db1cc001b1f965) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155574)) **GitLab Enterprise Edition**
- [Update ShortcutsBlob data](gitlab-org/gitlab@b71d5281d6f95a45c6b7b5cc491209ce9b95fc94) ([merge request](gitlab-org/gitlab!150836))
- [Show correct policies subheader for a group](gitlab-org/gitlab@f3e90a957241e086cb61ac2701120d0c6feb5488) ([merge request](gitlab-org/gitlab!155561)) **GitLab Enterprise Edition**
- [Fixes incorrect wrapping in styled log lines](gitlab-org/gitlab@d5077755cd75f7baa9143d1c14e8c62538630b81) ([merge request](gitlab-org/gitlab!155560))
- [Wiki sidebar: Fix hover in Darkmode](gitlab-org/gitlab@3f8163d43dbfd6f4748cc19561970f5dd5b120ec) ([merge request](gitlab-org/gitlab!155545))
- [Add analyze_interval for IntRangeStrategy](gitlab-org/gitlab@d0bcb7a7bbf7838d0c852f8f89230e82cd48a2c7) ([merge request](gitlab-org/gitlab!155538))
- [Add frontend scripts to assets hash calculation](gitlab-org/gitlab@97a567df370b5f5670afac9e5be3fbfa379d529b) ([merge request](gitlab-org/gitlab!155469))
- [Fix loading spinner spacing on child issues and epics](gitlab-org/gitlab@3010eda0658d4971104bdf53583587d4112f7e98) ([merge request](gitlab-org/gitlab!154467)) **GitLab Enterprise Edition**
- [Parses job log logs when lines gets split in chunks](gitlab-org/gitlab@f05a036eed649f7dbd4270b27e4966af4e1e3052) ([merge request](gitlab-org/gitlab!155095))
- [Remove card border for issue boards](gitlab-org/gitlab@9c4f0ba386e35a3de77c6eed3f606b6f982fd9ca) ([merge request](gitlab-org/gitlab!155216))
- [Enable extra slug sanitization on user provisioning](gitlab-org/gitlab@4423a768892336d21d934a2525f5f84a66b1dd43) ([merge request](gitlab-org/gitlab!147594))
- [Accept integer parameter in runner_type for GetUsageServiceBase](gitlab-org/gitlab@5f74a6de8dba029eebb6578db0fafd0ba83864ea) ([merge request](gitlab-org/gitlab!155121)) **GitLab Enterprise Edition**
- [Adds ancestors on the index Explore>Groups page](gitlab-org/gitlab@459e245199c87c0ba23199bf7e317db8a5d0bc15) ([merge request](gitlab-org/gitlab!153438))
- [Update MemberRoles::RolesFinder and Members::UpdateService](gitlab-org/gitlab@222a8a64d8938ad2010127d36889ab9271e0d4c1) ([merge request](gitlab-org/gitlab!152925))
- [Modify machine learning version input description](gitlab-org/gitlab@1d34552eb16398e793fb7f689043c1a6260dc35e) ([merge request](gitlab-org/gitlab!155207))
- [Fixes issue with valid Notebooks not diffing](gitlab-org/gitlab@2549735979d1c41b35684b73e614a68dd28216ef) ([merge request](gitlab-org/gitlab!155043))
- [Fix merge request padding](gitlab-org/gitlab@fc05924396fc0390f253ef5b713c370830977202) ([merge request](gitlab-org/gitlab!155133))
- [Remove the user_detail creation derisk feature flag](gitlab-org/gitlab@ef8805be95b078d02ba461805bcdb78cd28fcc07) ([merge request](gitlab-org/gitlab!153770))
- [Fix ancestor widget appearance in Epic sidebar](gitlab-org/gitlab@713b3a69cfbfdb3513a0feb2a975de7b5cac7543) ([merge request](gitlab-org/gitlab!154473)) **GitLab Enterprise Edition**
- [Allow more wiki types to be searchable](gitlab-org/gitlab@b54faca2df4b1f9ece74904a35c2e9a5d57e9ac3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154791)) **GitLab Enterprise Edition**
- [Fixes auditing non-changing fields for product analytics](gitlab-org/gitlab@6f3b2b9bc6953d559f6cb373f4874180872e0983) ([merge request](gitlab-org/gitlab!154762)) **GitLab Enterprise Edition**
- [Fix vertical spacing of collapse MR sidebar btn](gitlab-org/gitlab@9fff7b221555107621652d53742bac7f230458b0) ([merge request](gitlab-org/gitlab!154977))
- [Forbid branch protection updates with blocking policy in place](gitlab-org/gitlab@ca043088885417b226ededd07132855535a1c655) ([merge request](gitlab-org/gitlab!154369)) **GitLab Enterprise Edition**
- [Ensure complete messages are not passed to DuoChat in chunks](gitlab-org/gitlab@54f3c8c3b66f28501e2583e0ca751d1fa802c4c7) ([merge request](gitlab-org/gitlab!154306)) **GitLab Enterprise Edition**
- [Fix nav control layout for new dropdowns](gitlab-org/gitlab@2976f16cbc77beaaf1d8e4aa17e62ba16a4ccb41) ([merge request](gitlab-org/gitlab!154941))
- [Fix upgrade message link in operations dashboard](gitlab-org/gitlab@c816289a221cc4bff916734d153fa2516ee448d7) ([merge request](gitlab-org/gitlab!154930))
- [Delegate GroupHook URL validation to base class](gitlab-org/gitlab@c61f41b3980c3f6df94fe2ba8d59743530f0f1b2) ([merge request](gitlab-org/gitlab!154879)) **GitLab Enterprise Edition**
- [Fix the other icons being shown in loading state](gitlab-org/gitlab@05de171f5fd8b0aed8199f96707aaf4500f2e5b1) ([merge request](gitlab-org/gitlab!154867))
- [Fix serialization error on CI Lint with including a CI component](gitlab-org/gitlab@ca5c4651ab8cf24ab172214bca38e9eb7424fbbb) ([merge request](gitlab-org/gitlab!154747))
- [Fix code reloading for Sidekiq in development](gitlab-org/gitlab@9e3a454624524feb63401f0b7e31e651fbb9fe41) ([merge request](gitlab-org/gitlab!154847))
- [Fix button spacing and updating UI text to use sentence case](gitlab-org/gitlab@10630d60d5a2f4101fe15ff0d42fc2e71d63429c) ([merge request](gitlab-org/gitlab!154767)) **GitLab Enterprise Edition**
- [Fix protected branches deploy key selection for FOSS](gitlab-org/gitlab@1b6bbf9479c195e2272c114f40637535824a6c58) ([merge request](gitlab-org/gitlab!154884))
- [Remove the experiment_features_enabled check](gitlab-org/gitlab@db4a420af2278c26e9a6a044f7891bdc46bc4f05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154759)) **GitLab Enterprise Edition**
- [Fix visualization designer showing confirm modal after saving](gitlab-org/gitlab@f462a6f1932de0d18ca76f02e4d9f2c20cebc6ae) ([merge request](gitlab-org/gitlab!154585)) **GitLab Enterprise Edition**
- [Update StuckExportJobsWorker to not fail parallel export jobs](gitlab-org/gitlab@92936f18bac126be0f7a13cb530fe6dbce91f997) ([merge request](gitlab-org/gitlab!154772))
- [Vite config: Fix open in editor url](gitlab-org/gitlab@c0bd5d8dded7d6a3e5d35d3983bea126711c508a) ([merge request](gitlab-org/gitlab!154750))
- [Expose 'Is using seat' badge for Auditors](gitlab-org/gitlab@b6d1ac6544c233802cc4f589f9afe55e0acd953c) ([merge request](gitlab-org/gitlab!153123)) **GitLab Enterprise Edition**
- [Differentiate vulnerability security scanner](gitlab-org/gitlab@46722f6aa670674deba3bd731bdd92a6fcea065f) ([merge request](gitlab-org/gitlab!154268)) **GitLab Enterprise Edition**
- [Use compact pagination on explore page when total pages is unavailable](gitlab-org/gitlab@3dabc89d4e3dfd7a69ed6e06dfe0ff9a591c65dd) ([merge request](gitlab-org/gitlab!154051))
- [Exclude child pipelines from tag and branch query](gitlab-org/gitlab@72aeaa28ca6c66c9604d43c2f79b0f2f6683f18e) ([merge request](gitlab-org/gitlab!145503))
- [Fix registry list extra padding between list items](gitlab-org/gitlab@3a8cd5a6f8727902cf1f9e3782a618b17b7776e4) ([merge request](gitlab-org/gitlab!154136))
- [Include Group Links in access level check](gitlab-org/gitlab@7e8daa1016564b16267ae9b3f98987e65fa01f6d) ([merge request](gitlab-org/gitlab!154443)) **GitLab Enterprise Edition**
- [Fix work items showing icons and actions when not found](gitlab-org/gitlab@6f6c337dd3a8e0b0212fe6bb4efec6a81c197590) ([merge request](gitlab-org/gitlab!153346))
- [Fix missing BATCH_SIZE constant](gitlab-org/gitlab@a7e5069c26059da33277c65ae9e4280248ea4b97) ([merge request](gitlab-org/gitlab!154582))
- [Fix ActiveModel::UnknownAttributeError for `initialize_with_readme`](gitlab-org/gitlab@5151593ddb067105fdf8f928d93c03b0b06a2634) ([merge request](gitlab-org/gitlab!154579))
- [Add a check to use the different URL for namespace](gitlab-org/gitlab@1110192b28f621eb885799accd1b9a275c127b36) ([merge request](gitlab-org/gitlab!154245)) **GitLab Enterprise Edition**
- [Fix misleading error message when assigining sec policy project](gitlab-org/gitlab@920eefd94d8b2609c0caa746a4327d2d03346fe2) ([merge request](gitlab-org/gitlab!154402)) **GitLab Enterprise Edition**
- [Group visibility levels: Show all radio button with correct attributes](gitlab-org/gitlab@3917e9fbd217310de2dab82a63f2cf35967abc37) by @gerardo-navarro ([merge request](gitlab-org/gitlab!149427))
- [Fix display of performance bar in relative root installations](gitlab-org/gitlab@69165cae760a8e078d2694f0a8f38a9976eaa604) ([merge request](gitlab-org/gitlab!154537))
- [Fix Cloud Connector service catalog is stale](gitlab-org/gitlab@9398fdc9c343962b32453aa707ac18fa6b6e5567) ([merge request](gitlab-org/gitlab!154094))
- [Use `safe_params` to persevere sort params](gitlab-org/gitlab@d23db5479a5ea2baf0904bbe96405d6f20ad1ad8) ([merge request](gitlab-org/gitlab!154256))
- [Use localstorage to remember swimlane state for boards](gitlab-org/gitlab@ff623e67498c271af83a94d5f742285677098023) ([merge request](gitlab-org/gitlab!154174))
- [Generic Registry: Fix a bug when downloading files with sign symbol](gitlab-org/gitlab@7a8ca5f5cff9fad527988c071497cb6902514891) ([merge request](gitlab-org/gitlab!154248))
- [List all users in the Admin > Users](gitlab-org/gitlab@e8bfbccf974fb3118a95d892c16faa612e5c37d2) ([merge request](gitlab-org/gitlab!154392))
- [Do not allow creating Service Accounts for a subgroup](gitlab-org/gitlab@26408dfa91a9b8082b3b00aba01cc01a7a42ed69) ([merge request](gitlab-org/gitlab!154381)) **GitLab Enterprise Edition**
- [Fix child pipeline badge is broken in CI header](gitlab-org/gitlab@c8e8b55ef6a8775bb5c3d6257bbc49c3308dcd28) ([merge request](gitlab-org/gitlab!154376))
- [Fix Firefox Drag and Drop on epic lists](gitlab-org/gitlab@51074497aa9b48ee3b79122e135146111845f4fe) ([merge request](gitlab-org/gitlab!151676)) **GitLab Enterprise Edition**
- [Fixes typo for CS JOB](gitlab-org/gitlab@3acad3ecfced6e650b647d4cb920a576f6bd3534) ([merge request](gitlab-org/gitlab!154356)) **GitLab Enterprise Edition**
- [Fix @ autocomplete when search requests overlap](gitlab-org/gitlab@a7f794b027af20e8006e489eedd9cb624f5f616a) ([merge request](gitlab-org/gitlab!153924))
- [Allow branch protection updates via API with `block_branch_modification`](gitlab-org/gitlab@4fac6923be8e044036bbd926f702904c935ad9c5) ([merge request](gitlab-org/gitlab!153245)) **GitLab Enterprise Edition**
- [Set height: auto only on images with both dimension set](gitlab-org/gitlab@f7bb3a177ba17c6ccba24150f7430037c06bce92) ([merge request](gitlab-org/gitlab!154316))
- [Move modal and drawer out of container style](gitlab-org/gitlab@b239ea8869b23ca0f5c8d689caf8bd77538d779e) ([merge request](gitlab-org/gitlab!154135))
- [Import fork MR when target branch couldn't be created](gitlab-org/gitlab@b227427600845670ad2f4b38daa995c006e1fd28) ([merge request](gitlab-org/gitlab!154291))
- [Fix doc link to project topics](gitlab-org/gitlab@12d003f45195285185932dbed1f290d77122350a) ([merge request](gitlab-org/gitlab!154255))
- [Add default branch to branches API cache_context](gitlab-org/gitlab@4f2dce2d2e3a7d1a21330f2a0829d4435b67dcaf) ([merge request](gitlab-org/gitlab!152445))
- [Fix gitlab:db:decomposition:migrate task](gitlab-org/gitlab@83abacca7af10e055dc04fef6d00c80da2f87cd6) ([merge request](gitlab-org/gitlab!154198))
- [Fix dark mode hover for admin/credentials row user email](gitlab-org/gitlab@503e189d3d8db1f6e2329bf5c73daa828dc68802) ([merge request](gitlab-org/gitlab!153314)) **GitLab Enterprise Edition**
- [Set imported from value for project export import](gitlab-org/gitlab@75e0ca51d2764dc291af99f5e2fc340effd9d99c) ([merge request](gitlab-org/gitlab!153462))
- [Include headers in LfsDownloadObject](gitlab-org/gitlab@58c58cacad7351f9aa1c99539bcbd78d2bd0ed77) ([merge request](gitlab-org/gitlab!153840))
- [Set height: auto on images](gitlab-org/gitlab@a65de758f476bbcc83141be8eab70d90b41fab59) ([merge request](gitlab-org/gitlab!154122))
- [Fix registry search sorting layout in mobile screen sizes](gitlab-org/gitlab@d4b9a82eabbfaf85de2b512d2992be16e94acd97) ([merge request](gitlab-org/gitlab!153641))
- [Parameterize path after regex validation failure](gitlab-org/gitlab@56665acd82f894a470ec71706ed627283dec3d17) ([merge request](gitlab-org/gitlab!153869))
- [Use text-subtle instead of a disabled class for badge img empty](gitlab-org/gitlab@e7bb43efe406d6c1c650aa759d23f85e29e8a7d4) ([merge request](gitlab-org/gitlab!153901))
- [A11y fix: make sure "+" button can be focused in wiki sidebar](gitlab-org/gitlab@e46f9f147ab852c407f59acf0041e6fd11145fe0) ([merge request](gitlab-org/gitlab!154015))
- [Fix "shared_audit_event_id_seq" already exists](gitlab-org/gitlab@6a54eecf3cf19fe3dd95557fe6ad014d5a09bbd1) ([merge request](gitlab-org/gitlab!154007))
- [Fix batched finish worker reenqueue delay](gitlab-org/gitlab@f2c578993c5fded8c92e766961b29552446597b8) ([merge request](gitlab-org/gitlab!153976))
- [Ignore imported column in relevant models](gitlab-org/gitlab@44842e0cf3ee536c70a3ffea267efa5ce460764d) ([merge request](gitlab-org/gitlab!152620))
- [Show current wiki page as active](gitlab-org/gitlab@7e918f4456cd2f057eee5be89bf9dc39d1a6446c) ([merge request](gitlab-org/gitlab!153986))
- [Fix default branch protection settings](gitlab-org/gitlab@80e81f359ec7be1037cdba0456b2a9b4ab60c4d7) ([merge request](gitlab-org/gitlab!153306))
- [Use label text color for remove button icon in MR filter bar token](gitlab-org/gitlab@70eb192055a4d9be0259a5237f4bcbb0682a3653) ([merge request](gitlab-org/gitlab!153598))
- [Avoid idling in transaction when exporting with Parallel Project Export](gitlab-org/gitlab@199edf664d45f5f67dbc16695f1933266cc634ae) ([merge request](gitlab-org/gitlab!153955))
- [Only lookup by username if ops flag is enabled](gitlab-org/gitlab@8b1d6683bb36a15687bd445afaeccec3c2a1695a) ([merge request](gitlab-org/gitlab!153041))
- [Roadmap - Fix alignment of epics with no start date](gitlab-org/gitlab@a74dd9c640f7568d3711bf62f628472ad04350bb) ([merge request](gitlab-org/gitlab!153790)) **GitLab Enterprise Edition**
- [Filter labels already applied out of recently used suggestions](gitlab-org/gitlab@ac433c925f63e51dec4c45549182f5cfa20ed761) ([merge request](gitlab-org/gitlab!150063))
- [Fix broken link in CI Catalog verified badge](gitlab-org/gitlab@043203424b953c529049a9a83b1af345605b6ed3) ([merge request](gitlab-org/gitlab!153891))
- [Fix webhooks temporary disabled too long, too fast](gitlab-org/gitlab@bbb4872f2ea9aafd7205f2900cc3250d82f88a65) ([merge request](gitlab-org/gitlab!153637))
- [Update member roles REST API doc](gitlab-org/gitlab@66bf14afb8c7b792fa4e53ace0c520ca23b58f8d) ([merge request](gitlab-org/gitlab!153569))
- [Handle project creation error on git push](gitlab-org/gitlab@2e984bbd7a6b9da6f55c65f12c800a321f540752) ([merge request](gitlab-org/gitlab!153852))
- [Fix roadmap settings drawer offset height](gitlab-org/gitlab@16cb382ada2adf220e5e091f904a3c97bd3bf047) ([merge request](gitlab-org/gitlab!153767)) **GitLab Enterprise Edition**
- [Fix access levels for default branch protection](gitlab-org/gitlab@7561640903f7b443f68aced970f7bb2fb56955af) ([merge request](gitlab-org/gitlab!153688))
- [Disable promote button for in flight request](gitlab-org/gitlab@2c43b5b20a4da0d7fd6eefb4854c324ececaa292) ([merge request](gitlab-org/gitlab!153658))
- [Fix insert table box in rich text editor](gitlab-org/gitlab@9f029b40718b63034ef4753bece222fa3117a862) ([merge request](gitlab-org/gitlab!153185))
- [Ensure label text color is used for label filter in MR search bar](gitlab-org/gitlab@9d1da9d744a0058abb200d2c6ae7889f06ac86c1) ([merge request](gitlab-org/gitlab!153594))
- [Do not allow group Owners create Service accounts on Self-managed](gitlab-org/gitlab@64df3fcc1a2acded0ef5e52f0033af0a988391e2) ([merge request](gitlab-org/gitlab!152195)) **GitLab Enterprise Edition**
- [Fix an overwrite bug in the gcs metrics concern](gitlab-org/gitlab@822f7559f10ca45c5b75214866ec9a5336db1bcd) ([merge request](gitlab-org/gitlab!153252))
- [Skip pre-receive SD on deletes](gitlab-org/gitlab@be2328e70ea65122d1c1ce0b222c216dc4e610fc) ([merge request](gitlab-org/gitlab!153022)) **GitLab Enterprise Edition**
- [Fix board swimlanes headers background](gitlab-org/gitlab@7daca3861f715c71d62563cd80b8c9cf7943ff52) ([merge request](gitlab-org/gitlab!153476))
- [Prevent error in copy_metadata quick action](gitlab-org/gitlab@98bdd03317b5cd00421ae928a597fee0c498c718) ([merge request](gitlab-org/gitlab!153463))
- [Update imported value when cloning and moving issues](gitlab-org/gitlab@ceb1b3d123a9bf682aa442a3bfa959290f851470) ([merge request](gitlab-org/gitlab!152949))
- [Fix an N+1 situation](gitlab-org/gitlab@4fdf15c1a34307cf2dcd8ab0266daddb5bac5518) ([merge request](gitlab-org/gitlab!153444))
- [Move Direct Transfer project entities creation to a later stage](gitlab-org/gitlab@2f3ce52023aaf60fe3ac3c355d5352930618baf1) ([merge request](gitlab-org/gitlab!153441))
- [Reset project counters after relation import](gitlab-org/gitlab@18500843ba1fd41e5a4d0e709100fb039f5c9121) ([merge request](gitlab-org/gitlab!153261))
- [MR commit message: Fix existing message dropdown selection](gitlab-org/gitlab@edc55c66883cc8b808a997db609b66b99afdf789) ([merge request](gitlab-org/gitlab!153408))
- [Restrict `repository_object_format` update for PUT projects/:id](gitlab-org/gitlab@50f73c33e18066ebe335957effc3f0dfb0e0bab0) ([merge request](gitlab-org/gitlab!153411))
- [Correctly handle nil assignee arguments](gitlab-org/gitlab@f843d822f2a940c4654042024a0b908f19ce58a3) ([merge request](gitlab-org/gitlab!153404))
- [Fix dropdown behavior in ProtectedBranchHelpers to fix flaky test](gitlab-org/gitlab@11e4985f2bc6ff570058a1af32898ea098b12f14) ([merge request](gitlab-org/gitlab!153318))
- [Fix hidden code navigation tabs](gitlab-org/gitlab@8867313d15a7ad6da02f1386563a1878a2e977f2) ([merge request](gitlab-org/gitlab!153310))
- [Fix error when calling GQL ciConfig endpoint with include:component](gitlab-org/gitlab@911b7c6d7a35f3385a9f5cf8e77ea5dfd73ab1bc) ([merge request](gitlab-org/gitlab!153046))
- [Ensure BLPOP/BRPOP returns nil instead of raising ReadTimeoutError](gitlab-org/gitlab@b661fe39d595822918b9960e36809a1cc070f842) ([merge request](gitlab-org/gitlab!153282))
- [Use consistent encoding with startup js to fetch commit data](gitlab-org/gitlab@40679dd8da169f37b6979f8a587cd27dfe154e44) ([merge request](gitlab-org/gitlab!152929))
- [Expose project settings in REST API only for maintainer+ users](gitlab-org/gitlab@a05e5cfdb571b15b6db703780046148893b4c063) ([merge request](gitlab-org/gitlab!152023))
- [Fix approval policy to include group level protected branch](gitlab-org/gitlab@57c116c8760ad288dde0c47ee7d471a46a27de5a) ([merge request](gitlab-org/gitlab!153240)) **GitLab Enterprise Edition**
- [Fix N+1 query in /api/v4/projects/:id/jobs endpoint](gitlab-org/gitlab@a729189d3b4495fb529c0ffec9e6b52c51a49d4a) ([merge request](gitlab-org/gitlab!152904))
- [Only include the duo pro widget data if ultimate trial is absent](gitlab-org/gitlab@5ddbf85b40c86e8ce2667b840fc850837f8d9e48) ([merge request](gitlab-org/gitlab!153207)) **GitLab Enterprise Edition**
- [Fix counts for Search Within filter on issues list](gitlab-org/gitlab@881152d45ddd8890d15ab22ff2a97a1e9ad50191) ([merge request](gitlab-org/gitlab!153148))
- [Fix instance templates pagination](gitlab-org/gitlab@50f07a23b5cc694f24a5becff18e383f9cc93180) ([merge request](gitlab-org/gitlab!152921)) **GitLab Enterprise Edition**
- [MR: Show sidebar expand button on md breakpoint](gitlab-org/gitlab@5826a8814af9cadf505561e543b2d0c6a0397088) ([merge request](gitlab-org/gitlab!153069))
- [Make pending invitations search case insensitive](gitlab-org/gitlab@027dd7c657fca91b92914f3a7ce0c5e7cf646bba) ([merge request](gitlab-org/gitlab!152275))
- [Fixes "retryable" value for merge train pipelines as JSON](gitlab-org/gitlab@61a7fdf8fb6592f1932bdbf14a150c0fd4a58d17) ([merge request](gitlab-org/gitlab!152785)) **GitLab Enterprise Edition**
- [Change column default when the connections match](gitlab-org/gitlab@b47c5a409028a321a4f2339bdd6d1951ee270842) ([merge request](gitlab-org/gitlab!152933))
- [Link squashed, fast-forwarded merge requests to deployments](gitlab-org/gitlab@0422af60b3f3e8742c869083ea6f5193933ed3cc) ([merge request](gitlab-org/gitlab!152892))
- [Fix broken DORA performers score Storybook story](gitlab-org/gitlab@77957dbe5935018b9e910fa59a98863c7947d467) ([merge request](gitlab-org/gitlab!152861)) **GitLab Enterprise Edition**
- [Resolve flash of light styles when using auto color mode](gitlab-org/gitlab@aac0c68e8b0905a2c7ecbfd9bee30e34a7074dd2) ([merge request](gitlab-org/gitlab!152726))
- [Increase Atlassian token constraint](gitlab-org/gitlab@d58ba4ff37495dbfdaeac722e3eb5273a131be6f) ([merge request](gitlab-org/gitlab!152472))
- [Fix webhook warning permission check](gitlab-org/gitlab@09b3dee12925bf5df72d7e7bef2c63c8b408e6e9) ([merge request](gitlab-org/gitlab!152764)) **GitLab Enterprise Edition**
- [Bugfix file type icon resizes](gitlab-org/gitlab@0837165b15b7cb5bbaaa2f4b42d006d2214caac1) ([merge request](gitlab-org/gitlab!149724))
- [Fix Sidekiq migration timeout](gitlab-org/gitlab@63f1a8b3a58e6be5d3f2d843f3c2bc7ec583fe54) ([merge request](gitlab-org/gitlab!152754))
- [Fix OpenTofu CI/CD template backport](gitlab-org/gitlab@2906f7dd014c7f7abbe8917600d6cea39f610ebc) ([merge request](gitlab-org/gitlab!152748))
- [Fix collapsing sections in job log viewer](gitlab-org/gitlab@2189f1d86dbd8e5932092e3ab0f8bd0165ae3d05) ([merge request](gitlab-org/gitlab!152635))
- [Project transfer fix for ES indexing](gitlab-org/gitlab@98381f9e3d53050cdb137d90e8f1a2e7fdb3faa0) ([merge request](gitlab-org/gitlab!152650)) **GitLab Enterprise Edition**
- [Support Epic -> WorkItem sync of imported_from](gitlab-org/gitlab@bb87978b032b8a7a59f85fcd880b93be0f2d467a) ([merge request](gitlab-org/gitlab!152575)) **GitLab Enterprise Edition**
- [Right align snippet comment actions dropdown](gitlab-org/gitlab@b2e16eaf13b50f5be8c5da0529e038d725b97c34) ([merge request](gitlab-org/gitlab!152563))
- [Fix blob viewer line numbers](gitlab-org/gitlab@b26445992db50d72d58c0a218d23a3a8b851b59f) ([merge request](gitlab-org/gitlab!152331))
- [Fix flow metrics handling of null assignees](gitlab-org/gitlab@18aed612317fd01b674cfa130b4ae771a9e94e51) ([merge request](gitlab-org/gitlab!152127))

### Changed (308 changes)

- [Improve Analytics dashboards schema errors](gitlab-org/gitlab@9a72b77758a8a995183bec3153b4ac62dfce81ae) ([merge request](gitlab-org/gitlab!155896)) **GitLab Enterprise Edition**
- [Drop beta tag on Duo Pro promotion](gitlab-org/gitlab@875a8662ff4fd63e886ddf6468b7ef03c33ec312) ([merge request](gitlab-org/gitlab!156332))
- [Dont identify a user using a deploy key](gitlab-org/gitlab@57ff0d2337e4a11bb2f4783a76cee706e044f81f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153714))
- [Always show project count for group dependency list](gitlab-org/gitlab@23961918e241f4d16b4fbc87f8bcc27e76340532) ([merge request](gitlab-org/gitlab!156200)) **GitLab Enterprise Edition**
- [Add the proper empty state when wiki page not found](gitlab-org/gitlab@6ebf62f085e274d4e0d5d5e8872eab711c2afa46) ([merge request](gitlab-org/gitlab!156003))
- [Re-sync basic epic fields to work items](gitlab-org/gitlab@f28991fc518f66f2384b17aabf007bf8f4ab78d9) ([merge request](gitlab-org/gitlab!153736))
- [Declare `StoreSecurityReportsByProjectWorker` memory-bound](gitlab-org/gitlab@10ba0cec1b344a021dd600a16f13b6fcdcbbecd9) ([merge request](gitlab-org/gitlab!156478)) **GitLab Enterprise Edition**
- [Rename `work_items_mvc_2` to `work_items_alpha`](gitlab-org/gitlab@5456cc62cdcdadc3f1bd85ae32320b6a812b7172) ([merge request](gitlab-org/gitlab!155990))
- [Rename for reauthentication vs just password](gitlab-org/gitlab@a6a1e0eff08eefe224163d9b8e10e92ae29ef86c) ([merge request](gitlab-org/gitlab!150710)) **GitLab Enterprise Edition**
- [Reset input field when closing the modal to delete merged branches](gitlab-org/gitlab@69ca77dccf3aaf6aff38763d035f00a156510d15) ([merge request](gitlab-org/gitlab!155866))
- [Display easy to read error messages for Duo Chat](gitlab-org/gitlab@1eb026fcd8ead7001e503f018ef2583789b57324) ([merge request](gitlab-org/gitlab!154363)) **GitLab Enterprise Edition**
- [Work items: Migrate headline to use type scale](gitlab-org/gitlab@804f2e05b827a71e25cc7cfb0d971af316144f02) ([merge request](gitlab-org/gitlab!155715))
- [Improve VSD warning messages for failed API requests](gitlab-org/gitlab@35f819006b3683e89b2735e969bc02568a62064f) ([merge request](gitlab-org/gitlab!155307)) **GitLab Enterprise Edition**
- [Replace funnel name attribute with file name](gitlab-org/gitlab@c63cb149fd25690896d0bb5ba0889aac8c311dc0) ([merge request](gitlab-org/gitlab!156140)) **GitLab Enterprise Edition**
- [Update wiki page titles](gitlab-org/gitlab@b43b00591d8f794f19cae9d497c11cd81d4e7066) ([merge request](gitlab-org/gitlab!155856))
- [Update analytics settings page with link to dashboards page](gitlab-org/gitlab@c4553f02f1b7b0fe6d1bf4f603a5b50a4e7a2471) ([merge request](gitlab-org/gitlab!155847)) **GitLab Enterprise Edition**
- [Add padding to OWASP identifiers](gitlab-org/gitlab@88e46543866fea9beba21cb90df1ca615658dd08) ([merge request](gitlab-org/gitlab!156124)) **GitLab Enterprise Edition**
- [Fixes incorrect params passed to Workato](gitlab-org/gitlab@6f20eeb1aa17827798259b88008c9986a80b79bd) ([merge request](gitlab-org/gitlab!156081)) **GitLab Enterprise Edition**
- [Changes for project owners to receive email notifications](gitlab-org/gitlab@a075f58677ed18ffd0a3398446aa6f9f6e5511fa) ([merge request](gitlab-org/gitlab!155391))
- [Check for related_epics ff when linking epics](gitlab-org/gitlab@0d77a05dd638c2acb95cf6aa9458b5cf14319311) ([merge request](gitlab-org/gitlab!155706)) **GitLab Enterprise Edition**
- [Improve markdown syntax highlighting](gitlab-org/gitlab@e8924a991170babae52a82e2d6a20e289bfb1f5f) ([merge request](gitlab-org/gitlab!139904))
- [Enable user searching by partial email for admins](gitlab-org/gitlab@4531e215539615f598e76b189637cb6ad02a853a) by @zzaakiirr ([merge request](gitlab-org/gitlab!147204))
- [Update PMG architecture blueprint](gitlab-org/gitlab@b2988be7b588a0da5061d1f36ef5345e3ccde493) ([merge request](gitlab-org/gitlab!156216))
- [Fix spacing of new wiki form help text](gitlab-org/gitlab@d27c1b693f770c9c16ef399eaa4f571b360c9c01) ([merge request](gitlab-org/gitlab!156211))
- [Fixed search page flicker](gitlab-org/gitlab@ed6b4ef9378c1c8690e57058f117281f0925e02c) ([merge request](gitlab-org/gitlab!153102))
- [Improve the look of the token access table](gitlab-org/gitlab@2402a354f0b8bd871fa4a5a04c68be7ea2e2be89) ([merge request](gitlab-org/gitlab!151728))
- [Doc(Feature rollout): extend of monitoring](gitlab-org/gitlab@1c08fa901d01a1ce1844a2f7311178dddc786b0a) ([merge request](gitlab-org/gitlab!155857))
- [Don't show viewed file tooltip on scroll](gitlab-org/gitlab@1364a81809dab33b1e772d65188136b1f779a14e) ([merge request](gitlab-org/gitlab!155319))
- [Issuable: Migrate title](gitlab-org/gitlab@9cce810f60e3169c1ece42fd3b6a20ba0d171ce7) ([merge request](gitlab-org/gitlab!155098))
- [Changes model candidates to use ml_model packages](gitlab-org/gitlab@32f7e081ac29a44af344097f05028a4633466039) ([merge request](gitlab-org/gitlab!155096))
- [Handle errors in different formats](gitlab-org/gitlab@eedc5677cfc3e1fb38b905b72915025874176cf9) ([merge request](gitlab-org/gitlab!156153)) **GitLab Enterprise Edition**
- [Configure the Claude 3 Haiku model for VE](gitlab-org/gitlab@4726fa1e1c4d2893cfb44181263b1c8ff5c39bf2) ([merge request](gitlab-org/gitlab!156151)) **GitLab Enterprise Edition**
- [Added create method in MemberApproval, modified promotion mgmt util](gitlab-org/gitlab@8cd2ce31758a90ba0fe3ca2e1d8fba6b06d10f4f) ([merge request](gitlab-org/gitlab!154552)) **GitLab Enterprise Edition**
- [Wiki: Clean up code for injecting props](gitlab-org/gitlab@0d046d491ec2e82198750d897feb562f6e3e340d) ([merge request](gitlab-org/gitlab!156136))
- [Merge request: Migrate headline to use type scale](gitlab-org/gitlab@6186a75c64d1d605f2040b12b413e49cf8eeccc4) ([merge request](gitlab-org/gitlab!155708))
- [Issuables: Update alignment of open and closed status badge icons](gitlab-org/gitlab@5f196995c05cfa4bdd5bbcb8a836ceea9db2806c) ([merge request](gitlab-org/gitlab!155969))
- [Route LLM requests to AI Gateway](gitlab-org/gitlab@52fb2dd9736da25572b712d93934f761b81e0e0e) ([merge request](gitlab-org/gitlab!155387))
- [Remove  `prevent_issue_epic_search` feature flag](gitlab-org/gitlab@9835b9febbf12a69e2968944f31da9d836dc3a1e) ([merge request](gitlab-org/gitlab!156087)) **GitLab Enterprise Edition**
- [Update bulk assign service to include iterable triggers](gitlab-org/gitlab@f8a95d3c724f5b9667f99920011ec1bca1bdc785) ([merge request](gitlab-org/gitlab!153300)) **GitLab Enterprise Edition**
- [Add links to description in AI impact analytics dashboard](gitlab-org/gitlab@12efc8d7c2832872e7d3aa09c43aef4728282b56) ([merge request](gitlab-org/gitlab!155484)) **GitLab Enterprise Edition**
- [Validate that all or no analytics settings are defined](gitlab-org/gitlab@b415943adfdc1da32fdbf5bc47b010c92dcd852c) ([merge request](gitlab-org/gitlab!155051)) **GitLab Enterprise Edition**
- [Replace issues.milestone_id index by a [milestone_id, id]](gitlab-org/gitlab@cff20d04c882679118db9c092300b3824421c3ee) ([merge request](gitlab-org/gitlab!155120))
- [Save sidebar entries collapsed state](gitlab-org/gitlab@611f3a1521a3d5df1844d62c4d85247568cd8de7) ([merge request](gitlab-org/gitlab!156027))
- [Search flyout: Bump project avatar size to 32](gitlab-org/gitlab@79ecd33131e41ac3589a6d2a445d7a823efd85ad) ([merge request](gitlab-org/gitlab!156024))
- [Rename /explain_vulnerability Duo slash command](gitlab-org/gitlab@ca36155b5cf01b8f95c6b4297772c8020138c30d) ([merge request](gitlab-org/gitlab!156030)) **GitLab Enterprise Edition**
- [Remove `security_policies_unassign_redundant_policy_projects` FF](gitlab-org/gitlab@445daa55010e3ac9aa9fb8c83e69a5c702c1a0ec) ([merge request](gitlab-org/gitlab!156015))
- [Auto-select the current project](gitlab-org/gitlab@342bdaa4eacc4fb1ebe7b9e6a4db916127907de1) ([merge request](gitlab-org/gitlab!155750))
- [Remove search_query_builder feature flag](gitlab-org/gitlab@6a3196e48ff61f51fa5d2aa7b94ea60e0133d2b3) ([merge request](gitlab-org/gitlab!154805)) **GitLab Enterprise Edition**
- [Wiki custom sidebar: Store pages state in localStorage](gitlab-org/gitlab@3a9b7bfdae9f54bbb0c9a5003784e048a48b289b) ([merge request](gitlab-org/gitlab!155558))
- [Reduce runner stale timeout from 3 months to 7 days](gitlab-org/gitlab@01efb84f94894b5d817ba7a862e3ab21b7a87cae) ([merge request](gitlab-org/gitlab!155795))
- [SPP no secrets no message docs update](gitlab-org/gitlab@ab127ca5e2c50fdbb9a4b89183dbbb321a26cd57) ([merge request](gitlab-org/gitlab!155920))
- [Update beta documentation](gitlab-org/gitlab@6f65eda63f9cdca5ae8630aaa78c9b2c883ca0fb) ([merge request](gitlab-org/gitlab!151619))
- [Improve TOC functionality in rich text editor](gitlab-org/gitlab@1699087397fdb208dcd33a53723e0f42b02e87f7) ([merge request](gitlab-org/gitlab!155903))
- [Update dependency ai-gateway to v1.7.0](gitlab-org/gitlab@ee8ff222bd491f0160262ac8214c2110e13ea2ae) ([merge request](gitlab-org/gitlab!155919))
- [Update docs path to secret push protection](gitlab-org/gitlab@c18021bdd9164beeb01dd97150b2c21767274f85) ([merge request](gitlab-org/gitlab!155918))
- [Break out downstream pipelines](gitlab-org/gitlab@93b40f959a78801f09b074d7378e9835c7f79c85) ([merge request](gitlab-org/gitlab!155382))
- [Show alert on web IDE start error](gitlab-org/gitlab@414a0ab82f0bd2129bca29cb37f8ed6ca912e2a7) ([merge request](gitlab-org/gitlab!154178))
- [Updated popover text of system_id column on runner page](gitlab-org/gitlab@b5facc6017d74cde7c168dd06120a7a0c8956e01) by @catinbag ([merge request](gitlab-org/gitlab!153617))
- [Wiki: Create & edit sidebar changes](gitlab-org/gitlab@fd1071ba278659fd8702ffa8595f7b50e8ed9ece) ([merge request](gitlab-org/gitlab!155685))
- [Migrates gl-display-block to gl-block](gitlab-org/gitlab@09be442a056294b72923b8fa2ea6c7a22cce95c7) ([merge request](gitlab-org/gitlab!154880))
- [Wiki: Show more actions dropdown on pages](gitlab-org/gitlab@9fa0e5ee34cbe274b20babedc3400314f53ad05c) ([merge request](gitlab-org/gitlab!155832))
- [Change gitlab:elastic:index to async worker](gitlab-org/gitlab@50117cde75c3e15fc8a1bacca9262b2e4a7324c6) ([merge request](gitlab-org/gitlab!154610)) **GitLab Enterprise Edition**
- [Hide create wiki page button if inadequate permissions](gitlab-org/gitlab@df43408a5796fa7e1402af628c86f9e2e4b44022) ([merge request](gitlab-org/gitlab!155851))
- [Removes alpha from CI Catalog fields](gitlab-org/gitlab@c099ede5057c0408ea15637d037867dafe22a55d) ([merge request](gitlab-org/gitlab!154594))
- [Increase prominence of the context header](gitlab-org/gitlab@18c7c7ff364adaa64a229cf23ca878df1c2ea738) ([merge request](gitlab-org/gitlab!155461))
- [Add possibility to change allowed to merge groups](gitlab-org/gitlab@a323c4274dee287d55d8e690869ecd116a92fa22) ([merge request](gitlab-org/gitlab!154197)) **GitLab Enterprise Edition**
- [Show additional error details from CubeJS 400 responses](gitlab-org/gitlab@6454f0cdc9470af7ff6e0cfbeaa3dc9f9bcc7182) ([merge request](gitlab-org/gitlab!155814)) **GitLab Enterprise Edition**
- [chore: Remove the following gitlab embeddings rake task](gitlab-org/gitlab@d41177dbc260458be2d5b25b71519956dda93dc4) ([merge request](gitlab-org/gitlab!155803)) **GitLab Enterprise Edition**
- [Make locking message consistent](gitlab-org/gitlab@2550b70d1f8cc59565dadad190be640cbbacfd85) ([merge request](gitlab-org/gitlab!155383))
- [Update PMG architecture blueprint](gitlab-org/gitlab@4e45d4cd3a51bcba25adc2140eaf998852e42e4e) ([merge request](gitlab-org/gitlab!155780))
- [Add Google Cloud IAM integration metrics to Service Ping](gitlab-org/gitlab@f46bb861b5ee4aa9662adc04161e4c1269b0fa42) ([merge request](gitlab-org/gitlab!155134)) **GitLab Enterprise Edition**
- [Change title for bulk seat assignment/removal](gitlab-org/gitlab@fe5c3ba8579bbb9538101b4ea837adc276836118) ([merge request](gitlab-org/gitlab!155688)) **GitLab Enterprise Edition**
- [Add page counter to wiki sidebar](gitlab-org/gitlab@a19ea18ab0ae9c23c855222d392ea50b16a25966) ([merge request](gitlab-org/gitlab!155615))
- [Adds a new client that uses basic auth to fetch from prometheus](gitlab-org/gitlab@fd564d9bffe471b02fa3839c3351b4e86c945228) ([merge request](gitlab-org/gitlab!153629))
- [Migrate d-block to gl-block](gitlab-org/gitlab@b6239adc0ce50cfbd4b87b58a19c44c142c3ab2b) ([merge request](gitlab-org/gitlab!152737))
- [Fix hr color in navigation sidebar on darkmode](gitlab-org/gitlab@0ff3ef62c9886d590f821a7d4743eb56a247ca38) ([merge request](gitlab-org/gitlab!155465))
- [Overhaul OAuth page](gitlab-org/gitlab@6abdeff1a3ec4705940804045549f0a4a1322c47) ([merge request](gitlab-org/gitlab!153886))
- [Wiki history: Use card container](gitlab-org/gitlab@350b3585de66221bf6fd4e5cae4fd16a2f4ef014) ([merge request](gitlab-org/gitlab!155689))
- [Add jira client call](gitlab-org/gitlab@82670ea97171ab60ff15cff26aec489e70186789) ([merge request](gitlab-org/gitlab!150079))
- [Only show "Merge request was removed from train" for open MRs](gitlab-org/gitlab@90986d70b4f6049ab5d9e7f5614e8b7400c5a06e) ([merge request](gitlab-org/gitlab!155692)) **GitLab Enterprise Edition**
- [Wiki templates: Remove limited container](gitlab-org/gitlab@25293a4acac6c3aa7a95ac96a45ecd5294043a73) ([merge request](gitlab-org/gitlab!155687))
- [Remove FF allow_user_variables_by_minimum_role](gitlab-org/gitlab@456bf3133feeb966d0c3209339b91fde9ddedc29) ([merge request](gitlab-org/gitlab!155448))
- [Revert MR https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154228](gitlab-org/gitlab@e9b0447830dde522a94f332a286b0beb29e1caeb) ([merge request](gitlab-org/gitlab!155683))
- [Migrates gl-sm-display- classes to Tailwind](gitlab-org/gitlab@dff3b83a80b004fcac7165047d0e15383eebc2cf) ([merge request](gitlab-org/gitlab!154892))
- [Update dependency ai-gateway to v1.6.1](gitlab-org/gitlab@dd2a96c5edd5d77e24d3f5ae3ae534f33304a077) ([merge request](gitlab-org/gitlab!155674))
- [Update PreventIndexCreation rule](gitlab-org/gitlab@987b9ab3e69113786198f57b4cafde2b0fa7dd3a) ([merge request](gitlab-org/gitlab!154487))
- [Move all elastic rake tasks to service](gitlab-org/gitlab@c2eace877d07090065bc9732076b4e98a553a34c) ([merge request](gitlab-org/gitlab!154484)) **GitLab Enterprise Edition**
- [Wiki: Adds in-page editing functionality](gitlab-org/gitlab@fc8da6842d162589726b3a43330cf46b2006bd52) ([merge request](gitlab-org/gitlab!155227))
- [Update Rails to 7.0.8.4](gitlab-org/gitlab@dc80ea03aa7d321727e5eda156dab41373724352) ([merge request](gitlab-org/gitlab!155557))
- [Update pmg query](gitlab-org/gitlab@b3735652d8ab262903c32cf765cf0454e913b6ab) ([merge request](gitlab-org/gitlab!155129))
- [Refactor groups API](gitlab-org/gitlab@11badb038c972a660857d7466799333e6b3fea5f) by @imskr ([merge request](gitlab-org/gitlab!155139)) **GitLab Enterprise Edition**
- [Use sentence case for edit page, remove hr](gitlab-org/gitlab@5f9439c7b43adf19b2fde895cf3d7223db50ef87) ([merge request](gitlab-org/gitlab!155498))
- [Wiki sidebar: Change alignment of sidebar header](gitlab-org/gitlab@45d9cb1e99d93e1bfcec0eb693dfb5817e980885) ([merge request](gitlab-org/gitlab!155549))
- [Add connection mode column to cluster agents](gitlab-org/gitlab@a95cfc3eb9131ea84c3b6c09c6ab4542c45c4879) ([merge request](gitlab-org/gitlab!155540))
- [Allow retry of merge train pipeline while its running](gitlab-org/gitlab@6d92283b7ec0527ea0ef013aaf56758f10f04989) ([merge request](gitlab-org/gitlab!154916))
- [Rename doc page to secret push protection](gitlab-org/gitlab@5e1eecf805b2d82ba0eada4bc5e2cf425cb438a4) ([merge request](gitlab-org/gitlab!155331))
- [Add polling to jobs tabs on pipeline](gitlab-org/gitlab@121ed313755ce2c0216f550dd2019eff33c1f7fe) ([merge request](gitlab-org/gitlab!153906))
- [Add WorkItems reference](gitlab-org/gitlab@7bd505a61cf6bc5a853127d2ae909accd8c91089) ([merge request](gitlab-org/gitlab!151636)) **GitLab Enterprise Edition**
- [No longer require magic username for Git over HTTPS with OAuth token](gitlab-org/gitlab@0961072f1397bcb90dc884421e8e161e4926c65f) by @hickford ([merge request](gitlab-org/gitlab!152282))
- [Show collapsed directory when custom wiki sidebar exists](gitlab-org/gitlab@4f49394a21f3817fb9fa8b8d5d580572cde80658) ([merge request](gitlab-org/gitlab!154454))
- [Add hasChildrenWithinTimeframe field to epics](gitlab-org/gitlab@177c8b4fa6e0a59756c1a5b588ad47160007198d) ([merge request](gitlab-org/gitlab!151917)) **GitLab Enterprise Edition**
- [Add a param to indicate the purchase request is from GitLab.com](gitlab-org/gitlab@2ce35f49bea7e1f7ee1cb47513649930947fcb39) ([merge request](gitlab-org/gitlab!155164)) **GitLab Enterprise Edition**
- [Migrate gl-lg-display-* classes to Tailwind](gitlab-org/gitlab@4937a4a457cb690b84e7691839c7bc047fcbb7f3) ([merge request](gitlab-org/gitlab!155214))
- [Update GitLab Pages version](gitlab-org/gitlab@30c9de4d73b0714a01e00e82838238408ee3ec1c) ([merge request](gitlab-org/gitlab!155395))
- [Migrate d-flex to gl-flex](gitlab-org/gitlab@bcb0a1a56bbe672b0da23a2446cafba7782ec0d9) ([merge request](gitlab-org/gitlab!143177))
- [Update pmg architecture blueprint](gitlab-org/gitlab@5c921fe4c1ffa71f2a487af12f88441e94ed71e6) ([merge request](gitlab-org/gitlab!154953))
- [Replace `gl-white-space-normal` class](gitlab-org/gitlab@3cf91aee49e09f734cc53cfa23562e44c48ba952) ([merge request](gitlab-org/gitlab!155330))
- [Migrates gl-display-none! to !gl-hidden](gitlab-org/gitlab@d22d94e223b1ea15f2299cfc8098465e1ab1309b) ([merge request](gitlab-org/gitlab!154885)) **GitLab Enterprise Edition**
- [Update dependency auto-build-image to v4.1.0](gitlab-org/gitlab@7bbfd3e3d923c818ea950c753425bb0ab554b511) ([merge request](gitlab-org/gitlab!155302))
- [Rollout github_import_lock_user_finder feature flag](gitlab-org/gitlab@f10437d8b415fde2a30ada3988ec2c40962f8a72) ([merge request](gitlab-org/gitlab!155300))
- [Display username when advising of LFS lock](gitlab-org/gitlab@edb6b7781e0a0a930edbcb85da581e9c579d1220) ([merge request](gitlab-org/gitlab!154868))
- [Rename CI and pipeline minute to compute minute](gitlab-org/gitlab@06762051cb8b1ba128f18c971704ecaff0e3edb8) ([merge request](gitlab-org/gitlab!154751))
- [Replace "via" with "with" in email copy and event timeline](gitlab-org/gitlab@8bd87d17f1776d7549f455c743d2acd707aaea42) ([merge request](gitlab-org/gitlab!154602))
- [Bumping PAT last used timestamp will not trigger sticky writes](gitlab-org/gitlab@05b12662d43ca3275d1d526f2355228791738bbf) ([merge request](gitlab-org/gitlab!155275))
- [Rename Migration/BackgroundMigrationBaseClass rubocop rule](gitlab-org/gitlab@dae0d3dfa92a89e6c2670721c7a12b3dbb4dc078) by @zzaakiirr ([merge request](gitlab-org/gitlab!155069))
- [Make page breadcrumbs auto-adjust to available width](gitlab-org/gitlab@a442433218c18bcf9d048bb099b12a2ad383ce80) ([merge request](gitlab-org/gitlab!155053))
- [Add edit to edit page breadcrumb](gitlab-org/gitlab@88f5c0f7f3c4b739e4fce0c30c74942317949f5a) ([merge request](gitlab-org/gitlab!155132))
- [Consolidate Board scope for i18n](gitlab-org/gitlab@c76b71f9f14f5c8c8e0a6501ed08ff46be5d8df2) ([merge request](gitlab-org/gitlab!154464))
- [Update product analytics onboarding permissions](gitlab-org/gitlab@e39d0978423682334345742ac7977fa08f2fa6a6) ([merge request](gitlab-org/gitlab!154089)) **GitLab Enterprise Edition**
- [Add a banner informing about token expiration](gitlab-org/gitlab@a92f591761f4ebc1d92c505cdde7816b010b4703) ([merge request](gitlab-org/gitlab!154944))
- [This MR removed feature flag](gitlab-org/gitlab@dba976e1ce100d4d81eac766e07a611b39d04c27) ([merge request](gitlab-org/gitlab!148428)) **GitLab Enterprise Edition**
- [Wiki: Migrate content to Vue](gitlab-org/gitlab@1d66849dd4a9e9f0ff717482af8476f3cc0f5f84) ([merge request](gitlab-org/gitlab!154922))
- [Remove DORA Performers Score panel from built-in project VSD](gitlab-org/gitlab@027089c345dde71056fe56af97f39de8a89d4edf) ([merge request](gitlab-org/gitlab!154012)) **GitLab Enterprise Edition**
- [Enable filtered search on Vulnerability Report](gitlab-org/gitlab@da90a2fa23dad9f4104558fc3dca07b6e4df31ea) ([merge request](gitlab-org/gitlab!155093)) **GitLab Enterprise Edition**
- [Migrate your work pages to use new typescale](gitlab-org/gitlab@18929d3bea89a2a33717ccdd13382847cb769494) ([merge request](gitlab-org/gitlab!154360))
- [Migrates gl-md-display-* classes to Tailwind](gitlab-org/gitlab@11ae53c80dfd3cc0eab8124615bc2d76ddb926a6) ([merge request](gitlab-org/gitlab!154929))
- [Separate pipeline stages files](gitlab-org/gitlab@10009555259d495c46ba3982b5d0aaac351b282b) ([merge request](gitlab-org/gitlab!154818))
- [Tailwind: Migrate heading utility classes](gitlab-org/gitlab@80b783282e43be23f9c1cb8b886bbacaf5c6c5b2) ([merge request](gitlab-org/gitlab!154539))
- [Fix approval groups finder](gitlab-org/gitlab@7bc4ba742c775070c6e2a9b43cc9eb9b7433c131) ([merge request](gitlab-org/gitlab!154153)) **GitLab Enterprise Edition**
- [Remove Attributes column from Inherited CI/CD Variables table](gitlab-org/gitlab@5ea3bcadb2fa96b7591aa89e41ecc3fb435d8d9a) ([merge request](gitlab-org/gitlab!154084))
- [Skip timestamps in log if present when generating HTML](gitlab-org/gitlab@13a7331b43c38b36da72a89b25503b0c5ebcfdc5) ([merge request](gitlab-org/gitlab!154561))
- [Avoid overflows](gitlab-org/gitlab@894d06e88e08a203fe0378c9523b5eac8b1f640e) ([merge request](gitlab-org/gitlab!154299)) **GitLab Enterprise Edition**
- [Show toast message when merge request is removed from train](gitlab-org/gitlab@0bab2a22e8ab01d215bd3380da7532fae0cc3a4d) ([merge request](gitlab-org/gitlab!153974)) **GitLab Enterprise Edition**
- [Add Jenkins migration callout](gitlab-org/gitlab@8f442cfa2c75c0ea84ccb77b3da7154a04b57ad8) ([merge request](gitlab-org/gitlab!153344))
- [Clarifies issue list error state](gitlab-org/gitlab@6605528ec8c81f55b48decaff0d5197969f12852) ([merge request](gitlab-org/gitlab!154029))
- [Fix alignment of wiki sitemap and templates pages](gitlab-org/gitlab@d57baddbfa9261e2b00709695aae8aed0fe56c97) ([merge request](gitlab-org/gitlab!154815))
- [Rename "Limit access..." to "Grant access..."](gitlab-org/gitlab@e25e99a6c6724957dab3db284279bf14ac0ddc89) ([merge request](gitlab-org/gitlab!151704))
- [Align notes on mobile](gitlab-org/gitlab@18050f3b186cb1372f357742ec0d159ef0c21865) ([merge request](gitlab-org/gitlab!154596))
- [Replace gl-line-clamp with the Tailwind equivalent](gitlab-org/gitlab@3d6af09f952627e6cb6312926f4f9fcbb1c45cc7) ([merge request](gitlab-org/gitlab!154640))
- [Update file index.md](gitlab-org/gitlab@de74894d6f21402448c05bc25384fca2ebac6dbc) ([merge request](gitlab-org/gitlab!154890))
- [Add tracking event for Compute Minutes/Storage checkout page views](gitlab-org/gitlab@22714b27b89dd74b6827a8bbb1ac67a04644a50f) ([merge request](gitlab-org/gitlab!154711)) **GitLab Enterprise Edition**
- [Update @gitlab/web-ide and gitlab-vscode-extension](gitlab-org/gitlab@d2961ddfd862a967e7fa395f093b9bb6724776d9) ([merge request](gitlab-org/gitlab!154871))
- [Improve analytics dashboards descriptions](gitlab-org/gitlab@4187859c8a59c192c82058fe96857ee5133bda1d) ([merge request](gitlab-org/gitlab!154145)) **GitLab Enterprise Edition**
- [WorkItemAddClosingMergeRequest mutation allows URLs and full references](gitlab-org/gitlab@fb5d1fdeb989b28c490fab84a5e527c072efb759) ([merge request](gitlab-org/gitlab!154638))
- [Replace 'gl-overflow-wrap-anywhere' to Tailwind equivalent](gitlab-org/gitlab@4f0fa028655c93b1eb6764deffd165f44bea9d5a) ([merge request](gitlab-org/gitlab!154844))
- [Add iid to work item title](gitlab-org/gitlab@4e124137e215f9391b21bf47c79e9c8ed3eb6feb) ([merge request](gitlab-org/gitlab!154828))
- [Persist scan execution policies to database](gitlab-org/gitlab@26537c63d5f0806cfa849e1124404fc129364596) ([merge request](gitlab-org/gitlab!148854)) **GitLab Enterprise Edition**
- [Productize trial_disover_page experiment](gitlab-org/gitlab@e46cc41c4c962ccf2cd765b11de1352f68fdb6b1) ([merge request](gitlab-org/gitlab!153166)) **GitLab Enterprise Edition**
- [Move legacy pipeline mini graph](gitlab-org/gitlab@1265a43651275d9ee8164d6d9b17504f91c7703d) ([merge request](gitlab-org/gitlab!154625))
- [Update "Upgrade your plan to improve repositories" banner](gitlab-org/gitlab@3b1c3e696960bca0ed3a5f081973e646aa3f24fd) ([merge request](gitlab-org/gitlab!154782))
- [Reduce number of tokens sent for RCA](gitlab-org/gitlab@89ea275a8d8ed8fc85521424120df7cb33d8e75e) ([merge request](gitlab-org/gitlab!154780)) **GitLab Enterprise Edition**
- [Change issues from index to upsert for Elasticsearch](gitlab-org/gitlab@9150f417d5fca02291c3f565b6b0c847c8662df9) ([merge request](gitlab-org/gitlab!153580)) **GitLab Enterprise Edition**
- [refactor: Introduce a Vue-based UI for Pages](gitlab-org/gitlab@4f2d6608f81ea2f42518b9dbfed5be1321be2222) ([merge request](gitlab-org/gitlab!148534))
- [Pipeline graph: Improves accessibility when using keyboard](gitlab-org/gitlab@100b4af891129d58272eaa45c1e4844b289cce47) ([merge request](gitlab-org/gitlab!153949))
- [Update dependency auto-deploy-image to v2.93.0](gitlab-org/gitlab@42e1a868c0c48abd857fd00be71fa6acf3d1284f) ([merge request](gitlab-org/gitlab!154698))
- [Improve UX for 404 error for Duo Pro trial page](gitlab-org/gitlab@360de8682d8d56544ee2c6f0c30e9592c301085d) ([merge request](gitlab-org/gitlab!153403)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](gitlab-org/gitlab@fafa1284ae0f47c06f3b8d645da2e9a7c6279d2f) ([merge request](gitlab-org/gitlab!154193))
- [Consolidate iteration filters for issues](gitlab-org/gitlab@45fdc78c16bd93dadd4f895e8b44de0911e6deda) ([merge request](gitlab-org/gitlab!154222)) **GitLab Enterprise Edition**
- [Update breaking changes banner](gitlab-org/gitlab@7cd21d8c34b31208cb45be155f8067701b66fe8a) ([merge request](gitlab-org/gitlab!154347)) **GitLab Enterprise Edition**
- [Include session_cookie_token_prefix in KAS session cookie](gitlab-org/gitlab@e530511ec966d3785482b84e4374e0c765c7a2e5) ([merge request](gitlab-org/gitlab!154719))
- [Add alignment to prevent button height to grow](gitlab-org/gitlab@346c0b58858eb3f0753c41b61aa31fa88d60f0dc) ([merge request](gitlab-org/gitlab!154404))
- [Rate limit project / group notifications per user](gitlab-org/gitlab@ea40bb22bfd028d687faeaaa6cf9734777decde0) ([merge request](gitlab-org/gitlab!153786))
- [Allow redirecting wiki directories on rename](gitlab-org/gitlab@8b9d3640355e73b9ed6196aeeafb923d3cb8f3be) ([merge request](gitlab-org/gitlab!153289))
- [Add NOT NULL constraint to "path_locks.project_id"](gitlab-org/gitlab@8630330b599fcd0e15cc28680fac9b0c31c0ebea) ([merge request](gitlab-org/gitlab!153090))
- [Add metric start date tooltip to AI impact dashboard](gitlab-org/gitlab@8999b334c8612b21a553c2b14d7ef342700854f4) ([merge request](gitlab-org/gitlab!153141)) **GitLab Enterprise Edition**
- [Create parent links for imported epics](gitlab-org/gitlab@d6132daae948ef8daada9fbbb37e0d98f7337040) ([merge request](gitlab-org/gitlab!154445))
- [Migrate d-inline-block to gl-inline-block](gitlab-org/gitlab@cb06f5c91a046b7b86dda6793d4c3a6ceff3b6d7) ([merge request](gitlab-org/gitlab!152739))
- [Docs(Epic Header): add entry to describe counts](gitlab-org/gitlab@494803b1a5ba348ce7ea43c0d94960e8ca6f68f1) ([merge request](gitlab-org/gitlab!154391)) **GitLab Enterprise Edition**
- [Update page title of history page](gitlab-org/gitlab@8c4f89f139e474883661724712557dd8828129ba) ([merge request](gitlab-org/gitlab!154419))
- [Move AI Powered Features](gitlab-org/gitlab@0b712b2682d58a4fded8db4ed641e1a9d0b3cedb) by @jzeng88 ([merge request](gitlab-org/gitlab!153633))
- [Remove Kotlin and Scala from MR pipelines](gitlab-org/gitlab@0ccd369e7f5092a6e2291645817f9762e1a959ee) by @l.s.andringa1 ([merge request](gitlab-org/gitlab!154233)) **GitLab Enterprise Edition**
- [Scaffold component for visualization designer overhaul](gitlab-org/gitlab@e7af74a932bf13244ca9162ed47f590ca3eafe96) ([merge request](gitlab-org/gitlab!153638)) **GitLab Enterprise Edition**
- [Replace curl with gcloud commands in GAM integration](gitlab-org/gitlab@ea7605c5ad2abc38fc33abe3d380c39cf7f27a3a) ([merge request](gitlab-org/gitlab!153709))
- [Add enum to graphql mutation](gitlab-org/gitlab@76b21c24d33fc58ec10686433762cd7374c7b7ba) ([merge request](gitlab-org/gitlab!154261)) **GitLab Enterprise Edition**
- [Remove beta notice for import with projects](gitlab-org/gitlab@e71066a1e17c7f9a338592406f4560db39634f55) ([merge request](gitlab-org/gitlab!154228))
- [Feat(Purchase): remove key_contacts_management_v2](gitlab-org/gitlab@406b3e5b16c708915cfaa89d39486ae0f1bd44f5) ([merge request](gitlab-org/gitlab!154368)) **GitLab Enterprise Edition**
- [Value stream dashboard label filter no longer matches description](gitlab-org/gitlab@f33454f6a26202a95dd1926d164db53376bb0e80) ([merge request](gitlab-org/gitlab!152803)) **GitLab Enterprise Edition**
- [Convert GraphQL fullPath fields to ID types](gitlab-org/gitlab@b4efe173a87d318403cd96da877e3d97b2009eb4) ([merge request](gitlab-org/gitlab!152004))
- [Change removal milestone of ZenTao to 18.0](gitlab-org/gitlab@3cc9421531b3880049ba7280efeee242470467c8) ([merge request](gitlab-org/gitlab!153783))
- [Update UI of the MR approval rules banner](gitlab-org/gitlab@acfaf47daf8aabe6f27ac0968c039d24875c8f0a) ([merge request](gitlab-org/gitlab!153278)) **GitLab Enterprise Edition**
- [Remove "New list button has moved" popover](gitlab-org/gitlab@ec78155ece4b4c1cc6ee409a53684d1797003cb1) ([merge request](gitlab-org/gitlab!152981))
- [Change gl-overflow-wrap-break to gl-break-words](gitlab-org/gitlab@2f5556bc37324e680c5cf662ce8823020dbd2016) ([merge request](gitlab-org/gitlab!154461))
- [Update button and footer description on company form](gitlab-org/gitlab@329925c5a58e5676e812279d3620dc41bd834abd) ([merge request](gitlab-org/gitlab!153339)) **GitLab Enterprise Edition**
- [Help page: Fix badge alignment and migrate headline class](gitlab-org/gitlab@785c62e2e0a3222a9e1cf802c50373f873693cac) ([merge request](gitlab-org/gitlab!153817))
- [Cascade duo_features_enabled on save](gitlab-org/gitlab@4360bb7241117bdb76474592391ddf369ab3b6cf) ([merge request](gitlab-org/gitlab!145876)) **GitLab Enterprise Edition**
- [Update software license policies table](gitlab-org/gitlab@b0a1bb0b13ab4527abc638a9ddb50972d62964a9) ([merge request](gitlab-org/gitlab!152054)) **GitLab Enterprise Edition**
- [Convert GraphQL IID fields from ID to String types](gitlab-org/gitlab@d894d4d67e086d40f158113ea1c1197031edbee5) ([merge request](gitlab-org/gitlab!152002))
- [Apply one rate limit to all webhook test endpoints](gitlab-org/gitlab@c54e2e52c0969ed6198c961d5ca2f36a0261446d) ([merge request](gitlab-org/gitlab!153795))
- [Remove collapsed description field for snippets form](gitlab-org/gitlab@5a947a6ae81a357d6a5b2bbc4c479fee3564e568) ([merge request](gitlab-org/gitlab!153682))
- [Increase WorkItem max children](gitlab-org/gitlab@a3bfb61c0d7075d98e53ffd99fe88e075d0b1b95) ([merge request](gitlab-org/gitlab!154308))
- [Add allowed to merge drawer](gitlab-org/gitlab@a729730c105e1b79f11f1e12049f26a22c5167c1) ([merge request](gitlab-org/gitlab!153813))
- [Diff: use own  class for setting max-width](gitlab-org/gitlab@a49cab2bc50dc59e7a0a5e9f0e85166dba0e8119) ([merge request](gitlab-org/gitlab!154273))
- [Remove font weight 100 and 300](gitlab-org/gitlab@f5be4f7782f5b023842c27e2118c09051944d970) ([merge request](gitlab-org/gitlab!154257)) **GitLab Enterprise Edition**
- [Fix for broadcast messages not staying dismissed](gitlab-org/gitlab@6b0071a821635a1fe17b7f4bd7f2969c11dc5dae) by @robyrne ([merge request](gitlab-org/gitlab!151056))
- [Early access program tracking by namespace settings](gitlab-org/gitlab@13566d95bd075492cf008869a4def8fe5b9eec39) ([merge request](gitlab-org/gitlab!153170))
- [Change 'warning' banner to 'info' on the Terraform state page](gitlab-org/gitlab@a5d135d2b4e89ae7ac0eec13b4565bac01331ea6) by @antonkalmykov ([merge request](gitlab-org/gitlab!154177))
- [Migrate d-none to gl-hidden](gitlab-org/gitlab@65bf4636700bab3f14d71e6471e8f5a1515c6e8c) ([merge request](gitlab-org/gitlab!152735))
- [Moved MememberManagement namespaced files to GitlabSubscriptions](gitlab-org/gitlab@b5f3b618d3d3414f93fe87435cdcdb8be235fb02) ([merge request](gitlab-org/gitlab!153823)) **GitLab Enterprise Edition**
- [Update ruby-lsp to v0.16.7 and prism to v0.29.0](gitlab-org/gitlab@3ac076d8f8ebba057402dce30b1ccf02119e2d15) ([merge request](gitlab-org/gitlab!154156))
- [Use Duo icon and label in editor](gitlab-org/gitlab@6e88083cb2855f54f896bef059d9a7131a52caef) ([merge request](gitlab-org/gitlab!153321)) **GitLab Enterprise Edition**
- [Wiki create/edit form cleanup](gitlab-org/gitlab@20012b0b4f19bc9906b751a0cb9b26c520c41391) ([merge request](gitlab-org/gitlab!154087))
- [Remove "Already signed in with SAML"](gitlab-org/gitlab@325dc708209e479cd34913c62810c33b37e5f609) ([merge request](gitlab-org/gitlab!152383)) **GitLab Enterprise Edition**
- [Update in-progress product analytics onboarding state](gitlab-org/gitlab@242d32fa8d68efb7f6ce6b3954b1d7e0eb686295) ([merge request](gitlab-org/gitlab!153200)) **GitLab Enterprise Edition**
- [Cleanup FF saas_user_caps](gitlab-org/gitlab@0e0311ed402f7c67820ce78d8468e8bd55ad6d74) ([merge request](gitlab-org/gitlab!153812)) **GitLab Enterprise Edition**
- [Pages: Update UI](gitlab-org/gitlab@756ee6796e49046d7b25ae7bdf2b49f57b623a3c) ([merge request](gitlab-org/gitlab!153250))
- [Drop default value for p_ci_builds.auto_canceled_by_partition_id](gitlab-org/gitlab@274f12a9dbacdc45f47be17c39c331b4e844c335) ([merge request](gitlab-org/gitlab!153557))
- [Link to deployment details page for waiting-for-approval jobs](gitlab-org/gitlab@9380d8dc8bd24976cef51c1dcf8b3b8d61001854) ([merge request](gitlab-org/gitlab!152951)) **GitLab Enterprise Edition**
- [Allow instance adminstrators to link work items](gitlab-org/gitlab@639d3f8bbf63633c65f6a2aa0a212160a5307b7f) ([merge request](gitlab-org/gitlab!153679))
- [Regenerate OpenAPI documentation of REST API](gitlab-org/gitlab@34f987354ebc4e00b8037b85b74564501fb42a9e) ([merge request](gitlab-org/gitlab!154043))
- [Move board delete to board configuration modal](gitlab-org/gitlab@83805842942d9d0cd3eadcc3fee85ca0e52b7188) ([merge request](gitlab-org/gitlab!153491))
- [Align wording between group and project restore confirmation](gitlab-org/gitlab@a9eab33b0fe357124f07d99e2f3b700151749232) by @antonkalmykov ([merge request](gitlab-org/gitlab!152895)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.91.0](gitlab-org/gitlab@846f87e12d17504cb06656ea76c28bfa7d4d359c) ([merge request](gitlab-org/gitlab!154009))
- [Remove beta status from AI impact analytics dashboard](gitlab-org/gitlab@32a081ece5f67d93cbe7d32cd26c4ca81f140189) ([merge request](gitlab-org/gitlab!153729)) **GitLab Enterprise Edition**
- [Wiki: Clone repository changes](gitlab-org/gitlab@9ca0659583a43bda4a97f65d6f2102733190a283) ([merge request](gitlab-org/gitlab!153814))
- [Drop redudnant vuln_reads indices, improve unnested_in_filters](gitlab-org/gitlab@686cb8b161acefb09085f414f6b90daab44ae3ea) ([merge request](gitlab-org/gitlab!150657))
- [Remove invalid remote mirror records without "project_id"](gitlab-org/gitlab@d7fe734f16c465ac96c4a31226ebafa456dd0f89) ([merge request](gitlab-org/gitlab!146640))
- [Add epics.issue_id NOT NULL constraint](gitlab-org/gitlab@e652c9809e927edea6e68658f4783303c03832d9) ([merge request](gitlab-org/gitlab!151791)) **GitLab Enterprise Edition**
- [Add allowedParentTypes to Hierarchy widget](gitlab-org/gitlab@329d33ed35f9afe6bb4b17092c2c06ba5fc212b2) ([merge request](gitlab-org/gitlab!153079))
- [Update visualization designer to preview code in YAML](gitlab-org/gitlab@489bddfca2b69cf4e6e64b171e5a0e776ae30146) ([merge request](gitlab-org/gitlab!153275)) **GitLab Enterprise Edition**
- [Add routing field to issues index](gitlab-org/gitlab@34de4d9a84338f8dd96f1a1a9689a9d663dc3622) ([merge request](gitlab-org/gitlab!153394)) **GitLab Enterprise Edition**
- [Enable use of #deduplicated_size for self-managed](gitlab-org/gitlab@abf81bfd722928b75a5d1927ae82a645e0fd1cb0) ([merge request](gitlab-org/gitlab!152762))
- [Add feedback mechanism for AI cube query generation](gitlab-org/gitlab@9d9c13e77815c410fb0af5b00627907e47e73955) ([merge request](gitlab-org/gitlab!148354)) **GitLab Enterprise Edition**
- [Update error message and layout](gitlab-org/gitlab@b01200b8380702cef1270cb2b55c5eb7aece4695) ([merge request](gitlab-org/gitlab!153683))
- [Remove Scala and Kotlin from Spotbugs job in Static Analysis CI template](gitlab-org/gitlab@b9950c91c1da2df3aef1c5a19a633c6f293f783b) ([merge request](gitlab-org/gitlab!152876)) **GitLab Enterprise Edition**
- [Downcase invite emails as the service layer](gitlab-org/gitlab@1eb627416c0f99179c2dca9645a0ee7171a9163e) ([merge request](gitlab-org/gitlab!151796))
- [Use sentence case for edit snippet title](gitlab-org/gitlab@c148601d8df353472c4d88aab4a3b1582563de74) ([merge request](gitlab-org/gitlab!153909))
- [Remove FF mark_cvs_vulnerabilities_as_resolved](gitlab-org/gitlab@1f8dde0d52c0231d31f2254691aa85ab223c818a) ([merge request](gitlab-org/gitlab!153908)) **GitLab Enterprise Edition**
- [Update neighbor gem to 0.3.2](gitlab-org/gitlab@740ce014f73de7d70b324801e4e673c293121941) ([merge request](gitlab-org/gitlab!152672))
- [Updating ci_pipeline_schedule_variables with sharding key](gitlab-org/gitlab@04008d18d24fb732f0396f1b6df547ad26566acd) ([merge request](gitlab-org/gitlab!153897))
- [Make GITLAB_LOG_LEVEL affect more logs](gitlab-org/gitlab@7069c2f62c0d74ba059676de5dac9d975417286d) ([merge request](gitlab-org/gitlab!152467))
- [Update edit wiki page and template titles](gitlab-org/gitlab@2ba358ef7ba32499985e24ccb6f96fd165e69b28) ([merge request](gitlab-org/gitlab!153893))
- [Move wiki edited by text below title](gitlab-org/gitlab@bd1c09cfc9e4fe0042b8ba2b15f80ed581cd34be) ([merge request](gitlab-org/gitlab!153600))
- [Add ci_integration_jenkins model function](gitlab-org/gitlab@15be20460520a9eed1e5ec6e479493422acf6b67) ([merge request](gitlab-org/gitlab!153028))
- [Remove unused indices on sbom_occurrences](gitlab-org/gitlab@d2feeab0075873911fb08d5deecde2444ad9b819) ([merge request](gitlab-org/gitlab!153889))
- [Update GitLab Pages version](gitlab-org/gitlab@4503399dac6e0ad7290391b52b58c1716ec1dcb7) ([merge request](gitlab-org/gitlab!153885))
- [Update wiki sidebar](gitlab-org/gitlab@d05564a231ce7c4a84ce79dd9566a1812daa1c36) ([merge request](gitlab-org/gitlab!153178))
- [Add frontend URL validation for uploading metrics images (edit modal)](gitlab-org/gitlab@fd59de0a51d3a45cef7a0dad0463d7170b81224e) by @antonkalmykov ([merge request](gitlab-org/gitlab!151766))
- [Add allowed to merge drawer](gitlab-org/gitlab@d605239eb02e7a194c36b3f4a730a4dcd93cd472) ([merge request](gitlab-org/gitlab!152636))
- [Feat(Epic Header and Board): Align presentation](gitlab-org/gitlab@72737ab6fbccdf7ee817287144a8f0bc2242a458) ([merge request](gitlab-org/gitlab!152780)) **GitLab Enterprise Edition**
- [Using self-hosted llm models name as differentiator](gitlab-org/gitlab@a9e64f25ced17d64ee57f2aa4eab93fbd96dc4bd) ([merge request](gitlab-org/gitlab!153835)) **GitLab Enterprise Edition**
- [Ignore additional registry migration fields](gitlab-org/gitlab@cda67881762f6993e9690f06ae3ecaa13a421687) ([merge request](gitlab-org/gitlab!153518))
- [Wiki: Update docs](gitlab-org/gitlab@843663edb2bda8799612f66a083311a2da2e6fba) ([merge request](gitlab-org/gitlab!153822))
- [Only query the fields needed](gitlab-org/gitlab@50df21fc9b941feb905646a75363145bdd1d1313) ([merge request](gitlab-org/gitlab!153769))
- [Wiki: Move template link to kebab menu](gitlab-org/gitlab@0f5e57538e350b15b0e21d75f582472b1b38606d) ([merge request](gitlab-org/gitlab!153428))
- [Remove permission check skipping](gitlab-org/gitlab@76da3546db3fe3e1d3d1a51d2a945021d02a9a52) ([merge request](gitlab-org/gitlab!136218)) **GitLab Enterprise Edition**
- [Improve Analytics dashboards schema errors](gitlab-org/gitlab@cbdc05a2cfbbc63e895b5abea88e6ce8a870cc94) ([merge request](gitlab-org/gitlab!153152)) **GitLab Enterprise Edition**
- [Add aria label to labels search](gitlab-org/gitlab@92bbdc40a554b94ca44ca7ec0d156a41baeba0a0) ([merge request](gitlab-org/gitlab!153788))
- [Update redis-client to v0.22.2](gitlab-org/gitlab@bdf97a73accaa6b24e48101f7738d2fb5ac4511e) ([merge request](gitlab-org/gitlab!153787))
- [Do not perform git housekeeping when repository does not exist](gitlab-org/gitlab@27ca9c8da399c96d277d5f06a92f9aa2e4b3b266) ([merge request](gitlab-org/gitlab!153475)) **GitLab Enterprise Edition**
- [Update wiki templates layout](gitlab-org/gitlab@f7bed54007ba2a0d90b1f22519721a75e52abd4f) ([merge request](gitlab-org/gitlab!153337))
- [Show edit pending comment button on mobile](gitlab-org/gitlab@e52a146ba1bf75a6eaa813d325574fdba6fdd763) ([merge request](gitlab-org/gitlab!153480))
- [Excludes pre-release versions from `latest` and shorthand](gitlab-org/gitlab@776bcac5d87ce10e222d11b8672e005c77cd0e0a) ([merge request](gitlab-org/gitlab!152771))
- [Change included text for GitLab Duo generated commit message](gitlab-org/gitlab@3230eeb1ede42a238fe81d8d7a7e32cc1ebe4306) ([merge request](gitlab-org/gitlab!153680))
- [Remove enter key listener on states table actions form](gitlab-org/gitlab@3ee90fda7d10c24850ed32115627bf7857cc3ebf) by @archish27 ([merge request](gitlab-org/gitlab!151029))
- [Remove duplicated indexes in post migration](gitlab-org/gitlab@07c5ce572540822bdb150b24830ef1358ab7b2fe) ([merge request](gitlab-org/gitlab!153168))
- [Make media and list items draggable](gitlab-org/gitlab@3a833b37cd6e8664b5415624fb8e98d9e2322704) ([merge request](gitlab-org/gitlab!152664))
- [Hide RCA button on the job logs page](gitlab-org/gitlab@57e1cf9954cfca679631481429ba0448116e28df) ([merge request](gitlab-org/gitlab!153504))
- [Change edit board to "Configure board"](gitlab-org/gitlab@c1dcfd5a9d4694040fd50fd7523b28be632cafda) ([merge request](gitlab-org/gitlab!153296))
- [Remove duo chat ga flag](gitlab-org/gitlab@050defdb7d6497fa8026a70e4a7777a7dc72bccf) ([merge request](gitlab-org/gitlab!151395)) **GitLab Enterprise Edition**
- [Wiki page: Add delete option to kebab menu](gitlab-org/gitlab@9809fb80a0f21c6a2a38ee0e2173c1705e964d1b) ([merge request](gitlab-org/gitlab!153268))
- [Updated error text for incorrect branch name when creating](gitlab-org/gitlab@54d7ffd0b2efe81b29752cb27142b4550a101520) by @catinbag ([merge request](gitlab-org/gitlab!152122))
- [Handle product analytics urls endding with slash](gitlab-org/gitlab@ec312e0c3ad9a94061d76314532f7c85386ee0a4) ([merge request](gitlab-org/gitlab!153137)) **GitLab Enterprise Edition**
- [Add Search reference](gitlab-org/gitlab@66a6ae61dde6c942cfbaf8f230cbc177c8fc3fd2) ([merge request](gitlab-org/gitlab!150619)) **GitLab Enterprise Edition**
- [Add query builder format class](gitlab-org/gitlab@5896c53ef29a640ba9790e209f53a4692d7ee9ed) ([merge request](gitlab-org/gitlab!153406)) **GitLab Enterprise Edition**
- [Update product analytics onboarding flow settings clearing](gitlab-org/gitlab@f5e4108aa05ee468471aa5ce1cc409156f6c4ff0) ([merge request](gitlab-org/gitlab!152887)) **GitLab Enterprise Edition**
- [Updated the Upgrade GitLab Runner link](gitlab-org/gitlab@cf7c308266e21ec9fcef3912bd5268d609255f77) by @catinbag ([merge request](gitlab-org/gitlab!153527))
- [Remove epic work item sync feature flags](gitlab-org/gitlab@4ee9808791a1c3d6c9e6fac027af4bed75f834c2) ([merge request](gitlab-org/gitlab!152627)) **GitLab Enterprise Edition**
- [Create wikis without content](gitlab-org/gitlab@687dfb33fad16ed3927c6d1995d9e10f5e31919b) ([merge request](gitlab-org/gitlab!153331))
- [Replace approval selectors with User/Group selectors](gitlab-org/gitlab@aea17a97bc29e1c68a816f766dc324a151045adb) ([merge request](gitlab-org/gitlab!148667)) **GitLab Enterprise Edition**
- [Add new page button to wiki sitemap](gitlab-org/gitlab@7e878f395ded84c55dee5a4046ee1cc775283e7d) ([merge request](gitlab-org/gitlab!153329))
- [Wiki edit page: Move delete button to action row](gitlab-org/gitlab@346440f4064d78d458b4fe9ea47e4f5e4b359f0c) ([merge request](gitlab-org/gitlab!153262))
- [AI Generate commit message: Change text of button](gitlab-org/gitlab@5caf9854abdbaab155e7e840636e7e3c78093dfc) ([merge request](gitlab-org/gitlab!153276))
- [Remove static webhook feature flags](gitlab-org/gitlab@9956aa5963da4edf874e3d3b17847ac11e414fd0) ([merge request](gitlab-org/gitlab!153355))
- [Export private emails in seat usage quota export](gitlab-org/gitlab@a1ab6581729ea35ad429af328ed25c6785f00483) ([merge request](gitlab-org/gitlab!153325)) **GitLab Enterprise Edition**
- [Update ES sizing for single node clusters](gitlab-org/gitlab@f593de26520823e2ddf66bdcd9e7e120fb97ddfa) ([merge request](gitlab-org/gitlab!152871)) **GitLab Enterprise Edition**
- [Display custom role title in invitation emails](gitlab-org/gitlab@05bf47f96a22ecc0121d4a5a10f665b71f16c2e1) ([merge request](gitlab-org/gitlab!152266))
- [Add imported badge to design notes](gitlab-org/gitlab@f8a9bf9fc037c818a45a80f3bb96f383728aa844) ([merge request](gitlab-org/gitlab!153081))
- [Move board optons into dropdown and change config button](gitlab-org/gitlab@d856a839386f3114737ce6a61fc766aa15175a72) ([merge request](gitlab-org/gitlab!149773))
- [Change logic for beyond identity GPG keys alert message](gitlab-org/gitlab@68ffb7a4ac3c95cd1707179fb2c2bff3dd16d48a) ([merge request](gitlab-org/gitlab!152798))
- [Only return ID from Elasticsearch response](gitlab-org/gitlab@34ceaf2de8127d40eef96612470499581cec0f2f) ([merge request](gitlab-org/gitlab!152905)) **GitLab Enterprise Edition**
- [Move update trigger to pop up modal](gitlab-org/gitlab@eb028d5662d328d9019a362cc919044bc54e3e96) by @missy-davies ([merge request](gitlab-org/gitlab!139761))
- [Use confirm variant for new wiki template](gitlab-org/gitlab@d632d2d82f0d7d662972f5c2b3d23f8a821a0abd) ([merge request](gitlab-org/gitlab!153023))
- [Used gitlab ui utilities in feature flag form](gitlab-org/gitlab@3f20499bde568308669a398588893babd9f9959c) by @catinbag ([merge request](gitlab-org/gitlab!150889))
- [Add link to the project in the self-managed provider card](gitlab-org/gitlab@c37a10a91b5e6d2679b8b407090cf0beff7bb4eb) ([merge request](gitlab-org/gitlab!153113)) **GitLab Enterprise Edition**
- [Externalize interpret_service_spec](gitlab-org/gitlab@cbadf743ace89500f95d65e8064b2307a8409096) by @jzeng88 ([merge request](gitlab-org/gitlab!152142))
- [Disable Rails console's IRB's autocompletion by default](gitlab-org/gitlab@2871c67a367003e65f28b427bb095163f876301d) ([merge request](gitlab-org/gitlab!152997))
- [Add indicator when Cube query is loading slow](gitlab-org/gitlab@7563432d2fb0560c20accb7aa2c4950667149d2c) ([merge request](gitlab-org/gitlab!152448)) **GitLab Enterprise Edition**
- [Release compliance frameworks report csv feature](gitlab-org/gitlab@3a4c92068637429fc992e35db875b1e56c93e756) ([merge request](gitlab-org/gitlab!152644)) **GitLab Enterprise Edition**
- [Make edited text always gray](gitlab-org/gitlab@2a1083fa7419d86ee8fa6443e12f2c4b76f1a4ff) ([merge request](gitlab-org/gitlab!152806))
- [Update styling of framework report drawer](gitlab-org/gitlab@e9d64a03ac6d4360a5a03bf66179acdea7112a66) ([merge request](gitlab-org/gitlab!152297)) **GitLab Enterprise Edition**
- [Clean up duo_chat_ga_alert flag and feature](gitlab-org/gitlab@1377986666a081d3c8acd59e68aa2cbc99ebe1e2) ([merge request](gitlab-org/gitlab!152999)) **GitLab Enterprise Edition**
- [Remove saml_reload feature flag](gitlab-org/gitlab@9af615998ce82b4f4d51583c693104868cda4059) ([merge request](gitlab-org/gitlab!152944))
- [Clean up duo_pro_trial_alert feature flag](gitlab-org/gitlab@22743902a07bceb448dd74ff9a386ee4e89c12cb) by @robyrne ([merge request](gitlab-org/gitlab!152619)) **GitLab Enterprise Edition**
- [Updates GitLab Pages version](gitlab-org/gitlab@5e1325edb1c0686244d539941dca2bf2a76596ca) ([merge request](gitlab-org/gitlab!152890))
- [Swap columns trigger_request_id and erased_by_id for p_ci_builds](gitlab-org/gitlab@77e6025a048b7ed623d774df64d4204a92c634a7) ([merge request](gitlab-org/gitlab!152766))
- [Implement a web hook create service](gitlab-org/gitlab@87b1490239a90edb8af719ab908b8634a4b3117e) ([merge request](gitlab-org/gitlab!151841)) **GitLab Enterprise Edition**
- [Improve CI/CD lead time analytics rendering of small values](gitlab-org/gitlab@a144e3c8166853bfa3851d732bfa638ed189b4ce) ([merge request](gitlab-org/gitlab!151723)) **GitLab Enterprise Edition**
- [Minor UX updates to explore projects](gitlab-org/gitlab@ec1e467b071c4331a163cc4999e4d05f107ee83d) ([merge request](gitlab-org/gitlab!152822))
- [Restrict accesss requests when group has reached member limit](gitlab-org/gitlab@745662e4ab98decaaaae14fab9f7b5a9245b0bec) ([merge request](gitlab-org/gitlab!151802)) **GitLab Enterprise Edition**
- [Migrate d-inline to gl-inline](gitlab-org/gitlab@4fa50c491e80c77927e38cba13c83fbdc3787943) ([merge request](gitlab-org/gitlab!152740))
- [Remove log_execution_time_path_traversal_middleware feature flag](gitlab-org/gitlab@cd2fe0b7a2e4a79fb1bb2fe04bd43b4139e47ded) ([merge request](gitlab-org/gitlab!152784))
- [Remove rate_limit_oauth_api feature flag](gitlab-org/gitlab@e93be64dd79a8c9127c9903e16453d86a671a513) ([merge request](gitlab-org/gitlab!152772))
- [Migrates d-inline-flex go gl-inline-flex](gitlab-org/gitlab@32d3ffa9d6c092f0849d2de05ac3aeae0ba8d9cd) ([merge request](gitlab-org/gitlab!152738))
- [Remove `use_database_for_dependency_export` feature flag](gitlab-org/gitlab@b38f970aabcefc721406c7547f8b287926478c19) ([merge request](gitlab-org/gitlab!152652)) **GitLab Enterprise Edition**
- [Default group_multi_select_tokens feature flag to true](gitlab-org/gitlab@8669859635a2688e2e42c6eab5e9518891a0ba12) ([merge request](gitlab-org/gitlab!151637))
- [Change gl-word-break-word to gl-break-anywhere](gitlab-org/gitlab@90c9720d8afdd0eb1265a7c0fc826dd62321de29) ([merge request](gitlab-org/gitlab!152531))
- [Append a percentage symbol to the end of work item progress](gitlab-org/gitlab@ab4b7cbb0aa69ff6718239fef0c341bf45d16444) ([merge request](gitlab-org/gitlab!152501)) **GitLab Enterprise Edition**
- [Simplify text of Google Cloud runner registration](gitlab-org/gitlab@85a488dd5df5bfd28f72fb757933cf5d30d2e1c5) ([merge request](gitlab-org/gitlab!151763))

### Removed (29 changes)

- [Remove `confidence` parameter from `vulnerability_findings` API](gitlab-org/gitlab@8edfb042395bd758abf1e71d36f25d34c0fdbf39) ([merge request](gitlab-org/gitlab!156283)) **GitLab Enterprise Edition**
- [Remove deprecated ci_runners columns](gitlab-org/gitlab@322a7d9f62d72af7fec1a53d52d8cad4ac52fd09) ([merge request](gitlab-org/gitlab!155786))
- [Revert MR button in forked project issues](gitlab-org/gitlab@9d009a70e8326a67ca2bf1bb3fdfd675771e761a) ([merge request](gitlab-org/gitlab!155994))
- [Remove combined_analytics_dashboards feature flag](gitlab-org/gitlab@4eebdaa710c3249d752b1c7b4a0d66292908d291) ([merge request](gitlab-org/gitlab!155263)) **GitLab Enterprise Edition**
- [Remove code_suggestion_events_in_click_house FF](gitlab-org/gitlab@7c694f95951d596e1755850966a49db66cb460b4) ([merge request](gitlab-org/gitlab!155670)) **GitLab Enterprise Edition**
- [Removes the cascade_duo_features_enabled_setting feature flag](gitlab-org/gitlab@890f8472fe30906c0b055777aef806514d125f06) ([merge request](gitlab-org/gitlab!155664))
- [Remove BBM job classes up to 16.3](gitlab-org/gitlab@842d4283df74747a365ecef2d3afc807b97fa49f) ([merge request](gitlab-org/gitlab!154302))
- [Remove temporary duo pro settings banners](gitlab-org/gitlab@48e736ec9ea253f1408c7423caf972a710f74b34) ([merge request](gitlab-org/gitlab!153818))
- [Cleanup product_analytics_admin_settings flag](gitlab-org/gitlab@06cf268614e0f29a1496360484337510054f440b) ([merge request](gitlab-org/gitlab!155073))
- [Remove unused Geo::RepositoriesChangedEvent](gitlab-org/gitlab@08c855bc8e4dcb17123f52c651de407a5f97ad8d) ([merge request](gitlab-org/gitlab!154611)) **GitLab Enterprise Edition**
- [Remove ai_tracking_data_gathering feature flag](gitlab-org/gitlab@1120d2540c8b789b2864abb5574f93d27d7ae51e) ([merge request](gitlab-org/gitlab!155101)) **GitLab Enterprise Edition**
- [Cleanup product_analytics_beta_optin flag](gitlab-org/gitlab@2e6a866eceb9122b4affb6ead75170e5b25aefaf) ([merge request](gitlab-org/gitlab!155058))
- [Removes temporary index on project_statistics](gitlab-org/gitlab@75d5df80b6f64e5c8a38a3401d45a200ae4234a0) ([merge request](gitlab-org/gitlab!154410))
- [Remove migration columns in container repository](gitlab-org/gitlab@d25a63d2b13bd76f170479ca236efb96696e5f40) ([merge request](gitlab-org/gitlab!154769))
- [Removed product analytics dashboard feature flag](gitlab-org/gitlab@130337910dfda25e00ba4eff87f95b4beb984577) by @archish27 ([merge request](gitlab-org/gitlab!150489))
- [Remove backfill_workspace_personal_access_token_spec](gitlab-org/gitlab@f0ef3aebb6bb982ce79a2d956908ba547c1f36dc) ([merge request](gitlab-org/gitlab!154488))
- [Remove migration-related columns from settings](gitlab-org/gitlab@8d5b31f619e2a2244b5a3a363af6d5fa7bd771a9) ([merge request](gitlab-org/gitlab!153521))
- [Remove gitops Deprecation Alert](gitlab-org/gitlab@e9e382d8d735be8d29431af9d267d89865a77808) ([merge request](gitlab-org/gitlab!154013))
- [Remove AI experimentation endpoints](gitlab-org/gitlab@af2a1d8b53791d3e27f77e0696540107c025fc11) ([merge request](gitlab-org/gitlab!153612)) **GitLab Enterprise Edition**
- [Remove ignore columns rule for legacy event-related tables](gitlab-org/gitlab@56cf9c16ca5c6a52c4ad9c13642e65c2cb4ecc27) ([merge request](gitlab-org/gitlab!153615)) **GitLab Enterprise Edition**
- [Remove use_or_default_operator feature flag](gitlab-org/gitlab@084a259bab8be691eccec6bcb878e4a682be5eed) ([merge request](gitlab-org/gitlab!152486)) **GitLab Enterprise Edition**
- [Renamed relatedMergeRequests field on WorkItem Development widget](gitlab-org/gitlab@b3e14f4b742078788f472f160a38a4cb62468fbe) ([merge request](gitlab-org/gitlab!152542))
- [Remove unused code](gitlab-org/gitlab@f69bf91b4fdabc22e0db7ce607eb883bf90ee374) ([merge request](gitlab-org/gitlab!153473)) **GitLab Enterprise Edition**
- [Remove browse template button from the pipeline editor](gitlab-org/gitlab@e22d145dcb8340d8b24f31d093e55cced421ad06) by @yonghyun.jin13 ([merge request](gitlab-org/gitlab!142991))
- [Remove all code related to clusters/integrations](gitlab-org/gitlab@20120000eb02a790dcef9ea4708650a120e341a3) ([merge request](gitlab-org/gitlab!153086))
- [Remove the BuildSuccessWorker](gitlab-org/gitlab@50cd4644423470f06c8e01a935be51f9500b76f9) ([merge request](gitlab-org/gitlab!153083))
- [Remove approval_rules_drawer feature flag](gitlab-org/gitlab@ec2e99fbe5a942f079cae450cad12ed23497980f) ([merge request](gitlab-org/gitlab!149661))
- [Remove integer column and trigger function for ci_pipelines](gitlab-org/gitlab@9cbef519eb39cbec6c5dafbf90e7b6d1fddfd05a) ([merge request](gitlab-org/gitlab!152722))
- [Remove use_faster_code_owner_file_exist_check feature flag](gitlab-org/gitlab@4fc2d8eea64b346521e3bfe38285b69cff20ff35) ([merge request](gitlab-org/gitlab!152731)) **GitLab Enterprise Edition**

### Security (21 changes)

- [Verify Asana access token when testing Asana integration](gitlab-org/gitlab@97f67a7ecd39e1e7c6cbfefb652ae3e170b7b114)
- [Bump KAS version](gitlab-org/gitlab@005f811755b463936ca413ee8fd1b5b6e78ab598)
- [Improve go_package_regex to prevent ReDoS attacks](gitlab-org/gitlab@f3f4a536983f296c1c5bf2e63a4a69d6818578be)
- [XSS and content injection raw XHTML files on IOS devices](gitlab-org/gitlab@836d5100c658387f88f7cb0bcde23df38abef18c)
- [Fix ReDoS in CI Interpolation](gitlab-org/gitlab@03f36b94893d239a45525ba8f49255864fea0e2e)
- [Set IP address in sidekiq](gitlab-org/gitlab@f7913b6b6bc418a9c0f331c21878b563f30d8088) ([merge request](gitlab-org/gitlab!155817))
- [Prevent PDF.js from evaluating scripts](gitlab-org/gitlab@e2a29735486247da0cf674fa5c33be2a4d7e0c63) ([merge request](gitlab-org/gitlab!153841))
- [Add text limit to ci_runners text fields](gitlab-org/gitlab@688ca12a6d37329f70f3862f5cb4a7ac75c4fafa) ([merge request](gitlab-org/gitlab!153841))
- [Caching test_report api response to reduce calculations](gitlab-org/gitlab@bee5a8f73787f66a7681f3ceff69ac5f2608ce4f) ([merge request](gitlab-org/gitlab!153841))
- [Fail create commit status on pipeline_id / sha mismatch](gitlab-org/gitlab@ff4bb525a3b8714f9559559d067665630ec5b391) ([merge request](gitlab-org/gitlab!153841))
- [Restrict access to Secure artifacts to developer role](gitlab-org/gitlab@3f0ac72f4ee6fb8acd40557a8c2f1ca03900a6d8) ([merge request](gitlab-org/gitlab!153841))
- [Use UntrustedRegexp for gollum pattern](gitlab-org/gitlab@e15d1f7f40666b4d325f7141d3b351ef53e874aa) ([merge request](gitlab-org/gitlab!153841))
- [Patch @gitlab/web-ide to fix XSS webWorkerExtensionHostIframe.html](gitlab-org/gitlab@548889e43f739406c7e881c9b03c68a71a4eac79) ([merge request](gitlab-org/gitlab!153841))
- [Prevent PDF.js from evaluating scripts](gitlab-org/gitlab@6ba8424255a173353c07bbfd532e0b5ef15147ae) ([merge request](gitlab-org/gitlab!153995))
- [Add text limit to ci_runners text fields](gitlab-org/gitlab@189b90e8092c25c1b34c6df27460825e4b907f0f) ([merge request](gitlab-org/gitlab!153995))
- [Caching test_report api response to reduce calculations](gitlab-org/gitlab@3acb41e920fe8650fe7d9dbbddf1e61ab7563584) ([merge request](gitlab-org/gitlab!153995))
- [Fail create commit status on pipeline_id / sha mismatch](gitlab-org/gitlab@0f5330ecc5d278cf78d6ba9ed6ec4fb60299faf1) ([merge request](gitlab-org/gitlab!153995))
- [Update KAS version](gitlab-org/gitlab@00007063a47255e787ff8b1bd7823d324b7e6e05) ([merge request](gitlab-org/gitlab!153995))
- [Restrict access to Secure artifacts to developer role](gitlab-org/gitlab@6ba8d8a40db735f992d2fa66b41484dcc6166afa) ([merge request](gitlab-org/gitlab!153995))
- [Use UntrustedRegexp for gollum pattern](gitlab-org/gitlab@8e083639d385db5ccce615d676d4ce55132d74a1) ([merge request](gitlab-org/gitlab!153995))
- [Patch @gitlab/web-ide to fix XSS webWorkerExtensionHostIframe.html](gitlab-org/gitlab@1711a788083988e5e6b85767d2578e46d426b2e3) ([merge request](gitlab-org/gitlab!153995))

### Performance (10 changes)

- [Add index to package files on package_id, status and file extension](gitlab-org/gitlab@fa4bc43aa0e925f2d4a2d4c16949b0a8052f09af) ([merge request](gitlab-org/gitlab!153993))
- [Improves groups controller specs](gitlab-org/gitlab@2e69288741251bdc64b4d852b996ad93905de398) ([merge request](gitlab-org/gitlab!154541))
- [Memoize common rules:changes evaluations in pipeline creation](gitlab-org/gitlab@c02e500f3b2f7440d958c1c8006e24e3e167e392) ([merge request](gitlab-org/gitlab!154455))
- [Enable and remove ci_rules_exists_pattern_matches_cache](gitlab-org/gitlab@3a5dd890561b18b6cd7c4c9ddc93cecf833a7463) ([merge request](gitlab-org/gitlab!154377))
- [Fix N+1 problem in the pipeline bridges API endpoint](gitlab-org/gitlab@d216390dbb3ce093e4e0b0635d5bedbecca9e1c3) ([merge request](gitlab-org/gitlab!154354))
- [Skip groups query in @ autocomplete if not needed](gitlab-org/gitlab@f607997a208875757528bf8fe70c4d39ea1e2250) ([merge request](gitlab-org/gitlab!153919))
- [Delay devise login lock settings](gitlab-org/gitlab@a38c6c8d2a09b8b20a10f8c810d7a5560610d7d9) ([merge request](gitlab-org/gitlab!152923))
- [Optimize todos query when filtering by group](gitlab-org/gitlab@7394a7319fe9d42a3d016d9f4b66ce242cfe5ff8) ([merge request](gitlab-org/gitlab!153226))
- [Add index to package files on file_name and file_sha256](gitlab-org/gitlab@e2181e19648fad3804b0a0eb14520ad6264a6813) ([merge request](gitlab-org/gitlab!152930))
- [Analyze partitioned tables every 3 days](gitlab-org/gitlab@2e68137d27eb6f2137e8c44832c7b07ef732e206) ([merge request](gitlab-org/gitlab!152500))

### Other (334 changes)

- [Add the zoekt application setting zoekt_auto_index_root_namespace](gitlab-org/gitlab@84c7f5bbcbdc766633c19bab629bac90cff5fa1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154272)) **GitLab Enterprise Edition**
- [Add and backfill project_id for external_status_checks_protected_branche](gitlab-org/gitlab@1df183e590cb5df390793a5241f0b77bc71c0a03) ([merge request](gitlab-org/gitlab!156317))
- [Add and backfill project_id for merge_request_review_llm_summaries](gitlab-org/gitlab@52859d0726c36653780306bbccc1b2259ebdf8d9) ([merge request](gitlab-org/gitlab!156319))
- [Protected packages + containers: Set alpha for GraphQL protection rules](gitlab-org/gitlab@e72f7c5d73efab04dfea6c9e4711f997852cc1a0) by @gerardo-navarro ([merge request](gitlab-org/gitlab!155964))
- [Backfilling ci_pipelines project_id](gitlab-org/gitlab@91d71a484f3aa5c19dc153b342c8631c4cdce11b) ([merge request](gitlab-org/gitlab!155137))
- [Prepare async creation for merge_requests.head_pipeline_id ](gitlab-org/gitlab@9d405dac68023c15ac987e307685dd0a2fb23613) ([merge request](gitlab-org/gitlab!155965))
- [Add and backfill project_id for vulnerability_issue_links](gitlab-org/gitlab@5caf6d9bb3393ef09ec0f5bcb12c3ae98ce44cdb) ([merge request](gitlab-org/gitlab!156249))
- [Fix some Style/EmptyMethod offenses](gitlab-org/gitlab@fe3ea3ae3e1e0337e6a72a3ab02e5ea52a4cad88) by @phot0n ([merge request](gitlab-org/gitlab!156221))
- [Drop FF respawn_assign_resource_worker](gitlab-org/gitlab@ec427e5e1b0c5ce12e27527b08bfb96291fff554) ([merge request](gitlab-org/gitlab!155235))
- [Removes extra period from FK docs](gitlab-org/gitlab@443df175d937dee15ad0625249353efc56203789) ([merge request](gitlab-org/gitlab!156199))
- [Adds a note about using BIGINT Fks](gitlab-org/gitlab@3cd3b97af8082a42431878fac154dc0b7a6a7e17) ([merge request](gitlab-org/gitlab!156061))
- [Define events and metrics for Find file instrumentation](gitlab-org/gitlab@0add83849a609b16f3347cb21b1ecfbcea148676) ([merge request](gitlab-org/gitlab!155457))
- [Add sharding-key on upcoming_reconciliations](gitlab-org/gitlab@6055f30fa9a200cc9870a47b255d5dc9055da48b) ([merge request](gitlab-org/gitlab!155762)) **GitLab Enterprise Edition**
- [Remove duplicated index from boards_epic_board_recent_visits](gitlab-org/gitlab@a3e02ea480514d2abefc074744696e42c05ee416) ([merge request](gitlab-org/gitlab!155510))
- [Add and backfill project_id for operations_strategies_user_lists](gitlab-org/gitlab@185db034bf0b656ffcc46276e3db7ffd82ef96ad) ([merge request](gitlab-org/gitlab!156122))
- [Add and backfill project_id for sbom_occurrences_vulnerabilities](gitlab-org/gitlab@225de1c9ce78fbfd45c1436d48d2f69d43dc89a7) ([merge request](gitlab-org/gitlab!156129))
- [Add and backfill project_id for packages_debian_project_distribution_key](gitlab-org/gitlab@c6ae0d68a5b61c766ca199f866ea8e556c166220) ([merge request](gitlab-org/gitlab!156127))
- [Add and backfill project_id for merge_request_blocks](gitlab-org/gitlab@aaa78737c0273f10b144487801dde03ec3e6626f) ([merge request](gitlab-org/gitlab!156120))
- [Add and backfill group_id for epic_user_mentions](gitlab-org/gitlab@6115c1241b7e57dffa9646c35ceb99d1c9bbd573) ([merge request](gitlab-org/gitlab!156119))
- [Include accessibility tests for classing and rapid diffs](gitlab-org/gitlab@1ec2a8feeb9fa89967021fc62067b55a5b61999d) ([merge request](gitlab-org/gitlab!155769))
- [Remove overage_members_modal feature flag](gitlab-org/gitlab@b00ac4d40682ac59632cea4ba90267bcbcbf8c2d) ([merge request](gitlab-org/gitlab!155487))
- [Implement train_type](gitlab-org/gitlab@b8b334977349403f03e3006005facb1a0087be49) ([merge request](gitlab-org/gitlab!153815)) **GitLab Enterprise Edition**
- [Add and backfill project_id for status_check_responses](gitlab-org/gitlab@fb743c6504db008dc53475030e600d5b861124c0) ([merge request](gitlab-org/gitlab!156033))
- [Add and backfill project_id for release_links](gitlab-org/gitlab@489ef1749c69544b1277b38ef0d703fddad9e7c9) ([merge request](gitlab-org/gitlab!156018))
- [Fix missing `traversal_ids` for `vulnerability_reads` records](gitlab-org/gitlab@941c50828943c2d21f8f21c6c0b446079ca314be) ([merge request](gitlab-org/gitlab!155998))
- [refactor: Apply best practices to visibility helper test](gitlab-org/gitlab@9dcfcda5406dbef728ee85aaaa4c06ae92875bd5) by @gerardo-navarro ([merge request](gitlab-org/gitlab!153801))
- [refactor: Protected packages: Collection of wording changes](gitlab-org/gitlab@55046bd2c1377d2307333c67a1eb3a0c9aac119a) by @gerardo-navarro ([merge request](gitlab-org/gitlab!142660))
- [Quarantine a flaky test](gitlab-org/gitlab@feaa6b2f212ec933d7288ec29bcbf062dca73d1c) ([merge request](gitlab-org/gitlab!155941))
- [Add and backfill group_id for packages_debian_group_distribution_keys](gitlab-org/gitlab@5da56deb8da1e4b8872eb791b948a9d23249f506) ([merge request](gitlab-org/gitlab!155711))
- [Add and backfill project_id for merge_request_assignment_events](gitlab-org/gitlab@a7d367e3f9f0e327c0db069fc3627bdb0fdc909c) ([merge request](gitlab-org/gitlab!155700))
- [Quarantine a flaky test](gitlab-org/gitlab@d3239b93af3d7164af79b575b55870470436949d) ([merge request](gitlab-org/gitlab!155364))
- [Quarantine a flaky test](gitlab-org/gitlab@e24d9e4bc1b5d67f25a774ff569d2fea41f298ac) ([merge request](gitlab-org/gitlab!155666))
- [Quarantine a flaky test](gitlab-org/gitlab@0fc2ff0b0ae113b87de3e34bf2bfcb7064204f62) ([merge request](gitlab-org/gitlab!155357))
- [Quarantine a flaky test](gitlab-org/gitlab@a00350b743d4ef70afc2f31c67d2363cbfe87695) ([merge request](gitlab-org/gitlab!155359))
- [Quarantine a flaky test](gitlab-org/gitlab@11b6013cabc7e443959f020f934b5b58e17ee5c2) ([merge request](gitlab-org/gitlab!155665))
- [Add and backfill project_id for packages_debian_publications](gitlab-org/gitlab@b376522e2972fb930e3fcbb48d906a582e9c4249) ([merge request](gitlab-org/gitlab!155870))
- [Remove `index_identities_on_provider` DB index](gitlab-org/gitlab@3ea5d517464409eaed04ae21fe9f7a36ba6e765c) ([merge request](gitlab-org/gitlab!155712))
- [Quarantine a flaky test](gitlab-org/gitlab@d1a2d7e77f7e3b51f34dc860293aa0034a6eb7bd) ([merge request](gitlab-org/gitlab!155360))
- [Improve UI text in custom notification settings](gitlab-org/gitlab@88db65ff3f6bc8218549e93a861f340f5f08eb1d) ([merge request](gitlab-org/gitlab!154449))
- [Quarantine a flaky test](gitlab-org/gitlab@4403547fb7563ff52db739fe3ecbf9d1b8741699) ([merge request](gitlab-org/gitlab!155369))
- [Quarantine a flaky test](gitlab-org/gitlab@5022ce56f83e24b647515836c0a0299826e1cbf0) ([merge request](gitlab-org/gitlab!155529))
- [Protected packages: Use positive logic to protected_up_to_access_level](gitlab-org/gitlab@cbf2bcebdf45ae2e9a552ac8b74e905fe6dbea57) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146089))
- [Add and backfill project_id for dast_site_validations](gitlab-org/gitlab@d33db8c73c5fb4ff5c2f5bbed65c49e0025016aa) ([merge request](gitlab-org/gitlab!155713))
- [Add and backfill project_id for vulnerability_merge_request_links](gitlab-org/gitlab@bb896747e458ba106338c62534c3d3d0aa69ce36) ([merge request](gitlab-org/gitlab!155710))
- [Add and backfill project_id for operations_feature_flags_issues](gitlab-org/gitlab@a5720ce744a7f028a6a512fad3c79aa1aa318300) ([merge request](gitlab-org/gitlab!155709))
- [Docs: Support mutual TLS in GitLab Pages with GitLab API](gitlab-org/gitlab@180af6ac4d0756930cc39005211a6151edb1b52b) ([merge request](gitlab-org/gitlab!152909))
- [Quarantine a flaky test](gitlab-org/gitlab@846c4f050d264e539a310798e0d87940f8e37074) ([merge request](gitlab-org/gitlab!155371))
- [Quarantine a flaky test](gitlab-org/gitlab@a508063930f45f286c2263e1d9f5b5be8432b56e) ([merge request](gitlab-org/gitlab!155366))
- [Add a metric ZoektSearchEnabledMetric](gitlab-org/gitlab@3bc51db7d424d123eeefc0b8126fb05182defb8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/155078)) **GitLab Enterprise Edition**
- [Release augmenting package registry GCS signed URLs with metadata](gitlab-org/gitlab@8aa9648c51782c02f6211a849617e9e84c8a793e) ([merge request](gitlab-org/gitlab!153088))
- [Remove column default](gitlab-org/gitlab@c00383187e594a8dc72edd3bde9b748a033c53ad) ([merge request](gitlab-org/gitlab!155579)) **GitLab Enterprise Edition**
- [Add and backfill project_id for dast_pre_scan_verifications](gitlab-org/gitlab@7266c0e5aaab7efbdfa4e01865edee3500e3ffdc) ([merge request](gitlab-org/gitlab!155076))
- [Draft: Add sharding key tracking issues for security_policy_management](gitlab-org/gitlab@8439f732990165f212b6e09341ed25a17517a141) ([merge request](gitlab-org/gitlab!152827))
- [Resolve Layout/ArgumentAlignment offenses 82](gitlab-org/gitlab@e3e757d435782f44c4c3d30b37cb04104014d6cb) by @gauravmarwal ([merge request](gitlab-org/gitlab!151280))
- [Quarantine a flaky test](gitlab-org/gitlab@fb5dd9be30016271c73e1e9d69b944128cdbace1) ([merge request](gitlab-org/gitlab!155362))
- [Quarantine a flaky test](gitlab-org/gitlab@3ff708cb2aa5e1a222cbaef7e2dec67048e3236c) ([merge request](gitlab-org/gitlab!155528))
- [Quarantine a flaky test](gitlab-org/gitlab@dda670d9a2d4cfa95a270e500b2633170d3a6760) ([merge request](gitlab-org/gitlab!155527))
- [Quarantine a flaky test](gitlab-org/gitlab@0396564369629738968d8d0dc930f0eda995c60e) ([merge request](gitlab-org/gitlab!155525))
- [Quarantine a flaky test](gitlab-org/gitlab@3c9b215e4e324e4760fda84eae6867d7ea5b1aff) ([merge request](gitlab-org/gitlab!155524))
- [Quarantine a flaky test](gitlab-org/gitlab@2ff84a16cf0e6885b02efd6df8ad1303291b6b31) ([merge request](gitlab-org/gitlab!155523))
- [Quarantine a flaky test](gitlab-org/gitlab@7df354ef6579796417b3664185a826c58a598684) ([merge request](gitlab-org/gitlab!155521))
- [Quarantine a flaky test](gitlab-org/gitlab@4495c2622ced663b4ab52dc4d59490cabd38c670) ([merge request](gitlab-org/gitlab!155350))
- [Remove duplicated index from boards_epic_user_preferences](gitlab-org/gitlab@bc9b9e666a6358a1a000f63ed1e8f3dfceb2b0e6) ([merge request](gitlab-org/gitlab!155511))
- [Remove duplicated index from board_user_preferences](gitlab-org/gitlab@eebb49df49ff4310d7117ad63826308d279f4bcd) ([merge request](gitlab-org/gitlab!155508))
- [Mark 20230426195404 as obsolete](gitlab-org/gitlab@cc6c34aa8800a8c7d66cb41a63db62bbe2db1b03) ([merge request](gitlab-org/gitlab!152977)) **GitLab Enterprise Edition**
- [Add and backfill project_id for vulnerability_state_transitions](gitlab-org/gitlab@9bc3b8a24bc7dd1cf4dcd8b6818b80b4d7f59bec) ([merge request](gitlab-org/gitlab!155496))
- [Add and backfill project_id for merge_request_assignees](gitlab-org/gitlab@64d3c0f5be30fa42c7838e7a971787d17e4f20ee) ([merge request](gitlab-org/gitlab!155492))
- [Add and backfill project_id for dast_site_profile_secret_variables](gitlab-org/gitlab@02b3f753e567c6e0f9a37cec0af83ca5defb65fa) ([merge request](gitlab-org/gitlab!155491))
- [Mark 20230518064300 as obsolete](gitlab-org/gitlab@a138c4ecc70433ba67ce47be90aec4fac6e2bf5e) ([merge request](gitlab-org/gitlab!152982)) **GitLab Enterprise Edition**
- [Add and backfill project_id for terraform_state_versions](gitlab-org/gitlab@f94519f72675b154e1bc91b1f5380f768429ce93) ([merge request](gitlab-org/gitlab!155438))
- [Add and backfill project_id for project_relation_exports](gitlab-org/gitlab@c06311e91dcfb60411db86305ab0975d0fc051cd) ([merge request](gitlab-org/gitlab!155429))
- [Add organization_id column](gitlab-org/gitlab@ed6f2730719b11f38336f70962ee2fb716fe733c) ([merge request](gitlab-org/gitlab!154406)) **GitLab Enterprise Edition**
- [Draft: Add sharding key tracking issues for requirements_management](gitlab-org/gitlab@2b408fcefb58f04918c9e40106a733e370ec40a2) ([merge request](gitlab-org/gitlab!152749))
- [Draft: Add sharding key tracking issues for incident_management](gitlab-org/gitlab@8975d91056bd2d71febe4e70644b4c1eb240521c) ([merge request](gitlab-org/gitlab!152831))
- [Add and backfill project_id for draft_notes](gitlab-org/gitlab@e0d80557da7f2a7b29cd7857617781041ccf2664) ([merge request](gitlab-org/gitlab!155403))
- [Draft: Add sharding key tracking issues for geo_replication](gitlab-org/gitlab@a6a87bf77cdfcceb192ce1a8db9c055e3f3a6c4d) ([merge request](gitlab-org/gitlab!152829))
- [Remove ai_gateway_docs_search flag](gitlab-org/gitlab@e913aecc114640c0a2bfed0d9068071f49bdcbfe) ([merge request](gitlab-org/gitlab!154876)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](gitlab-org/gitlab@8ba829b3f032387f67a22f99b8c520571412d690) ([merge request](gitlab-org/gitlab!155379))
- [Quarantine a flaky test](gitlab-org/gitlab@2c9461207a1bd63e00b917229d5ecc5c56c32fab) ([merge request](gitlab-org/gitlab!155374))
- [Quarantine a flaky test](gitlab-org/gitlab@6c608a061cb6bf7d096b4fcc5f6ad70a9b1dbc06) ([merge request](gitlab-org/gitlab!155370))
- [Quarantine a flaky test](gitlab-org/gitlab@ee8ab4809dfd223c1e7460619e56c3b4bbf43a5b) ([merge request](gitlab-org/gitlab!155368))
- [Quarantine a flaky test](gitlab-org/gitlab@3483b1da1ca5d32c26b5cdced85f72f7fbfb88be) ([merge request](gitlab-org/gitlab!155367))
- [Quarantine a flaky test](gitlab-org/gitlab@fe3b977ff297f6b2c9ecf5b39ce6807aeaccefd6) ([merge request](gitlab-org/gitlab!155363))
- [Quarantine a flaky test](gitlab-org/gitlab@194729bb6fff41df35ccf282a487567fe1cea056) ([merge request](gitlab-org/gitlab!155358))
- [Quarantine a flaky test](gitlab-org/gitlab@9bb886e64718d7579a427c4e7faa2b1319ebf182) ([merge request](gitlab-org/gitlab!155355))
- [Quarantine a flaky test](gitlab-org/gitlab@c89b618e91f52ac321d1bf02b36d2670a99d03d6) ([merge request](gitlab-org/gitlab!155352))
- [Quarantine a flaky test](gitlab-org/gitlab@cd99efd4bc27dd2692bb6c90ad49ea33e7d6b4db) ([merge request](gitlab-org/gitlab!155348))
- [Draft: Add sharding key tracking issues for continuous_delivery](gitlab-org/gitlab@3a7280b4b1aa91f68922973cad2019456384d7d9) ([merge request](gitlab-org/gitlab!152821))
- [Draft: Add sharding key tracking issues for integrations](gitlab-org/gitlab@8b53200043eff2cfd419cbdabb31b26d6f6741c9) ([merge request](gitlab-org/gitlab!152745))
- [Add and backfill project_id for vulnerability_user_mentions](gitlab-org/gitlab@a1aeaf16848af009d0db5c7204874fc3c075c118) ([merge request](gitlab-org/gitlab!155289))
- [Add and backfill project_id for operations_strategies](gitlab-org/gitlab@427668fe83b4d3de07e74367f78cf994a9624b12) ([merge request](gitlab-org/gitlab!155286))
- [Add and backfill project_id for dast_profiles_tags](gitlab-org/gitlab@daed28a64c7992f46b69e2485268f5a13d78040d) ([merge request](gitlab-org/gitlab!155285))
- [Remove untrusted Bitbucket identities and related fallback](gitlab-org/gitlab@35ec48b44774e6a727bb22aa3a3af80f526125e6) ([merge request](gitlab-org/gitlab!155094))
- [Resolve Layout/ArgumentAlignment offenses 68](gitlab-org/gitlab@4c9a3f7e250735244336d1c15d85798f3310b70c) by @gauravmarwal ([merge request](gitlab-org/gitlab!151265))
- [Drop unused `index_vulnerability_occurrences_on_project_fingerprint`](gitlab-org/gitlab@edadc50b0ecc4b21e09e7656f25dabada28e2fae) ([merge request](gitlab-org/gitlab!155260))
- [Use normal font weight for board view dropdown toggles](gitlab-org/gitlab@4aed497b2fad8bf71919685e659ce0acf40c8537) ([merge request](gitlab-org/gitlab!154477))
- [Make approver to-do and email consistent](gitlab-org/gitlab@a065b06782a6a0c19e0f0466b74bd894a7923750) ([merge request](gitlab-org/gitlab!155122)) **GitLab Enterprise Edition**
- [Remove `tree` method from ExtractsRef](gitlab-org/gitlab@36adb54b79753a5d1496f1a399129f100d24441d) ([merge request](gitlab-org/gitlab!155259))
- [Updated documentation & fixed rate limit user](gitlab-org/gitlab@67feeea9cab671550c51a94f93fe1fbfb228387b) by @archish27 ([merge request](gitlab-org/gitlab!150327))
- [Resolve Layout/ArgumentAlignment offenses 65](gitlab-org/gitlab@b44a0275d73d160fa5f61176cb08feb2cde341a0) by @gauravmarwal ([merge request](gitlab-org/gitlab!151262))
- [Protected container: Add help page for protected containers](gitlab-org/gitlab@afcba570c9179a401d4ca6ea6b948ee28eb6c05f) by @gerardo-navarro ([merge request](gitlab-org/gitlab!154191))
- [Add and backfill project_id for ml_experiment_metadata](gitlab-org/gitlab@3309493f20737793c36ce1a2ba49e91b6d0f3dca) ([merge request](gitlab-org/gitlab!155223))
- [Add and backfill namespace_id for user_achievements](gitlab-org/gitlab@1fc41abad0b2627d116abaa104c05ff520531085) ([merge request](gitlab-org/gitlab!155222))
- [Remove use_ids_for_markdown_upload_urls flag](gitlab-org/gitlab@30e67a743f7e1727adf5b0500d648b2e20327b49) ([merge request](gitlab-org/gitlab!155215))
- [Remove default values ci_daily_build_group_report_results#partition_id](gitlab-org/gitlab@215f48baab9a21ca5e6d89deda3c42af9d6b1d28) ([merge request](gitlab-org/gitlab!155046))
- [Update feature category for MergeWorker](gitlab-org/gitlab@bc129def43dfad38ebfce9ec233929d7968660cb) ([merge request](gitlab-org/gitlab!155040))
- [Quarantine a flaky test](gitlab-org/gitlab@66917ad38bec71a2a4fa74e2e9d79623e9d9cea2) ([merge request](gitlab-org/gitlab!155196))
- [Quarantine a flaky test](gitlab-org/gitlab@01f3e694ade0bf23e8548ef751324d47a3d7f0b0) ([merge request](gitlab-org/gitlab!155173))
- [Refactor ExtractsRef to use RefExtractor logic](gitlab-org/gitlab@dc5272f95c570c7770cbc0defb2b7b5380db6b8e) ([merge request](gitlab-org/gitlab!145438))
- [Remove obsolete Advanced search migrations](gitlab-org/gitlab@108f9d81c9269fc9aaead109b41e7e670b3be7ce) ([merge request](gitlab-org/gitlab!155116)) **GitLab Enterprise Edition**
- [Remove FF auto_merge_when_incomplete_pipeline_succeeds](gitlab-org/gitlab@1c906336fe3c8f1d9663d40564376947489ba5cf) ([merge request](gitlab-org/gitlab!154619))
- [Remove unnecessary allows between gitlab_schemas](gitlab-org/gitlab@55fe55f2b8f4d70d32b06e33ae1836239619490c) ([merge request](gitlab-org/gitlab!155097))
- [Add and backfill project_id for packages_build_infos](gitlab-org/gitlab@bc1b931807503d32a798cbee0fae5af9321f2d22) ([merge request](gitlab-org/gitlab!154572))
- [Add a new FF disable_zoekt_search_for_saas](gitlab-org/gitlab@5ac1fd942d3215ba183cbd55bac566ce4d1aeb4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154746)) **GitLab Enterprise Edition**
- [Add and backfill namespace_id for design_management_versions](gitlab-org/gitlab@e3a33642f0fe5f2d1226035cc44da60fcb680171) ([merge request](gitlab-org/gitlab!154281))
- [Draft: Add sharding key tracking issues for release_evidence](gitlab-org/gitlab@79fb3807edf6965dd52f1ea0e878750a20119e4c) ([merge request](gitlab-org/gitlab!152811))
- [Remove "use_remote_service_update_service" feature flag](gitlab-org/gitlab@e57be539d8b256aa2257eb0c502b8731af10fa8e) ([merge request](gitlab-org/gitlab!155037)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](gitlab-org/gitlab@2e5ce185a9b4d8fefade0b25a9156c128ac323f8) ([merge request](gitlab-org/gitlab!154648))
- [Quarantine a flaky test](gitlab-org/gitlab@c91773edd2bd8236679043e1a46d957296536b9c) ([merge request](gitlab-org/gitlab!154670))
- [Quarantine a flaky test](gitlab-org/gitlab@b47592cb549ba134e70ca13cfc2cd0df995ed0dd) ([merge request](gitlab-org/gitlab!155003))
- [Quarantine a flaky test](gitlab-org/gitlab@2e565a6ad4d0859bd782a0ecb4a3a1c487733d8b) ([merge request](gitlab-org/gitlab!154655))
- [Quarantine a flaky test](gitlab-org/gitlab@08ff5fb8cf28bcc89e6ebbd4fe1da8464c3f5d45) ([merge request](gitlab-org/gitlab!154665))
- [Quarantine a flaky test](gitlab-org/gitlab@ae13cdfae8216c3e6626a913f155adaccea3fd49) ([merge request](gitlab-org/gitlab!154654))
- [Quarantine a flaky test](gitlab-org/gitlab@ab3e4694cfd71e173c8119163555b091f89287b0) ([merge request](gitlab-org/gitlab!154986))
- [Quarantine a flaky test](gitlab-org/gitlab@d5ab846923fd9d53943758f1dfd1d92a286de9b5) ([merge request](gitlab-org/gitlab!154658))
- [Quarantine a flaky test](gitlab-org/gitlab@45644e5ef1fc810084b3cfefe2f0d7c898258cad) ([merge request](gitlab-org/gitlab!154652))
- [Quarantine a flaky test](gitlab-org/gitlab@ea7ca973aa1f8e75d6bbb74fbf9e4f3343c5e954) ([merge request](gitlab-org/gitlab!154686))
- [Quarantine a flaky test](gitlab-org/gitlab@5fa066d4d4ec665ec8041b6b19a806531360f090) ([merge request](gitlab-org/gitlab!154650))
- [Quarantine a flaky test](gitlab-org/gitlab@430a7435376efff82034eff0fd4971175d99813d) ([merge request](gitlab-org/gitlab!154649))
- [Finalize migration BackfillDeploymentApprovalsProjectId](gitlab-org/gitlab@fca4850931faab8117964bbd21bb348a6e2956e8) ([merge request](gitlab-org/gitlab!154849))
- [Quarantine a flaky test](gitlab-org/gitlab@80bafa73a01722a05460605e711170b7df61bfaa) ([merge request](gitlab-org/gitlab!154988))
- [Fix Layout/FirstArrayElementIndentation 1 offenses](gitlab-org/gitlab@64da3ff4d62a548c7fde17061ba966fba998e390) by @archish27 ([merge request](gitlab-org/gitlab!151168))
- [Quarantine a flaky test](gitlab-org/gitlab@2878da485a53770c6011ce1f86c08f713e783a89) ([merge request](gitlab-org/gitlab!154859))
- [Quarantine a flaky test](gitlab-org/gitlab@1f00f34acc3ba7092de827a7f7e06ebd197c5361) ([merge request](gitlab-org/gitlab!154664))
- [Quarantine a flaky test](gitlab-org/gitlab@496e48f7fd887c72aeb9822f6de0b8006fb23a67) ([merge request](gitlab-org/gitlab!154661))
- [Quarantine a flaky test](gitlab-org/gitlab@c446902577bfe50473fffbe51efb9ae2c9a0ce63) ([merge request](gitlab-org/gitlab!154676))
- [Quarantine a flaky test](gitlab-org/gitlab@f6a745ab130650989c34a5eee63828b4375f6761) ([merge request](gitlab-org/gitlab!154666))
- [Quarantine a flaky test](gitlab-org/gitlab@926542ca756a622efc7a1df07609fd8b0b5d36b4) ([merge request](gitlab-org/gitlab!154644))
- [Add and backfill project_id for wiki_page_slugs](gitlab-org/gitlab@107b946a70d4b5346f4e7e3d0480734c88f396db) ([merge request](gitlab-org/gitlab!154560))
- [Quarantine a flaky test](gitlab-org/gitlab@694f9ccecea7bc0a742d871a3bf7315ea7e9482b) ([merge request](gitlab-org/gitlab!154685))
- [Drop temp_index_on_notes_with_null_noteable_type from notes table](gitlab-org/gitlab@4eaf5a5367ddef391a1833ee7333ef988da7e996) ([merge request](gitlab-org/gitlab!154831))
- [Resolve Layout/ArgumentAlignment offenses 75](gitlab-org/gitlab@fda543db58e15586a5dd39199763e0fb0fe058b1) by @gauravmarwal ([merge request](gitlab-org/gitlab!151272))
- [Protected packages: Add help text for name pattern input](gitlab-org/gitlab@5c0cd795d042532c629690d5073da2158f3df979) by @gerardo-navarro ([merge request](gitlab-org/gitlab!152221))
- [Quarantine a flaky test](gitlab-org/gitlab@6295213aa523df197e5ede2e0e9dce6f5ddc054d) ([merge request](gitlab-org/gitlab!154656)) **GitLab Enterprise Edition**
- [Add and backfill project_id for remote_development_agent_configs](gitlab-org/gitlab@55c95fc0c10af64c6503d528925f5296627ea512) ([merge request](gitlab-org/gitlab!154773))
- [Add and backfill project_id for dora_daily_metrics](gitlab-org/gitlab@002ac61dc198aa5db439235e28ac1129139df772) ([merge request](gitlab-org/gitlab!154616))
- [Resolve Layout/ArgumentAlignment offenses 73](gitlab-org/gitlab@fda37ccd9e8fe9a522e7c801588cbf1bb07b9d38) by @gauravmarwal ([merge request](gitlab-org/gitlab!151270))
- [Quarantine a flaky test](gitlab-org/gitlab@86ec6c830580c467c98d9010a3a417ab99b5b5bd) ([merge request](gitlab-org/gitlab!154704))
- [Quarantine a flaky test](gitlab-org/gitlab@76434fb001a650441cfdaef803f37f50e20da926) ([merge request](gitlab-org/gitlab!154647))
- [Quarantine a flaky test](gitlab-org/gitlab@d1f1892310aba18f46d6befe6bb9626848020e20) ([merge request](gitlab-org/gitlab!154657))
- [Quarantine a flaky test](gitlab-org/gitlab@9f16088e3bd8c6f7a44d84f402e0e28f355e984c) ([merge request](gitlab-org/gitlab!154672))
- [Quarantine a flaky test](gitlab-org/gitlab@9123fd9aea8e8e408bedb645972b3d47996fceda) ([merge request](gitlab-org/gitlab!154674))
- [Quarantine a flaky test](gitlab-org/gitlab@07c189d4ae49b94ec7165e8252e94b4ddc1be00f) ([merge request](gitlab-org/gitlab!154678))
- [Quarantine a flaky test](gitlab-org/gitlab@2776de0b049bdf12fee19b211fbc8bf98443cd25) ([merge request](gitlab-org/gitlab!154683))
- [Quarantine a flaky test](gitlab-org/gitlab@51d3bc98f8e68540e0dbf04711631732f4f3f599) ([merge request](gitlab-org/gitlab!154684))
- [Quarantine a flaky test](gitlab-org/gitlab@56d6306c2b0395418c974e8981b40daf535f0393) ([merge request](gitlab-org/gitlab!154687))
- [Quarantine a flaky test](gitlab-org/gitlab@f062aae2aba28c404fe42f6baa83802ed305ebcf) ([merge request](gitlab-org/gitlab!154641))
- [Finalize migration BackfillClusterAgentTokensProjectId](gitlab-org/gitlab@f2f3f3ff8c258cca10546880b836bcd4ec6109a8) ([merge request](gitlab-org/gitlab!154479))
- [Quarantine a flaky test](gitlab-org/gitlab@99249d5984cc5a732dc0b4f5a10e29ba3b613e5f) ([merge request](gitlab-org/gitlab!154662))
- [Quarantine a flaky test](gitlab-org/gitlab@fdbdeeb79f2d9db02ebfc4eb04db33d45b77da59) ([merge request](gitlab-org/gitlab!154642))
- [Add not null constraint for releases.project_id](gitlab-org/gitlab@f3763ebb9872e3d2bfbcd1c80514a95677299b89) ([merge request](gitlab-org/gitlab!153033))
- [Fix Lint/AmbiguousOperatorPrecedence 4 offenses](gitlab-org/gitlab@e42a48d63e2ac0e4379ea6d9ea13c65e23274715) by @archish27 ([merge request](gitlab-org/gitlab!151158)) **GitLab Enterprise Edition**
- [Draft: Add sharding key tracking issues for code_review_workflow](gitlab-org/gitlab@df0e610e23ecef90db062049ded8b39b7ed76c53) ([merge request](gitlab-org/gitlab!152826))
- [Add and backfill agent_project_id for agent_activity_events](gitlab-org/gitlab@548b86b953d04cffcfd4cbe820ded07c444298cd) ([merge request](gitlab-org/gitlab!154615))
- [Draft: Add sharding key tracking issues for cell](gitlab-org/gitlab@9ed1c393888569092b7fad4fac04fa1140fa1b28) ([merge request](gitlab-org/gitlab!152818))
- [Backfill epic_issues records into work_items](gitlab-org/gitlab@32db2a2ea881bb7b407a8a3e92f4f27d437209b7) ([merge request](gitlab-org/gitlab!147509))
- [Resolve Layout/ArgumentAlignment offenses 79](gitlab-org/gitlab@e1f099cdba783c8f5295ec7e772e07fe3efbe251) by @gauravmarwal ([merge request](gitlab-org/gitlab!151276))
- [Resolve Layout/ArgumentAlignment offenses 86](gitlab-org/gitlab@f00f776d47ee33cee64907eef88d79ed63b5145b) by @gauravmarwal ([merge request](gitlab-org/gitlab!151286))
- [Fix Layout/SpaceInLambdaLiteral 8 offenses](gitlab-org/gitlab@ca4c4ce0d1fe6829d344d6d1f0769ef6c6388b56) by @archish27 ([merge request](gitlab-org/gitlab!151197))
- [Remove unnecessary allows between gitlab_schemas](gitlab-org/gitlab@ce6af8bc6cb72bb2533aea6a9ef31f8bb109ff62) ([merge request](gitlab-org/gitlab!154570))
- [Add and backfill group_id for boards_epic_user_preferences](gitlab-org/gitlab@70b289a10d23b21f4c0f5125a73dd19678e8ef0c) ([merge request](gitlab-org/gitlab!153684))
- [Fix Layout/MultilineOperationIndentation 3 offenses](gitlab-org/gitlab@e6db09d0dccfdd67998b489a8a439ed8bb33ed83) by @archish27 ([merge request](gitlab-org/gitlab!151227))
- [Fix Lint/AmbiguousOperatorPrecedence 6 offenses](gitlab-org/gitlab@429fd86a0e03221529843a337dfa085014a78cfa) by @archish27 ([merge request](gitlab-org/gitlab!151160))
- [Draft: Add sharding key tracking issues for system_access](gitlab-org/gitlab@f27d8ccef26a83652f03aa3b3c22648402b1c3c3) ([merge request](gitlab-org/gitlab!152817))
- [Use RemoteMirrors::DestroyService for push mirror deletion](gitlab-org/gitlab@b96e0a77ade44b37ff161d88be2ec96b0e6ef3fc) ([merge request](gitlab-org/gitlab!153845))
- [Draft: Add sharding key tracking issues for importers](gitlab-org/gitlab@a3e134168759a8639a691a728f3980026b0c587c) ([merge request](gitlab-org/gitlab!152751))
- [Remove unused approval auto merge worker](gitlab-org/gitlab@727e45e696d04ce76d10de4610a78a7a80d1399b) ([merge request](gitlab-org/gitlab!154520))
- [Resolve Layout/ArgumentAlignment offenses 71](gitlab-org/gitlab@a8f96f102874e7e57c034a83d2c299509c8a9328) by @gauravmarwal ([merge request](gitlab-org/gitlab!151268))
- [Fix Lint/SymbolConversion 1 offenses](gitlab-org/gitlab@937bb5aa3300f9b5078deaf4cd1f6b036e0158ac) by @archish27 ([merge request](gitlab-org/gitlab!151182)) **GitLab Enterprise Edition**
- [Remove duplicated index from board_project_recent_visits](gitlab-org/gitlab@0983c14ba60390d51c4bef8637c6d935105de0ee) ([merge request](gitlab-org/gitlab!154476))
- [Fix Layout/SpaceInLambdaLiteral 4 offenses](gitlab-org/gitlab@860d415bde759f27dcd19c2eb9ea8ca588e6e636) by @archish27 ([merge request](gitlab-org/gitlab!151194))
- [Fix Lint/SymbolConversion 3 offenses](gitlab-org/gitlab@dc9cdca66278ead6da2e647837cc9dc8e22ae8a9) by @archish27 ([merge request](gitlab-org/gitlab!151184)) **GitLab Enterprise Edition**
- [Fix Lint/SymbolConversion 8 offenses](gitlab-org/gitlab@d496a0c37ba783b86206f00ab5b3af3c20ddfc02) by @archish27 ([merge request](gitlab-org/gitlab!151189))
- [Consolidate MWCP feature flags into 1](gitlab-org/gitlab@d7b291ef0e8d92b93edd5c4c6ae3ec587377799d) ([merge request](gitlab-org/gitlab!154366))
- [Resolve Layout/ArgumentAlignment offenses 74](gitlab-org/gitlab@18ee2c75a96f8468e20b6865fadf41a4dd89b517) by @gauravmarwal ([merge request](gitlab-org/gitlab!151271))
- [Resolve Layout/ArgumentAlignment offenses 85](gitlab-org/gitlab@cf75441a544748ae6b15656246f26926169107df) by @gauravmarwal ([merge request](gitlab-org/gitlab!151283))
- [Cleanup approval_policy_parent_child_pipeline feature flag](gitlab-org/gitlab@3c866e490badfa1a19fb7fb669c4459796f5d275) ([merge request](gitlab-org/gitlab!154345)) **GitLab Enterprise Edition**
- [Remove remove_refactor_auto_merge feature flag](gitlab-org/gitlab@a043b2a6af5123358768c79878fb32b37ac127d5) ([merge request](gitlab-org/gitlab!153279))
- [Draft: Add sharding key tracking issues for devops_reports](gitlab-org/gitlab@9fb17cbf334a25909e5e1215454273e2ed75bcb8) ([merge request](gitlab-org/gitlab!152833))
- [DROP temp_notes_backup table](gitlab-org/gitlab@271171b36d3b6cec3aadcf73d7efb001e5772277) ([merge request](gitlab-org/gitlab!154317))
- [Draft: Add sharding key tracking issues for team_planning](gitlab-org/gitlab@ef8fe276900124c0ec938b468cd227968991ca13) ([merge request](gitlab-org/gitlab!152832))
- [Validate notes.noteable_type NOT NULL constraint SYNC](gitlab-org/gitlab@57cbc5b3ac0165008ac26eaf41b479e4763ede26) ([merge request](gitlab-org/gitlab!154312))
- [Resolve Layout/ArgumentAlignment offenses 80](gitlab-org/gitlab@e646ab32b940432f289e3b2cc2b069fc178d4deb) by @gauravmarwal ([merge request](gitlab-org/gitlab!151277))
- [Resolve Layout/ArgumentAlignment offenses 78](gitlab-org/gitlab@967eb3f50541f392ae702c33c0baeda2d5132221) by @gauravmarwal ([merge request](gitlab-org/gitlab!151275))
- [Fix Layout/SpaceInLambdaLiteral 7 offenses](gitlab-org/gitlab@02262417c1b195d5deaacdabbff1011a645f9c20) by @archish27 ([merge request](gitlab-org/gitlab!151196))
- [Resolve Layout/ArgumentAlignment offenses 72](gitlab-org/gitlab@f3f7d4039c9c9337e4e55e27578896766d963a73) by @gauravmarwal ([merge request](gitlab-org/gitlab!151269))
- [Resolve Layout/ArgumentAlignment offenses 66](gitlab-org/gitlab@ec69edcd4e0b12291f0afe6fd898d117a23aba21) by @gauravmarwal ([merge request](gitlab-org/gitlab!151263))
- [Add sharding key tracking issues for continuous_integration](gitlab-org/gitlab@1f4007330cce78b62d07eeea2c85803733e76ff1) ([merge request](gitlab-org/gitlab!152830))
- [Fix Layout/SpaceInLambdaLiteral 22 offenses](gitlab-org/gitlab@5e0bb56106ecf14bc95b5c6ea0f3c5dee80790f4) by @archish27 ([merge request](gitlab-org/gitlab!151211))
- [Add and backfill group_id for boards_epic_lists](gitlab-org/gitlab@7ea84ab3d8916cea96df318d269801f8025436d7) ([merge request](gitlab-org/gitlab!153678))
- [Draft: Add sharding key tracking issues for build_artifacts](gitlab-org/gitlab@69d3d5ba40fa59c458e38b6fb5047f1ef71208ed) ([merge request](gitlab-org/gitlab!152814))
- [Fix Layout/FirstArrayElementIndentation 4 offenses](gitlab-org/gitlab@92040bdf2d96b4e2d06232e008d899ec220c76b7) by @archish27 ([merge request](gitlab-org/gitlab!151171))
- [Add sharding key for VSA tables](gitlab-org/gitlab@353b2fb694b7b940b82415ab4fc37c25ccc45eab) ([merge request](gitlab-org/gitlab!152816))
- [Fix Layout/FirstArrayElementIndentation 2 offenses](gitlab-org/gitlab@0db52cd8d7699f48d4c5957a8b1d0ce3dcf1e842) by @archish27 ([merge request](gitlab-org/gitlab!151169))
- [Fix Lint/AmbiguousOperatorPrecedence 10 offenses](gitlab-org/gitlab@d551dd5d4517386e8351bb3df232b699e3cea30d) by @archish27 ([merge request](gitlab-org/gitlab!151164))
- [Finalize migration BackfillCatalogResourceVersionSemVer](gitlab-org/gitlab@5bd85f6732e4d488be6077d6d46b46b0a0ada248) ([merge request](gitlab-org/gitlab!153037))
- [Fix Lint/AmbiguousOperatorPrecedence 11 offenses](gitlab-org/gitlab@254ad368b481f70b4ee6bdde343e6d14ed7e23a7) by @archish27 ([merge request](gitlab-org/gitlab!151165))
- [Fix Layout/SpaceInLambdaLiteral 11 offenses](gitlab-org/gitlab@be70cad526de5eeb0c194776f89573bbb757139e) by @archish27 ([merge request](gitlab-org/gitlab!151200)) **GitLab Enterprise Edition**
- [Make copy for entering URLs consistent](gitlab-org/gitlab@2568c86e7e6bc5e0056334738eb1a52efff919d4) ([merge request](gitlab-org/gitlab!154149)) **GitLab Enterprise Edition**
- [Drop the temporary index from `vulnerability_reads` table](gitlab-org/gitlab@ca35f6ed0b2a7babee6bf643d6acf7fdd36f379e) ([merge request](gitlab-org/gitlab!154154))
- [Draft: Add sharding key tracking issues for secrets_management](gitlab-org/gitlab@32e71b0c047045d74ab2d20089c932effa484689) ([merge request](gitlab-org/gitlab!152810))
- [Add and backfill namespace_id for design_management_repositories](gitlab-org/gitlab@dba894f7547482bc554d205899e0345363c04fff) ([merge request](gitlab-org/gitlab!153150))
- [Add and backfill namespace_id for design_management_designs](gitlab-org/gitlab@b57191df4c258f3c72ce051fc166238747f7250b) ([merge request](gitlab-org/gitlab!153149))
- [Fix Layout/SpaceInLambdaLiteral 5 offenses](gitlab-org/gitlab@48473738c8b6143a0f187699a6d921f6e03bb544) by @archish27 ([merge request](gitlab-org/gitlab!151230))
- [Fix Layout/SpaceInLambdaLiteral 14 offenses](gitlab-org/gitlab@21bd144b504613b8cfd8f2f224ba2221baba71bd) by @archish27 ([merge request](gitlab-org/gitlab!151203)) **GitLab Enterprise Edition**
- [Fix Layout/SpaceInLambdaLiteral 2 offenses](gitlab-org/gitlab@7f38f8622f789a0db731adca81501f418a349b02) by @archish27 ([merge request](gitlab-org/gitlab!151192))
- [Fix Lint/AmbiguousOperatorPrecedence 9 offenses](gitlab-org/gitlab@9e0df84fba2e2c995996b359566d4ee29ec64c4d) by @archish27 ([merge request](gitlab-org/gitlab!151163))
- [Draft: Add sharding key tracking issues for portfolio_management](gitlab-org/gitlab@53ef83704d9c6e8d20be49167bb31776b457e259) ([merge request](gitlab-org/gitlab!152812))
- [Quarantine a flaky test](gitlab-org/gitlab@22cb314cfb34210dbd85c7c8e67a46ae980a475b) ([merge request](gitlab-org/gitlab!153507))
- [Quarantine a flaky test](gitlab-org/gitlab@17972173cc8c64511af6ed18ec1fd3481c72a8e2) ([merge request](gitlab-org/gitlab!153368))
- [Quarantine a flaky test](gitlab-org/gitlab@9c41310492e80ee7f2d9cd9848a82dc376ecf473) ([merge request](gitlab-org/gitlab!153206))
- [Quarantine a flaky test](gitlab-org/gitlab@2623aa9fea09599076e0514e178b370b28b90f62) ([merge request](gitlab-org/gitlab!154077))
- [Clean up ai_chat_enabled_namespace_ids feature flag](gitlab-org/gitlab@b0a900638f08ffd830772ba4d11cb4a3d3d16a22) ([merge request](gitlab-org/gitlab!154068))
- [Draft: Add sharding key tracking issues for audit_events](gitlab-org/gitlab@f1c1eb55a0c231ca52be056db2b8018bb50a573a) ([merge request](gitlab-org/gitlab!152808))
- [Quarantine a flaky test](gitlab-org/gitlab@a2092465641932ba67623d9b3c8fd998720e3769) ([merge request](gitlab-org/gitlab!152881))
- [Resolve Layout/FirstHashElementIndentation 3](gitlab-org/gitlab@c2d84776623ab9f1f87a810820bf1819b1f21699) by @gauravmarwal ([merge request](gitlab-org/gitlab!151292))
- [Quarantine a flaky test](gitlab-org/gitlab@9553bcc213ba5c7c05465b9ddda1f569179738b3) ([merge request](gitlab-org/gitlab!152466))
- [Fix Lint/AmbiguousRegexpLiteral 2 offenses](gitlab-org/gitlab@2e853f231b02da9dfbff2f7d2423d8e5e349e7fa) by @archish27 ([merge request](gitlab-org/gitlab!151214))
- [Add and backfill group_id for audit_events_streaming_event_type_filters](gitlab-org/gitlab@449dd94db036d158bf95adc6ac9fe1b9e04bd830) ([merge request](gitlab-org/gitlab!152957))
- [Clean up arkose_labs_phone_verification_challenge FF](gitlab-org/gitlab@d22d27cda511b12cf61abdc82a97b1fad08b1ebc) ([merge request](gitlab-org/gitlab!153934)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](gitlab-org/gitlab@beb4d273e335fea7a1fe549af627a2262e0ed93b) ([merge request](gitlab-org/gitlab!153369))
- [Add and backfill group_id for audit_events_streaming_headers](gitlab-org/gitlab@7c1c96a67f1e4be15277d72869a6c59be32cf6a8) ([merge request](gitlab-org/gitlab!152963))
- [Mark 20230530500000 as obsolete](gitlab-org/gitlab@a426524c271293155b594d85effe78233b0d1ec7) ([merge request](gitlab-org/gitlab!152985)) **GitLab Enterprise Edition**
- [Draft: Add sharding key tracking issues for user_profile](gitlab-org/gitlab@f3296540c6c32ecd7b6f323894ca4567f0a5e153) ([merge request](gitlab-org/gitlab!152835))
- [Update capitalization of beta and experiment in ui](gitlab-org/gitlab@8ea186c824b15a4d345d6f27b9856bbfe4026727) ([merge request](gitlab-org/gitlab!153199))
- [Finalize migration BackfillNugetNormalizedVersion](gitlab-org/gitlab@7a71cbf526f5cd074000795b11238a1aa347864a) ([merge request](gitlab-org/gitlab!151966))
- [Add and backfill group_id for boards_epic_board_labels](gitlab-org/gitlab@67c540ff8357ae28dc2747128d763b9f71faebbe) ([merge request](gitlab-org/gitlab!153674))
- [Fix Layout/ArgumentAlignment offenses 44](gitlab-org/gitlab@65ca72707582b9b448cbb34a25360f603ad28fa6) by @gauravmarwal ([merge request](gitlab-org/gitlab!151240)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](gitlab-org/gitlab@b00d1f3c4fa74590456d5ec27538ecb6df167c2b) ([merge request](gitlab-org/gitlab!151860))
- [Remove the use_only_onboarding_status_db_value feature flag](gitlab-org/gitlab@0004297e19129611e9e02142ac3258661e623196) ([merge request](gitlab-org/gitlab!148879)) **GitLab Enterprise Edition**
- [Resolve Layout/ArgumentAlignment offenses 49](gitlab-org/gitlab@07a5bb742f59352cb1eff205b50bd3f342b4c6e0) by @gauravmarwal ([merge request](gitlab-org/gitlab!151245)) **GitLab Enterprise Edition**
- [Draft: Add sharding key tracking issues for package_registry](gitlab-org/gitlab@3c37e543f7a95bfb53bf9c2a1d0ef5dda64ce630) ([merge request](gitlab-org/gitlab!152743))
- [Resolve Layout/ArgumentAlignment offenses 70](gitlab-org/gitlab@8204acae7dcf5fe171e20172dc7465345f890190) by @gauravmarwal ([merge request](gitlab-org/gitlab!151267))
- [Add and backfill group_id for boards_epic_board_positions](gitlab-org/gitlab@4a050caebe8b17735dd1d7caf7738be779265403) ([merge request](gitlab-org/gitlab!153675))
- [Update validations for Push Mirrors](gitlab-org/gitlab@f51966171a8233deda029156d1a37e365364d909) ([merge request](gitlab-org/gitlab!153087))
- [Quarantine a flaky test](gitlab-org/gitlab@b94cce05710bbc8b50e31fa97780001d4fff2839) ([merge request](gitlab-org/gitlab!152882))
- [Quarantine a flaky test](gitlab-org/gitlab@73588a58d41b9a5e7d3b20d0fdc5f51f6848e248) ([merge request](gitlab-org/gitlab!153508))
- [Fix Layout/SpaceInLambdaLiteral 16 offenses](gitlab-org/gitlab@6ed73dbb0183607f336a4d6ec2e65d135e8a7393) by @archish27 ([merge request](gitlab-org/gitlab!151205)) **GitLab Enterprise Edition**
- [Finalize issue search data backfill migration](gitlab-org/gitlab@d06831a482383e8d1089fe4fcfffdb2c0a1f409e) ([merge request](gitlab-org/gitlab!153277))
- [Resolve Layout/FirstHashElementIndentation 2](gitlab-org/gitlab@ae05d462dac7a1d9a62663f2fa2be0276b13a3b1) by @gauravmarwal ([merge request](gitlab-org/gitlab!151291))
- [Ignore manually created MergeRequestsClosinIssues records](gitlab-org/gitlab@46e30096e6a76b99df1e2460c14a72c42adbb871) ([merge request](gitlab-org/gitlab!151838))
- [Fix Lint/AmbiguousOperatorPrecedence 8 offenses](gitlab-org/gitlab@222585199e76e369cd98b0f9f3551ddfd719e426) by @archish27 ([merge request](gitlab-org/gitlab!151162))
- [Resolve Layout/ArgumentAlignment offenses 67](gitlab-org/gitlab@4c25865c784642286827a01e37db77a02ebc12c8) by @gauravmarwal ([merge request](gitlab-org/gitlab!151264))
- [Mark 20230519142363 as obsolete](gitlab-org/gitlab@3856150d3b9c6180c75c5f6283c6d9ac741365c9) ([merge request](gitlab-org/gitlab!152983)) **GitLab Enterprise Edition**
- [Mark 20230428500000 as obsolete](gitlab-org/gitlab@a7d8c59ab67b030b982418f7d764c736e724406d) ([merge request](gitlab-org/gitlab!152979)) **GitLab Enterprise Edition**
- [Mark 20230613555555 as obsolete](gitlab-org/gitlab@95075e81e793a0447a07a50ca5325892f6493882) ([merge request](gitlab-org/gitlab!152987)) **GitLab Enterprise Edition**
- [Quarantine protected_branches_access_control_ce_shared_examples.rb](gitlab-org/gitlab@233408044e0d519449afcfba7dec0ae4b9e809ce) ([merge request](gitlab-org/gitlab!153446))
- [Draft: Add sharding key tracking issues for feature_flags](gitlab-org/gitlab@2fbf85e3572f35fe420df8823f9f23cb2f80fcbe) ([merge request](gitlab-org/gitlab!152820))
- [Extract GitLab-Shell JWT token verification into a class](gitlab-org/gitlab@d0382fc1b0a31985d1c90f03a6dcf0a7d501fcde) ([merge request](gitlab-org/gitlab!153439))
- [Quarantine a flaky test](gitlab-org/gitlab@06da6dc48d14b93ead0ed53603475e4f79b1c8bc) ([merge request](gitlab-org/gitlab!152883))
- [Quarantine a flaky test](gitlab-org/gitlab@eee04e3b22a2050f79b9099b802b3ecf4a614bfe) ([merge request](gitlab-org/gitlab!151858))
- [Quarantine a flaky test](gitlab-org/gitlab@8b16ea1bc17398d38ddefbc526be36b0d10545ee) ([merge request](gitlab-org/gitlab!151989))
- [Add sharding key tracking issues for source_code_management](gitlab-org/gitlab@85a69d3388728caf7c2bda7d63b31842202edb66) ([merge request](gitlab-org/gitlab!152747))
- [Mark 20230503064300 as obsolete](gitlab-org/gitlab@fe34d3d07fc75d5299e72ae464694e12bf452ab3) ([merge request](gitlab-org/gitlab!152980)) **GitLab Enterprise Edition**
- [Remove Message about moved Pages Menu entry](gitlab-org/gitlab@d92a77f0af301854e24ec9b746f6b206362fccd2) ([merge request](gitlab-org/gitlab!153257))
- [Draft: Add sharding key tracking issues for purchase](gitlab-org/gitlab@1bf5b665f32e404da3382468b4991a70a206708d) ([merge request](gitlab-org/gitlab!152752))
- [Draft: Add sharding key tracking issues for metrics](gitlab-org/gitlab@d3a2e8470cb4c4c75ec8f0151211c495c65a38d3) ([merge request](gitlab-org/gitlab!152813))
- [Draft: Add sharding key tracking issues for consumables_cost_management](gitlab-org/gitlab@3baa713ca92a886b970e51c2c7286b45f4c23e06) ([merge request](gitlab-org/gitlab!152819))
- [Draft: Add sharding key tracking issues for groups_and_projects](gitlab-org/gitlab@eabe708d57b84de3e29d71edd85abfe9895ff026) ([merge request](gitlab-org/gitlab!152834))
- [Draft: Add sharding key tracking issues for compliance_management](gitlab-org/gitlab@8aaf69e7d06d8b458dd3044defe97579b25e6412) ([merge request](gitlab-org/gitlab!152836))
- [Fix Layout/SpaceInLambdaLiteral 12 offenses](gitlab-org/gitlab@bf74284dc1d93a07ba856f63f9eef54c41b6f239) by @archish27 ([merge request](gitlab-org/gitlab!151201)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](gitlab-org/gitlab@17ac5af37b177a781fb17044da5ff15afbabad25) ([merge request](gitlab-org/gitlab!153055))
- [Quarantine a flaky test](gitlab-org/gitlab@7894ed19c4ada6cbcda4b00aa43fe5febacca394) ([merge request](gitlab-org/gitlab!153209))
- [Quarantine a flaky test](gitlab-org/gitlab@64b6a96b2f3995cd3ea912f548ab7274a6d9a3fa) ([merge request](gitlab-org/gitlab!153208))
- [Fix Layout/SpaceInLambdaLiteral 23 offenses](gitlab-org/gitlab@931d68749d68c88d24e575af95505cd3e5a808d6) by @archish27 ([merge request](gitlab-org/gitlab!151212))
- [Remove or_issuable_queries feature flag](gitlab-org/gitlab@4f864f61cfcc271749a315e149ca15c1c0192509) ([merge request](gitlab-org/gitlab!152032))
- [Mark 20230519500012 as obsolete](gitlab-org/gitlab@2cbd325b6d5f9cad29d3b7f2d33b00b66e18efcd) ([merge request](gitlab-org/gitlab!152984)) **GitLab Enterprise Edition**
- [Remove `k8s_watch_api` feature flag](gitlab-org/gitlab@d82a17c636d1d1f3086be46f9248a9bb42c47d45) ([merge request](gitlab-org/gitlab!153176))
- [Mark 20230427555555 as obsolete](gitlab-org/gitlab@e809cec27956acc8c4594c19e8d6b604e8176172) ([merge request](gitlab-org/gitlab!152978)) **GitLab Enterprise Edition**
- [Fix Layout/MultilineOperationIndentation 1 offenses](gitlab-org/gitlab@788304fde199b798fb32eb3fdb2adc6ad77194c3) by @archish27 ([merge request](gitlab-org/gitlab!151225))
- [Remove alpha label](gitlab-org/gitlab@518e312d1c53bbbd0da11e5989ef05c9867882e0) ([merge request](gitlab-org/gitlab!153110)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](gitlab-org/gitlab@f6a9373f68eb8192054b789810fe847677d2ad5e) ([merge request](gitlab-org/gitlab!152569))
- [Remove feature flag "use_remote_mirror_create_service"](gitlab-org/gitlab@6a71cf41fa94570125c0a8cf989598c748a14513) ([merge request](gitlab-org/gitlab!153076))
- [Protected packages: Shorten GraphQL field `protectionRuleExists` Part 2](gitlab-org/gitlab@51b42d6607f5ba41f0a2fb99cef6574a35badc88) by @gerardo-navarro ([merge request](gitlab-org/gitlab!152372))
- [Fix Layout/ArgumentAlignment offenses 16](gitlab-org/gitlab@f64ef53e08a1a34da7c2d1e6884fe5afc82f9c83) by @gauravmarwal ([merge request](gitlab-org/gitlab!151016))
- [Fix Layout/SpaceInLambdaLiteral 17 offenses](gitlab-org/gitlab@ae4eb7f325ac1242948599c99d82d36d77f2ef22) by @archish27 ([merge request](gitlab-org/gitlab!151206)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](gitlab-org/gitlab@28407ef47c050330509253eae74de8e26373e0ad) ([merge request](gitlab-org/gitlab!152880))
- [Quarantine a flaky test](gitlab-org/gitlab@01936c6b34d5b572105ae4446102eee0a9425ee6) ([merge request](gitlab-org/gitlab!153054))
- [Quarantine a flaky test](gitlab-org/gitlab@a36c88810e6a0d1a45c07e2fa9d3a6ae3756d8be) ([merge request](gitlab-org/gitlab!153053))
- [Quarantine a flaky test](gitlab-org/gitlab@c151f91ed74efc88e3d133daff10d0a56f20961a) ([merge request](gitlab-org/gitlab!153052))
- [Quarantine a flaky test](gitlab-org/gitlab@e7805367c6b69580f7c3683205501a0323746f24) ([merge request](gitlab-org/gitlab!153051))
- [Finalize BackupAndRemoveNotesWithNullNoteableType migration](gitlab-org/gitlab@c853e60ec17a81743da08b00b967ece41101cdc8) ([merge request](gitlab-org/gitlab!153029))
- [Fix Layout/SpaceInLambdaLiteral 9 offenses](gitlab-org/gitlab@c1d0fcaf6298064ce0e8fea6f1176c028e17f606) by @archish27 ([merge request](gitlab-org/gitlab!151198))
- [Fix Layout/SpaceInLambdaLiteral 19 offenses](gitlab-org/gitlab@df659810a68a96028fcb4e8cd5f30f215eb4e299) by @archish27 ([merge request](gitlab-org/gitlab!151208))
- [Fix Layout/LineContinuationLeadingSpace 3](gitlab-org/gitlab@05d105f6d4d453dc1a37b538c08fce863f5d6565) by @archish27 ([merge request](gitlab-org/gitlab!150903))
- [Fix Lint/DeprecatedConstants Layout/FirstArgumentIndentation offenses](gitlab-org/gitlab@55625cc1e1e565c5999ab3d99a13caf87ae48849) by @archish27 ([merge request](gitlab-org/gitlab!150913))
- [Add sync index and swap columns](gitlab-org/gitlab@c5a2f1b1bf37aad145be78f95d97bc6567511d7e) ([merge request](gitlab-org/gitlab!152340))
- [Fix Lint/AmbiguousRegexpLiteral 4 offenses](gitlab-org/gitlab@fd9b4af66be3de474797d2f3fd1b2a749c1b05f5) by @archish27 ([merge request](gitlab-org/gitlab!151216))
- [Remove duplicated index from alert_management_http_integrations](gitlab-org/gitlab@d13c032c17d8137c0dcb7ea748f7b25234a994de) ([merge request](gitlab-org/gitlab!152276))
- [Fix Layout/MultilineOperationIndentation 4 offenses](gitlab-org/gitlab@c07f1ebb75b7bca9b63b872a01d691ce55041d3b) by @archish27 ([merge request](gitlab-org/gitlab!151228)) **GitLab Enterprise Edition**
- [Fix Layout/SpaceInsideParens offenses 5](gitlab-org/gitlab@7a1c8b81bf91fd3cc2722120a966a6cfb845993a) by @archish27 ([merge request](gitlab-org/gitlab!150884)) **GitLab Enterprise Edition**
- [Draft: Add sharding key tracking issues for seat_cost_management](gitlab-org/gitlab@e6d781559355157431cc077ae6519dd542f43ca4) ([merge request](gitlab-org/gitlab!150584))
- [Fix Layout/SpaceInLambdaLiteral 6 offenses](gitlab-org/gitlab@a0c02e6c370194573f854cd4cb526aa494eb57d5) by @archish27 ([merge request](gitlab-org/gitlab!151195))
- [Fix Layout/SpaceInLambdaLiteral 21 offenses](gitlab-org/gitlab@be6b65658946b40373bf4fecb201c95512ec8466) by @archish27 ([merge request](gitlab-org/gitlab!151210))
- [Finalize migration BackfillArchivedAndTraversalIdsToVulnerabilityReads](gitlab-org/gitlab@50dfd88245e7b9cb54268dcc0c911fa3a11d26b3) ([merge request](gitlab-org/gitlab!152557))
- [Draft: Add sharding key tracking issues for global_search](gitlab-org/gitlab@f31d314d65bfbb3a280a60e25d08ba1b02bb1ff4) ([merge request](gitlab-org/gitlab!152825))
- [Fix Layout/SpaceInsideParens offenses 4](gitlab-org/gitlab@1444a653e08b0ac71d3881f9bb86413f1a1f1009) by @archish27 ([merge request](gitlab-org/gitlab!150881)) **GitLab Enterprise Edition**
- [Update Node-Express template with an updated code](gitlab-org/gitlab@3cd31a90facda1875f741c612dcc4be53e3335c0) ([merge request](gitlab-org/gitlab!152794))
- [Add and backfill project_id for approval_project_rules_users](gitlab-org/gitlab@25e85ddf7b58f50d901c2ebfc23bc7bea5f09af8) ([merge request](gitlab-org/gitlab!151631))
- [Finalize BackfillEpicBasicFieldsToWorkItemRecord background migration](gitlab-org/gitlab@0dc9f193fd937e7460c35724b547f407facb1b57) ([merge request](gitlab-org/gitlab!152625))
- [Draft: Add sharding key tracking issues for deployment_management](gitlab-org/gitlab@75819cfecf5c1a8d838b09d63bcb795599fe40b4) ([merge request](gitlab-org/gitlab!152750))
- [Draft: Add sharding key tracking issues for release_orchestration](gitlab-org/gitlab@d37159ab8fa3de59b368717172320d9105444e51) ([merge request](gitlab-org/gitlab!152746))
- [Quarantine a flaky test](gitlab-org/gitlab@a65316435e9600930adec58e771d44a8372b52dd) ([merge request](gitlab-org/gitlab!152465))
- [Quarantine a flaky test](gitlab-org/gitlab@d971d2ee17c42a5f968b707f0624b3f16a3d7aad) ([merge request](gitlab-org/gitlab!152568))
- [Resolve Layout/FirstHashElementIndentation 14](gitlab-org/gitlab@04ce7b44f76c0794834823dcb620431c98d91e3d) by @gauravmarwal ([merge request](gitlab-org/gitlab!151233))
- [Resolve Layout/FirstHashElementIndentation 1](gitlab-org/gitlab@33f95cd22335ca57afae898ee98257615e54fd52) by @gauravmarwal ([merge request](gitlab-org/gitlab!151290))
- [Resolve Layout/ArgumentAlignment offenses 87](gitlab-org/gitlab@132497023bc81790e9c57395d397116c4cb8e3b6) by @gauravmarwal ([merge request](gitlab-org/gitlab!151288))
- [Resolve Layout/ArgumentAlignment offenses 84](gitlab-org/gitlab@f0cb9655c5bb02234c439b441d14defe856df307) by @gauravmarwal ([merge request](gitlab-org/gitlab!151282))
- [Quarantine a flaky test](gitlab-org/gitlab@9da8e35f11374721829e64ece361b373f48686df) ([merge request](gitlab-org/gitlab!152692))
- [Resolve Layout/ArgumentAlignment offenses 81](gitlab-org/gitlab@80501c0f4d6598d3f3972aba758771e841566ec4) by @gauravmarwal ([merge request](gitlab-org/gitlab!151279))
- [Resolve Layout/ArgumentAlignment offenses 77](gitlab-org/gitlab@2135520d1b1ac4dfb1485e06c4dcb3e438b69c66) by @gauravmarwal ([merge request](gitlab-org/gitlab!151274))
- [Resolve Layout/ArgumentAlignment offenses 69](gitlab-org/gitlab@894ae44be3b9f4dd9d7e07a4afdde02370967096) by @gauravmarwal ([merge request](gitlab-org/gitlab!151266))
- [Quarantine a flaky test](gitlab-org/gitlab@e32f26dc31a54bfc39afbc5ccc86a397957b26b9) ([merge request](gitlab-org/gitlab!152683))
- [Quarantine a flaky test](gitlab-org/gitlab@879b12099c9d8395da6344e51c5a345d62abef2a) ([merge request](gitlab-org/gitlab!152682))
- [Quarantine a flaky test](gitlab-org/gitlab@de48ec05e437c199bcd9de8bdc8dd366044a38b0) ([merge request](gitlab-org/gitlab!152681))
- [Remove disable_developer_access_to_admin_vulnerability feature flag](gitlab-org/gitlab@4848f3f37a2d4ba902a69f5ab6e44a79ba240a2c) ([merge request](gitlab-org/gitlab!150336)) **GitLab Enterprise Edition**
- [Remove autovacuum skip for ci_builds related BBMs](gitlab-org/gitlab@d987bdaee20acc23033a2f447f4bf9560384ecb1) ([merge request](gitlab-org/gitlab!152614))
- [Remove pool_key label in connection pool metrics](gitlab-org/gitlab@48275615a1db67526cb49fb52e88cdb03050b78b) ([merge request](gitlab-org/gitlab!152574))
- [Fix Layout/ArgumentAlignment offenses 4](gitlab-org/gitlab@763a40762fb7809c45fbc656d403efbbfa5c2fac) by @gauravmarwal ([merge request](gitlab-org/gitlab!150961))
- [Quarantine a flaky test](gitlab-org/gitlab@a58a971bbc062c4e8334c9108ee453662f047373) ([merge request](gitlab-org/gitlab!152136))
- [Fix Layout/ArgumentAlignment offenses 11](gitlab-org/gitlab@bdb7e15aedd739dd188fd6d6fa30c0dc3480e45a) by @gauravmarwal ([merge request](gitlab-org/gitlab!151002))
- [Add and backfill project_id for approval_merge_request_rules](gitlab-org/gitlab@40f94b7aad59e1536b7b30d0cfed050d35758d56) ([merge request](gitlab-org/gitlab!151630))
- [Fix Lint/SymbolConversion 4 offenses](gitlab-org/gitlab@b5fcf0f1aa4aeff41242dd7fb01d1a2d30a5cbcf) by @archish27 ([merge request](gitlab-org/gitlab!151185))
- [Fix Layout/FirstArrayElementIndentation 2 offenses](gitlab-org/gitlab@239ad2e2187253b2e03265571671527210a8adb2) by @archish27 ([merge request](gitlab-org/gitlab!151170)) **GitLab Enterprise Edition**

### fix (1 change)

- [Update Web IDE dependency to receive duo fixes](gitlab-org/gitlab@47323c05565dd32ea4de9f999adbd9f7aa8748e3) ([merge request](gitlab-org/gitlab!154064))

## 17.0.6 (2024-08-06)

### Changed (1 change)

- [Put groups_direct field in CI JWT tokens behind feature flag](https://gitlab.com/gitlab-org/security/gitlab/-/commit/106d8bbe3b70f99f52963ac363764f4eb6abd5c1)

### Security (13 changes)

- [Show correct file content](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a1fa5a60d3f8b4d420e65baaf9eb631e2fa9bdf0) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4336))
- [Fix Possible asciidoctor include:: directive DOS](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8d03c5769e39605f00c930d0fb7b9baab2b6ae5c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4331))
- [Filter parameters in Rack::Attack logs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9ee1310ad76bceb5f45cb04ea4534c71efa90255) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4274))
- [Update audit payload](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6e11e37c02cf10887a49e2ee494fec7efe37d944) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4327))
- [Limit access to project accessed by Security Policy Bot](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3c4c9a4adf772993f42b4788303180d36fb8642d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4345))
- [Show alert about not rendering files due to path encoding](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d939235f3042ff0924e4a794cf0481bc28e08ae3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4339))
- [Fix the catastrophic backtracking](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7397896f34a4d0319a7750ae7f0a32aa2dad72c6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4291))
- [Security fixes for banzai pipeline part 2](https://gitlab.com/gitlab-org/security/gitlab/-/commit/40cf9d179ad038363b59eb0accfd1fa2e6bef34b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4281))
- [Remove xhtml extensions from snippets blobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4952960acf3b3b133c29454375fcbb1e3850ee44) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4332))
- [Add a project scope to LfsTokens](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cbe4a50b5844d452f12e58dab80143c7e548d273) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4321))
- [Fix ReDoS when parsing git push options](https://gitlab.com/gitlab-org/security/gitlab/-/commit/14b95bf425bf27746f73ec813753355919346b82) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4314))
- [Fix ReDoS in RefMatcher](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fdab3bdb907212a736b961ed58f5ad4d52135108) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4317))
- [Enforce `require_password_to_approve` MR approval policy property](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2d7c6114a6915143751f40e44ef2630647cf615a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4261))

## 17.0.5 (2024-07-24)

### Added (1 change)

- [Add Rake task to show token expiration info](https://gitlab.com/gitlab-org/security/gitlab/-/commit/10f23572a1c4aca31a9e3a9eb9f5546fe5353dfe)

### Fixed (1 change)

- [Ignore object pool already exists creation errors](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f34b4a189ab52c96b69716b3b02290c11e67ff42)

### Security (7 changes)

- [Refactor import_export_upload to be user-based](https://gitlab.com/gitlab-org/security/gitlab/-/commit/762b76f8c82061702e4854b978462f8f5f915a4d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4265))
- [Fix for private txt artifacts being accessible through the artifacts/browse link](https://gitlab.com/gitlab-org/security/gitlab/-/commit/502b678220abbc1427d2c9320d6e26deb4084234) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4292))
- [Attribute BulkImport::Export to a particular user](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bc6479e121222a51d8281b445626959732880f67) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4286))
- [Don't include project-level analytics settings in DOM](https://gitlab.com/gitlab-org/security/gitlab/-/commit/60d862aa715e1692942faaa8fa4ecf719e05407e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4131))
- [Fix for private dotenv artifacts not accessible to downstream jobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7be78d4cf575453967f23b09054551299841fd8a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4243))
- [Do not allow script execution on dependency responses](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1afc21105ee1285c40a701edf729bb2a247c1438) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4255))
- [Remove prohibited tags after import](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a3b8343e3ef3fd0025db94a8b8d14006d821b831) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4250))

## 17.0.4 (2024-07-09)

### Fixed (1 change)

- [Update dependency slack-messenger to v2.3.5](gitlab-org/security/gitlab@8800f576925de4fcf00d46f707a70e1e81e5f00a)

### Security (9 changes)

- [Disallow serving Pages over disabled custom domains with deployments](gitlab-org/security/gitlab@760d6115e963e744ee55230be45e9fc3c138a73d) ([merge request](gitlab-org/security/gitlab!4248))
- [Check npm package name, version and scripts coherence](gitlab-org/security/gitlab@f3b322c5e20036e380ac15b3b2614d9bcc800e75) ([merge request](gitlab-org/security/gitlab!4158))
- [Check for create_deploy_token policy before creating deploy token](gitlab-org/security/gitlab@87ab0448c48a0ac45540986f4f7429cbc0db3e04) ([merge request](gitlab-org/security/gitlab!4168))
- [Check if user has ban_group_member access before banning in namespace](gitlab-org/security/gitlab@1b69ccb4a7e7e16372a926d7e2954aec76cdc0fd) ([merge request](gitlab-org/security/gitlab!4087))
- [Prevent privilege escalation via custom role](gitlab-org/security/gitlab@288e1493a3c16689993d7cbbd7f60cd9bdeffcc0) ([merge request](gitlab-org/security/gitlab!4198))
- [Prevent using quick actions for some bot users](gitlab-org/security/gitlab@5b8aef69fc74e5aba42d65591902a151a1654316) ([merge request](gitlab-org/security/gitlab!4232))
- [Disable raw HTML for quick action pipeline](gitlab-org/security/gitlab@0ca2b123f1f627e68b73a1699fbefbb4a70c28d1) ([merge request](gitlab-org/security/gitlab!4236))
- [Disable quick actions unless description changed](gitlab-org/security/gitlab@9e5397fbd82497083cd69f526a13caea1b5efd21) ([merge request](gitlab-org/security/gitlab!4239))
- [Remove comment support from shrug and tableflip](gitlab-org/security/gitlab@e378c24c4a1a8dd323bd157bce29b21cca1e0701) ([merge request](gitlab-org/security/gitlab!4228))

## 17.0.3 (2024-06-25)

### Fixed (5 changes)

- [Only enumerate commits in pre-receive check if push came from Web](gitlab-org/security/gitlab@fd87b2983859ab11a131febccdea4945a5fd73bb)
- [Only allow documented token types for GraphQL authentication](gitlab-org/security/gitlab@b1d1a51dfd983646ad3fbf4c22e55cf323dcb9e5)
- [Fix error when calling GQL ciConfig endpoint with include:component](gitlab-org/security/gitlab@c20626b033fbae85138bb303b29286e6b47229ac)
- [Update an expired test certificate](gitlab-org/security/gitlab@d21feaf61f993b889af7485289239fef62c84267)
- [Fix missing filename when downloading generic package in release page](gitlab-org/security/gitlab@6254d8691b2cfb9ee2f656424c98f29882e8d36d)

### Changed (1 change)

- [Add a banner informing about token expiration](gitlab-org/security/gitlab@06c6e4bc40bfe359ebabf0046394211d04f995c9)

### Security (14 changes)

- [Security fixes for banzai pipeline](gitlab-org/security/gitlab@04cbf788c8a0fb668d47692f44dd5abbc1ee3230) ([merge request](gitlab-org/security/gitlab!4183))
- [Fix the catastrophic backtracking in openapi regex](gitlab-org/security/gitlab@3994786908e1a966616069fdb263e2840126a8b0) ([merge request](gitlab-org/security/gitlab!4143))
- [Use permitted_params for standalone and multiplex queries](gitlab-org/security/gitlab@cc0c469450103d6f6d97dd8fe571e80bfe6f9f89) ([merge request](gitlab-org/security/gitlab!4149))
- [Fix for Private job artifacts can be accessed by any user](gitlab-org/security/gitlab@95756b0b374a618477b2f2fbd1b9a41d61786f12) ([merge request](gitlab-org/security/gitlab!4195))
- [Remove search results from public projects with unauthorized repos](gitlab-org/security/gitlab@9bc323c63aeb0811786b9ebb916645da6a4a49f3) ([merge request](gitlab-org/security/gitlab!4074))
- [Do not run a new pipeline on re-target](gitlab-org/security/gitlab@5da8934f84edaa663910eaa104b657086bfa9a18) ([merge request](gitlab-org/security/gitlab!4188))
- [Add limits on autolinker regex](gitlab-org/security/gitlab@d930c4bb3cc692c821eee6df82fc3567eb4ccb53) ([merge request](gitlab-org/security/gitlab!4127))
- [Fix clickjacking on OAuth application page](gitlab-org/security/gitlab@0d7cd1b4ea7c28030c52306710c9f88a5bb6382e) ([merge request](gitlab-org/security/gitlab!4062))
- [Hide branch merge request if merge requests are private](gitlab-org/security/gitlab@323293651d6e441bf719b54494180f8c37bb2c05) ([merge request](gitlab-org/security/gitlab!4201))
- [Remove collapseLongCommitList method](gitlab-org/security/gitlab@c40bfcd824d029a8ff7bec05e294337e8a7dcc05) ([merge request](gitlab-org/security/gitlab!4204))
- [Pass SSO session data to Sidekiq](gitlab-org/security/gitlab@a189575f905a48e85f06865f0e10d8d15c00e303) ([merge request](gitlab-org/security/gitlab!4160))
- [Prevent non-members from using promote_to quick action for quick actions](gitlab-org/security/gitlab@0335cfbb28fab459c8cbba8ec3d2ca9a3127947c) ([merge request](gitlab-org/security/gitlab!4157))
- [Reject deletion of security policy project approval rules](gitlab-org/security/gitlab@fedbaa529d358e72f299fd94b263ce39cfd55fe2) ([merge request](gitlab-org/security/gitlab!4105))
- [Mitigate ReDoS attacks via `method_call_regex`](gitlab-org/security/gitlab@dba917caf0103a2247949eaa31389458c44e2190) ([merge request](gitlab-org/security/gitlab!4163))

## 17.0.2 (2024-06-11)

### Fixed (1 change)

- [Fix instance templates pagination](gitlab-org/security/gitlab@d53fb868885472d0b7645afabee590f416eda0d5) **GitLab Enterprise Edition**

### Changed (1 change)

- [Only query the fields needed](gitlab-org/security/gitlab@74794d45373cf605d7c036cc0ab13a3d5018c616)

### Security (4 changes)

- [XSS and content injection raw XHTML files on IOS devices](gitlab-org/security/gitlab@7459916b867b01581b3422fd065419feb6352180) ([merge request](gitlab-org/security/gitlab!4093))
- [Improve go_package_regex to prevent ReDoS attacks](gitlab-org/security/gitlab@45ccd851058bf319f7795e88afcb27c1440c24e9) ([merge request](gitlab-org/security/gitlab!4096))
- [Fix ReDoS in CI Interpolation](gitlab-org/security/gitlab@11be5651e849441813c022bc492e6549e9ed297d) ([merge request](gitlab-org/security/gitlab!4081))
- [Verify Asana access token when testing Asana integration](gitlab-org/security/gitlab@c35fb1ce0e58b8e90bc61b7d48949572fca6705c) ([merge request](gitlab-org/security/gitlab!4059))

## 17.0.1 (2024-05-21)

### Fixed (2 changes)

- [Don't fail so loudly if default work item type is invalid](gitlab-org/security/gitlab@c0817a7654e3fb68e1cc89e19599fd16ff63f121)
- [Ensure BLPOP/BRPOP returns nil instead of raising ReadTimeoutError](gitlab-org/security/gitlab@9a0c5c69aa9d54aaae8ceb1698c7fbae0aa74694)

### Security (7 changes)

- [Prevent PDF.js from evaluating scripts](gitlab-org/security/gitlab@2820f31998ca2dcf61eb4b6893b615cebb503b07) ([merge request](gitlab-org/security/gitlab!4069))
- [Caching test_report api response to reduce calculations](gitlab-org/security/gitlab@b64b0178e955d5091dfaf47b632af266165a5a2e) ([merge request](gitlab-org/security/gitlab!4051))
- [Restrict access to Secure artifacts to developer role](gitlab-org/security/gitlab@5dd7b7377e0d33dd635fedca66e4aefd5bdf7c7e) ([merge request](gitlab-org/security/gitlab!4053))
- [Fail create commit status on pipeline_id / sha mismatch](gitlab-org/security/gitlab@460dd3c803da58973d2a4597581c42f4f82e76cc) ([merge request](gitlab-org/security/gitlab!4049))
- [Use UntrustedRegexp for gollum pattern](gitlab-org/security/gitlab@b5499fca0fa5ac226f97665168562a9f93465525) ([merge request](gitlab-org/security/gitlab!4039))
- [Patch @gitlab/web-ide to fix XSS webWorkerExtensionHostIframe.html](gitlab-org/security/gitlab@c848b946ee4867332692d15e6c27e8efaf37ae53) ([merge request](gitlab-org/security/gitlab!4055))
- [Add text limit to ci_runners text fields](gitlab-org/security/gitlab@20cf74de115473a32bb3c1e3d52e3c7b8f31b3f9) ([merge request](gitlab-org/security/gitlab!4050))

## 17.0.0 (2024-05-15)

### Added (164 changes)

- [Add more actions to work item sticky header](gitlab-org/gitlab@d652db2e95244d18fd9e7d17e4ad92b586b8ddb6) ([merge request](gitlab-org/gitlab!152156))
- [Expose webhook name and description fields in API](gitlab-org/gitlab@3c3e42b2e6f43450667edd0892c66965035b3982) ([merge request](gitlab-org/gitlab!152497))
- [Expose VSA metrics via GraphQL](gitlab-org/gitlab@d45e601964aef8557d289a13c3b40a9f5b1431ac) ([merge request](gitlab-org/gitlab!152029))
- [Update project policy to use admin_push_rules](gitlab-org/gitlab@67b51d054820e891425f880be9981ecbae615196) ([merge request](gitlab-org/gitlab!150415)) **GitLab Enterprise Edition**
- [Document migration to multiple databases for Streaming Replication setup](gitlab-org/gitlab@7c845587e022488153d95b213bbe9e308f648844) ([merge request](gitlab-org/gitlab!152389))
- [Auto assign the new members a duo pro seat](gitlab-org/gitlab@6f42311253eb9005109849c3aafd2681f69a9cfb) ([merge request](gitlab-org/gitlab!152058)) **GitLab Enterprise Edition**
- [Augment GCS signed URLs with GitLab metadata for package registry](gitlab-org/gitlab@e03f6750463a4783165463b7df7241013b7cf863) ([merge request](gitlab-org/gitlab!147207))
- [Add automatic color mode](gitlab-org/gitlab@d57d070fd9e07f672cd5fb20f6a3ca6c9cf22aa6) ([merge request](gitlab-org/gitlab!150254))
- [Enable ai_gateway_docs_search as beta feature](gitlab-org/gitlab@4825c14339231ab0123ad41e63ad8f639441a5a8) ([merge request](gitlab-org/gitlab!152581)) **GitLab Enterprise Edition**
- [Set imported_from for Direct Transfer objects](gitlab-org/gitlab@798ba98818bfaeea1d0982a6e21fd9b2ac077fc8) ([merge request](gitlab-org/gitlab!152576))
- [Adding create and delete apis for group namespace filters](gitlab-org/gitlab@1395a790daa3719e560a46b63df46506a08ead27) ([merge request](gitlab-org/gitlab!150712)) **GitLab Enterprise Edition**
- [Cleanup default_branch_protection_defaults feature flag](gitlab-org/gitlab@78af3a7af2823e3de3ec588ee5e4ca9bb0c63709) ([merge request](gitlab-org/gitlab!152543))
- [Warn when pages multiple deployments is disabled](gitlab-org/gitlab@903fdde47300c27cd1aad69141cf19b7a8f7d57c) ([merge request](gitlab-org/gitlab!150750)) **GitLab Enterprise Edition**
- [Add admin_web_hook ability to custom roles](gitlab-org/gitlab@984a60ababeb79b1e965173e86cabb894a0dd74f) ([merge request](gitlab-org/gitlab!151551)) **GitLab Enterprise Edition**
- [Add new params in protected branch creation](gitlab-org/gitlab@ba25cab465f14ccd9da05984d2fb45846a9c4e13) ([merge request](gitlab-org/gitlab!152346)) **GitLab Enterprise Edition**
- [Add reassigned_by_user to import_source_users](gitlab-org/gitlab@e758f0391f29d3ef369efd21c6c4904b85c4a36b) ([merge request](gitlab-org/gitlab!152199))
- [Migrate Value streams dashboard to shared analytics dashboards](gitlab-org/gitlab@5bed304fe361a7ca8907751c9a4bad92d4d9eb40) ([merge request](gitlab-org/gitlab!151845))
- [Enable approval_policy_disable_bot_comment by default](gitlab-org/gitlab@5f6effd9ddc5c1593e5c872560eae59e508914e5) ([merge request](gitlab-org/gitlab!152353)) **GitLab Enterprise Edition**
- [Add creator relationship to namespaces](gitlab-org/gitlab@d1031c0436f140af4b2fbd5377e6f480aba20ddd) ([merge request](gitlab-org/gitlab!150051))
- [Add mutation for clearing project runner cache](gitlab-org/gitlab@f49431f78892a799eac12981e1a82ee1c0681d40) ([merge request](gitlab-org/gitlab!151768))
- [Enables external participants for Service Desk](gitlab-org/gitlab@b76b97fd0562d3b4dff80805b4bb9b477de0e730) ([merge request](gitlab-org/gitlab!152083))
- [Add tooltip with raw counts to AI usage rate values in AI Impact table](gitlab-org/gitlab@4eb18ffa8f77eea133d2cc8431fcb570e5e8e639) ([merge request](gitlab-org/gitlab!151955)) **GitLab Enterprise Edition**
- [Expose imported status for relevant entities](gitlab-org/gitlab@5615f8c9c945f6cc8ddd472b9865f38630fa6d0e) ([merge request](gitlab-org/gitlab!150038))
- [Update project_saved_replies_flag to default `true`](gitlab-org/gitlab@e4b48d64355c10820514a7e82cac74903952ae94) ([merge request](gitlab-org/gitlab!152219)) **GitLab Enterprise Edition**
- [Delete users unconfirmed secondary emails after 3 days](gitlab-org/gitlab@99aecbaacd332abc7f3a94adc7b07fa3a6995955) ([merge request](gitlab-org/gitlab!151562))
- [Add labels and assignees widgets to work items create mutation](gitlab-org/gitlab@36e62e5e1da20411eeba574c86443735441b0df7) ([merge request](gitlab-org/gitlab!150160))
- [Allow additional parameter: published_at for sorting](gitlab-org/gitlab@042d11edfe85ffe2f5a05f95f05d3184d4d5da5b) ([merge request](gitlab-org/gitlab!151638))
- [Expose last_published_at field from API](gitlab-org/gitlab@d1bb5e23ac3b7ee720795402efe9f2206550281c) ([merge request](gitlab-org/gitlab!151506))
- [Add a worker to remove stuck canceling jobs](gitlab-org/gitlab@bc5d68d7728d22048054243d9e194b9aed7fb32e) ([merge request](gitlab-org/gitlab!152203))
- [Bypass secrets check via push option](gitlab-org/gitlab@7003122dcd624bd264a8dcd4d402859cdfdbb7c7) ([merge request](gitlab-org/gitlab!151468))
- [Implement default branch protection defaults](gitlab-org/gitlab@e29376834096c1128fc3c48a160c21e017e87087) ([merge request](gitlab-org/gitlab!148349))
- [Adds Phorge logo](gitlab-org/gitlab@7ca2d4b09b4a78c7f6b8f29d544f57b5b7559947) ([merge request](gitlab-org/gitlab!152165))
- [Organization owner project permissions](gitlab-org/gitlab@b5047f04c96942db6202dd738a23d7cb852d8acb) ([merge request](gitlab-org/gitlab!147762))
- [Add BranchRuleExternalStatusCheckDestroy mutation](gitlab-org/gitlab@e15d0923ff7bef20e92c38cba426aca25c64ea5a) ([merge request](gitlab-org/gitlab!151581)) **GitLab Enterprise Edition**
- [Adds templating functionality to new participant email](gitlab-org/gitlab@2b2f7ddd62a5285eaff109b2680592be439ea61b) ([merge request](gitlab-org/gitlab!151799))
- [Add gql option to ciCatalogResources to sort by usage](gitlab-org/gitlab@92e666f9724becad976c3e376b05d3e781568439) ([merge request](gitlab-org/gitlab!151977))
- [Adding aws audit event destination validator](gitlab-org/gitlab@9853a6f8b5c2b45124cce206e9188a19c6f8f64f) ([merge request](gitlab-org/gitlab!151659)) **GitLab Enterprise Edition**
- [Protected packages: Show protection info in package detail page](gitlab-org/gitlab@a51abf496663b6fca7c32bc71e2a83beba8e2d6e) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146206))
- [Add scan result policy deprecated warning](gitlab-org/gitlab@44e7ab7a3d50adf3306601f87e6873869f7393dd) ([merge request](gitlab-org/gitlab!151582)) **GitLab Enterprise Edition**
- [Add imported_from column](gitlab-org/gitlab@e81a28a8c2f5dd03523d93f3c6a900b978fbd86b) ([merge request](gitlab-org/gitlab!151782))
- [Backfill work items for epics](gitlab-org/gitlab@2690fab8d8631e66c571698a9dcf664f251668b1) ([merge request](gitlab-org/gitlab!143844))
- [Clean up auto_request_phone_number_verification_exemption feature flag](gitlab-org/gitlab@63198f153151d6903dc91cf780d00d25d93f81f7) ([merge request](gitlab-org/gitlab!151333)) **GitLab Enterprise Edition**
- [Support rules:exists subkeys `paths`, `project`, and `ref`](gitlab-org/gitlab@a51888f0caf542d69c9299a20ae69a108724e14a) ([merge request](gitlab-org/gitlab!151719))
- [Allow group owners to enable duo pro auto assign](gitlab-org/gitlab@c9b766c31d56666aadf562e0d545927603ed63de) ([merge request](gitlab-org/gitlab!151511)) **GitLab Enterprise Edition**
- [Roll out deployment details page](gitlab-org/gitlab@67e63b2240e1480f8c0454317f16a9a545d6d7ab) ([merge request](gitlab-org/gitlab!151680))
- [Add validation error to input](gitlab-org/gitlab@072e0fc972c5b6b4b6fe43b640da776a4141d49c) ([merge request](gitlab-org/gitlab!151373)) **GitLab Enterprise Edition**
- [Protected packages: Use icon only for delete rule button](gitlab-org/gitlab@9c652e00e140f82e0d0b52ef19a8acc0061e82b5) by @gerardo-navarro ([merge request](gitlab-org/gitlab!151797))
- [Adds `Beta` badge for analytics dashboards](gitlab-org/gitlab@e0c03ead4ef216c60b9bf612d7f5bd0468e6d2bb) ([merge request](gitlab-org/gitlab!151398)) **GitLab Enterprise Edition**
- [Secrets push check uses project level settings](gitlab-org/gitlab@2fbff3c8072b9decbfe27039d2459fd0d5a343e0) ([merge request](gitlab-org/gitlab!150760))
- [This MR adds drawer for pipeline execution](gitlab-org/gitlab@9ef6bb813ed0efe06185d2788f8121ba9bdd91da) ([merge request](gitlab-org/gitlab!149306)) **GitLab Enterprise Edition**
- [Index `vulnerability_reads` for common group-level queries](gitlab-org/gitlab@7b3f0c3048bb95e1b0d749213db62d5be98e6d2b) ([merge request](gitlab-org/gitlab!151770))
- [Add status to Ci::Partition](gitlab-org/gitlab@ee2a1b38b7f5c32c89d75b99897138dc500cc3bc) ([merge request](gitlab-org/gitlab!150443))
- [Make view Jira issues configurable via API](gitlab-org/gitlab@9cd88e31d4c3615a20155c0ec6e441134a6ee4cc) by @ivantedja ([merge request](gitlab-org/gitlab!150209))
- [Add Update avatar api endpoint for current user](gitlab-org/gitlab@9b25a4eebdf4ce60212c40e3d637d249fd518a77) by @lifez ([merge request](gitlab-org/gitlab!148130))
- [Add audit event for deleting web hooks](gitlab-org/gitlab@727046f543953ae4097a07368e76eae444cf0f55) ([merge request](gitlab-org/gitlab!151304)) **GitLab Enterprise Edition**
- [Add silent_admin_exports_enabled setting](gitlab-org/gitlab@fb01914fa56fe12de72861e5f54aef4db6988fc9) ([merge request](gitlab-org/gitlab!148918))
- [Allow groups to be added to the inbound allowlist](gitlab-org/gitlab@84d8663540bfd7517081ae903d482d5e0e1e4ca6) ([merge request](gitlab-org/gitlab!151693))
- [Support deep linking to search results on the CI/CD catalogue page](gitlab-org/gitlab@41cc3db73e3290698afe59cc73e9b463ba31d5b5) by @espadav8 ([merge request](gitlab-org/gitlab!151653))
- [Add setting for enabling CS for Registry](gitlab-org/gitlab@e989696a061ba5b2875b0e98051d9531ebd7d156) ([merge request](gitlab-org/gitlab!148242)) **GitLab Enterprise Edition**
- [Create BranchRuleExternalStatusCheckUpdate mutation](gitlab-org/gitlab@eb3803b5102ee9b07bd7657b1a2edce4a550bd7a) ([merge request](gitlab-org/gitlab!149941)) **GitLab Enterprise Edition**
- [Added validation of http destinations](gitlab-org/gitlab@6d66364c3130231be5a0ba3016320b7360c757fd) ([merge request](gitlab-org/gitlab!150669)) **GitLab Enterprise Edition**
- [Add empty states for deployment approvals](gitlab-org/gitlab@cdfed1db2e23b226bb5d2b741bed1373bb2fa1d7) ([merge request](gitlab-org/gitlab!150920)) **GitLab Enterprise Edition**
- [Finalize `BackfillVulnerabilityReadsClusterAgent` migration](gitlab-org/gitlab@d6dcfeb48f1e3f0994fcb8151a959b32d6ceb6a4) ([merge request](gitlab-org/gitlab!151519))
- [Add achievementsPath to NamespaceType for graphql](gitlab-org/gitlab@18ef59e452fcdd3db93b11fdd87507548948e8a0) by @ChaelCodes ([merge request](gitlab-org/gitlab!150906))
- [Add UI components for Beyond Identity check exclusions](gitlab-org/gitlab@2699b4b70c2d963f011d066aeca1c65ab6cc3d02) ([merge request](gitlab-org/gitlab!150664))
- [Add `status` field to CustomizableDashboard GraphQL API](gitlab-org/gitlab@261c0ad14a37f86e8350b46aa8dfbf76375bbb19) ([merge request](gitlab-org/gitlab!149914)) **GitLab Enterprise Edition**
- [Add support for ordering group runners by most active](gitlab-org/gitlab@e4ab7af64ff50f0a50c36b8a7a653f246bf9250a) ([merge request](gitlab-org/gitlab!150788))
- [Added CreateService](gitlab-org/gitlab@98cd3de0e3170d261d0a2dd714697fb34baebc97) ([merge request](gitlab-org/gitlab!149136)) **GitLab Enterprise Edition**
- [Add manual_confirmation](gitlab-org/gitlab@2635e5f35e6d1b0b32b36e736f604afd5aeef930) by @lifez ([merge request](gitlab-org/gitlab!148778))
- [Frontend work for regex filter on Zoekt code search](gitlab-org/gitlab@4d4ae099c367e1aa304eb519679d1f29af45ecf7) ([merge request](gitlab-org/gitlab!149838))
- [Remove "update_changelog_logic" FF](gitlab-org/gitlab@d9e9ba469ef9ff7af8a807440a92c7de6abc65a7) ([merge request](gitlab-org/gitlab!146610))
- [Limit the number of active versioned pages deployments](gitlab-org/gitlab@8c87749593710d4d7fd2c4de48a000286adc96dc) ([merge request](gitlab-org/gitlab!149161))
- [Added model for instance namespace filters](gitlab-org/gitlab@5caaa35c11992913171be826f64f977b837e8dcc) ([merge request](gitlab-org/gitlab!148448)) **GitLab Enterprise Edition**
- [Sort labels by relevance on search](gitlab-org/gitlab@35257e78b540bfd1325db4edd4d9e6f93dfd647f) ([merge request](gitlab-org/gitlab!151091))
- [Add VerifyNamespaceService to change validation_level](gitlab-org/gitlab@d335dba721c5e59a82efc537e00db63ea64d5a97) ([merge request](gitlab-org/gitlab!149532))
- [Synch add tmp indexes for `vulnerability_occurrences` backfill](gitlab-org/gitlab@0d2cc271f2e4412c5d85c76eee2436a0c6689c9f) ([merge request](gitlab-org/gitlab!148514))
- [Adds support to filter packages by status](gitlab-org/gitlab@c88bcf88f71da9339a187634a258821ac963ae59) ([merge request](gitlab-org/gitlab!150322))
- [Rate limit internal X-Ray scan API endpoint](gitlab-org/gitlab@1e5cb32ef94f01a93a4c00ed71cc1a6f54bfc16d) ([merge request](gitlab-org/gitlab!150636)) **GitLab Enterprise Edition**
- [Clean up arkose_labs_signup_data_exchange feature flag](gitlab-org/gitlab@1c60af1fffe502e29957b8466f8baf2d8fbbb868) ([merge request](gitlab-org/gitlab!150949)) **GitLab Enterprise Edition**
- [Create partitioned merge_request_diff_files_* table](gitlab-org/gitlab@aaa74a411b8a1819b64fea42bd91f34104d1065f) ([merge request](gitlab-org/gitlab!149181))
- [Add pipeline source check for security_policy_default](gitlab-org/gitlab@7a5493c70c81633a192686d991e9299bb5bb441f) ([merge request](gitlab-org/gitlab!150918)) **GitLab Enterprise Edition**
- [This MR adds pipeline execution queries](gitlab-org/gitlab@cc08c78055863fdfa58e60496643521d16680ab8) ([merge request](gitlab-org/gitlab!149145)) **GitLab Enterprise Edition**
- [Adds system note when external participant unsubscribes](gitlab-org/gitlab@141568321fcf56d95a0fe91527633ecfbda505f0) ([merge request](gitlab-org/gitlab!142287))
- [Add Bitbucket Cloud Import API](gitlab-org/gitlab@512a41c2ce3f5b551a88f3cc3b7166860508fcdf) ([merge request](gitlab-org/gitlab!150016))
- [Add enable_auto_assign_gitlab_duo_pro_seats setting](gitlab-org/gitlab@4d8c131a60c9db9c88ce2ef43ef167d9fc6b6b5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150824)) **GitLab Enterprise Edition**
- [Add support to list child pipelines in project](gitlab-org/gitlab@92dff8bf24e96e4195a8a731e92df3fab6066257) ([merge request](gitlab-org/gitlab!149839))
- [Default enable approval_policy_parent_child_pipeline](gitlab-org/gitlab@9267b661442953c0159917bdae0c8803eebc2713) ([merge request](gitlab-org/gitlab!150826)) **GitLab Enterprise Edition**
- [Finish value stream stages read GraphQL API](gitlab-org/gitlab@f107106d529321ab522e1a88137ecc24f92daba6) ([merge request](gitlab-org/gitlab!149819)) **GitLab Enterprise Edition**
- [Support X-Original-To headers for email ingestion](gitlab-org/gitlab@f52e4fb91b967530c61fba6df94aadfb6614c672) ([merge request](gitlab-org/gitlab!149874))
- [Support banned projects in VisibilityIcon component](gitlab-org/gitlab@b36144584252e22c674631ab7c36af85ea8e1e1e) by @espadav8 ([merge request](gitlab-org/gitlab!150599))
- [Move Analytics settings to a new admin settings section](gitlab-org/gitlab@c2e55e2cc188903a6cea3d4557b22a87d2dcd634) ([merge request](gitlab-org/gitlab!149434)) **GitLab Enterprise Edition**
- [This MR adds new resolver](gitlab-org/gitlab@f69e16b958b45f3776008bf47f94524c5c459422) ([merge request](gitlab-org/gitlab!149546)) **GitLab Enterprise Edition**
- [Add ID of runner owner group in ci_running_builds](gitlab-org/gitlab@557b0ea2e8c3f4fd88ab29f578671cf8249d12c6) ([merge request](gitlab-org/gitlab!150150))
- [Add REST API endpoints to list, create, delete instance member roles](gitlab-org/gitlab@9501fed6d666f710adbc51dc5ae4a594e85f71f9) ([merge request](gitlab-org/gitlab!148931)) **GitLab Enterprise Edition**
- [Refactor refresh user assignments jobs](gitlab-org/gitlab@ff77e94b7dfd59a26cf43d558cf502ce0ae43242) ([merge request](gitlab-org/gitlab!150159)) **GitLab Enterprise Edition**
- [Allow fetching related merge requests on a WorkItem](gitlab-org/gitlab@6ac354d778f3260a65d26d7e02c2490a16a1965c) ([merge request](gitlab-org/gitlab!149951))
- [feat: Add throttle app settings for unauthenticated GIT HTTP requests](gitlab-org/gitlab@2f92e34cc759f8fe06a9d3d34ea18630bdafb0e8) by @gerardo-navarro ([merge request](gitlab-org/gitlab!147112))
- [Prepare async index for p_ci_builds.user_id](gitlab-org/gitlab@8a2b880b324a10825f9d546d419992d951557631) ([merge request](gitlab-org/gitlab!150658))
- [Add GraphQL API for policy violations](gitlab-org/gitlab@61f3f5e24cea493ce668cf234ded858f26a5816c) ([merge request](gitlab-org/gitlab!149710)) **GitLab Enterprise Edition**
- [Add missing arguments for creating a work item epic](gitlab-org/gitlab@2140c1636ed5f45217609f4dc6228cbfc4fc5fe8) ([merge request](gitlab-org/gitlab!149536))
- [Reconcile Seat Overage](gitlab-org/gitlab@61e0ce1d2cf23ab17749539c0f6db8459fa919eb) ([merge request](gitlab-org/gitlab!149892)) **GitLab Enterprise Edition**
- [Early Access Program tracking init](gitlab-org/gitlab@416858a9b1d675d6c34cd3b74e84f5c21e0a8dd6) ([merge request](gitlab-org/gitlab!148990))
- [Add full log viewer](gitlab-org/gitlab@280b47f50e6951a6ddbc67f2b82b779e831c2fe8) ([merge request](gitlab-org/gitlab!145499))
- [Add frontend for user registration restrictions](gitlab-org/gitlab@a8fa3a53e2f3ad3461c99fae538ba124a01136b2) ([merge request](gitlab-org/gitlab!148905)) **GitLab Enterprise Edition**
- [Create index on user_add_on_assignments](gitlab-org/gitlab@8b0ff49cf4d6b38043d26cfba9a8d15fa4dd77c1) ([merge request](gitlab-org/gitlab!150430))
- [Updated requesting changes blocking behaviour](gitlab-org/gitlab@2a55e046cb7fadbf5a4be0e0c64c37ba7a9962d6) ([merge request](gitlab-org/gitlab!150098))
- [Add limit warning message](gitlab-org/gitlab@bfaee4c1c4ba38a30c36abf5e4679a47715eb6fa) ([merge request](gitlab-org/gitlab!149925)) **GitLab Enterprise Edition**
- [Add admin compliance framework as custom ability](gitlab-org/gitlab@59d750e995a4383d893d765049a0d8b3b16cca79) ([merge request](gitlab-org/gitlab!144183)) **GitLab Enterprise Edition**
- [Add solution_html to PipelineSecurityReportFindingType](gitlab-org/gitlab@2d8b0556e6c0b56a4500b09cb6f35152cfb7b2f9) ([merge request](gitlab-org/gitlab!149583)) **GitLab Enterprise Edition**
- [Show which group user approved for](gitlab-org/gitlab@2bdcab23314036f5807b6c1dfd5af47ce4251d2b) ([merge request](gitlab-org/gitlab!150309)) **GitLab Enterprise Edition**
- [Add new fields for orchestration helper](gitlab-org/gitlab@dc224f0faf2ded832603f10957f919ad25a3972a) ([merge request](gitlab-org/gitlab!149778)) **GitLab Enterprise Edition**
- [Document pitfalls with upgrading PostgreSQL across glibc versions](gitlab-org/gitlab@6b2d558e132d4eaec2a4b66b3736e4c6ac3a89c4) ([merge request](gitlab-org/gitlab!149894))
- [Improve backup logging by log levels](gitlab-org/gitlab@e7059d2081525d4507e3b4d70ef98dab340f657e) by @imskr ([merge request](gitlab-org/gitlab!149137))
- [Added create and delete api for instance level event filters](gitlab-org/gitlab@6d2399dd404af809c446858ddf2bf2651abe95fc) ([merge request](gitlab-org/gitlab!149704)) **GitLab Enterprise Edition**
- [Sync create indexes and validate fks for ci_pipelines bigint id](gitlab-org/gitlab@d67b47569dedd691ff3485bc294df8eb92cc2517) ([merge request](gitlab-org/gitlab!148132))
- [Allow users to select which group to approve as](gitlab-org/gitlab@5854b3bb3f26abec88cdc49b2788222e47c01603) ([merge request](gitlab-org/gitlab!150033)) **GitLab Enterprise Edition**
- [This MR adds new humanization rules](gitlab-org/gitlab@ae4ed02a7676a5ebfeb5dc099c4164b936a26d6b) ([merge request](gitlab-org/gitlab!149706)) **GitLab Enterprise Edition**
- [Add actions dropdown to work item links](gitlab-org/gitlab@be757ff7ba12ae440777bbbb3c09977f9a014161) ([merge request](gitlab-org/gitlab!149311))
- [Add functions to search for merge_user in merge request view](gitlab-org/gitlab@ac202b15fb3c7eee13e87ab6292039728013522b) by @schurzi ([merge request](gitlab-org/gitlab!142666))
- [Saved MemberRoleId when passed](gitlab-org/gitlab@f2c4941c27ad90a2f360193389c1af39a15c1ecc) ([merge request](gitlab-org/gitlab!148869)) **GitLab Enterprise Edition**
- [Track Secret Detection vulnerabilities as they move within the file](gitlab-org/gitlab@279e15ea932ffe44aaaa1aaa12218e1026630030) ([merge request](gitlab-org/gitlab!147549)) **GitLab Enterprise Edition**
- [Add weight to iteration issue list](gitlab-org/gitlab@086788c98c389aaf527ea232fac687bdac41911c) ([merge request](gitlab-org/gitlab!150070)) **GitLab Enterprise Edition**
- [Use Progressive Web App (PWA) icon as apple-touch-icon if defined](gitlab-org/gitlab@aa2cab5170e24052266f3f4e023fec1ed63c1e7b) by @bufferoverflow ([merge request](gitlab-org/gitlab!147551))
- [Expose trigger short token to CI](gitlab-org/gitlab@e816eb68bb4a8d94b4063a3825225461399fc241) by @kevin.gosa ([merge request](gitlab-org/gitlab!149456))
- [Support GitLab flavored markdown in finding modal description](gitlab-org/gitlab@8bfc635846a58c6c3b032947566dacfc8db6b9a8) ([merge request](gitlab-org/gitlab!150008)) **GitLab Enterprise Edition**
- [Add secure schemas version 15.1.0](gitlab-org/gitlab@15fe039600a8da5e25b1fbb07a8fa626307516fd) ([merge request](gitlab-org/gitlab!149589))
- [Extracted Billable code to a shared util file](gitlab-org/gitlab@43ed48182a712db8cf7f181dfe67b30622d717df) ([merge request](gitlab-org/gitlab!143545)) **GitLab Enterprise Edition**
- [GraphQL: Add upgradeStatus field to RunnerManagerType](gitlab-org/gitlab@a9f38533237f08fc6a470a42df77329948fbf920) ([merge request](gitlab-org/gitlab!149140)) **GitLab Enterprise Edition**
- [Support epoch millis when ingesting alerts](gitlab-org/gitlab@a3ce617e27610cb8a0347ad7f5a1fb11d3049271) ([merge request](gitlab-org/gitlab!145502))
- [Audit Event when merge request approval setting is updated](gitlab-org/gitlab@6efdc2919afa249f10e48e83d7817002d5414203) ([merge request](gitlab-org/gitlab!148743)) **GitLab Enterprise Edition**
- [Add REST API to update pages settings](gitlab-org/gitlab@70f2f198bbb5b56edd8f78bc91d7ca4787e032c0) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147227)) **GitLab Enterprise Edition**
- [Obfuscate external participants emails in system notes](gitlab-org/gitlab@47eea6ebc4c890f0b04b41a99dc1cd212e47d4e4) ([merge request](gitlab-org/gitlab!149415))
- [Protected packages: Delete protection rules in project settings ui](gitlab-org/gitlab@25b7a9983530c22cc91b3af8fb6757a53bf4181e) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146622))
- [Jira issues - Display error message returned from jira response](gitlab-org/gitlab@ed112d4ba34aee3caa73532f2923deed00f10ead) ([merge request](gitlab-org/gitlab!149592))
- [Expose auto_stop_at in Environments api](gitlab-org/gitlab@54419be87c1a4dc83ea72e61c7dde7dce3b9ff80) by @devDavidBox ([merge request](gitlab-org/gitlab!147210))
- [Show admin mode within active sessions view (remove feature flag)](gitlab-org/gitlab@cc8aebe7f1652e8fc635d826ba3b23f695597b81) by @bufferoverflow ([merge request](gitlab-org/gitlab!148321))
- [Add new panel title interpolation options to analytics dashboards](gitlab-org/gitlab@2cdec433f39e4cb108eb4ef0d72e64b1053b58f7) ([merge request](gitlab-org/gitlab!149437)) **GitLab Enterprise Edition**
- [Add imported column to resources](gitlab-org/gitlab@7de9ab19f57db23825a0fe708ff20bfadf64b652) ([merge request](gitlab-org/gitlab!149570))
- [Add support for showing a popover for milestones in GFM](gitlab-org/gitlab@90f1603b8a19da7c8c06a6938811349eb21f8853) ([merge request](gitlab-org/gitlab!147797))
- [Exposed web_path on the MR GraphQL type](gitlab-org/gitlab@a88c47e65c5c9342f4790c5ffc4495ceb27b1368) by @zillemarco ([merge request](gitlab-org/gitlab!148780))
- [Expose project/namespace IDs in `internal/allowed` response](gitlab-org/gitlab@2870d33a22646cb493e436837dbd191e05443455) ([merge request](gitlab-org/gitlab!148525))
- [Add edit button to policies list in edit screen](gitlab-org/gitlab@1f1740f718876c9071f7a8ede18f24697f40048d) ([merge request](gitlab-org/gitlab!149768)) **GitLab Enterprise Edition**
- [Added MemberApprovalFinder](gitlab-org/gitlab@7cc3770e8786cffaa64f6ac0a4de946e2fec1a09) ([merge request](gitlab-org/gitlab!148815)) **GitLab Enterprise Edition**
- [Remove the `tailwind_all_the_way` feature flag](gitlab-org/gitlab@77897c330d78487ecea679af32bd6fa84e08fd34) ([merge request](gitlab-org/gitlab!149572))
- [Added keyboard shortcut](gitlab-org/gitlab@bfc980af9e430373442cae86fb841104698aabcb) ([merge request](gitlab-org/gitlab!147918))
- [Add a branch check for default security policy config](gitlab-org/gitlab@ca2bd86f9715ffe92c7a8210663e41f6c85b744e) ([merge request](gitlab-org/gitlab!149567)) **GitLab Enterprise Edition**
- [Prepare async index for p_ci_builds.project_id](gitlab-org/gitlab@47e7059e94fb7c197c766a5c8b26b0e09bffa588) ([merge request](gitlab-org/gitlab!145362))
- [Add confirmation when closing blocked work items](gitlab-org/gitlab@04e2a71c43555387a4ebca559e3cdc84d633045d) ([merge request](gitlab-org/gitlab!148545))
- [Add setting for enabling CS for Registry](gitlab-org/gitlab@6acb41742b1c17c9cd481f1295936ace54adb34c) ([merge request](gitlab-org/gitlab!147537)) **GitLab Enterprise Edition**
- [Add feature flag for stopping CH data ingestion](gitlab-org/gitlab@86efe63ad79a3da2f613a437ca774e78e8fc29b0) ([merge request](gitlab-org/gitlab!149668)) **GitLab Enterprise Edition**
- [Prepare async indexes and fks for ci_pipelines.id_convert_to_bigint](gitlab-org/gitlab@12e654a483aae7912ec3970f0abc3fad8ba3b13b) ([merge request](gitlab-org/gitlab!148034))
- [Sync create indexes p_ci_builds runner_id](gitlab-org/gitlab@17763d54bfa50827a9badf528823ed0943174d21) ([merge request](gitlab-org/gitlab!145380))
- [Add median time to merge metric to VSD](gitlab-org/gitlab@c321a474b9f0d3d1fa07a25f872804692766fe15) ([merge request](gitlab-org/gitlab!149249)) **GitLab Enterprise Edition**
- [Add milestone and iteration to board card](gitlab-org/gitlab@ae74843b86416e3e98b707c4e7ab87e9a2c2b7d3) ([merge request](gitlab-org/gitlab!148151))
- [Added possibility to sort todos from GraphQL](gitlab-org/gitlab@68eecfecc7b76c3d1932572b9ea5e70c8c903750) by @zillemarco ([merge request](gitlab-org/gitlab!149020))
- [Always submit note via key shortcut with shift](gitlab-org/gitlab@8d341b9e4f1705d2921eb9d7c6b85cf9a41fddeb) ([merge request](gitlab-org/gitlab!148899))
- [Adds a new keep file to remove duplicated indexes](gitlab-org/gitlab@2df360578dbd98ac684d091981fd65ba8b5ce80a) ([merge request](gitlab-org/gitlab!148200))
- [Add migration for semver_prefixed column](gitlab-org/gitlab@0baaabb76ba09ab7ed9aa09eaaba1e054af9c703) ([merge request](gitlab-org/gitlab!149568))
- [Use object exist check for codeowners file](gitlab-org/gitlab@1a76967e87e15a0324618e81adb9616b96578777) ([merge request](gitlab-org/gitlab!149527)) **GitLab Enterprise Edition**
- [Show warning when a group webhook is disabled](gitlab-org/gitlab@2ab55f1eb1f5e392a224af77da2c80d02832eb38) ([merge request](gitlab-org/gitlab!128213))
- [Add error to indicate email is linked to an account pending deletion](gitlab-org/gitlab@034b152beb39762ca117318c307e8cfe2be5185e) ([merge request](gitlab-org/gitlab!148369))
- [Remove exempt_paid_namespace_members_...from_identity_verification FF](gitlab-org/gitlab@3565bb91f96fc10560c2e451a3a52a1011f695e5) ([merge request](gitlab-org/gitlab!149360)) **GitLab Enterprise Edition**
- [Remove internal_events_for_product_analytics FF](gitlab-org/gitlab@07b6b1840bcafddce00546a8f96c457da0d23790) ([merge request](gitlab-org/gitlab!149280))
- [GraphQL: Add queuedDuration field to CiJobsStatistics](gitlab-org/gitlab@2d4e7bfd3d5df7b7f179769c449f8fffa74b4a0d) ([merge request](gitlab-org/gitlab!149141)) **GitLab Enterprise Edition**

### Fixed (161 changes)

- [Trigger epic dates update when adding or removing a child epic](gitlab-org/gitlab@666cc2df44043b79ab1afc731c7df4128c34af10) ([merge request](gitlab-org/gitlab!151751)) **GitLab Enterprise Edition**
- [Fix default protected branch settings for user namespace](gitlab-org/gitlab@a553b3e37b926cf4d97bb14d1542429768fccfe3) ([merge request](gitlab-org/gitlab!152769))
- [Fix a dependency proxy upload premature interruption in workhorse](gitlab-org/gitlab@5fbb20ea249e8f5600fca7605dd39c0fefd453c0) ([merge request](gitlab-org/gitlab!149984))
- [Fixes requested access users when excluding guests](gitlab-org/gitlab@298d3f575a2f613ab190cf60e53bd856319a6ddf) ([merge request](gitlab-org/gitlab!150099)) **GitLab Enterprise Edition**
- [Add break-all class to stages dropdown](gitlab-org/gitlab@67c9f630a91d675c504f7229dbbd37da0809df58) ([merge request](gitlab-org/gitlab!152646))
- [Normalize golang component name when looking up their license](gitlab-org/gitlab@26c258da68d984751ab9de39337f949a30bd0301) ([merge request](gitlab-org/gitlab!152434))
- [Fix code suggestions and diagrams in rich text](gitlab-org/gitlab@642235ccc432e9b1d71fb2694b14875fc8cb7908) ([merge request](gitlab-org/gitlab!152213))
- [Merge commit message: Use monospace font](gitlab-org/gitlab@2651f84789d93d4679f5569fcc39b86687e79c57) ([merge request](gitlab-org/gitlab!152589))
- [Fix custom dashboards not saving on non-"main" branch](gitlab-org/gitlab@d993e00165311e07efe6648cd0a4421f37ccd30e) ([merge request](gitlab-org/gitlab!152217)) **GitLab Enterprise Edition**
- [Exclude ci_secure_files from Workhorse-accelerated types](gitlab-org/gitlab@7dc051b2e89436dc6d1342cbd3662ba2aa8d9d56) ([merge request](gitlab-org/gitlab!152553))
- [Fix license approval policy for pre-existing license_state](gitlab-org/gitlab@cdaf4e2b3adcbb3da9bbfa8483b7dbe0492e6192) ([merge request](gitlab-org/gitlab!151441)) **GitLab Enterprise Edition**
- [Rescue errors in ActionCable #connect](gitlab-org/gitlab@3d86841496e51043a068088d8b292d54cf1b4a3b) ([merge request](gitlab-org/gitlab!152363))
- [Hide download button on blob viewer](gitlab-org/gitlab@e12b391412ba66b2ef0f55436395476e4c8734df) ([merge request](gitlab-org/gitlab!152232))
- [Fix text on vulnerability report alert](gitlab-org/gitlab@6e8f13b02909a5534e8dd1039ab564c9feb34047) ([merge request](gitlab-org/gitlab!152485)) **GitLab Enterprise Edition**
- [Fix NoMethodError for BranchesController](gitlab-org/gitlab@00cf5cf23bb8f70b594c6d91cd48c403909fbf12) ([merge request](gitlab-org/gitlab!152078))
- [Prevent WebIDE from crashing on message](gitlab-org/gitlab@bd785b62c641b7d7921d06fe33aac23b11751efa) ([merge request](gitlab-org/gitlab!152289))
- [Add requested_path to readmeHtml field resolver](gitlab-org/gitlab@9f2ccc1b7ec7600b89b1490eeca8babaa0952008) ([merge request](gitlab-org/gitlab!151936))
- [Handle dashboard pointer in sync funnels worker](gitlab-org/gitlab@2261d0e4d298cca1d943667b7a08cf140a5abe83) ([merge request](gitlab-org/gitlab!151758)) **GitLab Enterprise Edition**
- [Fix blob border radius](gitlab-org/gitlab@e7b1739a527626b82b582699dd85cb1615393094) ([merge request](gitlab-org/gitlab!152415))
- [Add word break to the job log sidebar](gitlab-org/gitlab@8de49dceeedd5bf7b27b2daba127bbbff9e5c78c) ([merge request](gitlab-org/gitlab!152273))
- [Release calling after_script on cancel](gitlab-org/gitlab@475a785b487a4164c633c70bd9a24f0eb9a5a32e) ([merge request](gitlab-org/gitlab!152387))
- [Reject zero-length component names and versions](gitlab-org/gitlab@c67389ec5fe89e4e5abd95075ffbab6c3c48d3ce) ([merge request](gitlab-org/gitlab!152379)) **GitLab Enterprise Edition**
- [Correctly handle empty default branch protection defaults](gitlab-org/gitlab@4c378c22cd212530f19d3ab29a3e8d2a745db5a5) ([merge request](gitlab-org/gitlab!152367))
- [Fix alignment in rolled up dates widget](gitlab-org/gitlab@e56be1407890c344fd601c08e4393302ae097995) ([merge request](gitlab-org/gitlab!152241))
- [Exclude YAML languages in the wiki search results](gitlab-org/gitlab@8a4454cbb9a72b4960597ad97bc3fbd01ff41a44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152170)) **GitLab Enterprise Edition**
- [Fix escaping dismissal descriptions on MR widget](gitlab-org/gitlab@7edd1c82e6fe142aecd0a1e1ae1b87c6da98d103) ([merge request](gitlab-org/gitlab!152184)) **GitLab Enterprise Edition**
- [Update fetch path of raw logs](gitlab-org/gitlab@88bcdcf45956839094371718867ecb0081815bcf) ([merge request](gitlab-org/gitlab!150802))
- [Handle an empty "subjectAltName" field for X.509 certificates](gitlab-org/gitlab@0744271ad9f6f8d5ef3a286cfa2f7a7882c03c1f) ([merge request](gitlab-org/gitlab!152179))
- [Calculate correct access level of members invited through group](gitlab-org/gitlab@f03c0a7522dfbf4f22f578d936efbc7d053aca47) ([merge request](gitlab-org/gitlab!151760))
- [High contrast mode fixes for topbar and sidebar navigation](gitlab-org/gitlab@86bbae0eb30afae514187bf264462fa6a2737e22) ([merge request](gitlab-org/gitlab!152067))
- [Fix milestone dropdown on incident sidebar](gitlab-org/gitlab@d514b8ef352f775621f22a3df150475f7ea5caea) ([merge request](gitlab-org/gitlab!152159))
- [Preserve approval rules when role changes](gitlab-org/gitlab@640c5a613182e3c804beb8e0cdc770e6e06d6ce7) ([merge request](gitlab-org/gitlab!151856))
- [Allow auto merge on created and blocked pipelines](gitlab-org/gitlab@b4450cbe46bd8bc2d35cd4d80435a77c40a95b8f) ([merge request](gitlab-org/gitlab!152101))
- [Fix 500 errors when viewing empty CI artifacts image](gitlab-org/gitlab@2c49e3fbb05c6f9fd9b99f901a6b4271734c1792) ([merge request](gitlab-org/gitlab!151991))
- [Fix notice for projects](gitlab-org/gitlab@3e0d9d8a937fa63374c844f1a52523559b1455eb) ([merge request](gitlab-org/gitlab!151900)) **GitLab Enterprise Edition**
- [Upgrade to semver_dialects 3.0.0](gitlab-org/gitlab@6c487c9781b98c398c47ecb40869f508f065b197) ([merge request](gitlab-org/gitlab!151761)) **GitLab Enterprise Edition**
- [SSO enforcement: Sessionless activity does not need to be allowed for Owner without session](gitlab-org/gitlab@208ea4c49a1982b7d05a62d48cce0e00f028e907) ([merge request](gitlab-org/gitlab!149154)) **GitLab Enterprise Edition**
- [Add apk to supported package managers](gitlab-org/gitlab@45b47dd6cf49e8247cfd93391fb39fc84a04b7f2) ([merge request](gitlab-org/gitlab!151508)) **GitLab Enterprise Edition**
- [Handle window popstate events for registry search](gitlab-org/gitlab@ff6cb7b4df2d7181d5140b1265ff1b680d9ea680) ([merge request](gitlab-org/gitlab!152079))
- [Release raising permissions of group APIs to owner for package settings](gitlab-org/gitlab@e789d28c6ca1d20e8219c7aff34fd5f5206e7bfe) ([merge request](gitlab-org/gitlab!149872))
- [Load the system cert pool when dialing websocket channels in workhorse](gitlab-org/gitlab@10390da750d2cc9e1aa37b8e30e5f19fca51eafd) by @jlsalmon ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80374))
- [Fixed flaky billable member spec](gitlab-org/gitlab@085e37e337026b1a14405166a5d964dabf569975) ([merge request](gitlab-org/gitlab!151887)) **GitLab Enterprise Edition**
- [Fix broken link to CI troubleshooting doc from merge requests](gitlab-org/gitlab@8967f78d902a66f5fb8dc2957f5ef1ba945f4c19) ([merge request](gitlab-org/gitlab!152028))
- [Cancel outdated deployments for jobs with resource groups](gitlab-org/gitlab@42bbd0f616832458b893dd249789c33529c8105a) ([merge request](gitlab-org/gitlab!151613))
- [Fix race condition when changing dashboard filters quickly](gitlab-org/gitlab@30a33491a0115939ea2c0a016f6004a955310cab) ([merge request](gitlab-org/gitlab!152021)) **GitLab Enterprise Edition**
- [gitlab-zip-metadata: Ensure 0-byte files have a size field](gitlab-org/gitlab@c44d8f3ec62d9988e80ab012fd07a6d9ab6e7a58) ([merge request](gitlab-org/gitlab!151992))
- [Disable sidekiq shard validation for /admin/sidekiq path](gitlab-org/gitlab@e7e923242024f3dabd05834cb40b155fa5123816) ([merge request](gitlab-org/gitlab!151969))
- [Show global search filter button when sidebar is auto collapsed](gitlab-org/gitlab@2e8f6d5ea61c2ae3a5e8d723d85b04d561ae1e30) ([merge request](gitlab-org/gitlab!151964))
- [Update pipeline_triggers plan limits to 25k for Premium and Ultimate](gitlab-org/gitlab@b773f9a0f29e59ebbd3ab0c87ee2c6bc7a9ff23f) ([merge request](gitlab-org/gitlab!151826))
- [Fix handling of analytics visualizations with hyphens](gitlab-org/gitlab@ff583757b4cd43e763dd473f0115505a030402d8) ([merge request](gitlab-org/gitlab!151757)) **GitLab Enterprise Edition**
- [Prevent board epic lane header from moving before sticky](gitlab-org/gitlab@c09ef674d53331ad6eafc79e7dc5398d218e9fe0) ([merge request](gitlab-org/gitlab!151824)) **GitLab Enterprise Edition**
- [Adjust left and right margins of board top bar and content](gitlab-org/gitlab@52bf965090c1c247247e3f0ba6651f7e16899776) ([merge request](gitlab-org/gitlab!151790))
- [Allow developers to create an issue for a vulnerability](gitlab-org/gitlab@f01f6ecd5b8b6d72c1400c91c5a23eb7df7406fb) ([merge request](gitlab-org/gitlab!151069)) **GitLab Enterprise Edition**
- [Fix board epic swimlane header background in dark mode](gitlab-org/gitlab@6c76ba0ccd94791b9c0daac2399b07fb7ac95b98) ([merge request](gitlab-org/gitlab!151795)) **GitLab Enterprise Edition**
- [Improve issue searches for URLs](gitlab-org/gitlab@a5b246df9126e46fe9a42eb7bd01a3c40f5c9eef) ([merge request](gitlab-org/gitlab!150845))
- [Upgrade to grpc v1.63.0](gitlab-org/gitlab@088f376ad5c9528b8abe61eff5f6d3c73a900a27) ([merge request](gitlab-org/gitlab!151692))
- [Ignore tag pipelines for MR approval policies](gitlab-org/gitlab@295adb6b5399cea45434f02534155d7ee2bfe6f8) ([merge request](gitlab-org/gitlab!150637)) **GitLab Enterprise Edition**
- [Rescue from validation errors when uploading terraform modules](gitlab-org/gitlab@cd69df8f6e9d8c1d999be3b8eb49d47e608baf85) ([merge request](gitlab-org/gitlab!151649))
- [Allow access to roles/permissions page via read_member_role permission](gitlab-org/gitlab@2b0d6eebb6340baf01b53a931ca61ede865e2579) ([merge request](gitlab-org/gitlab!150568)) **GitLab Enterprise Edition**
- [Ensure assignee array has values before passing argument to finder](gitlab-org/gitlab@669254bba3ee103bc79a957c8cefe7b68665b047) ([merge request](gitlab-org/gitlab!151639))
- [Fix dark mode search token coloring and dropdown active/hover colors](gitlab-org/gitlab@588c59b949fcd60b71b5954d494545d149d2fede) ([merge request](gitlab-org/gitlab!151618))
- [Casts finalized_by migration version to an integer](gitlab-org/gitlab@4c6d21499ed2d848551cb2b2f63094139b66eb91) ([merge request](gitlab-org/gitlab!151580))
- [Do not overwrite findings_by_commits hash](gitlab-org/gitlab@72a39b5fe7f5c279c95659e3d60410eb5c90dd07) ([merge request](gitlab-org/gitlab!150574))
- [Allow admins to be able to link issues](gitlab-org/gitlab@d9b83adfef6750d5ef234fe535980352582ab3fe) ([merge request](gitlab-org/gitlab!151360))
- [Changed the email validation for only encoded chars](gitlab-org/gitlab@d1a07d35acd9eaa37b463c22b9f4d9b85eb9716c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151484/))
- [Fix resetting approvals when pipeline is manual](gitlab-org/gitlab@6068320db68868561ba9a376a6474c17f0b55ad5) ([merge request](gitlab-org/gitlab!150040)) **GitLab Enterprise Edition**
- [Use tmpdir for relation import extraction](gitlab-org/gitlab@61ff555741aac83fc7609c17755f3c092914168c) ([merge request](gitlab-org/gitlab!149530))
- [Consume response stream to finish when calling UserMergeBranch](gitlab-org/gitlab@397fad24a0d81453ed4ad4c90e4bcf09b51a50f2) ([merge request](gitlab-org/gitlab!150202))
- [Fix style of search tokens in dark mode](gitlab-org/gitlab@6bba68f6d3fbac359ade990798462a5d0fa00c7c) ([merge request](gitlab-org/gitlab!150693))
- [Fix pattern matching for `prevent_pushing_and_force_pushing`](gitlab-org/gitlab@2168f4cbe4c349cdbeb14d6e9c496d8b81e12956) ([merge request](gitlab-org/gitlab!150853)) **GitLab Enterprise Edition**
- [Align project avatar to the top](gitlab-org/gitlab@1b0a028cbb1fc3ecf1c7736abb50f399c6044374) by @grace-chung ([merge request](gitlab-org/gitlab!150747))
- [Fix loading state for group invite modal](gitlab-org/gitlab@07204a74d4167f5d8b5dcb3b55866e74c292687b) ([merge request](gitlab-org/gitlab!151403)) **GitLab Enterprise Edition**
- [Schedule Dora updates after MR linking process](gitlab-org/gitlab@741009018c7ebdf7e7d2bb47da09e46cad02f8b7) ([merge request](gitlab-org/gitlab!150968)) **GitLab Enterprise Edition**
- [Sync approval rules even when security_scans are duplicated](gitlab-org/gitlab@5b1a83ad61cd05c5b3fa23a4fa071a4772560121) ([merge request](gitlab-org/gitlab!150752)) **GitLab Enterprise Edition**
- [Account for protected branches without backing git refs](gitlab-org/gitlab@ecb27bd1abfd9ca2cf986500b4f8771acd00cd9f) ([merge request](gitlab-org/gitlab!150848)) **GitLab Enterprise Edition**
- [Include template in deprecated flafinder-sast job](gitlab-org/gitlab@7bce91fd3639660b11b7669831f9ddc0d13bbe50) ([merge request](gitlab-org/gitlab!151298))
- [Add AzureRM support to orphan artifacts cleanup](gitlab-org/gitlab@627eb5411af6f76a03c067131c7846c5c8d9129d) ([merge request](gitlab-org/gitlab!140497))
- [Fix work item child status icon color](gitlab-org/gitlab@e5770bc16824362e06c73d56957255c5500f60c7) ([merge request](gitlab-org/gitlab!151094))
- [Use locale-specific formatting for numbers in the AI Impact dashboard](gitlab-org/gitlab@07a2c3c576b7d0574c0d649ac7931d14606b5305) ([merge request](gitlab-org/gitlab!150882)) **GitLab Enterprise Edition**
- [Allows ml_model pending destruction](gitlab-org/gitlab@4b3d7a7eaf03cb799fdd91781347bcafdd9fa040) ([merge request](gitlab-org/gitlab!150808))
- [Fixes issue with registry search query params when removed](gitlab-org/gitlab@2f13fba9b1c405de37dc7b618f5472f129859989) ([merge request](gitlab-org/gitlab!150934))
- [MR list: Fix overlapping search icon](gitlab-org/gitlab@7421cb36c6481acafb30435cb81695ff97bf6a3c) ([merge request](gitlab-org/gitlab!151045))
- [Create refs/merge-requests/:iid/head refs for imported merge requests](gitlab-org/gitlab@fe2e9c840eabee06ffc6ef0676f90d3a8abda988) ([merge request](gitlab-org/gitlab!150458))
- [Fixed MR list layout on mobile](gitlab-org/gitlab@4ac087906b5c4b595be986c3f6e75e4a3d1d1869) by @zillemarco ([merge request](gitlab-org/gitlab!150087))
- [Apply truncation to other Pypi metadatum fields](gitlab-org/gitlab@2a69d91bf6c62ea0321fe853ef9b4cd3c2e8089d) ([merge request](gitlab-org/gitlab!147891))
- [Legacy HAML filtered search: Fix reset search](gitlab-org/gitlab@3c96f772915bf7013b72b9fac08558f315d3faa4) ([merge request](gitlab-org/gitlab!150984))
- [Zoekt search enable should respect expiriment setting](gitlab-org/gitlab@f5d12dddddd10f66b2ea404830563acd7b612df8) ([merge request](gitlab-org/gitlab!150916)) **GitLab Enterprise Edition**
- [Replace markdown escpae filters](gitlab-org/gitlab@d4ae13f3e441546e46473d71f14cac8b357e50af) ([merge request](gitlab-org/gitlab!150181))
- [Allow Developers to create external issue links for vulnerabilities](gitlab-org/gitlab@506d4c8de0d686eb9e8b4202679286cd9079934d) ([merge request](gitlab-org/gitlab!150745)) **GitLab Enterprise Edition**
- [Always return the direct member of an object that requests it](gitlab-org/gitlab@ede02eb93b05b9d8bee20c3d9bcff4f98d0397e0) ([merge request](gitlab-org/gitlab!149227))
- [Fix blurry avatars in Members list](gitlab-org/gitlab@03c4e30d40637e908907a73c19a93f4046e4a3e6) ([merge request](gitlab-org/gitlab!150558))
- [Branch target settings: Change spacing of table row](gitlab-org/gitlab@03c7f866a62234784f49c24a5528f6483022b540) ([merge request](gitlab-org/gitlab!150827)) **GitLab Enterprise Edition**
- [Avoid sub-group destruction in group link synchronization](gitlab-org/gitlab@be3ad065d131c244e63629a48f8976a981908e1b) ([merge request](gitlab-org/gitlab!150104))
- [Fix project_path sorting scopes in Packages::Package model](gitlab-org/gitlab@a66396731e823f044017bff6e7c0604cb2ef8baa) ([merge request](gitlab-org/gitlab!150298))
- [Fix flaky test in Epics > User uses quick actions](gitlab-org/gitlab@fc071e7bd6c0c8037f6dda44423e82f6cf17a447) ([merge request](gitlab-org/gitlab!150645)) **GitLab Enterprise Edition**
- [Fix bug of coverage check approval rules](gitlab-org/gitlab@d2ccea108e377cb12910de6acd0a8500cca1120e) ([merge request](gitlab-org/gitlab!142339))
- [Decouple read_vulnerability from read_dependency](gitlab-org/gitlab@c16ea82219a5794a0afcaf0036ac1024fa0f4335) ([merge request](gitlab-org/gitlab!150363)) **GitLab Enterprise Edition**
- [Update XRay Add-On Access check](gitlab-org/gitlab@94de2b31aeebe276e3928c6f6ee92ee8ec493800) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150065)) **GitLab Enterprise Edition**
- [Show zero based coverage](gitlab-org/gitlab@dac7570511f548f12acbf8ba9bc2095c5b42021b) ([merge request](gitlab-org/gitlab!150524))
- [Only allow documented token types for GraphQL authentication](gitlab-org/gitlab@38f00deab060fc6f24607b67c1702017a5884bda) ([merge request](gitlab-org/gitlab!150407))
- [Fix inherited member source not visible to subgroup members](gitlab-org/gitlab@fea35718f132f9c8e238e911f5428f8d5c0cfbf9) ([merge request](gitlab-org/gitlab!150101))
- [Fix bug preventing instance settings being inherited by project](gitlab-org/gitlab@3676f3416152e802c592b178ed79364c77253be1) ([merge request](gitlab-org/gitlab!149796)) **GitLab Enterprise Edition**
- [Fix empty CommitMessage error](gitlab-org/gitlab@ad0a79371888c8fae45c32a5c6031c5f5cb308b8) ([merge request](gitlab-org/gitlab!150013))
- [Pass correct reference for modal work item](gitlab-org/gitlab@efd6737d2c14c3db82be3aa3250e407f0f159320) ([merge request](gitlab-org/gitlab!150435))
- [Fix trailing slash in Maven dependency proxy upstream URL](gitlab-org/gitlab@ab3fd426a5b734e67ce486cadbe12e0860123c22) ([merge request](gitlab-org/gitlab!149999))
- [Reject git LFS push when the namespace is over the free tier user limit](gitlab-org/gitlab@546275f337c39b90e5e8ca956c9beb7a890f551a) ([merge request](gitlab-org/gitlab!149919)) **GitLab Enterprise Edition**
- [Fix broadcast message text in darkmode](gitlab-org/gitlab@b34d1168286c64721ff52dd162d42c2697c1ee7e) ([merge request](gitlab-org/gitlab!150315))
- [Do not move "You" to front of emoji award list](gitlab-org/gitlab@750d3308c79a9ccbaf23471dc2f5bfd33a6188fe) ([merge request](gitlab-org/gitlab!149460))
- [Zoekt: Fix exact search mode](gitlab-org/gitlab@98444db3eecd47e53e2f800ac02370216d9270de) ([merge request](gitlab-org/gitlab!150319)) **GitLab Enterprise Edition**
- [fix: Avoids whitespace when displaying the version number](gitlab-org/gitlab@40f7f3fa6d6b34dfbe2b0e7d8cce9f174d269b5a) by @gerardo-navarro ([merge request](gitlab-org/gitlab!150317))
- [Fix type error when the file_name is not set](gitlab-org/gitlab@bc9f365660c1e8b1d858af9b24595c778f2ea280) ([merge request](gitlab-org/gitlab!123183))
- [Resolve query performance regression on sbom reports](gitlab-org/gitlab@1e391276260a38bcd227b4ac1fcb4fb5ee0924af) ([merge request](gitlab-org/gitlab!149823)) **GitLab Enterprise Edition**
- [Add fullPath to CatalogResource graphl query](gitlab-org/gitlab@bbdb451eb234e2b29994a9ef29aa748f203b690d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148385))
- [Fixes N+1 on ExperimentsController](gitlab-org/gitlab@1922e2df2493f71f5ca72b72d4780b470954a2be) ([merge request](gitlab-org/gitlab!150271))
- [Fixed drawer view with two column](gitlab-org/gitlab@5ec50c1f81e6901a84bd39d0119518ae3c86f45c) ([merge request](gitlab-org/gitlab!150294))
- [Resolve homepage tooltip covering sidebar contents](gitlab-org/gitlab@2884f69063099420043ca258c63ebe60874c4305) ([merge request](gitlab-org/gitlab!149808))
- [Pipeline: Fix dropdown item focus in darkmode](gitlab-org/gitlab@2f9b7f97beb6aea1a6f452e04dffbf8d4f3917ed) ([merge request](gitlab-org/gitlab!150258))
- [Fix vulnerability list table head](gitlab-org/gitlab@0f4ac96c5426ce90ec8c7055ee4fbb6e5da23ad4) ([merge request](gitlab-org/gitlab!149895)) **GitLab Enterprise Edition**
- [Improve extra_slug_path_sanitization account creation](gitlab-org/gitlab@047a2010c4741815b3c8a8ce8762e8671eac1604) ([merge request](gitlab-org/gitlab!147971))
- [Truncate/Wrap around exit codes larger than 32767](gitlab-org/gitlab@a7e6de712d0fe30819a5b0266f1e37fdc220cacd) ([merge request](gitlab-org/gitlab!150053))
- [Render alert when raw text search attempted in Issue Analytics](gitlab-org/gitlab@5f3cc93125c7c0e05cd3799434cbd04c874af41d) ([merge request](gitlab-org/gitlab!149921)) **GitLab Enterprise Edition**
- [Clear license caches before license reset in seat link sync](gitlab-org/gitlab@5387d7241ca01b8f89eeab304264a1d0f5ed155b) ([merge request](gitlab-org/gitlab!149989)) **GitLab Enterprise Edition**
- [Let merge request sidebar scroll](gitlab-org/gitlab@152ebe894c7301c355b7ea340f44b720baf8db9c) ([merge request](gitlab-org/gitlab!149940))
- [Non-admins can change "Allow runner registration token"](gitlab-org/gitlab@db7430462003d7783b53b7d3dbf392f4d9088afc) ([merge request](gitlab-org/gitlab!149827))
- [Migrate deprecated dropdown in pipeline deployment widget](gitlab-org/gitlab@a3dd2aac62f4d17f57fcc06d319e057e4573c595) ([merge request](gitlab-org/gitlab!135283))
- [Package detail: Assets table adjustments](gitlab-org/gitlab@8ef416bc626ba2833464338d94f03f5046d910a8) ([merge request](gitlab-org/gitlab!149833))
- [Fix N+1 queries with autocomplete recent items](gitlab-org/gitlab@7fc709c538d03ef08db980f1a4d5a4273da54319) ([merge request](gitlab-org/gitlab!149635)) **GitLab Enterprise Edition**
- [Let sidekiq handle retries](gitlab-org/gitlab@b37ac6b62a1a1a491835a30c3102f412e839e4d8) ([merge request](gitlab-org/gitlab!150041)) **GitLab Enterprise Edition**
- [Fix math block alert rendering](gitlab-org/gitlab@2d29ad27181e861c1f28449fce36b471537e1c88) ([merge request](gitlab-org/gitlab!149765))
- [Add missing handler for protected branches Deploy key](gitlab-org/gitlab@7c8e3121af8a8276dfa14ab108f9fa145a00bad7) ([merge request](gitlab-org/gitlab!149863))
- [Fix todo count going from 99+ down to 98](gitlab-org/gitlab@db961ef6649bf181c6e585a6e68792ce47909ab3) ([merge request](gitlab-org/gitlab!149927))
- [Fixes deleting last page of package assets deleting entire package](gitlab-org/gitlab@a0f9d9abe4d4c954c5567e67e6ce8782308caeb8) ([merge request](gitlab-org/gitlab!149862))
- [Allow incomplete bucket for Secure Files in object storage config](gitlab-org/gitlab@2f69784ac2915d0a67087e39b70d48ec6fc07141) ([merge request](gitlab-org/gitlab!149873))
- [Package registry detail page: Use secondary text for help text](gitlab-org/gitlab@5a004529195f6d7dbc385c474f9814d40143b7dc) ([merge request](gitlab-org/gitlab!149835))
- [Skip license capacity check for security policy bot user](gitlab-org/gitlab@3fb8d15b0d6a8994d3d9d2deb4acaed400b7199d) ([merge request](gitlab-org/gitlab!149276)) **GitLab Enterprise Edition**
- [Fix box-shadow colors in Tailwind](gitlab-org/gitlab@fa71ce4e2cc6d14c765e9ef0ae0af8ef4f0fb6fa) ([merge request](gitlab-org/gitlab!149843))
- [Fixes missing webUrl on associated projects](gitlab-org/gitlab@4c0c8e40d0a8730fe637b1caf81a6b74dd8df266) ([merge request](gitlab-org/gitlab!149798)) **GitLab Enterprise Edition**
- [Add gl-text-left to stage name in job](gitlab-org/gitlab@6e129892658dff8c16bb9297fd80d4a459501ba3) ([merge request](gitlab-org/gitlab!149789))
- [Fix Usage Overview panel title's popover positioning](gitlab-org/gitlab@e231133f007d508d348f09d314f54c41eb3a5d55) ([merge request](gitlab-org/gitlab!149774)) **GitLab Enterprise Edition**
- [Only add to merge train if not already there](gitlab-org/gitlab@bb5ea952aa5e222992f230c5a8b5174b7720bdab) ([merge request](gitlab-org/gitlab!149891)) **GitLab Enterprise Edition**
- [Fix bottom popover arrow color](gitlab-org/gitlab@61a1ff92cdf5300ed9d54f5d108f81910dba4988) ([merge request](gitlab-org/gitlab!149761)) **GitLab Enterprise Edition**
- [Fix toggle behavior for board iteration and label edits](gitlab-org/gitlab@8345d35e1840d143a5988912a8a72a86e9462b27) ([merge request](gitlab-org/gitlab!149443)) **GitLab Enterprise Edition**
- [Work items widgets: Fix alignments of items](gitlab-org/gitlab@7c3ef799f2b0e05d4b24ee0912aaaf3da301324c) ([merge request](gitlab-org/gitlab!149749))
- [Add jitter to StoreSecurityReportsWorker lock retries](gitlab-org/gitlab@b4e73b0031a480480b79a101f8ed7c29b5eaa96a) ([merge request](gitlab-org/gitlab!149719)) **GitLab Enterprise Edition**
- [Fix link to self-hosted docs in sidebar help menu](gitlab-org/gitlab@b51e610d0342c70937d55bfea84fe93f01ed5567) ([merge request](gitlab-org/gitlab!149559))
- [Fix prominent create board button alignment](gitlab-org/gitlab@bf3e30be8a81fbf100da97926d7115a2576bb0cc) ([merge request](gitlab-org/gitlab!149678))
- [Fix error for truncated height](gitlab-org/gitlab@65ef05bb40817120415bb956228ce0ab12701767) ([merge request](gitlab-org/gitlab!149674))
- [Fix incorrect `locked` state for missing group settings](gitlab-org/gitlab@444c113305aff21682f0e31bf6f86888c0556182) ([merge request](gitlab-org/gitlab!148986)) **GitLab Enterprise Edition**
- [Fix FetchPolicyApproversService for ComplianceFramework](gitlab-org/gitlab@414d88e171224d65b7da130526d16aee9323d680) ([merge request](gitlab-org/gitlab!149554)) **GitLab Enterprise Edition**
- [Use new math ability of markdown parser](gitlab-org/gitlab@bc9473d1aae65b55c3cabb58772dceb6a9bc1a4d) ([merge request](gitlab-org/gitlab!148702))
- [Update split i18n strings to be more translatable](gitlab-org/gitlab@746789fd35b5a8c4f57067ad66e0e0c0a8533eac) ([merge request](gitlab-org/gitlab!148112))
- [Fix built-in shadows in empty state dashboard SVGs](gitlab-org/gitlab@ceeab678504bf98cb2b2f92cca666462ad94dc83) ([merge request](gitlab-org/gitlab!149595))
- [Fixing Flaky Test in ConsistencyCheckService](gitlab-org/gitlab@acfd7f91bf183f8ac942fa75a80fc44b77cd0d03) ([merge request](gitlab-org/gitlab!149564))
- [Fix LFS token check & add test for specific case](gitlab-org/gitlab@d21e5b4f41445793795ca1567f08861cf1345bb3) by @kevin.gosa ([merge request](gitlab-org/gitlab!149474))
- [When localStorage draft exists for comment reply, show it on load](gitlab-org/gitlab@dfbec8b4924b37c6fb593d40df96e4477dbc3039) ([merge request](gitlab-org/gitlab!149159))
- [Fix missing webUrl for associated framework projects](gitlab-org/gitlab@462271f1c333610372ba5884c3105c235a70eb9d) ([merge request](gitlab-org/gitlab!148080)) **GitLab Enterprise Edition**
- [Update fog-google to v1.24.1](gitlab-org/gitlab@c587b42c263634b933be33ffe73f7e8af177e2b6) ([merge request](gitlab-org/gitlab!123999))
- [Return Snippet.none when not referencing a project](gitlab-org/gitlab@f4ce2773ee78053b017f85236a2d36cf27b285e0) ([merge request](gitlab-org/gitlab!149308))
- [Remove "fork_targets_finder_with_parents" feature flag](gitlab-org/gitlab@b8c74a682e8e3f34527d7560cbdd987b8276173b) ([merge request](gitlab-org/gitlab!149234))
- [Fix downstream pipeline background color in dark mode](gitlab-org/gitlab@3ad0077f343d1ef3dfce799104db0d834d3f1b4f) ([merge request](gitlab-org/gitlab!149176))
- [Remove lazy_merge_request_committers feature flag](gitlab-org/gitlab@13ebc1f188cae31c4018fd55d42d6779f851d7e8) ([merge request](gitlab-org/gitlab!149062))

### Changed (228 changes)

- [Show project that invited group users on usage quota > seats page](gitlab-org/gitlab@d65519052156da86f9d1b50f3e1b9b2d4cee70c1) ([merge request](gitlab-org/gitlab!150852))
- [Make default admin email not a known value](gitlab-org/gitlab@d4bff3028a5204852ec36e9bc749522f4adc995a) ([merge request](gitlab-org/gitlab!150388))
- [Fix(Confirm Order): handle 3DS failure](gitlab-org/gitlab@db2ffc6b98d979f7f0c0e689cfafed51623cb4d5) ([merge request](gitlab-org/gitlab!152209)) **GitLab Enterprise Edition**
- [Add a generic error message when the error response is not of JSON type](gitlab-org/gitlab@080079cdd89f28c5d3edb87702e9e67a168f3d5b) by @antonkalmykov ([merge request](gitlab-org/gitlab!151572))
- [Use Claude 3 for some parts of Duo Chat](gitlab-org/gitlab@32fa9eaa3c8589ee7f448ae683710ec7bd82f36c) ([merge request](gitlab-org/gitlab!152544)) **GitLab Enterprise Edition**
- [Add visual indicators for some items](gitlab-org/gitlab@db85d9d870d77c9ea7c2aa1aa843c2fc1062f9fc) ([merge request](gitlab-org/gitlab!152496))
- [Remove 'Get Started' page during registration](gitlab-org/gitlab@7cb1c42045694e267dd9cce2351b2cd7f52e07c3) ([merge request](gitlab-org/gitlab!152098)) **GitLab Enterprise Edition**
- [Use full-width for both inline and side-by-side diffs in compare](gitlab-org/gitlab@c703b2577802096ab4ba6439c9592b7e0b694f11) ([merge request](gitlab-org/gitlab!152432))
- [Update empty settings search result page](gitlab-org/gitlab@984e7fa13f91b6a1ca5afeb5d0494b7edd9ff976) ([merge request](gitlab-org/gitlab!152072))
- [Remove :jira_multiple_project_keys feature flag](gitlab-org/gitlab@ed1b477bb139abd7f00bf8b4a6cee7c2cd725cbc) ([merge request](gitlab-org/gitlab!151753))
- [Remove role=button from related issues input](gitlab-org/gitlab@c1c4466266c9163de2535cd1c9f8daf4cabcb7c3) ([merge request](gitlab-org/gitlab!152558))
- [Add logging for keep-around references](gitlab-org/gitlab@00d7d67039c4979a2762ec7a8fea5c790ff2375e) ([merge request](gitlab-org/gitlab!152555))
- [Update how header anchors ids are generated](gitlab-org/gitlab@c1f016755540a570a9aaa75c2c159965417f1824) ([merge request](gitlab-org/gitlab!152088))
- [Remove use_database_for_dependencies_api feature flag](gitlab-org/gitlab@4042799921d559eaa27f4e6b9778fe6fe6b8c226) ([merge request](gitlab-org/gitlab!152540)) **GitLab Enterprise Edition**
- [Update global search comments results UI](gitlab-org/gitlab@d54b5b48558759a4e2ca610f614ee3b056c71307) ([merge request](gitlab-org/gitlab!151956))
- [Update "removal" language to "deletion" for groups](gitlab-org/gitlab@295d4cd519f1b666e468350d64a758fd8dff4e1a) by @antonkalmykov ([merge request](gitlab-org/gitlab!151000)) **GitLab Enterprise Edition**
- [Allow overriding restricted variables from Scan Execution Policy](gitlab-org/gitlab@2601ae273dc7f18c23453c55581533fd28106295) ([merge request](gitlab-org/gitlab!152113)) **GitLab Enterprise Edition**
- [Improves alert message when multiple error packages exist](gitlab-org/gitlab@219a8a5bbe5d76701b37467018a123c801d0ec96) ([merge request](gitlab-org/gitlab!151550))
- [Adds logo for Pumble integration](gitlab-org/gitlab@7fbff99b12a1efe7f67f899f2f289a0ab22c0a58) ([merge request](gitlab-org/gitlab!152349))
- [Disable runner registration tokens on self-managed instances](gitlab-org/gitlab@d7beba5f5b04f3f16b2fd9436fd42454e4847875) ([merge request](gitlab-org/gitlab!150648))
- [Swap primary key with bigint column for ci_pipelines](gitlab-org/gitlab@481c3e58d76c1217457c95caf8259d5efb64cd23) ([merge request](gitlab-org/gitlab!121123))
- [Remove feature flag from downstream pipeline](gitlab-org/gitlab@cf70bff7faf32bbb45870a7aedd6b7b2d4295cb6) ([merge request](gitlab-org/gitlab!152267))
- [Clean up cs_connect_with_sales feature and productize feature](gitlab-org/gitlab@dedd37ed4a7295322b78e5b65b6d6d6fc2fe28c6) ([merge request](gitlab-org/gitlab!151777)) **GitLab Enterprise Edition**
- [Remove FF "allow_nokogiri_parse_huge_xml"](gitlab-org/gitlab@f90c0b4338f1c2b349e3d9c6d556e9ee799237a9) ([merge request](gitlab-org/gitlab!151138))
- [Changed timelogCreate mutation to not require the spentAt field](gitlab-org/gitlab@9dea68207e32e5d7316acf389bec10685dd01524) by @zillemarco ([merge request](gitlab-org/gitlab!150564))
- [Release changing npm package upload from sync to async](gitlab-org/gitlab@d0603c8511ca322345a881f82c055cdacbca3a97) ([merge request](gitlab-org/gitlab!152397))
- [Updating ci_build and pipeline tracking data_category](gitlab-org/gitlab@96788521ddc0a5e70869591327b98b25adab64d2) ([merge request](gitlab-org/gitlab!152284))
- [Makes issue list title inline](gitlab-org/gitlab@987c5d75465e22792e4f11b573b3df8b2e4e93c0) ([merge request](gitlab-org/gitlab!152227))
- [Updating help text for Ci/Cd](gitlab-org/gitlab@adfdd9eb85bf91c597bff41297f85e8caf95a3d4) ([merge request](gitlab-org/gitlab!151440))
- [Use database for dependency exports](gitlab-org/gitlab@70f4593de5f2f618b123177dd9d45d8759c93dab) ([merge request](gitlab-org/gitlab!150879)) **GitLab Enterprise Edition**
- [Remove double border on todo row hover](gitlab-org/gitlab@5027d1793fca982f38aac85f6da27c3007b9be48) ([merge request](gitlab-org/gitlab!152416))
- [Skip committer email checks for commits signed by GitLab](gitlab-org/gitlab@7064b8f8cdb81678a90fcb51edc1e099c740efa6) ([merge request](gitlab-org/gitlab!151755))
- [Replace gl-word-break-all to gl-break-all](gitlab-org/gitlab@cbc0f09027935d4f3bec5df6a4df1572ad3d4045) ([merge request](gitlab-org/gitlab!152120))
- [Upgrade to semgrep v5](gitlab-org/gitlab@c945ca7ba442b2fddbc01cfad531e8bc6012ea40) ([merge request](gitlab-org/gitlab!152322)) **GitLab Enterprise Edition**
- [Edit scheduled policy to inform that scan executes around provided time](gitlab-org/gitlab@fa697b857fe2d3b3e36b4b2838899a48cddafb02) ([merge request](gitlab-org/gitlab!152111)) **GitLab Enterprise Edition**
- [Auto expand merge commit message field](gitlab-org/gitlab@180d73a43936cb25963885628231e205c165a199) ([merge request](gitlab-org/gitlab!152365))
- [Refactor text-gl-muted and use gl-text-secondary instead](gitlab-org/gitlab@8b6b379b2914e09fcbd45d07d7e8434588825d4d) ([merge request](gitlab-org/gitlab!152164))
- [Disable deprecated SAST analyzers for 17.0 release](gitlab-org/gitlab@5f218c6822ab4b1fd317a91c66853558f7f3b80f) ([merge request](gitlab-org/gitlab!151632)) **GitLab Enterprise Edition**
- [MR commit message: Add AI icon to generate commit message feature](gitlab-org/gitlab@460658ef0733768f318faf77fc95602a07be2834) ([merge request](gitlab-org/gitlab!152345))
- [Add link to log viewer for long logs](gitlab-org/gitlab@e88d9d13ca52efb09526786f956fbb455062b317) ([merge request](gitlab-org/gitlab!152329))
- [Remove remove_jwks_endpoint FF](gitlab-org/gitlab@3f44fea00787f7630c835bf786c7bb9925892d52) ([merge request](gitlab-org/gitlab!152247))
- [Remove Feature Flag remove_shared_jwts](gitlab-org/gitlab@a70e87d3367e1451abd1aa5b5c6dd8f6e13e76f3) ([merge request](gitlab-org/gitlab!152259))
- [Merge request widget: Fix action button height](gitlab-org/gitlab@ab50b15d808aabe7c6be866a99cd3beb8610b042) ([merge request](gitlab-org/gitlab!152215))
- [Releases: Migrate item to use GlCard](gitlab-org/gitlab@bf18f35c09ef6ecfb1cce4ca02245b1c45ae585e) ([merge request](gitlab-org/gitlab!152059))
- [Set Claude 3 sonnet as code generation default](gitlab-org/gitlab@bb9ed6837092f8a24de0a4f69ce1ab8babe77c06) ([merge request](gitlab-org/gitlab!151589)) **GitLab Enterprise Edition**
- [Merge request list: Add new MR and more actions to Vue FF](gitlab-org/gitlab@65d476688fdc1cc3cf5ab4cb33a2129257195457) ([merge request](gitlab-org/gitlab!150833))
- [Simplify UI text of Google Artifact Management](gitlab-org/gitlab@ab61166d93996d24501230168ea11d68d9252ba4) ([merge request](gitlab-org/gitlab!151397)) **GitLab Enterprise Edition**
- [Upgrade DAST to use version 5](gitlab-org/gitlab@e8ec9ee9d445723acb6fd45900eed6144ef04d3b) ([merge request](gitlab-org/gitlab!151910))
- [Don't upsert work item types if not found in the DB](gitlab-org/gitlab@a357e665eb33592a39e9cbd305b9f757ee199097) ([merge request](gitlab-org/gitlab!151817))
- [Sync indexes and swap columns user_id for p_ci_builds](gitlab-org/gitlab@ebca06927fd0f47d800f2670bb7a01c1784f1237) ([merge request](gitlab-org/gitlab!151470))
- [Breadcrumbs text made more intuitive on new entities pages in Groups](gitlab-org/gitlab@ab7163fbc6333962e32305d2430f69bb7d164086) by @catinbag ([merge request](gitlab-org/gitlab!152114))
- [Fix alignment for global search filter row](gitlab-org/gitlab@ceb0bfdad4ab151c51bfe29959101c9ca8b7f220) ([merge request](gitlab-org/gitlab!151503))
- [Added Branches page link to New Branch page breadcrumbs](gitlab-org/gitlab@cb4e973625e203c63f850efecc7179c6eb5ac17c) by @catinbag ([merge request](gitlab-org/gitlab!151672))
- [Override bootstrap margin](gitlab-org/gitlab@4b9958447fff819f9e9dd3481e844c2fe3a1f08f) ([merge request](gitlab-org/gitlab!151078))
- [Remove FF activity_filter_has_mr](gitlab-org/gitlab@5896631c2eed7ea65de27fa750f62d2e40659f1c) ([merge request](gitlab-org/gitlab!150730)) **GitLab Enterprise Edition**
- [Renames invite_email quickaction to add_email](gitlab-org/gitlab@e26eef74e05c87346c58a29881bb76416bb3c419) ([merge request](gitlab-org/gitlab!151776))
- [Ignore migration-related fields in app settings](gitlab-org/gitlab@a6f1d6a2762a172841d25758da815849a73ce922) ([merge request](gitlab-org/gitlab!151383))
- [Update parent link validate_max_children validation](gitlab-org/gitlab@b9b71d7e0b0e711cc94ba2b398614c8d417ebfc4) ([merge request](gitlab-org/gitlab!152082))
- [Remove link icons from search code results](gitlab-org/gitlab@94523d27dab0c3151e9da8c00b3d9970eb1ca75b) ([merge request](gitlab-org/gitlab!151926))
- [Disable runner registration tokens for all groups on .com](gitlab-org/gitlab@6b1a45adffd3382c3c0c0ff86ac71298857067de) ([merge request](gitlab-org/gitlab!150562))
- [Default-enable `fallback_behavior` flags](gitlab-org/gitlab@04bf5ff7452cd352c89a2f6f47cbc3115e6d8145) ([merge request](gitlab-org/gitlab!152048)) **GitLab Enterprise Edition**
- [Adds WAL receiver saturation indicator](gitlab-org/gitlab@1200923ce2c02cb36086204ced731face5a878b3) ([merge request](gitlab-org/gitlab!150544))
- [Update global search milestone results page](gitlab-org/gitlab@b124df8df7e67a22da097d33b08d4fb53620bc5f) ([merge request](gitlab-org/gitlab!151963))
- [Groups and Projects - Update invite tab name](gitlab-org/gitlab@4e9058929e2f9f74624db135e31f1afa4a31171f) ([merge request](gitlab-org/gitlab!151811))
- [Add batched migration to remove namespace from OS components](gitlab-org/gitlab@276b8aa60ecc03a0aeec4c512123a2d7be6a6d5e) ([merge request](gitlab-org/gitlab!151444))
- [Remove overflow:hidden from gl-card](gitlab-org/gitlab@7db69bb620ea33d01f9cda82cb2a6bd7e39878f0) ([merge request](gitlab-org/gitlab!151909))
- [Rename report abuse to administrator to report abuse in dropdowns](gitlab-org/gitlab@1ffbf5a136dbe9ab9be8bfb1e189974b543d2018) ([merge request](gitlab-org/gitlab!151523)) **GitLab Enterprise Edition**
- [Ignore migration columns in container repository](gitlab-org/gitlab@e2af18612d08a1251aa1d4785c38d00c4702dfc6) ([merge request](gitlab-org/gitlab!151442))
- [Update empty search result](gitlab-org/gitlab@2982a640676d5666e4e27b836ef112525d8bb594) ([merge request](gitlab-org/gitlab!151507))
- [This MR updates text rendering](gitlab-org/gitlab@eb9f41a84cc73fc902f6af23a89e6c05798f95f8) ([merge request](gitlab-org/gitlab!151600)) **GitLab Enterprise Edition**
- [Update license_finder to v7.1.0](gitlab-org/gitlab@1cff96eec07ab77a76215f46b3ae467947fdf236) ([merge request](gitlab-org/gitlab!151813))
- [Create new group settings page for analytics](gitlab-org/gitlab@647162b876ef7d08f29ff6da02b85702ca356de5) ([merge request](gitlab-org/gitlab!150943)) **GitLab Enterprise Edition**
- [Remove overflow shadow in favor of border on readme](gitlab-org/gitlab@921ed4d0c79d412d46bfa194971c196a7bfde61c) ([merge request](gitlab-org/gitlab!151060))
- [Show most recent contact in runner details](gitlab-org/gitlab@cee189e5e5da867179fc6f6f114d303eafd8679f) ([merge request](gitlab-org/gitlab!151336))
- [Modify breadcrumbs text](gitlab-org/gitlab@2ec70fb0e4ec3181567303f19bfa28234975c8c9) by @jzeng88 ([merge request](gitlab-org/gitlab!150389))
- [Move repository cleanup under maintenance section](gitlab-org/gitlab@403b074c051695dc41da5acd7b1bfde1e3b2e1d6) ([merge request](gitlab-org/gitlab!150490))
- [Update time tracking report](gitlab-org/gitlab@6ce71a14686fafdcc309c00190dc3a5d49a3002c) ([merge request](gitlab-org/gitlab!151759))
- [Update illustrations for a chart with no jobs](gitlab-org/gitlab@d57464250e8d129ec3d708701a6b28509898c330) ([merge request](gitlab-org/gitlab!148091))
- [Update quick action language](gitlab-org/gitlab@e76ba16ee10c482e17042e5c29cc3712e8d2c7f9) ([merge request](gitlab-org/gitlab!151565))
- [Protected containers: Use icon only for delete rule button](gitlab-org/gitlab@ef2cc2289fc630e7072c0c864ed2ad37553f0911) by @gerardo-navarro ([merge request](gitlab-org/gitlab!150793))
- [Add "Imported" badge to Notes](gitlab-org/gitlab@185e8f495e487bee90686cc48a3db145e97dc08a) ([merge request](gitlab-org/gitlab!151733))
- [Prevented jobs allowed to fail from cancelling the pipeline](gitlab-org/gitlab@23d88edb0dd45c202d0bb62d74d30a3bb1657c08) by @zillemarco ([merge request](gitlab-org/gitlab!149854))
- [Added highlighting of incorrect branch name on new branch page](gitlab-org/gitlab@aebbf990963881fd4683e9a0900013f41e005a05) by @catinbag ([merge request](gitlab-org/gitlab!151690))
- [Update terraform states UI](gitlab-org/gitlab@dad080a70d3d34527374d5e27b6171906ffbd071) ([merge request](gitlab-org/gitlab!151443))
- [Removed published data for error packages](gitlab-org/gitlab@7883447710fe8c3563450998b31f3e73c9fab92a) by @jzeng88 ([merge request](gitlab-org/gitlab!149478))
- [Remove experiment flag from Analytics GraphQL](gitlab-org/gitlab@b736d0cc0dc0951e56d28b1b61f85c2eb17b716f) ([merge request](gitlab-org/gitlab!151658)) **GitLab Enterprise Edition**
- [Update Usage Overview panel to support subgroups](gitlab-org/gitlab@409a0f55235f691bc67362bfc9f8908791c2ffb3) ([merge request](gitlab-org/gitlab!151426)) **GitLab Enterprise Edition**
- [Move Zoekt to Search::Zoekt namespace](gitlab-org/gitlab@9b826b84ab3beb41cc4d5dced8a0db91a846a187) by @jzeng88 ([merge request](gitlab-org/gitlab!150371)) **GitLab Enterprise Edition**
- [Remove overflow:hidden from gl-card](gitlab-org/gitlab@0f821ea9a053585ba98c2b0b07092dc2ca44cfa8) ([merge request](gitlab-org/gitlab!151588))
- [Enable /confidential quickaction for tasks](gitlab-org/gitlab@4693a9da68f7924cdb8b2851cee0af0599d1c4ab) ([merge request](gitlab-org/gitlab!151587))
- [Remove extra borders around filter](gitlab-org/gitlab@807296289cd8af1c0c21cfb496a5a5ae1ede2c53) ([merge request](gitlab-org/gitlab!151449))
- [Secret detection CLI message update](gitlab-org/gitlab@0dab7fc19e1a27121abd77ad4d892108747eb59d) ([merge request](gitlab-org/gitlab!150392))
- [Add modal for epic work item creation](gitlab-org/gitlab@97cf1da14153d3efa8e26012a5bd1b251d443e95) ([merge request](gitlab-org/gitlab!150308)) **GitLab Enterprise Edition**
- [Update component include to use $CI_SERVER_FQDN](gitlab-org/gitlab@e7409c2459f1c88cd74600eb45c8f18034d667ca) ([merge request](gitlab-org/gitlab!151545))
- [Apply rate limit to project hook test API endpoint](gitlab-org/gitlab@5060a4e4f8cc260bdfecefc5fa8a344872b3a4e7) ([merge request](gitlab-org/gitlab!150066))
- [Removes "new" badge next to fleet dashboard link](gitlab-org/gitlab@c206cfc04b7e5334e0d6de58416aa86dcd1b46df) ([merge request](gitlab-org/gitlab!151534))
- [Remove the left and right borders from the registry search block](gitlab-org/gitlab@cee27e155c26a7752f1602022a03a0c22f926f6a) by @antonkalmykov ([merge request](gitlab-org/gitlab!151524))
- [Update schema for clusterwide tables in threat insights](gitlab-org/gitlab@5fd368e4325662ddc4a1b7c8448cd71cd9a5605b) ([merge request](gitlab-org/gitlab!149630))
- [Update constants in catalog](gitlab-org/gitlab@7536250df8d2fdc3c58c0f463973f9a0213a31b1) ([merge request](gitlab-org/gitlab!149319))
- [Update major version to 5 for DAST API/API Fuzzing](gitlab-org/gitlab@3fb071cc1385f3760ab3a38975d874619966e2ac) ([merge request](gitlab-org/gitlab!150370))
- [Reset pagination on grouping change](gitlab-org/gitlab@369abf0e6b0132575c0ec46d924209f9367629e1) ([merge request](gitlab-org/gitlab!151389)) **GitLab Enterprise Edition**
- [Use "Previous" instead of "Prev" in pagination](gitlab-org/gitlab@53f190b9c6922b72ac44a7b4d7686bc566ce4a08) ([merge request](gitlab-org/gitlab!150729))
- [Make metadata processing optional for Secure Files](gitlab-org/gitlab@b3960b1d2fae82ccd854eacf5e6d0ba708efa234) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151357))
- [Remove `admin_user_filtered_nav` feature flag](gitlab-org/gitlab@d64f499fa6d8fb85634825867c4e35ec5897c406) ([merge request](gitlab-org/gitlab!150288))
- [Log zoekt node name in scheduling service](gitlab-org/gitlab@b9677a4df82e040dbdb79affaa147df263c4a792) ([merge request](gitlab-org/gitlab!151368)) **GitLab Enterprise Edition**
- [Merge request list: Migrate actions to Vue](gitlab-org/gitlab@d2788e1837fd9e60814af647d0de5f08a376303e) ([merge request](gitlab-org/gitlab!150682))
- [Sync indexes and swap columns project_id for p_ci_builds](gitlab-org/gitlab@223b7ab1a1b80e0801010ddec42a4ae27c13bd46) ([merge request](gitlab-org/gitlab!150592))
- [Sync indexes and swap columns project_id for p_ci_builds](gitlab-org/gitlab@86b10535a9b5d08619224cd09a44c991b7d80a57)
- [Update dependency auto-build-image to v4](gitlab-org/gitlab@7869e52dfdcf2f8c385c98ad53078f9852e3d85c) ([merge request](gitlab-org/gitlab!151331))
- [Move new list button out of board header into board content](gitlab-org/gitlab@80d1f00c06a5756cad04a03d17fe595fc0b6d464) ([merge request](gitlab-org/gitlab!149760))
- [Used constant for CSS classes in pipeline_failed_jobs_widget test](gitlab-org/gitlab@bd8862723e2bec436a18b416278fc07226b53235) by @catinbag ([merge request](gitlab-org/gitlab!151125))
- [Restrict member roles REST API](gitlab-org/gitlab@dfb52f4856425afff2d8b4292a6b192277d381fc) ([merge request](gitlab-org/gitlab!149685)) **GitLab Enterprise Edition**
- [Used gitlab-ui classes for time_ago in pipelines_page](gitlab-org/gitlab@dbb38e7f6274c2354e8257749a5c217134c18ee3) by @catinbag ([merge request](gitlab-org/gitlab!151105))
- [Update the global search users results page](gitlab-org/gitlab@2ef4c19f30f0341c99b8e590ce2a64f498e21fff) ([merge request](gitlab-org/gitlab!150739))
- [Add support for DAST 5 to DAST templates](gitlab-org/gitlab@e497574361ad5143bf432790678aa171f39d6656) ([merge request](gitlab-org/gitlab!150289))
- [Use database for dependencies API](gitlab-org/gitlab@817000223f3cca6c782c1e8ecfcf6a411769dfe0) ([merge request](gitlab-org/gitlab!150746)) **GitLab Enterprise Edition**
- [Clean up epics/issues/MR search results](gitlab-org/gitlab@091259e599f347d4c99bd94a649e6b398840194d) ([merge request](gitlab-org/gitlab!150899))
- [Refactor argument splat for edit framework handler](gitlab-org/gitlab@d874f1ac5894cd5446c163ae04031b064537e649) ([merge request](gitlab-org/gitlab!151043)) **GitLab Enterprise Edition**
- [Pipeline Graph page: Improve repsonsive behavior of dropdown](gitlab-org/gitlab@9f4c2ce7a8d11f1ce6a67c2105dc3b4ec0af05a3) ([merge request](gitlab-org/gitlab!149053))
- [Update milestone labels tab](gitlab-org/gitlab@917f6621e27c64053c9d8246dd7467dd7a744327) ([merge request](gitlab-org/gitlab!149395))
- [Pipeline MiniGraph: Update tooltip content and direction](gitlab-org/gitlab@60e62f7a7e0d8a2e3e57e90534e36ce2b1684c18) ([merge request](gitlab-org/gitlab!150798))
- [Add new illustrations to product analytics onboarding flow](gitlab-org/gitlab@46a2191ab4e85f96e6a67826c0d8c7c615f7cce6) ([merge request](gitlab-org/gitlab!148771)) **GitLab Enterprise Edition**
- [Add "Imported" badge to Snippet header](gitlab-org/gitlab@3b9680de058bec44b6302463774580fb8884596d) ([merge request](gitlab-org/gitlab!150828))
- [Update `flux_resource_path`](gitlab-org/gitlab@1fd4900c8e5ede2a31a97cb436d1306687bc4feb) ([merge request](gitlab-org/gitlab!149915))
- [Update ProjectPipelinesResolver preloads](gitlab-org/gitlab@a48f643efca4c0c3bdbc14556103b8bf62807b0c) ([merge request](gitlab-org/gitlab!150922)) **GitLab Enterprise Edition**
- [Added margin top to pipeline tabs](gitlab-org/gitlab@483078e2168895e725fec4a0aa06bdbfcdcffad1) ([merge request](gitlab-org/gitlab!150886))
- [Always allow reading external pipeline builds](gitlab-org/gitlab@1251422ae11ec623c6406f25168d04e257eb9b36) ([merge request](gitlab-org/gitlab!150567))
- [Update permissions to relate issues](gitlab-org/gitlab@ab9915e9035fe7d8d697c25947c14555fdcbd0e2) ([merge request](gitlab-org/gitlab!148372)) **GitLab Enterprise Edition**
- [Check membership with all_group_members](gitlab-org/gitlab@4d05f9c34568bcd0f28257a009e91e9994e710cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150487)) **GitLab Enterprise Edition**
- [Add "Imported" badge to designs](gitlab-org/gitlab@c80e15c555ea375d97964b773ed101497b09aea7) ([merge request](gitlab-org/gitlab!150625))
- [User profile readme: Add ability to use hash scrollTo event](gitlab-org/gitlab@30183c60261e3f3eaac118916972d5846076581b) ([merge request](gitlab-org/gitlab!150307))
- [Move platform selection to runners "register" step](gitlab-org/gitlab@84f4e3c6165ccfd83579543e99af9098cca73ef2) ([merge request](gitlab-org/gitlab!148939))
- [Remove FF activity_filter_has_remediations](gitlab-org/gitlab@bd24183ddb5dd20ccfa9350d6c92468513163e31) ([merge request](gitlab-org/gitlab!150532)) **GitLab Enterprise Edition**
- [Change project_level_sbom_occurrences default](gitlab-org/gitlab@cc1634927a6e15894e69457d8b5e4c797035373a) ([merge request](gitlab-org/gitlab!150628)) **GitLab Enterprise Edition**
- [Removes link to log viewer](gitlab-org/gitlab@3390fe3929fd4cfa94284a34b0be589a2a613508) ([merge request](gitlab-org/gitlab!150773))
- [Improve registry search query params generation](gitlab-org/gitlab@9fd49f2308b8e7bb64981f1ce9788b798f1c3b1d) ([merge request](gitlab-org/gitlab!150137))
- [Update syntax options drawer title](gitlab-org/gitlab@3ee68f9246fbc586a20d930120509f86c4a6faa1) ([merge request](gitlab-org/gitlab!150740))
- [Align presentation of pending deletion tab](gitlab-org/gitlab@022e0ae9d3e55b0ddb857f4a28cbe87059397da8) by @r2abreu ([merge request](gitlab-org/gitlab!148594)) **GitLab Enterprise Edition**
- [Add frontend validation for framework names](gitlab-org/gitlab@06a7cd59844c0985051abac9d58f079543d8ccf6) ([merge request](gitlab-org/gitlab!150699)) **GitLab Enterprise Edition**
- [Only show project limits alert on affected project](gitlab-org/gitlab@721ebe8d274eb5b470a39f71253c36a19184dd24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150017)) **GitLab Enterprise Edition**
- [Remove purchase_code_suggestions feature flag](gitlab-org/gitlab@7c28632ca53e7afac1a8cbd1cf892660fe48b576) ([merge request](gitlab-org/gitlab!150447)) **GitLab Enterprise Edition**
- [Highlight search text on the global search result page](gitlab-org/gitlab@3003cb7cdab09c047990801a2538d0fbabc2898f) ([merge request](gitlab-org/gitlab!150452))
- [Remove start_pre_import method](gitlab-org/gitlab@6b623b6444bfcbc166811c9a85d6415f38019fbb) ([merge request](gitlab-org/gitlab!148009)) **GitLab Enterprise Edition**
- [Fix(Purchase addon): handle errors in the frontend](gitlab-org/gitlab@5024e47e158df6458c3be748a335a6b962b212d3) ([merge request](gitlab-org/gitlab!149817)) **GitLab Enterprise Edition**
- [Fix(Purchase): handle 3DS error in the frontend](gitlab-org/gitlab@ec341094614d81e564fe140faaacab21a3b5b021) ([merge request](gitlab-org/gitlab!149734)) **GitLab Enterprise Edition**
- [Swap columns runner_id for p_ci_builds](gitlab-org/gitlab@1f923a06d8c2360b0b485a077b4ba182cdd26e79) ([merge request](gitlab-org/gitlab!149204))
- [Issue list: Update search bar](gitlab-org/gitlab@d944e18b01623693056bfb993cc635f43668f65d) ([merge request](gitlab-org/gitlab!150473))
- [Return or display Gitlab version if GITLAB_KAS_VERSION is a SHA](gitlab-org/gitlab@f8642296278a94f686f1ef07875f934c56f1fcbc) ([merge request](gitlab-org/gitlab!149794))
- [Render Storage Usage Quotas for Profile in CE](gitlab-org/gitlab@f2f5d665160dc3db5a75abfa1107020aa3d6c6f2) ([merge request](gitlab-org/gitlab!148661))
- [Fix bottom border for the last commit block](gitlab-org/gitlab@06a06a55245514135cf0b9b445fca5a130c80664) ([merge request](gitlab-org/gitlab!150538))
- [Update grpc to v1.62.0 and gitlab-labkit to v0.32.0](gitlab-org/gitlab@9bcf0c32a594e7e8dfc1255c54e4793d23d3705a) by @gitlab-dependency-update-bot ([merge request](gitlab-org/gitlab!148887))
- [Update multiple entries in a single input guidance text](gitlab-org/gitlab@1b01d87c1192dbef95bbd007d17f8b1d1511df7e) ([merge request](gitlab-org/gitlab!150523))
- [Replace "Play" with "Run" in pipeline action button titles](gitlab-org/gitlab@9edf5ba758f32ffdbb58c66971e4af7a3a14803b) ([merge request](gitlab-org/gitlab!150521))
- [Add "Imported" text to User profile activity](gitlab-org/gitlab@7a5af7892e31c0db59334ad7052c7536a305bc2c) ([merge request](gitlab-org/gitlab!150485))
- [Branch Rules: Allow to merge section with edit](gitlab-org/gitlab@211d88f7821b8de144046347490307c06348ff04) ([merge request](gitlab-org/gitlab!150269))
- [Replace references to deprecated runner fields](gitlab-org/gitlab@b61703540f8106873846101ac8eda285138a4d1d) ([merge request](gitlab-org/gitlab!150100))
- [Update badges on project security configuration page](gitlab-org/gitlab@88a38fbc010fc3ef6939219c51fdd7c96f1e8e4b) ([merge request](gitlab-org/gitlab!150037))
- [Milestone header: Migrate kebab menu to GlDisclosureDropdown](gitlab-org/gitlab@e7cdbb5cc2102354e549ca14d698beee3884f329) ([merge request](gitlab-org/gitlab!148844))
- [Merge request: Show code dropdown on small screens](gitlab-org/gitlab@1da9fb05e47177be6a8784f4b3dd8e82379105d6) ([merge request](gitlab-org/gitlab!150418))
- [Remove usage of `latest` for non catalog resource projects](gitlab-org/gitlab@31a0e5786accc049ead8ee916bea764eb0c7c71b) ([merge request](gitlab-org/gitlab!149288))
- [Remove lock icon from admin mode setting](gitlab-org/gitlab@96b9ec42317b142594fa5e63d01847218ea9620c) ([merge request](gitlab-org/gitlab!150356))
- [GraphQL: Rename RunnerMembershipFilter to CiRunnerMembershipFilter](gitlab-org/gitlab@8945cbe4a09fdee80f0953487b3e91cddc96b8f3) ([merge request](gitlab-org/gitlab!148316))
- [GraphQL: Change CiRunnerType.projects default sort order](gitlab-org/gitlab@5eb0c7e987439f919c13ae042ddd013c7524c680) ([merge request](gitlab-org/gitlab!148199))
- [Upgrade Secret Detection Analyzer to v6 in CI templates](gitlab-org/gitlab@c0494ea58a8fce76244fcb48f773a03d664a5fc9) ([merge request](gitlab-org/gitlab!150332))
- [Allow migrations to be skipped on condition](gitlab-org/gitlab@5ea06881b7c738d3939835470f11ec2fc4c07995) ([merge request](gitlab-org/gitlab!149209)) **GitLab Enterprise Edition**
- [Update dependency auto-build-image to v3](gitlab-org/gitlab@d7367237395cbc0564a6aff8671f1ab6b91d4a36) ([merge request](gitlab-org/gitlab!150282))
- [Add new stream only audit event for repo download of public projects](gitlab-org/gitlab@7b90b0d5df0a6f92c004ed272fe81d0d184a0825) ([merge request](gitlab-org/gitlab!149842)) **GitLab Enterprise Edition**
- [Migrate explore search and sort to filtered search bar](gitlab-org/gitlab@b4c80706967cdb728f11691ba5c522de84296c2b) ([merge request](gitlab-org/gitlab!148880))
- [Update time tracking UI](gitlab-org/gitlab@28fc2624572383f3071f5af32a0564dcbe5cbf0a) ([merge request](gitlab-org/gitlab!150270))
- [Change to work item namespace query](gitlab-org/gitlab@39fb93375731494acbcefeccf9b3f9c86061fe40) ([merge request](gitlab-org/gitlab!146752))
- [Add "Imported" badge to epic header](gitlab-org/gitlab@ace2ad4a72d62a1414b07daef0ac97466fc4e6b8) ([merge request](gitlab-org/gitlab!150266)) **GitLab Enterprise Edition**
- [Change Duo Chat default final error message to be more friendly](gitlab-org/gitlab@211ab9261cfd3b270c344c81956c2f279215b094) ([merge request](gitlab-org/gitlab!150179)) **GitLab Enterprise Edition**
- [Remove connecting lines in group list](gitlab-org/gitlab@9921e040bfb8f0499890321f41680a520cded683) ([merge request](gitlab-org/gitlab!150169))
- [Remove 'and' from component list](gitlab-org/gitlab@d1d0c05510ab6b21882dc7e4644f09701c21e201) ([merge request](gitlab-org/gitlab!150049))
- [Capture running builds on non-shared runners](gitlab-org/gitlab@b04070c4d1d164ab9dab6ee8dbb2a37c50689303) ([merge request](gitlab-org/gitlab!150172))
- [Update Usage Overview panel to support subgroups](gitlab-org/gitlab@8ad87d225d28e00ead206a5c6c97255221661b0b) ([merge request](gitlab-org/gitlab!150052)) **GitLab Enterprise Edition**
- [Add "Imported" badge to MR header](gitlab-org/gitlab@14855c11e959d9b73439609ebab78962610515bb) ([merge request](gitlab-org/gitlab!150095))
- [Update analytics docs links for some metrics](gitlab-org/gitlab@a3a75e642d251144b81471049d2762cee4aeac12) ([merge request](gitlab-org/gitlab!150133))
- [Support JOB-TOKEN authentication header for generic packages](gitlab-org/gitlab@1b32ed844a4b044a192965de546b058e12126ee7) ([merge request](gitlab-org/gitlab!138770))
- [Format dates on analytics dashboards](gitlab-org/gitlab@0488252b815ec5296651492395457782d0b769a9) ([merge request](gitlab-org/gitlab!149946)) **GitLab Enterprise Edition**
- [Add imported badge on issue page](gitlab-org/gitlab@9649b40c9d53f9a83ca4923705a6e7103148e8a5) ([merge request](gitlab-org/gitlab!149876))
- [Fix display Mermaid plots in project CI/CD setting pages](gitlab-org/gitlab@619ad675a055e17b2d081bc762d563623a8ae740) by @dannyelcf ([merge request](gitlab-org/gitlab!149611))
- [Fix hover underline in comments icon in list view](gitlab-org/gitlab@bc2748136bc9a8a30c77f7f498d5ce2c78a69073) ([merge request](gitlab-org/gitlab!149024))
- [Hide archived filter toggle with selected project](gitlab-org/gitlab@703d6aa24b37ecd66a160dbd419567ca8df46966) ([merge request](gitlab-org/gitlab!148969))
- [Display commit title instead of message](gitlab-org/gitlab@6adf2ad84aeca7bb58e2aa597001359e1ce813e5) ([merge request](gitlab-org/gitlab!150018))
- [Update dependency auto-build-image to v2.1.0](gitlab-org/gitlab@9978397bc2d051c193951832fa37758b5b1b00de) ([merge request](gitlab-org/gitlab!150014))
- [Upgrade Container Scanning to v7](gitlab-org/gitlab@19f500530b73f79acd52da3034db428a825122a4) ([merge request](gitlab-org/gitlab!150007))
- [Upgrade to Gemnasium v5](gitlab-org/gitlab@f21733826ffe490584462ae32d382f18cb951d78) ([merge request](gitlab-org/gitlab!150000)) **GitLab Enterprise Edition**
- [Package registry list: Change metadata appearance](gitlab-org/gitlab@6b394212f98c5d46004188039c2e8362669c918b) ([merge request](gitlab-org/gitlab!149834))
- [Use GITLAB_LOG_LEVEL for Geo logs](gitlab-org/gitlab@5d4aae5e21d062d12ee958cf81464f74e80c1b93) ([merge request](gitlab-org/gitlab!149786)) **GitLab Enterprise Edition**
- [Unblock fail-open `license_scanning` rules without target pipeline](gitlab-org/gitlab@dd80989d9ae9ca6f5d5649d7601fff4e038ce21a) ([merge request](gitlab-org/gitlab!149688)) **GitLab Enterprise Edition**
- [Update description field component](gitlab-org/gitlab@4ab3be0dbc800ea544fdd355f7277ab63ac93747) ([merge request](gitlab-org/gitlab!148359))
- [Update URLs for Terraform module registry pages](gitlab-org/gitlab@37204cac93fc47a42fff00eb675cbe92f55ab728) by @jzeng88 ([merge request](gitlab-org/gitlab!149477))
- [Change unneeded js test attribute to data attribute](gitlab-org/gitlab@51183c70fb26851a5764694db4d807478547f82b) by @bahek2462774 ([merge request](gitlab-org/gitlab!149673))
- [Remove restrict_member_roles feature-flag](gitlab-org/gitlab@5624ff325ec541f2920a1aaa4719e5ee00295dc4) ([merge request](gitlab-org/gitlab!149515)) **GitLab Enterprise Edition**
- [Redesign create custom role permissions list](gitlab-org/gitlab@eecc27db83f30537a60208edf83af11ed7183319) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148645)) **GitLab Enterprise Edition**
- [Add Duo Chat GA alert](gitlab-org/gitlab@fd1d7cc4ee548cab0b3a69c2cb50b20ebbc8a9eb) ([merge request](gitlab-org/gitlab!149329)) **GitLab Enterprise Edition**
- [Turn off the Trial Abandonment Survey sent from the GitLab application](gitlab-org/gitlab@e72709e59d24ed7032cc525d2dbb32cf805afd1d) ([merge request](gitlab-org/gitlab!149709)) **GitLab Enterprise Edition**
- [Cleanup Feature Flag: usage_quotas_for_all_editions](gitlab-org/gitlab@9fb1f9f4569bd35c1c0db685c0b53b55f97a2b9d) ([merge request](gitlab-org/gitlab!149041))
- [Add `fallback_behavior` property to MR approval policies](gitlab-org/gitlab@41530a9e97c17aa0a8a6debfac5367dfeb5e5faf) ([merge request](gitlab-org/gitlab!147838)) **GitLab Enterprise Edition**
- [Move close action first](gitlab-org/gitlab@acbebe7daedda0f647175735f71d6cc4270e7ad1) ([merge request](gitlab-org/gitlab!149757))
- [Use GITLAB_LOG_LEVEL for Sidekiq server logs](gitlab-org/gitlab@1890f98ec611b842beb828cd36d92ec55c898b89) ([merge request](gitlab-org/gitlab!149790))
- [Protected packages: Use icon only for remove action](gitlab-org/gitlab@8283b0af11fd7d707ced1418c7f7d7f09860acf4) ([merge request](gitlab-org/gitlab!149836))
- [Remove :new_pipeline_graph FF](gitlab-org/gitlab@85a6e2b15896d910d2c878037a131314f3b7e901) ([merge request](gitlab-org/gitlab!149114))
- [Update dependency auto-deploy-image to v2.90.0](gitlab-org/gitlab@f9086329f65c60a89e68eec12d4cfdd871293f95) ([merge request](gitlab-org/gitlab!149800))
- [Remove duo_chat_current_resource_by_default feature flag](gitlab-org/gitlab@6fe901bdb08f8eab70950f431f52ba2f9bf379e8) ([merge request](gitlab-org/gitlab!149759))
- [Pipeline graph items: Change tooltip orientation, content](gitlab-org/gitlab@52a898b9d87c4844e19303dac2dff3e9a001a374) ([merge request](gitlab-org/gitlab!149296))
- [Save resource verification level on publish](gitlab-org/gitlab@1a791e2700a2c6c7528ec1cfd20c37a2122c1116) ([merge request](gitlab-org/gitlab!149400))
- [Add limitation for semi-linear/ff merge trains](gitlab-org/gitlab@93c351df84a82c493b1c3b531c2069691dc8a5ef) ([merge request](gitlab-org/gitlab!149438)) **GitLab Enterprise Edition**
- [Make basic information section expanded by default](gitlab-org/gitlab@62d562ae632f44718f9cd6846dc28ee5c1a3d34e) ([merge request](gitlab-org/gitlab!149551)) **GitLab Enterprise Edition**
- [Update "View raw" link](gitlab-org/gitlab@a18a83679ff4781dfe4fe512bc7b9de1c8f8c094) ([merge request](gitlab-org/gitlab!149562))
- [Move harbor integration sidemenu entry from operate to deploy](gitlab-org/gitlab@cc0811f931787c694c418e61ee27e0d3dad6d30d) ([merge request](gitlab-org/gitlab!149216))
- [Show alert when project transfer is still running](gitlab-org/gitlab@7995faeb6764d36c600cc209df20071abd4d4d30) ([merge request](gitlab-org/gitlab!148837))
- [Adjust the update password page](gitlab-org/gitlab@cdde74ff444192f320805b63cab9bae663acdd8f) ([merge request](gitlab-org/gitlab!147274))
- [Register Sidekiq queues only from routing rules](gitlab-org/gitlab@7265bfd0c608b8f76dc72c97b2477b995bef0f57) ([merge request](gitlab-org/gitlab!149510))
- [Update compliance framework badge](gitlab-org/gitlab@250960baaff8bd96e54d5206a2763b74fceb979c) ([merge request](gitlab-org/gitlab!143135)) **GitLab Enterprise Edition**
- [MR sidebar: Put loading icon after participants title](gitlab-org/gitlab@3b2f71294f743d72e33668d9d1e2b6a38350e499) ([merge request](gitlab-org/gitlab!149675))
- [Fix flaky test by sorting dependencies](gitlab-org/gitlab@888d0ddb6559b383a2f675c8b9a7b3ababec7cd2) ([merge request](gitlab-org/gitlab!149410)) **GitLab Enterprise Edition**
- [Allow migrations to be skipped on condition](gitlab-org/gitlab@3203bde77fd512d158890cb56ac07f84ae66799e) ([merge request](gitlab-org/gitlab!148812)) **GitLab Enterprise Edition**
- [Cleanup gitlab_duo_chat_requests_to_ai_gateway feature flag](gitlab-org/gitlab@94e43669f28423303f9db3db78b9125f5c3b72dc) ([merge request](gitlab-org/gitlab!149646))
- [Bringing back ability to use iterations in incidents](gitlab-org/gitlab@4f4145b8d0f3b46df6758a379ef1d2deca327486) by @SlickDomique ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148306)) **GitLab Enterprise Edition**
- [Remove unnecessary div for vulnerability modal footer](gitlab-org/gitlab@f7cea70505015d439fbdfe98079a457ebd74761d) ([merge request](gitlab-org/gitlab!149488)) **GitLab Enterprise Edition**
- [Relax constraints when consolidated object storage settings is enabled](gitlab-org/gitlab@c7d3c135d3255af7e113a6056417fde509232519) ([merge request](gitlab-org/gitlab!149480))
- [Pipeline Graph Drodpown: Use fluidWidth](gitlab-org/gitlab@83333a91f13df06a3308b6cea4b81518aa50fef2) ([merge request](gitlab-org/gitlab!149371))
- [Adjust border radius of collapsed conflicted file](gitlab-org/gitlab@7b3370d122b2c293d2853133189267ab9828ca57) ([merge request](gitlab-org/gitlab!149006))
- [Remove usages of `sub-header-block`](gitlab-org/gitlab@1b327f547d8ef2c4d63d1679c3c71d5509faf09e) by @espadav8 ([merge request](gitlab-org/gitlab!148669))
- [GraphQL: Rename CiRunnerUpgradeStatusType to CiRunnerUpgradeStatus](gitlab-org/gitlab@3b72183c58e40024d9482db05e4928a68b43ac26) ([merge request](gitlab-org/gitlab!148315))
- [Update advice for QA selectors in rubocop output](gitlab-org/gitlab@c1daea7ce91a0b891ebdd87c0ff5b17826696355) ([merge request](gitlab-org/gitlab!141745))

### Deprecated (5 changes)

- [Return an empty `pipelines` in the package REST API payload](gitlab-org/gitlab@ca926a17ee0328cfd3d8ec5e974adb7319a67b88) ([merge request](gitlab-org/gitlab!150103))
- [Disable the migration MigrateZoektSettingsInApplicationSettings](gitlab-org/gitlab@20457b7f26dad1b9caed4b3f4b549b31f093dcf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151080))
- [Sunset deprecated args for UpdateRepositoryStorageWorker#perform](gitlab-org/gitlab@96dff484106bf71ea134634722d8c3fce1452c86) ([merge request](gitlab-org/gitlab!136262))
- [REST: Deprecate runner details API fields](gitlab-org/gitlab@0a2a3894ba3e3f3a0e4a03b937fe709af459ce39) ([merge request](gitlab-org/gitlab!150094))
- [Remove CreateEmptyEmbeddingsRecordsWorker class](gitlab-org/gitlab@2f107a9d1098931b1e592ad470509b844a9a151f) by @jzeng88 ([merge request](gitlab-org/gitlab!149473)) **GitLab Enterprise Edition**

### Removed (59 changes)

- [Remove license compliance app](gitlab-org/gitlab@040bab0af542cf807bc7df751d90a52e62681a58) ([merge request](gitlab-org/gitlab!150831)) **GitLab Enterprise Edition**
- [Remove unused code_suggesitons project setting](gitlab-org/gitlab@b05ae4b32bb8447b65352a9fa694869dd060951d) ([merge request](gitlab-org/gitlab!151698))
- [Remove security_policies_breaking_changes feature flag](gitlab-org/gitlab@edbf6dc999b80f2d93db5993319989b1f3876fa6) ([merge request](gitlab-org/gitlab!151946)) **GitLab Enterprise Edition**
- [Remove confidential attribute from Note](gitlab-org/gitlab@f918ecacffbf69057c91c6e94a9710a19dc77320) ([merge request](gitlab-org/gitlab!151557))
- [Drop table geo_hashed_storage_migrated_events](gitlab-org/gitlab@62db14ff8c00076be20189a2cd93f6a2b2683bdc) ([merge request](gitlab-org/gitlab!151938))
- [Remove usages of deprecated runner fields](gitlab-org/gitlab@667c26e9d3a084a3b8f42dc5dcd31a1774a822f5) ([merge request](gitlab-org/gitlab!151350))
- [Remove compliance framework from settings](gitlab-org/gitlab@64e1fcf89777623e7a740f06d9a8026a24d6210d) ([merge request](gitlab-org/gitlab!152176)) **GitLab Enterprise Edition**
- [Remove Facebook OmniAuth integration](gitlab-org/gitlab@2987a84416a1b36cfd84e9259565d21214c42a5a) ([merge request](gitlab-org/gitlab!151348))
- [Delete temporary_storage_increase feature flag](gitlab-org/gitlab@3105db075bf10a9f742d7e8c1288b07d50946cf7) ([merge request](gitlab-org/gitlab!151386)) **GitLab Enterprise Edition**
- [Remove Twitter OmniAuth integration](gitlab-org/gitlab@965acf966a1c74148cebe4d6187c8262012e93a5) ([merge request](gitlab-org/gitlab!151345))
- [Remove deprecated canDestroy and canDelete GraphQL fields](gitlab-org/gitlab@9eb4dd8c6ab0a959ee8625d0b46e541e8dac646b) ([merge request](gitlab-org/gitlab!150701))
- [Remove loading status spinner for hand raise lead button](gitlab-org/gitlab@06cb796a3a6d0f2d28064fa5077cc456cec1b9cc) ([merge request](gitlab-org/gitlab!152119)) **GitLab Enterprise Edition**
- [Remove min and max_concurrency option in Sidekiq cluster](gitlab-org/gitlab@45af39fc59a80dca7f4016fe10ba9f8af09ccd79) ([merge request](gitlab-org/gitlab!149972))
- [Remove deprecate_unified_approval_rules feature flag](gitlab-org/gitlab@f8114c66a6f80b58448ccddb0e09d807df65ceaf) ([merge request](gitlab-org/gitlab!152099))
- [Remove beta badge](gitlab-org/gitlab@1cad27ef52b17b21032b21fc0a3030465134140e) ([merge request](gitlab-org/gitlab!151949))
- [Remove unused FK(s) on geo_event_log table](gitlab-org/gitlab@ff1e373e3506b00f7eaf2d806f89b3a598a5cb7d) ([merge request](gitlab-org/gitlab!150892))
- [Remove calls to the import API endpoints](gitlab-org/gitlab@120036d15aa7b9286ad1c16508e392c605e28ac2) ([merge request](gitlab-org/gitlab!150741))
- [Remove dead code from details page](gitlab-org/gitlab@e346b881c3dbfa9a1b308f24b230a8ba9acdc259) ([merge request](gitlab-org/gitlab!151576))
- [Remove unused Dependency Scanning jobs](gitlab-org/gitlab@1977c36d76d02bb3e346d1f156bff61c1d057108) ([merge request](gitlab-org/gitlab!150917))
- [Remove ScanResultPolicy.groupApprovers graphql field](gitlab-org/gitlab@082a71669275a2329780c92cc592cf4d1f33b68e) ([merge request](gitlab-org/gitlab!150834)) **GitLab Enterprise Edition**
- [Remove deprecated Geo prometheus metrics](gitlab-org/gitlab@ce40d131b88d1bc660981774b35defdba36d0518) ([merge request](gitlab-org/gitlab!150549)) **GitLab Enterprise Edition**
- [Drop path column](gitlab-org/gitlab@fdf4fb7e5007c892ebc8053a2a6aac255969b773) ([merge request](gitlab-org/gitlab!149738))
- [Remove Dependency Scanning artifact from CS template](gitlab-org/gitlab@9f9a6f66dcb90059f57c14be6c606cd31118bbbb) ([merge request](gitlab-org/gitlab!150540))
- [Remove deprecated GitLab Agent GitOps docs](gitlab-org/gitlab@bf76277a6f63659bd06a7b368ee9f042735ea983) ([merge request](gitlab-org/gitlab!150632))
- [Remove migration worker files and update queues yml](gitlab-org/gitlab@45a8b2d529c207b41643e975764aa6f49a66c625) ([merge request](gitlab-org/gitlab!150214))
- [Replace flawfinder analyzer with semgrep](gitlab-org/gitlab@82edabbe8f8fefa5388449676c1a447b06566434) ([merge request](gitlab-org/gitlab!150839))
- [Remove list_repos Rake task](gitlab-org/gitlab@1071b01b1fbec01c93b7f446135d5de1a9af3186) ([merge request](gitlab-org/gitlab!150535))
- [Remove total_weight from BoardList type](gitlab-org/gitlab@0398ea80b9ef0cd3e5624dfea134bd99f7db812e) ([merge request](gitlab-org/gitlab!150390)) **GitLab Enterprise Edition**
- [Goodbye sentry-raven](gitlab-org/gitlab@20c5881c4631a8cb6db049843586976e342a65c1) ([merge request](gitlab-org/gitlab!148984))
- [Removes old funnels endpoint](gitlab-org/gitlab@d93b487f3f0a973ef797fa99065458b7ec1772ec) ([merge request](gitlab-org/gitlab!150659)) **GitLab Enterprise Edition**
- [Remove visual review tools](gitlab-org/gitlab@c7ff8b6dca08240981f0ea97e3f1b6bcfab382c6) ([merge request](gitlab-org/gitlab!149586))
- [Remove required pipeline configuration feature](gitlab-org/gitlab@bc4e983a2b67f5d48f7653499d85962a453fc6be) ([merge request](gitlab-org/gitlab!150189)) **GitLab Enterprise Edition**
- [Remove vendored omniauth-azure-oauth2](gitlab-org/gitlab@0140ad21eb9147837420b2b0ca1a64d44d3efef7) by @bufferoverflow ([merge request](gitlab-org/gitlab!142276))
- [Remove support for match_on_inclusion](gitlab-org/gitlab@193f00f087a4e991b56f1cdfebfe78bd4d02cb56) ([merge request](gitlab-org/gitlab!143976)) **GitLab Enterprise Edition**
- [GraphQL: Remove deprecated CiRunnerType fields](gitlab-org/gitlab@0f0a1f69765d4e268f5116d8b444acc6be34db72) ([merge request](gitlab-org/gitlab!148319))
- [Remove License Scanning CI templates](gitlab-org/gitlab@4eac33a5c4051472e2d2af5a3a251b8e9ca6138f) ([merge request](gitlab-org/gitlab!149884)) **GitLab Enterprise Edition**
- [Remove onboarding_step_url column from user_details](gitlab-org/gitlab@7443b9722b6c0e18a4def96e7cf00d6a8ab7b3a0) ([merge request](gitlab-org/gitlab!150328)) **GitLab Enterprise Edition**
- [GraphQL: Remove deprecated DISABLED_WITH_OVERRIDE value](gitlab-org/gitlab@784b92d2a260ff24845e98715966d0b291b69459) ([merge request](gitlab-org/gitlab!148201))
- [Remove support for newly_detected vulnerability status](gitlab-org/gitlab@646baa8dd1a08aeb0ba275097ec99aa78b1f27ed) ([merge request](gitlab-org/gitlab!143281)) **GitLab Enterprise Edition**
- [Remove VSA cumulative duration FF](gitlab-org/gitlab@f296f0646247acc043a79d2e892b2461fba17dbf) ([merge request](gitlab-org/gitlab!149248)) **GitLab Enterprise Edition**
- [Replace NodeJS and PHPCS analyzer with semgrep](gitlab-org/gitlab@65527ecd294ade6a2216adabd54f5525c30dbbbb) ([merge request](gitlab-org/gitlab!149788))
- [Remove cadence_validation feature flag](gitlab-org/gitlab@8b399e57310f4821918f45dcde1cc67b09b2e93f) ([merge request](gitlab-org/gitlab!150165)) **GitLab Enterprise Edition**
- [Remove :simplified_labels FF](gitlab-org/gitlab@ce1c903ec87e3698f872c5612852bc1470d7e3cb) ([merge request](gitlab-org/gitlab!129915))
- [Remove networkpolicies field from ProjectType](gitlab-org/gitlab@a187a1ed1945ed99bd66d2dc82369e4541127ce2) ([merge request](gitlab-org/gitlab!142460)) **GitLab Enterprise Edition**
- [Remove `message` field from Vulnerability GraphQL type](gitlab-org/gitlab@46736fe6b051b8aa0e166219b1d38118a48e3ec8) ([merge request](gitlab-org/gitlab!137671)) **GitLab Enterprise Edition**
- [Remove deprecated DORA API fields](gitlab-org/gitlab@e6ae06801b88b8acb63d01caa693e1a3f5de1008) ([merge request](gitlab-org/gitlab!149978)) **GitLab Enterprise Edition**
- [Drop diff summaries table](gitlab-org/gitlab@7935467e36e2863a0737c169048615ec088d2445) ([merge request](gitlab-org/gitlab!148133))
- [Remove min and max_concurrency option in Sidekiq cluster](gitlab-org/gitlab@ea1fc989a0b8e85a1bc952b08674d96e8b48ba82) ([merge request](gitlab-org/gitlab!149690))
- [Clean up duo_pro_trials_for_free_plans feature flag](gitlab-org/gitlab@fdf648678c90714dee906583fd8cd0b8cf687bdb) ([merge request](gitlab-org/gitlab!149743)) **GitLab Enterprise Edition**
- [Dropping unsused table external_approval_rules_protected_branches](gitlab-org/gitlab@f50c1d586b9ae1ec4dd6ac3667369a9f204bef9c) ([merge request](gitlab-org/gitlab!148853))
- [Remove queue selector and negate options from Sidekiq cluster CLI](gitlab-org/gitlab@0c0bbbfb4bac988abe2dba56414cae82144a07a3) ([merge request](gitlab-org/gitlab!149370))
- [Remove shared avatar for security policy bots](gitlab-org/gitlab@c31b160589fc717e88f6f55c9e9eb9e072731da5) ([merge request](gitlab-org/gitlab!149605)) **GitLab Enterprise Edition**
- [Remove legacy replication details routes redirection](gitlab-org/gitlab@30098817b644c41dc245f4afed58124e982ed887) ([merge request](gitlab-org/gitlab!149330)) **GitLab Enterprise Edition**
- [Remove current_stage argument from EntityWorker](gitlab-org/gitlab@9d4374312b5e8dda3eece6d4dd9e2c7c914b6795) ([merge request](gitlab-org/gitlab!149557))
- [Remove deprecated confidence field from GraphQL](gitlab-org/gitlab@081f44cd0e9d0a6b35e1d50f82237868c512e27f) ([merge request](gitlab-org/gitlab!149407)) **GitLab Enterprise Edition**
- [Remove GraphQL field `hasSolutions` from VulnerabilityType](gitlab-org/gitlab@4273fcb36fc04e1507ff1f761461d7c2787f76ed) ([merge request](gitlab-org/gitlab!137668)) **GitLab Enterprise Edition**
- [Remove ci_catalog_create_metadata feature flag](gitlab-org/gitlab@bfb4e397872b98ff3747d2112647c3ab0698e2c7) ([merge request](gitlab-org/gitlab!149547))
- [Remove the feature flag filter_saml_response](gitlab-org/gitlab@8c9bfe5fc7d8fb178391b94518714730c802a05d) ([merge request](gitlab-org/gitlab!149519))
- [Remove auto_fix for security settings](gitlab-org/gitlab@c8b84a9519a60d5ad8d64dc1296c3ac82c284111) ([merge request](gitlab-org/gitlab!149291))

### Security (18 changes)

- [Prevent deploy token bypass for external authentication (Part 2)](gitlab-org/gitlab@4342df404000eb64c0cde74baee01a3ff0211888) ([merge request](gitlab-org/gitlab!122670))
- [Fix confidentiality check optimization](gitlab-org/gitlab@0da5bb1a47564cec8c7aec4fa98c6706eedea195)
- [Enforce per_page validation for Branches/TagsFinders](gitlab-org/gitlab@1c2d72dfb7b4a237c43725857b79144aac30156d)
- [Prevent namespace banned users from reading project todos](gitlab-org/gitlab@937b10cc4cebcc10b870623a547ca093cb4757dc)
- [Validate request origin before MR approval](gitlab-org/gitlab@04e8a5e1f3ac2c678e30f7a14aafdea580272ab1)
- [ReDoS in GitRefsFinder when using wildcards in branch search](gitlab-org/gitlab@790f41315a8dadb9c9d463f931f0c617b1e875c6)
- [Update GITHUB_MEDIA_CDN to avoid SSRF when importing from Github](gitlab-org/gitlab@da3b71d7eaa7b7654343c74fb60f91e12d9781fd)
- [Require confirmation before linking JWT identity](gitlab-org/gitlab@a8a9e972255dfeda3267fce1f21d4e16582aa25e)
- [ReDos in escape and commit reference filters](gitlab-org/gitlab@6f8fe6cfefbb33a61abed8e14ea4a59eb482b366)
- [Check request size before updating user pins](gitlab-org/gitlab@996b8bd92242f7c549bfb624b288cd2c4042ecb2)
- [Update BaseMessage::RELATIVE_LINK_REGEX regex](gitlab-org/gitlab@acca17739e9d1d0591425e3cfc3ef195d64e868a)
- [Update Integrations::Discord::ATTACHMENT_REGEX regex](gitlab-org/gitlab@04bc3196cc6c5ffb7c926c324aa56214ff23839d)
- [Fix guest access for setting time estimate on issues](gitlab-org/gitlab@d93cda44396d5dbec165476bc12a48a9cd280c1b) ([merge request](gitlab-org/gitlab!150026))
- [Forbid untrusted sign-ins to GitLab with Bitbucket and fix related uid](gitlab-org/gitlab@4bff4d82fb045dfc1cce4ef08685c3b3aba2ca6e)
- [fix: Validate security report version against schema during parsing](gitlab-org/gitlab@9aefb64d69d84e19e9e9be73d9f987944b27aca5)
- [Validation for encoded formatting characters](gitlab-org/gitlab@0d03608df342ccf24ef6fc55def837dbedd672bf)
- [Protect against ReDoS in FileFinder with wildcard filters](gitlab-org/gitlab@b1b91959494a16036c361e22e1d3caffd874cc02)
- [Ensure PAT scope is validated everywhere for GraphQL/ActionCable](gitlab-org/gitlab@41e8969408776ef0d7dab741be32ddce39078459)

### Performance (9 changes)

- [Improve ServiceHook and SystemHook specs](gitlab-org/gitlab@d9b8431c40d96c6e0e7ab1e80334f8ff197d4329) ([merge request](gitlab-org/gitlab!152508))
- [Remove pipelines schedules delay feature flag](gitlab-org/gitlab@20e6a4aa163244ce588d6052b44a1597b8751014) ([merge request](gitlab-org/gitlab!152339))
- [Remove ExclusiveLease on setting last_activity_on](gitlab-org/gitlab@028e72cca06c79096a2610a14148a94bdbdbe432) ([merge request](gitlab-org/gitlab!152168))
- [Release avoiding copy operation in terraform modules upload](gitlab-org/gitlab@0a3678937cc5c71dccde3d4adadc13ea646c9802) ([merge request](gitlab-org/gitlab!152052))
- [Remove index index_vulnerabilities_on_detected_at_and_id](gitlab-org/gitlab@d5643728c12dce55cc7ac35126a00401809f280e) by @jzeng88 ([merge request](gitlab-org/gitlab!150759))
- [Use backend filtering for @ autocomplete](gitlab-org/gitlab@69ac80a1a0488a818b3ad952d0b834dff4e41eba) ([merge request](gitlab-org/gitlab!149832))
- [Don't update `vulnerability_reads` records unnecessarily](gitlab-org/gitlab@0f02ba9189e231dd45a00698b5a874136c28f85e) ([merge request](gitlab-org/gitlab!150149)) **GitLab Enterprise Edition**
- [Direct answering instead of using IssueReader](gitlab-org/gitlab@eb35296e2d9446d81eb0c41b439d8def83a538f6) ([merge request](gitlab-org/gitlab!149970)) **GitLab Enterprise Edition**
- [Add limit to RelatedPipelinesFinder](gitlab-org/gitlab@36c807d64147b883395c3aaf058eda52e0aa3b5d) ([merge request](gitlab-org/gitlab!149411)) **GitLab Enterprise Edition**

### Other (191 changes)

- [Fix Layout/LineContinuationLeadingSpace 1](gitlab-org/gitlab@a8691ef95f043661de5bb9d683a9222c9d4193e8) by @archish27 ([merge request](gitlab-org/gitlab!150901)) **GitLab Enterprise Edition**
- [Document `bounded_contexts.yml` in Software Design Guides](gitlab-org/gitlab@cd0121c6c7ed0fadfaceeba4899871303826d4bd) ([merge request](gitlab-org/gitlab!151883))
- [Protected packages: Shorten GraphQL field for](gitlab-org/gitlab@fbbb5e3dd5b7f9f1b2f391991a323a08ea946cca) by @gerardo-navarro ([merge request](gitlab-org/gitlab!151881))
- [Quarantine a flaky test](gitlab-org/gitlab@8d3bb75c690a08b255387a50f1c363ee88f122d8) ([merge request](gitlab-org/gitlab!152464))
- [Quarantine a flaky test](gitlab-org/gitlab@1dfbed37fa6973294e48f662b83fbecda7219884) ([merge request](gitlab-org/gitlab!152463))
- [Quarantine a flaky test](gitlab-org/gitlab@730de9a8c40c71dcdaad9175fb11951e03a34d98) ([merge request](gitlab-org/gitlab!152462))
- [Quarantine a flaky test](gitlab-org/gitlab@ab1529f6caec97e469cff2e80546499042df8d93) ([merge request](gitlab-org/gitlab!152307))
- [Quarantine a flaky test](gitlab-org/gitlab@f9b086ab2a8d77ef001afcc1361db516974709fc) ([merge request](gitlab-org/gitlab!152567))
- [Fix Layout/ArgumentAlignment offenses 25](gitlab-org/gitlab@e5af94d5bfac8836c457df5de55a411262ff2038) by @gauravmarwal ([merge request](gitlab-org/gitlab!151066))
- [Quarantine a flaky test](gitlab-org/gitlab@8d9ed05571720705bfeaeb8f733d65eb3f50d041) ([merge request](gitlab-org/gitlab!152693))
- [Quarantine a flaky test](gitlab-org/gitlab@6f1431ba0d3a454149af568a8d194e35b7f70665) ([merge request](gitlab-org/gitlab!152680))
- [Fix Lint/AmbiguousOperatorPrecedence 17 offenses](gitlab-org/gitlab@f8cc668f200a666273c1db5f88ae3d40a5f5fb38) by @archish27 ([merge request](gitlab-org/gitlab!151166))
- [Removes database migrations up to 16-2-stable-ee](gitlab-org/gitlab@828defcd6e22a2d69b92f4f03d1dfa35859c181e) ([merge request](gitlab-org/gitlab!149003))
- [Refactor "(s)" in quick actions](gitlab-org/gitlab@64fefb28418ba3ed29dabf35c2699251d6146852) ([merge request](gitlab-org/gitlab!152218))
- [Protected packages: Scope feature flag check to project](gitlab-org/gitlab@6b0cbd64882fe58785de275e23e7898de5ef339a) by @gerardo-navarro ([merge request](gitlab-org/gitlab!152208))
- [Drop duplicate index on p_ci_runner_machine_builds](gitlab-org/gitlab@798652849a2679f975dfa707f4ed9ab4e8abfa4d) ([merge request](gitlab-org/gitlab!152337))
- [Fix Layout/MultilineOperationIndentation 2 offenses](gitlab-org/gitlab@2577d7fc3fde307457d4874d7fadf236e1b37753) by @archish27 ([merge request](gitlab-org/gitlab!151226))
- [Remove resolve_all_organization_groups feature flag](gitlab-org/gitlab@d1bf5e1435e59875047c39c33cf3de6a2db85614) ([merge request](gitlab-org/gitlab!152577))
- [Quarantine a flaky test](gitlab-org/gitlab@0da92c020bae30f15c3c05a8e5a6204aeefa18a4) ([merge request](gitlab-org/gitlab!152572))
- [Drop unused index on ci_pipelines_config](gitlab-org/gitlab@8fbb318011dee13df591ff866ae8b6711461fd3a) ([merge request](gitlab-org/gitlab!152333))
- [Fix Layout/SpaceInLambdaLiteral 3 offenses](gitlab-org/gitlab@f75446f390164420b11da263634bb4b587ff5525) by @archish27 ([merge request](gitlab-org/gitlab!151193))
- [Enable `webui_members_inherited_users` feature flag by default](gitlab-org/gitlab@41ef706244f2acac6db5b957811693548ed7f5fb) ([merge request](gitlab-org/gitlab!148237))
- [Fix Layout/ArgumentAlignment offenses 30](gitlab-org/gitlab@e0b9b4f820630e38c78031e0800e000d4d368246) by @gauravmarwal ([merge request](gitlab-org/gitlab!151088))
- [Docs: Update default auth_redirect_uri](gitlab-org/gitlab@c80ecc80d6bb657d5f682f55f9e0b1b60e0beb0f) ([merge request](gitlab-org/gitlab!152352))
- [Remove ci_create_partitions_102 feature flag](gitlab-org/gitlab@eb453b1939e40a13b05cd95994160e6485b3513c) ([merge request](gitlab-org/gitlab!152336))
- [Remove duplicated index from abuse_reports](gitlab-org/gitlab@21f155addb35a6719e1254d81a1fc6edc70b9ba2) ([merge request](gitlab-org/gitlab!152274))
- [Quarantine a flaky test](gitlab-org/gitlab@c56ebf2a7b464c042de6794d192c2b93ec713149) ([merge request](gitlab-org/gitlab!151525))
- [Quarantine a flaky test](gitlab-org/gitlab@418634263d46bbf2283103e1ebb9f1615370b657) ([merge request](gitlab-org/gitlab!151972))
- [Remove useless method from Issuable::DestroyService](gitlab-org/gitlab@14bad30790df377bdcb2313a964ddd95b8adfe51) by @zzaakiirr ([merge request](gitlab-org/gitlab!152384))
- [Fix workhorse linter warnings](gitlab-org/gitlab@d42f8edd8b3f209198d823849402c5c30bf4ffbb) ([merge request](gitlab-org/gitlab!152373))
- [Quarantine a flaky test](gitlab-org/gitlab@a0237fe1c2a097afb9c32643a1dc6e7b1b276322) ([merge request](gitlab-org/gitlab!152310))
- [Quarantine a flaky test](gitlab-org/gitlab@71b8fc193b64f6e4e5c962770b8a66e50863e474) ([merge request](gitlab-org/gitlab!152309))
- [Quarantine a flaky test](gitlab-org/gitlab@a22631dd27c31b07cd4455a26f1fd845d1b60850) ([merge request](gitlab-org/gitlab!152308))
- [Add new invite_email column index on members for new query](gitlab-org/gitlab@e9bd2741e9c6fb1836381dc6a351ec519424a368) ([merge request](gitlab-org/gitlab!152296))
- [Remove duplicated index from board_group_recent_visits](gitlab-org/gitlab@a5308aa8075d5ecf1b5d3e182b87c50025b36cba) ([merge request](gitlab-org/gitlab!152278))
- [Allow CORS for /oauth/token/info](gitlab-org/gitlab@585e6b3d0daadefb4be48167eb20101c9afa4c84) ([merge request](gitlab-org/gitlab!152239))
- [Fix Layout/ArgumentAlignment offenses 23](gitlab-org/gitlab@311531d1fe3ca8f5cc0948e5ad96231d6340126c) by @gauravmarwal ([merge request](gitlab-org/gitlab!151055))
- [Fix Layout/SpaceInsideParens offenses 5](gitlab-org/gitlab@f3590a0eb19a5d1a5f5b910a5150ee5abaf52def) by @archish27 ([merge request](gitlab-org/gitlab!150890)) **GitLab Enterprise Edition**
- [Track redirection counts within a Redis pipeline](gitlab-org/gitlab@f7e1c46ec1eb314dd122415d5c130098be307d85) ([merge request](gitlab-org/gitlab!151875))
- [Fix Layout/SpaceInsideParens offenses 2](gitlab-org/gitlab@f1a7db160b81e23bcc6a2085032efd26fe37ad85) by @archish27 ([merge request](gitlab-org/gitlab!150875))
- [Quarantine a flaky test](gitlab-org/gitlab@a828c82547110fd030f5af0b5eb78e077ba9cf22) ([merge request](gitlab-org/gitlab!152140))
- [Quarantine a flaky test](gitlab-org/gitlab@4b2d88b6c9fd87276d5939332c5542a11e3b8f5e) ([merge request](gitlab-org/gitlab!152139))
- [Quarantine a flaky test](gitlab-org/gitlab@a8ea37f18396ed245edca1553c0f3842e23ab098) ([merge request](gitlab-org/gitlab!152138))
- [Quarantine a flaky test](gitlab-org/gitlab@12ebe4a15d26dd45705a2d1164c7e7502543a332) ([merge request](gitlab-org/gitlab!151855))
- [Fix Layout/ArgumentAlignment offenses 31](gitlab-org/gitlab@077754b9b661f9ca3bf5bc0b32c5b194b207b7a7) by @gauravmarwal ([merge request](gitlab-org/gitlab!151090))
- [Use Gitlab::Redis::ClusterUtil in redis cache store patch](gitlab-org/gitlab@27a439c1df10d586d6c167b7cc777d6aa262ebce) ([merge request](gitlab-org/gitlab!152033))
- [Quarantine a flaky test](gitlab-org/gitlab@6fef9b6b62d7f314d3eada20fb8c4f765f55bbc1) ([merge request](gitlab-org/gitlab!151857))
- [Quarantine a flaky test](gitlab-org/gitlab@47add7b889fadf8a6e6c0acab2eca7248b93f800) ([merge request](gitlab-org/gitlab!152019))
- [Quarantine a flaky test](gitlab-org/gitlab@af643882d701003eaf3d3ffccbfc6e308295b275) ([merge request](gitlab-org/gitlab!152018))
- [Quarantine a flaky test](gitlab-org/gitlab@bc2d6985c122397bc82cde490e85527af28a1b36) ([merge request](gitlab-org/gitlab!151854))
- [Quarantine a flaky test](gitlab-org/gitlab@26b9b4580396248ef79dc1a599e0d25288906ade) ([merge request](gitlab-org/gitlab!151970))
- [Quarantine a flaky test](gitlab-org/gitlab@8ec8a0c95992574f3c1f30751f8f3eeb0725b49f) ([merge request](gitlab-org/gitlab!151986))
- [Quarantine a flaky test](gitlab-org/gitlab@efe23c5c46647d83d47e2168a0489490e5b7eff2) ([merge request](gitlab-org/gitlab!151971))
- [Quarantine a flaky test](gitlab-org/gitlab@34ef10adaff0bd987c12ff5450b0f058b78386d2) ([merge request](gitlab-org/gitlab!151987))
- [Quarantine a flaky test](gitlab-org/gitlab@b01ee9027c75cb444668ffcde37deadf57847eec) ([merge request](gitlab-org/gitlab!151975))
- [Add icon to issues on child epics when filtering epics](gitlab-org/gitlab@8586591c5629724f35c5612d6d764bce4270fe71) ([merge request](gitlab-org/gitlab!149865)) **GitLab Enterprise Edition**
- [Remove cron job details for CreateEmptyEmbeddingsRecordsWorker](gitlab-org/gitlab@6d6fd042859b1deb932ea531c5fefca94eee63d9) ([merge request](gitlab-org/gitlab!151731))
- [Fix Layout/ArgumentAlignment offenses 2](gitlab-org/gitlab@5468f69218852eaf9148e5e0e800ab5ac86baaeb) by @gauravmarwal ([merge request](gitlab-org/gitlab!150959))
- [Fix Layout/ArgumentAlignment offenses 21](gitlab-org/gitlab@3bbaed175e71762cddcf812a8e4cb90112339d1a) by @gauravmarwal ([merge request](gitlab-org/gitlab!151039))
- [Mark 20230415500000 MigrateWikisToSeparateIndex migration as obsolete](gitlab-org/gitlab@ec683edeadfd752330db0af57e99cb154b7f45ee) ([merge request](gitlab-org/gitlab!150863)) **GitLab Enterprise Edition**
- [Mark AddHashedRootNamespaceIdToIssues as obsolete](gitlab-org/gitlab@d7a51a6b06134b47d8c1959d77172cc68b1c8baf) ([merge request](gitlab-org/gitlab!150857)) **GitLab Enterprise Edition**
- [Fix Layout/ArgumentAlignment offenses 14](gitlab-org/gitlab@77261271c15551a9cbfc0569b47724d4ec5ddac6) by @gauravmarwal ([merge request](gitlab-org/gitlab!151009))
- [Fix Layout/ArgumentAlignment offenses 19](gitlab-org/gitlab@abba6534db42f37555273efb960c619bb37643c2) by @gauravmarwal ([merge request](gitlab-org/gitlab!151031))
- [Fix Layout/ArgumentAlignment offenses 29](gitlab-org/gitlab@b183c81e66a1b8308fcaa823c4e08fe1ead0a613) by @gauravmarwal ([merge request](gitlab-org/gitlab!151086))
- [Fix Layout/ArgumentAlignment offenses 8](gitlab-org/gitlab@91242af2c22b527faf6a445f3d1d8294e9decc65) by @gauravmarwal ([merge request](gitlab-org/gitlab!150980))
- [Add specs for Gitlab::VulnerabilityScanning::SecurityScanner](gitlab-org/gitlab@2e5ff4c4e84f0e3794a783b1b42714a1d08da05d) by @jzeng88 ([merge request](gitlab-org/gitlab!150401)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](gitlab-org/gitlab@788d35255b5e54867aedc399f577e37892ecbc1b) ([merge request](gitlab-org/gitlab!151859))
- [Quarantine a flaky test](gitlab-org/gitlab@19886139a2bd3026213583e0004474dd4c5bfb7d) ([merge request](gitlab-org/gitlab!151853))
- [Remove FF check when creating synced work items](gitlab-org/gitlab@d476de77e148c2e266d07ef0ee5185e61eb920f3) ([merge request](gitlab-org/gitlab!151783)) **GitLab Enterprise Edition**
- [Fix Layout/ArgumentAlignment offenses 13](gitlab-org/gitlab@9d179e398f5634f8bd15611a745ee79504c0acb7) by @gauravmarwal ([merge request](gitlab-org/gitlab!151003))
- [Fix Layout/ArgumentAlignment offenses 6](gitlab-org/gitlab@e8806b0ab7f77c257ae17c69403a5f0cfe190ed3) by @gauravmarwal ([merge request](gitlab-org/gitlab!150972))
- [Fix Layout/ArgumentAlignment offenses 18](gitlab-org/gitlab@ea0e4859ec0f3757e0ee2988373da85a8872139b) by @gauravmarwal ([merge request](gitlab-org/gitlab!151022))
- [Fix Layout/ArgumentAlignment offenses 27](gitlab-org/gitlab@224afe1a4293da79790770c701da8a61eafd5e45) by @gauravmarwal ([merge request](gitlab-org/gitlab!151076))
- [Fix Layout/LineContinuationLeadingSpace 4 offenses](gitlab-org/gitlab@63b34e0850b16ff439b7509ede775fad92c6a80d) by @archish27 ([merge request](gitlab-org/gitlab!150904))
- [Schedule async indexes](gitlab-org/gitlab@87366b5aa714ce5e5014ae79ba0bb1e7d69d6fe8) ([merge request](gitlab-org/gitlab!149701))
- [Release FF environment_stop_actions_include_all_finished_deployments](gitlab-org/gitlab@e486a07b28ce030e024b0fccd855decd166b9ae6) ([merge request](gitlab-org/gitlab!150932))
- [Remove obsolete Advanced search migrations](gitlab-org/gitlab@09f1e11d28cc8caa5bda23695b4a4975457d807f) ([merge request](gitlab-org/gitlab!150542)) **GitLab Enterprise Edition**
- [Fix Layout/SpaceBeforeBlockBraces Layout/TrailingWhitespace offenses](gitlab-org/gitlab@016fa8b49cc2fb8e7475f55aeaf38bd09bbc0df7) by @archish27 ([merge request](gitlab-org/gitlab!150897))
- [Fix Layout/SpaceInsideParens offenses 1](gitlab-org/gitlab@9869edbe7435301b10e9a6649d59f97b65999ffa) by @archish27 ([merge request](gitlab-org/gitlab!150873))
- [Add and backfill project_id for approval_merge_request_rule_sources](gitlab-org/gitlab@d2cbe38d668ec893af0637e31dd3a2b5cdf2f720) ([merge request](gitlab-org/gitlab!151629))
- [Move emails_disabled inversion to REST API](gitlab-org/gitlab@2fe8399acede8ac9b8d3cec5143ecf5586ba8e26) ([merge request](gitlab-org/gitlab!151065))
- [Mark 20230320011400 AddHashedRootNamespaceIdToCommits as obsolete](gitlab-org/gitlab@9699ac60d6a224040316c66ce63d1556ff61d004) ([merge request](gitlab-org/gitlab!150858)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](gitlab-org/gitlab@d52b25abfaf7a3f0ea4e8f5366c902477328c9b5) ([merge request](gitlab-org/gitlab!150260))
- [Remove duplicated code from MirrorsController#update](gitlab-org/gitlab@712a3db930df348eb990da62b4c78ad1fbdfd2bc) ([merge request](gitlab-org/gitlab!151024)) **GitLab Enterprise Edition**
- [Remove unused code from MergeRequest model](gitlab-org/gitlab@b5dae91e0017ca03c91cfbb447d5d8c37cbec944) ([merge request](gitlab-org/gitlab!150497))
- [Rubocop: Fixes warning for GraphQL/resolver_method_length](gitlab-org/gitlab@cfc75957330332f0b37f25fc1299e973d644e763) by @nwittstruck ([merge request](gitlab-org/gitlab!150323))
- [Add trigger function reset](gitlab-org/gitlab@cc617cd7ab6194c7b6964388515a233b5a4422f4) ([merge request](gitlab-org/gitlab!151437))
- [Finalize migration BackfillHasRemediationsOfVulnerabilityReads](gitlab-org/gitlab@89dbe19267a829495a7def353c05f55ed0afacf5) ([merge request](gitlab-org/gitlab!151467))
- [Add sharding key tracking issues for Threat Insights](gitlab-org/gitlab@2f430bc60865547e14d97cdf3892b0a8faf22b39) ([merge request](gitlab-org/gitlab!150926))
- [Update trigger function for merge_request_metrics](gitlab-org/gitlab@1aea1b0a5e74408830a2b350dd7bc3d556c7dcc6) ([merge request](gitlab-org/gitlab!151347))
- [Populate Ci::Partition first record](gitlab-org/gitlab@4bc8ccfe2ee09a85c9b702fa4976afebb7714769) ([merge request](gitlab-org/gitlab!148944))
- [Remove MR locked state index synchronously](gitlab-org/gitlab@26f8984678de8cc576ea33d88cd40c6b0b2035a4) ([merge request](gitlab-org/gitlab!150402))
- [Fix Layout/MultilineOperationIndentation 5 offenses](gitlab-org/gitlab@f17e7302de2c6d864e5bf75e02749b494eb25b4b) by @archish27 ([merge request](gitlab-org/gitlab!151229))
- [Fix Lint/AmbiguousRegexpLiteral 6 offenses](gitlab-org/gitlab@e97f97940a6a8da0d78bad1542c653be17815216) by @archish27 ([merge request](gitlab-org/gitlab!151218))
- [Fix Lint/AmbiguousRegexpLiteral 5 offenses](gitlab-org/gitlab@e1aba89424367fa197feec2f00234af3d8c6a518) by @archish27 ([merge request](gitlab-org/gitlab!151217))
- [Fix Lint/AmbiguousRegexpLiteral 3 offenses](gitlab-org/gitlab@5c2ef8703e4ebb30cc46dd299a28b9afb57edeaa) by @archish27 ([merge request](gitlab-org/gitlab!151215))
- [Fix Lint/AmbiguousRegexpLiteral 1 offenses](gitlab-org/gitlab@90d9c0ef0aa64ab1eaf418389814bb691f59733b) by @archish27 ([merge request](gitlab-org/gitlab!151213)) **GitLab Enterprise Edition**
- [Fix Layout/SpaceInLambdaLiteral 18 offenses](gitlab-org/gitlab@53b3519e539f85ab8aa92845db8d8f011557c7ab) by @archish27 ([merge request](gitlab-org/gitlab!151207))
- [Fix Layout/SpaceInLambdaLiteral 15 offenses](gitlab-org/gitlab@8d98f39e249f25d87b49ae07cc2daf1371de4d97) by @archish27 ([merge request](gitlab-org/gitlab!151204)) **GitLab Enterprise Edition**
- [Fix Layout/SpaceInLambdaLiteral 13 offenses](gitlab-org/gitlab@5f4f039e90f3c194b1ada5763f95f4f90f94f2bc) by @archish27 ([merge request](gitlab-org/gitlab!151202)) **GitLab Enterprise Edition**
- [Fix Layout/SpaceInLambdaLiteral 10 offenses](gitlab-org/gitlab@c36369ce1066c3df96ade70d51041e66523f7ac9) by @archish27 ([merge request](gitlab-org/gitlab!151199))
- [Fix Layout/SpaceInLambdaLiteral 1 offenses](gitlab-org/gitlab@899c81d3582419228e3edc253b3ef6d5b90eb348) by @archish27 ([merge request](gitlab-org/gitlab!151191))
- [Fix Lint/SymbolConversion 9 offenses](gitlab-org/gitlab@447eaf19e3e58f200bcb4d4285c288ce5b6525e2) by @archish27 ([merge request](gitlab-org/gitlab!151190))
- [Fix Lint/SymbolConversion 7 offenses](gitlab-org/gitlab@27032e88e61246543de2c942f137a89b3f1cf6c7) by @archish27 ([merge request](gitlab-org/gitlab!151188))
- [Fix Lint/SymbolConversion 2 offenses](gitlab-org/gitlab@3d8a79695788c91087d03e88a2186ac0eb5191e7) by @archish27 ([merge request](gitlab-org/gitlab!151183)) **GitLab Enterprise Edition**
- [docs: Add missing access levels for `minimum_access_level_for_x` fields](gitlab-org/gitlab@499cde09234ef432f26482e28c03b8ae15ecd20f) by @gerardo-navarro ([merge request](gitlab-org/gitlab!151119))
- [Fix Layout/ArgumentAlignment offenses 28](gitlab-org/gitlab@55672eee98188c2e08416d5438d4b30ac21260cf) by @gauravmarwal ([merge request](gitlab-org/gitlab!151079))
- [Use Pajamas input for approval count](gitlab-org/gitlab@fd4e34d429b6da7dbb9b96a1e7e17656afa7819c) ([merge request](gitlab-org/gitlab!150880)) **GitLab Enterprise Edition**
- [Fix Layout/ArgumentAlignment offenses 26](gitlab-org/gitlab@4373ab2dd8ab7c2670482eb234e0687b523afa6f) by @gauravmarwal ([merge request](gitlab-org/gitlab!151072))
- [Initial commit of `bounded_contexts.yml` file](gitlab-org/gitlab@abc355aafb96543577db7b488eeb1dd694d8d2e2) ([merge request](gitlab-org/gitlab!149543))
- [Fix Lint/AmbiguousOperatorPrecedence 7 offenses](gitlab-org/gitlab@aee39a98490e97a57c91b6dbe9719d5175985ea1) by @archish27 ([merge request](gitlab-org/gitlab!151161))
- [Fix Layout/ArgumentAlignment offenses 22](gitlab-org/gitlab@89b8333f0b8004dbbc6d8faeeed1c59174b490dc) by @gauravmarwal ([merge request](gitlab-org/gitlab!151049))
- [Mark BackfillWikiPermissionsInMainIndex search migration as obsolete](gitlab-org/gitlab@5bb8d83847c46d7b13ef7820dcb2378b454dab49) ([merge request](gitlab-org/gitlab!150862)) **GitLab Enterprise Edition**
- [Fix Rails/NegateInclude 1](gitlab-org/gitlab@01ad76bd13727db6540bba10645ee72097e02445) by @archish27 ([merge request](gitlab-org/gitlab!151035)) **GitLab Enterprise Edition**
- [Switch merge_request_metrics pipeline_id to bigint ](gitlab-org/gitlab@4122e960ce70c618b2a919d69aef45900fb03875) ([merge request](gitlab-org/gitlab!149681))
- [Fix Layout/ArgumentAlignment offenses 20](gitlab-org/gitlab@6ccef6b89f93a37b3d8de58072d20676fc85f162) by @gauravmarwal ([merge request](gitlab-org/gitlab!151036))
- [ Switch merge_trains pipeline_id to bigint ](gitlab-org/gitlab@43af55844e6f95dca92abc957ce088861dca1c2c) ([merge request](gitlab-org/gitlab!149689))
- [Lint fixes OrAssignmentToConstant RedundantStringCoercion EnvMocking](gitlab-org/gitlab@e75d037e61148926abdfbf5950e1d9c95d96cb0d) by @archish27 ([merge request](gitlab-org/gitlab!151034)) **GitLab Enterprise Edition**
- [Fix Layout/ArgumentAlignment offenses 17](gitlab-org/gitlab@46e29a4251be12a4250a1a6c3476d16bfc430e4d) by @gauravmarwal ([merge request](gitlab-org/gitlab!151020))
- [Update epic deletion confirmation](gitlab-org/gitlab@462c30d3cbf0b46311411141b72f8e321d85acc5) ([merge request](gitlab-org/gitlab!150359))
- [Fix Layout/ArgumentAlignment offenses 15](gitlab-org/gitlab@8bc60558bb808542f19bcce64074c60eb96b5e97) by @gauravmarwal ([merge request](gitlab-org/gitlab!151012))
- [Fix Layout/ArgumentAlignment offenses 12](gitlab-org/gitlab@b641e62f910898dcb7d733a57a6f96cb7d91a7ae) by @gauravmarwal ([merge request](gitlab-org/gitlab!151001))
- [Mark 20230325200700 search migration as obsolete](gitlab-org/gitlab@0ce39d322d2421d32e5ea5d8775903fc69537a53) ([merge request](gitlab-org/gitlab!150861)) **GitLab Enterprise Edition**
- [Mark 20230321202400 search migration as obsolete](gitlab-org/gitlab@5ede57ad184e9e8b87f0ba585d0af113cbfb8c96) ([merge request](gitlab-org/gitlab!150860)) **GitLab Enterprise Edition**
- [Mark 20230321091100 search migration as obsolete](gitlab-org/gitlab@656a5f72f3827a3bc7723a00a7516633800531ce) ([merge request](gitlab-org/gitlab!150859)) **GitLab Enterprise Edition**
- [Fix Layout/ArgumentAlignment offenses 10](gitlab-org/gitlab@1d7ba1882f666cd7ff3ed2b0c4d05f80d13ef01e) by @gauravmarwal ([merge request](gitlab-org/gitlab!150997))
- [Mark 20230316150000 search migration as obsolete](gitlab-org/gitlab@2af7e14e5c9642adce1b0464155cfc906d32b26a) ([merge request](gitlab-org/gitlab!150856)) **GitLab Enterprise Edition**
- [Fix Layout/ArgumentAlignment offenses 7](gitlab-org/gitlab@a4c109f89c5e2a4ce1c753b36a9bd81d01bd3942) by @gauravmarwal ([merge request](gitlab-org/gitlab!150977))
- [Fix Layout/ArgumentAlignment offenses 5](gitlab-org/gitlab@f4ea0dae7aca90fa7fc3c6f8766a3b5262c02816) by @gauravmarwal ([merge request](gitlab-org/gitlab!150967))
- [Fix Layout/ArgumentAlignment offenses 3](gitlab-org/gitlab@ee8f78236573734a7928a92dd99f9f693c1fcb3a) by @gauravmarwal ([merge request](gitlab-org/gitlab!150960))
- [Fix Layout/ArgumentAlignment offenses](gitlab-org/gitlab@84458db13411621faa4a60984ba951894d38ea33) by @gauravmarwal ([merge request](gitlab-org/gitlab!150953))
- [Fix Style/RedundantInterpolation offenses](gitlab-org/gitlab@bc2ce00feef69715e4567b64e6be92711116bfa3) by @archish27 ([merge request](gitlab-org/gitlab!150965))
- [Fix Layout/SpaceInsideBlockBraces offenses](gitlab-org/gitlab@a2b7f42a24280d350df0ab214e8b054abfca4276) by @gauravmarwal ([merge request](gitlab-org/gitlab!150948))
- [Add Sidekiq shard-awareness validator](gitlab-org/gitlab@4d631c2fc335f58d0c7d2e07d21efe39e817cf8c) ([merge request](gitlab-org/gitlab!149943)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](gitlab-org/gitlab@ba608c4eee624799ec2b9ae2f2b3c71f9d3bd1b2) ([merge request](gitlab-org/gitlab!150935))
- [Allow MultiStore to be initialised with Redis clients](gitlab-org/gitlab@08bbbb3c09fc3e32fc7713f7035bf20c4c262708) ([merge request](gitlab-org/gitlab!150445))
- [Add and backfill project_id for wiki_repository_states](gitlab-org/gitlab@4c72d6396e2324c8ef5deae1fe9c98ff7a9d98fd) ([merge request](gitlab-org/gitlab!150076))
- [Fix Layout/HashAlignment Layout/LeadingCommentSpace offenses](gitlab-org/gitlab@e5e0eebc90cdb92079a7410af45582dc38455599) by @archish27 ([merge request](gitlab-org/gitlab!150909)) **GitLab Enterprise Edition**
- [Fix Layout/LineContinuationLeadingSpace 2](gitlab-org/gitlab@512a47ca2ab14be04d7c44490cfcff5ead6bc670) by @archish27 ([merge request](gitlab-org/gitlab!150902)) **GitLab Enterprise Edition**
- [Fix Layout/SpaceInsideParens offenses 7](gitlab-org/gitlab@c69b16ec3905b1d9dc2a4825005751840e17e851) by @archish27 ([merge request](gitlab-org/gitlab!150900)) **GitLab Enterprise Edition**
- [Delete FF](gitlab-org/gitlab@375cd5b9a6f792ca93abe67c636ae644277da489) ([merge request](gitlab-org/gitlab!149270))
- [Use Pajamas components for approval password form](gitlab-org/gitlab@bf5892ba401d68f2ce4a648a1dc25dfd0eb70f35) ([merge request](gitlab-org/gitlab!150867)) **GitLab Enterprise Edition**
- [Fix Layout/SpaceInsideParens offenses 3](gitlab-org/gitlab@7cd11f59ef018bcf819382e302c0e4e4db9603bd) by @archish27 ([merge request](gitlab-org/gitlab!150877))
- [Remove container_scanning_continuous_vulnerability_scans flag](gitlab-org/gitlab@8cdedd9262d215605fd8ac56027a663b9b4517f5) ([merge request](gitlab-org/gitlab!150593))
- [Remove ExtractsPath module from ProjectsController](gitlab-org/gitlab@ef61eb161d5516de4b5f8ce9bc5a66c60630f1a5) ([merge request](gitlab-org/gitlab!145434))
- [Fix Layout/LeadingCommentSpace offenses](gitlab-org/gitlab@bb10428759597328b4e8a3995c637e7858041718) by @archish27 ([merge request](gitlab-org/gitlab!150864))
- [Clean up linked_work_items feature flag](gitlab-org/gitlab@6acf7665af0978c4cb8883db35787b3c16bd7f82) ([merge request](gitlab-org/gitlab!150148))
- [Mark 20230307102400 advanced search migration as obsolete](gitlab-org/gitlab@7dee6aeff24a6f050569be95952716fefcf05269) ([merge request](gitlab-org/gitlab!150543)) **GitLab Enterprise Edition**
- [Update Pages without wildcard DNS docs](gitlab-org/gitlab@9266906be190cb579baaf6bf93dba44e75a25316) ([merge request](gitlab-org/gitlab!149533))
- [Fix Style/HashAsLastArrayItem Offenses](gitlab-org/gitlab@7e80f65a35a18bff5b74b57dd4bec3d7f4375398) ([merge request](gitlab-org/gitlab!150579))
- [Remove a MR index with state_id, iid synchronously](gitlab-org/gitlab@24e8c2a050757211a48ec69d9dc5e1b08ebc5330) ([merge request](gitlab-org/gitlab!150403))
- [Include itemprop attribute in project avatar component](gitlab-org/gitlab@50ba33a6b4815ab3209596fb91ff9116d0cdb471) by @espadav8 ([merge request](gitlab-org/gitlab!150597))
- [Draft: Add sharding key tracking issues for design_management](gitlab-org/gitlab@705a7208ac76be9db6dad6c498f52ee59d18ad14) ([merge request](gitlab-org/gitlab!150582))
- [Fix Lin/AmbiguousRange Offenses](gitlab-org/gitlab@04d1b931283a7580d988dfdfc182b3e53612cb1c) ([merge request](gitlab-org/gitlab!150580))
- [Fix RSpec/HooksBeforeExamples Offenses](gitlab-org/gitlab@d961327a33359836173f20d03b1c3be62cac122a) ([merge request](gitlab-org/gitlab!150576))
- [Change maxWorkers configuration](gitlab-org/gitlab@76d9801e24b08865fae8f997c61763332f60adec) ([merge request](gitlab-org/gitlab!150541))
- [Add DEV flag for jest](gitlab-org/gitlab@facaeb0a8273c47ab12d031291b95fe1f8b49684) ([merge request](gitlab-org/gitlab!150178))
- [Protected containers: Use service response shared examples in tests](gitlab-org/gitlab@1947eb3126891cc77d0e109e51c6098005ac9c8d) by @gerardo-navarro ([merge request](gitlab-org/gitlab!149436))
- [Swap packages_build_infos pipeline_id to bigint ](gitlab-org/gitlab@bad46790e59e2a5b6e1e0127e2f653b776fdf4bc) ([merge request](gitlab-org/gitlab!149686))
- [Swap vulnerability_feedback pipeline_id to bigint](gitlab-org/gitlab@07ca529cd6df4fa0f16577645b30627ba555144c) ([merge request](gitlab-org/gitlab!149692))
- [Add JSON validation spec for zoekt/node.rb](gitlab-org/gitlab@2c6a31b88f0d5e65d92a47314b68f585f85606b0) by @jzeng88 ([merge request](gitlab-org/gitlab!150406)) **GitLab Enterprise Edition**
- [Finalize migration BackfillHasMergeRequestOfVulnerabilityReads](gitlab-org/gitlab@47bae85c99b4c2a041bbbe711e690b535d3a181f) ([merge request](gitlab-org/gitlab!150385))
- [Apply Sidekiq sharding router to Sidekiq::Job::Setter](gitlab-org/gitlab@9718edffc7b483664577e7a83aa0340fa5b46163) ([merge request](gitlab-org/gitlab!149962))
- [Remove the temporary patch for "listing commits failed" error](gitlab-org/gitlab@05968a3fde15f9c263a5f96c4511a6ba69905825) ([merge request](gitlab-org/gitlab!148979))
- [Fix warning by adding feature category to pipeline specs](gitlab-org/gitlab@d572fe4a00f11708015df3d9118798c95c5bc5b5) by @b310-jannik ([merge request](gitlab-org/gitlab!150325))
- [refactor: Rename names of attributes related to access levels](gitlab-org/gitlab@10e3a4b291fffb955e1b02c1f2ab5a5c529f74cf) by @gerardo-navarro ([merge request](gitlab-org/gitlab!139413))
- [Add desired sharding keys for metrics](gitlab-org/gitlab@937cf9d44de31c8d9331356ae138fc24f34e7d98) ([merge request](gitlab-org/gitlab!150274))
- [Update MAX_RUN_TIME to match max HTTP request time](gitlab-org/gitlab@d41fd892521c671006e4a587dff0d4a35fab1c3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149994)) **GitLab Enterprise Edition**
- [Add and backfill namespace_id for work_item_parent_links](gitlab-org/gitlab@7c56b7b7dfa27de7ef4ea435c81507cb719f9ee3) ([merge request](gitlab-org/gitlab!150075))
- [Add and backfill project_id for workspace_variables](gitlab-org/gitlab@ea0a824cce14f16f0db8b6a10351e7fd9f3b5198) ([merge request](gitlab-org/gitlab!150074))
- [Remove create_vulnerability_jira_issue_via_graphql feature flag](gitlab-org/gitlab@d99b3417db5c6585b09b761a9232f5626cdd3c4a) ([merge request](gitlab-org/gitlab!149087)) **GitLab Enterprise Edition**
- [Remove feature flag for custom webhook templates](gitlab-org/gitlab@e6d8073f349f6b49191b7e87b2186a8a24512155) by @kevin.gosa ([merge request](gitlab-org/gitlab!149912))
- [Revert "Merge branch '434291-refactor-pat-policy' into 'master'"](gitlab-org/gitlab@aa9d47a4650d599431fbd0945afb108ee81f8ad7) ([merge request](gitlab-org/gitlab!149909))
- [Remove custom_webhook_headers feature flag](gitlab-org/gitlab@a11f581efb48f1415be746163a34c3c822806d86) by @Taucher2003 ([merge request](gitlab-org/gitlab!149910))
- [Quarantine a flaky test](gitlab-org/gitlab@f9ee7173fdd1965cbaa138ad6605e5a213e7ed6c) ([merge request](gitlab-org/gitlab!149282))
- [Remove `group_user_saml` feature flag](gitlab-org/gitlab@fbbb435b7290d3b82f4ad312c42718ea151ddb85) ([merge request](gitlab-org/gitlab!149815))
- [Quarantine a flaky test](gitlab-org/gitlab@a1c324b4085177be390b48afdd4a9dd0c3a333c7) ([merge request](gitlab-org/gitlab!149814))
- [Quarantine a flaky test](gitlab-org/gitlab@67b1158733b7472b9d5b24cda18d9790f5908dd4) ([merge request](gitlab-org/gitlab!149580))
- [Quarantine a flaky test](gitlab-org/gitlab@b7f163aeaf716718fa2d14e2616de4ca3be4164a) ([merge request](gitlab-org/gitlab!149281))
- [Introduce service "RemoteMirrors::CreateService"](gitlab-org/gitlab@a7cbd98e5f1bcb2fd75f195e093b78ea0056bcf9) ([merge request](gitlab-org/gitlab!149700)) **GitLab Enterprise Edition**
- [Release FF link_fast_forward_merge_requests_to_deployment](gitlab-org/gitlab@6ccd8eeef686598e6d45b335e0e69f5e8cc1470a) ([merge request](gitlab-org/gitlab!146729))
- [Cleanup add_policy_approvers_to_rules feature flag](gitlab-org/gitlab@086cd84677fe1dc6ab90a1d35e89aeae8fdde8e8) ([merge request](gitlab-org/gitlab!149463))
- [Quarantine a flaky test](gitlab-org/gitlab@f07f135458e2180a1cb4a10e806f0ec2c87ae557) ([merge request](gitlab-org/gitlab!149581))
- [Quarantine a flaky test](gitlab-org/gitlab@7fc9441be3d88cafac24d5b972aa1cf9a176ae77) ([merge request](gitlab-org/gitlab!149579))
- [Quarantine a flaky test](gitlab-org/gitlab@39146ef3454e40472fcbade4a5abffba8a218da2) ([merge request](gitlab-org/gitlab!149279))
- [Remove `inputs` from `catalog_resource_components`](gitlab-org/gitlab@91a3fffdcc91e06054f81c9dd4b9060a76cd7223) ([merge request](gitlab-org/gitlab!149550))
- [Add relaxed sharding keys for runner](gitlab-org/gitlab@c13eb5b8c35494e92e17dce7866fcc59d513eb83) ([merge request](gitlab-org/gitlab!149293))
- [Quarantine a flaky test](gitlab-org/gitlab@e7be87525827b87bd762d1d45985128093f8bd8d) ([merge request](gitlab-org/gitlab!149283))
- [Include psudonymised user id into X Ray scan req](gitlab-org/gitlab@7c3553f71da1fa87cd1bfd58cc78449f55f33e60) ([merge request](gitlab-org/gitlab!149124)) **GitLab Enterprise Edition**
- [Migrate self-managed custom roles to the instance-level roles](gitlab-org/gitlab@46ab664a1877f8b761c2b25e13e01561d56cf6fd) ([merge request](gitlab-org/gitlab!147829))
- [Feature cleanup flag wiki_content_background_job](gitlab-org/gitlab@c39a37db4a6112456052c11bf5fd1afa9c23bd6d) by @ivantedja ([merge request](gitlab-org/gitlab!148820))

## 16.11.8 (2024-08-05)

### Changed (1 change)

- [Put groups_direct field in CI JWT tokens behind feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d0a48169310c947607259d20046bdaadabcebaee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161239))

## 16.11.7 (2024-07-23)

### Added (1 change)

- [Add Rake task to show token expiration info](https://gitlab.com/gitlab-org/gitlab/-/commit/74bda3d7064c5d346b89c3b81fc9ee9189919945) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159056))

### Fixed (1 change)

- [Ignore object pool already exists creation errors](https://gitlab.com/gitlab-org/gitlab/-/commit/b1ce2c82376ff000984686c22e739464458d868b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159021))

## 16.11.6 (2024-07-09)

### Fixed (1 change)

- [Update dependency slack-messenger to v2.3.5](gitlab-org/security/gitlab@4e78461cef64c7423d793de22deffbae7088e7d6)

### Security (6 changes)

- [Disallow serving Pages over disabled custom domains with deployments](gitlab-org/security/gitlab@ff23e03cab7495107b1342b4fa175db63a4acd61) ([merge request](gitlab-org/security/gitlab!4247))
- [Check if user has ban_group_member access before banning in namespace](gitlab-org/security/gitlab@cadb2dba7f5fe825fab7fe761259e7c1721bebfe) ([merge request](gitlab-org/security/gitlab!4090))
- [Prevent using quick actions for some bot users](gitlab-org/security/gitlab@951a656e6d530ba7692b03506b7c340bc5ac2788) ([merge request](gitlab-org/security/gitlab!4233))
- [Disable raw HTML for quick action pipeline](gitlab-org/security/gitlab@1a7f336059af3223b4886e79060b8dc8a17f5482) ([merge request](gitlab-org/security/gitlab!4237))
- [Disable quick actions unless description changed](gitlab-org/security/gitlab@267f4cf51303f70d5a834a3358fe62b6e981a873) ([merge request](gitlab-org/security/gitlab!4240))
- [Remove comment support from shrug and tableflip](gitlab-org/security/gitlab@579a180538609ccad2d3930218a5410cb33d3920) ([merge request](gitlab-org/security/gitlab!4230))

## 16.11.5 (2024-06-25)

### Fixed (2 changes)

- [Only allow documented token types for GraphQL authentication](gitlab-org/security/gitlab@29cf595d53bc1d05edb662004c5ac76a8d497065)
- [Update an expired test certificate](gitlab-org/security/gitlab@7d482c5924e4b61a1889029147367631c1b435ad)

### Changed (2 changes)

- [Add a banner informing about token expiration](gitlab-org/security/gitlab@e60607a2d4377cdb872b65d756d0e478e01e0f1c)
- [Enable invert_emails_disabled_to_emails_enabled by default](gitlab-org/security/gitlab@a2adc31b3fe5b8160922c42df31ab3b12ecc5b7b)

### Security (14 changes)

- [Security fixes for banzai pipeline](gitlab-org/security/gitlab@7a7560ebf98b9e3fed749c0895c7fe952a35d0e6) ([merge request](gitlab-org/security/gitlab!4182))
- [Fix the catastrophic backtracking in openapi regex](gitlab-org/security/gitlab@6561fa187bd297a664c7fee8d1bbb546fb6f197e) ([merge request](gitlab-org/security/gitlab!4144))
- [Use permitted_params for standalone and multiplex queries](gitlab-org/security/gitlab@7be6c33aa9ed53d8713a098a48ad5b5265fd4801) ([merge request](gitlab-org/security/gitlab!4148))
- [Fix for Private job artifacts can be accessed by any user](gitlab-org/security/gitlab@eff1ae75283fafff1204063fc9c5fa43d90439b0) ([merge request](gitlab-org/security/gitlab!4196))
- [Remove search results from public projects with unauthorized repos](gitlab-org/security/gitlab@5e1513db50b3ada45a991d39fde0cd4cadd4bb88) ([merge request](gitlab-org/security/gitlab!4042))
- [Do not run a new pipeline on re-target](gitlab-org/security/gitlab@f68c020c8d2a2dc53187a65857f3312a025af3f4) ([merge request](gitlab-org/security/gitlab!4189))
- [Add limits on autolinker regex](gitlab-org/security/gitlab@d79a1a8333484bf9537af2907767fad0ec1ad240) ([merge request](gitlab-org/security/gitlab!4128))
- [Fix clickjacking on OAuth application page](gitlab-org/security/gitlab@05b187a7860fc02b68eced70e882a807d7a0e784) ([merge request](gitlab-org/security/gitlab!4024))
- [Hide branch merge request if merge requests are private](gitlab-org/security/gitlab@5973f83550e4b6341ca3f3fdbd29759a46b31bb6) ([merge request](gitlab-org/security/gitlab!4206))
- [Remove collapseLongCommitList method](gitlab-org/security/gitlab@279c1eee6676df9e25b723fd971dcf5c7134effd) ([merge request](gitlab-org/security/gitlab!4207))
- [Pass SSO session data to Sidekiq](gitlab-org/security/gitlab@e3147a7c301acf2d5e474745e594ff319f6e7f37) ([merge request](gitlab-org/security/gitlab!4161))
- [Prevent non-members from using promote_to quick action for quick actions](gitlab-org/security/gitlab@6424c7ad252809a13bc14d61ba15a6a377cd5a30) ([merge request](gitlab-org/security/gitlab!4156))
- [Reject deletion of security policy project approval rules](gitlab-org/security/gitlab@0e86b08d33fcfca547fb0e95ef462e4240bcf00e) ([merge request](gitlab-org/security/gitlab!4106))
- [Mitigate ReDoS attacks via `method_call_regex`](gitlab-org/security/gitlab@6e3fb9ff027fa56e62db093c4291c5d562550c2d) ([merge request](gitlab-org/security/gitlab!4164))

## 16.11.4 (2024-06-11)

### Security (4 changes)

- [XSS and content injection raw XHTML files on IOS devices](gitlab-org/security/gitlab@5df472ac0deefe1e59ecfc0ffae7fa489cb6c9ab) ([merge request](gitlab-org/security/gitlab!4094))
- [Improve go_package_regex to prevent ReDoS attacks](gitlab-org/security/gitlab@d0b04b06f59e81bc57f6b33e26a0399b4b86ee80) ([merge request](gitlab-org/security/gitlab!4097))
- [Fix ReDoS in CI Interpolation](gitlab-org/security/gitlab@b013996a0612c9cc1e43bcd0be4b47d98eaf92f4) ([merge request](gitlab-org/security/gitlab!4082))
- [Verify Asana access token when testing Asana integration](gitlab-org/security/gitlab@6db47bd6ace0904869f56f035ff408855f3f4c9b) ([merge request](gitlab-org/security/gitlab!4060))

## 16.11.3 (2024-05-21)

### Fixed (2 changes)

- [Ensure BLPOP/BRPOP returns nil instead of raising ReadTimeoutError](gitlab-org/security/gitlab@53de79ac43f81963a15be27b94bc67f7bbf036b6)
- [Fix Sidekiq migration timeout](gitlab-org/security/gitlab@32cf49a634b4cb15f065c3e112a693ea30dadda5)

### Security (7 changes)

- [Prevent PDF.js from evaluating scripts](gitlab-org/security/gitlab@b5f9843d9b54ca45817c16cbb706697bf9d44d81) ([merge request](gitlab-org/security/gitlab!4070))
- [Caching test_report api response to reduce calculations](gitlab-org/security/gitlab@63299beda6e61653070c279ad6838a99a29dc33f) ([merge request](gitlab-org/security/gitlab!4027))
- [Restrict access to Secure artifacts to developer role](gitlab-org/security/gitlab@63855780157d740d1c8e731b90eecae4d5f1c8c2) ([merge request](gitlab-org/security/gitlab!4045))
- [Fail create commit status on pipeline_id / sha mismatch](gitlab-org/security/gitlab@a1a4f80bee205fedfd3da27978bed810afe78555) ([merge request](gitlab-org/security/gitlab!4032))
- [Use UntrustedRegexp for gollum pattern](gitlab-org/security/gitlab@fafda23db9f0c34408b155ddc089872b55e1fd8b) ([merge request](gitlab-org/security/gitlab!4040))
- [Patch @gitlab/web-ide to fix XSS webWorkerExtensionHostIframe.html](gitlab-org/security/gitlab@7b2acad244d55455a0bba1fd8cbad28b22704756) ([merge request](gitlab-org/security/gitlab!4056))
- [Add text limit to ci_runners text fields](gitlab-org/security/gitlab@d78c5995f6651e54ed97340a1446822d185f02f5) ([merge request](gitlab-org/security/gitlab!4036))

## 16.11.2 (2024-05-07)

### Fixed (1 change)

- [Changed the email validation for only encoded chars](gitlab-org/security/gitlab@d920615ba4a25ffc035ad6b8c26285815eeff4f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151484/))

### Changed (1 change)

- [Return or display Gitlab version if GITLAB_KAS_VERSION is a SHA](gitlab-org/security/gitlab@0f75cac19752463492bd3311b14c37c468f8ab0d)

### Security (11 changes)

- [Update GITHUB_MEDIA_CDN to avoid SSRF when importing from Github](gitlab-org/security/gitlab@d09a2e9218ca0388e17c6e5810d73b1cdfaed965) ([merge request](gitlab-org/security/gitlab!4011))
- [Prevent namespace banned users from reading project todos](gitlab-org/security/gitlab@b3cc2799fe98e9a5a493545f5ff45098b9ba60fb) ([merge request](gitlab-org/security/gitlab!3968))
- [ReDoS in GitRefsFinder when using wildcards in branch search](gitlab-org/security/gitlab@1b2d2c2b4fb27eafd40ab4ef230f2b52d7b73747) ([merge request](gitlab-org/security/gitlab!3995))
- [ReDos in escape and commit reference filters](gitlab-org/security/gitlab@0b08bd7eebf65e4999574f3f856d996568c87fe6) ([merge request](gitlab-org/security/gitlab!3972))
- [Validate request origin before MR approval](gitlab-org/security/gitlab@ad8dfe033740952805ed677f26ff2ec391e4be82) ([merge request](gitlab-org/security/gitlab!4007))
- [Check request size before updating user pins](gitlab-org/security/gitlab@8f8110ed24f70c00f1bc69848af22f7fdd0caf57) ([merge request](gitlab-org/security/gitlab!4014))
- [Enforce per_page validation for Branches/TagsFinders](gitlab-org/security/gitlab@4655fca6ac2ecc340dd3bc50ddd6a74a8d00048f) ([merge request](gitlab-org/security/gitlab!3998))
- [Update Integrations::Discord::ATTACHMENT_REGEX regex](gitlab-org/security/gitlab@7d6c80a3768a7c0281647402990b67a4fa8a2c19) ([merge request](gitlab-org/security/gitlab!3988))
- [Update BaseMessage::RELATIVE_LINK_REGEX regex](gitlab-org/security/gitlab@52311b09ce70c1b3db8b7e7a49808467f76980b5) ([merge request](gitlab-org/security/gitlab!3989))
- [Require confirmation before linking JWT identity](gitlab-org/security/gitlab@2d84949cf6707d14ffd5a54290c605ff83bed6f6) ([merge request](gitlab-org/security/gitlab!3990))
- [Fix confidentiality check optimization](gitlab-org/security/gitlab@df63eb711d5d1f75147a4c5b3365559ed42af879) ([merge request](gitlab-org/security/gitlab!4002))

## 16.11.1 (2024-04-24)

### Security (5 changes)

- [Validation for encoded formatting characters](gitlab-org/security/gitlab@fc42e4b96ae1ac3cd766569d62d025cbf23ef16c) ([merge request](gitlab-org/security/gitlab!3979))
- [Forbid untrusted sign-ins to GitLab with Bitbucket and fix related uid](gitlab-org/security/gitlab@ef083c319e67072029787cd5c6a588562984a58c) ([merge request](gitlab-org/security/gitlab!3983))
- [Ensure PAT scope is validated everywhere for GraphQL/ActionCable](gitlab-org/security/gitlab@1847435210161d95b9c5fcd079380e7f2892195f) ([merge request](gitlab-org/security/gitlab!3975))
- [Protect against ReDoS in FileFinder with wildcard filters](gitlab-org/security/gitlab@dc16f3baa640ca8d5b223782ef3d58369423a1dd) ([merge request](gitlab-org/security/gitlab!3969))
- [fix: Validate security report version against schema during parsing](gitlab-org/security/gitlab@55e58d49051aa42938ec1d159b5e7eb3c47d2eb1) ([merge request](gitlab-org/security/gitlab!3967))

## 16.11.0 (2024-04-17)

### Added (121 changes)

- [Add skip secret detection audit event](gitlab-org/gitlab@e5b10f3c044a8992907f2dcc598123d798be9c7e) ([merge request](gitlab-org/gitlab!147855)) **GitLab Enterprise Edition**
- [Added added_approver to the todo action enum in GraphQL](gitlab-org/gitlab@0f2966c47ed9f5e042b8fb633ce454aa4592aa35) by @zillemarco ([merge request](gitlab-org/gitlab!148831))
- [Add setting for enabling pre-receive SD](gitlab-org/gitlab@dc4f895086986077fafc660537060d78546826b2) ([merge request](gitlab-org/gitlab!148332)) **GitLab Enterprise Edition**
- [Added pending member for project listing page](gitlab-org/gitlab@dcbb5001eca02fd8aa6d8dbd06a401fc49716988) ([merge request](gitlab-org/gitlab!146678)) **GitLab Enterprise Edition**
- [Merge branch 'add-support-for-v-prefix' into 'master' ](gitlab-org/gitlab@e5bcb9dc8a57d7bdcf6fc5ed4d9a34590fdf7348) ([merge request](gitlab-org/gitlab!148706))
- [Simplifies SemanticVersionable concern](gitlab-org/gitlab@f7353bc52a84f417ccc032ae4ba45e1058c14c50) ([merge request](gitlab-org/gitlab!148706))
- [Added model for external_status_checks_protected_branches](gitlab-org/gitlab@2647e53b6725a9c90e032488401d4b1d2827571e) ([merge request](gitlab-org/gitlab!149046)) **GitLab Enterprise Edition**
- [Update URL with cursor to load a specific page](gitlab-org/gitlab@4c7fb3d5d2853424555c64e23ebbe1ccb79dee0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148593)) **GitLab Enterprise Edition**
- [Added update api for instance level audit streaming](gitlab-org/gitlab@444a1b0312439545bd7ca7bd50136047c8db9c6f) ([merge request](gitlab-org/gitlab!149104)) **GitLab Enterprise Edition**
- [Add endpoint for checking relation import status](gitlab-org/gitlab@f450696483846a1cd7da2f2e8315e52df979cd75) ([merge request](gitlab-org/gitlab!147775))
- [Utilize show_diff_preview_in_email column](gitlab-org/gitlab@614f6d5d7d2c0358ebf5425e76d4f3062009be6c) by @joe-snyder ([merge request](gitlab-org/gitlab!98547))
- [Add API for trigger project webhook](gitlab-org/gitlab@b9bf0c33d5139823dada3a401a2607fa3856b6b5) by @lifez ([merge request](gitlab-org/gitlab!147656))
- [Add displaying list of linked policies to framework table](gitlab-org/gitlab@4528caee6d01cfb2e2c6b4f739cf7da3ed63a81f) ([merge request](gitlab-org/gitlab!149324)) **GitLab Enterprise Edition**
- [Change admin users search filter](gitlab-org/gitlab@60cb8a9b7be5eed84f1a2bf9d41c5e3a5620099a) by @bahek2462774 ([merge request](gitlab-org/gitlab!144907))
- [Protected packages: Show protected label in packages list](gitlab-org/gitlab@42a2d94bac523ec8cbd000609c49a38b84a72b46) by @gerardo-navarro ([merge request](gitlab-org/gitlab!141134))
- [Added delete api for instance level audit streaming](gitlab-org/gitlab@e81b3ef2809032b87bbdb1c3a662c256182aadad) ([merge request](gitlab-org/gitlab!149101)) **GitLab Enterprise Edition**
- [Update query for elevated_guests to use occupies_seat](gitlab-org/gitlab@0c7f5da4f50c6034cb018eca9378623869c5df53) ([merge request](gitlab-org/gitlab!148653)) **GitLab Enterprise Edition**
- [Frontend work for regex filter on Zoekt code search](gitlab-org/gitlab@bc2d7efa52429cabfd2cdd7a414c1aaf579a9728) ([merge request](gitlab-org/gitlab!144625))
- [Enabled product_analytics_billing by default](gitlab-org/gitlab@e4fbfd31e5ebe071a848a6c38c00bc9e355133fc) ([merge request](gitlab-org/gitlab!149243)) **GitLab Enterprise Edition**
- [Added update api for group audit event destinations](gitlab-org/gitlab@a08acfeab8dc426b96563d9a7ae26203af0d1ac2) ([merge request](gitlab-org/gitlab!148388)) **GitLab Enterprise Edition**
- [Remove experiment flag for product analytics](gitlab-org/gitlab@1fb7122f8e60a51e9e0f31213cbf29f1b467b21d) ([merge request](gitlab-org/gitlab!148983)) **GitLab Enterprise Edition**
- [Add co_authored_by placeholder to suggestions template](gitlab-org/gitlab@be6287b6c6e3280b26750842090563b531301183) ([merge request](gitlab-org/gitlab!148890))
- [New tests for project dropdown actions](gitlab-org/gitlab@61fc9592e2483aa2ba1577acc6d26b4e751c6915) by @espadav8 ([merge request](gitlab-org/gitlab!148750))
- [Obfuscate external participants emails in system notes](gitlab-org/gitlab@db7f244e226dfe2959034713daffa4b5511865fc) ([merge request](gitlab-org/gitlab!141612))
- [Update group policy to use admin_push_rules](gitlab-org/gitlab@ca6de0c1c208df53f13b08d024deafe4312853c6) ([merge request](gitlab-org/gitlab!147974)) **GitLab Enterprise Edition**
- [Added delete api for group audit event destinations](gitlab-org/gitlab@12d3cc288b8178cee1de4c8ac0bc9c89a514ece2) ([merge request](gitlab-org/gitlab!148738)) **GitLab Enterprise Edition**
- [Add top-level namespace to Usage Overview panel](gitlab-org/gitlab@3b8fbd9853cf73845a7dd95b7b11f4eb1bbeb1f5) ([merge request](gitlab-org/gitlab!148597)) **GitLab Enterprise Edition**
- [Add pre_receive_secret_detection_enabled param](gitlab-org/gitlab@875dfd8dbdd324b75e4fbc940381abd26cc28534) ([merge request](gitlab-org/gitlab!149160))
- [Protected containers: Create protection rules in project setting ui](gitlab-org/gitlab@aef987b99cf9d7e53a114f0d9d705e2304844e33) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146523))
- [Add catalog component usage tracking in pipeline sequence](gitlab-org/gitlab@a0f6fd925367eb55a428a2687203888f6d6af64c) ([merge request](gitlab-org/gitlab!149138))
- [Implement the ability to use shorthand for semantic versions](gitlab-org/gitlab@ae5f0b35997e69ba646fb5cb4b5ce11ab73a8370) ([merge request](gitlab-org/gitlab!147910))
- [Add client for generating vertex embedding](gitlab-org/gitlab@d142f59a3c45d286fa15c61b5d28f2d5327ca501) ([merge request](gitlab-org/gitlab!148483)) **GitLab Enterprise Edition**
- [Expose metadata fields on Milestone type](gitlab-org/gitlab@3e5d0ab7f83a6f5562512bc465285b3883af15f9) ([merge request](gitlab-org/gitlab!148927))
- [Document encryption support for Google Cloud Storage (GCS)](gitlab-org/gitlab@63e1b9dfd82aa5527006ed97c9b37dc4ea0031b7) ([merge request](gitlab-org/gitlab!148994))
- [This MR adds new filter option](gitlab-org/gitlab@e62883d3d8504032bcf92805555e30ba7e20636b) ([merge request](gitlab-org/gitlab!148675)) **GitLab Enterprise Edition**
- [Added list api for listing instance level audit event destinations](gitlab-org/gitlab@86186adc05d92bc5a9a88f275c33d543cba424e3) ([merge request](gitlab-org/gitlab!148839)) **GitLab Enterprise Edition**
- [Added create api for instance audit event streaming destinations](gitlab-org/gitlab@20ec713cb27b4e8701317e2211b39f6daf960e02) ([merge request](gitlab-org/gitlab!148383)) **GitLab Enterprise Edition**
- [Adds "Allow runner registration token" setting to top-level group](gitlab-org/gitlab@29df08fb36a5c6b2626a021f5f2a3696cd637506) ([merge request](gitlab-org/gitlab!148557))
- [Rollout new custom roles UI](gitlab-org/gitlab@e82557fd72bbdcb1eeab09499d12b84e91071bde) ([merge request](gitlab-org/gitlab!148468)) **GitLab Enterprise Edition**
- [This MR adds new policy type](gitlab-org/gitlab@34203ec1278f48992af196a9f717620962886916) ([merge request](gitlab-org/gitlab!148600)) **GitLab Enterprise Edition**
- [Add referrer_type filtering to containerRepository tags GraphQL query](gitlab-org/gitlab@4720e1cbb764c3807dc881dc06a145e4ba19d2c5) ([merge request](gitlab-org/gitlab!147277))
- [Enable `group_saved_replies_flag` by default](gitlab-org/gitlab@04f93bbecb93e9a73d891611d258b76d9c4e3251) ([merge request](gitlab-org/gitlab!148958))
- [Add manage security policy as custom ability](gitlab-org/gitlab@b6a8cf2d72af8ee4a64612711111586b4cafdad6) ([merge request](gitlab-org/gitlab!148371)) **GitLab Enterprise Edition**
- [Initialize bigint conversion for vulnerability_occurrence_pipelines](gitlab-org/gitlab@bd40369ab79962a83a19e852ab3624b958507a36) ([merge request](gitlab-org/gitlab!148735))
- [Initialize bigint conversion for merge_trains](gitlab-org/gitlab@343e2b965acfdcbcb6d70b7f74dbfcf8b3fc55ed) ([merge request](gitlab-org/gitlab!148730))
- [Initialize bigint conversion for merge_trains](gitlab-org/gitlab@09fcf24f778807dc4097b17b9088499a9a32234b) ([merge request](gitlab-org/gitlab!148786))
- [Initialize bigint conversion for packages_build_infos](gitlab-org/gitlab@c65891c9240d56b53f391e0666631cb84a2e14b3) ([merge request](gitlab-org/gitlab!148791))
- [Initialize bigint conversion for vulnerability_feedback](gitlab-org/gitlab@390b83d1b1280f8657d96f7ef7cacf8fa709118f) ([merge request](gitlab-org/gitlab!148790))
- [Add a new worker to process the pipeline creation for sep](gitlab-org/gitlab@0185a66f0b645ad9625ea94d3ec7299d8959175b) ([merge request](gitlab-org/gitlab!147691)) **GitLab Enterprise Edition**
- [Removed auto_cancel_pipeline_on_job_failure feature flag](gitlab-org/gitlab@5e80edd594717e6a91c65223bd24b2bc716dbf0d) by @zillemarco ([merge request](gitlab-org/gitlab!148515))
- [Add runner creation status](gitlab-org/gitlab@6faa548186a248a22a3686d8e125a4ca1d204f56) by @imskr ([merge request](gitlab-org/gitlab!144842))
- [Add close on escape support](gitlab-org/gitlab@89c281d7077c29a6ec4a2a62443008e6ce8f2071) ([merge request](gitlab-org/gitlab!148852)) **GitLab Enterprise Edition**
- [Initialize bigint conversion for merge_requests](gitlab-org/gitlab@3c7e1f1157c6608ca54f1c19fada2fb4f5c48015) ([merge request](gitlab-org/gitlab!148788))
- [Add accessLevel & isLastOrganizationOwner fields to organizationUser](gitlab-org/gitlab@2acf4411a1396b9f00b36e2c2b4f74de47de4785) ([merge request](gitlab-org/gitlab!148148))
- [Improve the performance of group-level vulnerability export](gitlab-org/gitlab@3c0c31802ca926ade373a71c6c356085eeb254e0) ([merge request](gitlab-org/gitlab!147365))
- [Enable Custom Webhook Headers feature](gitlab-org/gitlab@e05517344b269d3fe0f200f87ba7901d3852468e) by @Taucher2003 ([merge request](gitlab-org/gitlab!148690))
- [Consider child pipelines for MR approval policies](gitlab-org/gitlab@5ba4ebdcd7c9de8296df6535c92b135465061069) ([merge request](gitlab-org/gitlab!147710)) **GitLab Enterprise Edition**
- [Add development widget (feature flags)](gitlab-org/gitlab@5dc384fd05ab651525ecc922ab6f62dba3569d93) ([merge request](gitlab-org/gitlab!148215)) **GitLab Enterprise Edition**
- [Beyond Identity: Add option to exclude service accounts](gitlab-org/gitlab@da808914d9bf0afbc194e428f1396a054303366a) ([merge request](gitlab-org/gitlab!148590))
- [Add verified badge](gitlab-org/gitlab@89e089bbf086ca7d98cdc7d88ab4f5d007fa4127) ([merge request](gitlab-org/gitlab!147384))
- [Add runner wait time stats by namespace](gitlab-org/gitlab@0f7fece2f8d894cb670859298fd2c6caca2e0541) ([merge request](gitlab-org/gitlab!147148)) **GitLab Enterprise Edition**
- [Support minimal access base for custom roles](gitlab-org/gitlab@95ffa5f8d64aae0cd99c7014488c57bbfc23ddc4) ([merge request](gitlab-org/gitlab!148390))
- [Add object_attributes.action for note webhooks](gitlab-org/gitlab@abc1b67b29fc9c2a1cf7f4454b55ee527021631d) ([merge request](gitlab-org/gitlab!147856))
- [Add cadence validation for sep creation](gitlab-org/gitlab@d8732ca1a7ce25be3d06a01879ed11895b126a35) ([merge request](gitlab-org/gitlab!148096)) **GitLab Enterprise Edition**
- [Enable combined analytics dashboards by default](gitlab-org/gitlab@0675178be05bcbe8236b6b74b74684eaa950bbaf) ([merge request](gitlab-org/gitlab!148559)) **GitLab Enterprise Edition**
- [Create and list apis for group audit events](gitlab-org/gitlab@f5bafe4a48bc98901b4e709bfadad3adfedb5379) ([merge request](gitlab-org/gitlab!147888)) **GitLab Enterprise Edition**
- [Default enable producy analytics admin settings FF](gitlab-org/gitlab@0c4927326f9bbacd66653adf39b3832b37e711f3) ([merge request](gitlab-org/gitlab!148539)) **GitLab Enterprise Edition**
- [Enabling FF ci_retry_on_exit_codes on SM](gitlab-org/gitlab@24590f014becc7a09566dcc384dc0dfc7657239d) ([merge request](gitlab-org/gitlab!148189))
- [Add API endpoint to return current SSO session expiry time](gitlab-org/gitlab@a5f5dde09f72743021ca1f5aa2560aaa227f69b6) ([merge request](gitlab-org/gitlab!146011)) **GitLab Enterprise Edition**
- [Add REST API endpoint to sync push mirrors](gitlab-org/gitlab@1ab7f8dfad9608b4f5455f2c0d80c6a52c2d6fb5) ([merge request](gitlab-org/gitlab!148186))
- [Rollout security_policies_policy_scope_project by default](gitlab-org/gitlab@dcbcf0bdb1a8be2268339148dc2fdcecde39a551) ([merge request](gitlab-org/gitlab!148407)) **GitLab Enterprise Edition**
- [Add custom webhook headers](gitlab-org/gitlab@1504f88df5a07db69abeef68edcf9c4ec5a63fcd) by @Taucher2003 ([merge request](gitlab-org/gitlab!146702))
- [Remomve FF for search_add_archived_filter_to_zoekt](gitlab-org/gitlab@c2b5997f9b1e6d7326cacf73d591927c740538da) ([merge request](gitlab-org/gitlab!148107)) **GitLab Enterprise Edition**
- [Enalbed the global Duo Chat button](gitlab-org/gitlab@e3c4da4f8b7186e628f7dc8fea9e0bbf6ee2af82) ([merge request](gitlab-org/gitlab!148402)) **GitLab Enterprise Edition**
- [Validate check null constraint for vulnerability_reads#traversal_ids](gitlab-org/gitlab@e59b81bac5ad2b16797694870ef10e12095db594) ([merge request](gitlab-org/gitlab!148386))
- [Switch Groups UX to emails_enabled](gitlab-org/gitlab@77b46f4a8ccb8901e04b50a378d10d5284d4f00b) by @joe-snyder ([merge request](gitlab-org/gitlab!135959)) **GitLab Enterprise Edition**
- [New Audit Event when approval rule is updated](gitlab-org/gitlab@45d8bc02374aefcf852f1a61b8849a11db930b6f) ([merge request](gitlab-org/gitlab!146819)) **GitLab Enterprise Edition**
- [Add list of tag in external pipeline validation api](gitlab-org/gitlab@0db47b7ac6a22038a0298ac9314389db4650ab4c) by @lifez ([merge request](gitlab-org/gitlab!148318))
- [This MR adds breaking changes icon](gitlab-org/gitlab@3574df9f1f482529b31ae657476f1a1d0885757d) ([merge request](gitlab-org/gitlab!146921)) **GitLab Enterprise Edition**
- [Add user count to Usage Overview panel on Value Streams Dashboard](gitlab-org/gitlab@b52185cfd145cfa9165bd68e07d5be1e32fd0cd7) ([merge request](gitlab-org/gitlab!148254)) **GitLab Enterprise Edition**
- [Update JiraConnect app_descriptor](gitlab-org/gitlab@d4e186f8744231fc4c9c5139394446017d4034f0) ([merge request](gitlab-org/gitlab!148251))
- [Finalize BackfillHasIssuesForExternalIssueLinks background migration](gitlab-org/gitlab@af5f897a532475711837ea27d3b8d32260d6c216) ([merge request](gitlab-org/gitlab!148244))
- [Enable create_vulnerability_jira_issue_via_graphql by default](gitlab-org/gitlab@acab556c474c16825ea0da33449e2403f2a87b4b) ([merge request](gitlab-org/gitlab!148239)) **GitLab Enterprise Edition**
- [feat: Protected containers: Protection rules in project settings ui](gitlab-org/gitlab@794768d4aa5ca2347b9c7c20aca303ee487b5d0b) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146436))
- [Add a new column zoekt_settings in the application_settings](gitlab-org/gitlab@54abc04448244b588436065b6d807fe91af51a8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147914))
- [Add a shared avatar image for security policy bots](gitlab-org/gitlab@799dd2d015217e47d82c9a3bfb7432e8bbc014c9) ([merge request](gitlab-org/gitlab!146942))
- [Add Create New Merge Request button to issues in forked projects](gitlab-org/gitlab@a3d260fd772c7d407c8f363e849d1b9cb8e25886) ([merge request](gitlab-org/gitlab!147355))
- [Accept generation_type parameter](gitlab-org/gitlab@682b3e557d9e76385799d13b8fac1a9a43e82ab4) ([merge request](gitlab-org/gitlab!147421)) **GitLab Enterprise Edition**
- [Add autocomplete support for wiki pages](gitlab-org/gitlab@27c318f7b83312cd6ec2a04704414ccbe6139556) ([merge request](gitlab-org/gitlab!143654))
- [Introduces hidden variable to group and ci variables](gitlab-org/gitlab@8ecd09100a7e8af196c3ec4bef8db0ab9a106fa3) ([merge request](gitlab-org/gitlab!141926))
- [Enable GitLab for Slack app for Instances and Groups](gitlab-org/gitlab@aca445a970e6cfccfe43566f34192835becec2af) ([merge request](gitlab-org/gitlab!147820))
- [Add indirect membership API endpoint](gitlab-org/gitlab@35586c95a5c16dad059058c36f143fa956032e3a) ([merge request](gitlab-org/gitlab!145227)) **GitLab Enterprise Edition**
- [Expose `created_at` field in Tags API](gitlab-org/gitlab@dea10fa96631eecb3834a7fdf1a9b1eacacc61da) ([merge request](gitlab-org/gitlab!147785))
- [Add topic support for Telegram](gitlab-org/gitlab@e6152b6d9b87bc5ba9f26f6d239b4f7c4cfc52a3) ([merge request](gitlab-org/gitlab!147734))
- [Wait for ClickHouse workers before running migrations](gitlab-org/gitlab@9060b40f86cd60cd38b488914d017d3509ab9243) ([merge request](gitlab-org/gitlab!147925))
- [Add `default_branch` attribute to Groups API](gitlab-org/gitlab@86ffba7a79ef7d6625062b2787be1551ea90dbd5) ([merge request](gitlab-org/gitlab!145803))
- [Add post migration to set value of occupies_seat column](gitlab-org/gitlab@abdb1960504d0a5b89ad7b16dcd44143a8d259d9) ([merge request](gitlab-org/gitlab!146293))
- [Add setting for pre-receive secret detection](gitlab-org/gitlab@631340d934a92d4eee47b762882b255eb739046f) ([merge request](gitlab-org/gitlab!147831)) **GitLab Enterprise Edition**
- [Remove feature toggle for policy scope](gitlab-org/gitlab@8c61aded645b4d1935d2d15e22c135a679e214f2) ([merge request](gitlab-org/gitlab!145997)) **GitLab Enterprise Edition**
- [Add '/clear' to Duo Chat commands in addition to '/clean'](gitlab-org/gitlab@b7beb41ec62dad5e59b543aaa455ba96472550b6) ([merge request](gitlab-org/gitlab!147380)) **GitLab Enterprise Edition**
- [Add setting for enabling CS for Registry](gitlab-org/gitlab@31a3e10652e98f380970e1fa88873ff643b1758d) ([merge request](gitlab-org/gitlab!147409)) **GitLab Enterprise Edition**
- [AddOnPurchase process trial attribute](gitlab-org/gitlab@318753cfb1c1f2dc35e400b53d74d116c3986a96) ([merge request](gitlab-org/gitlab!147522)) **GitLab Enterprise Edition**
- [Add detailed view for pods and services](gitlab-org/gitlab@07057f76bd480726d0db5ef84af5c7dbd9db55de) ([merge request](gitlab-org/gitlab!147553))
- [Add array types to CI inputs](gitlab-org/gitlab@853153958068f8586bee2bfb6dca6a8c64925e3e) ([merge request](gitlab-org/gitlab!145954))
- [Add full_path GQL field to ResourceType](gitlab-org/gitlab@c5c9e4a7c30f20c642d239e1f11945de8dbe2fcd) ([merge request](gitlab-org/gitlab!147623))
- [Add report abuse button](gitlab-org/gitlab@a82ef82275695877f23351a4192763ec71e91d69) ([merge request](gitlab-org/gitlab!143692))
- [Add access keyword in artifacts](gitlab-org/gitlab@9fa22477401fa7257391a7fab5a3b8bc683b9488) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145206))
- [Finalize PurgeSecurityScansWithEmptyFindingData migration](gitlab-org/gitlab@c5b2254257272ad4906664d98c019257a0ce06e3) ([merge request](gitlab-org/gitlab!147426))
- [Work item two column loading skeleton](gitlab-org/gitlab@5c5d2ec1acf231d51a1bef7a65753deeefbcfb29) ([merge request](gitlab-org/gitlab!146615))
- [Add trial column to subscription_add_on_purchases table](gitlab-org/gitlab@e64f8868f576f4616df91b101db9b9b2c1186089) ([merge request](gitlab-org/gitlab!147422)) **GitLab Enterprise Edition**
- [Add migration to index all projects](gitlab-org/gitlab@a81fb1fa887c886c053e08893a04cdb7abe4584d) ([merge request](gitlab-org/gitlab!145131)) **GitLab Enterprise Edition**
- [Add usage_count columns to catalog tables](gitlab-org/gitlab@92fa72a80a427e1c374d111eab00fc2191180b07) ([merge request](gitlab-org/gitlab!147293))
- [Add a worker Zoekt::MarkReadyWorker](gitlab-org/gitlab@8b48c1465f408d915b60474a1bf38de04904e89c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/146475)) **GitLab Enterprise Edition**
- [Validate the foreign key & add to routing table commit_id](gitlab-org/gitlab@e88832c384b363628b9f8cc26446c51e413160a1) ([merge request](gitlab-org/gitlab!146964))
- [Add avatar to new achievement form](gitlab-org/gitlab@91bd29352ce7830664da5d16cd8b1a23980f9cdd) ([merge request](gitlab-org/gitlab!147040))
- [Add humanized role to removal events in audit details](gitlab-org/gitlab@bb18b60933e840a4f3179bab6d77d7fd8c108506) ([merge request](gitlab-org/gitlab!147435)) **GitLab Enterprise Edition**
- [Added model for instance level event type filters](gitlab-org/gitlab@585a40d553de3ea560447813e7fb79434d7afe3c) ([merge request](gitlab-org/gitlab!145421)) **GitLab Enterprise Edition**
- [Add frontend filter for zoekt code search](gitlab-org/gitlab@752200fdf1126146712847c1075b0a4c2d061bd1) ([merge request](gitlab-org/gitlab!147014)) **GitLab Enterprise Edition**
- [Add `spec` column to `catalog_resource_components`](gitlab-org/gitlab@c7cf6d3080559a2231dfd1b3ac01d0a5c14fab64) ([merge request](gitlab-org/gitlab!146674))
- [Make `traversal_ids` column nullable if it's already not](gitlab-org/gitlab@155267bfa51e8d5e2efd45dc9e850eb7d774e0bb) ([merge request](gitlab-org/gitlab!147326))
- [Add not valid null check constraint for `traversal_ids`](gitlab-org/gitlab@4255ad3962ac3cf3572dc4d088514ab6c4ed1aa3) ([merge request](gitlab-org/gitlab!147276))

### Fixed (141 changes)

- [Update pages ci templates - Gatsby](gitlab-org/gitlab@f309140b1c746dbf93ba0e5d75342348760f64fe) ([merge request](gitlab-org/gitlab!148120))
- [Consider merge request pipelines for license approval policies](gitlab-org/gitlab@334e560a3649c8071429023e4b745761311dbfcf) ([merge request](gitlab-org/gitlab!149192)) **GitLab Enterprise Edition**
- [Disable personal access tokens for enterprise users](gitlab-org/gitlab@cbf59303e43effeabe2d1fa7abe3df631cdff9dd) ([merge request](gitlab-org/gitlab!148415)) **GitLab Enterprise Edition**
- [Fix ArgumentError in ProjectApprovalRules API](gitlab-org/gitlab@e2d0c77bb4bc7045851c35c9f27b75a18a1a9b0b) ([merge request](gitlab-org/gitlab!149106)) **GitLab Enterprise Edition**
- [Add row gap between rows of codeowner approver avatars](gitlab-org/gitlab@57816fbf3da86695403517b75f5d6542ab0be68c) ([merge request](gitlab-org/gitlab!149008)) **GitLab Enterprise Edition**
- [Fix hover state of emoji on snippets](gitlab-org/gitlab@f0154f2277fb93bcadec376de10c1977d5e7cdfa) ([merge request](gitlab-org/gitlab!149153))
- [Hide `New subgroup` button if visibility is restricted](gitlab-org/gitlab@97b12dbf8ea56eb4fdc96a8b775ac319f6bdb957) ([merge request](gitlab-org/gitlab!148758))
- [Ensure command pallet search respects current ref](gitlab-org/gitlab@4db0a566751b3e28166813f6d14b81f8d0f30c82) ([merge request](gitlab-org/gitlab!149084))
- [Escape markdown characters for Telegram integration](gitlab-org/gitlab@545fb61ba96dd21754e929fdb3f6de8d123671d2) ([merge request](gitlab-org/gitlab!148703))
- [Fix job log link regex](gitlab-org/gitlab@bdbcbb71363fbe9b6503c87dec979de2ab1838c1) ([merge request](gitlab-org/gitlab!148891))
- [Fix undefined method error when package.json is malformed](gitlab-org/gitlab@0e4e9aba50543be7b283ad3bc2d5753c2db8f931) ([merge request](gitlab-org/gitlab!149148))
- [Remove unnecessary md header divider when previewing](gitlab-org/gitlab@4692a59fc53bfb1fc1dd2a4d11a498838218e1df) ([merge request](gitlab-org/gitlab!149012))
- [Fix NoMethodError when an array parameter has an invalid format](gitlab-org/gitlab@920437053ace6d4d6625c60caa860305983d46dc) ([merge request](gitlab-org/gitlab!148962)) **GitLab Enterprise Edition**
- [MR approval widget: Align text correctly](gitlab-org/gitlab@4218a8b5430990ca3e2c4008140e36a55dcb6487) ([merge request](gitlab-org/gitlab!149056))
- [[Batched Migration] Fix corrupted scanner_ids of vulnerability_reads](gitlab-org/gitlab@fc5abd0b3f19b5aaa009704bd9f586f457801537) ([merge request](gitlab-org/gitlab!148807)) **GitLab Enterprise Edition**
- [Temporarily restore old breadcrumbs UX](gitlab-org/gitlab@ae8f680b61091bddb1abd86624cdc36126e6ba6c) ([merge request](gitlab-org/gitlab!148673))
- [Avoid bad MIN query plan during batch count](gitlab-org/gitlab@786631a70c5e96948be2bb96a9e62b76b41de516) ([merge request](gitlab-org/gitlab!148608)) **GitLab Enterprise Edition**
- [Show status, milestone and statistics on service desk issue list](gitlab-org/gitlab@135ed3c1ad3e8a035b633f3555cce54c7607ab5b) ([merge request](gitlab-org/gitlab!148895))
- [Clean up instrumentation key in analytics controller](gitlab-org/gitlab@15067f062f8123521d576b4c39e4c659a0eba78d) ([merge request](gitlab-org/gitlab!148840)) **GitLab Enterprise Edition**
- [MR widget approvals: Auto update approvals](gitlab-org/gitlab@fa3bfef9a940b60742d5d7d20fda0b2640bc2ae1) ([merge request](gitlab-org/gitlab!148379))
- [Let sub group api update default branch protection defaults](gitlab-org/gitlab@eafcf0f24fcd4f7a6eaa5b3e4e552cfbccdcd12e) ([merge request](gitlab-org/gitlab!148566))
- [Fix migration error when updating from GitLab 16.9 to 16.10](gitlab-org/gitlab@d2f0aaf37ececcd92b0c1eab73129532c92fb71a) ([merge request](gitlab-org/gitlab!148135))
- [MR sidebar: Fix reviewers loading icon position](gitlab-org/gitlab@af34d0b62b56e6d3b94b70ab28a277d9ea07a919) ([merge request](gitlab-org/gitlab!148950))
- [MR approval in MR list: Fix display of total approvals](gitlab-org/gitlab@5b91c9e43f813c100dab62bb8df1861c0a831452) ([merge request](gitlab-org/gitlab!148941)) **GitLab Enterprise Edition**
- [Skip license capacity check for security policy bot user](gitlab-org/gitlab@33345f3c5ed65a5f4920a1f5c68e5b84582ae6aa) ([merge request](gitlab-org/gitlab!148893)) **GitLab Enterprise Edition**
- [Preserve indirect memberships](gitlab-org/gitlab@bd9dae0c2b320cc75a99b720e1733b5894ef66a2) ([merge request](gitlab-org/gitlab!148220))
- [Fix border radius on MR diffs](gitlab-org/gitlab@f384129183453962a28da05cdc901d3986a9f737) ([merge request](gitlab-org/gitlab!148716))
- [Adapt Graphql path depending on GitHub API endpoint](gitlab-org/gitlab@f3b9cd839825c0b5200870f1f76735ff433a0e5d) by @daniel.marks ([merge request](gitlab-org/gitlab!147143))
- [Migrate sbom_occurrences.component_name to match](gitlab-org/gitlab@85faa73c55cc3aa61b41a0afdbbb3442edff3fd7) ([merge request](gitlab-org/gitlab!146776))
- [Fix pipeline complete condition and include manual state](gitlab-org/gitlab@5713bf9fbb108efd38808ed8a955c2e79370f240) ([merge request](gitlab-org/gitlab!148866)) **GitLab Enterprise Edition**
- [Use 2x image source for avatars smaller than 96px](gitlab-org/gitlab@7fefa86be66444f85e1229b96a7feb2b960b17b5) ([merge request](gitlab-org/gitlab!148333))
- [Prevent access to achievements for private groups](gitlab-org/gitlab@664430132351ea6aa881d78ae3ccb0f19f7a369b) ([merge request](gitlab-org/gitlab!147319))
- [This MR fix scope column in policy list](gitlab-org/gitlab@ec655265e05b1924ebc9ce50ea5d758f2877fb60) ([merge request](gitlab-org/gitlab!148842)) **GitLab Enterprise Edition**
- [Fix missing validation for Branches::CreateService](gitlab-org/gitlab@b458ed5ee901060552dd2d2ab80d04fc3a773faa) ([merge request](gitlab-org/gitlab!148689))
- [Make milestone titles unique in group hierarchy](gitlab-org/gitlab@aa5a790f9e3de50a049a1fd52d46a7e1f3c142a9) ([merge request](gitlab-org/gitlab!142857))
- [Correct parse the `canEdit` permission for project dropdown items](gitlab-org/gitlab@310ceeea42b8586001d948f54a56c08f2547c644) by @espadav8 ([merge request](gitlab-org/gitlab!148659))
- [Fix 500 error in Commits API when the repository is empty](gitlab-org/gitlab@778793d50837ca778541931827fe08cdc823765f) ([merge request](gitlab-org/gitlab!148405))
- [MR widget: Fix alignment of approval button and text](gitlab-org/gitlab@07cbdc49f8fb6097db11417a32208a5881220cf3) ([merge request](gitlab-org/gitlab!148631))
- [Fix "Import with projects" button not showing](gitlab-org/gitlab@fd2d9482bc2104f0df61c338ae6a415642a8f894) ([merge request](gitlab-org/gitlab!148613))
- [Fix board scope assignee dropdown results](gitlab-org/gitlab@4ff3dcf5d4fdc51928bfe339271df898146dfe7a) ([merge request](gitlab-org/gitlab!148377)) **GitLab Enterprise Edition**
- [Invert emails_disabled into emails_enabled](gitlab-org/gitlab@e6f3c8ddaeb34ee8526645418eaf61935308038c) ([merge request](gitlab-org/gitlab!148577))
- [Use locale-specific formatting for VSD table numbers](gitlab-org/gitlab@4b71d52baa05867abafcff3e03f5ad417d9dc4e0) ([merge request](gitlab-org/gitlab!148331)) **GitLab Enterprise Edition**
- [Correct diff colors & highlighting for none theme](gitlab-org/gitlab@8391bb3e6461fbf508bb965a7e98b33115e79cda) by @jameschensmith ([merge request](gitlab-org/gitlab!148538))
- [Disable sending of Link header in preload_link_tag](gitlab-org/gitlab@76fe184e4281812a9f819c2b3a2c4c3a89b356f1) ([merge request](gitlab-org/gitlab!148280))
- [Fix job sidebar when artifact access is restricted](gitlab-org/gitlab@e9cee36e9a051a782b8e47f8ecf5b43d6bc6d111) ([merge request](gitlab-org/gitlab!148453))
- [This is a small breaking change, and while it's not being done in the](gitlab-org/gitlab@1e9e6d5fcd5913ca79505fff4dc1dd1a44f99935) by @gitlab-dependency-update-bot ([merge request](gitlab-org/gitlab!147619))
- [Fix the test report modal](gitlab-org/gitlab@c9808da3a3bff4e6ad8e052391500c8128b84799) ([merge request](gitlab-org/gitlab!148440))
- [Fix handling of DAGs within a stage in AtomicProcessingService ](gitlab-org/gitlab@9ceb88fe5421afa87af290da78f419032325d746) ([merge request](gitlab-org/gitlab!148211))
- [Fix Duo Chat Popover Design Managment overlapping Bug](gitlab-org/gitlab@843bb55409348cc91e2d0ebb74094917e3823d3c) ([merge request](gitlab-org/gitlab!148434))
- [Fix epic links in issue sidebar changing to work item link](gitlab-org/gitlab@d7ac773456fd49792073024a505a4dc24cbc3888) ([merge request](gitlab-org/gitlab!148420))
- [Fix NoMethodError for tags#date](gitlab-org/gitlab@96858a07cc2046162dc7c15e5a95de33ba5f9c23) ([merge request](gitlab-org/gitlab!148413))
- [Support large wiki content in webhooks](gitlab-org/gitlab@3e38cff3a36d741b89b59859317cf8d6b3916917) by @ivantedja ([merge request](gitlab-org/gitlab!146973))
- [Fix included avatar in the code copy](gitlab-org/gitlab@fd451c621adcd6f59f03c636b665f3bf8b9c0cca) ([merge request](gitlab-org/gitlab!148243))
- [Use a correct link to group templates docs](gitlab-org/gitlab@30669dff2c937c78033b3de578d0d9c4bfb4e1cb) ([merge request](gitlab-org/gitlab!148374)) **GitLab Enterprise Edition**
- [Fix URL validator for mirror services when using localhost](gitlab-org/gitlab@310317f36d14efe8b424b1fdcb5fe00abdae1395) ([merge request](gitlab-org/gitlab!148368))
- [Expose `branches_to_be_notified` field for Telegram API](gitlab-org/gitlab@7bf6d3eee9c8a33f73a7b1f4e2a29268aa9d68b7) ([merge request](gitlab-org/gitlab!148281))
- [Fix duplicate "Job suceeded lines"](gitlab-org/gitlab@e86eddfe31a4e1ba25e4ca271c6c2d693f72e69a) ([merge request](gitlab-org/gitlab!148255))
- [WIP OVERWRITE LATER](gitlab-org/gitlab@81a73d56889b006adc1d36d60e04dbabb08e37c2) ([merge request](gitlab-org/gitlab!148262))
- [Fail sync when a primary connection is unvailable](gitlab-org/gitlab@756f9cdb1518ded4c2f53e9971ba38634d1f129c) ([merge request](gitlab-org/gitlab!148105)) **GitLab Enterprise Edition**
- [Trigger Epic events after transaction has been finished](gitlab-org/gitlab@4eab137d71d3e4d7785efcea963088567c9b6e9f) ([merge request](gitlab-org/gitlab!147677)) **GitLab Enterprise Edition**
- [Update vulnerability_reads scanner in the ingestion pipeline](gitlab-org/gitlab@287fd2d24d774cde7293e803a2cdc7f2c4dcf7ff) ([merge request](gitlab-org/gitlab!148016)) **GitLab Enterprise Edition**
- [Strip keywords from chat final answer](gitlab-org/gitlab@ca76cb9a231b8842bfad0b90a624558da584fbc3) ([merge request](gitlab-org/gitlab!148177)) **GitLab Enterprise Edition**
- [Fix native browser navigation in MR single-file mode](gitlab-org/gitlab@95c6310bc3d409db219246bc8c96fed684ca6f34) ([merge request](gitlab-org/gitlab!147413))
- [Fixes race condition for GFM rendering on issuable description](gitlab-org/gitlab@89a1fbb0cd5749991ca77cd0ce84747097a69613) ([merge request](gitlab-org/gitlab!148150))
- [Branches list: Fix focus states](gitlab-org/gitlab@be5f35c4998e8e50461075b9cbcf84bcf4009763) ([merge request](gitlab-org/gitlab!148057))
- [Fix cache timeout for commands](gitlab-org/gitlab@7655608a37274a2836fb1b799eeb886e0ebc65c3) ([merge request](gitlab-org/gitlab!147368))
- [Fix wiki URLs for wiki webhooks](gitlab-org/gitlab@dc6f269ba62b3e8ab95aca104179007d969bb8cb) by @ivantedja ([merge request](gitlab-org/gitlab!147822))
- [Fix size of design management todo button](gitlab-org/gitlab@8cec5771e1d853effa09babb9cbc9f7e3f2b007b) ([merge request](gitlab-org/gitlab!147941))
- [Strip cookies for asset requests in development and test](gitlab-org/gitlab@58a4a2cb5fb3ee1e205df5c314cb48a64f4cfb97) ([merge request](gitlab-org/gitlab!148117))
- [Remove echarts <5.x workaround in lead_time_charts](gitlab-org/gitlab@71b3002dbf56cc48fc0f2433ae8647688a36056f) ([merge request](gitlab-org/gitlab!148116)) **GitLab Enterprise Edition**
- [Fix styling of Incident timeline tab in dark mode](gitlab-org/gitlab@14bff2aa8bad57734a74f1210312337f6081d5f5) ([merge request](gitlab-org/gitlab!147852))
- [Fixes a horizontal scrolling issue for json tables](gitlab-org/gitlab@d38662cb71260969cd10d98cc3d0651a9cc5f9d4) by @fagerburg ([merge request](gitlab-org/gitlab!147286))
- [Fix blurry avatars when size < 48](gitlab-org/gitlab@d9d6391d1330e749500446b0e295106a61321716) ([merge request](gitlab-org/gitlab!147821))
- [Fix the deprecated_properties method](gitlab-org/gitlab@c2c641f183d38ccfca4be64a3463f2e342eec11a) ([merge request](gitlab-org/gitlab!147958)) **GitLab Enterprise Edition**
- [Pipeline Sec: Fix issue with deleted Jira issue](gitlab-org/gitlab@4e7bf39e3087bccc23b14780afeb07afc22d9e22) ([merge request](gitlab-org/gitlab!148007)) **GitLab Enterprise Edition**
- [Fix component include path rendered in the components tab](gitlab-org/gitlab@79a10b4eca5b2ed002105bd5ad91ffc8e3501163) ([merge request](gitlab-org/gitlab!147998))
- [Fix handling of DAGs within a stage in AtomicProcessingService](gitlab-org/gitlab@44911410286607e47a98e885744b06ec87d6c865) ([merge request](gitlab-org/gitlab!147875))
- [Fix handleLocationHash behavior for MRs and issuables](gitlab-org/gitlab@ab1e57d6c1d78d3efa69dde14bd66c7d39e5cbd6) ([merge request](gitlab-org/gitlab!147711))
- [Fix commit status API incorrectly overwriting MR head pipeline](gitlab-org/gitlab@6a4c87d6db68e2536b90b38c1e11f9a158bd7480) ([merge request](gitlab-org/gitlab!147212))
- [Pipeline Sec: Fix Jira issue creation](gitlab-org/gitlab@da3b8c10a91c3152af0b00048ebcc2b9c4c7c765) ([merge request](gitlab-org/gitlab!147647)) **GitLab Enterprise Edition**
- [Handle null owner when indexing projects](gitlab-org/gitlab@059908f552762fbc26bc8d62f383770cfc02f926) ([merge request](gitlab-org/gitlab!147951)) **GitLab Enterprise Edition**
- [Add search functionality to sub group autocomplete](gitlab-org/gitlab@5172a9247bc4fc7b5192247db7dfd27be4d94dce) ([merge request](gitlab-org/gitlab!147578)) **GitLab Enterprise Edition**
- [Initialize hiding tooltip for links with tooltips when clicked](gitlab-org/gitlab@4fd57f617d97c9764e11c4c89c03e399fc1a3507) ([merge request](gitlab-org/gitlab!147947))
- [Fix design management notification buttons feature flag](gitlab-org/gitlab@61e6d9765c2b4ecbcc236ec9f6ed5590037958fe) ([merge request](gitlab-org/gitlab!147945))
- [ActionController::UrlGenerationError for old path redirects](gitlab-org/gitlab@4b37f666e26e3f382a88e5e4872ae2de9d2399e9) ([merge request](gitlab-org/gitlab!147933))
- [Use vue routes for group custom Value Stream Dashboard](gitlab-org/gitlab@8b431614f3d6e8a254eef23dde703a0f35dc10d0) ([merge request](gitlab-org/gitlab!147842)) **GitLab Enterprise Edition**
- [Set `traversal_ids` and `archived` attributes always](gitlab-org/gitlab@589b246fa034fd339aefb746ac1de972409d843b) ([merge request](gitlab-org/gitlab!147082)) **GitLab Enterprise Edition**
- [Fix 500 error for erroneous content in markdown footnotes](gitlab-org/gitlab@8d061c5813ad28eea8afd6bdf15d098ad720a7a1) ([merge request](gitlab-org/gitlab!147922))
- [Update pages ci templates - Nanoc](gitlab-org/gitlab@f6e2b4f9edf9a1ceba5428f0dd435caac0f10242) ([merge request](gitlab-org/gitlab!147722))
- [Fix start_is_fixed and due_date_is_fixed default](gitlab-org/gitlab@2a2405c48f9081c415ba9623d653a85995a4ef69) ([merge request](gitlab-org/gitlab!147119)) **GitLab Enterprise Edition**
- [Skip migration when the partitioned FK exists](gitlab-org/gitlab@cb88e677ff9397c1b825d38381f987465fc76b1c) ([merge request](gitlab-org/gitlab!147878))
- [Handle missing pipeline user name in terraform registry UI](gitlab-org/gitlab@db119bed67e45bb7779aaf187b3af77fbe8af7e7) ([merge request](gitlab-org/gitlab!147865))
- [Reset pagination page](gitlab-org/gitlab@e164ef2015c9388d00bd3b4f9842fc747a779bb1) ([merge request](gitlab-org/gitlab!147832))
- [Fix leave action label for project members](gitlab-org/gitlab@f8bb6dd151393ff9e2b0e59921204fa7665b2a41) ([merge request](gitlab-org/gitlab!147692))
- [Replace space with HTML entity](gitlab-org/gitlab@eae79bfd94be8cb6d9a05adf2dd1fad284180116) ([merge request](gitlab-org/gitlab!147805)) **GitLab Enterprise Edition**
- [Apply inline validation to admin deletion protection settings](gitlab-org/gitlab@f5733cdc6a4a32780a0e1803d5bc447d1564f1c0) ([merge request](gitlab-org/gitlab!147299)) **GitLab Enterprise Edition**
- [Fix webhook test send wrong object kind for tag_push_event](gitlab-org/gitlab@ecc33395ae61141eb8d09245350ede435a070058) by @lifez ([merge request](gitlab-org/gitlab!147634))
- [Use semaphore for storing security reports](gitlab-org/gitlab@fea7c1843b08a9377a96f0a15e071b560867948c) ([merge request](gitlab-org/gitlab!147816)) **GitLab Enterprise Edition**
- [Fix character escaping in fork divergence message](gitlab-org/gitlab@0699d4ed2e2e61da32798d73a62ff79dbeadf073) ([merge request](gitlab-org/gitlab!147808))
- [Zoekt: Retry indexing if too many requests](gitlab-org/gitlab@0f2ecf22b24826efe5b30168acd9b5ee612ceda9) ([merge request](gitlab-org/gitlab!147776)) **GitLab Enterprise Edition**
- [Update pages ci templates - Lektor](gitlab-org/gitlab@89756d0a3c14b24dac2cc3b5e0a4d801b49ee876) ([merge request](gitlab-org/gitlab!147491))
- [Fix focus state for dark mode rounded bottom markdown input](gitlab-org/gitlab@ce00c22b4ba4a87d03fe57c9bb0bcfae35eb4a9d) ([merge request](gitlab-org/gitlab!147476))
- [Fix invalid CI input array type default value](gitlab-org/gitlab@3070c59f634ba8357fc9bcf32dcd763f1bfb0cd5) ([merge request](gitlab-org/gitlab!147681))
- [Update redis-client to v0.21.1](gitlab-org/gitlab@2e2191cb4f7ef4fdb4f7088377483beab31e0714) ([merge request](gitlab-org/gitlab!147675))
- [Include all changes made to issuable in hook data](gitlab-org/gitlab@9f0fd32b7039d6ba23b8829a1792490fbfc15626) ([merge request](gitlab-org/gitlab!147033))
- [Fix markdown header for uses with restricted items](gitlab-org/gitlab@be9c2c1e736c48341a7446829c101b6738b46e71) ([merge request](gitlab-org/gitlab!147481))
- [Fix VSD column names not matching the date range](gitlab-org/gitlab@45b59e2e3f52cfd953f51dd3e9c463d9ea2c7323) ([merge request](gitlab-org/gitlab!147668)) **GitLab Enterprise Edition**
- [Fix apparent spacing of issuable sidebar content](gitlab-org/gitlab@6502a266e8918d606b2266bae7edd21138a6c613) ([merge request](gitlab-org/gitlab!147294))
- [Pass plan when create trials](gitlab-org/gitlab@5f8421ffd418ea5fcf6141d8a731afce3d9dba4a) ([merge request](gitlab-org/gitlab!147635)) **GitLab Enterprise Edition**
- [Remove `ci_fix_input_types` feature flag](gitlab-org/gitlab@bcd12f77cd3875df3a87add7eed73a94ddda46da) ([merge request](gitlab-org/gitlab!146897))
- [Fix import of Gitea projects with a dot in owner name or project name](gitlab-org/gitlab@8c3c45e68887a072ac12ae3280bb5b0b489ba215) by @Cerdic ([merge request](gitlab-org/gitlab!146168))
- [Strip namespaces from OS component names](gitlab-org/gitlab@4f416b69ff375b7f200eb903ae37855d3a3cb9e9) ([merge request](gitlab-org/gitlab!145613)) **GitLab Enterprise Edition**
- [Fix check for adminPath in home_panel.vue](gitlab-org/gitlab@5d16553bf2053166eedd63a6cf96f9bfc0f42f10) ([merge request](gitlab-org/gitlab!147562))
- [Keep scope conditions for associations](gitlab-org/gitlab@0ce8a7ae2f050ed3b4b2ec190e98edf31e049c62) ([merge request](gitlab-org/gitlab!147550))
- [Fix the case when mirror trigger builds is not set](gitlab-org/gitlab@9bc3be7276d094256814b2b16e78a3c9ed520f2f) ([merge request](gitlab-org/gitlab!147545)) **GitLab Enterprise Edition**
- [Fix new project group templates pagination](gitlab-org/gitlab@2c5f068a0ab0e187cc564fda6a4765431d8a6a24) ([merge request](gitlab-org/gitlab!147534)) **GitLab Enterprise Edition**
- [Fixes update analytics dashboards project settings](gitlab-org/gitlab@f095431a0d6bbeca0a94b3b4b515ac8e440bbb41) ([merge request](gitlab-org/gitlab!147533)) **GitLab Enterprise Edition**
- [Change CRM Contacts help icon color](gitlab-org/gitlab@337c6ce961bc7bd1a514d3cbfc6b98068a8f08fd) ([merge request](gitlab-org/gitlab!147331))
- [Fix line width which separating the timeline events](gitlab-org/gitlab@fc17d327787945dc7d7a493c65ce30ce8a7d5cc1) by @antonkalmykov ([merge request](gitlab-org/gitlab!147037))
- [Pipeline Sec Report: handle Jira issues](gitlab-org/gitlab@e80220aa097b1ff7e304c5669da175773d1121e0) ([merge request](gitlab-org/gitlab!147102)) **GitLab Enterprise Edition**
- [Enable 'self' in Content-Security-Policy worker-src directive](gitlab-org/gitlab@52ec8103551d0b5fbcaf3d1b02cbcaa9ffe441a1) ([merge request](gitlab-org/gitlab!147472))
- [Ensure labels in inapplicable task list items are crossed out](gitlab-org/gitlab@4b6db3fe08157be75d3a286e6f1557ef864caacc) ([merge request](gitlab-org/gitlab!147361))
- [Delete callback should use namespace_id](gitlab-org/gitlab@2e0540f4a5b45f9245103f3fa17356c24e885192) ([merge request](gitlab-org/gitlab!147459)) **GitLab Enterprise Edition**
- [Fix the permission check for pull mirroring](gitlab-org/gitlab@4249c03c44f11d49b4c201c5b1247513cffd0c43) ([merge request](gitlab-org/gitlab!146899)) **GitLab Enterprise Edition**
- [Update pages ci templates - JBake, Jekyll, Jigsaw](gitlab-org/gitlab@74943a41a628eb764472c0fd3809e46c4bb1095d) ([merge request](gitlab-org/gitlab!146529))
- [Fix Vite HMR Content Security Policy rules](gitlab-org/gitlab@25f1a1d56fc1b814ff921535ef333997fae038a2) ([merge request](gitlab-org/gitlab!147366))
- [Fix breadcrumb style broken in external_file page](gitlab-org/gitlab@2316e9dcb069aac982fba0133b41a300a4feefe3) ([merge request](gitlab-org/gitlab!143597))
- [Remove indentation logic to fix Objective child list](gitlab-org/gitlab@72e68aec2d83e5f17b599691190a8c7bfcaa4474) ([merge request](gitlab-org/gitlab!147391))
- [Adjust border radius of rounded note input](gitlab-org/gitlab@928efabcb3b056876cb6c57d5251372d7b6ab130) ([merge request](gitlab-org/gitlab!147385))
- [Project item template: Fix alignment of CI/CD Catalog badge](gitlab-org/gitlab@ed2a3f707a789699f6ee402644572f9744aef9d7) ([merge request](gitlab-org/gitlab!147416))
- [Return 401 when user sign ins but password authentication is not allowed](gitlab-org/gitlab@2fc17dcf0951ab65e7962ef1bbc3d47a5dd1b4f2) ([merge request](gitlab-org/gitlab!147343))
- [Fix autocomplete for long items](gitlab-org/gitlab@6afbbc07bbf56afed66be66b1cded2a413bed70e) ([merge request](gitlab-org/gitlab!147337))
- [Fix scheduling service statement timeout](gitlab-org/gitlab@f3611dd958710be31e1d39d723d8c07bc130f393) ([merge request](gitlab-org/gitlab!147328)) **GitLab Enterprise Edition**
- [Make the recently added not null migration no-op](gitlab-org/gitlab@9025c5e6f7f024288497f64a8f00e364ff1d96e8) ([merge request](gitlab-org/gitlab!147264))
- [Fix the deprecated_properties method](gitlab-org/gitlab@fbed1c09ebb3a46e8403e992300986f4b9dba2e7) ([merge request](gitlab-org/gitlab!147281)) **GitLab Enterprise Edition**
- [Allow reset password when password auth is partially disabled](gitlab-org/gitlab@9198967aa9291c96da56547a853f101334be87d8) ([merge request](gitlab-org/gitlab!147198))
- [Upgrade gitlab-fog-azure-rm to v1.9.1](gitlab-org/gitlab@e3a40763932e46429ce3e826356badccf654bf60) ([merge request](gitlab-org/gitlab!147219))
- [Fix commit markdown parsing with word boundaries](gitlab-org/gitlab@9fc957662b0b2692306cc66cec89cdb4abbf1074) ([merge request](gitlab-org/gitlab!147185))
- [Record unassignment notes for removed member](gitlab-org/gitlab@40f479d5fdc34e1886d6aaca2d8e0b4cfaf12286) by @euko ([merge request](gitlab-org/gitlab!146735))
- [Fix Gitlab::HTTP_V2 allowed_internal_uris https scheme](gitlab-org/gitlab@c67777cf68bae073be21610e387e458b9de08d58) ([merge request](gitlab-org/gitlab!146919))
- [Transfer group labels](gitlab-org/gitlab@4011fd1f703072aaf5e2e21573246ae0071ebcb6) by @euko ([merge request](gitlab-org/gitlab!146727))

### Changed (167 changes)

- [Place relation import endpoint behind feature flag](gitlab-org/gitlab@32fa8cc96bc1866a3a2e1be517dddc0b5bb4eeec) ([merge request](gitlab-org/gitlab!149444))
- [Add Google Artifact Registry count to Service Ping](gitlab-org/gitlab@fb05c4f181c1ddd5bed877219abb0db97612a31d) ([merge request](gitlab-org/gitlab!148414)) **GitLab Enterprise Edition**
- [Enable approval rues drawer feature flag](gitlab-org/gitlab@24c5aabcfb278469bcc956ae76f618066318272f) ([merge request](gitlab-org/gitlab!149045))
- [Not throwing error when token not present](gitlab-org/gitlab@b5d98289e3724bc9bd3f7782a7a99e2fcf90907d) ([merge request](gitlab-org/gitlab!149392))
- [Add help text for agent selector on env settings page](gitlab-org/gitlab@e949eae157b441f2593195d384359a8fee83b8e6) by @jzeng88 ([merge request](gitlab-org/gitlab!149033))
- [Improve system note messaging for assumed merges](gitlab-org/gitlab@74389c2bcd8fafb3324f1459a4b0dde111636f2c) ([merge request](gitlab-org/gitlab!148147))
- [Export for the new frameworks report (frontend)](gitlab-org/gitlab@50dd9ced39e545544a5d75f11001512c0241a7b7) ([merge request](gitlab-org/gitlab!146740)) **GitLab Enterprise Edition**
- [Redirect profile ssh keys to user settings](gitlab-org/gitlab@c1544549d186064042ebdbc5d842ece1b06c1457) ([merge request](gitlab-org/gitlab!148081)) **GitLab Enterprise Edition**
- [Fix deprecated properties method for multiple policies](gitlab-org/gitlab@1cdb8a3b5087fd46891e9c74ad232214a9521c7e) ([merge request](gitlab-org/gitlab!149264)) **GitLab Enterprise Edition**
- [Enable moving issue children by default](gitlab-org/gitlab@10fa5542b53ff7e08d95b81f8d0cf60a52f6a5c0) ([merge request](gitlab-org/gitlab!149156))
- [Redirect profile gpg keys to user settings](gitlab-org/gitlab@9870ed2063627121b5bb39760e080cb10ba585d7) ([merge request](gitlab-org/gitlab!148528))
- [Enable epic_color_highlight feature flag by default](gitlab-org/gitlab@a16fce87696a265f2ad8dcc136996eda03bbf99a) ([merge request](gitlab-org/gitlab!149147)) **GitLab Enterprise Edition**
- [Display descendant policies in compliance framework report](gitlab-org/gitlab@60f154d4d3397f29754bdfbc440e1ff8839576fb) ([merge request](gitlab-org/gitlab!149116)) **GitLab Enterprise Edition**
- [Allow relation tree restorer to import single relation](gitlab-org/gitlab@485fd4aaa0a12565e6283aeb92e8fe165e969da2) ([merge request](gitlab-org/gitlab!147904))
- [Enable analytics dashboards animations and floating panels](gitlab-org/gitlab@fa00531c81e38d1190ced75830ff1dd7cc4281f5) ([merge request](gitlab-org/gitlab!149081)) **GitLab Enterprise Edition**
- [Update feature flag modal text](gitlab-org/gitlab@2b12f90a49a2fd657f19aac06999e2727226750c) ([merge request](gitlab-org/gitlab!149261))
- [This MR updates copy for pipeline execution type](gitlab-org/gitlab@7a3d9c2f87c0238d1275d1f97279b7297ffb61d1) ([merge request](gitlab-org/gitlab!149187)) **GitLab Enterprise Edition**
- [Add pagination for the approval rules in the `Merge requests` settings](gitlab-org/gitlab@487e19f41dc759770bfcb32949a385fe5831d727) by @antonkalmykov ([merge request](gitlab-org/gitlab!148824)) **GitLab Enterprise Edition**
- [Remove orphaned indices for a namespace](gitlab-org/gitlab@831bcba18bd90a6487706032e70371102ee4305d) ([merge request](gitlab-org/gitlab!147482)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.89.0](gitlab-org/gitlab@63927f21846020d245304dc862db5f7301093804) ([merge request](gitlab-org/gitlab!149236))
- [Hide the `created_by` attribute from group/project non-admins](gitlab-org/gitlab@6acf810b4ca85ff48aba72c3e8296054abfb86a3) ([merge request](gitlab-org/gitlab!147870))
- [Limit counters on group deletion](gitlab-org/gitlab@9c060bc84c6ebfd01fb1d227e40ffb3bb20c5094) ([merge request](gitlab-org/gitlab!148575))
- [Remove Beta Labels from DuoChat Callout and Sidebar](gitlab-org/gitlab@206234fc578c9ccf64b9c452ae9064cd70aca586) ([merge request](gitlab-org/gitlab!149177)) **GitLab Enterprise Edition**
- [Add unicode_escaped_blob field](gitlab-org/gitlab@0a06e1dcb2474f866e2f335cee2d0cb3c6886db3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139090))
- [Swap pipeline columns for p_ci_builds](gitlab-org/gitlab@44449068f2b450e2cbaa8feae58f819275bdb3f5) ([merge request](gitlab-org/gitlab!146759))
- [Add info about release notes for policy rename](gitlab-org/gitlab@21782f49f506e21424294ef9ae73ad0bb3d2235a) ([merge request](gitlab-org/gitlab!148144)) **GitLab Enterprise Edition**
- [MR widget: Use secondary text style for merge train message](gitlab-org/gitlab@d79f1d4a3da2ff601038c0432a101320307d577c) ([merge request](gitlab-org/gitlab!149131)) **GitLab Enterprise Edition**
- [Snippets: Move embed and clone to actions](gitlab-org/gitlab@3d46019e187930303752f7cdec0e4ca7b9786688) ([merge request](gitlab-org/gitlab!147996))
- [MR list: Show self approval](gitlab-org/gitlab@eec8884f56aa7276e391c24d8e67c8ec457a001c) ([merge request](gitlab-org/gitlab!149092))
- [Update design of the pipeline graph](gitlab-org/gitlab@8a05ff09c54f5a840816308468fab1046be712ea) ([merge request](gitlab-org/gitlab!149068))
- [Pipeline overview page: Migrate dropdown to GlDisclosureDropdown](gitlab-org/gitlab@a45e646fe225ee4a9cbb6ae0546d614803dac5fd) ([merge request](gitlab-org/gitlab!147273))
- [Reduce sbom_occurrences table writes](gitlab-org/gitlab@f1e0086cfba47720fd5a07ea38c9a9c9640b4da5) ([merge request](gitlab-org/gitlab!148868)) **GitLab Enterprise Edition**
- [Added information to product analytics docs](gitlab-org/gitlab@6e8750493f2418655d88f21d778a95529326aab3) ([merge request](gitlab-org/gitlab!148601)) **GitLab Enterprise Edition**
- [Add the container to the cadence validation ff check](gitlab-org/gitlab@47ae7f5dce7b4bcf3cf91bd89c026ad697eab088) ([merge request](gitlab-org/gitlab!148892)) **GitLab Enterprise Edition**
- [Fix project overview bugs](gitlab-org/gitlab@cabb403855e5ae6a8d4f1f700a7425376a24b7a4) ([merge request](gitlab-org/gitlab!148953))
- [Allow relation tree restorer to import single relation](gitlab-org/gitlab@ff17628fb19918ed0cf774fd5f48ab55101b740c) ([merge request](gitlab-org/gitlab!147913))
- [Remove `scan_result_policies_block_unprotecting_branches` feature flag](gitlab-org/gitlab@9056627110b4ac647b32ddf6810f20c4b7333855) ([merge request](gitlab-org/gitlab!148549)) **GitLab Enterprise Edition**
- [Left-align activity timestamps on mobile](gitlab-org/gitlab@30c223251024930c15fad63342595d8b8e3c35b9) ([merge request](gitlab-org/gitlab!148711))
- [Remove the need for SaaS to configure Product Analytics](gitlab-org/gitlab@85eb339cec332c1392d753fd789bd937d70388c7) ([merge request](gitlab-org/gitlab!147833))
- [Add action menu to milestone row on milestones page](gitlab-org/gitlab@d9895d13de20db638e261cac294152df83b98341) ([merge request](gitlab-org/gitlab!148219))
- [Move viewed file tooltip to the left; only show on hover](gitlab-org/gitlab@11105fe52389dfb17a10e39ea4b7b4995c5ee440) ([merge request](gitlab-org/gitlab!148558))
- [Capture running builds on non-shared runners](gitlab-org/gitlab@d299c78fa96ee76d16a95524cf04cf5f8bc0c708) ([merge request](gitlab-org/gitlab!147943))
- [Update epics foreign key on parent_id to nullify on delete](gitlab-org/gitlab@c6e4f7e2c0add5e048a32bd73e5113387add0ff5) ([merge request](gitlab-org/gitlab!148522))
- [Merge request list: Improve approvals](gitlab-org/gitlab@443aab39ec9ac0a79299b6947cda09d9194d594b) ([merge request](gitlab-org/gitlab!148364))
- [Add metadata database alert to registry pages in the UI](gitlab-org/gitlab@062eea6b2627d81ff3f8fb2ef36178f0e45d68bc) ([merge request](gitlab-org/gitlab!147503))
- [Enable `security_policies_unassign_redundant_policy_projects` FF](gitlab-org/gitlab@3c0bbcf05586a51dded19fe27d396ded619be706) ([merge request](gitlab-org/gitlab!148741)) **GitLab Enterprise Edition**
- [Add a `personal` argument to `Query.projects`](gitlab-org/gitlab@2ae86907e57e69350029b9cd11f5219172542355) by @yasuk ([merge request](gitlab-org/gitlab!148393))
- [Combine snippet embed and clone buttons into single code dropdown](gitlab-org/gitlab@4b8561afa2018da16348d43eb277cad8953b437b) ([merge request](gitlab-org/gitlab!147719))
- [Drop workhorse_google_client feature flag](gitlab-org/gitlab@2715b0369da54560ccdc51f524f3187228620713) ([merge request](gitlab-org/gitlab!148755))
- [Update text in deployment approval modal](gitlab-org/gitlab@5951bfd01255d5d0b9b1370317830cde22230238) ([merge request](gitlab-org/gitlab!148588)) **GitLab Enterprise Edition**
- [Distribute scheduled pipelines from Scan Execution Policy](gitlab-org/gitlab@7c1cac1a853639ab9a047f2d44ac39befe117ae1) ([merge request](gitlab-org/gitlab!145993)) **GitLab Enterprise Edition**
- [Update DevOps Reports illustrations](gitlab-org/gitlab@bfb5623d0b7ac5860f94c786c46cba71d6748fc0) ([merge request](gitlab-org/gitlab!148530)) **GitLab Enterprise Edition**
- [Update DevOps Adoption empty state illustration](gitlab-org/gitlab@f5df939dbb72e467918ea00eab9a269840c510ca) ([merge request](gitlab-org/gitlab!148546)) **GitLab Enterprise Edition**
- [Update ES shard size rake task and guidelines](gitlab-org/gitlab@9f48a818e5c0724bc5201c20ad68b7ad77e2cadb) ([merge request](gitlab-org/gitlab!146108)) **GitLab Enterprise Edition**
- [Update release empty state illustration](gitlab-org/gitlab@ab374d34bb7948dca1da5023ef301b8b2b8627de) ([merge request](gitlab-org/gitlab!148526))
- [Add sales call to action when onboarding without purchase](gitlab-org/gitlab@7355dafcd25f41bea162fec4c3ee0dfe8ac4daf4) ([merge request](gitlab-org/gitlab!148439)) **GitLab Enterprise Edition**
- [Moves ml_experiment_tracking to group::mlops](gitlab-org/gitlab@a398f1a46638db397f1772498e9f5026a3b85339) ([merge request](gitlab-org/gitlab!148533))
- [Truncate individual names](gitlab-org/gitlab@804f6efec7ef7c89405026f9a51c7c5d0e04e343) ([merge request](gitlab-org/gitlab!144369))
- [Replace GlAvatar with ProjectAvatar in GroupItems](gitlab-org/gitlab@7bcb4defeab1ac52da0e58d8256e8b9d5027668a) by @espadav8 ([merge request](gitlab-org/gitlab!148464))
- [Adjust default_enabled to true for wiki_content_background_job flag](gitlab-org/gitlab@672d92d44977ef0c1e8eaae7ecb85629f743e79a) by @ivantedja ([merge request](gitlab-org/gitlab!148616))
- [Remove sub-header background from Compare revisions form](gitlab-org/gitlab@bbcf8f8cb4c63cfa0f4472edec747dfae0420ac2) by @espadav8 ([merge request](gitlab-org/gitlab!148614))
- [Search iterations in descending order](gitlab-org/gitlab@17b0039b731cf31a7046720ecfe5d788b3fa070d) ([merge request](gitlab-org/gitlab!148465)) **GitLab Enterprise Edition**
- [Allow admins to disable runner registration token](gitlab-org/gitlab@7e4b4f7d0375b4d8a53ceb2705bc8280b3aae999) ([merge request](gitlab-org/gitlab!147559))
- [Update issue filter search illustration](gitlab-org/gitlab@a23f546fc0c705257782abdac946b64451e8fa03) ([merge request](gitlab-org/gitlab!148521))
- [Trigger search file modal when searching](gitlab-org/gitlab@d421d9cb81acaf422ecb04468450d23c03be74aa) ([merge request](gitlab-org/gitlab!148025))
- [Cleanup web_ide_settings_sync feature flag](gitlab-org/gitlab@512cf3f80903e3288400ca93b71a73012299b32c) ([merge request](gitlab-org/gitlab!148365))
- [Update color and spacing of releases page](gitlab-org/gitlab@09fc52c7762f812780bb35269be5de844e14a06e) ([merge request](gitlab-org/gitlab!148474))
- [Make merge conflict file stand out more](gitlab-org/gitlab@fae96877f76f666ba5c33552f22a28c2b9804eef) ([merge request](gitlab-org/gitlab!147654))
- [Update the cadence documentation for sep](gitlab-org/gitlab@2605c360256f47423ba2975003307dfa85a330ce) ([merge request](gitlab-org/gitlab!148109))
- [Add alphabetical sort for branch names](gitlab-org/gitlab@4a0c51d52c0ff087c553328034c11b0c7b0d7060) by @gauravmarwal ([merge request](gitlab-org/gitlab!147034))
- [Enable product_analytics_beta_option by default](gitlab-org/gitlab@3122e16371dc4e2e9330698d87f94cd6b5323add) ([merge request](gitlab-org/gitlab!148422))
- [Make product_analytics_dashboards default enabled](gitlab-org/gitlab@104c9d4aef2c258181c15287589c8d4983be4637) ([merge request](gitlab-org/gitlab!148381))
- [Add a validation to the scan execution policy cadence](gitlab-org/gitlab@3a3160b708ae1e67ef4a5ea738e447e9fc5b09d1) ([merge request](gitlab-org/gitlab!147576)) **GitLab Enterprise Edition**
- [Update MR changes empty state](gitlab-org/gitlab@d19cd4d747086f4677358fa7ea05484f659535fd) ([merge request](gitlab-org/gitlab!148051))
- [Adds logo to MattermostSlashCommands](gitlab-org/gitlab@558a96afcba39e3d57af296cea1ec4d714adb4e3) ([merge request](gitlab-org/gitlab!148373))
- [Update analytics dashboard observability](gitlab-org/gitlab@0f0627036905f892fe8b0cbb2afe459813ecbeb4) ([merge request](gitlab-org/gitlab!147163)) **GitLab Enterprise Edition**
- [Keep compliance frameworks for project transfers](gitlab-org/gitlab@b81b52b2c67664dd1dc941ab0e431d59d7869288) ([merge request](gitlab-org/gitlab!148142)) **GitLab Enterprise Edition**
- [This MR adds scope column to policies list](gitlab-org/gitlab@9d50f342072abdfe87a44b80c8eb5ef9662c118e) ([merge request](gitlab-org/gitlab!145047)) **GitLab Enterprise Edition**
- [Refactor BulkIndexer to able to handle other document references](gitlab-org/gitlab@2da4b1ca443ede7a42ecafbafbf1d37e9b6cfd45) ([merge request](gitlab-org/gitlab!146491)) **GitLab Enterprise Edition**
- [Add Mattermost logo](gitlab-org/gitlab@f3bd984876b13ea6328327f36314167cef9c0051) ([merge request](gitlab-org/gitlab!147893))
- [Blocks unprovisioned access to product analytics apis](gitlab-org/gitlab@f58377548fa9370b80861dcf52d3ec48fbf8d484) ([merge request](gitlab-org/gitlab!147841)) **GitLab Enterprise Edition**
- [Add empty state for sidebar CRM widget](gitlab-org/gitlab@b764d0da8be493cfd4ff961b659fc982e827f55e) ([merge request](gitlab-org/gitlab!147694))
- [Snippets delete modal improvements](gitlab-org/gitlab@0898b4148bc60063d3785eb2273247d67b6689c8) ([merge request](gitlab-org/gitlab!148044))
- [This MR adds branch exceptions selector](gitlab-org/gitlab@2c9b4b8a89f12fe9bb6a6f1f0053cedde65dbe6c) ([merge request](gitlab-org/gitlab!141650)) **GitLab Enterprise Edition**
- [Move Google Cloud instructions to reduce duplication](gitlab-org/gitlab@9ac8d4aa4d79650640828f28e46b5e721ae5a9a1) ([merge request](gitlab-org/gitlab!148190))
- [Adding alert for duo pro trials for existing users](gitlab-org/gitlab@f43b7f57087aaf6b9e2bbd94aeb057e5c494e9bd) ([merge request](gitlab-org/gitlab!148012)) **GitLab Enterprise Edition**
- [Deprecate security_auto_fix from graphql type](gitlab-org/gitlab@a69eb00b15bf14aae02ae885c9aefcee38cd5e9f) ([merge request](gitlab-org/gitlab!147157))
- [Show package processing error message returned from API](gitlab-org/gitlab@03da4ea38f9d5acec50d9499c9e27193b70d3810) ([merge request](gitlab-org/gitlab!147026))
- [Add columns for require_reauthentication_to_approve](gitlab-org/gitlab@24c9690f099da9fead2a364b87aef39cc08fc851) ([merge request](gitlab-org/gitlab!146374))
- [MR more actions dropdown: Improve alignment on small viewports](gitlab-org/gitlab@e8950e4bc438552fa65da59ed6b22d08bb30423d) ([merge request](gitlab-org/gitlab!148000))
- [Issuables: Improve more actions on smaller devices](gitlab-org/gitlab@1cbafae293a2d030eca6b5c36119d070e849c04b) ([merge request](gitlab-org/gitlab!147999))
- [Update CreateIssueForm to support Japanese IME](gitlab-org/gitlab@b1a1cf97ed248a5d20e926b7e629aff1ccb489e0) ([merge request](gitlab-org/gitlab!147814)) **GitLab Enterprise Edition**
- [Snippets page: Adjust header elements to match issuables](gitlab-org/gitlab@228280f9ef67c19f739f5113367457c2cfdc6419) ([merge request](gitlab-org/gitlab!147451))
- [Change button text from "Create/add new role" to "Create role"](gitlab-org/gitlab@da8245685deb6715a760d2c7dcc43cb1d123b86e) ([merge request](gitlab-org/gitlab!147507)) **GitLab Enterprise Edition**
- [Collapse sidebar on ESC key if in overlay mode](gitlab-org/gitlab@fdc93c8c76210fb393cd469fbc2223a9f76ca12d) ([merge request](gitlab-org/gitlab!147001))
- [Stop calling the migration's workers and update them to no-op](gitlab-org/gitlab@511b7db63830f0370845f950816c90b6d45d69fe) ([merge request](gitlab-org/gitlab!147228))
- [Unify the more actions kebab menu tooltip behavior](gitlab-org/gitlab@aa4126f55207d6849c97ffce972fd4a7ad840b32) ([merge request](gitlab-org/gitlab!147540))
- [Snippets page: Migrates dropdown to GlDisclosureDropdown](gitlab-org/gitlab@c475073d10e440e33bf4929ec911201eecd4336a) ([merge request](gitlab-org/gitlab!147518))
- [Update dependency auto-deploy-image to v2.88.0](gitlab-org/gitlab@a69a8c5cfba9d2949d266f358a772c008dbf4ec3) ([merge request](gitlab-org/gitlab!147935))
- [Improve UX feedback when project deploy feature flags limit is reached](gitlab-org/gitlab@584c89afc0260ae41f48a6b96f91c7e0931b75af) by @antonkalmykov ([merge request](gitlab-org/gitlab!147446))
- [Add provider selection in product analytics onboarding](gitlab-org/gitlab@1940cd0405f1cb0f9747f3f25c8cfeb1c889dd21) ([merge request](gitlab-org/gitlab!145880)) **GitLab Enterprise Edition**
- [Add descendant filter to security policies graphql query](gitlab-org/gitlab@15ac762e945f3e1488c059eb57302139bba077f0) ([merge request](gitlab-org/gitlab!145825)) **GitLab Enterprise Edition**
- [Clarify supported signed commits types](gitlab-org/gitlab@d9d9f2115fdb93ced6c7713da36cb2c4a11328ab) ([merge request](gitlab-org/gitlab!147556)) **GitLab Enterprise Edition**
- [Edit branch rule name](gitlab-org/gitlab@2ac027412c70a4a76c037c7d06518155a32d5eb3) ([merge request](gitlab-org/gitlab!147308))
- [Improve license matching when evaluating policies](gitlab-org/gitlab@40c4f39deecdb36b7ffa2dd49981b1c10a11b926) ([merge request](gitlab-org/gitlab!147598)) **GitLab Enterprise Edition**
- [Update project and group transfer modal text](gitlab-org/gitlab@c2515558105c95c1220b41a500ec422eb4f8e441) ([merge request](gitlab-org/gitlab!146938))
- [Updated gitlab-ui and refactored duo chat](gitlab-org/gitlab@0e4cea3574e69fe33f2c546d16ad2712666d9006) ([merge request](gitlab-org/gitlab!147802)) **GitLab Enterprise Edition**
- [This MR adds policy scope to a drawer](gitlab-org/gitlab@9ae60e3cf90df6e51e89325d36e6684fcd2428be) ([merge request](gitlab-org/gitlab!145567)) **GitLab Enterprise Edition**
- [Add empty state for discussion in sidebar](gitlab-org/gitlab@5a172ca1a1db009c5d50bc4b3ca8148aca8ee837) ([merge request](gitlab-org/gitlab!147642))
- [Remove namespace alias from DORA performance counts](gitlab-org/gitlab@a6287c22842e298fd8865016112f4e40dbb54c3d) by @jzeng88 ([merge request](gitlab-org/gitlab!147400)) **GitLab Enterprise Edition**
- [Update importers to use application settings to limit number of jobs](gitlab-org/gitlab@3254590fd2105fcd995f0ccb5e0b3e214c9a59c6) ([merge request](gitlab-org/gitlab!143875))
- [Add placeholder and validation for linkedin profile input](gitlab-org/gitlab@0381be4712ae81e508abe78b292c6fc1fabef6b1) ([merge request](gitlab-org/gitlab!147288))
- [Set AddOnPurchase trail value in CreateService](gitlab-org/gitlab@13174ab1ce2ee8a94cee7b3b8cfba5ee0b4ab221) ([merge request](gitlab-org/gitlab!147764)) **GitLab Enterprise Edition**
- [Use static_holmes instead of charlock_holmes](gitlab-org/gitlab@4f5136b7735810d03ce9aa20b5257ccec446808a) ([merge request](gitlab-org/gitlab!147721))
- [Make consistent padding in the package asset table row](gitlab-org/gitlab@925520fe0473c090a78cdc89baee0c41176a62cc) by @antonkalmykov ([merge request](gitlab-org/gitlab!147211))
- [Add groups_direct field in JWT for Vault integration](gitlab-org/gitlab@3b628813eff7ddd1ef085708e2fb63df3536d899) by @alexandru.jieanu ([merge request](gitlab-org/gitlab!146881))
- [Export for the new frameworks report (backend)](gitlab-org/gitlab@3bac11cb79bf24c72b15082fe484a06edc411936) ([merge request](gitlab-org/gitlab!144815)) **GitLab Enterprise Edition**
- [This MR changes key name for license rule](gitlab-org/gitlab@9a8e4548524fe903b5b988e1e0aba048d3a0a535) ([merge request](gitlab-org/gitlab!147184)) **GitLab Enterprise Edition**
- [Well segment: Change border color to default gray-100](gitlab-org/gitlab@8fa2fbf74694b5932162f222cb3409baaf4b4b2c) ([merge request](gitlab-org/gitlab!147674))
- [Reorganization project overview page](gitlab-org/gitlab@f0af2950542c1329cafa13342cf6b86bde3f2d03) ([merge request](gitlab-org/gitlab!145678))
- [Fix formatting of issue summaries](gitlab-org/gitlab@8622a816cd7cfc298cce6e28d79525dbf80de204) ([merge request](gitlab-org/gitlab!147466)) **GitLab Enterprise Edition**
- [Use textarea for collapsed snippet description](gitlab-org/gitlab@e637e32fb073ff0cd16a7f4f6d472ffa02415845) ([merge request](gitlab-org/gitlab!147585))
- [Disable file path input until project is selected](gitlab-org/gitlab@8fe848cbafaf0b786efffa28a2b4c5814fdcf652) ([merge request](gitlab-org/gitlab!147307))
- [Fix and refactor snippets list view](gitlab-org/gitlab@ee9bb496ca85487ded7e6599c608bc596cc39b1b) ([merge request](gitlab-org/gitlab!147580))
- [Update markdown styles for quoted lists](gitlab-org/gitlab@58ad2dbb905877f7d1934798c6e630c50722ef6f) ([merge request](gitlab-org/gitlab!147646))
- [Upgrade Elasticsearch version to 8.11.4](gitlab-org/gitlab@04103822e6731f1f69d806f5e0378425472b3231) ([merge request](gitlab-org/gitlab!147527))
- [Hide invited group name and source from project/group non-admins](gitlab-org/gitlab@a984f85ae821842538743d453fd3c26c79b2a636) ([merge request](gitlab-org/gitlab!147629))
- [Show Duo Pro button for ultimate trial](gitlab-org/gitlab@1a126e4bbf21e6056919d0d9e35302971025e22d) ([merge request](gitlab-org/gitlab!147548)) **GitLab Enterprise Edition**
- [Remove claude 2.1 feature flag](gitlab-org/gitlab@04c4cec133da5f095ddccc6b80304f01fd55bc58) ([merge request](gitlab-org/gitlab!147253))
- [Delete redundant policy configurations on assignment](gitlab-org/gitlab@bd8219a5ff8924b192e830bd0d9b0828f16d749c) ([merge request](gitlab-org/gitlab!143668)) **GitLab Enterprise Edition**
- [Add $gl-padding  margin bottom to <summary> in open <details>](gitlab-org/gitlab@32c118ce721f62f18cafea19fa615e1e3cb51dbd) ([merge request](gitlab-org/gitlab!147492))
- [Remove CI_COMPONENT_FQDN variable](gitlab-org/gitlab@c5497cf4aa3287d5cd2d817db2e8b09e07f03c0c) ([merge request](gitlab-org/gitlab!146797))
- [Updates model registry table docs with correct schema](gitlab-org/gitlab@aa3c9018fb4dbd623fc8cdbcb55a5a791d45d250) ([merge request](gitlab-org/gitlab!146898))
- [Migrate button-class-vue in todo.vue](gitlab-org/gitlab@69ef496e2898633f7884b94f160f5553450bd3e1) ([merge request](gitlab-org/gitlab!147203))
- [Cleanup snippets edit page](gitlab-org/gitlab@fe21c3ef651f3d5d508d1d179ed2f1a02d5997c9) ([merge request](gitlab-org/gitlab!147442))
- [Update deprecation milestone for job token setting](gitlab-org/gitlab@6097ab4273c38d2b7625e79107940e282108c90c) ([merge request](gitlab-org/gitlab!147320))
- [Change username validation message](gitlab-org/gitlab@cbafeab9d89686143a214b0f632b322eb0274ae6) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147213)) **GitLab Enterprise Edition**
- [Backport Work Item copy changes to legacy issuables](gitlab-org/gitlab@ca1533961fe1ff8a841ebb1e36f4ea3b6638b079) ([merge request](gitlab-org/gitlab!147369))
- [Updating tab title](gitlab-org/gitlab@f1d14b00ecadcc50cadb3024ff9640d5d21a7af9) ([merge request](gitlab-org/gitlab!147094))
- [Display project and subgroup counters when deleting group](gitlab-org/gitlab@1b001708ad7aacdee9c7f537ceacf314ed7c315d) ([merge request](gitlab-org/gitlab!145838))
- [Issuables: Mark destructive action (delete) as such](gitlab-org/gitlab@8f64896cfa3c2b55442762864d90b9cf56111b8a) ([merge request](gitlab-org/gitlab!147441))
- [Migrates user access badge to use GlBadge](gitlab-org/gitlab@0afdd01a0e777d74960ca04349bf1ba01ce0c03b) ([merge request](gitlab-org/gitlab!147437))
- [Add logging for JWT errors](gitlab-org/gitlab@bbad75c4d5811a645fca9a71b70b637820da729b) ([merge request](gitlab-org/gitlab!147234))
- [Add thread count and remove participants from sidebar](gitlab-org/gitlab@80ea76d941891c82d7239ed2996f7d2db9aff364) ([merge request](gitlab-org/gitlab!146037))
- [User profile: Hide sidebar if user is blocked](gitlab-org/gitlab@366b3ce92586831e4ea910ac960332c4ae403649) ([merge request](gitlab-org/gitlab!147354))
- [Improved CI YAML schema tests](gitlab-org/gitlab@097f279544068ada7441e865b1f5819ff1b97b8e) by @zillemarco ([merge request](gitlab-org/gitlab!139716))
- [Fix runner form headings to match Pajamas](gitlab-org/gitlab@be576ce1ed8e7b68eff6563d1571bd8c29957b36) ([merge request](gitlab-org/gitlab!146383))
- [Display created and finshed pipeline times](gitlab-org/gitlab@d0c74ae64c7a80223183186099ec6efd6a2fbb21) ([merge request](gitlab-org/gitlab!147060))
- [Use standardized panel errors for Value stream dashboard](gitlab-org/gitlab@86a9a9194dd2a61263440f31441c177ad3e3990a) ([merge request](gitlab-org/gitlab!147287)) **GitLab Enterprise Edition**
- [Add tooltip to snippet visibility icon](gitlab-org/gitlab@442bba2c81e87e6126a1fd74133194494a4dbfa4) ([merge request](gitlab-org/gitlab!147295))
- [Migrates code dropdown to Vue](gitlab-org/gitlab@60a1a8f38183f774e12fbc7d3a265bae05a6e62f) ([merge request](gitlab-org/gitlab!146633))
- [Cleaned up code_suggestions_ga_owner_alert feature flag](gitlab-org/gitlab@032cc3a042653d306ab8636d5dea204145073e43) ([merge request](gitlab-org/gitlab!146322)) **GitLab Enterprise Edition**
- [Improve loading states of sidebar items](gitlab-org/gitlab@beef7d7944736f4401c48eea519c27c5cae137e8) ([merge request](gitlab-org/gitlab!147330))
- [Log if pipeline creation limit might be exceeded](gitlab-org/gitlab@c1e13cf9138c4dc3ecd117739bedf1f6cda00385) ([merge request](gitlab-org/gitlab!147306))
- [Show deployment count](gitlab-org/gitlab@a5ca23c5cf5b6d515865c1c5051d3cf92b49dfcb) ([merge request](gitlab-org/gitlab!147280))
- [Refactor enterprise_user trait into factory](gitlab-org/gitlab@a18dd07b682299c653d63f44d30cc238441974f0) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145626)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.87.0](gitlab-org/gitlab@aa08f973bcfcaa3f61cc0aa632d3698c0a8f3751) ([merge request](gitlab-org/gitlab!147272))
- [Change username text color to use same across UI](gitlab-org/gitlab@18f99db2f182da23df0e4c31903159eb14e1db7c) ([merge request](gitlab-org/gitlab!147260))
- [Remove feature flag fetch_tags_from_registry_api](gitlab-org/gitlab@0e2677a0f6be7b37324b4db1a6fdcc39bd8eb1da) ([merge request](gitlab-org/gitlab!147233))
- [Remove api: API::Internal::ContainerRegistry::Migration](gitlab-org/gitlab@00886957027172084f211dff4d6a18ab0271b68e) ([merge request](gitlab-org/gitlab!147229))
- [Do not expand CI predefined `TRIGGER_PAYLOAD` variable](gitlab-org/gitlab@e91bece35975a4f2e5e0da30eec651a125d76da6) by @vytautasbert ([merge request](gitlab-org/gitlab!146242))
- [Block compliance fraework removal when there are linked policies](gitlab-org/gitlab@e417b94198995f065763e1d80e7d62da381417db) ([merge request](gitlab-org/gitlab!147041)) **GitLab Enterprise Edition**
- [Raise atom feed title length limit to 160 characters](gitlab-org/gitlab@fbddd8ad18df8794627ebb20279ac3315bbc5f72) by @kxxt ([merge request](gitlab-org/gitlab!145730))
- [Fix pagination issue on adherences report](gitlab-org/gitlab@7d8bf7fe05c5bf658ada58ff15408396db3dd653) ([merge request](gitlab-org/gitlab!147022)) **GitLab Enterprise Edition**
- [Trim further file content for code suggestions](gitlab-org/gitlab@abbfb78f8ec921a4cde20340e79d03da1e1cbe17) ([merge request](gitlab-org/gitlab!146977)) **GitLab Enterprise Edition**
- [Update milestone icon](gitlab-org/gitlab@0ef8adbdf7769f36c4747a3d3e9069a001bd14ff) ([merge request](gitlab-org/gitlab!146828)) **GitLab Enterprise Edition**
- [Reject project CI jobs on reserved policy stages](gitlab-org/gitlab@82a6d2066bbc73c5ee41be5ca630bd4101ec0ed4) ([merge request](gitlab-org/gitlab!146307)) **GitLab Enterprise Edition**

### Deprecated (1 change)

- [Deprecate GITLAB_SHARED_RUNNERS_REGISTRATION_TOKEN](gitlab-org/gitlab@b35c2cc49458a06c641f150802faa3604ae98cc4) ([merge request](gitlab-org/gitlab!148310))

### Removed (19 changes)

- [Remove about section](gitlab-org/gitlab@62fbee1ba9a04453909b25e24f4f7e5db0694d74) ([merge request](gitlab-org/gitlab!147948))
- [Remove CH analytics related feature flags](gitlab-org/gitlab@7f85033ebb8d6b46203a94626e2cab7cc145824e) ([merge request](gitlab-org/gitlab!148651)) **GitLab Enterprise Edition**
- [Remove modify_auto_fix_setting](gitlab-org/gitlab@67de5f0af68d99b3104e25004b9bb2930a89dc55) ([merge request](gitlab-org/gitlab!149286))
- [Remove beta badge](gitlab-org/gitlab@5cab24cfce096bb3203a8ffa1285ff11582fa353) ([merge request](gitlab-org/gitlab!149018))
- [Clean up default_to_import_tab experiment](gitlab-org/gitlab@163a262210660a0ce2328f9976e20ca46ebce1f7) ([merge request](gitlab-org/gitlab!149130))
- [Remove ff and policy information related to](gitlab-org/gitlab@00a8ca95ce9890bd44a2e077728f83550e5bc805) ([merge request](gitlab-org/gitlab!147202))
- [Remove the backend changes for automatic diff summary](gitlab-org/gitlab@397e3d8c6e6177b10b62d5507177ac2edb8e0155) ([merge request](gitlab-org/gitlab!148122))
- [Remove ignore column rule from GeoNodeStatus](gitlab-org/gitlab@9bc24bb9d4a09ff63bc9d31af8a353f93b87d1b2) ([merge request](gitlab-org/gitlab!148335)) **GitLab Enterprise Edition**
- [Remove runner registration compatibility alert](gitlab-org/gitlab@5213b04f44787bf348ed19e94ef2f38b50eb7785) ([merge request](gitlab-org/gitlab!148152))
- [refactor: Drop col 'package_name_pattern_ilike_query' Part 3](gitlab-org/gitlab@afc688f79144701a6f0c215c2f96fbd850f7aefc) by @gerardo-navarro ([merge request](gitlab-org/gitlab!142305))
- [Remove CI text interpolation code](gitlab-org/gitlab@96f86196a6571c751433fd7eda099446ce9a4ece) ([merge request](gitlab-org/gitlab!147803))
- [Clean up auto_fix related action and services](gitlab-org/gitlab@b8898d459cec9ae3122e698d446738b7f44ed200) ([merge request](gitlab-org/gitlab!147161)) **GitLab Enterprise Edition**
- [Remove final mentions of Ai::SyncServiceTokenWorker](gitlab-org/gitlab@f0a6080f0dd86678283a0e15c24bc6c2f24d44c7) ([merge request](gitlab-org/gitlab!147452)) **GitLab Enterprise Edition**
- [Remove github_import_extended_events feature flag](gitlab-org/gitlab@6052e8d7e8973b20a27a3575f732b4f04d02628a) ([merge request](gitlab-org/gitlab!146695))
- [CI/CD Catalog experiment badge](gitlab-org/gitlab@e249ed0e906fdc5d029a1db6b0ef38ca5baa8e1b) ([merge request](gitlab-org/gitlab!147630))
- [Remove CH materialized view rebuilding FFs](gitlab-org/gitlab@e593b34b6a5aa9e00be73d40cffd42cdb257dda7) ([merge request](gitlab-org/gitlab!146592))
- [Remove latest_version from Ci::Catalog::ResourceType](gitlab-org/gitlab@917b922b5f351a748e72fb00a49b6cf2d84b71c0) ([merge request](gitlab-org/gitlab!146913))
- [Remove frontend code for security_auto_fix with](gitlab-org/gitlab@f4d3dd1222a472ae144a87eed37462d1284de5bb) ([merge request](gitlab-org/gitlab!147078)) **GitLab Enterprise Edition**
- [Remove ignore column](gitlab-org/gitlab@fe8ca866391350852803c8b6670a9c0de18cd09f) by @imskr ([merge request](gitlab-org/gitlab!147250))

### Security (7 changes)

- [Fix stored xss using the gollum filter](gitlab-org/gitlab@8240472c85efd51938ad064ab5cc4a39e374d0c8) ([merge request](gitlab-org/gitlab!149158))
- [Update Gitlab::Regex::Packages#slack_link_regex](gitlab-org/gitlab@ea5f384a4e51d16b1fe00ba9233abc09fb2b92d6) ([merge request](gitlab-org/gitlab!149158))
- [Fix XSS in autocomplete in rich text editor](gitlab-org/gitlab@d3ca8e6cc9cc98a48d53d7f968cd922ded0d74f8) ([merge request](gitlab-org/gitlab!149158))
- [Correctly parse attachments for junit result](gitlab-org/gitlab@9a0357ac244a3c7282d73864d5792d1aff3f48dd) ([merge request](gitlab-org/gitlab!149158))
- [Fix stored xss in wikis using the abstract_reference_filter](gitlab-org/gitlab@4ba8bee6bb39fb830c592c57d5d4595411c8a9ad)
- [Limit the number of emojis we will transform](gitlab-org/gitlab@ce5a24e34504c1f4b4408c83ebb801a055809bea)
- [Remove `unsafe-inline` from CSP](gitlab-org/gitlab@a7a302b7484d972fa85e2003a799349c541077b4) ([merge request](gitlab-org/gitlab!147268))

### Performance (8 changes)

- [Preload `vulnerability_reads` for vulnerability records](gitlab-org/gitlab@a36e652efbb76203555cc3b5afd72d225eb5b047) ([merge request](gitlab-org/gitlab!149304)) **GitLab Enterprise Edition**
- [Preload releases for Tags API](gitlab-org/gitlab@5a78293c8227686315b62b1f429f7b6669b9f24f) ([merge request](gitlab-org/gitlab!140484))
- [Added index for member_approval on member_namespace_id and status](gitlab-org/gitlab@7377e5a0e2dac6b06feddd21bafa197a22cdd182) ([merge request](gitlab-org/gitlab!149044))
- [Release skipping copy operation in generic packages upload](gitlab-org/gitlab@3e0dd0a3cafab219b5e7aa2d23995433db470fe3) ([merge request](gitlab-org/gitlab!148947))
- [Enable and remove the FF ci_rule_exists_extension_optimization](gitlab-org/gitlab@ccdac7fcf341030e2d3cdeaa2aad1c54cd2fb2c7) ([merge request](gitlab-org/gitlab!148682))
- [Avoid duplicated keys in ProtectedBranches cache](gitlab-org/gitlab@75183a5901df5b550879a78ba04a15470f1c01a7) ([merge request](gitlab-org/gitlab!148172))
- [Use replica DB to read ContainerRepository requiring_cleanup ids](gitlab-org/gitlab@5b757f6da9638f94570c8a5f4ef464f329d1637f) ([merge request](gitlab-org/gitlab!147074))
- [Optimize performance of ambiguous ref detection](gitlab-org/gitlab@e38ec0f827400093797c9608d2d9a86931c4c531) ([merge request](gitlab-org/gitlab!147557))

### Other (113 changes)

- [Removed Tanukibot from Translations](gitlab-org/gitlab@a2c915e9cc23c1767618404fc13c4f01ce75ceb3) by @NIKU-SINGH ([merge request](gitlab-org/gitlab!149328)) **GitLab Enterprise Edition**
- [Drop a partial index we no longer need](gitlab-org/gitlab@ce5d50df74794888b895388028da95c07f0b135f) ([merge request](gitlab-org/gitlab!149218))
- [Add relaxed sharding keys for groups_and_projects](gitlab-org/gitlab@7d37ac964b121056ef24c01cf03b9f89fcd2e9ae) ([merge request](gitlab-org/gitlab!149299))
- [Update artifact_state to include partition_id filter for job_artifacts](gitlab-org/gitlab@d370ffc255670587ba9091ba9bfc4841d5cdfc80) ([merge request](gitlab-org/gitlab!146305))
- [Remove identity_verification feature flag](gitlab-org/gitlab@be6f616110a4a36515ade286d91abe773a6d1902) ([merge request](gitlab-org/gitlab!148888))
- [Enable save_policy_violation_data by default](gitlab-org/gitlab@557fffb41124987e98cc62c1eb572235ba4d050c) ([merge request](gitlab-org/gitlab!149388)) **GitLab Enterprise Edition**
- [Add relaxed sharding keys for source_code_management](gitlab-org/gitlab@7e8e7d61321969a5c5f14cbd6eb921bcff8099dd) ([merge request](gitlab-org/gitlab!148951))
- [Add relaxed sharding keys for continuous_delivery](gitlab-org/gitlab@d087a3dfd833081f3270473cd4584912ea70fbea) ([merge request](gitlab-org/gitlab!149294))
- [Add Sidekiq shard-support for active jobs](gitlab-org/gitlab@cf10df05928636cca210560cafeb34428fb24348) ([merge request](gitlab-org/gitlab!148637))
- [Update status of namespace in URL path to Beta from Experiment](gitlab-org/gitlab@0f30d0144634ee1a65435d1d697340c1fbc0ee8b) ([merge request](gitlab-org/gitlab!148621))
- [Add relaxed sharding keys for vulnerability_management](gitlab-org/gitlab@7324229b273d51b04e2da297247fb4d38aa58b1e) ([merge request](gitlab-org/gitlab!149297))
- [Add relaxed sharding keys for devops_reports](gitlab-org/gitlab@cc6cb9bd1b9b2ff48cdababaa5d9b6ae6d781e5d) ([merge request](gitlab-org/gitlab!149298))
- [Add relaxed sharding keys for importers](gitlab-org/gitlab@cd15a5948cf911d3bcfa2c45cffc515f8a774546) ([merge request](gitlab-org/gitlab!149295))
- [Quarantine a flaky test](gitlab-org/gitlab@8577724795dad8de0558c351c0f45718f2dfab18) ([merge request](gitlab-org/gitlab!149287))
- [Quarantine a flaky test](gitlab-org/gitlab@5136480176a92b5afc9e88d26fad2cbd91651120) ([merge request](gitlab-org/gitlab!149292))
- [Support classic tokens only](gitlab-org/gitlab@795bd63fa964fc8a1e5fbea8e750a089689ff2b5) ([merge request](gitlab-org/gitlab!148398))
- [Adjust UI to new designs](gitlab-org/gitlab@99ca6307e61a75506a55b22bebea2400695614bc) ([merge request](gitlab-org/gitlab!148696))
- [Revert 'ci-rules-exists-add-paths-project-ref'](gitlab-org/gitlab@89133ab27ace8fdc455833baee5b94de72af89f0) ([merge request](gitlab-org/gitlab!149266))
- [Return all visible groups for the Organization.groups GraphQL query](gitlab-org/gitlab@f579c7fcd8eb13002dd5bba358dce02c0e0d87a1) ([merge request](gitlab-org/gitlab!146600))
- [Globally enabled the Duo Chat callout](gitlab-org/gitlab@645c1f1637c4ad230d849cac5b94850af1b1f68d) ([merge request](gitlab-org/gitlab!149059)) **GitLab Enterprise Edition**
- [Remove feature flags related to FF merge trains](gitlab-org/gitlab@4c024b8c82abad6925577e14137ae728f151cbba) ([merge request](gitlab-org/gitlab!148964))
- [Remove sbom_occurrences_vulnerabilities feature flag](gitlab-org/gitlab@29145495ac2a7262425944cfa657835bd3216cbd) ([merge request](gitlab-org/gitlab!148998)) **GitLab Enterprise Edition**
- [Remove the FF ci_parallel_remote_includes](gitlab-org/gitlab@3a2c20f792893ac9fa3a6537083026187e488f24) ([merge request](gitlab-org/gitlab!149134))
- [Protected packages: Use namespace for external string](gitlab-org/gitlab@bf7fbf998ab2ec2edb6dea7e02f8d0108f320c6e) by @gerardo-navarro ([merge request](gitlab-org/gitlab!149113))
- [Protected packages + containers: Adjust style and wording in settings UI](gitlab-org/gitlab@b7cb3e617114b9cc7535d3e552bad150bd446d84) by @gerardo-navarro ([merge request](gitlab-org/gitlab!148704))
- [Quarantine a flaky test](gitlab-org/gitlab@20de72ec85589163c98b843003b9ffda698574a2) ([merge request](gitlab-org/gitlab!149078))
- [Quarantine a flaky test](gitlab-org/gitlab@848d093630c75c294736e364c1d1ce2595ff5342) ([merge request](gitlab-org/gitlab!149064))
- [Quarantine a flaky test](gitlab-org/gitlab@56c4817c4b1a22c24b36f8519e6d69b6186dc27f) ([merge request](gitlab-org/gitlab!149075))
- [Quarantine a flaky test](gitlab-org/gitlab@6907a2cefc9e54be0721f6c7c493d090de827d7e) ([merge request](gitlab-org/gitlab!149065))
- [Quarantine a flaky test](gitlab-org/gitlab@c3bba73c876e2f91efd0f182af9ab295597506b4) ([merge request](gitlab-org/gitlab!149074))
- [Quarantine a flaky test](gitlab-org/gitlab@eb62b4a7d6caa65593dd13a47815e945c6c293f5) ([merge request](gitlab-org/gitlab!149072))
- [Quarantine a flaky test](gitlab-org/gitlab@47f8bc50e897cdf9bdfa2c95ade96282eae72c5d) ([merge request](gitlab-org/gitlab!149071))
- [Add and backfill project_id for deployment_approvals](gitlab-org/gitlab@c2e7da79997c9367ec37e6beda269ced8b533498) ([merge request](gitlab-org/gitlab!149031))
- [Drop an unnecessary index on merge_requests](gitlab-org/gitlab@cc96c157f239907b0103c55898578f400c7790a3) ([merge request](gitlab-org/gitlab!148490))
- [Clean up dora_performers_score_panel feature flag](gitlab-org/gitlab@b37063a371e3348712fdd6818a30d74c78df6c72) ([merge request](gitlab-org/gitlab!148973)) **GitLab Enterprise Edition**
- [Add relaxed sharding keys for system_access](gitlab-org/gitlab@44c0956d60b63ab5e0775a900eb6476e2f18aecf) ([merge request](gitlab-org/gitlab!148949))
- [Add a migration to backfill zoekt_settings in application_settings](gitlab-org/gitlab@100e7f8746da72119163a57a195ca56d160f3905) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148014)) **GitLab Enterprise Edition**
- [Add relaxed sharding keys for pipeline_composition](gitlab-org/gitlab@6dafca0da880249bba35e5f6c75ddbc8b8263bde) ([merge request](gitlab-org/gitlab!148948))
- [Add sharding keys for continuous_delivery](gitlab-org/gitlab@fe492cd4c24684a5d190639526c1f282c9cd6b7c) ([merge request](gitlab-org/gitlab!142493))
- [Add closes_work_item column to merge_requests_closing_issues](gitlab-org/gitlab@39fd40250ec4d7100df419293b15a5e46191ae79) ([merge request](gitlab-org/gitlab!148763))
- [Remove FF search_add_archived_filter_to_zoekt](gitlab-org/gitlab@ce8c1e208f45cbe24595f151fd8c1d257f0310c9) ([merge request](gitlab-org/gitlab!148551)) **GitLab Enterprise Edition**
- [Fix Style/KeywordParametersOrder offenses](gitlab-org/gitlab@79b0fd0a7f4eabdebe91da01fa356af1cdc71119) by @harryminsky ([merge request](gitlab-org/gitlab!148567)) **GitLab Enterprise Edition**
- [Fix Lint/RedundantDirGlobSort offenses](gitlab-org/gitlab@2b1829232ccfb3101b8681bc545b5ba14ba58f58) ([merge request](gitlab-org/gitlab!148582))
- [Quarantine a flaky test](gitlab-org/gitlab@783ea4eaefe32a6fecfdda723c1b996c8c100c17) ([merge request](gitlab-org/gitlab!148856))
- [Add relaxed sharding keys for release_orchestration](gitlab-org/gitlab@2274785bd784dfb4fda398d5b906be82a81678db) ([merge request](gitlab-org/gitlab!148836))
- [Add relaxed sharding keys for continuous_integration](gitlab-org/gitlab@2af79b9748da46d525b6b7e1531d1a7d58fd3a29) ([merge request](gitlab-org/gitlab!148835))
- [Explicitly pass organization when a user namespace is created](gitlab-org/gitlab@f3d0799e44b372dbb63954212343acf7345189d9) ([merge request](gitlab-org/gitlab!148818))
- [Remove collapse_generated_diff_files FF](gitlab-org/gitlab@58a9c214ba078bce15bd6fcf420bbebd08c36899) ([merge request](gitlab-org/gitlab!148478))
- [Remove search_index_all_projects FF](gitlab-org/gitlab@d50f4f1ca6f352b367a20696f7264bf8a1302ceb) ([merge request](gitlab-org/gitlab!148111)) **GitLab Enterprise Edition**
- [Remove a partial index with locked_state on merge_requests](gitlab-org/gitlab@c4f4e335df8228984b785ac456f58bb9178df0db) ([merge request](gitlab-org/gitlab!148646))
- [Remove usages of FullPath and SetFullPath RPCs](gitlab-org/gitlab@32393507bd640aec2b5078ee7e76f45244689b3c) ([merge request](gitlab-org/gitlab!147651))
- [Move ref validation to services](gitlab-org/gitlab@147d4fd4def3b5f591178b1c171910079b09f17e) ([merge request](gitlab-org/gitlab!146764))
- [Add development widget to work item types](gitlab-org/gitlab@7c2ea75132f59b0fb5599cf1011f608674b3c32a) ([merge request](gitlab-org/gitlab!148119))
- [Create events definitions and reference them on UI elements](gitlab-org/gitlab@be2fa80363a086d046b3f03b326b5351620cad63) ([merge request](gitlab-org/gitlab!147673))
- [Refactor LfsStorageController#upload_finalize into service](gitlab-org/gitlab@5bd8976a7d7e5f5153c92c10a1a238de74435c7c) by @missy-davies ([merge request](gitlab-org/gitlab!139729))
- [Add relaxed sharding keys for team_planning](gitlab-org/gitlab@950f0665725a64db412262b59900fbd6de058a1e) ([merge request](gitlab-org/gitlab!148672))
- [Enforce not-null constraint vs_code_settings version](gitlab-org/gitlab@d73d7b283386ed5a9ba291b2b3f49d0661e66a90) ([merge request](gitlab-org/gitlab!148648))
- [Migrate inputs to spec on CI components table](gitlab-org/gitlab@9ff7f0872dbd089f16e89fc1bcb151021466e4ee) ([merge request](gitlab-org/gitlab!148547))
- [Remove "fetch_commits_for_bitbucket_server" feature flag](gitlab-org/gitlab@c971bda0141b79005afe97e89a1f8081e54e2416) ([merge request](gitlab-org/gitlab!148657))
- [Remove security_policies_policy_scope feature flag](gitlab-org/gitlab@ccdd99f9601cba26f0d3775bfda3c5067f59cf46) ([merge request](gitlab-org/gitlab!147386)) **GitLab Enterprise Edition**
- [Move right side panel into its own component](gitlab-org/gitlab@e9c465a377e4c9d13ed8dcad0b25b05d4c21f4d0) by @espadav8 ([merge request](gitlab-org/gitlab!148461))
- [Remove use_registration_type_db_value feature flag](gitlab-org/gitlab@a1e3f2bff8b28359cbc714eb3803e6d7a22de95f) ([merge request](gitlab-org/gitlab!148595)) **GitLab Enterprise Edition**
- [Add next desired sharding keys for code_review_workflow](gitlab-org/gitlab@e7a83dda1616fbd0dae531f7cd25c425b3319f48) ([merge request](gitlab-org/gitlab!148532))
- [Add next desired sharding keys for incident_management](gitlab-org/gitlab@d981c6f7d9ac6d13ba0807e116855887ccae9382) ([merge request](gitlab-org/gitlab!148531))
- [Add next desired sharding keys for portfolio_management](gitlab-org/gitlab@460a1b05e7bc6ea480499133dbbdb15361d8a23f) ([merge request](gitlab-org/gitlab!148529))
- [Finalize backfill vs_code_settings table migration](gitlab-org/gitlab@d105097d252eb65e2c7609808df660b4dbb925f1) ([merge request](gitlab-org/gitlab!148367))
- [Remove arkose_labs_signup_challenge feature flag](gitlab-org/gitlab@4276f0048ac1d060e1d8536eddf45c2cc5f2ca98) ([merge request](gitlab-org/gitlab!147767))
- [Protected containers: Resolve duplicate test assertions](gitlab-org/gitlab@9cc4b1b0ce27055df79ef4731a2072f40233ed95) by @gerardo-navarro ([merge request](gitlab-org/gitlab!148252))
- [Add desired sharding keys for geo_replication](gitlab-org/gitlab@fa96b612b05f861721c277c887e9885f5504a1c3) ([merge request](gitlab-org/gitlab!148061))
- [Remove `group_analytics_dashboards` feature flag](gitlab-org/gitlab@9c38ad6deef6d8123896eadfaa1aa702fa6196a6) ([merge request](gitlab-org/gitlab!147013)) **GitLab Enterprise Edition**
- [Add storage_shard label by decomposing instrumentation class name](gitlab-org/gitlab@f698dae407cebe4e12a62dca39028279ebe98897) ([merge request](gitlab-org/gitlab!147746))
- [Remove feature flag use_partition_id_filter_on_ci_job_artifacts](gitlab-org/gitlab@a58b1c3ad28329bc40f1df414356f511c676abd2) ([merge request](gitlab-org/gitlab!148029))
- [Finalize migration BackfillDefaultOrganizationUsers](gitlab-org/gitlab@295e8510ca9389c3156b54ba18d08d802d1c3a0b) ([merge request](gitlab-org/gitlab!147516))
- [Protected containers: Adjust error message in docker client](gitlab-org/gitlab@13417ca9003d59e0536e2ad166029b4a9ed0d731) by @gerardo-navarro ([merge request](gitlab-org/gitlab!148087))
- [Add desired sharding keys for audit_events](gitlab-org/gitlab@547eb9efc2f01024ffdc35535c710bad8018ecce) ([merge request](gitlab-org/gitlab!148067))
- [Add desired sharding keys for package_registry](gitlab-org/gitlab@ed4cebb62545b275b0bb1823ff96618c134579b7) ([merge request](gitlab-org/gitlab!148065))
- [Add desired sharding keys for team_planning](gitlab-org/gitlab@8be2b931e341e36db286aef9a9a5fade4b54f204) ([merge request](gitlab-org/gitlab!148063))
- [Add desired sharding keys for portfolio_management](gitlab-org/gitlab@4a121810e6d3f98175d7e85c7328e89f7fd775ec) ([merge request](gitlab-org/gitlab!148060))
- [Add desired sharding keys for incident_management](gitlab-org/gitlab@7ea185c0efb61a38cfb6e821e3e8219af2ece4c1) ([merge request](gitlab-org/gitlab!148043))
- [Add desired sharding keys for service_desk](gitlab-org/gitlab@464b55c52ee5afd640d1d2524d1655e2e69247c0) ([merge request](gitlab-org/gitlab!148041))
- [Add desired sharding keys for error_tracking](gitlab-org/gitlab@dabaf4a1de77a57f791bddb5f7770e5262073a67) ([merge request](gitlab-org/gitlab!148038))
- [Add desired sharding keys for metrics](gitlab-org/gitlab@8e885408fcb425c643961244624ee41cc38d2a54) ([merge request](gitlab-org/gitlab!148035))
- [Update schema for clusterwide tables in web_ide](gitlab-org/gitlab@cfd0ed92e464eb15bf047db4b697558f133a94a2) ([merge request](gitlab-org/gitlab!147982))
- [Update schema for clusterwide tables in team_planning](gitlab-org/gitlab@52e858a8f4c94b26e724854b61fa2fb5259d81df) ([merge request](gitlab-org/gitlab!147981))
- [Update schema for clusterwide tables in importers](gitlab-org/gitlab@c4fdf02c1044f544504563674a2ee7c2bb6c6e54) ([merge request](gitlab-org/gitlab!147980))
- [Update schema for clusterwide tables in system_access](gitlab-org/gitlab@883691365e1b424f33b10091f572551837153d50) ([merge request](gitlab-org/gitlab!147979))
- [Update schema for clusterwide tables in user_profile](gitlab-org/gitlab@22bbf1c56bdf44f55adfa6f3d9f426eb098b3aee) ([merge request](gitlab-org/gitlab!147978))
- [Update schema for clusterwide tables in deployment_management](gitlab-org/gitlab@b0854c4e78023392c85ac0a39b1912307783030a) ([merge request](gitlab-org/gitlab!147972))
- [Use PipelineTriggers::DestroyService across endpoints](gitlab-org/gitlab@85bded241311852974738edb35559141009c92a9) by @missy-davies ([merge request](gitlab-org/gitlab!136163))
- [Add missing attributes in the search/count endpoint](gitlab-org/gitlab@f93369b84e4dd53e1d084d322a5e534c899fd38b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147796))
- [Update artifacts queries to use partition_id filter](gitlab-org/gitlab@bf891b816aacf233a9280ebd2b4928391131eafe) ([merge request](gitlab-org/gitlab!147126))
- [Adds sharding_key to internal_ids](gitlab-org/gitlab@9f9e531d020e8f89afc5c85dd1030f6b9f10db5c) ([merge request](gitlab-org/gitlab!147705))
- [Add sharding keys for error_tracking](gitlab-org/gitlab@54ec24bb31ae92b19a8237d8aedd275bbd43870c) ([merge request](gitlab-org/gitlab!147788))
- [Add sharding keys for metrics](gitlab-org/gitlab@a50560611537ba8df6d3758cdc727eea59151733) ([merge request](gitlab-org/gitlab!147787))
- [Add sharding keys for navigation](gitlab-org/gitlab@9c99f8829d400e748a409e679194222c8c8f36f9) ([merge request](gitlab-org/gitlab!147784))
- [Add sharding keys for service_desk](gitlab-org/gitlab@5f7162a6fbf5cd4172e54f1c54b333a58e70ab67) ([merge request](gitlab-org/gitlab!147783))
- [Add sharding keys for incident_management](gitlab-org/gitlab@3ae59207a80b6e46b8c6232d3513d8ece0aaff07) ([merge request](gitlab-org/gitlab!147779))
- [Remove epic_events_on_contributions_calendar feature flag](gitlab-org/gitlab@3f985a78b205ffb208ea5a1dc0e38c8a9f06e084) ([merge request](gitlab-org/gitlab!147760))
- [Use partitioned foreign key between ci_builds and ci_stages](gitlab-org/gitlab@6a18d4996153cecada618bfd35c36a9eea070b72) ([merge request](gitlab-org/gitlab!147648))
- [Use routing tables for ci_job_artifacts and ci_stages ](gitlab-org/gitlab@001e895189c01640f729f104430596055cfbb919) ([merge request](gitlab-org/gitlab!147438))
- [Add relation import tracker and table](gitlab-org/gitlab@6591d0b946a8dcc069b3c8250291aec1e235732a) ([merge request](gitlab-org/gitlab!146778))
- [Show alert to explain where code suggestions moved](gitlab-org/gitlab@d293a5a61db21f431772a12d99b786afd0fcbad3) ([merge request](gitlab-org/gitlab!144807)) **GitLab Enterprise Edition**
- [Adding p_ci_build_names table and model](gitlab-org/gitlab@af1699a0822078be97696954a5df78127a9f79e6) ([merge request](gitlab-org/gitlab!146555))
- [Refactor push_rules_helpers_spec.rb to improve tests speed](gitlab-org/gitlab@baa2641e1d44660613148e85216d6ce5d9ebe779) ([merge request](gitlab-org/gitlab!147571)) **GitLab Enterprise Edition**
- [Update indentation on yaml docs](gitlab-org/gitlab@d0f731e72094927a87411b152486e69f55700bcd) ([merge request](gitlab-org/gitlab!147564))
- [Adjust naming in admin network settings](gitlab-org/gitlab@39219aedd2a6c92964d9949ffed00060721c5c18) by @gerardo-navarro ([merge request](gitlab-org/gitlab!147536))
- [refactor: Add feature category for rack attack tests](gitlab-org/gitlab@adf26bc8186ac36c44c5044bdcdd5cd59212c5cd) by @gerardo-navarro ([merge request](gitlab-org/gitlab!147530))
- [Finalize migration BackfillDefaultOrganizationOwnersAgain](gitlab-org/gitlab@918153f76698b529d56f79f6768333189b2013d2) ([merge request](gitlab-org/gitlab!147514))
- [Remove "external_pipeline_validation_service_url" feature flag](gitlab-org/gitlab@95259cdfe652b81023988a868827c7d21faa9cd3) ([merge request](gitlab-org/gitlab!147407))
- [Port the project admin button to Vue](gitlab-org/gitlab@62bdb1e1a41db8e3161146f43724e43743e5e150) by @espadav8 ([merge request](gitlab-org/gitlab!144736))
- [Drop promote_ultimate_features_at column](gitlab-org/gitlab@b5dbcc83686be21fbf90d176bfd07707f21d1518) ([merge request](gitlab-org/gitlab!145706))
- [Finalize the backfill migration for onboarding status step url](gitlab-org/gitlab@f986c1b1cf00968ff106136893bfe68d47895c69) ([merge request](gitlab-org/gitlab!147278))
- [Remove ClusterRepositoryCache migration helper class](gitlab-org/gitlab@f71a7a94ce8d70d9d378ebc225b802b58f0ae006) ([merge request](gitlab-org/gitlab!147244))

## 16.10.9 (2024-07-23)

### Added (1 change)

- [Add Rake task to show token expiration info](https://gitlab.com/gitlab-org/gitlab/-/commit/401fa9da22fdeffa67c783e11b98ce0c9bb8c7ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159057))

## 16.10.8 (2024-06-25)

### Fixed (1 change)

- [Update an expired test certificate](gitlab-org/gitlab@adb50cc178e81e75b78f6b10cafc79cd6be9a43c) ([merge request](gitlab-org/gitlab!156394))

### Changed (1 change)

- [Add a banner informing about token expiration](gitlab-org/gitlab@7f51cdccdd702a4f92607d52b6d4e3884c8e5234) ([merge request](gitlab-org/gitlab!155266))

## 16.10.7 (2024-06-11)

### Security (4 changes)

- [XSS and content injection raw XHTML files on IOS devices](gitlab-org/security/gitlab@bd477c1d019b3f758a38a4b7182b86f2d4668df4) ([merge request](gitlab-org/security/gitlab!4095))
- [Improve go_package_regex to prevent ReDoS attacks](gitlab-org/security/gitlab@56f50979b62a982e572d5695a87d19a36e0a9ef6) ([merge request](gitlab-org/security/gitlab!4098))
- [Fix ReDoS in CI Interpolation](gitlab-org/security/gitlab@045cf00aa56d545bdfb828c6131af89c37164946) ([merge request](gitlab-org/security/gitlab!4083))
- [Verify Asana access token when testing Asana integration](gitlab-org/security/gitlab@233b152dfea572b19b1803174c4604f4c0e04851) ([merge request](gitlab-org/security/gitlab!4061))

### Other (1 change)

- [Quarantine a flaky test](gitlab-org/security/gitlab@45242cdf1d36c89aff59e3ce7ee3d2e2f5b16471)

## 16.10.6 (2024-05-21)

### Fixed (1 change)

- [Ensure BLPOP/BRPOP returns nil instead of raising ReadTimeoutError](gitlab-org/security/gitlab@78c11d44cf01757221da8bb01f6fbdefb352f619)

### Security (6 changes)

- [Prevent PDF.js from evaluating scripts](gitlab-org/security/gitlab@db5b63e4a26889f09f72b582b7777909efd4cd4d) ([merge request](gitlab-org/security/gitlab!4071))
- [Caching test_report api response to reduce calculations](gitlab-org/security/gitlab@8b67dde95712b74c3ff0ae9d8bc73d7cd0a350cf) ([merge request](gitlab-org/security/gitlab!4030))
- [Fail create commit status on pipeline_id / sha mismatch](gitlab-org/security/gitlab@36c5070a2ad812f52747241321aaae81345aaee0) ([merge request](gitlab-org/security/gitlab!4033))
- [Use UntrustedRegexp for gollum pattern](gitlab-org/security/gitlab@3fee24aca41a5db9135e8f3003335d1754beb636) ([merge request](gitlab-org/security/gitlab!4041))
- [Patch @gitlab/web-ide to fix XSS webWorkerExtensionHostIframe.html](gitlab-org/security/gitlab@29cc8769daee74938155dd7e3b5a2f3a3bda5b71) ([merge request](gitlab-org/security/gitlab!4057))
- [Add text limit to ci_runners text fields](gitlab-org/security/gitlab@5af28a81f6c11d9627f1a359a7c3a7d85e7fb4d9) ([merge request](gitlab-org/security/gitlab!4037))

## 16.10.5 (2024-05-07)

### Fixed (1 change)

- [Changed the email validation for only encoded chars](gitlab-org/security/gitlab@f7c8aa08b6bac4cfc9942166607ed482037e440f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151484/))

### Changed (1 change)

- [Return or display Gitlab version if GITLAB_KAS_VERSION is a SHA](gitlab-org/security/gitlab@0b3fa36f5dd06891b9e612cc8abc007368b27be3)

### Security (11 changes)

- [Update GITHUB_MEDIA_CDN to avoid SSRF when importing from Github](gitlab-org/security/gitlab@0d7ee3cee127d629f12bfee309dbc55c8cc9c256) ([merge request](gitlab-org/security/gitlab!4012))
- [Prevent namespace banned users from reading project todos](gitlab-org/security/gitlab@8073a9aee49d9cad4923adaa2dbf0a6ad14ea9a6) ([merge request](gitlab-org/security/gitlab!3940))
- [ReDoS in GitRefsFinder when using wildcards in branch search](gitlab-org/security/gitlab@ba1ed3f62c2c454ec295636c66b4b1e4a2f8d990) ([merge request](gitlab-org/security/gitlab!3996))
- [ReDos in escape and commit reference filters](gitlab-org/security/gitlab@a1894c71a676f5b762bd951cf996f39e13a7725c) ([merge request](gitlab-org/security/gitlab!3973))
- [Validate request origin before MR approval](gitlab-org/security/gitlab@5279a01f625dc258a2f450ef2a7f65f63eb5d138) ([merge request](gitlab-org/security/gitlab!4008))
- [Check request size before updating user pins](gitlab-org/security/gitlab@914de75d86f9cf2a3275e2a48f35e19478d3aad4) ([merge request](gitlab-org/security/gitlab!4015))
- [Enforce per_page validation for Branches/TagsFinders](gitlab-org/security/gitlab@2ad4ddfb1fb705fec72771870624647443e7e55c) ([merge request](gitlab-org/security/gitlab!3999))
- [Update Integrations::Discord::ATTACHMENT_REGEX regex](gitlab-org/security/gitlab@3900a2e11afbca28d28bdf014e4c2f40b255236c) ([merge request](gitlab-org/security/gitlab!3987))
- [Update BaseMessage::RELATIVE_LINK_REGEX regex](gitlab-org/security/gitlab@f8641296f1bc0e944cee2685df703bcd72c4a556) ([merge request](gitlab-org/security/gitlab!3993))
- [Require confirmation before linking JWT identity](gitlab-org/security/gitlab@47382334fb05c3bef26719100e4281124dea606f) ([merge request](gitlab-org/security/gitlab!3991))
- [Fix confidentiality check optimization](gitlab-org/security/gitlab@3a6d5fbdea0f205695f0bf34cd5f64bec6ddbbd1) ([merge request](gitlab-org/security/gitlab!4003))

## 16.10.4 (2024-04-24)

### Fixed (1 change)

- [Update vulnerability_reads scanner in the ingestion pipeline](gitlab-org/security/gitlab@14b8876233e5dd29149426fd88bab0fc4f014d46) **GitLab Enterprise Edition**

### Security (5 changes)

- [Validation for encoded formatting characters](gitlab-org/security/gitlab@4cd13c705ce1a94152fb2fd6fcaa77e90e6441e5) ([merge request](gitlab-org/security/gitlab!3950))
- [Forbid untrusted sign-ins to GitLab with Bitbucket and fix related uid](gitlab-org/security/gitlab@5d3c3a599cc5560dea2236474309537536428cdc) ([merge request](gitlab-org/security/gitlab!3984))
- [Ensure PAT scope is validated everywhere for GraphQL/ActionCable](gitlab-org/security/gitlab@079dfee8cff9da9075eec7c03ce002e87eeebfff) ([merge request](gitlab-org/security/gitlab!3976))
- [Protect against ReDoS in FileFinder with wildcard filters](gitlab-org/security/gitlab@0e7e54050f1c4829b1d55aac85bd4e9cd96f1580) ([merge request](gitlab-org/security/gitlab!3960))
- [fix: Validate security report version against schema during parsing](gitlab-org/security/gitlab@217040b1062caad501d60af387c47cff758788a1) ([merge request](gitlab-org/security/gitlab!3956))

## 16.10.3 (2024-04-12)

No changes.

## 16.10.2 (2024-04-09)

### Fixed (1 change)

- [Fix URL validator for mirror services when using localhost](gitlab-org/security/gitlab@82ee9dbd7b4f52507563a509eaa8d2e4839b2e58)

### Security (3 changes)

- [Update Gitlab::Regex::Packages#slack_link_regex](gitlab-org/security/gitlab@25d2355e4cd84a5c1005f1769624e83bfc6d63c2) ([merge request](gitlab-org/security/gitlab!3945))
- [Fix XSS in autocomplete in rich text editor](gitlab-org/security/gitlab@dc132c61a896afc1b63ce9cf31b69797eecf95ce) ([merge request](gitlab-org/security/gitlab!3946))
- [Correctly parse attachments for junit result](gitlab-org/security/gitlab@e729252188fd47950e27abe14bad4bf748e99455) ([merge request](gitlab-org/security/gitlab!3934))

## 16.10.1 (2024-03-27)

### Fixed (2 changes)

- [Update redis-client to v0.21.1](gitlab-org/security/gitlab@c9d6f434dbc8d5ca244d0c00d8c5cf0d9092df39)
- [Fix new project group templates pagination](gitlab-org/security/gitlab@956b01c404e55bc92276ab7d21c63a09bc3edfb5) **GitLab Enterprise Edition**

### Security (3 changes)

- [Merge branch 'dchevalier2-master-patch-88770' into 'master'](gitlab-org/security/gitlab@9e621975bf405f2e66541faebf11b06a31360b5d) ([merge request](gitlab-org/security/gitlab!3936))
- [Limit the number of emojis we will transform](gitlab-org/security/gitlab@e935e1cc26a06990832781b30827d5afa53d0194) ([merge request](gitlab-org/security/gitlab!3927))
- [Fix stored xss in wikis using the abstract_reference_filter](gitlab-org/security/gitlab@d1bad1a4847917d5f10c883d0d2f627088a00ca5) ([merge request](gitlab-org/security/gitlab!3929))

## 16.10.0 (2024-03-20)

### Added (115 changes)

- [Add drawer to list of linked policies](gitlab-org/gitlab@218016c38801cfeac1308385097dcd760182a378) ([merge request](gitlab-org/gitlab!147039)) **GitLab Enterprise Edition**
- [Command palette default opening state - part 3](gitlab-org/gitlab@a51d07342e3a7dc4da56ec84efec5191d8663640) ([merge request](gitlab-org/gitlab!142816))
- [Expose repository object format via GitInfo](gitlab-org/gitlab@4947d2c17a7118e392312f9d31fcf7c6799577e3) ([merge request](gitlab-org/gitlab!146485))
- [Add deprecated_policy field for approval policies](gitlab-org/gitlab@2e332564e7148343db00f79a4caafe672e206c87) ([merge request](gitlab-org/gitlab!146520))
- [Add approval rules drawer component](gitlab-org/gitlab@51b30ac3d7bb61ab5f43fc87a322560ea0167238) ([merge request](gitlab-org/gitlab!146502)) **GitLab Enterprise Edition**
- [Expose external issue links to Vulnerabilities if any](gitlab-org/gitlab@7a8d63cd7660e3bc2dcc1de307f556549c137876) ([merge request](gitlab-org/gitlab!146149)) **GitLab Enterprise Edition**
- [Add table to track CI component usage](gitlab-org/gitlab@3372a7566bfe2b0bea000e48fd0bffbaffb2db45) ([merge request](gitlab-org/gitlab!145881))
- [Add Pages URL anchor](gitlab-org/gitlab@6d5023141d9597087ffd353a2794102e52ec5e09) ([merge request](gitlab-org/gitlab!144281))
- [Update Jira::JqlBuilderService to support multiple project keys](gitlab-org/gitlab@4da23ca620a7219a43c81170496ef99ebc989efd) ([merge request](gitlab-org/gitlab!146916))
- [Add new achievement UI](gitlab-org/gitlab@a4bcf4e181d1458f8bcb504de2d7e95ee3a4136e) ([merge request](gitlab-org/gitlab!146273))
- [Protected containers: GraphQL query for container protection rules](gitlab-org/gitlab@1a773182a248eb646affd5334c6a6e1182828345) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146467))
- [Add runner creation metrics](gitlab-org/gitlab@dc17b7ad19792592b2e9078e49755a5da3356bc6) ([merge request](gitlab-org/gitlab!146063)) **GitLab Enterprise Edition**
- [Allow to enable/disable ClickHouse for analytics](gitlab-org/gitlab@f025888da096cace95cf86d5d20f3a52e0691eaa) ([merge request](gitlab-org/gitlab!145022)) **GitLab Enterprise Edition**
- [Adds Destroy action to delete models](gitlab-org/gitlab@1e487f60a57924b9c7dcbb1503af5e7478781a3a) ([merge request](gitlab-org/gitlab!144226))
- [Added event type filters for group audit event destinations](gitlab-org/gitlab@67cb59d71542f90b1e1fc62295747814fc16dd0c) ([merge request](gitlab-org/gitlab!144139)) **GitLab Enterprise Edition**
- [This MR adds alert banner](gitlab-org/gitlab@4d9836b4900ab7540c64e766ad6c18c0e9ce7011) ([merge request](gitlab-org/gitlab!146709)) **GitLab Enterprise Edition**
- [Create partitioned merge_request_diff_commits copy](gitlab-org/gitlab@1efd0bb9ea849e189d39940d0cd9a8878e20bf63) ([merge request](gitlab-org/gitlab!143869))
- [Allow toggling duo_features_enabled settings via REST API](gitlab-org/gitlab@8f960b374aea97fda31a3a2159ef26bb71e05bdd) ([merge request](gitlab-org/gitlab!146582)) **GitLab Enterprise Edition**
- [Document runner long polling configuration](gitlab-org/gitlab@4dbcfba63217807106534d88039015e07775cab9) ([merge request](gitlab-org/gitlab!146701))
- [Prepare async indices for dependency list aggregations](gitlab-org/gitlab@3d87873acd137f1610229114db9854c7ceeb3e68) ([merge request](gitlab-org/gitlab!146650))
- [Add GitHub integration's logo](gitlab-org/gitlab@bd5d604b677a23eac4a8d59ec99bdae991d81042) ([merge request](gitlab-org/gitlab!146614)) **GitLab Enterprise Edition**
- [Add Cloud Connector docs for new backends](gitlab-org/gitlab@8afdf975d407ab3a98d1bce2004366147e0b7b7b) ([merge request](gitlab-org/gitlab!146507))
- [Synchronously add indexes for new `vulnerability_occurrences` cols](gitlab-org/gitlab@fb7b7225e2058029b10d2f2e7b6d7f1f680a87b3) ([merge request](gitlab-org/gitlab!145782))
- [Backfill semvar columns of existing catalog versions](gitlab-org/gitlab@67dfcf8be9ec25bd6f496d36d5349de8da6ad4f4) ([merge request](gitlab-org/gitlab!146688))
- [Allow toggling duo_features_enabled on Groups via GraphQL](gitlab-org/gitlab@30b24fdead5bd9d48bafe9ce7066bb2d5ead14b8) ([merge request](gitlab-org/gitlab!146430)) **GitLab Enterprise Edition**
- [API customizations for service account user](gitlab-org/gitlab@da6541a26e55d761fc434596e6cbba63efd7cfc2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144841))
- [Add diff_id to diff file links](gitlab-org/gitlab@81dce0361b9bfd951735a942ea40d3c4016dcb4c) ([merge request](gitlab-org/gitlab!146092))
- [Check duo_features_enabled setting by default](gitlab-org/gitlab@09581f30e9a9b9f2b42f3881a9a2d90ca8a1a3b8) ([merge request](gitlab-org/gitlab!146684)) **GitLab Enterprise Edition**
- [Add policy list when editing compliance framework](gitlab-org/gitlab@99fcb973a1e82fc567b1a0fbf7e7e22acf0af8b8) ([merge request](gitlab-org/gitlab!145312)) **GitLab Enterprise Edition**
- [Backfill has_issues for Vulnerability::Read rows with ExternalIssueLink](gitlab-org/gitlab@28ca07fe271a711692f7ac207118cf3309966140) ([merge request](gitlab-org/gitlab!146643))
- [Remove "dynamic_empty_tree_id" feature flag](gitlab-org/gitlab@f349b74184b4d5ab34c4da4262e4ba91894ba2b5) ([merge request](gitlab-org/gitlab!146609))
- [Adds /convert_to_ticket quick action](gitlab-org/gitlab@3bbe37bd14f9b3fa340f0b54e20a50e889b5f225) ([merge request](gitlab-org/gitlab!146492))
- [Adds activity page to Organization level](gitlab-org/gitlab@65045809d2d1a55942b5190dcdcc117e1ea6e665) ([merge request](gitlab-org/gitlab!146167))
- [Backfill archived and traversal_ids for vulnerability_reads](gitlab-org/gitlab@f032f04cc32f9d80688ac1192cc540c9c4d9962e) ([merge request](gitlab-org/gitlab!144765))
- [Cloud Connector: support extra claims in JWT](gitlab-org/gitlab@32202b2c6e104b239d2600ceee18b06a966f5406) ([merge request](gitlab-org/gitlab!146172)) **GitLab Enterprise Edition**
- [Add visibility filter in groups API](gitlab-org/gitlab@7f9aaa608595edbff92111607efbd6320ccd44b9) by @imskr ([merge request](gitlab-org/gitlab!146263))
- [Update JiraConnect app_descriptor](gitlab-org/gitlab@404abd1fc8fa1a620d60ef97df08024105fe35e9) ([merge request](gitlab-org/gitlab!142316))
- [Add user permission type for finding](gitlab-org/gitlab@41d142f4c6fc896f2849dddde18e61a14db9a312) ([merge request](gitlab-org/gitlab!144295)) **GitLab Enterprise Edition**
- [[Ban AI] Audit duo_features_enabled changes](gitlab-org/gitlab@dc3e1c3ed1bb7ccaf1f69877ff7586da6815f22a) ([merge request](gitlab-org/gitlab!145509)) **GitLab Enterprise Edition**
- [Add application limit on downstream pipelines](gitlab-org/gitlab@7dc888ebd2d890c70146079dfbe5bc7903953617) ([merge request](gitlab-org/gitlab!146112))
- [Show admin mode within active sessions view](gitlab-org/gitlab@5ea5889f554f334b54f9bd46f86401bceabb38ab) by @bufferoverflow ([merge request](gitlab-org/gitlab!145523))
- [Add support for templates in wikis](gitlab-org/gitlab@d469211260979df568fb488ea2cc202075071521) ([merge request](gitlab-org/gitlab!143314))
- [Add filter support for enterprise in GraphQL group members](gitlab-org/gitlab@1489b6e9b5fc89d3705308183afb3851913a6162) by @imskr ([merge request](gitlab-org/gitlab!145331))
- [Add service to send Arkose truth data](gitlab-org/gitlab@f3bbe9f5cc7781a6e7d9a30866125afb4b9e85db) ([merge request](gitlab-org/gitlab!145314))
- [Add php support for semgrep](gitlab-org/gitlab@cbb5b12d96def6ef5ef4d7029a96d24c1efb2fd6) ([merge request](gitlab-org/gitlab!143472))
- [Adds logo for DroneCI integration](gitlab-org/gitlab@3d856ecb91792afa226f5a189575261eae2638b6) ([merge request](gitlab-org/gitlab!146046))
- [Remove WIP feature flag](gitlab-org/gitlab@565d5f2aa37d75faa59fd1e737e5b2c9717f5e0b) ([merge request](gitlab-org/gitlab!146211)) **GitLab Enterprise Edition**
- [Add `initial` &  `latest` pipeline IDs to `vulnerability_occurrences`](gitlab-org/gitlab@cd1bfa6961c32e265f91c3ba657c6697ad3c301b) ([merge request](gitlab-org/gitlab!144697))
- [Add Remove Group custom ability](gitlab-org/gitlab@627346a084944547289326590b19769f887412dd) ([merge request](gitlab-org/gitlab!145166)) **GitLab Enterprise Edition**
- [Add support for sorting GET /groups/:id/projects by star count](gitlab-org/gitlab@7463ec4e59365c06bd7907c6f02a3bb1b81c9cd0) by @imskr ([merge request](gitlab-org/gitlab!145308))
- [Configurable session cookie token prefix](gitlab-org/gitlab@3bae157050215d0b975c195c755905abc9dfeda0) ([merge request](gitlab-org/gitlab!145178))
- [Add CI_COMPONENT_FQDN variable and usage instructions](gitlab-org/gitlab@ae9f265a8f7cb4fcecccd550f9751861987abd04) ([merge request](gitlab-org/gitlab!145950))
- [Add table to support new group-agent authorization strategy for RD](gitlab-org/gitlab@23a95b2769cb26478cc989aa00c5e153c9c5d0be) ([merge request](gitlab-org/gitlab!145101))
- [feat: Protected packages: Update protection rules in project settings ui](gitlab-org/gitlab@22769e8b79e976f172d5a85df2eea7c30f9ee303) by @gerardo-navarro ([merge request](gitlab-org/gitlab!141792))
- [Expose groups and projects allow list counters on graphQL](gitlab-org/gitlab@534f1dadc8129774ac3fe2965971c6f83539d7a8) ([merge request](gitlab-org/gitlab!145067))
- [Add time tracking widget to the work item update mutation](gitlab-org/gitlab@e2d808d2f668e64ba9b02e41ecd07bbcf5a5885d) ([merge request](gitlab-org/gitlab!145146))
- [Show target branch of MRs in Global Search](gitlab-org/gitlab@44a47b5f1d72b0f390bdef005b4393613220c758) by @santigl ([merge request](gitlab-org/gitlab!145849))
- [Add at least one approval by non author SOC 2 adherence check](gitlab-org/gitlab@33b9f8c00d4843d1403a908081dd416bb2bfe80a) ([merge request](gitlab-org/gitlab!145302)) **GitLab Enterprise Edition**
- [Add occupies_seat column to member_roles table](gitlab-org/gitlab@918cc302556394795be586125f4b8a84ccc63255) ([merge request](gitlab-org/gitlab!143911)) **GitLab Enterprise Edition**
- [Add REST API to fetch project's groups allowlist](gitlab-org/gitlab@84e9f297b0cdc02a7a47a35debe062cab04c269f) ([merge request](gitlab-org/gitlab!145069))
- [Add starrers_path to Catalog::ResourceType](gitlab-org/gitlab@9693fc338b17876112599fc27b1869f1f72e2daa) ([merge request](gitlab-org/gitlab!145937))
- [Added documentation for workflow:auto_cancel:on_job_failure](gitlab-org/gitlab@f822691e9082800dda1150814b96bb7c2e5d50bd) by @zillemarco ([merge request](gitlab-org/gitlab!145709))
- [Add new checkbox for optional data in service ping](gitlab-org/gitlab@51a6985a9ba587e0f6a970595257d218f4eff7b4) ([merge request](gitlab-org/gitlab!141540))
- [Display message when git rate limited by failed auth attempts](gitlab-org/gitlab@0c6b22efc24069741349ee0411d06c97749b27fe) ([merge request](gitlab-org/gitlab!145624))
- [Add new generic worker to handle auto merges from events](gitlab-org/gitlab@c8d7ec7f16b10b4b33ab6cd60bde982238397ab2) ([merge request](gitlab-org/gitlab!145460))
- [This MR adds policy scope on project level](gitlab-org/gitlab@7a4df91eef1dc726024f52e005c7db8757ba9481) ([merge request](gitlab-org/gitlab!143877)) **GitLab Enterprise Edition**
- [Remove ci_data_ingestion_to_click_house feature flag](gitlab-org/gitlab@8dd9fe00ae6b56664c086f83a4f81518a0f99e92) ([merge request](gitlab-org/gitlab!145665))
- [Remove run_clickhouse_migrations_automatically feature flag](gitlab-org/gitlab@7173726fdf9f309f4a692415a3df091e118cabdd) ([merge request](gitlab-org/gitlab!145668))
- [Added code to queue member promotion request](gitlab-org/gitlab@e61033ad415476d4c2ebe9ab63b1b98edfa3b443) ([merge request](gitlab-org/gitlab!142202)) **GitLab Enterprise Edition**
- [Add deployments_count field](gitlab-org/gitlab@3f0759518670a098e2c142a78f74d5ca218b4715) ([merge request](gitlab-org/gitlab!145320))
- [Copy VSA query params to issue analytics link](gitlab-org/gitlab@4ab125b9f80b7d0734256adbc50004b3f363b725) ([merge request](gitlab-org/gitlab!145496)) **GitLab Enterprise Edition**
- [Add ops flag to disable cookie-based language switcher](gitlab-org/gitlab@2b891f71abd03ffb1ad52e19eb15505d6b60ba96) ([merge request](gitlab-org/gitlab!144484))
- [Added first part of the command palete update - part 2](gitlab-org/gitlab@85cfd7f1dd1ae5d5fc3c011748d43ee5f2ba6893) ([merge request](gitlab-org/gitlab!141256))
- [Add an avatar to security policy bot](gitlab-org/gitlab@948d1602cad9d38464162b61bf5e2357678c4298) ([merge request](gitlab-org/gitlab!145423)) **GitLab Enterprise Edition**
- [Add yaml_error_messages graphql field](gitlab-org/gitlab@90de1d0c38c4e07d017a79b705ce1e62fec9c9f8) ([merge request](gitlab-org/gitlab!145327))
- [Add VSA aggregation status to GraphQL](gitlab-org/gitlab@875ba7de9ecaf52239000d3ea52406f3b232514a) ([merge request](gitlab-org/gitlab!144961)) **GitLab Enterprise Edition**
- [Add ops FF to reduce the export batch size](gitlab-org/gitlab@b85c99b7982ca94b03416bee2f8ad2b6a313a906) ([merge request](gitlab-org/gitlab!145189))
- [Add Cloud Connector developer docs](gitlab-org/gitlab@33714cfd2ab38b440903e5545b4b0672423cfd9f) ([merge request](gitlab-org/gitlab!142426))
- [Add endpoint to update group approval rules](gitlab-org/gitlab@526caa76c9b984eafa9f69b00f4c449ceeea9e34) ([merge request](gitlab-org/gitlab!144927)) **GitLab Enterprise Edition**
- [Default enable collapse_generated_diff_files feature](gitlab-org/gitlab@5134fbf13ff9fe1fa5025bba8f97842371c039ea) ([merge request](gitlab-org/gitlab!145100))
- [Add option to sort ciCatalogResources by star count](gitlab-org/gitlab@54a1a80598d40ed4a642fffc80680f1a384c40f5) ([merge request](gitlab-org/gitlab!145351))
- [Add duo_features_enabled cascading setting](gitlab-org/gitlab@08b0a643cde3a0bb7bcfee114bdbf9b2afe8131c) ([merge request](gitlab-org/gitlab!144931)) **GitLab Enterprise Edition**
- [Bulk ingest archived and traversal_ids values for security reports](gitlab-org/gitlab@08f4b9c2b680d7bde0303186de589191c09bb1f1) ([merge request](gitlab-org/gitlab!144618)) **GitLab Enterprise Edition**
- [Add parallel_project_export feature flag](gitlab-org/gitlab@1209339688c917a967877e89fa5c591f4d22e01f) ([merge request](gitlab-org/gitlab!145165))
- [Update denoramlized vuln read archived when projects are archived](gitlab-org/gitlab@529826c7bb117cb6ccee4cd4952cc3207fe48736) ([merge request](gitlab-org/gitlab!144455)) **GitLab Enterprise Edition**
- [Prepare issues table to backfill work items for epics](gitlab-org/gitlab@b1cfb979498102d1261081f24cc844e0235909b6) ([merge request](gitlab-org/gitlab!145124))
- [Keep showing create issue loading spinner while redirecting](gitlab-org/gitlab@0929a192c02d5f3d8c7301d8a18021fa805b2a05) ([merge request](gitlab-org/gitlab!144991)) **GitLab Enterprise Edition**
- [Purge old `security_scans` records on self-hosted installations](gitlab-org/gitlab@1ee7388709bbc8d5450164bbb60708613633a64a) ([merge request](gitlab-org/gitlab!144456))
- [Add custom payload template to webhooks](gitlab-org/gitlab@f8cfcb4fc3425636f4aede663078ae2caa503969) by @Taucher2003 ([merge request](gitlab-org/gitlab!142738))
- [Adds association count on organization level](gitlab-org/gitlab@d88c728d00ac23636b3a9c42bea76cf0e4d4a3d8) ([merge request](gitlab-org/gitlab!144726))
- [Add migration to add count fields to projects](gitlab-org/gitlab@ca9ba8a38fe0abbc19803729d1c8ad935ce6705e) ([merge request](gitlab-org/gitlab!144557)) **GitLab Enterprise Edition**
- [Add metrics for keep-around ref creation](gitlab-org/gitlab@de7031379b6ddc73934261b6f4a478e7947cfa8b) ([merge request](gitlab-org/gitlab!144809))
- [Add remove_child quick action for work items](gitlab-org/gitlab@d4d761fc83660692d39b03c50b7ab2a18417503c) ([merge request](gitlab-org/gitlab!141354))
- [Support job:rules:interruptible in CI config](gitlab-org/gitlab@78bd296182b6a2f1dd38345cbcaf1e7d76e1cacf) ([merge request](gitlab-org/gitlab!144687))
- [Add semantic version validation for catalog versions](gitlab-org/gitlab@8af3ded67da2dade5e090bdf471ca55df59893a0) ([merge request](gitlab-org/gitlab!144052))
- [Adds attribution_notice to Bugzilla integration](gitlab-org/gitlab@966edeabb3eaa40438d4ff69bb7bb997071f69c5) ([merge request](gitlab-org/gitlab!144166))
- [Run security reports ingestion for pipeline blocked with manual jobs](gitlab-org/gitlab@a1c5d4fc156a47702dccdff5812b7e378a433ee9) ([merge request](gitlab-org/gitlab!143046)) **GitLab Enterprise Edition**
- [Add Kubernetes overview on the Environment details page](gitlab-org/gitlab@04addb05c22b46001c798a99068c720215fd1d54) ([merge request](gitlab-org/gitlab!144370))
- [Enable VSA cumulative duration calculation](gitlab-org/gitlab@dfbf02a0b78000ec9d9115b8953ac969f0038e3c) ([merge request](gitlab-org/gitlab!144838)) **GitLab Enterprise Edition**
- [Adds search support to user organizations GraphQL query](gitlab-org/gitlab@116d540354890c4280a59f9b072f980d1080a2dd) ([merge request](gitlab-org/gitlab!144338))
- [Add configuration settings for Arkose client API](gitlab-org/gitlab@2043fe594f2fa16696c6429805108b94224957c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144534))
- [WorkItems rolledup dates: make fixed dates nullable on graphql](gitlab-org/gitlab@e402022624f847d31a38b653f6fb383df5ea185a) ([merge request](gitlab-org/gitlab!144451)) **GitLab Enterprise Edition**
- [Add throttling to bulk assignments](gitlab-org/gitlab@13806020f9e3f8f852ae1efc08e09280f14497a3) ([merge request](gitlab-org/gitlab!144745)) **GitLab Enterprise Edition**
- [Reuse existing projects & groups resolvers for Organization](gitlab-org/gitlab@9658c87958a54735b77882e270e2ca07ec54a7c8) ([merge request](gitlab-org/gitlab!144716))
- [Cancel a pipeline when configured to auto cancel on first job failure](gitlab-org/gitlab@88df5f5092e722fa408690fe4a38ebf0b9eb71cb) by @zillemarco ([merge request](gitlab-org/gitlab!141812))
- [feat: Protected packages: Delete protection rules in project settings ui](gitlab-org/gitlab@604002909fa988169c4c847e1e9451f29c5bb1c5) by @gerardo-navarro ([merge request](gitlab-org/gitlab!140483))
- [Replace FKs for p_ci_job_artifacts](gitlab-org/gitlab@01b364b8f0ab992249b3fe0dbc86c53a4964f144) ([merge request](gitlab-org/gitlab!144569))
- [Validate the foreign key & add to routing table upstream_pipeline_id](gitlab-org/gitlab@082ef3ac9bcbfac4d2f6e2d0ffa2bb548452abcf) ([merge request](gitlab-org/gitlab!144418))
- [Sync create indexes and prepare FK for p_ci_builds commit_id](gitlab-org/gitlab@fb679799339293f95cbc897a46fb6a22e08b9db5) ([merge request](gitlab-org/gitlab!144416))
- [Prepare async index for p_ci_builds.runner_id and project_id](gitlab-org/gitlab@569927247f88d04f6743b069f7a23c82b8f12f48) ([merge request](gitlab-org/gitlab!144414))
- [Use built-in multiline block quotes from parser](gitlab-org/gitlab@64fd38a6ebad791151e4e763dc82fead384e60ec) ([merge request](gitlab-org/gitlab!144379))
- [Add application setting for limit of merge request approval policies](gitlab-org/gitlab@381185ae27da69df4f8f29a2722ff9dcf75585ef) ([merge request](gitlab-org/gitlab!143849)) **GitLab Enterprise Edition**
- [Enable project redirect when fetching CI components](gitlab-org/gitlab@02e8ddbc0be5e6f42190be2ef8d23c3fb43fe229) ([merge request](gitlab-org/gitlab!144234))
- [Add the ability to sort findings](gitlab-org/gitlab@21cda12ba051b1c0640f00b9514bffee3575ea5a) ([merge request](gitlab-org/gitlab!142773)) **GitLab Enterprise Edition**
- [Fix WorkItems::RolledupDatesFinder](gitlab-org/gitlab@c590f431e7a1c1b050af83998e0f2eda90d6e698) ([merge request](gitlab-org/gitlab!143853)) **GitLab Enterprise Edition**

### Fixed (165 changes)

- [AdvisoryScanner recovers invalid version error](gitlab-org/gitlab@c85021c98817798ca2bf92555dd64f7de7fd70cf) ([merge request](gitlab-org/gitlab!147120)) **GitLab Enterprise Edition**
- [Add rake task to delete orphan artifact objects](gitlab-org/gitlab@e376ab7eba4f8d6fb16277e3c2b3dfd2e8b743b0) ([merge request](gitlab-org/gitlab!146093))
- [Fixed search input at small sizes](gitlab-org/gitlab@b0c6064fc61778f8bf6a578c5e7b7692f5d11ea7) ([merge request](gitlab-org/gitlab!147098))
- [Fix sidebar padding problem for issue lists](gitlab-org/gitlab@e97e31aa24678d314054bf6a2ad400f347b344a6) ([merge request](gitlab-org/gitlab!146954))
- [Fix incorrect dashboards link within onboarding flow](gitlab-org/gitlab@bf7e5046dfca54f7ac631707f7a93d46ad8b6c74) ([merge request](gitlab-org/gitlab!146967)) **GitLab Enterprise Edition**
- [Bulk deletes should respect search_index_all_projects FF](gitlab-org/gitlab@60ab1efa915c5b4f725c126256e9c129aab7f398) ([merge request](gitlab-org/gitlab!146999)) **GitLab Enterprise Edition**
- [Fix links to project issues redirect to wrong server](gitlab-org/gitlab@7d01bf2c60f617bdd56df43486ef12f23bad762e) by @lifez ([merge request](gitlab-org/gitlab!146433))
- [Truncate description and solution when ingesting Vulnerabilities](gitlab-org/gitlab@06391d0dc1b962811746d16f9556d7478eabd41e) ([merge request](gitlab-org/gitlab!146571)) **GitLab Enterprise Edition**
- [Fix a bug when mvn uses the dependency proxy with basic auth](gitlab-org/gitlab@5f517356a06b025239f910fc749775b5011867f4) ([merge request](gitlab-org/gitlab!146665))
- [Fix style problems for issues list on small screen](gitlab-org/gitlab@231127b6356687bf61d06ae25f823b528ba14a7a) ([merge request](gitlab-org/gitlab!146394))
- [Fix Repository analytics commit statistics failing to render](gitlab-org/gitlab@e9ba6a27a4b82c5ef0feae1a3702f2c400c460ed) ([merge request](gitlab-org/gitlab!146675))
- [Allow users to use _EXCLUDED_ANALYZERS variable in SEP](gitlab-org/gitlab@072cf3d3fae6ac9b0d97a0b44120d0833c6bc543) ([merge request](gitlab-org/gitlab!144243)) **GitLab Enterprise Edition**
- [Update pages ci templates - Hexo, Hugo, Hyde](gitlab-org/gitlab@fe427d85e54283b0475cb3116cafdfd3af62e7d3) ([merge request](gitlab-org/gitlab!146050))
- [Design management: Fix overflow of video](gitlab-org/gitlab@1269d6ad2d858b39e39d55dfdb7c8b4d946fac91) ([merge request](gitlab-org/gitlab!146903))
- [Limit security policy project resolver suggestions](gitlab-org/gitlab@cef98dcd59e0eac397c65985ce16a818451685d5) ([merge request](gitlab-org/gitlab!146892)) **GitLab Enterprise Edition**
- [Make sure spinner occupies enough vertical space](gitlab-org/gitlab@176e38e3b5d110433a44f0f0079f8261527b05b6) ([merge request](gitlab-org/gitlab!146535))
- [Issuable sidebar: Improve promotions and hide empty section](gitlab-org/gitlab@4ca9820861522c17264c7afd264f5c08b30b0d5d) ([merge request](gitlab-org/gitlab!146879))
- [Change bootstrap migration reset font weight bold value](gitlab-org/gitlab@c5f730ce559152349e9d0da3a3d14e24649369d9) ([merge request](gitlab-org/gitlab!146872))
- [Prevent mutating line endings](gitlab-org/gitlab@1aaf877acdf90e2aaf693da05851728a45df81ab) ([merge request](gitlab-org/gitlab!137641))
- [Resolve validation failing for theme_id when previous dark mode value 11](gitlab-org/gitlab@4526b9ebac1c98921365c27061b1e80bbb04fc1d) ([merge request](gitlab-org/gitlab!146845))
- [Add exit status when backup fail](gitlab-org/gitlab@d664f5b8d136fdf3005a3fdb4d22bbe6519f6156) by @lifez ([merge request](gitlab-org/gitlab!145943))
- [Clear search input when selecting or deselecting a reviewer](gitlab-org/gitlab@3adcfb3228272b5d995b7a394c96f41b13906042) ([merge request](gitlab-org/gitlab!145247))
- [Refactor Vue shared `SettingsBlock`](gitlab-org/gitlab@877bdbcad632b4e5164393181e44e5cb6a574530) ([merge request](gitlab-org/gitlab!146156)) **GitLab Enterprise Edition**
- [Clarify ambiguous instructions](gitlab-org/gitlab@6453121e844e17f7eca808b9c45a32993e1f0096) ([merge request](gitlab-org/gitlab!142782)) **GitLab Enterprise Edition**
- [Fix encoding error when downloading archive](gitlab-org/gitlab@f974d7b2a4a7485115eef8225851d37ae8ba60cf) ([merge request](gitlab-org/gitlab!146705))
- [Resolve Issue list page size control overlap](gitlab-org/gitlab@2308ffc9fa8895bf938bf1b9cf04fef15834cf99) ([merge request](gitlab-org/gitlab!145848))
- [Fix pagination in wiki pages and templates](gitlab-org/gitlab@c486b3fe6aa3b0ddaafa387009268b89004009fe) ([merge request](gitlab-org/gitlab!146468))
- [Ensure that scan-policies stage is added after .pre](gitlab-org/gitlab@48319b2baee8bbd64a90cd2d60daa914e03d983e) ([merge request](gitlab-org/gitlab!146096)) **GitLab Enterprise Edition**
- [Fix compliance framework graphql query to return correct policies](gitlab-org/gitlab@977713f1fc8ca310fd7c509abcba6d704a5549de) ([merge request](gitlab-org/gitlab!146238)) **GitLab Enterprise Edition**
- [Ensure scope validation only for classic pats](gitlab-org/gitlab@98a42cf48774b1f15e9b8d56ecc6f2e4300887cf) ([merge request](gitlab-org/gitlab!146532))
- [Reload HEAD diff when MR is marked as mergeable](gitlab-org/gitlab@804b8d9ccb92ec1d469fd04338d535eee34aeedc) ([merge request](gitlab-org/gitlab!146604))
- [Fix for avatar cache not clearing on update](gitlab-org/gitlab@4340c5ef62eedf10241e812243a08e85bfe9376c) ([merge request](gitlab-org/gitlab!122639))
- [Fix Issues Analytics first-of-month loading error](gitlab-org/gitlab@8337293db998ed3dca791bc95212f8f1e59381ac) ([merge request](gitlab-org/gitlab!146546)) **GitLab Enterprise Edition**
- [Fix namespace reset](gitlab-org/gitlab@5236a9e83069bd3af4a8baf88229ed8eb1a0dd0d) ([merge request](gitlab-org/gitlab!146540))
- [Prepare push rules for committer email change](gitlab-org/gitlab@19ea246eb99d09ab40a4155e01d101f942caa15e) ([merge request](gitlab-org/gitlab!146335))
- [Empty repo: Hide empty sidebar blocks](gitlab-org/gitlab@4a5bdc76a55db8cc1aabc965cb14d23132b81df5) ([merge request](gitlab-org/gitlab!146462))
- [Fix incorrect audit event name being logged when a user is rejected](gitlab-org/gitlab@472d22ef63d30097100634a5f42f02ad22221b76) ([merge request](gitlab-org/gitlab!146458)) **GitLab Enterprise Edition**
- [Style fixes for board top bar on small screens](gitlab-org/gitlab@94ce27a63db52aa2de4001c1fcf0893b72ea5020) ([merge request](gitlab-org/gitlab!146414)) **GitLab Enterprise Edition**
- [Emoji picker: Fix icon for legacy notes](gitlab-org/gitlab@f7de180b4ed8cca021ce5f83b3262a61621c2d13) ([merge request](gitlab-org/gitlab!146369))
- [Fix policy variables in scheduled pipelines](gitlab-org/gitlab@b091e4f849f6cf68c115504cd0844c2ae87a179c) ([merge request](gitlab-org/gitlab!146064)) **GitLab Enterprise Edition**
- [Enable feature flag "fetch_commits_for_bitbucket_server" by default](gitlab-org/gitlab@fd9256e60c83d23280cad631ca0350f028fe496c) ([merge request](gitlab-org/gitlab!146353))
- [Fix missing require for users development seed](gitlab-org/gitlab@8f6166dbd04aeebbedd23cc152413ab17a53254f) ([merge request](gitlab-org/gitlab!146351))
- [Fix finding modal when dismissed by is null](gitlab-org/gitlab@7be939041e81a5950c86bfacb39f35b86bfd34f8) ([merge request](gitlab-org/gitlab!146193)) **GitLab Enterprise Edition**
- [Fix user having custom role in multiple objects in a hierarchy](gitlab-org/gitlab@2a0fff1e1679df6aa3fae4aec1c9ba2490dfdbd5) ([merge request](gitlab-org/gitlab!144851)) **GitLab Enterprise Edition**
- [Use sentence case for DORA metrics titles](gitlab-org/gitlab@073fd7fcf5ae27dace77811f011258cb48e7c508) ([merge request](gitlab-org/gitlab!145867)) **GitLab Enterprise Edition**
- [Update pipeline_triggers plan limits to 25k for trials and opensource](gitlab-org/gitlab@2cecbcd8b82850f7607b4e9a85e76f50df8f98e1) ([merge request](gitlab-org/gitlab!145846))
- [This MR fixes header for security policies](gitlab-org/gitlab@96eac69ed540c700ac0af6cf4fea989cc7190d07) ([merge request](gitlab-org/gitlab!146277)) **GitLab Enterprise Edition**
- [Change "Create new Value Stream" to "New value Stream"](gitlab-org/gitlab@b0d79d1b864dd793b2f800ed589adab0bf42e358) ([merge request](gitlab-org/gitlab!146248)) **GitLab Enterprise Edition**
- [Fix DiffStatsType encoding error](gitlab-org/gitlab@077f497ee737c0e9615321f80d855afdcd79dc6d) ([merge request](gitlab-org/gitlab!145068))
- [Use user locale to display delimiters and separators in storage usage](gitlab-org/gitlab@d22bf9d9fc411948acf13d466baff2b949670cae) ([merge request](gitlab-org/gitlab!144565)) **GitLab Enterprise Edition**
- [Export & Import diff note's diff file](gitlab-org/gitlab@ab57d9055d0f457e50c3de4127b186574f996ef3) ([merge request](gitlab-org/gitlab!145967))
- [Handle version conflict errors in ElasticDeleteProjectWorker](gitlab-org/gitlab@fd99b56be44bdb74a8886cd2ca378b1fea800c3f) ([merge request](gitlab-org/gitlab!146068)) **GitLab Enterprise Edition**
- [Assignees widget dropdown reordering of selected users](gitlab-org/gitlab@f85f207eb67495cbe9331b555266e52bd100dfc4) ([merge request](gitlab-org/gitlab!145901))
- [Inspect start_branch_name if provided](gitlab-org/gitlab@54cf87270109b7d543f9f1a5c072effe54f5ab6b) ([merge request](gitlab-org/gitlab!139351))
- [Fix search within Environments folder](gitlab-org/gitlab@0e5e87e49c10e97969c7c187641f77878beb35db) ([merge request](gitlab-org/gitlab!146154))
- [Move focus to "What's new" drawer when opened](gitlab-org/gitlab@7e43fee0fc7df835a889c19eb3328b1a9ce7b7b7) ([merge request](gitlab-org/gitlab!144873))
- [Fix page overflow with long MR titles](gitlab-org/gitlab@4200b87ff685151ac389cf3241187fbcaa18a948) ([merge request](gitlab-org/gitlab!146103))
- [Release fetching all npm package tags](gitlab-org/gitlab@9031573c52bddcf17f20b8e563caf1c603d38565) ([merge request](gitlab-org/gitlab!144434))
- [Update Duo Pro Card to to show Add seats button for SM](gitlab-org/gitlab@6d19053750ea2f35f5bf2080fc6595981aed6aa3) ([merge request](gitlab-org/gitlab!145689)) **GitLab Enterprise Edition**
- [Supply the sequence name to the partitioning helper](gitlab-org/gitlab@644125eb09bbbc31dbbe52669527a8c13e478b3b) ([merge request](gitlab-org/gitlab!146065))
- [Fix autocomplete issue on design management comment form](gitlab-org/gitlab@b670c06fa8b594fd7155e492e3daa8580177dc31) ([merge request](gitlab-org/gitlab!146047))
- [Run specs with elastic_clean trait](gitlab-org/gitlab@cd71206c3b9f31199697d27806c111c206ba5d4f) ([merge request](gitlab-org/gitlab!145771))
- [Fix link to check out MRs locally](gitlab-org/gitlab@f7cca629e378d524cea27065f9530cf04c10bc9c) ([merge request](gitlab-org/gitlab!146041))
- [Do not raise CI lint exception if repository is empty](gitlab-org/gitlab@9a38817ff55f0f628238e0a76e20a59c1a20f066) ([merge request](gitlab-org/gitlab!145801))
- [Remove memoization for existing_sequence](gitlab-org/gitlab@ee5d8e912816d403f123eb1c0dd3824ceb2cfa16) ([merge request](gitlab-org/gitlab!146027))
- [Fixes missing "cancel" job button in admin jobs](gitlab-org/gitlab@2f8e8a1757733592d882c7d0224d4040cca6eaa1) ([merge request](gitlab-org/gitlab!146024))
- [Fix line highlighting](gitlab-org/gitlab@3df369cf54cb7c17c3a383545688ccc243d05106) ([merge request](gitlab-org/gitlab!146019))
- [Fix auth to dependency proxy with service account](gitlab-org/gitlab@9405a79b02255f917942442af1aff6454ffe15a0) ([merge request](gitlab-org/gitlab!146012))
- [Add SaaS check when fetching instance member roles](gitlab-org/gitlab@00a6aaff31941c18f979006d865cef3913458578) ([merge request](gitlab-org/gitlab!145094))
- [Proposed format changes for CI/CD Analytics](gitlab-org/gitlab@388ba9840241e7c233eba1e1e94e81ba5e45ed83) ([merge request](gitlab-org/gitlab!141307))
- [Include epic events on Profile page heat map](gitlab-org/gitlab@bc7602f7ca163ad03ec87889b37cabae071cf144) by @zzaakiirr ([merge request](gitlab-org/gitlab!138688))
- [Manage external issue tracker links to Vulnerabilities using events](gitlab-org/gitlab@a80b6a445c5171857fd97b1ba4874e42309e5370) ([merge request](gitlab-org/gitlab!145563)) **GitLab Enterprise Edition**
- [Change DuoChat z-index value to put it behind the feedback modal](gitlab-org/gitlab@96f283f2c5d4a06f1194cf90ebbc85f618c27180) ([merge request](gitlab-org/gitlab!145802)) **GitLab Enterprise Edition**
- [Check merge request's head_sha pipeline instead of latest](gitlab-org/gitlab@fd9980a6110598c4abc8f37db631e9674488ecfd) ([merge request](gitlab-org/gitlab!144919)) **GitLab Enterprise Edition**
- [Expose auth_method for remote mirrors via API](gitlab-org/gitlab@7d2177d947f48440211d49a3ac30c5405a369a21) ([merge request](gitlab-org/gitlab!75155))
- [Fix container repositories checksum mismatch errors](gitlab-org/gitlab@8a631409ceac9eaf66248741f7e31e2a47899c6d) ([merge request](gitlab-org/gitlab!145869)) **GitLab Enterprise Edition**
- [Make enum consistent to vulnerability enum](gitlab-org/gitlab@c9388aa1d7687098f0b5c82d7d444b54a5dafbc3) ([merge request](gitlab-org/gitlab!144849)) **GitLab Enterprise Edition**
- [Change query for assignee users to autocomplete query](gitlab-org/gitlab@49edefe573d4fbfb7d7cf8cd5e61b9a5aec95c00) ([merge request](gitlab-org/gitlab!145370))
- [Fix composability of `:published_event` with `:not_publish_event`](gitlab-org/gitlab@fe7cd8a3035beb4874f22df82e0bf59f34afdf86) ([merge request](gitlab-org/gitlab!144777))
- [Fixes duplicate users in search suggestions](gitlab-org/gitlab@384a98956d5ea3fe900a6854f7edf2edd66ba80f) ([merge request](gitlab-org/gitlab!145818))
- [Fix boolean and number input types](gitlab-org/gitlab@a4032ae6aef2e5dbd8a63b5a78fa3b334ab8e98f) ([merge request](gitlab-org/gitlab!145257))
- [Google Chat: Support inline replies](gitlab-org/gitlab@1ae2e61298b8a0463a570ff6ba16969356f87c82) by @robbie-demuth ([merge request](gitlab-org/gitlab!145187))
- [Web IDE Link: Hide button if empty](gitlab-org/gitlab@0daf8bf5c20d703cbf81c6c8799fee8bb13c0bef) ([merge request](gitlab-org/gitlab!145812))
- [Fix multi-line highlighting](gitlab-org/gitlab@34fa08685dbdaa41375ec5615609be7f925af4d3) ([merge request](gitlab-org/gitlab!144884))
- [Use `pre-wrap` to both preserve whitespace and wrap long lines](gitlab-org/gitlab@3e109880ebfee0754bb8172fe8dee15bf89a2b4f) ([merge request](gitlab-org/gitlab!145482))
- [Use sentence case for VSA Lifecycle metric titles](gitlab-org/gitlab@0040d58416ccc7a66e88c43b94d457b9f6cf56a1) ([merge request](gitlab-org/gitlab!145717)) **GitLab Enterprise Edition**
- [Fixes bug where Geo servers may leave orphaned Upload rep. stuck](gitlab-org/gitlab@c77566920dd7297a47b30942169b1b75f721ce87) ([merge request](gitlab-org/gitlab!142456)) **GitLab Enterprise Edition**
- [Update proxied request to use secondary for push_from_secondary](gitlab-org/gitlab@b93ec88eb37294778f70a8dc32cb8ce4aa665650) ([merge request](gitlab-org/gitlab!143980)) **GitLab Enterprise Edition**
- [Fix alert showing for unlimited schedules](gitlab-org/gitlab@b4e5516ce87a9d15393ea1ac984285c3687d143e) ([merge request](gitlab-org/gitlab!145695))
- [Add support for sidebar, example and openblock in AsciiDoc](gitlab-org/gitlab@ef0d0f9724d4cecb0ec5d0aa58b2dd9fb601841e) ([merge request](gitlab-org/gitlab!145379))
- [Fixed contributor count metric in VSD comparison table](gitlab-org/gitlab@328077d72a2cfa5fb2db63e4186ba59169317cd8) ([merge request](gitlab-org/gitlab!145682)) **GitLab Enterprise Edition**
- [Fix popover position for dependency list export](gitlab-org/gitlab@30ef0993c537c4d823df04ac774bc741fbd08fb9) ([merge request](gitlab-org/gitlab!145604)) **GitLab Enterprise Edition**
- [Increase packages_pypi_metadata keywords text limit](gitlab-org/gitlab@3b877ebf6a2e059e8b936a2fd3f69a64da1a4d94) ([merge request](gitlab-org/gitlab!144983))
- [Re-introduce drop user_interacted_projects table](gitlab-org/gitlab@574d864290ad35d20d33bce9198a6d22d9ce67c9) ([merge request](gitlab-org/gitlab!145260))
- [Do not remove indentation when pasting in code block](gitlab-org/gitlab@6c59aad2decc096a62deb2f2e515732499509160) ([merge request](gitlab-org/gitlab!143793))
- [Geo: Fix incorrect return values](gitlab-org/gitlab@f1a3391ad943e58217fc9e5a47794f217378d533) ([merge request](gitlab-org/gitlab!145616)) **GitLab Enterprise Edition**
- [Hide roles and permissions page from admin area when in SaaS mode](gitlab-org/gitlab@507361069cbadfe3766b748fe10242fde0aa264d) ([merge request](gitlab-org/gitlab!145262)) **GitLab Enterprise Edition**
- [Fix required approvals for mixed policies](gitlab-org/gitlab@86fc8568572466a532fe3971bb21d185e1c839f2) ([merge request](gitlab-org/gitlab!145572)) **GitLab Enterprise Edition**
- [Handle projects not found in Zoekt indexer worker](gitlab-org/gitlab@2c00ff21679c4287cef16853b86b62df8696b31d) ([merge request](gitlab-org/gitlab!145571)) **GitLab Enterprise Edition**
- [Handle a deletion of deployments for the removed repository](gitlab-org/gitlab@0c85dc6160d74f71ca0f2b81e6482ec86b61d772) ([merge request](gitlab-org/gitlab!145498))
- [Fix link anchors for synthetic system notes](gitlab-org/gitlab@ea1ffd2245d28861070dc1246b1b2ac3222983a5) ([merge request](gitlab-org/gitlab!145489))
- [Fix issue with uploading images sometimes](gitlab-org/gitlab@3c4c967a57ebf122be0d595a2c05ba9ce0f68029) ([merge request](gitlab-org/gitlab!144131))
- [Merge when checks pass should not need a pipeline to merge](gitlab-org/gitlab@5a9f0ac851aa4ba2e0b6ac7a2dbc5b381ca00f0c) ([merge request](gitlab-org/gitlab!144553))
- [Fix participants query in MR list page](gitlab-org/gitlab@a031162213a98d77dbd1089f2af1fc12dee7e4d8) ([merge request](gitlab-org/gitlab!145381))
- [Fix Container Registry Path](gitlab-org/gitlab@b77ae8639d0266b7a9364735f1cf3015cbcda68a) ([merge request](gitlab-org/gitlab!145389))
- [Job status: Add missing status text to GraphQL query](gitlab-org/gitlab@322aefda8599d1a915c6ab8db320daba1f2e0273) ([merge request](gitlab-org/gitlab!145139))
- [Improve show/hide logic of cube query generation frontend](gitlab-org/gitlab@2d149b9f695d86f5bec5f029a9de39ce99066f17) ([merge request](gitlab-org/gitlab!144415)) **GitLab Enterprise Edition**
- [Ensure errors.css is interpreted as UTF-8 encoding](gitlab-org/gitlab@b936a1d344d49bce1af09f92826dc152b77129d1) ([merge request](gitlab-org/gitlab!145363))
- [Keep code dropdown open when focusing clone inputs](gitlab-org/gitlab@d74e986b2ea8ae7be698b8583b5ef37fcabaf500) ([merge request](gitlab-org/gitlab!145304))
- [Fixed Shows branch name in non-blobs scopes](gitlab-org/gitlab@d60e1385ef64c13ff3aa50dc19a8cf624f3b0fac) ([merge request](gitlab-org/gitlab!142406))
- [Fix policy bot comment layout](gitlab-org/gitlab@8ba7c0fb55574c644db6fcfd5b023e93be69bcfb) ([merge request](gitlab-org/gitlab!145282)) **GitLab Enterprise Edition**
- [Fix overwriting the SOURCE_CODE variable in Code Quality](gitlab-org/gitlab@428327f364a601a9baff09be3fff6a1689e0fb0f) ([merge request](gitlab-org/gitlab!143018))
- [Emoji picker height in user edit profile page](gitlab-org/gitlab@88ac0ac0f404fd3525abedb57f6fe1779d15cf91) ([merge request](gitlab-org/gitlab!145240))
- [Fix highlight worker event ordering](gitlab-org/gitlab@a77f9e9ff46699fba0a95661d98f5bc75f33b206) ([merge request](gitlab-org/gitlab!145148))
- [Fix vulnerabilities seeder](gitlab-org/gitlab@cb8875c1aac0a1b7d7b4f01982de20aa0ba01640) ([merge request](gitlab-org/gitlab!145163))
- [Don't escape query in "Search or go to..." modal twice](gitlab-org/gitlab@d95bd7aa30d138d210f350201c34b52b799f5af6) by @syvb ([merge request](gitlab-org/gitlab!145158))
- [Mark issuable-resource-links as unique on create](gitlab-org/gitlab@463db89eb519aaddab6e64ada70b83a013be9a86) by @tomasz.skorupa ([merge request](gitlab-org/gitlab!143642)) **GitLab Enterprise Edition**
- [Fix queue purge security scans migration](gitlab-org/gitlab@426115c8c59e705c594777189fec6bba8e2886d0) ([merge request](gitlab-org/gitlab!145130))
- [Enable user/group pages access when namespace_in_path is enabled](gitlab-org/gitlab@5850113d14e830fe431a0d63dd42dd108f9a6d1e) ([merge request](gitlab-org/gitlab!144576))
- [Pipeline Status: Add aria-label](gitlab-org/gitlab@a50d244cf3a00c93be3c8094106282848bf87225) ([merge request](gitlab-org/gitlab!144969))
- [Adds the empty string fallback for organization description field](gitlab-org/gitlab@fa45b4f92de9e4448ce93a4f422f4544a6e3fa35) ([merge request](gitlab-org/gitlab!144896))
- [Check the actual bytesize of a Sentry JSON payload](gitlab-org/gitlab@48507d54bbfa735bd2847f35621c6d283ba6c332) ([merge request](gitlab-org/gitlab!112813))
- [Fix delete text on attach file toolbar button](gitlab-org/gitlab@60b5695e70f54bf34e4a37b95183cee0ceffc166) ([merge request](gitlab-org/gitlab!145034))
- [Profile page: Fix whitepsace  issue](gitlab-org/gitlab@c7e996f8f952bcabf79dd36f808a813a3a40aa7b) ([merge request](gitlab-org/gitlab!144955))
- [Fix boolean and number input types](gitlab-org/gitlab@24dabbb7d60819b209d1563c0d60e748620ec6af) ([merge request](gitlab-org/gitlab!144065))
- [Make `/clear_weight` work when weight is 0](gitlab-org/gitlab@dcc5068812cdb5c849bc00a46b6122476eed4065) ([merge request](gitlab-org/gitlab!145002)) **GitLab Enterprise Edition**
- [Adds users_organization_path to the organization home page](gitlab-org/gitlab@32e24b3baad4766d5d2a90cdef030da0efb01407) ([merge request](gitlab-org/gitlab!144878))
- [Make bundler-checksum work with RubyGems 3.5.6](gitlab-org/gitlab@f0de0f34901266750794bebddb60b10e8d0d642a) ([merge request](gitlab-org/gitlab!144985))
- [Repository: Fix code owners question icon color](gitlab-org/gitlab@0994efe550d105aa35695dc3d316ba0e7c0051ad) ([merge request](gitlab-org/gitlab!144634)) **GitLab Enterprise Edition**
- [Board - Fix creating issue in board scoped to iteration](gitlab-org/gitlab@1101bb89195da41aaa5911c02816744b9eae6e4b) ([merge request](gitlab-org/gitlab!144689)) **GitLab Enterprise Edition**
- [Add conditional operator to check for descriptionVersion being null](gitlab-org/gitlab@7236bc723087c919d6e3371112fcc90a88015d38) ([merge request](gitlab-org/gitlab!144949))
- [Mark code_suggestions as ignored](gitlab-org/gitlab@1ee566f4caecd01b118b6909ec0041a3c110b7ef) ([merge request](gitlab-org/gitlab!144892))
- [Fix alert showing for guest/reporter](gitlab-org/gitlab@3b2bb2575bbc00ef5321cc6c9825398fecf9a8ce) ([merge request](gitlab-org/gitlab!144901))
- [Project list item: Fix avatar spacing and alignment](gitlab-org/gitlab@7d2a4cc4714d0b89c079cb65db02021967c6e686) ([merge request](gitlab-org/gitlab!144898))
- [Add a safeguard against non-matching diff discussion positions](gitlab-org/gitlab@a9b42a7e2785101d696b1ec5b354aea8c2f313d3) ([merge request](gitlab-org/gitlab!144865))
- [Prevent policy bot message on non-applicable branches](gitlab-org/gitlab@4b3f6a0657b1979cd6534e0e87f168eab72d6c3f) ([merge request](gitlab-org/gitlab!144863)) **GitLab Enterprise Edition**
- [Set correct state for Apply button after action](gitlab-org/gitlab@ca45668160caf3e27be3c3a48c5211731b55524b) ([merge request](gitlab-org/gitlab!144862)) **GitLab Enterprise Edition**
- [Scope rejected projects query for better performance](gitlab-org/gitlab@f1ce9c5b24f969fc3cf8d6a76eff3a5323292f96) ([merge request](gitlab-org/gitlab!144047)) **GitLab Enterprise Edition**
- [Hide "email a new issue" on archived issues lists](gitlab-org/gitlab@eaaf0f1247a129d4b9fc5082f768b98cb14fe2b2) ([merge request](gitlab-org/gitlab!144058))
- [Consider pipelines with supported sources for MR approval policy](gitlab-org/gitlab@0b08e35779b472f4dc0dd9270a1c917e09156541) ([merge request](gitlab-org/gitlab!144825)) **GitLab Enterprise Edition**
- [Fix Search::Zoekt.index? logic](gitlab-org/gitlab@c8f7bbc7848ea348f5688ce430616fedecc2c898) ([merge request](gitlab-org/gitlab!144592)) **GitLab Enterprise Edition**
- [Remove `gl-z-index-200` from inline findings icon](gitlab-org/gitlab@518a6557ee95299af1d99dc0e3481954a72b0bac) ([merge request](gitlab-org/gitlab!144771)) **GitLab Enterprise Edition**
- [Reintroduces error tracking approximate user count](gitlab-org/gitlab@f1ac7ef970c590d98f84428f5652c0255b847372) ([merge request](gitlab-org/gitlab!144384))
- [Rename security dashboard graphql error alert](gitlab-org/gitlab@c7e343d4a7b0ae11bb0edd5019e75067588f13f8) ([merge request](gitlab-org/gitlab!144775)) **GitLab Enterprise Edition**
- [Fix including CI files in pipeline execution policy](gitlab-org/gitlab@089e07e8439caab0a8d25235670cb19abbcf9e2c) ([merge request](gitlab-org/gitlab!144727)) **GitLab Enterprise Edition**
- [Ignore compliance CI config when source is on-demand DAST scan](gitlab-org/gitlab@7638eb2383826bf63fd19d08502ea76669a71a3b) ([merge request](gitlab-org/gitlab!144307)) **GitLab Enterprise Edition**
- [Merge request checks: Fix right alignment of actions](gitlab-org/gitlab@a8cb6a80e0b8690965f2eea0097e5897a2f2853c) ([merge request](gitlab-org/gitlab!144724))
- [Readme: Fix anchor overflow behavior when collapsed](gitlab-org/gitlab@98f6b8c22097e0d584356f946946ecb9b2671b35) ([merge request](gitlab-org/gitlab!144571))
- [Update pages ci templates - Doxygen](gitlab-org/gitlab@3ccebc465ca01fb8cd3fc89f620cbf12898e2584) ([merge request](gitlab-org/gitlab!144317))
- [Fix Geo: Personal snippets not syncing](gitlab-org/gitlab@14b1af7e3b39179375439e9fc888eadc2bd51b8d) ([merge request](gitlab-org/gitlab!143456)) **GitLab Enterprise Edition**
- [Vulnerability Details: Fix code-snippet rendering](gitlab-org/gitlab@62dc1de6a55d21daa3942bb192a7c23fe6bdc2e4) ([merge request](gitlab-org/gitlab!144444)) **GitLab Enterprise Edition**
- [This MR fixes alignment](gitlab-org/gitlab@1763ec36864731b13c539689a4286c130f483e3b) ([merge request](gitlab-org/gitlab!144348)) **GitLab Enterprise Edition**
- [Add error recovery for package metadata sync](gitlab-org/gitlab@501075e19485de53c93b0405c10cc0c15149fcc5) ([merge request](gitlab-org/gitlab!144090))
- [Readmore shadow: Fix darkmode](gitlab-org/gitlab@329bcd9481289403f255ad386b55b24b8557e037) ([merge request](gitlab-org/gitlab!144568))
- [Fix GitLab for Slack app disabled when uninstalled](gitlab-org/gitlab@7de79ac28efecdd4388b54a7bcea66e009b30cf3) ([merge request](gitlab-org/gitlab!144544))
- [Add spacing to "Awaiting user signup" badge](gitlab-org/gitlab@986a26854a510b25ec0e855228b07c146bfbd792) by @yonghyun.jin13 ([merge request](gitlab-org/gitlab!141181))
- [Fix the name of a missing svg for the tests reports](gitlab-org/gitlab@52121f27ea34d66d6823f171a72dc2a3175a39cb) ([merge request](gitlab-org/gitlab!144362))
- [Changes the empty state illustation from CI/CD Analytics](gitlab-org/gitlab@4e39718b157492c0a256e003ec912caab632c816) ([merge request](gitlab-org/gitlab!144487))
- [Fix error from using `inputs` in some cases](gitlab-org/gitlab@ba97ac19e27fb650c9cc33d72181bff666c2874d) ([merge request](gitlab-org/gitlab!144497))
- [Fix deny_all_requests_except_allowed of AddressableUrlValidator](gitlab-org/gitlab@3d9f595d1b1a4f057c37770ac2ee0312c0b6e8a7) ([merge request](gitlab-org/gitlab!144488))
- [Fix File Browser height update on merge request tab change](gitlab-org/gitlab@e23549d421fc5692abfa2763b85a5a25793f840e) ([merge request](gitlab-org/gitlab!144458))
- [Account for typed code block responses from the LLM](gitlab-org/gitlab@2028e11ad4ad51cc1ecee021816b9134936947e3) ([merge request](gitlab-org/gitlab!144358)) **GitLab Enterprise Edition**
- [Make variable value listbox searchable](gitlab-org/gitlab@9b91529d6a563c3f7ad3d6ebde84bfda1d67bd43) ([merge request](gitlab-org/gitlab!143529))
- [Hide exposed artifacts when there are none](gitlab-org/gitlab@650e8107815f8eb6479bc13882aefdd854ad8cf7) ([merge request](gitlab-org/gitlab!143698))
- [Fix permissions check for runner usage by project](gitlab-org/gitlab@f72ecedc94a50668080bff83ce05593aa2adc4f6) ([merge request](gitlab-org/gitlab!143352))

### Changed (207 changes)

- [Change pipeline schedule button text](gitlab-org/gitlab@a2ea0248f57d9fb27a3f61d62d445592790efcca) ([merge request](gitlab-org/gitlab!147058))
- [Update MR empty states](gitlab-org/gitlab@d221a84ca42f98af1173ba65de862294197370a3) ([merge request](gitlab-org/gitlab!146708))
- [Updated the texts in the Protected environments under CI/CD Settings tab](gitlab-org/gitlab@b5ef5f805320d28a015d65a53e5d794b0aa40c0d) by @antonkalmykov ([merge request](gitlab-org/gitlab!147035)) **GitLab Enterprise Edition**
- [Projects: Improve pending deletion visibility and message](gitlab-org/gitlab@5b26f9c384db51533fe3ad69ea2e4d086062ca3e) ([merge request](gitlab-org/gitlab!146082))
- [Audit member access on destroy](gitlab-org/gitlab@38aacd015273bcfe45ea46f24c821de1c4ab73fd) ([merge request](gitlab-org/gitlab!146908)) **GitLab Enterprise Edition**
- [Design management add ability to toggle comments](gitlab-org/gitlab@e8e2aa5fbe895b3ce187bf3b9f08bf394b994760) ([merge request](gitlab-org/gitlab!146290))
- [Clarify audit event type script text](gitlab-org/gitlab@300e410878b6da70c6ff5ffe69580264b7a38706) ([merge request](gitlab-org/gitlab!146960))
- [Improve error message when job is missing an artifact](gitlab-org/gitlab@7639c2c7db731f1be98938d695ae9e1a9c3ad847) ([merge request](gitlab-org/gitlab!146941))
- [Disable release button for catalog resources](gitlab-org/gitlab@bf1f6ad7428842cf7d5784d13f29aaf783b415bc) ([merge request](gitlab-org/gitlab!145701))
- [Guided setup for Google Cloud IAM integration - 3](gitlab-org/gitlab@0f503f650d1dafcd70beb2dd4a10749f4ccbcc80) ([merge request](gitlab-org/gitlab!146174)) **GitLab Enterprise Edition**
- [This MR changed default state for policy scope](gitlab-org/gitlab@5fba32dab3df4627a93b7e975637662abb3b35a5) ([merge request](gitlab-org/gitlab!146210)) **GitLab Enterprise Edition**
- [Update todo and notifications for work items](gitlab-org/gitlab@25b37bd1f36113598ffaefd407f49218361a2c4b) ([merge request](gitlab-org/gitlab!145711))
- [Update commits empty state](gitlab-org/gitlab@88dd091d81f98187d9283d577e93f1df8e184489) ([merge request](gitlab-org/gitlab!146531))
- [Update kubernetes cluster empty state](gitlab-org/gitlab@ca986649138437d15b79ca4f804adf60c5756886) ([merge request](gitlab-org/gitlab!146358))
- [Added new columns and removed unwanted not null constraint](gitlab-org/gitlab@86f299d430d36db4a645c7c16bf8870896ee71f8) ([merge request](gitlab-org/gitlab!144882)) **GitLab Enterprise Edition**
- [Allow milestones to be specified by full path](gitlab-org/gitlab@d7d326b6d944bc30b0a33473a7e4eb24dcbefa3c) ([merge request](gitlab-org/gitlab!143859))
- [Assign default security policy stage](gitlab-org/gitlab@03591fa30b5c95e47a855593465cb0ff47457a9e) ([merge request](gitlab-org/gitlab!145914)) **GitLab Enterprise Edition**
- [Improve environments dashboard](gitlab-org/gitlab@40d007dd394da43c5b901db2cb315a8e45773c05) ([merge request](gitlab-org/gitlab!146258)) **GitLab Enterprise Edition**
- [Update frontend versioning](gitlab-org/gitlab@d3176d6895dc2cc27ce7dbd82e0de698480e2a75) ([merge request](gitlab-org/gitlab!146479))
- [Decouple dark color mode from navigation themes](gitlab-org/gitlab@66f9b887e601d888602aabe211454958616ffeb2) ([merge request](gitlab-org/gitlab!141459))
- [Update UI text](gitlab-org/gitlab@d7311e818cceba40f4496d8db7ef73f51fbc2b6d) by @jrachelr1 ([merge request](gitlab-org/gitlab!146432))
- [Modified source of the current scope](gitlab-org/gitlab@5d3c0e4371d195f77bb5c6c9f2f6fd2c7b1c17c3) ([merge request](gitlab-org/gitlab!146338))
- [Align merge request sticky header with static header](gitlab-org/gitlab@ab1a618aedbdc2c5ca6a778d599df8a8710c4c57) ([merge request](gitlab-org/gitlab!146809))
- [Change column null for `traversal_ids` of the `vulnerability_reads`](gitlab-org/gitlab@932600ee31623be2fe86ca92a19a45c971f36d9b) ([merge request](gitlab-org/gitlab!146800))
- [Migrate sbom_components.name so to match PEP 503](gitlab-org/gitlab@78b9a6025f5a61d2488ad1234fd9a2f914bea824) ([merge request](gitlab-org/gitlab!145700))
- [File header: Use variable instead of magic number](gitlab-org/gitlab@6b0d3eeed0afb8a0c839fb099c10b59eb69c7620) ([merge request](gitlab-org/gitlab!145229))
- [apps/pipeline_details: Copy full commit id](gitlab-org/gitlab@8c3b60c2108da8f72fad2f56ac660a567f7301cf) ([merge request](gitlab-org/gitlab!146052))
- [User profile sidebar: Fix alignment of user details](gitlab-org/gitlab@8a6ae0886b6b5ed81258765373acb183a2f5a6a5) ([merge request](gitlab-org/gitlab!146747))
- [Expose policy_scope in security policy graphql API](gitlab-org/gitlab@b052611c1d1b8a627622c165ec4482baae72a058) ([merge request](gitlab-org/gitlab!146562)) **GitLab Enterprise Edition**
- [Update compare empty state](gitlab-org/gitlab@728033c0efc1527cd05ec49b0af38012fef097da) ([merge request](gitlab-org/gitlab!146525))
- [Rename variable to CI_SERVER_FQDN to match expected value](gitlab-org/gitlab@ed5eb77c8cb130e573e0ad96961f4a778cb7e8d9) ([merge request](gitlab-org/gitlab!146461))
- [Remove cached_conflicts_with_types feature flag](gitlab-org/gitlab@ba3b70e080869ecbb7df80553f5fc7b83fb6200f) ([merge request](gitlab-org/gitlab!146738))
- [Correctly style labels in filtered search](gitlab-org/gitlab@890398b954a1efb9df5d71f715b195bc90ddc932) ([merge request](gitlab-org/gitlab!143780))
- [Update docs to clarify framework removal](gitlab-org/gitlab@fc75ad770f7e9158fe6a16f95f17fc5eeb21db9d) ([merge request](gitlab-org/gitlab!146704)) **GitLab Enterprise Edition**
- [Projects: Improve archived visibility and message](gitlab-org/gitlab@b1050e939f0d671bdf52b9a6eaaee1841a007f1d) ([merge request](gitlab-org/gitlab!145277))
- [Removes database migrations up to 16-1-stable-ee](gitlab-org/gitlab@c9d9a3bb5c6f249075f63c7d4fbd3feed9df1ab6) ([merge request](gitlab-org/gitlab!144364))
- [Update service desk empty state illustration](gitlab-org/gitlab@f47c45dfbeb001518aef3cd5bcecb30959d58ece) ([merge request](gitlab-org/gitlab!146549))
- [Update surface alerts empty state illustration](gitlab-org/gitlab@f8873fccddf20b5e6844aac99d534b10a8e47026) ([merge request](gitlab-org/gitlab!146534))
- [Guided setup for Google Cloud IAM integration - 2](gitlab-org/gitlab@3773915b528f23e3081555c67b4b15841712ba24) ([merge request](gitlab-org/gitlab!145543)) **GitLab Enterprise Edition**
- [Only show epic lane header shadow when it overlaps](gitlab-org/gitlab@d473fee4fd5cc144181037a76a0cc7f0f1fd51d2) ([merge request](gitlab-org/gitlab!146421)) **GitLab Enterprise Edition**
- [Use new ScalarValidator for variables CI keyword](gitlab-org/gitlab@65684085897b3c3daf717d3155936ffce6a26c7b) ([merge request](gitlab-org/gitlab!146503))
- [Billing page does not scale with large font sizes](gitlab-org/gitlab@eb845e4ae2d5806a4be249b42df0393a6359c36d) ([merge request](gitlab-org/gitlab!146668)) **GitLab Enterprise Edition**
- [Removes testable method from EWM](gitlab-org/gitlab@40e558363e07e6b3bca5e9303f65a3edfcc278ce) ([merge request](gitlab-org/gitlab!146636))
- [Change todo re-add button icon and title](gitlab-org/gitlab@918f2933adc729d6737aee5bc0167a10b59b91a4) ([merge request](gitlab-org/gitlab!146254))
- [Update Terraform modules empty state illustration](gitlab-org/gitlab@848d69f63b4c59ae51a71e92ffed80955b75a1c2) ([merge request](gitlab-org/gitlab!146487))
- [Remove merge_request_diff_generated_subscription feature flag](gitlab-org/gitlab@d3f0486be4473cbe3f93b21ca4a35902c81fe6c8) ([merge request](gitlab-org/gitlab!146580))
- [This MR adds validation for policy scope](gitlab-org/gitlab@5989bdd2b2e951bdb0663fb5b78866118e04e982) ([merge request](gitlab-org/gitlab!145871)) **GitLab Enterprise Edition**
- [Keeps compliance frameworks for project transfers](gitlab-org/gitlab@657c47cd46bfc9f3c12f3d0a3a34f1e8ea0f6fcf) ([merge request](gitlab-org/gitlab!146533)) **GitLab Enterprise Edition**
- [Update incident empty state illustration](gitlab-org/gitlab@781b87bc22f484156b1847bafbff537d8e81607c) ([merge request](gitlab-org/gitlab!146537))
- [Consolidate all google cloud support feature flags into one](gitlab-org/gitlab@aeb368e8f67d68274cdda70177328ddff424ddb6) ([merge request](gitlab-org/gitlab!145918)) **GitLab Enterprise Edition**
- [Guided setup for Google Cloud IAM integration - 1](gitlab-org/gitlab@efc4b630c9b912dc9415758dcca769d5f8d7d85a) ([merge request](gitlab-org/gitlab!146028)) **GitLab Enterprise Edition**
- [Update to redis-client v0.21.0](gitlab-org/gitlab@fccd704cd2409e0cb21db495b4dcc865162401ef) ([merge request](gitlab-org/gitlab!146506))
- [Update profile empty state](gitlab-org/gitlab@b7e7e087f28bbca8441106e8b5678c74307d14c8) ([merge request](gitlab-org/gitlab!146490))
- [Update UI text replacing 'catalog resource' with 'catalog project'](gitlab-org/gitlab@289eedc11b43c1cfcc96cfc7a07a1a4d563e38cc) ([merge request](gitlab-org/gitlab!146077))
- [Add environments empty state illustration](gitlab-org/gitlab@05b2c427d55fae41bac374f431eb308a4a1e3300) ([merge request](gitlab-org/gitlab!146323))
- [Swap columns auto_canceled_by for p_ci_builds](gitlab-org/gitlab@51a6865cd17c6bd49354426aab768e511a7b3d4b) ([merge request](gitlab-org/gitlab!144845))
- [Remove sort direction sync between columns on vulnerability report](gitlab-org/gitlab@ce614adbb30fc8c64fc1e8d7528d62ec981ead85) ([merge request](gitlab-org/gitlab!146466)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.86.0](gitlab-org/gitlab@9089b269766ccfab11ef50cccef2e21984d3449b) ([merge request](gitlab-org/gitlab!146362))
- [Remove "ref_extract_sha256" feature flag](gitlab-org/gitlab@7e5ae6d6dac929cc94e4bb9df65c0285fe72456d) ([merge request](gitlab-org/gitlab!146355))
- [Backfill traversal_ids and archived to sbom_occurrences](gitlab-org/gitlab@6a422c6e02e16f3b8b6be544e07eb81ada7fe2d1) ([merge request](gitlab-org/gitlab!144802))
- [Update copy for trials/duo_pro/new](gitlab-org/gitlab@1fb2a8d3189d9c7b097a9684d14563fd46807220) ([merge request](gitlab-org/gitlab!145810)) **GitLab Enterprise Edition**
- [Add a link to the starrer's page on project stars in the CI/CD catalog](gitlab-org/gitlab@215ba918fad59d989c47b1cb4ca93e1796498b0c) by @antonkalmykov ([merge request](gitlab-org/gitlab!144781))
- [Expands adherence report group by dropdown](gitlab-org/gitlab@1e6a819972e5365c86f966bc01934d8f7302d350) ([merge request](gitlab-org/gitlab!144688)) **GitLab Enterprise Edition**
- [Update docs for security_approval_policies_limit application setting](gitlab-org/gitlab@247ef6ea819213983ad910d80cc443d7ef51c84f) ([merge request](gitlab-org/gitlab!146178))
- [Add safe rel attribute on links with target "_blank"](gitlab-org/gitlab@2e8037f5198072593a7c61148c8bc74b61c36cc7) ([merge request](gitlab-org/gitlab!145516))
- [Update MR sidebar reviewer status icons](gitlab-org/gitlab@de50202ed1aecc822791a6162f616bc00f303447) ([merge request](gitlab-org/gitlab!146237))
- [Expose policy_scope in policy graphql API](gitlab-org/gitlab@09e869ff19d792dbc8c4603e39af8a5b21e1a601) ([merge request](gitlab-org/gitlab!142248)) **GitLab Enterprise Edition**
- [Rename Google Artifact Registry integration](gitlab-org/gitlab@b5f665e86a79625852f29a2c66752cf2f7ff649e) ([merge request](gitlab-org/gitlab!145529)) **GitLab Enterprise Edition**
- [AI docs: explicitly mention use of HTTPS](gitlab-org/gitlab@006fe0e80023f3d354fa93865300a46484c44902) ([merge request](gitlab-org/gitlab!146194))
- [Default enable FF include_manual_to_pipeline_completion](gitlab-org/gitlab@b6d9b3e1626f5e8a27e674fb14f5ee1cc79f5e17) ([merge request](gitlab-org/gitlab!146100)) **GitLab Enterprise Edition**
- [Add image size recommendation to avatar settings](gitlab-org/gitlab@fd98b5647d244bb9ab0f8f81b486b137088a83f8) ([merge request](gitlab-org/gitlab!145418))
- [Allow adding an Organization to an User Namespace](gitlab-org/gitlab@65e4d11e147c09a70565993a1062cde1cfe23742) ([merge request](gitlab-org/gitlab!144049))
- [Allow /help to accept either page title in front matter or in Markdown](gitlab-org/gitlab@b13518baf1f74865bd811e9107d2dc0a7b55214e) ([merge request](gitlab-org/gitlab!145627))
- [Update scaler and overlay color on design detail](gitlab-org/gitlab@fc77cced42e59de58e4b29d753b0e4528d95e669) ([merge request](gitlab-org/gitlab!145153))
- [Link fast-forward Merge Requests to deployment](gitlab-org/gitlab@979a7f19da5834d6272bc2c94030ad37503c0a7f) ([merge request](gitlab-org/gitlab!145211))
- [Mark vulnerabilitiesRemoveAllFromProject mutation as stable](gitlab-org/gitlab@cd06c9a442a8340c4e4428381902fa75fed9ed0e) ([merge request](gitlab-org/gitlab!146125)) **GitLab Enterprise Edition**
- [Replace geo-replication-empty illustration](gitlab-org/gitlab@6e850f35e39c3547ab1528c0b0a40d2df75198a0) ([merge request](gitlab-org/gitlab!144665)) **GitLab Enterprise Edition**
- [This MR adds new properties for toggle_list](gitlab-org/gitlab@7f06af55b260c17627fe9794d5c77ac641caeccc) ([merge request](gitlab-org/gitlab!145548)) **GitLab Enterprise Edition**
- [Improve Google Cloud IAM integration UI text](gitlab-org/gitlab@2fdc58840c714e637caa4970871018799d1f7035) ([merge request](gitlab-org/gitlab!145535)) **GitLab Enterprise Edition**
- [Rollout zoekt_cache_search_responses feature](gitlab-org/gitlab@49d4a9163ba4a9e2b65ddfefc61c100532ce61b0) ([merge request](gitlab-org/gitlab!146085)) **GitLab Enterprise Edition**
- [This MR select all reset option](gitlab-org/gitlab@ade7828071bbd7f879a0948b6704f880b5215d5b) ([merge request](gitlab-org/gitlab!145874)) **GitLab Enterprise Edition**
- [Render project name with namespace in runner usage](gitlab-org/gitlab@8673d2b3d39c8de524920d18c548610f6775e5e7) ([merge request](gitlab-org/gitlab!145151)) **GitLab Enterprise Edition**
- [Design management - Move issue title](gitlab-org/gitlab@df0fec3009f0d89d0ff9cbb78e203936aa9ab02f) ([merge request](gitlab-org/gitlab!145878))
- [Change security pipeline execution policy stages strategy](gitlab-org/gitlab@8ac1d6f071f520f4329d76d9e6ee0e437d760cae) ([merge request](gitlab-org/gitlab!145136)) **GitLab Enterprise Edition**
- [Cleanup update_vuln_reads_traversal_ids_via_event FF](gitlab-org/gitlab@b073ad51ccb9470c4225457477f2279faa9c81cd) ([merge request](gitlab-org/gitlab!145430)) **GitLab Enterprise Edition**
- [Emphasize integration reset button](gitlab-org/gitlab@761185ebac73dceae5cc69c7f479e883a4f002c7) ([merge request](gitlab-org/gitlab!146045))
- [Activity feed: Make content better searchable](gitlab-org/gitlab@e408f410c069049f33bbe49255e295e858aeb4c6) ([merge request](gitlab-org/gitlab!145540))
- [Remove outdated illustrations](gitlab-org/gitlab@8b0acb8f862d8f13411bba5c26da7e32e72ceec8) ([merge request](gitlab-org/gitlab!146043))
- [Pipeline MiniGraph dropdown: Keep open when modifier is pressed](gitlab-org/gitlab@8920145ad81a08adc2a9693fdaec3d59643cedd4) ([merge request](gitlab-org/gitlab!146030))
- [Project/Group overview: Add settings link to kebab menu](gitlab-org/gitlab@57ebda215bbf27f2360a1b3a103cf38886bc969e) ([merge request](gitlab-org/gitlab!145239))
- [Add optional project labels to keep-around ref metrics](gitlab-org/gitlab@f54ae894c9f778a5a448312c49fe49b860d73ac9) ([merge request](gitlab-org/gitlab!145988))
- [Add option to keep shared groups when filtered by parent](gitlab-org/gitlab@d8e65143b0e464cfc0aa1a1d7c51250f331e48bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/141462)) **GitLab Enterprise Edition**
- [Use pluralized string for Job/Jobs count label on jobs/pipelines page](gitlab-org/gitlab@46bce5fdcbda80cbd8c028a8e966de4152f848b5) by @antonkalmykov ([merge request](gitlab-org/gitlab!145731))
- [Make the date format consistently across the CI/CD Catalog](gitlab-org/gitlab@a6db118290802a2b0471362820ddd3a391668d57) by @antonkalmykov ([merge request](gitlab-org/gitlab!145729))
- [Redact SAMLResponse from logs](gitlab-org/gitlab@ec6757d64db8567ea0d486816067f62e489e8f7d) ([merge request](gitlab-org/gitlab!144732))
- [Darken light blue and green theme for contrast](gitlab-org/gitlab@cff5ca48903b919af5cbca744a4e25517e962617) ([merge request](gitlab-org/gitlab!145815))
- [Add illustration to Value Stream Analytics empty state](gitlab-org/gitlab@0225ddc22fd59537de8552bc354df8a622ad2722) ([merge request](gitlab-org/gitlab!145868))
- [Upgraded Web IDE to 0.0.1-dev-20240226152102](gitlab-org/gitlab@dac076d55d4c3e488080ef88deefd5cc12238d6d) ([merge request](gitlab-org/gitlab!145900))
- [Added namespace actor to PA billing feature flag](gitlab-org/gitlab@63b15bdab9aab6c041161adaf7fce4cc02942d52) ([merge request](gitlab-org/gitlab!145116)) **GitLab Enterprise Edition**
- [Update design management discussion as per new UX](gitlab-org/gitlab@b8ca254afd0ec5d357aecfdb894bf647c9c18d34) ([merge request](gitlab-org/gitlab!145011))
- [Add color_mode_id column to users table](gitlab-org/gitlab@2ff7f2616984e455fd00fa0e5d1f572874b7b77c) ([merge request](gitlab-org/gitlab!142772))
- [Allow /help to accept either index.md or _index.md as a docs index page](gitlab-org/gitlab@1be8d7c707febb07987558fce7e21efbcebf3c81) ([merge request](gitlab-org/gitlab!144419))
- [Update regex for normalize_pypi to align with](gitlab-org/gitlab@b191ad6ccf65e9756d646a301618b4c287c777f6) ([merge request](gitlab-org/gitlab!145393))
- [Cleanup free_user_cap_over_limit_email FF](gitlab-org/gitlab@6273551f112a258787c580fc6c39f9efd96b2fbe) ([merge request](gitlab-org/gitlab!145707)) **GitLab Enterprise Edition**
- [Add prefix to Operations::FeatureFlagsClient#token](gitlab-org/gitlab@0ef1fadd62b116373874995a179bdc1802f1cf00) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144703))
- [Use skeleton loader for artifacts loading state](gitlab-org/gitlab@02b44144c0dc937aff74649c3e8c4ceaab1a6fcd) ([merge request](gitlab-org/gitlab!143218))
- [Additional cleanup for external usernames on oAuth and LDAP sign up](gitlab-org/gitlab@fdba060146a5952726d02d036eca8581ba6b022e) ([merge request](gitlab-org/gitlab!145038))
- [Design management - Move todo button](gitlab-org/gitlab@26a73723334f87e2fbe2035fb1109dad41fa446e) ([merge request](gitlab-org/gitlab!145736))
- [Update Cloud Connector architecture blueprint](gitlab-org/gitlab@95a9b949b67aaadaca04868a52555b73631b8cf8) ([merge request](gitlab-org/gitlab!145220))
- [Replace manual and failed pipeline illustrations](gitlab-org/gitlab@3bad95bb777af89f264056ade339033669125225) ([merge request](gitlab-org/gitlab!145650)) **GitLab Enterprise Edition**
- [Enable continuous container scanning by default](gitlab-org/gitlab@f85b3bd21829762f56d404ef9fdab7670e9554dd) ([merge request](gitlab-org/gitlab!145723)) **GitLab Enterprise Edition**
- [Default enable FF search_index_all_projects](gitlab-org/gitlab@9172ba05d3613e967a468d4956a4298c182bdb69) ([merge request](gitlab-org/gitlab!145300)) **GitLab Enterprise Edition**
- [Replace milestone promotion banner with alert](gitlab-org/gitlab@c323a81ed4440b319b965ee2dfda30dc49e3c735) ([merge request](gitlab-org/gitlab!138597))
- [Update Rails to 7.0.8.1](gitlab-org/gitlab@92c0c5192703bbfa5ebdf36e6c9853d9268061f4) ([merge request](gitlab-org/gitlab!145667))
- [Update GITLAB_PAGES_VERSION](gitlab-org/gitlab@8bf8b553560e18925368a152322eb6a652a720fa) ([merge request](gitlab-org/gitlab!145634))
- [Update version outdated text](gitlab-org/gitlab@5cc715a24c1aba10c53d1db07f4bdbf5ae3cdc2a) ([merge request](gitlab-org/gitlab!145445))
- [Add approval group rule get endpoint](gitlab-org/gitlab@85492b1c18760a01bb15e94dc8b7096b3efab99b) ([merge request](gitlab-org/gitlab!144170)) **GitLab Enterprise Edition**
- [Reword Project.services field deprecation](gitlab-org/gitlab@13cb32e1248fec2221e9b36163b8ccbb7d4d0dec) ([merge request](gitlab-org/gitlab!145615))
- [Beautify groups](gitlab-org/gitlab@4019e3877369357157babc316f03e64290e25768) ([merge request](gitlab-org/gitlab!144921))
- [Use helpPagePath to Render terraform module registry links](gitlab-org/gitlab@4773c0f603cb93eb174be4fa1bbd3e698968ee03) by @jzeng88 ([merge request](gitlab-org/gitlab!145055))
- [Remove $white color to improve dark mode](gitlab-org/gitlab@b49bdefbcf5108f116d800bc34be4c170ccbc9ec) ([merge request](gitlab-org/gitlab!145590))
- [Update dependency auto-deploy-image to v2.85.0](gitlab-org/gitlab@834c41c7014781adfe7df55b3bd1ae1d50471f52) ([merge request](gitlab-org/gitlab!145557))
- [Remove backtrace silencer for app dir](gitlab-org/gitlab@9c6c0e73615151400634b5736edc0ac22783d007) ([merge request](gitlab-org/gitlab!145084))
- [Open Deployments tab when no K8s integration set for Environment](gitlab-org/gitlab@7b7cfa054db6acfbb187285a04720b1d7495e881) ([merge request](gitlab-org/gitlab!145287))
- [Enable custom_webhook_template by default](gitlab-org/gitlab@40d60e40802723553aad8c11ad01d7d1c5866014) by @Taucher2003 ([merge request](gitlab-org/gitlab!145514))
- [Profile page: Increase spacing after profile avatar](gitlab-org/gitlab@2528c9a773e7950e8d099cff1dd09e9125cdca03) ([merge request](gitlab-org/gitlab!145487))
- [Clean up successful free_trial_registration_redesign experiment](gitlab-org/gitlab@578e07da6d39d24e6af01fd3a9ef144e62e1b721) ([merge request](gitlab-org/gitlab!145235)) **GitLab Enterprise Edition**
- [Remove feature flag and update docs](gitlab-org/gitlab@1bf2cb1e157a8d45a3cd699ebd24970e64de1704) ([merge request](gitlab-org/gitlab!145366))
- [Add ability to unsubscribe from design management notifications](gitlab-org/gitlab@bb1596a3594d06ff28345bb21122274c89afb9a0) ([merge request](gitlab-org/gitlab!144247))
- [Make sign in tabs fully Pajamas compliant](gitlab-org/gitlab@e7e211edc7a9baf0067d25b6719cc24379e9588b) ([merge request](gitlab-org/gitlab!145238))
- [Remove Gitlab.com check for ContainerRepository#size](gitlab-org/gitlab@b6659019f631d443da33907a2d6910174fbb8b5a) ([merge request](gitlab-org/gitlab!144917))
- [Add Search::Zoekt::Task](gitlab-org/gitlab@9e53a29fe3878b86a826493e7e32fb32b889df04) ([merge request](gitlab-org/gitlab!143063))
- [This MR extend compliance framework list](gitlab-org/gitlab@7d458862e69543ddd175c9541ac4fd25280c3bc9) ([merge request](gitlab-org/gitlab!145051)) **GitLab Enterprise Edition**
- [GCP WLIF script improvements](gitlab-org/gitlab@562e2bcaf6234a20e0de1196497abe7f11d44ad9) ([merge request](gitlab-org/gitlab!144818)) **GitLab Enterprise Edition**
- [Show more specific error messages](gitlab-org/gitlab@80fa7fe57c2e8021a2970f0077df27711e54fbf6) ([merge request](gitlab-org/gitlab!145140))
- [Add logos to JetBrains integrations](gitlab-org/gitlab@1f32dccc4cc2f9f84391ff902050a3d6d0e4164d) ([merge request](gitlab-org/gitlab!145149))
- [Update default bot comment text when approvals required](gitlab-org/gitlab@3aec41edf9d4de5c306254dc602ad1fa8ac00e2d) ([merge request](gitlab-org/gitlab!143717)) **GitLab Enterprise Edition**
- [Clean up encoding_logs_tree FF](gitlab-org/gitlab@dafd046609ee79dac9531ddf0b73f002da8e28a8) ([merge request](gitlab-org/gitlab!145242))
- [Update column title](gitlab-org/gitlab@410d00f738fa70a525e79486cc4d8dd59b5e7199) ([merge request](gitlab-org/gitlab!145079))
- [Renaming column type to category for external audit event destinations](gitlab-org/gitlab@1fc1ae33e39862feeb6c7f01489b863f874a5f87) ([merge request](gitlab-org/gitlab!144994)) **GitLab Enterprise Edition**
- [Add additional analytics dashboard user events](gitlab-org/gitlab@4d33a2150ead4078cdab85a6094483e47f4db41e) ([merge request](gitlab-org/gitlab!144850)) **GitLab Enterprise Edition**
- [Moves full stop out of "Learn More" link](gitlab-org/gitlab@cfd3fce24eadce307bc880020ef315e643f0e302) by @r2abreu ([merge request](gitlab-org/gitlab!145192))
- [Replace cluster_popover illustration](gitlab-org/gitlab@68fdc2a29ec09b6faa15d3238fa8eecfd242b852) ([merge request](gitlab-org/gitlab!145185))
- [Declare service_access_tokens table clusterwide](gitlab-org/gitlab@97aaf7ac774249a34f29c8e58637bd8303a35383) ([merge request](gitlab-org/gitlab!145157))
- [Fix emoji picker](gitlab-org/gitlab@d1faa6d12980f407d5d72eadb2de86e244f52b18) ([merge request](gitlab-org/gitlab!144977))
- [Design management - Update layout of image preview](gitlab-org/gitlab@675403ae0874b08a0af73302d292d04ad81d90b5) ([merge request](gitlab-org/gitlab!144550))
- [Update branch rules via global id](gitlab-org/gitlab@a730a2af6201b7757f66101a50fa3cdf53cfbcd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144632)) **GitLab Enterprise Edition**
- [Fix pull lfs files issue](gitlab-org/gitlab@f913a7709d370f68fb2681958b5f81f73c1947b0) by @chaomao ([merge request](gitlab-org/gitlab!145114)) **GitLab Enterprise Edition**
- [Use entity full_path for page title / breadcrumbs](gitlab-org/gitlab@90a8358de64ed3091a0cb93898c7a11909528796) ([merge request](gitlab-org/gitlab!145112))
- [Clarified work items FF naming](gitlab-org/gitlab@81c20d2c9d2276f4ac8a8edfed6dce9799a4f12d) ([merge request](gitlab-org/gitlab!144141))
- [Epic boards - Display Ancestors in sidebar when subepics are allowed](gitlab-org/gitlab@a99ae25fc7522b34373d826fc2241d1be995e7a3) ([merge request](gitlab-org/gitlab!145092)) **GitLab Enterprise Edition**
- [Backfill non-instance admins into the organization users table](gitlab-org/gitlab@f784aa8c573f918c3e9249540a2577c0f007653c) ([merge request](gitlab-org/gitlab!144674))
- [Switch repository backups to use manifests only](gitlab-org/gitlab@81871c9a1451cce33eb2e078c57d8bc7618502c7) ([merge request](gitlab-org/gitlab!144677))
- [Remove the Kubernetes overview section from the Environments page](gitlab-org/gitlab@c4c98e8e0d3696574978b09ab62fec770c480ee7) ([merge request](gitlab-org/gitlab!144799))
- [Implement BranchRules::UpdateService](gitlab-org/gitlab@d4289fcb5e12358c9f3f5969031d6dd655f70fec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144630))
- [Change route for /details to /failures with id](gitlab-org/gitlab@627d9b00ad48264b42b935698a8aa3e7ceccfce6) ([merge request](gitlab-org/gitlab!143904))
- [Add form validation for cube query generation input](gitlab-org/gitlab@6bd72dc87ef319444bc31429a14f5a5c8e1c4b81) ([merge request](gitlab-org/gitlab!144146)) **GitLab Enterprise Edition**
- [Update repositories analytics empty states](gitlab-org/gitlab@61fe290457749aa35d4afcd3d2149386b38aff0a) ([merge request](gitlab-org/gitlab!144794)) **GitLab Enterprise Edition**
- [Expand sidekiq queue_groups to default](gitlab-org/gitlab@658da0610c5b22b84f89452aec0441dc77819782) ([merge request](gitlab-org/gitlab!142577))
- [Change `vulnerabilities.finding_id` column to NOT NULL](gitlab-org/gitlab@34772c2ca6742c08b059bb93b9367d3a8c195695) ([merge request](gitlab-org/gitlab!140989)) **GitLab Enterprise Edition**
- [Pipeline MiniGraph: Migrate dropdown to GlDisclosureDropdown](gitlab-org/gitlab@677bf84e6da0b3c6044bcaac0d849fbe21b85d17) ([merge request](gitlab-org/gitlab!144606))
- [Changed Terraform Modules history wording](gitlab-org/gitlab@d333bad70a2fa12fabf667c833ff0c7c94f4d00d) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144945))
- [Fix bitbucket spread cal job](gitlab-org/gitlab@aeb47d1fb039c758ba36ffe4d0a2f93b1a149076) by @imskr ([merge request](gitlab-org/gitlab!143815))
- [Update dependency auto-deploy-image to v2.83.0](gitlab-org/gitlab@a0959e69590f3d7e507943f58cc48caa58c00058) ([merge request](gitlab-org/gitlab!144826))
- [Refactor compliance frameworks export backend](gitlab-org/gitlab@d08f0385ab3700c3a7db80664e7fd791bf9522c0) ([merge request](gitlab-org/gitlab!144915)) **GitLab Enterprise Edition**
- [Fix blurry avatar in profile](gitlab-org/gitlab@3c2337946dcbac75603a9475f899e072b23e4dbd) ([merge request](gitlab-org/gitlab!144448))
- [Clean up promote_ultimate_features experiment](gitlab-org/gitlab@872f590928af5451e6902a71d334b8c2b4a5bd4a) ([merge request](gitlab-org/gitlab!144513)) **GitLab Enterprise Edition**
- [Now allowing expired trials to see Trial Discover Page](gitlab-org/gitlab@fb0118da47716650afdc5d0dfce06a7987c4a3e8) ([merge request](gitlab-org/gitlab!144904)) **GitLab Enterprise Edition**
- [Route projects by root namespace id](gitlab-org/gitlab@6583846f71e2d30434058c0cf7bb1ec84f68ea08) ([merge request](gitlab-org/gitlab!143212)) **GitLab Enterprise Edition**
- [Open "Create Slack app" link in new tab](gitlab-org/gitlab@9cf51675f38552e621e6432fdf37f8768e7e41fe) ([merge request](gitlab-org/gitlab!144885))
- [api/runners: Expose `maintenance_note` in details and editing](gitlab-org/gitlab@7b1af91226ba2ce3f6db523f3fcc0254592b32e1) ([merge request](gitlab-org/gitlab!144482))
- [Code dropdown: Migrate to GlDisclosureDropdown](gitlab-org/gitlab@9ab2803420becc67589be5979439e6aaa469bf80) ([merge request](gitlab-org/gitlab!143324))
- [User profile: Show 7 achievements instead of 3](gitlab-org/gitlab@653d2949f79e40d77908a57b669a3ce67272e1cd) ([merge request](gitlab-org/gitlab!144453))
- [Reorders work item sidebar widgets](gitlab-org/gitlab@040e80bce5db879fca047e64d87125c1afd041ba) ([merge request](gitlab-org/gitlab!143707))
- [Adjust environment and sync status badges on environments page](gitlab-org/gitlab@2cda9c5802a9d3787c553f0d82ebe2dcf55c3c8d) by @antonkalmykov ([merge request](gitlab-org/gitlab!144486))
- [Use color for protected/default branches/tags (#439551)](gitlab-org/gitlab@9db61fa943bb55622860f78e25b7a0253425e45c) by @abh80 ([merge request](gitlab-org/gitlab!143398))
- [Use createdAt instead of releasedAt](gitlab-org/gitlab@cea397f6460ea5acd8369db9d3b8c27f6039d1a4) ([merge request](gitlab-org/gitlab!144789))
- [Update cube query generation UI](gitlab-org/gitlab@969ea9d1c16df9993158cd99f44477fe777d79c4) ([merge request](gitlab-org/gitlab!144148)) **GitLab Enterprise Edition**
- [Update sha method depending of release presence](gitlab-org/gitlab@7c3a7cdb23417751176cef593d7dd6d955558e69) ([merge request](gitlab-org/gitlab!144175))
- [Fixing rubocop exceptions in tests](gitlab-org/gitlab@3695ddb1f7399d32d919c2ca9508787905c5d388) ([merge request](gitlab-org/gitlab!144589))
- [Rename "Runner" header to "Runner configuration"](gitlab-org/gitlab@1a26aaa3f15259890741215076e3ce7dc8a36291) ([merge request](gitlab-org/gitlab!144216))
- [workhorse: Downgrade incomplete multipart uploads to 400 errors](gitlab-org/gitlab@f85f72255c9bd8d9d3f63a1aa3f2ceae495d0546) ([merge request](gitlab-org/gitlab!144710))
- [Remove redundant "runner statuses" popover in the runners list](gitlab-org/gitlab@7ef740fca0b92292b062bc9922a581b8df7a5d98) ([merge request](gitlab-org/gitlab!144343))
- [Sort personal projects on profile page by last_activity_at](gitlab-org/gitlab@eea414d5709cb8d25bc94ab80c96892ce9596ed6) ([merge request](gitlab-org/gitlab!144309))
- [Unify collapse\expand all unresolved threads action](gitlab-org/gitlab@04143ecfedde8b70727874f1e5175650df527616) ([merge request](gitlab-org/gitlab!136034))
- [Improve environments dashboard](gitlab-org/gitlab@3fb0db611b5faa615565d5cd9a839a33fac06a88) ([merge request](gitlab-org/gitlab!142747))
- [Enable `group_level_dependencies_filtering` by default](gitlab-org/gitlab@0b43ebd13a7afc20b94b546e14e8e05fd10de0b0) ([merge request](gitlab-org/gitlab!144668)) **GitLab Enterprise Edition**
- [Abbreviate long numbers in groups/projects list](gitlab-org/gitlab@8f5bdcbf015eb459418e341a56a27a4e892be1cf) ([merge request](gitlab-org/gitlab!144074))
- [Remove namespace validation for policy_scope](gitlab-org/gitlab@e29824a6b9a36a93f5ed0b8b2364a5671548292f) ([merge request](gitlab-org/gitlab!144491)) **GitLab Enterprise Edition**
- [Allow only top level groups for ApprovalGroupRules](gitlab-org/gitlab@e7928dc11522850791e753ca152ffe8255c29581) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144438)) **GitLab Enterprise Edition**
- [Dashboard: Use SingleStatComponent](gitlab-org/gitlab@ea8bcef820ac357c3766399ff076ed8a0e9af0d3) ([merge request](gitlab-org/gitlab!144447)) **GitLab Enterprise Edition**
- [Update redis-client to v0.20.0](gitlab-org/gitlab@099eb093032b3bfc1b8a59eb5eef0df2156e7bca) ([merge request](gitlab-org/gitlab!144620))
- [Use less ambiguous parameter names in CI lint API](gitlab-org/gitlab@043bc732c46c9453b52913fc2a824ede7e6aaf4e) ([merge request](gitlab-org/gitlab!143098))
- [Use Duo Chat for explain code feature](gitlab-org/gitlab@fe321c6b1c7c772f3f9079b6eedc51e6626c1afb) ([merge request](gitlab-org/gitlab!143217)) **GitLab Enterprise Edition**
- [Add tabs to Environment details page](gitlab-org/gitlab@6c021229c55cdf45c7787a59b139760e94a1397c) ([merge request](gitlab-org/gitlab!143865))
- [Truncate long dashboard descriptions on list page](gitlab-org/gitlab@8e4729ce031acfb431b039df5f84e720407a3155) ([merge request](gitlab-org/gitlab!144274)) **GitLab Enterprise Edition**
- [Populate topics slug column from name column](gitlab-org/gitlab@188e2c64cc2e4e4cc411783da74f64d70bfb7ce7) by @zzaakiirr ([merge request](gitlab-org/gitlab!141715))
- [Update layout and styling of billing/plan_component](gitlab-org/gitlab@7e3be144f84dfca7d2480a8faf2b174402d28902) ([merge request](gitlab-org/gitlab!142939)) **GitLab Enterprise Edition**
- [Update milestone banner illustration](gitlab-org/gitlab@b30970c3e092985a04bd66969fd16667dab25c1b) ([merge request](gitlab-org/gitlab!144044)) **GitLab Enterprise Edition**
- [Update alert settings tests](gitlab-org/gitlab@4dcfd3d40db22f6b416ee7d934eb181fd4085f35) ([merge request](gitlab-org/gitlab!144547))
- [Move color widget update to a callback](gitlab-org/gitlab@fb7759bfb3d57adf248e8c58a6446727c72b8b34) ([merge request](gitlab-org/gitlab!142335)) **GitLab Enterprise Edition**
- [Only allow group approval rules to be created by group admins](gitlab-org/gitlab@41196db8017bfc191ae11fdfd1b0eed2eeb78428) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144452)) **GitLab Enterprise Edition**
- [MR approval widget: Fix alignment](gitlab-org/gitlab@eb905a344ea9e7db5fce3d48756739bc2801a148) ([merge request](gitlab-org/gitlab!144465))
- [MR ready message: Fix alignments](gitlab-org/gitlab@ae428ea4f4c01475082013914b506a359a2a1b2f) ([merge request](gitlab-org/gitlab!144462))
- [Update UI text with purchasing instructions](gitlab-org/gitlab@f8a14f17473f072b95e7a5b49ae06b99505e8318) ([merge request](gitlab-org/gitlab!144275)) **GitLab Enterprise Edition**
- [Migrate todos empty state component](gitlab-org/gitlab@1f0909949255acc5404ee3d0c2a139d31ca70e90) ([merge request](gitlab-org/gitlab!144083))
- [Migrate applications empty state component](gitlab-org/gitlab@bf351b1f3a0d9585e2d8ab763b3f51a67f2318cc) ([merge request](gitlab-org/gitlab!144069))

### Removed (24 changes)

- [Remove auto fix worker with migration](gitlab-org/gitlab@ed2b69bdf691791ef760b63889adf832bd609025) ([merge request](gitlab-org/gitlab!147051))
- [Remove issues_completed_analytics_feature_flag FF](gitlab-org/gitlab@d8e43c2d9945088cbb3392f1cf6765dfafd75569) ([merge request](gitlab-org/gitlab!146766))
- [Remove unused EOA bronze banner code and feature flag](gitlab-org/gitlab@0706b210dbac418f5243b7003d51b4d4c674c7e2) ([merge request](gitlab-org/gitlab!146309))
- [Remove use_primary_for_update_computations FF](gitlab-org/gitlab@c5b800f6712e0427e54a84542ad51024a94f96c1) ([merge request](gitlab-org/gitlab!146287))
- [Remove ci_catalog_components_tab](gitlab-org/gitlab@094eff85500582bd06f300ed0010542b93e13366) ([merge request](gitlab-org/gitlab!146224))
- [Remove obsolete logic behind a feature flag](gitlab-org/gitlab@91941eb9bae3996aad91b019b4f54a1101b7fc9a) ([merge request](gitlab-org/gitlab!146188))
- [Drop `third_party_ai_features_enabled` column](gitlab-org/gitlab@6622480255721cf65cc381fbb8c1a219f1138817) ([merge request](gitlab-org/gitlab!145210))
- [Remove delayed project/group columns](gitlab-org/gitlab@d8fcdb1c1e58f15ca522ceb7f6fda91dade2676c) by @imskr ([merge request](gitlab-org/gitlab!144347))
- [Geo DB migrations to remove force_to_redownload column from 5 tables](gitlab-org/gitlab@e35e9f05db2e24e3607aafa2affafb70072061f3) ([merge request](gitlab-org/gitlab!144824)) **GitLab Enterprise Edition**
- [Drop temporary index on vulnerabilities table](gitlab-org/gitlab@35a3978a5664f26ae22b4707f4ffcd3c9bc3f8c6) ([merge request](gitlab-org/gitlab!143338))
- [Drop project_repository_states table](gitlab-org/gitlab@f36ef30b0a65efc88a2157612e89df587e4bcb36) ([merge request](gitlab-org/gitlab!145195))
- [Remove build hooks worker and associated code](gitlab-org/gitlab@543286bcf0a5f48a8576ecd6900f8a3735583337) by @Varedis ([merge request](gitlab-org/gitlab!144965))
- [Remove old finding modal from MR security widget](gitlab-org/gitlab@889c831d5400dc9a24dc3d8d89a4a8d34aa678d4) ([merge request](gitlab-org/gitlab!144341)) **GitLab Enterprise Edition**
- [Remove deprecated /code_suggestions/tokens endpoint](gitlab-org/gitlab@2e6e1b2a4b094678605556ec5d2a75108ca087ce) ([merge request](gitlab-org/gitlab!145052)) **GitLab Enterprise Edition**
- [Remove the user_interacted_projects table](gitlab-org/gitlab@8a280cc82aac0bc2e1db8880afe78a6b2ee7b51e) by @missy-davies ([merge request](gitlab-org/gitlab!139630))
- [Remove license_compliance_widget_category feature flag](gitlab-org/gitlab@7f9371979d149406a9fa1c0926101de11b6a1730) ([merge request](gitlab-org/gitlab!144989))
- [Remove upload_ready from pages deployment](gitlab-org/gitlab@b377d57acc7546240614be2b49b850bd2914ca31) by @imskr ([merge request](gitlab-org/gitlab!144962))
- [Removing feature flag audit_events_streaming_namespace_filter](gitlab-org/gitlab@5771e1e6a0567a33f03024c0c650a9fd35349388) ([merge request](gitlab-org/gitlab!144043)) **GitLab Enterprise Edition**
- [refactor: Drop col 'package_name_pattern_ilike_query' Part 2](gitlab-org/gitlab@3ba3e9b1ad96291295e0f88e42fc5973682ba6ae) by @gerardo-navarro ([merge request](gitlab-org/gitlab!142303))
- [Remove deprecated BulkImports::StuckImportWorker](gitlab-org/gitlab@122b73c8668fed51502fd3fef0629d69186709d3) ([merge request](gitlab-org/gitlab!143806))
- [Drop product_analytics_events_experimental table](gitlab-org/gitlab@93093d2bf1f30059421fe181b54e1d06c7ead8f4) ([merge request](gitlab-org/gitlab!144626))
- [Remove ci_guard_for_catalog_resources ff](gitlab-org/gitlab@c78d549c9134e3ad881b9a1b188f0ed7f58ee155) ([merge request](gitlab-org/gitlab!144583))
- [Delete the usage_data_api feature flag](gitlab-org/gitlab@b9376c3aa14676463d0d82c3807ade22b966f7bb) ([merge request](gitlab-org/gitlab!143973))
- [Clean up SafelyChangeColumnDefault for CI models](gitlab-org/gitlab@f8c38e13fb26516855a3efc35de195e55962af11) by @imskr ([merge request](gitlab-org/gitlab!143058))

### Security (15 changes)

- [Filter SAML saml_response](gitlab-org/gitlab@010d0a2266d27c6a53ccbbb008fb8fd9bba6f95b) ([merge request](gitlab-org/gitlab!146454))
- [Add client-side detection for GitLab tokens](gitlab-org/gitlab@74f56ea7291084db2cb54dd0335adfbdbac5c749) ([merge request](gitlab-org/gitlab!146757))
- [Reset approvals when reopening a MR](gitlab-org/gitlab@8ba5fe64e3d3b62fc8acbecbd2dd99df5694a8c7)
- [Restrict group token rotation for custom roles](gitlab-org/gitlab@18abfbc075083ec0921d47056c185f01478eaf0c)
- [Update rack to v2.2.8.1](gitlab-org/gitlab@4df84ee731b04079ccad24fb8327e0107abcb0eb) ([merge request](gitlab-org/gitlab!145473))
- [Ensure LDAP user cannot sign in with password](gitlab-org/gitlab@98fd29b8beb2d72adbb194f424eddbdd591a7e8d)
- [Invalidate markdown cache to clear up stored XSS](gitlab-org/gitlab@adec203de57cd370ee9985607919a3e48bc808d1)
- [Ensure LDAP users cannot reset local password to bypass LDAP](gitlab-org/gitlab@7a15c7669cbb8dc6bbd83ea0440b83fc9c8c7ca4)
- [Add a limit to CodeOwners reference extractor regex](gitlab-org/gitlab@17b51afe3c586b73d3933d93352ac722db6c2510)
- [Adds authorization for analytics settings](gitlab-org/gitlab@eaff749ab0ff501f1eae69ef7f3d5a141c02924c)
- [Fix Stored-XSS in user's profile page: Change markup used for pronouns](gitlab-org/gitlab@3672795fc9a3f5e4768320a53cad40d209afe3da)
- [Check project read access in Environments and Operations dashboard](gitlab-org/gitlab@b1a317f836d862f6c0872a3889a36285216f8482)
- [Disallow assigning higher role than current user](gitlab-org/gitlab@87273243752ebef58fda6bfdcb2be685e7318200)
- [Disallow users to modify deploy key title](gitlab-org/gitlab@200f3fe6905bb48dfd4517d98461ad935ec702c2)
- [Use merge_head_diff for codeowners when merge request is mergeable](gitlab-org/gitlab@7457a15973e913719461c0630d27c34b1dfae368)

### Performance (16 changes)

- [Use the AvatarCache for commits/events](gitlab-org/gitlab@581403c153acbdc1d1e322cd29d65d5b892e27cf) ([merge request](gitlab-org/gitlab!144739))
- [Reduce N+1 queries when approvals by committers are not allowed](gitlab-org/gitlab@9e7ef142b35f44ae5d559be9411e7047b148de8f) ([merge request](gitlab-org/gitlab!146297)) **GitLab Enterprise Edition**
- [Fix N+1 problems in Groups API](gitlab-org/gitlab@b34d6d8baa9f1702c3ba65324dfefa59059319ef) ([merge request](gitlab-org/gitlab!145906)) **GitLab Enterprise Edition**
- [refactor: Debounce GET requests for notes after submitting MR review](gitlab-org/gitlab@624ee38a5be85050c3b25f5521f2d48b6e572dd4) by @gerardo-navarro ([merge request](gitlab-org/gitlab!145177))
- [RegisterJobService will use partition pruning](gitlab-org/gitlab@ce908573c8a06bb242703bacf8148a72410f2d8d) ([merge request](gitlab-org/gitlab!145861))
- [Enable ci_parallel_remote_includes feature flag](gitlab-org/gitlab@fb8c2c6f5e500012cbea05e9af0912f68c870cf8) ([merge request](gitlab-org/gitlab!145784))
- [Remove duplicated indexes for source code](gitlab-org/gitlab@927cdb8b48303e59b64c576960393b998c0bb50d) ([merge request](gitlab-org/gitlab!145534))
- [Remove FF reading p_ci_pipeline_variables](gitlab-org/gitlab@383397e44a6a5f583bab1cfc4e8c6296c5f73991) ([merge request](gitlab-org/gitlab!145374))
- [Reduce N+1 queries when approvals by committers are not allowed](gitlab-org/gitlab@dcf09018965e1c356a8680fa77bedbcfbd9e1685) ([merge request](gitlab-org/gitlab!144860)) **GitLab Enterprise Edition**
- [Reduce N+1 queries when MRs has blocking MRs](gitlab-org/gitlab@ff912fd563fb49120ad8f9b061cc937228bea272) ([merge request](gitlab-org/gitlab!144944)) **GitLab Enterprise Edition**
- [Skip status preloads in pipeline lists](gitlab-org/gitlab@0a426914445e111a1243aff912e058f3801c860c) ([merge request](gitlab-org/gitlab!144783))
- [Cache private email regex for a request](gitlab-org/gitlab@46489a0f94596510475fe302fef714c43db15555) ([merge request](gitlab-org/gitlab!144644))
- [Remove unused index on ci_pipeline_metadata](gitlab-org/gitlab@bbb4eb3f5f65a30c6bfec7a4addf8cc6771c9dcf) ([merge request](gitlab-org/gitlab!140608))
- [Stop calculating if blob is binary on creation](gitlab-org/gitlab@df1a89383d09669270f1f98d5f13571124cb92a0) ([merge request](gitlab-org/gitlab!144115))
- [Removing FF track_ci_build_created_internal_event](gitlab-org/gitlab@1cba51150c772c0a6e07b471db6056a91f875c15) ([merge request](gitlab-org/gitlab!144091))
- [Preload downstream pipelines when serializing bridge jobs](gitlab-org/gitlab@45883cb4df3a2a62ab5e90f0f4c0917d7043c3f6) ([merge request](gitlab-org/gitlab!143546))

### Other (120 changes)

- [Remove `compliance_framework_report_ui` feature flag](gitlab-org/gitlab@f613bc6d34c2d06c027b0ea9b423cfebed5c69cf) ([merge request](gitlab-org/gitlab!147042)) **GitLab Enterprise Edition**
- [refactor: Fix typo in code](gitlab-org/gitlab@696d38721bccfe93cb6fbfc4dad106291ab940b5) by @gerardo-navarro ([merge request](gitlab-org/gitlab!147081))
- [Revert "Merge branch..."](gitlab-org/gitlab@07745e093497fc85d43387112cd0decee98d975f) ([merge request](gitlab-org/gitlab!147061))
- [Update job_artifacts queries to use partition_id filter](gitlab-org/gitlab@3699e9824f98e9b462553413595848dadf8a4286) ([merge request](gitlab-org/gitlab!145522))
- [Fix Workhorse linter warnings](gitlab-org/gitlab@a7d7e7d52cca84a836d6d986189f982f7fe4de95) ([merge request](gitlab-org/gitlab!146871))
- [Revert changes to import stages](gitlab-org/gitlab@fe80668eb8b0ec3d57fb32891ddd204b1951b65c) ([merge request](gitlab-org/gitlab!146812))
- [Migrate table to gl-table](gitlab-org/gitlab@26bc530f6ea4685f515e5808392f697e65d2728e) by @hsbhangu ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145618)) **GitLab Enterprise Edition**
- [Enables lock_retries by default in migrations](gitlab-org/gitlab@65ad9d77344fee470c4f8f39344df805888df518) ([merge request](gitlab-org/gitlab!135808))
- [Add cell local schema](gitlab-org/gitlab@631e338e7f169493f0236a3d1e29bb677b8dd0d3) ([merge request](gitlab-org/gitlab!146496))
- [refactor: Fix rubocop todos for maven package files](gitlab-org/gitlab@d1f395b6288fb3655849b9bbade03729aa3e23ee) by @gerardo-navarro ([merge request](gitlab-org/gitlab!145951))
- [Add missing sharding keys](gitlab-org/gitlab@121941b96e717d4a29a10b9bff1868345d473370) ([merge request](gitlab-org/gitlab!146607))
- [Clean up tmp FKs p_ci_stages](gitlab-org/gitlab@9fc2f3468fb97ca2714c39a21ec6c847d9403c0d) ([merge request](gitlab-org/gitlab!146598))
- [Add and validate FKs to p_ci_stages](gitlab-org/gitlab@0a63fc972c8ce42a02e90ad21421a021b04f1a80) ([merge request](gitlab-org/gitlab!146459))
- [Protected packages: Show alert message on fetching error](gitlab-org/gitlab@4aea495dcf70ab58860d5fd8e1d6af5306ac8bfb) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146473))
- [Clean up current_organization_middleware feature flag](gitlab-org/gitlab@8e9aecabb2ddedfec3695b1b08a58370a7d8103b) ([merge request](gitlab-org/gitlab!146527))
- [Validate uniqnuess of member role name](gitlab-org/gitlab@4af14e2cd1b78a7ac1fb72c93d29669b0a29c298) ([merge request](gitlab-org/gitlab!145294))
- [chore: Remove sidekiq_job_completion_metric_initialize feature flag](gitlab-org/gitlab@0ae3e714c0a3620460e463fb1b71f43f80027554) ([merge request](gitlab-org/gitlab!146497))
- [Improve handling group_path param](gitlab-org/gitlab@b04c7baf3c1100ef13a5df1d3d230e53ccc35442) ([merge request](gitlab-org/gitlab!145511))
- [Remove `security_findings_finder_lateral_join` FF](gitlab-org/gitlab@575962a50408eed8434414abaa5c4d24a9fc4381) ([merge request](gitlab-org/gitlab!145754)) **GitLab Enterprise Edition**
- [refactor: Fix rubocop issues in Pypi::CreatePackageService](gitlab-org/gitlab@726376b6dd7ddf062cb82bd9bbde35eb02c4605e) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146403))
- [Remove cron schedule for removed job](gitlab-org/gitlab@60525d4cc87554e7c0c456c6abd2c3d1202c919f) ([merge request](gitlab-org/gitlab!145938))
- [Protected packages: Return ServiceResponse for CreateMavenPackageService](gitlab-org/gitlab@951bc970ce553709d02cf81caada5a6b3cc51253) by @gerardo-navarro ([merge request](gitlab-org/gitlab!145076))
- [Remove assign_compliance_project_service feature flag](gitlab-org/gitlab@212283a3a27ee58c0ff2ffc6a47e2325403044c8) ([merge request](gitlab-org/gitlab!146331)) **GitLab Enterprise Edition**
- [Add cluster wide schema](gitlab-org/gitlab@206a512b463161dc5f5e274563a6809bf0e10aeb) ([merge request](gitlab-org/gitlab!146345))
- [Remove resolve_organization_groups feature flag](gitlab-org/gitlab@863cfe276028e69d9f88007967e777d1b29a743f) ([merge request](gitlab-org/gitlab!146320))
- [Backup and remove orphaned notes](gitlab-org/gitlab@ffcb25747f5794aaec5f64bfd89c92c3727d4f15) ([merge request](gitlab-org/gitlab!146023))
- [Backfill onboarding_status_step_url from orginal column](gitlab-org/gitlab@2ad007b5c1af1a973603f45a7219b3cc964426f1) ([merge request](gitlab-org/gitlab!145041))
- [Remove project_path_sort feature flag](gitlab-org/gitlab@0fbb3b34f341c0a22b9e182e3a06d5ae26de3157) ([merge request](gitlab-org/gitlab!146179))
- [Add sharding keys for application_instrumentation](gitlab-org/gitlab@756debd91cb6298d779ae308cfcc790eb19c468c) ([merge request](gitlab-org/gitlab!143308))
- [refactor: Fix rubocop issues for Npm::CreatePackageService](gitlab-org/gitlab@d2f2ef494f0822c0efb0e2fc62c5fdd81822543c) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146098))
- [Use defined table header across the module](gitlab-org/gitlab@54781db8307169aaa0e5627fd675f9c991841e2e) ([merge request](gitlab-org/gitlab!145412)) **GitLab Enterprise Edition**
- [Replace FKs for p_ci_stages](gitlab-org/gitlab@f07c52a3db3199d3ae36542dab25d47615e367e3) ([merge request](gitlab-org/gitlab!145899))
- [Add database transaction duration to logs](gitlab-org/gitlab@c80306a326e55b131b919f7bac80bc3ba0bdf72a) ([merge request](gitlab-org/gitlab!145775))
- [Add cell scope with sharding key](gitlab-org/gitlab@a8dfef77479f503b243b288d4ae1468aa7150bd6) ([merge request](gitlab-org/gitlab!146039))
- [Add next desired sharding keys for dynamic_application_security_testing](gitlab-org/gitlab@966fbc0df2ba1b892fdcda464d644675f163165f) ([merge request](gitlab-org/gitlab!145249))
- [Add next desired sharding keys for code_review_workflow](gitlab-org/gitlab@b0c6247a455f8bbb46e95aa7aecab8562b9bf6f2) ([merge request](gitlab-org/gitlab!146029))
- [Update schemas and shared keys for source_code_management](gitlab-org/gitlab@dce38caea6e92d926c7640c7bb240dca5bd35be8) ([merge request](gitlab-org/gitlab!144014))
- [Use data-testid instead of js- class for project approvals](gitlab-org/gitlab@746490b79cd9c9ba299eb5c47dadf67f1c9f99d8) ([merge request](gitlab-org/gitlab!145236)) **GitLab Enterprise Edition**
- [Remove geo_proxy_check_pipeline_refs feature flag](gitlab-org/gitlab@92929c83dcd47dc2980d8c35fca7c7d7a5dd0dfb) ([merge request](gitlab-org/gitlab!145864)) **GitLab Enterprise Edition**
- [Add visibility_level to organizations](gitlab-org/gitlab@edd4f2c77d8e8edec18a9d2fdc1580715dd2a307) ([merge request](gitlab-org/gitlab!145606))
- [Migrate search empty states and update banner illustration](gitlab-org/gitlab@fe7193e9efc74e00e893b667b4c4647da7eedb43) ([merge request](gitlab-org/gitlab!145191))
- [Add self-managed migration](gitlab-org/gitlab@32ba10481eb050b79504d805e18fa75cffec1619) ([merge request](gitlab-org/gitlab!144953))
- [Add cluster_wide schema to add_ons](gitlab-org/gitlab@064e0550359b5cfcbaa185c4278f32df843488f3) ([merge request](gitlab-org/gitlab!145824))
- [Update remote mirror failure email](gitlab-org/gitlab@c6b5161e6e268ae49708537899f2d11b54461627) ([merge request](gitlab-org/gitlab!145808))
- [Change gitlab_schema for user_credit_card_validations](gitlab-org/gitlab@e82cebd9b483d332f539276808c24753dc98a48f) ([merge request](gitlab-org/gitlab!145426))
- [Add clusterwide schema](gitlab-org/gitlab@2f7151569970d3cc244051219b338ff1c861cd3e) ([merge request](gitlab-org/gitlab!145673))
- [Ensure ID uniqueness on p_ci_stages](gitlab-org/gitlab@13af4ccec70624cf816ee682df8f3f38db9b5cf3) ([merge request](gitlab-org/gitlab!145778))
- [Enforce not-null constraint vs_code_settings uuid](gitlab-org/gitlab@040e9503ad3e79c2378b1873eed894be9c2f57c5) ([merge request](gitlab-org/gitlab!145427))
- [Remove identity_verification_auto_ban feature flag](gitlab-org/gitlab@806a5188e05f82c746eb79390422acc0cc580ead) ([merge request](gitlab-org/gitlab!145781)) **GitLab Enterprise Edition**
- [Making a quick action spec rely less on the frontend](gitlab-org/gitlab@48ec55748fad7eb0084a2b894fd0dbadefb4d969) ([merge request](gitlab-org/gitlab!142236))
- [Update Transfer Data project blueprint with new Clickhouse fields](gitlab-org/gitlab@7217f644fbe19cac2d6429df626d6ad344ee40a2) ([merge request](gitlab-org/gitlab!145675))
- [Allowing cross db transactions and joins between clusterwide and main](gitlab-org/gitlab@d292da30656bb010d26d3b0da102f22b6886fb59) ([merge request](gitlab-org/gitlab!145669))
- [Add and backfill project_id for cluster_agent_tokens](gitlab-org/gitlab@485282ac8e4289f116c3fc77efee8b6850bd9968) ([merge request](gitlab-org/gitlab!144939))
- [Delete service_desk_vue_list feature flag](gitlab-org/gitlab@58efa1d0f78a48371a2378d269d12651471d87db) ([merge request](gitlab-org/gitlab!144782))
- [Remove cron schedule for removed job](gitlab-org/gitlab@e8b6e3c14032385defacd72255aba1114221e4fd) ([merge request](gitlab-org/gitlab!145633))
- [Create routing table for ci_stages](gitlab-org/gitlab@ba2318027315fd2cddcbc014e3c6ed5941c8a0d8) ([merge request](gitlab-org/gitlab!145217))
- [Remove cron schedule for removed job](gitlab-org/gitlab@69ee1ebf4ca5fc26347ea6e339e2d95f5ad90dc7) ([merge request](gitlab-org/gitlab!145248))
- [Fix secret config validation](gitlab-org/gitlab@3b20dc278580bfe138d461daad0582131b948763) by @alberts-gitlab ([merge request](gitlab-org/gitlab!145490))
- [Remove arkose_labs_oauth_signup_challenge feature flag](gitlab-org/gitlab@792f0612de2e77d81a0e16f4bc3da608cba7e915) ([merge request](gitlab-org/gitlab!145225)) **GitLab Enterprise Edition**
- [Allow to persist Clickhouse state](gitlab-org/gitlab@5c814099985ff577f48a597059f64e4d67df5174) ([merge request](gitlab-org/gitlab!144918))
- [Remove `sync_project_archival_status_to_sbom_occurrences` feature flag](gitlab-org/gitlab@107d31db9b8595f97f64c4908ab46e55309b6fc7) ([merge request](gitlab-org/gitlab!145419)) **GitLab Enterprise Edition**
- [Introduce empty_tree_id to correctly work with SHA256 repository](gitlab-org/gitlab@bfab8988d9cf7712dc8e6b6b217bb7c04dc21efe) ([merge request](gitlab-org/gitlab!144494))
- [Refactor planning component currency symbol](gitlab-org/gitlab@c675d2173a23bbfbb5883ef686e7fd833190e1f4) by @chaomao ([merge request](gitlab-org/gitlab!145378)) **GitLab Enterprise Edition**
- [Remove `group_level_dependencies_filtering` feature flag](gitlab-org/gitlab@500892480ccf798e07654b86e64b57b46902b35c) ([merge request](gitlab-org/gitlab!144672)) **GitLab Enterprise Edition**
- [test: Fix wrong param for shared example 'error service response'](gitlab-org/gitlab@9103ced153fa5c901deae045c14b5451ed5957d4) by @gerardo-navarro ([merge request](gitlab-org/gitlab!145134))
- [Clean up tmp FKs p_ci_job_artifacts](gitlab-org/gitlab@e97208ffe95e4d29619061623b39177290cf32a2) ([merge request](gitlab-org/gitlab!145216))
- [Remove enable_new_sentry_clientside_integration](gitlab-org/gitlab@c54585488ccd84b2e0a738e41fea5c69a7068f5c) ([merge request](gitlab-org/gitlab!145276))
- [Add ClusterRepositoryCache class for migration](gitlab-org/gitlab@147ddbd512dc9e2ec5686e4d16bcd8168bebb242) ([merge request](gitlab-org/gitlab!144548))
- [Finalize backfill vs_code_settings column migrations](gitlab-org/gitlab@46a38c5d8ce1bf0a2d18d310ac94d10d5beab2de) ([merge request](gitlab-org/gitlab!145138))
- [Remove arkose_labs_trial_signup_challenge feature flag](gitlab-org/gitlab@1df16b97529aa3f0b0f0e2b86c11818e86af32cc) ([merge request](gitlab-org/gitlab!144834)) **GitLab Enterprise Edition**
- [Add next desired sharding keys for package_registry](gitlab-org/gitlab@ff7c2b5abd423d2333b7b908a16448da14c2dffd) ([merge request](gitlab-org/gitlab!145254))
- [Add next desired sharding keys for importers](gitlab-org/gitlab@76a2e668305ed30e3da9608f7af8d992552fd215) ([merge request](gitlab-org/gitlab!145252))
- [Add next desired sharding keys for feature_flags](gitlab-org/gitlab@818efece04995d92ffd2f7dfcee0db6b74a9111f) ([merge request](gitlab-org/gitlab!145251))
- [Add next desired sharding keys for source_code_management](gitlab-org/gitlab@3c42ee7b0207f258ef7c429315205adad5c8a62c) ([merge request](gitlab-org/gitlab!145250))
- [Cleanup bigint conversion for system_note_metadata](gitlab-org/gitlab@5c0539a14db6da96acdda5ed337afe9c9069353e) ([merge request](gitlab-org/gitlab!145125))
- [test: Refactor tests to leverage service response shared examples](gitlab-org/gitlab@175d0d1f31090dca7762005ebb8ab95a11edf428) by @gerardo-navarro ([merge request](gitlab-org/gitlab!145156))
- [Drop use_sync_service_token_worker FF](gitlab-org/gitlab@eae7739ac1c5d0eee0e78f53cbb19e87f34816ae) ([merge request](gitlab-org/gitlab!144871))
- [Validate FKs p_ci_job_artifacts self managed](gitlab-org/gitlab@6f2cb0fa3d3537c7b70a028cd3e09ef1e7ac2fa8) ([merge request](gitlab-org/gitlab!145111))
- [Remove feature flag ci_workflow_auto_cancel_on_new_commit](gitlab-org/gitlab@2933c5f713b4fb5146b228bcf0dfcbc243d264cb) ([merge request](gitlab-org/gitlab!145144))
- [Prepare partitioning constraint for ci_stages](gitlab-org/gitlab@0bd2a03b743d0360a45f42685106a5004abdec6a) ([merge request](gitlab-org/gitlab!145109))
- [Add temporary index for locating orphaned notes](gitlab-org/gitlab@d562735b899e4840cb2297022d2ebb0d83e0f14d) ([merge request](gitlab-org/gitlab!143928))
- [Remove references to code suggestions group setting](gitlab-org/gitlab@11753521b2d89348558b147ca5982eafca2ea238) ([merge request](gitlab-org/gitlab!145043)) **GitLab Enterprise Edition**
- [Remove update_organization_users feature flag](gitlab-org/gitlab@ae9679c3c3abb92dd7f5902f48db040f802837de) ([merge request](gitlab-org/gitlab!144997))
- [Add self-managed migration](gitlab-org/gitlab@b23c24529147cfbf081d36798b821327be5f8289) ([merge request](gitlab-org/gitlab!142037))
- [Use UpdateService, add more spec coverage](gitlab-org/gitlab@6e0431b9e7ede3594f4032fa2a03bbe819b6fb7f) ([merge request](gitlab-org/gitlab!144800)) **GitLab Enterprise Edition**
- [Clean up self-hosted sent_notifications bigint](gitlab-org/gitlab@5c412bfd9627abd764725dee631cf4dbf37ef377) ([merge request](gitlab-org/gitlab!142965))
- [Add desired sharding keys for importers](gitlab-org/gitlab@989706b5b11fc621265f5947113f995ab3b5d7e7) ([merge request](gitlab-org/gitlab!144856))
- [Add desired sharding keys for team_planning](gitlab-org/gitlab@5b25063b60e1edf94d4300bdc4c87fb77526cdc2) ([merge request](gitlab-org/gitlab!144855))
- [Remove FF dependency_scanning_on_advisory_ingestion](gitlab-org/gitlab@43f385c185b094b8ec874d5c7123dcf9e78db63c) ([merge request](gitlab-org/gitlab!144546)) **GitLab Enterprise Edition**
- [Remove proxy-through-com logic for CS](gitlab-org/gitlab@b76a68ce0b1dd827107ad78124a7079565d09586) ([merge request](gitlab-org/gitlab!144721))
- [Add violation_data to scan_result_policy_violations](gitlab-org/gitlab@2210af36a7988cc2bfe9817851aa51c576603c2b) ([merge request](gitlab-org/gitlab!144504))
- [Update the Kaniko template to make the job be extendible](gitlab-org/gitlab@62fbbb77c3c81cbabed7199824c032c3125ed522) by @kjetilho ([merge request](gitlab-org/gitlab!144352))
- [Ensure uniqueness p_ci_job_artifacts IDs](gitlab-org/gitlab@7433b17f0f311d289aaa1577c4d9b9893674058a) ([merge request](gitlab-org/gitlab!144574))
- [Rename CreateEmptyEmbeddingsRecordsWorker](gitlab-org/gitlab@d8c24152743d7d5cc00c034ab9db9bcdb9db419a) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144374)) **GitLab Enterprise Edition**
- [Add transaction check to ExclusiveLease](gitlab-org/gitlab@21994f1f62f70a3afc55b505a980ab517a016aa3) ([merge request](gitlab-org/gitlab!143321))
- [Remove ignore_column for project_import_level](gitlab-org/gitlab@f4891f738ef3ff0b9787a991c9a2277badcc1e00) ([merge request](gitlab-org/gitlab!144662))
- [Remove security_policies_sync_preexisting_state feature flag](gitlab-org/gitlab@331e33a9347988917ba2137535799e783af19ca6) ([merge request](gitlab-org/gitlab!144531)) **GitLab Enterprise Edition**
- [Fixes for MR Widget implementation and tests to support Vue compat](gitlab-org/gitlab@2cd2f8a45d2adb65638ea55480ca9943be2610d7) ([merge request](gitlab-org/gitlab!143485))
- [Remove unused code](gitlab-org/gitlab@29bb77e3c5b39706df09cc9906548598fe12d998) ([merge request](gitlab-org/gitlab!144604))
- [Rename EMPTY_TREE_ID constant](gitlab-org/gitlab@4babc79beb27c03c56301e40a047a243a2d71dee) ([merge request](gitlab-org/gitlab!144579))
- [Remove feature flag "store_object_format"](gitlab-org/gitlab@727577987734e018c0baa1c63d799de726a9f5a2) ([merge request](gitlab-org/gitlab!144628))
- [Update "Duo Pro" copy to "GitLab Duo Pro" in UI](gitlab-org/gitlab@f5ef5367a2a7fc39cea07afdbb5acac7a32f3da6) ([merge request](gitlab-org/gitlab!144461)) **GitLab Enterprise Edition**
- [Add patch for find_or_create_by](gitlab-org/gitlab@18e1855d5fd5f7e22c58a40fdf6f16540291185d) ([merge request](gitlab-org/gitlab!144457))
- [Add desired sharding keys for security_policy_management](gitlab-org/gitlab@3abb5e86fbcc4a7a59c59c08b671cdf49f659c9b) ([merge request](gitlab-org/gitlab!144470))
- [Remove feature flag security_policies_unenforceable_rules_notification](gitlab-org/gitlab@ab7862f7585854e48ad7cf28e1f530b3c8b64f4e) ([merge request](gitlab-org/gitlab!144468)) **GitLab Enterprise Edition**
- [Finalize UpdateDelayedProjectRemovalToNullForUserNamespaces migration](gitlab-org/gitlab@71bb14cb07479c40b8986c68dd7c9a388d8c91b7) ([merge request](gitlab-org/gitlab!144361))
- [Cleanup geo_pipeline_replication feature flag](gitlab-org/gitlab@32fb7a3ccc2d97bfeb60048b8519272e66015bc2) ([merge request](gitlab-org/gitlab!144549)) **GitLab Enterprise Edition**
- [Include prepared_at in the MR hook data](gitlab-org/gitlab@9cc77b735f037c2bd849b9fb76ca3435d4343080) ([merge request](gitlab-org/gitlab!143998))
- [Cleanup search_filter_by_ability feature flag](gitlab-org/gitlab@71c98ac1a359d099528b89d41aa3022abe0def72) ([merge request](gitlab-org/gitlab!144537)) **GitLab Enterprise Edition**
- [Add desired sharding keys for package_registry](gitlab-org/gitlab@530a5b438891aedf7a92ae414bb81e5d4eb0adc6) ([merge request](gitlab-org/gitlab!144476))
- [Add desired sharding keys for feature_flags](gitlab-org/gitlab@5f02c416dd9bad120799a2076dc6e262513cf6ff) ([merge request](gitlab-org/gitlab!144475))
- [Add desired sharding keys for dynamic_application_security_testing](gitlab-org/gitlab@f719300dc0cbafcee93776fa9b66800f14243b38) ([merge request](gitlab-org/gitlab!144474))
- [Add desired sharding keys for geo_replication](gitlab-org/gitlab@e5583c5d337ab47b8021c50f43cb0c0aa59d582e) ([merge request](gitlab-org/gitlab!144471))
- [Remove ci_job_token_groups_allowlist feature flag](gitlab-org/gitlab@1e192a7dcd317594757abebcf4f9872315e924ac) ([merge request](gitlab-org/gitlab!144258))
- [Add desired sharding keys for secrets_management](gitlab-org/gitlab@21d4784a4cf8162625aaf8e613935a648de56989) ([merge request](gitlab-org/gitlab!144211))
- [Remove select_ancestors_of_paginated_items feature flag](gitlab-org/gitlab@2bb9c584820424e33bca0524ebe2d49bd4ea29e3) ([merge request](gitlab-org/gitlab!143636))
- [Add sharding keys for auto_devops](gitlab-org/gitlab@320db1b8da1692fc61bc89f1c4b4e23dc87d0f00) ([merge request](gitlab-org/gitlab!143307))
- [Add sharding keys for code_review_workflow](gitlab-org/gitlab@f0ad99cc932bd74a5d02de99ee62651b32a34af2) ([merge request](gitlab-org/gitlab!143310))
- [Add sharding keys for system_access](gitlab-org/gitlab@62c2fd4788e62e46f1469e2f18d178840e8e3df2) ([merge request](gitlab-org/gitlab!142501))
- [Add sharding keys for purchase](gitlab-org/gitlab@9c3843da74714c72483c17489d5d3d68ceffd2c8) ([merge request](gitlab-org/gitlab!142505))

## 16.9.10 (2024-07-23)

### Added (1 change)

- [Add Rake task to show token expiration info](https://gitlab.com/gitlab-org/gitlab/-/commit/7747e83d1860f2186df35c5a29370e0e5bb0c810) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159058))

### Changed (1 change)

- [Do not enqueue PAT expiry enforcement migration](https://gitlab.com/gitlab-org/gitlab/-/commit/c7dc314ace84491b696fb65c3384fb0302d00d5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153470))

## 16.9.9 (2024-06-25)

### Fixed (1 change)

- [Update an expired test certificate](gitlab-org/gitlab@8fb9c678564e11392eab4d2001e60f751d6a86bc) ([merge request](gitlab-org/gitlab!156395))

### Changed (1 change)

- [Add a banner informing about token expiration](gitlab-org/gitlab@a079122ed2976df0f023ef55cef4a1585e31b5ce) ([merge request](gitlab-org/gitlab!155267))

## 16.9.8 (2024-05-09)

No changes.

## 16.9.7 (2024-05-07)

### Fixed (1 change)

- [Changed the email validation for only encoded chars](gitlab-org/security/gitlab@01275ef428e3b183c638adaebe28ac53edb6ce0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151484/))

### Changed (1 change)

- [Return or display Gitlab version if GITLAB_KAS_VERSION is a SHA](gitlab-org/security/gitlab@d7792bcb9cdfaabc3b1345facee6b7536fb2b3cb)

### Security (11 changes)

- [Update GITHUB_MEDIA_CDN to avoid SSRF when importing from Github](gitlab-org/security/gitlab@3910b8db08f64662611322b84abfa282fe975396) ([merge request](gitlab-org/security/gitlab!4013))
- [Prevent namespace banned users from reading project todos](gitlab-org/security/gitlab@a43f81187c393376f7bdf603277e72036a127013) ([merge request](gitlab-org/security/gitlab!3941))
- [ReDoS in GitRefsFinder when using wildcards in branch search](gitlab-org/security/gitlab@844ad9c3f404a0a838b895d4ac9b7dc7493bd291) ([merge request](gitlab-org/security/gitlab!3997))
- [ReDos in escape and commit reference filters](gitlab-org/security/gitlab@186bda71e1bbcf542effee18a14d1a7261b0b12d) ([merge request](gitlab-org/security/gitlab!3974))
- [Validate request origin before MR approval](gitlab-org/security/gitlab@47be8dd9e352c19ca8fe2865c6cf995fbce987de) ([merge request](gitlab-org/security/gitlab!4009))
- [Check request size before updating user pins](gitlab-org/security/gitlab@f882c7ffaca37e10933d3f7e82d665444e25fd64) ([merge request](gitlab-org/security/gitlab!4016))
- [Enforce per_page validation for Branches/TagsFinders](gitlab-org/security/gitlab@29b2b5636a1ce1defa6dedaf656f84b54b322976) ([merge request](gitlab-org/security/gitlab!4000))
- [Update Integrations::Discord::ATTACHMENT_REGEX regex](gitlab-org/security/gitlab@3e9f6cca867362cfbd70da79f47a6ce2481fef0e) ([merge request](gitlab-org/security/gitlab!3986))
- [Update BaseMessage::RELATIVE_LINK_REGEX regex](gitlab-org/security/gitlab@e5be5ad17ba7d09b923098382b16f8637f8cac31) ([merge request](gitlab-org/security/gitlab!3994))
- [Require confirmation before linking JWT identity](gitlab-org/security/gitlab@e889c09bd4bd3897badb73d79231f183881a20f4) ([merge request](gitlab-org/security/gitlab!3992))
- [Fix confidentiality check optimization](gitlab-org/security/gitlab@fb3635e8674859226a71c1a43d26655c908ce15b) ([merge request](gitlab-org/security/gitlab!4004))

## 16.9.6 (2024-04-24)

### Security (5 changes)

- [Validation for encoded formatting characters](gitlab-org/security/gitlab@de8dc151e5ef3f07cf50839e50645df6ec12f5a5) ([merge request](gitlab-org/security/gitlab!3951))
- [Forbid untrusted sign-ins to GitLab with Bitbucket and fix related uid](gitlab-org/security/gitlab@94496a91c17a0f73202cd5c55abc93395825c68c) ([merge request](gitlab-org/security/gitlab!3985))
- [Ensure PAT scope is validated everywhere for GraphQL/ActionCable](gitlab-org/security/gitlab@0dccf32b71614584e05a8590b21a902220e8c701) ([merge request](gitlab-org/security/gitlab!3977))
- [Protect against ReDoS in FileFinder with wildcard filters](gitlab-org/security/gitlab@60a7418ec10f7c6f4ef9bcc75b2fec71255ddcc3) ([merge request](gitlab-org/security/gitlab!3961))
- [fix: Validate security report version against schema during parsing](gitlab-org/security/gitlab@ce709ff78fd8f18024383085d6ac0bf43fa2efbb) ([merge request](gitlab-org/security/gitlab!3957))

## 16.9.5 (2024-04-12)

No changes.

## 16.9.4 (2024-04-09)

### Security (3 changes)

- [Update Gitlab::Regex::Packages#slack_link_regex](gitlab-org/security/gitlab@af54b6789912e394423920674ac2f4f0e38f9ff7) ([merge request](gitlab-org/security/gitlab!3903))
- [Fix XSS in autocomplete in rich text editor](gitlab-org/security/gitlab@bf84ed8c4d716d642ed36c1a804733a17dace11a) ([merge request](gitlab-org/security/gitlab!3947))
- [Correctly parse attachments for junit result](gitlab-org/security/gitlab@ed457bf14d21566b98fa461dfac10dac06b054ac) ([merge request](gitlab-org/security/gitlab!3911))

## 16.9.3 (2024-03-27)

### Fixed (1 change)

- [Fix new project group templates pagination](gitlab-org/security/gitlab@93a68da5a3ddc7f2f5f44658a163198a8c5da240) **GitLab Enterprise Edition**

### Security (2 changes)

- [Limit the number of emojis we will transform](gitlab-org/security/gitlab@41ec64318e92b428edf9796b2777dc1d8b9b3bc2) ([merge request](gitlab-org/security/gitlab!3926))
- [Fix stored xss in wikis using the abstract_reference_filter](gitlab-org/security/gitlab@a39b0ea96cf309dfc2d8a3a73ea4a047567bd0a1) ([merge request](gitlab-org/security/gitlab!3921))

## 16.9.2 (2024-03-06)

### Fixed (2 changes)

- [Backport 145801 (Fix CI linter error when repository is empty) to 16.9](gitlab-org/security/gitlab@3387113650f62739955a47de59f7c17dbe7e9509)
- [Fix container repositories checksum mismatch errors](gitlab-org/security/gitlab@7dce926636d80e26c4e99ac74c09c3795063151a) **GitLab Enterprise Edition**

### Security (2 changes)

- [Restrict group token rotation for custom roles](gitlab-org/security/gitlab@c7eafe2b214d8a5c739fe116899540133daebef3) ([merge request](gitlab-org/security/gitlab!3905))
- [Reset approvals when reopening a MR](gitlab-org/security/gitlab@4c3fbb6674de3dfc01332a25959167ba1085e5bb) ([merge request](gitlab-org/security/gitlab!3897))

## 16.9.1 (2024-02-20)

### Fixed (2 changes)

- [Fix Duo Chat CORS issue by updating web-ide package](gitlab-org/security/gitlab@6c4fccdd4d33fd40550197699a990a0d07a65137)
- [Fix deny_all_requests_except_allowed of AddressableUrlValidator](gitlab-org/security/gitlab@18ff795a3b9fdd54705c1a8898ad15b5dd84e2f0)

### Security (10 changes)

- [Add a limit to CodeOwners reference extractor regex](gitlab-org/security/gitlab@b090b503c47300d708d7e51192a486467fdecefd) ([merge request](gitlab-org/security/gitlab!3894))
- [Ensure LDAP user cannot sign in with password](gitlab-org/security/gitlab@1c2de5ef077c5710e213b668373557c01ff8ba26) ([merge request](gitlab-org/security/gitlab!3891))
- [Ensure LDAP users cannot reset local password to bypass LDAP](gitlab-org/security/gitlab@07621ad26d2db3656c99b332e697a6b0857f6e07) ([merge request](gitlab-org/security/gitlab!3879))
- [Disallow assigning higher role than current user](gitlab-org/security/gitlab@c9d8ffebe020dfdc1435e073516a098a8d188ff0) ([merge request](gitlab-org/security/gitlab!3889))
- [Check project read access in Environment and Operations dashboard](gitlab-org/security/gitlab@83fdac099562fa4aebcc43e400b0da2026c730a6) ([merge request](gitlab-org/security/gitlab!3873))
- [Fix Stored-XSS in user's profile page: Change markup used for pronouns](gitlab-org/security/gitlab@0fafb29660c08e72b87bd79d792da802c566b650) ([merge request](gitlab-org/security/gitlab!3882))
- [Invalidate markdown cache to clear up stored XSS](gitlab-org/security/gitlab@3411c25e77642fddc3619bf24ee956d4ba4d99b2) ([merge request](gitlab-org/security/gitlab!3884))
- [Disallow users to modify deploy key title](gitlab-org/security/gitlab@46ffceb9c94b6f4ba207ddf035ae67e8de413d57) ([merge request](gitlab-org/security/gitlab!3876))
- [Adds authorization for analytics settings](gitlab-org/security/gitlab@01e2c82cb79b6b4a9f6cf3428890149d023aacfb) ([merge request](gitlab-org/security/gitlab!3877))
- [Use merge_head_diff for codeowners when merge request is mergeable](gitlab-org/security/gitlab@eafc00662cb6e604b35278a5f59c25d418ef00c9) ([merge request](gitlab-org/security/gitlab!3878))

## 16.9.0 (2024-02-14)

### Added (145 changes)

- [Ensure at least one permission is selected during member role creation](gitlab-org/gitlab@327e3959708cd9b4ed91f565f1b79108ab2c0d6e) ([merge request](gitlab-org/gitlab!143616)) **GitLab Enterprise Edition**
- [Allow signing in to Active Directory with smart card](gitlab-org/gitlab@25f2235ce97701a2677a13a6ae175f40d6f5da64) ([merge request](gitlab-org/gitlab!143721)) **GitLab Enterprise Edition**
- [Add POST /personal_access_tokens/self/rotate endpoint](gitlab-org/gitlab@e48c661eecb449deb591f3c6d89f7aa716460019) by @stalb ([merge request](gitlab-org/gitlab!142664))
- [Track traversal sync events, update vulnerability reads accordingly](gitlab-org/gitlab@9f960c976ffefa38ae025b5531f24886517cfda6) ([merge request](gitlab-org/gitlab!143537)) **GitLab Enterprise Edition**
- [Add achievements UI](gitlab-org/gitlab@7dd37d8ae59dd1fbc6120bfb50cb3821589c8b27) ([merge request](gitlab-org/gitlab!129370))
- [Update BulkImports::Failure to display subrelation that failed to import](gitlab-org/gitlab@8d44a19fe239b03134c4c247fde54b07b2062a6d) ([merge request](gitlab-org/gitlab!142820))
- [Add branchRuleDelete graphql mutation](gitlab-org/gitlab@6bc4e72b8233d8ce06697f88ea82a7fc2a04ddf9) ([merge request](gitlab-org/gitlab!144255))
- [This MR adds experiment promotion banner](gitlab-org/gitlab@9b9ac988a4a831d83514b64d6c203dce134ddde3) ([merge request](gitlab-org/gitlab!144078)) **GitLab Enterprise Edition**
- [Add settting math_rendering_limits_enabled](gitlab-org/gitlab@9f416a02be5417e9473e9f94065dce9ec7170a90) ([merge request](gitlab-org/gitlab!143256))
- [Add basic testing functionality for group level](gitlab-org/gitlab@24d019352e82b4f2c29a5d8cf86068e1ffd0dea3) ([merge request](gitlab-org/gitlab!144023)) **GitLab Enterprise Edition**
- [Sync create indexes and prepare FK for p_ci_builds upstream_pipeline_id](gitlab-org/gitlab@f4e00909f87104e3a4f5b3be8aa90beb22e53101) ([merge request](gitlab-org/gitlab!143897))
- [Added first part of the command palete update](gitlab-org/gitlab@2b5ecb472381de3cea78f40c22fc0ffb5c719fc0) ([merge request](gitlab-org/gitlab!143353))
- [Add composite PK to ci_stages](gitlab-org/gitlab@de4eb89657a422971315b39e1faeab5c98e0307a) ([merge request](gitlab-org/gitlab!144025))
- [Adds download API v4 endpoint for project avatar](gitlab-org/gitlab@d23076b8c94565a857e6e01a87dcc585064c1188) ([merge request](gitlab-org/gitlab!144039))
- [Add designs widget to work items](gitlab-org/gitlab@8533e3ec0ae8f965e82420f8f188a76d4e3cc10c) ([merge request](gitlab-org/gitlab!142113))
- [Adds convert_to_ticket quick action](gitlab-org/gitlab@d3ca0752f06031c5d6e72e06abaad84f96e5bb92) ([merge request](gitlab-org/gitlab!139553))
- [Sort resources by released_at](gitlab-org/gitlab@978ec481cc728643b5a8a98be17535b16e004a19) ([merge request](gitlab-org/gitlab!143532))
- [Adding SemanticVersionable concern to Ml::ModelVersion](gitlab-org/gitlab@f34eb63a8d499c8c2b3fae51d436e3f4a13edebe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142228))
- [Add member guideline to admin appearance settings](gitlab-org/gitlab@70f1a15faf61074208968279a413123159d56d05) by @bufferoverflow ([merge request](gitlab-org/gitlab!137942))
- [Allow adding groups to CI_JOB_TOKEN allowlist graphQL mutation](gitlab-org/gitlab@2f6931217be6375c62415ea9f6c0d90ffeec4d4a) ([merge request](gitlab-org/gitlab!143132))
- [Log audit event for member events and custom roles](gitlab-org/gitlab@ca9ae9103a93fbf7169c61506645eaab8c6981fe) ([merge request](gitlab-org/gitlab!141985)) **GitLab Enterprise Edition**
- [Add concurrency option on sidekiq-cluster CLI](gitlab-org/gitlab@4843e5c1fb0f42c6614e9cf59e8f865a7f9da19b) ([merge request](gitlab-org/gitlab!143329))
- [Add alert about the gitops keyword deprecation](gitlab-org/gitlab@f48384c65592e2d3eafad862568505588c7c0bf4) ([merge request](gitlab-org/gitlab!143586))
- [Enable new finding modal on MR widget by default](gitlab-org/gitlab@b935941a9784e2d0902e9320a79db36e84c2bb6c) ([merge request](gitlab-org/gitlab!143987)) **GitLab Enterprise Edition**
- [feature: Add keyset pagination to the list of package protection rules](gitlab-org/gitlab@4de6931b301d2b3962ea3bcff34fbfca2663d885) by @gerardo-navarro ([merge request](gitlab-org/gitlab!140738))
- [Added cut line for board lists with WIP limit](gitlab-org/gitlab@e9b4c7188ce36533fd2b1241645aca478f3a6a88) ([merge request](gitlab-org/gitlab!142847)) **GitLab Enterprise Edition**
- [Release terraform module registry at (sub)group level](gitlab-org/gitlab@09ef9dd0344757dbddb0f40619cdd2cec970e3e6) ([merge request](gitlab-org/gitlab!143608))
- [Match Container Scanning SBOM component](gitlab-org/gitlab@d442355b2b25ddb398d6f81eb17123ac3edf6036) ([merge request](gitlab-org/gitlab!137623)) **GitLab Enterprise Edition**
- [Add GraphQL API for projects/groups linked to security policy project](gitlab-org/gitlab@6c0da69eb77dbc0b2abc1266281ff8d1a07877a4) ([merge request](gitlab-org/gitlab!143703)) **GitLab Enterprise Edition**
- [Added table and model for instance level destination](gitlab-org/gitlab@28ed896bef7853172f26eecd8a2bd9618adb14ed) ([merge request](gitlab-org/gitlab!143247)) **GitLab Enterprise Edition**
- [Adding tables and models for group streaming destinations](gitlab-org/gitlab@29199b2afc5725dc23b86feed48430a03c259516) ([merge request](gitlab-org/gitlab!141739)) **GitLab Enterprise Edition**
- [Add rich text editor in design notes](gitlab-org/gitlab@b4b05e8980c9ed841ee6de6d0f5bea9260250e66) ([merge request](gitlab-org/gitlab!143773))
- [Add rich text editor to release descriptions](gitlab-org/gitlab@23f137b4b3aa45b01b5eedd0746b530b287838a3) ([merge request](gitlab-org/gitlab!143775))
- [Add rich text editor in requirements](gitlab-org/gitlab@5418d7e981e7d39da510ca1f1443838a2cd575da) ([merge request](gitlab-org/gitlab!143778))
- [Add rich text editor in vulnerabilities](gitlab-org/gitlab@5d193823bd7b4fc6234dc2e7583cbca9f5ec25bc) ([merge request](gitlab-org/gitlab!143784))
- [Validate the foreign key & add to routing table auto_canceled_by_id](gitlab-org/gitlab@97aa6e854227cbf7b20c253c0031e1d300a1bef2) ([merge request](gitlab-org/gitlab!143777))
- [Add catalog_verified_namespace table](gitlab-org/gitlab@ec63a6edd94ab97bd73a27367d138e515cc62e7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/143003))
- [Feat: transition to JiHu callout frontend](gitlab-org/gitlab@c5c35a14976cf4a065be06c901cfc7b84619a2a9) ([merge request](gitlab-org/gitlab!142126))
- [Feat: add entries for JH about repo blob viewers](gitlab-org/gitlab@c5effaac0edd22deba0a6d03bfb963468003d3c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/143019))
- [Add organizations support to PushRules](gitlab-org/gitlab@8ecc6da4125581ce65c7d509ce1f665a7edd19dc) ([merge request](gitlab-org/gitlab!143541)) **GitLab Enterprise Edition**
- [Add rewrite_history method to the Gitaly cleanup client](gitlab-org/gitlab@76e7cd4f3cfca86ef1da574809adaeba599d5aff) ([merge request](gitlab-org/gitlab!142886))
- [Prepare async index for p_ci_builds.runner_id and commit_id](gitlab-org/gitlab@f37f03ce7c4145825a23849dfa172f28b47f8ced) ([merge request](gitlab-org/gitlab!143747))
- [Add CVSS data to vulnerabilities GraphQL API](gitlab-org/gitlab@9fa0080b83b1a827a81ca92c126a3352e3b77c88) ([merge request](gitlab-org/gitlab!143736)) **GitLab Enterprise Edition**
- [Add separate tab for the K8s Pods](gitlab-org/gitlab@39e7ffca747ac05fbfdf157b02069830eccd4afe) ([merge request](gitlab-org/gitlab!142326))
- [Update the analyzer for merge_request title and description](gitlab-org/gitlab@014d6c3fbe5f95e798c937a9f6aceafbc40c76d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142550)) **GitLab Enterprise Edition**
- [Reject commits breaking GitGuardian policies](gitlab-org/gitlab@e0355289f7440cb6a0664b00f0c49e879b5e2d38) ([merge request](gitlab-org/gitlab!141779)) **GitLab Enterprise Edition**
- [Add the user access level claim to ID tokens](gitlab-org/gitlab@2c200eae49e0a0b5514a4100f8cafefc5d928b65) ([merge request](gitlab-org/gitlab!143091))
- [Add allow/disallow duplicate terraform modules setting to UI](gitlab-org/gitlab@f171779d298e1eb0957880f8501cda7c0c88e0b9) ([merge request](gitlab-org/gitlab!142855))
- [Track Insights merge request chart item click events](gitlab-org/gitlab@66824bdd9fb5673e744f724660118d77e4744288) ([merge request](gitlab-org/gitlab!143126)) **GitLab Enterprise Edition**
- [Extend drill-down functionality to all issuables Insights charts](gitlab-org/gitlab@10b7a5a0de86f1bc351c899d312f9a14486916d3) ([merge request](gitlab-org/gitlab!142872)) **GitLab Enterprise Edition**
- [Extend Projects API with a new parameter `repository_object_format`](gitlab-org/gitlab@9cfc3937cc35bd9b845f3c5c82cac136acf314e7) ([merge request](gitlab-org/gitlab!137659))
- [Allow creation of group-level custom-roles on self-managed instances](gitlab-org/gitlab@af5016004d8b7e2a0dafee9cb9c1c260ffa7c9e5) ([merge request](gitlab-org/gitlab!142637)) **GitLab Enterprise Edition**
- [Add groups to CI_JOB_TOKEN allowlist](gitlab-org/gitlab@60d902398ddb61730f8d4ee0dc384687ac457bb4) ([merge request](gitlab-org/gitlab!142441))
- [Add feature flag for progressive rollout of CVS](gitlab-org/gitlab@e2b2acb15169ad347a0230c69ed838a171b83a25) ([merge request](gitlab-org/gitlab!143275))
- [Sync create indexes for p_ci_builds auto_canceled_by_id and commit_id](gitlab-org/gitlab@dbef1efea70a0359a1de1ec83f2b299de45c5fe4) ([merge request](gitlab-org/gitlab!142766))
- [Create ProjectPlanLimits type](gitlab-org/gitlab@2ccbdebdc7c5d175cba4344de61c1342eeb118b1) ([merge request](gitlab-org/gitlab!142717))
- [Added updated to releases api](gitlab-org/gitlab@95b9bf0773eaff7b98fb2d0b399201f837b4eb13) ([merge request](gitlab-org/gitlab!141432))
- [Add group vulnerability report denormalisation fields to vuln_reads](gitlab-org/gitlab@f16ea5e330d0a584b126a8ff5f93eb08da974ebf) ([merge request](gitlab-org/gitlab!143215))
- [Sort resources by released_at](gitlab-org/gitlab@3609e3f9ae1ebd3c03e9194a291ad4356d2147c6) ([merge request](gitlab-org/gitlab!143422))
- [Ingest source_package_name as source_package](gitlab-org/gitlab@7ac33bbdbb8db6e0978cfb20595a3354cf97f759) ([merge request](gitlab-org/gitlab!142008)) **GitLab Enterprise Edition**
- [Add direct members metric to VSD counts](gitlab-org/gitlab@ae8160deca5ae04c6fe4dd72b33f8e78cbe94fe0) ([merge request](gitlab-org/gitlab!142060)) **GitLab Enterprise Edition**
- [Enable the ci_workflow_auto_cancel_on_new_commit feature](gitlab-org/gitlab@4be9807c06d25e4d905a964c878da5af42c2b01b) ([merge request](gitlab-org/gitlab!142911))
- [Add Privacy Policy and Terms acceptance component](gitlab-org/gitlab@7bff2bbfb2fbd218a2d387058e035869fa4d9ce4) ([merge request](gitlab-org/gitlab!143025)) **GitLab Enterprise Edition**
- [Assign instance-level custom roles to user](gitlab-org/gitlab@dbc40511cf0643a69a95d691622754651d80d80d) ([merge request](gitlab-org/gitlab!141847)) **GitLab Enterprise Edition**
- [Add `archived` and `traversal_ids` columns to `sbom_occurrences`](gitlab-org/gitlab@3042efee13bdac33a8b3a8de965b0df6b2f8e7fb) ([merge request](gitlab-org/gitlab!143104))
- [Add version to fetch readme](gitlab-org/gitlab@3367905421933f2b1233d5fd91168465a150c4d9) ([merge request](gitlab-org/gitlab!142853))
- [Update the analyzer for epic description and title](gitlab-org/gitlab@e422027b22ae2bc7944882c22fedf102da125bfc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142562)) **GitLab Enterprise Edition**
- [Add sorting support to organization projects GraphQL query](gitlab-org/gitlab@6c86c6ab89c4b82dd46cc88168d7a67440af203e) ([merge request](gitlab-org/gitlab!142390))
- [Enabled has remediations filter by default](gitlab-org/gitlab@6a6306895e90a937e99b1d47f865441571621ad2) ([merge request](gitlab-org/gitlab!140469)) **GitLab Enterprise Edition**
- [Release concurrency limit for Sidekiq](gitlab-org/gitlab@58f7280969d7d026509427629ddc95468cba01f4) ([merge request](gitlab-org/gitlab!142901)) **GitLab Enterprise Edition**
- [Add GraphQL mutation to refresh standards adherence checks](gitlab-org/gitlab@0e5c6b9125f42588354ccaddc0e02b138415f5d2) ([merge request](gitlab-org/gitlab!142440)) **GitLab Enterprise Edition**
- [Document how to configure mutual TLS for Webhooks](gitlab-org/gitlab@286493c283f5936b0e6eccf18daf626b8ad86658) ([merge request](gitlab-org/gitlab!143115))
- [Add available_from_access_level to custom abilities](gitlab-org/gitlab@b556e17a09f79190a2faaf4c9eed32178f54c058) ([merge request](gitlab-org/gitlab!142802)) **GitLab Enterprise Edition**
- [Add index on sbom_occurrences table on project_id,](gitlab-org/gitlab@23f5a409ca6f030f74e5a9e9518c7d5fb4fdfce4) ([merge request](gitlab-org/gitlab!142540)) **GitLab Enterprise Edition**
- [Add repository x-ray usage tracking telemetry](gitlab-org/gitlab@efbba568863106a3379f8d1b0418af72088058f1) ([merge request](gitlab-org/gitlab!142807)) **GitLab Enterprise Edition**
- [Add manage roles link to roles dropdowm](gitlab-org/gitlab@f308529e9616b3ccf5af59d55bfd765ced90f0c9) ([merge request](gitlab-org/gitlab!142560)) **GitLab Enterprise Edition**
- [Allow filtering by unknown license](gitlab-org/gitlab@3a569da169dda8fb6bb22c8c02f7bf3be3172cf7) ([merge request](gitlab-org/gitlab!142235)) **GitLab Enterprise Edition**
- [Create packages_terraform_module_metadata table & corresponding model](gitlab-org/gitlab@4d56bfa7f73375bdb5d46e8a80143427595a1f8f) ([merge request](gitlab-org/gitlab!141914))
- [Show admin mode within active sessions view](gitlab-org/gitlab@4041a0ff1a6c8cf80bc3514a197a5355e02ac29f) by @bufferoverflow ([merge request](gitlab-org/gitlab!142158))
- [Port Star button to Vue app](gitlab-org/gitlab@5bde208c6864d9d1fdaf790002c30913374aae3a) by @espadav8 ([merge request](gitlab-org/gitlab!126475))
- [Criticial Security Alert - Latest Stable Patch](gitlab-org/gitlab@1d9a8808f369b8acf56b64b77499a945502ff4d7) ([merge request](gitlab-org/gitlab!142858))
- [Add description field to GraphQL MemberEntity](gitlab-org/gitlab@ac8d02f164873440baf8002411a2e75dc536edb5) ([merge request](gitlab-org/gitlab!142900)) **GitLab Enterprise Edition**
- [Add WorkItems Rolledup Dates mutation GraphQL](gitlab-org/gitlab@83070391bde87bfd61d821b1d527f2aafe7e37a4) ([merge request](gitlab-org/gitlab!140224)) **GitLab Enterprise Edition**
- [Expose ID in Types::Projects::BranchRuleType](gitlab-org/gitlab@d15b9464a31f7b67fda866e10e3ed9550cca18f4) ([merge request](gitlab-org/gitlab!142306))
- [Adds instance admins to organization_users as owners](gitlab-org/gitlab@4d8d7beb3f7d629c7a896a11d6b50a242556c8eb) ([merge request](gitlab-org/gitlab!141297))
- [Add verification_level to GraphQL ComponentType](gitlab-org/gitlab@47e3ccb19b186610550014b3dd5447d858d01457) by @imskr ([merge request](gitlab-org/gitlab!142317))
- [Expose securityPolicyProject for project or group in GraphQL API](gitlab-org/gitlab@e72f2a5f5090c597062b7e765c17860cc3fd2c7e) ([merge request](gitlab-org/gitlab!142720)) **GitLab Enterprise Edition**
- [feat: Integration in container auth service](gitlab-org/gitlab@e7f2bf7141fd80508eea887e8ca11010dd397c52) by @gerardo-navarro ([merge request](gitlab-org/gitlab!136873))
- [feat: Validation for container_path_pattern](gitlab-org/gitlab@11e486f956544ebb83d6366d7d436e870d037ab9) by @gerardo-navarro ([merge request](gitlab-org/gitlab!135972))
- [Add composite PK to ci_job_artifacts](gitlab-org/gitlab@d59c2ba0e50a32a7a3b132ad1b0cb77447dcc966) ([merge request](gitlab-org/gitlab!142644))
- [Added FF](gitlab-org/gitlab@40d860975611a37f5b29b2de3c3b6a1261a64f06) ([merge request](gitlab-org/gitlab!141965)) **GitLab Enterprise Edition**
- [Add Search::Zoekt::Repository model](gitlab-org/gitlab@6e4608a381d967a5f77d2a367294ac7006ed08c5) ([merge request](gitlab-org/gitlab!141864)) **GitLab Enterprise Edition**
- [feat: Protected packages: Create protection rules in project setting ui](gitlab-org/gitlab@ddca3e317dab73a0c324f9f6fe78b01394c6af4d) by @gerardo-navarro ([merge request](gitlab-org/gitlab!140473))
- [Prepare async index for p_ci_builds.upstream_pipeline_id and commit_id](gitlab-org/gitlab@2a820097db2208a450ef682bd70a31f79eb6e1fc) ([merge request](gitlab-org/gitlab!142763))
- [Add protectableBranches to ProjectType](gitlab-org/gitlab@40cc526d6904f5eff90bfb9f1c5b0c15615b8218) ([merge request](gitlab-org/gitlab!142464))
- [Add a new analyzer title_analyzer](gitlab-org/gitlab@80eebb64cb367b1fdc66c6312ddcf68d515cf061) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142580)) **GitLab Enterprise Edition**
- [Add preload for autocomplete_sources/members](gitlab-org/gitlab@eddb9f3c540521257b5dcabe0c705560ed6796e1) ([merge request](gitlab-org/gitlab!142663))
- [Add the code_analyzer for notes note](gitlab-org/gitlab@c0fd247544196cad1cdbf0a7e9f983154db7398a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142301)) **GitLab Enterprise Edition**
- [REST API support for getting commit sequence/count](gitlab-org/gitlab@613708ea4526695c7bf1b60aa766ee56cecfbdd5) by @travis.finch ([merge request](gitlab-org/gitlab!142250))
- [Adds graphql search options for Ml::ModelVersion](gitlab-org/gitlab@4f486027ee4a7f236e79a7bdbf77a954b31cef06) ([merge request](gitlab-org/gitlab!142320))
- [Migration to remove work_items from issues index](gitlab-org/gitlab@409762fb210fbc08d145dcbbd62a3cc05cc7faa1) ([merge request](gitlab-org/gitlab!142653)) **GitLab Enterprise Edition**
- [SAML reauth banner for issues and merge requests dashboard](gitlab-org/gitlab@508604d28acbe897d5c00f7482dab9a344f16438) ([merge request](gitlab-org/gitlab!140893)) **GitLab Enterprise Edition**
- [Prepare async index for auto_canceled_by_id_convert_to_bigint](gitlab-org/gitlab@5903e80a1b7eb93a7f1e9a51cdf9365dd05293b0) ([merge request](gitlab-org/gitlab!142476))
- [Publish ApprovalsResetEvent when approvals are reset on push](gitlab-org/gitlab@646e45c00447acf0ea47b2f4f782556db74cc3f4) ([merge request](gitlab-org/gitlab!141680)) **GitLab Enterprise Edition**
- [Members API: Allow group Owners to obtain enterprise users emails](gitlab-org/gitlab@708e6e51e849325b3cbc7950b82479ae5b205ec0) ([merge request](gitlab-org/gitlab!135873)) **GitLab Enterprise Edition**
- [Add `is_forked` field to project GraphQL type](gitlab-org/gitlab@38a1db7a93b1deacec0bc78aa76bd65897b077ee) ([merge request](gitlab-org/gitlab!141536))
- [Removes moved_mr_sidebar flag](gitlab-org/gitlab@fd56a1433ea685e965f0430d754a1bc3f779587d) ([merge request](gitlab-org/gitlab!127001))
- [Finalize BackfillPartitionId for ci_pipelines related tables](gitlab-org/gitlab@75e6ab96bf2284867552b3bcebea31edbca3ced7) ([merge request](gitlab-org/gitlab!142422))
- [Add "Contributor count" metric to Value Streams Dashboard](gitlab-org/gitlab@c615ebfc53d7edbff7bdae18dcf272edf29fe990) ([merge request](gitlab-org/gitlab!141912)) **GitLab Enterprise Edition**
- [Add category to /spend quick action](gitlab-org/gitlab@243d761bc9d88143f9bb8df3c9aa397a0106c5e5) ([merge request](gitlab-org/gitlab!140990))
- [Allow group Owners to view enterprise users emails on UI/Members page](gitlab-org/gitlab@15aa8b554ecf7512938bbf7c4729b2aad0e13830) ([merge request](gitlab-org/gitlab!141789)) **GitLab Enterprise Edition**
- [Add name and description for WebHooks](gitlab-org/gitlab@0d67426dc335c5741da2f8476f2b5197f094b1bb) ([merge request](gitlab-org/gitlab!141977))
- [Update front-end to create instance-level custom roles](gitlab-org/gitlab@0afa98ea9425260255a7e6a804f271131cbfcec1) ([merge request](gitlab-org/gitlab!141562)) **GitLab Enterprise Edition**
- [Add maxAccessLevel field to project and group type](gitlab-org/gitlab@26daf5920372e37475da022a566c0cf6470c7d83) ([merge request](gitlab-org/gitlab!141969))
- [Log when GraphQL query has deprecated arguments](gitlab-org/gitlab@ae2b28bbbf9a03a224da83aa4148c70a88ed11a8) ([merge request](gitlab-org/gitlab!142467))
- [Add Direct Transfer Stats API](gitlab-org/gitlab@75befb2b7fbe8f33ac12a673a541e6afce55f1c5) ([merge request](gitlab-org/gitlab!140097))
- [Add timestamp for sbom_source_packages](gitlab-org/gitlab@194ec70a7b8889a88c473354b29d0dafa6f4e045) ([merge request](gitlab-org/gitlab!142006))
- [Add GitLab for Slack app integration to REST API](gitlab-org/gitlab@e086e2def0c14dfaf92456509538591cee5434dd) ([merge request](gitlab-org/gitlab!141693))
- [Check if DB external command config parsed output is a Hash](gitlab-org/gitlab@7bf751639945a545f553b01749aedf3d61663309) ([merge request](gitlab-org/gitlab!142064))
- [AI Agent list view](gitlab-org/gitlab@e343e98ea2c994e44690b879e6819ed78c544278) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/141664)) **GitLab Enterprise Edition**
- [Unsubscribe individual issue email participants from issue](gitlab-org/gitlab@a536d72bb0a56b9d9eb96b52a9ea2d5c02662981) ([merge request](gitlab-org/gitlab!141131))
- [Define global identifiers for branch rules](gitlab-org/gitlab@d18055644dd3ddc121373ce9c63206d31476a393) ([merge request](gitlab-org/gitlab!142302))
- [Allow configuring git access protocol via Groups API](gitlab-org/gitlab@36ffbf82f70c58c83308b6d2500aacb37a794bf4) ([merge request](gitlab-org/gitlab!141118))
- [Add get ServicePing API endpoint](gitlab-org/gitlab@8bf3fe0482097456c01fb2b3da51b72becab9dcf) ([merge request](gitlab-org/gitlab!141446))
- [Remove dev feature flag: track_geo_secondary_git_op_action](gitlab-org/gitlab@57ad5fec53706e6cc215654a1aa80cd35f86174e) ([merge request](gitlab-org/gitlab!141505)) **GitLab Enterprise Edition**
- [Add description field to CI Variables drawer](gitlab-org/gitlab@16e327b66b7a05fc905b932719e5663bba79714d) ([merge request](gitlab-org/gitlab!140547))
- [Introduce BeyondIdentity integration to verify GPG keys](gitlab-org/gitlab@69cb2d20fc2a501ace8172af4aebfc478da317d1) ([merge request](gitlab-org/gitlab!136754))
- [Add support for cancelled subscription licenses](gitlab-org/gitlab@7f17d1bd47907941e6b45a995e751c825c8bba68) ([merge request](gitlab-org/gitlab!141554))
- [Enable geo_skip_download_if_exists by default](gitlab-org/gitlab@0388a8255a31a03b9403e49519d16ec9a6681938) ([merge request](gitlab-org/gitlab!140276)) **GitLab Enterprise Edition**
- [Audit CI artifact download](gitlab-org/gitlab@7d96ac2f1884b5f492cd9b12c66068ebf0666a9b) ([merge request](gitlab-org/gitlab!129608)) **GitLab Enterprise Edition**
- [Enable Jira integration issues and vulnerabilities on the group level](gitlab-org/gitlab@b593f6773310eaef370c49741690589e2470bd9f) ([merge request](gitlab-org/gitlab!141996))
- [Add participants widget](gitlab-org/gitlab@c5b699208d90e829decb15f1d7be3f68724efd2b) ([merge request](gitlab-org/gitlab!141097))
- [Hide count and table header in empty state](gitlab-org/gitlab@14d4d9d10f307f1576fdddb242d67b311def4917) ([merge request](gitlab-org/gitlab!141458)) **GitLab Enterprise Edition**
- [Remove pipeline_name_search feature flag](gitlab-org/gitlab@25101d206da47de552ed561e180ed9e6d2b50ace) ([merge request](gitlab-org/gitlab!133607))
- [GraphQL: Add systemId argument to `CiRunner.managers`](gitlab-org/gitlab@55562e837e99ab44395b8eb236e6d7066e918743) ([merge request](gitlab-org/gitlab!140714))
- [Allow setting inheritance type on protected env](gitlab-org/gitlab@85ba8369a4ea3944a010df9d8bf2ed061193e5e0) ([merge request](gitlab-org/gitlab!141422)) **GitLab Enterprise Edition**
- [Allow providing extra DB config through an external command](gitlab-org/gitlab@13d5b459b37d7149b8c494e7fad86345e47d0507) ([merge request](gitlab-org/gitlab!141818))
- [Added arugment error when pipeline is nil](gitlab-org/gitlab@e9d89ce94094f92d089f3d5d68f20192e8c91e85) by @chirayu999 ([merge request](gitlab-org/gitlab!141267))
- [Enforce workspaces_quota and workspaces_per_user_quota](gitlab-org/gitlab@ab0fadb19142b6c70c732105c864ce6d2f208868) ([merge request](gitlab-org/gitlab!141376))
- [Add verification_level to catalog_resources](gitlab-org/gitlab@480abdaf55b90106dfa0de5bf04a44bcc41b2da5) by @imskr ([merge request](gitlab-org/gitlab!140219))
- [Allow specifying extra Redis config from external command](gitlab-org/gitlab@595b0672a637988b44c88f1b0a335b508ca78eb8) ([merge request](gitlab-org/gitlab!141681))
- [Record previous weight when updating issue weight](gitlab-org/gitlab@e7e786b76b9737a6cfb4e0796fb59d7d078b8d37) ([merge request](gitlab-org/gitlab!141509)) **GitLab Enterprise Edition**
- [Add VSA added to iteration event](gitlab-org/gitlab@f5769694b23984e7d8eefc8f5953394d51e9b99f) ([merge request](gitlab-org/gitlab!141759)) **GitLab Enterprise Edition**
- [Add standards adherence refresh worker](gitlab-org/gitlab@14b242fd7abe57213c1eefa7f89c6de3ee71960c) ([merge request](gitlab-org/gitlab!141710)) **GitLab Enterprise Edition**
- [Track git operations from geo sites](gitlab-org/gitlab@950c237f1a9a40e77d9c46e94941692ba2ef73bb) ([merge request](gitlab-org/gitlab!141512)) **GitLab Enterprise Edition**

### Fixed (145 changes)

- [Filter committers with merge commits as well when users are loaded](gitlab-org/gitlab@d9d08f598d9a2dcb47f5a1e2f4a869e053eaea6d) ([merge request](gitlab-org/gitlab!144381)) **GitLab Enterprise Edition**
- [Fix CODEOWNERS rule to ignore Verify specs for lib](gitlab-org/gitlab@8e329139ceac045fc7c547dff9ffb60cabd45047) ([merge request](gitlab-org/gitlab!143387))
- [Contributor analytics: User commit counts update for time period](gitlab-org/gitlab@084e63e4ebe3a4dcade0224c30d228999b604095) ([merge request](gitlab-org/gitlab!143968))
- [Fix missing outbound_local_requests_allowlist parameter](gitlab-org/gitlab@62a58d5a51e70816544e9a537d9938f64e4dc6d1) ([merge request](gitlab-org/gitlab!144345))
- [Fix line anchor hrefs for legacy viewers](gitlab-org/gitlab@c4d26666c277141df039f37684b527004341c3a2) ([merge request](gitlab-org/gitlab!144340))
- [Fixes rendering issue with the sidebar on printed pages](gitlab-org/gitlab@20c031c02b12745026c6072e6bb719de597d22b0) ([merge request](gitlab-org/gitlab!144321))
- [Avoid mutating OpenSSL::PKey::EC keys](gitlab-org/gitlab@a661db3bcfbf9c32dcc9cf28bcd0221cfa0c289c) ([merge request](gitlab-org/gitlab!144252))
- [Fix X509::Signature#x509_issuer not working with OpenSSL 3](gitlab-org/gitlab@4bad33e001f09d1dd83f9f5bfd042fa39c137780) ([merge request](gitlab-org/gitlab!144252))
- [Added RefreshImportWorker to Bitbucket Cloud/Server stage workers](gitlab-org/gitlab@2e8babc771fd88d05334a9001d36e40aa86e0bd9) ([merge request](gitlab-org/gitlab!142980))
- [Remove math rendering exception for wikis](gitlab-org/gitlab@f1810d659e5faf1f499a1a49f6c64951a2c7837d) ([merge request](gitlab-org/gitlab!143550))
- [Use component_version_id for project finder](gitlab-org/gitlab@365ae698118d74374c47d15c90e76cd6518a9a7b) ([merge request](gitlab-org/gitlab!143841)) **GitLab Enterprise Edition**
- [Revert "Merge branch 'ag/356965-bug-sm-awaiting-user-signup-badge' into 'master' "](gitlab-org/gitlab@c7faa8439891cc3d69fa42fe4e23e48922599595) ([merge request](gitlab-org/gitlab!144225))
- [Update DiffNote's line_range during importing](gitlab-org/gitlab@d6df0435065dbb909fe8f8b425d9ff3804248326) ([merge request](gitlab-org/gitlab!144221))
- [Fix approvers loading for approval_policy type](gitlab-org/gitlab@92e1c3d8947d55cf5c73d579db5e1b8e81f262b0) ([merge request](gitlab-org/gitlab!144184)) **GitLab Enterprise Edition**
- [Fix with_hosted_plan when used with trial: nil](gitlab-org/gitlab@244b65135cbe747332389e45e1eff2d93dd54ae7) ([merge request](gitlab-org/gitlab!144185)) **GitLab Enterprise Edition**
- [Disable autocomplete sources feature flag](gitlab-org/gitlab@7c3494ad641eca5adf2b655e0fd4202666f11018) ([merge request](gitlab-org/gitlab!144169))
- [Handle row for "others" in runner usage breakdown](gitlab-org/gitlab@b620584b51a1e72064cb4e0715deb976d1432e27) ([merge request](gitlab-org/gitlab!144163)) **GitLab Enterprise Edition**
- [Update workhorse timeout to 55s](gitlab-org/gitlab@a88995390cca1f8fabe2dd326334ffd84c6bd3b3) ([merge request](gitlab-org/gitlab!143855)) **GitLab Enterprise Edition**
- [Milestone burndown chart consistency fixes](gitlab-org/gitlab@8ecd79969c4973fe044ab0c1c7939fc692b8d33e) ([merge request](gitlab-org/gitlab!143992)) **GitLab Enterprise Edition**
- [Fix limited visibility of variable values in dropdown](gitlab-org/gitlab@39da4e2266eca1832770bf6a6667b9bae2023fde) by @antonkalmykov ([merge request](gitlab-org/gitlab!143733))
- [Fix scan execution policy without ci file](gitlab-org/gitlab@07ce5d109b5664a755fbb086d2451e7abfa0817a) ([merge request](gitlab-org/gitlab!143979)) **GitLab Enterprise Edition**
- [Allow users w/ read_code permission to search code](gitlab-org/gitlab@9f1011b035accaa9aacd48ffbde01b68db39fd0a) ([merge request](gitlab-org/gitlab!144084)) **GitLab Enterprise Edition**
- [Fix issue with selecting expired milestones in RTE](gitlab-org/gitlab@25e7905d2048059ffb21e9251f826a3cb309ca29) ([merge request](gitlab-org/gitlab!143790))
- [Fix SBOM ingestion errors caused by input file path validation](gitlab-org/gitlab@19b483346280cf0879ef541be068f1de6aff9ee0) ([merge request](gitlab-org/gitlab!143985))
- [Fix changelog tag detection logic](gitlab-org/gitlab@abca89753caa1d533cb3444f94e0d31266825cd5) ([merge request](gitlab-org/gitlab!143827))
- [Issue board - Fix updating total list weight](gitlab-org/gitlab@0a1c36473054e65ccde90088401ec27fd8c5c331) ([merge request](gitlab-org/gitlab!143765)) **GitLab Enterprise Edition**
- [This MR fixes wrong wording for policy scope](gitlab-org/gitlab@b7821d5b764a354f78d9fb45ca1b033cf298e37b) ([merge request](gitlab-org/gitlab!143648)) **GitLab Enterprise Edition**
- [Fix OIDC and id_token issuer mismatch](gitlab-org/gitlab@45fe23971510232ca4586bd5f971e2de3f2acf9b) ([merge request](gitlab-org/gitlab!141151))
- [Revert "Merge branch '427437-preload-autocomplete_sources-members-retry' into 'master'"](gitlab-org/gitlab@3fb8cd2d698c07047e3bf6f8153307ef07cdefd3) ([merge request](gitlab-org/gitlab!143912))
- [Allow move to failed, from pending or failed](gitlab-org/gitlab@3813e8733745afb377eb57e1778b332d1b85099f) ([merge request](gitlab-org/gitlab!143158)) **GitLab Enterprise Edition**
- [Fix MockCI REST API](gitlab-org/gitlab@efd5c645eb3bb370d86bbef1c3ebc54d341872d1) ([merge request](gitlab-org/gitlab!143634))
- [Display runner dashboard ClickHouse features](gitlab-org/gitlab@641233ea0367c28fc786d3c1e926323c1564b74c) ([merge request](gitlab-org/gitlab!143209))
- [Return allow_force_push: false always when security policy enforced](gitlab-org/gitlab@9d1d787801d09ea8c669228b5d283aceb8cbaa5f) ([merge request](gitlab-org/gitlab!143839)) **GitLab Enterprise Edition**
- [Fix broken upload progress indicator](gitlab-org/gitlab@c47f652b024213c1a5d686bd437b1b1ed308acee) ([merge request](gitlab-org/gitlab!143788))
- [Fix the error when the fork is linked to itself](gitlab-org/gitlab@e20f2e58d43f0c5dd65806346ce5484498a0e3aa) ([merge request](gitlab-org/gitlab!141273))
- [Fix absent parameters in runner usage resolver](gitlab-org/gitlab@02b566c317f62d4944e69cbcc6d6c56ee6b64f39) ([merge request](gitlab-org/gitlab!143800))
- [Save message in chat api](gitlab-org/gitlab@670d883877a8359ffbc3b68638bc91529ebff680) ([merge request](gitlab-org/gitlab!143371)) **GitLab Enterprise Edition**
- [Fix issue with copying task lists](gitlab-org/gitlab@c1d5446ea22fe62426f172d52108f6a64e09ce3f) ([merge request](gitlab-org/gitlab!143785))
- [Fix bug where date strings where incorrectly formatted](gitlab-org/gitlab@bcdedf57aa6ab804207e5c4b858c36ebd62c6ee6) ([merge request](gitlab-org/gitlab!143744)) **GitLab Enterprise Edition**
- [Fix API branches OpenAPI YAML parameters](gitlab-org/gitlab@6ef1605082e05ea3b8d3aee2cd73534af6b7b7fc) by @Sineaggi ([merge request](gitlab-org/gitlab!143610))
- [Select report_type based on feature flag when](gitlab-org/gitlab@7cf9c781f6fc0377a3cc448176b176b4a17393c7) ([merge request](gitlab-org/gitlab!143517)) **GitLab Enterprise Edition**
- [Allow loading of Hashie::Mash in YAML](gitlab-org/gitlab@23b1e437266d947c447934f12fff494e6cffc3e3) ([merge request](gitlab-org/gitlab!143694))
- [Update mermaid to fix upstream render bug](gitlab-org/gitlab@e20e78a59270419d21aa348b16316a6ca31aa603) ([merge request](gitlab-org/gitlab!143609))
- [Use clearer label for iteration report calc mode](gitlab-org/gitlab@0d762500d61fc55d6b28b6c30045a4593e3bd80e) ([merge request](gitlab-org/gitlab!143569)) **GitLab Enterprise Edition**
- [Update the list of supported protocols for Settings API](gitlab-org/gitlab@5324313f5e2e473df28977ce01c08ff02604654a) ([merge request](gitlab-org/gitlab!142159))
- [Reindex wikis to adopt new structure of id](gitlab-org/gitlab@14e68ac13830c99f81c4e0b505dba29cb7c746eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/143273)) **GitLab Enterprise Edition**
- [Set default vulnerability_states for empty states](gitlab-org/gitlab@554078f22ba1cd92143dc78d5ed0f60dec251e01) ([merge request](gitlab-org/gitlab!143498)) **GitLab Enterprise Edition**
- [Fix snippets overflowing bug](gitlab-org/gitlab@b2961c3aea41106d3aace04fb18e56c7febb2794) ([merge request](gitlab-org/gitlab!143523))
- [Fix group filter and pagination bug](gitlab-org/gitlab@d8591c7fca8c34bbe59166dd388a15a55a539d2d) ([merge request](gitlab-org/gitlab!108022))
- [Check project policy_configuration ids on syncing compliance framework](gitlab-org/gitlab@568f996d9a256b7a927b07faabb2780b0faca245) ([merge request](gitlab-org/gitlab!143590)) **GitLab Enterprise Edition**
- [Fix the lingering outdated codeowner rules issue](gitlab-org/gitlab@e812b800c3199a71422ffe1cd475eb24f05c39ca) ([merge request](gitlab-org/gitlab!143330))
- [Fix reviews import and E2E in GitHub Import](gitlab-org/gitlab@faecff1ffd804262a97fc9add58bf4bdf918bcba) ([merge request](gitlab-org/gitlab!143219))
- [Add dark mode modal specific timeline entry styles](gitlab-org/gitlab@eb06fd2eea03a824d4c75a4dc5345e88a59ba4d4) ([merge request](gitlab-org/gitlab!143128))
- [Change logic of oauth_authorization_path for GitLab Jira App](gitlab-org/gitlab@2e2010e3f090bafad371f2a1787d9edccbea38ff) ([merge request](gitlab-org/gitlab!143543))
- [Fix pipeline page timeout](gitlab-org/gitlab@1bc7e2a55723f3ef8701c909d6849d8afb535db1) ([merge request](gitlab-org/gitlab!143413))
- [VSD - Group merge request throughput should include subgroups](gitlab-org/gitlab@6dcecc1c11a5027e204d473553e7e440d53b1e5b) ([merge request](gitlab-org/gitlab!143377)) **GitLab Enterprise Edition**
- [Fix Redis 6.0 compatibility breakage with Sidekiq 7 gem](gitlab-org/gitlab@02467a794e381217f10ccdbf5717cbbf9b0e3086) ([merge request](gitlab-org/gitlab!142986))
- [Pass outbound_local_requests_whitelist to ProjectImporter](gitlab-org/gitlab@28995a77f33e4bf602ade8ea75d8e977784b7480) ([merge request](gitlab-org/gitlab!142893))
- [Fix mermaid diagrams in dark mode on linux](gitlab-org/gitlab@d99b43827dd67dc822d12e2c84715580e9d82d32) ([merge request](gitlab-org/gitlab!143459))
- [Fix webhooks to POST correct MR state after create](gitlab-org/gitlab@a7dbd4941d944e705f6d5196ec26e70ffa4ca193) ([merge request](gitlab-org/gitlab!143447))
- [Partial unique index on issuable-resource-links](gitlab-org/gitlab@96b575fcab74cee940bb904df4c69410c183b637) ([merge request](gitlab-org/gitlab!141549))
- [Use update services to unassign from issuables](gitlab-org/gitlab@dd6202dcbbde25adfbf19f9c922c9367677b5fcc) ([merge request](gitlab-org/gitlab!143045))
- [Fixes Rspec for FOSS edition](gitlab-org/gitlab@db7458bfe767acfe786f642724fdce849e23a1d6) ([merge request](gitlab-org/gitlab!143337))
- [Fix outdated pages brunch ci template](gitlab-org/gitlab@3e3b97e749c73029d31f3265977a9604895449b6) ([merge request](gitlab-org/gitlab!143336))
- [Update semver_dialects gem](gitlab-org/gitlab@7f8ebc1b288ed859c07ff0882e3a376bc3238263) ([merge request](gitlab-org/gitlab!143317)) **GitLab Enterprise Edition**
- [Remove archived projects from the group vulnerability report filter](gitlab-org/gitlab@71546ebc61c7f8192a6ac3500d6caa687ffb08a4) ([merge request](gitlab-org/gitlab!143315)) **GitLab Enterprise Edition**
- [Direct transfer: Handle case where bulk import status is nil](gitlab-org/gitlab@efe422a6cf870f56c669513f39d1a90a8eaef7e0) ([merge request](gitlab-org/gitlab!143291))
- [Make notification dropdown flippable](gitlab-org/gitlab@9924ba39ace06582286fdd0859e085dcda3133d7) by @bahek2462774 ([merge request](gitlab-org/gitlab!143257))
- [Update Kontra security training token](gitlab-org/gitlab@14e39c931d6e212bd2cc38c90402d8a46be1cfca) ([merge request](gitlab-org/gitlab!143277)) **GitLab Enterprise Edition**
- [Geo: Fix verification timeout of registry records](gitlab-org/gitlab@7987099fb9efcadefb7bc99e35fa4a5f35f5b027) ([merge request](gitlab-org/gitlab!143162)) **GitLab Enterprise Edition**
- [Fix alignment of note emoji btn on hover](gitlab-org/gitlab@a538c625b70a3134134962e89ec009016c4ef4f8) ([merge request](gitlab-org/gitlab!142834))
- [Fix email update on LDAP sync](gitlab-org/gitlab@9ccfd178cc6fc635e126060401169107983a11dd) ([merge request](gitlab-org/gitlab!142796)) **GitLab Enterprise Edition**
- [Downcase checksum in with_file_sha256 nuget symbol scope](gitlab-org/gitlab@c7fcbaae6a00824b26ab34985108cbc1ebd489c2) ([merge request](gitlab-org/gitlab!143262))
- [Fix epic subscription](gitlab-org/gitlab@784431025b22d9f4913c0a71d82704eaa16387f7) ([merge request](gitlab-org/gitlab!143249))
- [Hide draft comment note text when editing the comment](gitlab-org/gitlab@e69a7b72935aa07be8d0f22d43f960158200a481) ([merge request](gitlab-org/gitlab!142852))
- [Update star count component to work when logged out](gitlab-org/gitlab@dac9451e00251183a8571047f7db4ab425c9c946) by @espadav8 ([merge request](gitlab-org/gitlab!143047))
- [Add worker to sync approval rules with preexisting state](gitlab-org/gitlab@78678693be8d3d2a8cb407fa85f84c01b529d436) ([merge request](gitlab-org/gitlab!141095)) **GitLab Enterprise Edition**
- [Make sure the key attribute is unique](gitlab-org/gitlab@04442157e3d873616105646f3c48d2b54c3b75cd) ([merge request](gitlab-org/gitlab!143170))
- [This MR fixes code source selection](gitlab-org/gitlab@2d9a38724a93c9a392a12ae5f213c9875b33e72a) ([merge request](gitlab-org/gitlab!143008)) **GitLab Enterprise Edition**
- [This MR fixes adding extra characters](gitlab-org/gitlab@272e56176fec6cedb0457f4262c1f16933440189) ([merge request](gitlab-org/gitlab!143068)) **GitLab Enterprise Edition**
- [Redirect to correct page after dashboard SAML reauth](gitlab-org/gitlab@b5ce814f260b908baaeb0616735d96e51016d47f) ([merge request](gitlab-org/gitlab!142933)) **GitLab Enterprise Edition**
- [Fix vulnerability statistics adjustment service](gitlab-org/gitlab@d6d21d6662e9d74698ab5a4d002623d889229e5d) ([merge request](gitlab-org/gitlab!142684)) **GitLab Enterprise Edition**
- [Make nuget symbol files search case-insensitive](gitlab-org/gitlab@dd6abc7d74b58aba7312054535369620433a207f) ([merge request](gitlab-org/gitlab!142723))
- [Use `hidden` to prevent scollbars on inline math](gitlab-org/gitlab@30b6b1b3b4db4a1295363db86a456b77a35ec30d) ([merge request](gitlab-org/gitlab!142972))
- [Fix Members::DestroyService audit bug with removing subresources](gitlab-org/gitlab@d5bad07ac2762b488e1723adcb773673f7208273) ([merge request](gitlab-org/gitlab!142058)) **GitLab Enterprise Edition**
- [Use static list for dependency list licenses](gitlab-org/gitlab@a7f72c086f0a11deaa6d3a9704cde82543cb1907) ([merge request](gitlab-org/gitlab!142695)) **GitLab Enterprise Edition**
- [Fix invalid records with FK not valid](gitlab-org/gitlab@36bcd8b69954b22d3a0a4f6873e7799a6535089f) ([merge request](gitlab-org/gitlab!142896))
- [Only set CI_HAS_OPEN_REQUIREMENTS when licensed](gitlab-org/gitlab@1cb715e259818a485592f863cfc4aad702e25f82) ([merge request](gitlab-org/gitlab!142917)) **GitLab Enterprise Edition**
- [Emoji Picker button hover misalignment fix](gitlab-org/gitlab@a701195f5653a2e33dff464ad7ef91c3a4b039dd) ([merge request](gitlab-org/gitlab!142908))
- [Respect inherited font-size in markdown code block](gitlab-org/gitlab@50f378808d6417a0c9156de46e587f1332da27db) ([merge request](gitlab-org/gitlab!142882))
- [Load filter targets dynamically](gitlab-org/gitlab@be6147f9f39693d8394ad7d8a0513cd23efda433) ([merge request](gitlab-org/gitlab!142871)) **GitLab Enterprise Edition**
- [Allow non-development environments to perform local project imports](gitlab-org/gitlab@750d3d53b3132122da505ea85be6e818e6d8c127) ([merge request](gitlab-org/gitlab!142835))
- [Use active and correct add_on_purchase](gitlab-org/gitlab@cbab87474efb6a4847ffcdb90f1ab12ba79714e8) ([merge request](gitlab-org/gitlab!142812)) **GitLab Enterprise Edition**
- [Remove transaction around object pool mirroring](gitlab-org/gitlab@46218a4785f73a10641bf5e4d04e1f75182cc48f) ([merge request](gitlab-org/gitlab!142822))
- [Fix 403 error when using job token to access public project](gitlab-org/gitlab@16bb8da9f665fa751216f3c546e63e23a5366977) ([merge request](gitlab-org/gitlab!140903))
- [Fix creation of instance-level member roles](gitlab-org/gitlab@7012eb7c573ff08a306974dcdfd8c8d2ee06b27d) ([merge request](gitlab-org/gitlab!142636)) **GitLab Enterprise Edition**
- [Handle invalid API JSON input gracefully](gitlab-org/gitlab@8a98dadd5fbc3f6b3a1c014722c91e1c3c0a200c) ([merge request](gitlab-org/gitlab!142741))
- [Change SAML group lock self-managed to work on group sync and group SAML](gitlab-org/gitlab@0628a873297793a284b19acafed738f9addbfe9f) ([merge request](gitlab-org/gitlab!137579)) **GitLab Enterprise Edition**
- [Stop allowing approvals to be changed post merge](gitlab-org/gitlab@7c565585a5dc7493a923c32ed8e2d51b434fce1c) ([merge request](gitlab-org/gitlab!142705))
- [Use LFS change size for pushes, not total size](gitlab-org/gitlab@1c1b1d99893428289da0c6136fb2c98289bf653e) ([merge request](gitlab-org/gitlab!140604)) **GitLab Enterprise Edition**
- [Fix NoMethodError from Projects::BlobController#show](gitlab-org/gitlab@108c095516baecab239b6b732ba6c91f6164035c) ([merge request](gitlab-org/gitlab!142701)) **GitLab Enterprise Edition**
- [Disable pipeline_stage_set_last_modified FF](gitlab-org/gitlab@2a603c45f36c43a368b3cb42baaa7209b7213846) ([merge request](gitlab-org/gitlab!142683))
- [Fix breadcrumb and page title for Wiki/New page](gitlab-org/gitlab@bb24ab345d1ced58940559249a45d8e2e73c2a75) ([merge request](gitlab-org/gitlab!142416))
- [Only perform workspace agent validation on create](gitlab-org/gitlab@ad8808c16bb0e497a6d46b5a48a744dab246c818) ([merge request](gitlab-org/gitlab!142654)) **GitLab Enterprise Edition**
- [Fix issue search when created from another locale](gitlab-org/gitlab@7a3168c37303df3255398130c5ab85702ead19cf) ([merge request](gitlab-org/gitlab!142652))
- [Revert: Fix pages with case sensitive paths](gitlab-org/gitlab@d60f35d72201169d111ded6385c208b45ea26882) ([merge request](gitlab-org/gitlab!142638))
- [Execute hooks from timelog create service](gitlab-org/gitlab@d3298520740455a446479b1843acacaa580a1acf) by @zillemarco ([merge request](gitlab-org/gitlab!141916))
- [Fix punctuation on profile edit page](gitlab-org/gitlab@53817f4fdf1479b2a1191f7d13cf1ac6263d6ea5) ([merge request](gitlab-org/gitlab!142472))
- [Fix error in Mapper::Normalizer when CI include value type is invalid](gitlab-org/gitlab@c04f536620d53dfc175668d3abbf6c50861ea7bc) ([merge request](gitlab-org/gitlab!142616))
- [Bump semver_dialects gem](gitlab-org/gitlab@9fb4fae8bf2f0ed854cfbbf8b232d48fb1043f19) ([merge request](gitlab-org/gitlab!142607))
- [Fix Gitlab::Llm::Completions::Chat default value for the options param](gitlab-org/gitlab@df476fe9ddd2f71ba4b9ee69b02b4f603bee9de4) ([merge request](gitlab-org/gitlab!142084)) **GitLab Enterprise Edition**
- [Fix current_license_title namespace translation](gitlab-org/gitlab@6f64497263b61435e0e7e05cd7c4dbf3b1200b43) ([merge request](gitlab-org/gitlab!142587))
- [Truncate commit author on blame view when under 3 lines](gitlab-org/gitlab@36df40d1a3ab6292e1a4a1cff74722afd0bc9683) ([merge request](gitlab-org/gitlab!142043))
- [Fix action/rule deletion bug](gitlab-org/gitlab@710e25c8adbabda357440ca31aab50e80e485cea) ([merge request](gitlab-org/gitlab!140533)) **GitLab Enterprise Edition**
- [Vulnerability Details: Fix generic report types](gitlab-org/gitlab@4c5efd59b93adf9cab3d455d565cb24913254dc7) ([merge request](gitlab-org/gitlab!142220)) **GitLab Enterprise Edition**
- [Group dropdown on New Project page respects visibility settings](gitlab-org/gitlab@65a1e7fdb6813fc0e86a7130dd840dcb8fef57b6) ([merge request](gitlab-org/gitlab!140853))
- [Add with-header class to root element in minimal and devise empty views](gitlab-org/gitlab@84a7d2845bc487476ad4c1c5f3fbd84219dc1f1b) ([merge request](gitlab-org/gitlab!142079))
- [Set modal title to finding title](gitlab-org/gitlab@ce24424f093d245fe2ed4a1a4a10d92a89a04120) ([merge request](gitlab-org/gitlab!142140)) **GitLab Enterprise Edition**
- [Defer ConnectionPool instrumentation setup](gitlab-org/gitlab@747a5ed7e16737b3793598265e55a90cc2b55c6f) ([merge request](gitlab-org/gitlab!142042))
- [Create merge request button: Fix spacing in dropdown](gitlab-org/gitlab@f3c70dc2bf1e3d073d38510bd8fc97c2d735c36a) ([merge request](gitlab-org/gitlab!142184))
- [Improve decimal precision for small VSD metric values](gitlab-org/gitlab@05654fe07da6c07b654a675ac35ebfb9c7e1433a) ([merge request](gitlab-org/gitlab!141450)) **GitLab Enterprise Edition**
- [Update review button variant](gitlab-org/gitlab@0476bcf36776a11877907291f3d0cb46ffcc36a7) ([merge request](gitlab-org/gitlab!142245))
- [Fix issue with pasting images in RTE](gitlab-org/gitlab@391f84db218a67f205fa9164b933c30f58c88899) ([merge request](gitlab-org/gitlab!142244))
- [Referencing a user with "me" could result in an incorrect quick action](gitlab-org/gitlab@61ef25232ec9152bff185b386998e25db7778447) ([merge request](gitlab-org/gitlab!139712)) **GitLab Enterprise Edition**
- [Update nullable on author field on NoteType](gitlab-org/gitlab@801077b3c883bfba3f4d8b2266a9fdb58654dfa3) ([merge request](gitlab-org/gitlab!142206))
- [Allow non-admin access to user activities](gitlab-org/gitlab@fb7c8382fb1d6d10d6e63b77b34ecd811bd7de1a) ([merge request](gitlab-org/gitlab!141767))
- [Add team members to policy project only when not added for the group](gitlab-org/gitlab@2dee7c5f97ca5c09bca84634db6db6233091d330) ([merge request](gitlab-org/gitlab!141592)) **GitLab Enterprise Edition**
- [Use component_version_id instead component_id for](gitlab-org/gitlab@baa4a0de591bc493047b295fb67d8e9dd7beb3a6) ([merge request](gitlab-org/gitlab!142161)) **GitLab Enterprise Edition**
- [Fix pages with case sensitive paths](gitlab-org/gitlab@3a456fdee226a896357077f7c08028bc06f76acc) ([merge request](gitlab-org/gitlab!142188))
- [Ensure SVGs are properly compiled](gitlab-org/gitlab@f66e091a8da330dc0a28fd77d143267aff377467) ([merge request](gitlab-org/gitlab!141548))
- [Fix source code highlighting when using relative URL](gitlab-org/gitlab@9165b5fce9b3f1ed895356ff1c04ea96ba9edf96) ([merge request](gitlab-org/gitlab!141984))
- [Fixes project export task issue](gitlab-org/gitlab@f245593f8be5e099caa64f433079b7e4657b1ec1) ([merge request](gitlab-org/gitlab!142039))
- [Use different localStorage sorting key](gitlab-org/gitlab@fca67af7956a997e65aa4fd6c0fc4e55fba1547b) by @bahek2462774 ([merge request](gitlab-org/gitlab!141937))
- [Remember BACKUP for untarred backups](gitlab-org/gitlab@cc44a9dbd8288e3c48056e931eb65303daffd3b0) ([merge request](gitlab-org/gitlab!141440))
- [Nullify `dismissal_reason` when a vulnerability is un-dismissed](gitlab-org/gitlab@6420d0f7e9304bb226f371712476821e00eccd86) ([merge request](gitlab-org/gitlab!141245)) **GitLab Enterprise Edition**
- [Fix GitLab typo in empty state group page](gitlab-org/gitlab@73de2e4149434eb3bcd9dc919058ec9adcdaaf59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/141895))
- [MR Media report widget alignment fix](gitlab-org/gitlab@1edbfa9ac6fbe5042418deffb01a90ad83f4533a) ([merge request](gitlab-org/gitlab!141981))
- [Hide viz designer button until product analytics onboarded](gitlab-org/gitlab@afb4d54cbaa92a9cbff664ff02ae5c49c6dac9a1) ([merge request](gitlab-org/gitlab!141325)) **GitLab Enterprise Edition**
- [Update RTV and ETV to use subscription ID](gitlab-org/gitlab@bc97b923570a677d48a6044e77cb585552acc89b) ([merge request](gitlab-org/gitlab!140884)) **GitLab Enterprise Edition**
- [Diff controls alignment fix](gitlab-org/gitlab@39baea28294eba3e27010b9ae917714848f2db7a) ([merge request](gitlab-org/gitlab!141979))
- [Validate repo import scope](gitlab-org/gitlab@9a33f82f4c5c893dd81467cec93b350203b5788d) ([merge request](gitlab-org/gitlab!141762))
- [Add VulnerabilitiesFinder for scan result policies](gitlab-org/gitlab@cef6c3b8089b6af5c570626152f175bb4caee3c7) ([merge request](gitlab-org/gitlab!141052)) **GitLab Enterprise Edition**
- [Issues list: spacing between labels](gitlab-org/gitlab@95dbe008aba60342195bfa4939371fd1099319f0) ([merge request](gitlab-org/gitlab!141760))
- [Resolve feedback banner not showing on the behavior dashboard](gitlab-org/gitlab@8ba4e5dcecf39baa7f15a1b525d39032ae91d43f) ([merge request](gitlab-org/gitlab!141753)) **GitLab Enterprise Edition**
- [Unify dividing line color in commit info-well](gitlab-org/gitlab@71257740d9dc9db05cec169424e0ab2dbd3eb63d) ([merge request](gitlab-org/gitlab!141652))

### Changed (209 changes)

- [Show subscription next term start date](gitlab-org/gitlab@332f61ca39f679119b8a70fef16750945e9d4ff8) ([merge request](gitlab-org/gitlab!143439)) **GitLab Enterprise Edition**
- [Filter out unlincensed work item widget definitions](gitlab-org/gitlab@2a043c41234fc8294b6d2b17f93fb5bb35d442d5) ([merge request](gitlab-org/gitlab!142746)) **GitLab Enterprise Edition**
- [Add rails payload to zoekt indexing callbacks](gitlab-org/gitlab@26e5ab8db15025ff890c0cad6ca295eb08505818) ([merge request](gitlab-org/gitlab!142865)) **GitLab Enterprise Edition**
- [Update deployment tests to vue 3](gitlab-org/gitlab@fef86060fb9e44c788541e6a293e9da2e94bea5a) ([merge request](gitlab-org/gitlab!144367))
- [Update comment form tests for vue 3](gitlab-org/gitlab@9a983ab621bc45615db41a0c7a0aff3e30319750) ([merge request](gitlab-org/gitlab!144366))
- [Reorganize profile page layout](gitlab-org/gitlab@2934d5a2a640d195cb0c8df6f3d22d373cc88799) ([merge request](gitlab-org/gitlab!137024))
- [Enable CRM by default](gitlab-org/gitlab@55f027781facbcabdce3aab3feb4d1ae7b143faf) ([merge request](gitlab-org/gitlab!108378))
- [Uses similarity sort for projects query](gitlab-org/gitlab@3ea9934ef98d8fd4d192dabb174b639cd57e46f1) ([merge request](gitlab-org/gitlab!144363))
- [Fixing rubocop exceptions no. 7](gitlab-org/gitlab@48c5d6af6c42633e4d905c8886f43eaadc5c1ec5) ([merge request](gitlab-org/gitlab!144060))
- [Remove `determine_blank_ref_based_on_gitaly_object_format` feature flag](gitlab-org/gitlab@3498dfc49f5d41647a6ee04a9af63a5339a013f1) ([merge request](gitlab-org/gitlab!144306))
- [Changes for optimizing expiring worker](gitlab-org/gitlab@24d80c655bc42b85faa25fd4d31816b741edbd96) ([merge request](gitlab-org/gitlab!144063))
- [Add group by dropdown on adherence report](gitlab-org/gitlab@c3825697aa2443015295c22afab58831c3d0a380) ([merge request](gitlab-org/gitlab!143557)) **GitLab Enterprise Edition**
- [Reposition catalog setting](gitlab-org/gitlab@6ac46b5ab0b832555b115e8d59426e8da7a9dc84) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144256))
- [Improve analytics settings copy](gitlab-org/gitlab@8d4c76102a651b32e2ec658bbc8a8451b5e80b3a) ([merge request](gitlab-org/gitlab!144264)) **GitLab Enterprise Edition**
- [Migrate label empty state component](gitlab-org/gitlab@08a9d3910ba107fbcc44c0ac65735c9b366ff6d5) ([merge request](gitlab-org/gitlab!144064))
- [Pipeline manual action: Migrate dropdown to GlDisclosureDropdown](gitlab-org/gitlab@87c40a31cb5b29d6c68e4dffc8c41ebe73aaa7b2) ([merge request](gitlab-org/gitlab!143092))
- [Update old Geo DB docs link](gitlab-org/gitlab@e2d1c72d59ebad5e4eb0bccec82b99dba1ac1893) ([merge request](gitlab-org/gitlab!142932)) **GitLab Enterprise Edition**
- [Replace UI usages of shared runner with instance runner](gitlab-org/gitlab@765bbac324a81bd4e990875560dff9cf1dfb7810) ([merge request](gitlab-org/gitlab!143480))
- [Show alert in CI Variable drawer](gitlab-org/gitlab@545f3e784e6709ac162ec86ac67090408e060431) ([merge request](gitlab-org/gitlab!143901))
- [Rewrite Cloud Connector architecture docs](gitlab-org/gitlab@04ba8a1e0369fc72fbef50ac4c9621e72369b8f5) ([merge request](gitlab-org/gitlab!143538))
- [Fix security policy source to not trigger pipelines for tags](gitlab-org/gitlab@50894d0931cfdf2a652849a4676c095780b2bced) ([merge request](gitlab-org/gitlab!143089))
- [Enhance navigation in findings drawer with tooltip and button group](gitlab-org/gitlab@08df56dcb103340913f809004a9734edebe9eca7) ([merge request](gitlab-org/gitlab!143942)) **GitLab Enterprise Edition**
- [Add new integration logos](gitlab-org/gitlab@fcf1ea87634a70ceb0d7a5e3a14649771f099786) ([merge request](gitlab-org/gitlab!143945))
- [Premium customers can use GitLab Duo Chat](gitlab-org/gitlab@ddf5034094daf4bbfdf5f94c171f8c10f3a983af) ([merge request](gitlab-org/gitlab!142808)) **GitLab Enterprise Edition**
- [Set minimum Redis version in system check to 6.0.0](gitlab-org/gitlab@7aff713bce676a49a1504ab500dd635808283e9a) ([merge request](gitlab-org/gitlab!143643))
- [Add new route /bulk_imports/:id/history](gitlab-org/gitlab@a9858666566b3b9477ff5eae78e02f4b94fc42ff) ([merge request](gitlab-org/gitlab!143322))
- [Add tooltip with help docs to license scanning widget](gitlab-org/gitlab@123d60836dd352abc1e03e28420eaacbe830ef8f) ([merge request](gitlab-org/gitlab!144072))
- [Fixing rubocop exceptions in tests no 8](gitlab-org/gitlab@102eb807715e727caf883902d1072c64f5acff76) ([merge request](gitlab-org/gitlab!144080))
- [Fixes issue actions presentation at small size](gitlab-org/gitlab@1562926f5d1dffa7a23aa6f2c75f1572c6721f4a) ([merge request](gitlab-org/gitlab!144073))
- [Add runner usage breakdown to dashboard](gitlab-org/gitlab@20007fea48361e6e0650c86538dd05d34b877b6b) ([merge request](gitlab-org/gitlab!143680)) **GitLab Enterprise Edition**
- [Remove .borderless, .nav-links-unboxed](gitlab-org/gitlab@49625137f004a720161c5c61beec5318a5d22e10) ([merge request](gitlab-org/gitlab!143933))
- [Support nested arrays in CI config `stages`](gitlab-org/gitlab@24d85084d6a5eff195b2ba1a0b487474385bf1aa) by @suyash-chavan ([merge request](gitlab-org/gitlab!142916))
- [Expose committed_before and committed_after](gitlab-org/gitlab@53de24d78ed29fc64a422a8b63ae1d422610d152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/143354))
- [Update GITLAB_PAGES_VERSION](gitlab-org/gitlab@fec61ffdf2056102bb76c471430db03c0f02376b) ([merge request](gitlab-org/gitlab!144024))
- [Use 'last_activity_at' for project list order by last updated](gitlab-org/gitlab@d69b9d65321f97b5f44cbc6bcda173762d6ca86b) ([merge request](gitlab-org/gitlab!143054))
- [Add import stats to bulk_import_history_app](gitlab-org/gitlab@aa779d93e3bdfa1bec64ec0c10c6a6b770bde9b6) ([merge request](gitlab-org/gitlab!143776))
- [Invite Group Modal - Use new API on project view](gitlab-org/gitlab@a3cafefa378ac7ba3eac3a5528d2b2087052c722) ([merge request](gitlab-org/gitlab!143431))
- [Disable new schedule button](gitlab-org/gitlab@82380af6a76c58428f4be095be7772d93e955892) ([merge request](gitlab-org/gitlab!143669))
- [Remove `compliance_standards_adherence_csv_export` feature flag](gitlab-org/gitlab@d2cf0bd03129be8fb383b58e1a1db809ba014129) ([merge request](gitlab-org/gitlab!143397)) **GitLab Enterprise Edition**
- [Rename Infrastructure Registry page title to Terraform Module Registry](gitlab-org/gitlab@5b4c8e19493961d9d51312847494cc37231361bb) ([merge request](gitlab-org/gitlab!143599))
- [This MR changes flow for compliance framework](gitlab-org/gitlab@fbed514e66f3db53f3121b216b89ab9a19458cbf) ([merge request](gitlab-org/gitlab!143442)) **GitLab Enterprise Edition**
- [Show various MR keyboard shortcuts in tooltips](gitlab-org/gitlab@817076618f1c5a937b3db5359bcdeb710095c621) ([merge request](gitlab-org/gitlab!143088))
- [Migrates .d-md-flex to .gl-md-display-flex!](gitlab-org/gitlab@b5794c3424553bef95fa28c19e66dbc2c74530b6) ([merge request](gitlab-org/gitlab!143225))
- [Add approvalPolicies field and deprecate scanResultPolicies](gitlab-org/gitlab@ea278f57cd37d52f442a7e413a43475c0b79846e) ([merge request](gitlab-org/gitlab!142662)) **GitLab Enterprise Edition**
- [Replace taskable argument with name](gitlab-org/gitlab@5861fc16f202a9b9e4d54c0a49233ec4c7f5f23b) ([merge request](gitlab-org/gitlab!140074))
- [Align X Ray permission model to Duo Pro Add On](gitlab-org/gitlab@685c1caa432d90a0507d146e04654d66753f767b) ([merge request](gitlab-org/gitlab!143798)) **GitLab Enterprise Edition**
- [Move order of collaborators import](gitlab-org/gitlab@ecef4593b2e003eecab9a7ad2177a23ba2ebf57e) ([merge request](gitlab-org/gitlab!142732))
- [Update permissions for adding a child issue to an epic](gitlab-org/gitlab@cf1934f55851b357a0601fde4648f1c3c8456cc1) ([merge request](gitlab-org/gitlab!136322))
- [Enable dora_performers_score_panel feature flag by default](gitlab-org/gitlab@20d8f1262055b260dc817230b2cbb7f4dd1376eb) ([merge request](gitlab-org/gitlab!143711)) **GitLab Enterprise Edition**
- [Update ui text for MR comment filters](gitlab-org/gitlab@8a7eb400ac9c47204755fe408b42d440e4bcba72) ([merge request](gitlab-org/gitlab!143700))
- [Auto approve pending members on user cap disable](gitlab-org/gitlab@1d3fb482a0fbc025c157aa2c4403c8b1ac973590) ([merge request](gitlab-org/gitlab!142711)) **GitLab Enterprise Edition**
- [Update sbom occurrence source fields ingestion](gitlab-org/gitlab@369f70468494911a521ac2652b4472ffddd499c0) ([merge request](gitlab-org/gitlab!140282)) **GitLab Enterprise Edition**
- [Pipeline MiniGraph: Migrate dropdown to GlDisclosureDropdown](gitlab-org/gitlab@f954ec9288a0b459a571cbb4b7c3949a704b6821) ([merge request](gitlab-org/gitlab!142427))
- [Add severity sort for group level dependencies](gitlab-org/gitlab@b5e23fe4195d2de78473350bc0b7c61d77a8d39b) ([merge request](gitlab-org/gitlab!143087)) **GitLab Enterprise Edition**
- [Refine Add code task copy](gitlab-org/gitlab@dfdb0a19f4ebcd59c618f8b5fa527c368b795578) ([merge request](gitlab-org/gitlab!143641)) **GitLab Enterprise Edition**
- [Update help text for GitHub import PAT field](gitlab-org/gitlab@e9a1ebbaf222ec62df77479784b95a412a733a42) ([merge request](gitlab-org/gitlab!143042))
- [Migrate buttons in overflow_warning_component.rb](gitlab-org/gitlab@0916c7470f6eb31a7514dbe7bd361edcaa84e186) ([merge request](gitlab-org/gitlab!142956))
- [Add delimiters to large numbers in analytics chart tooltips](gitlab-org/gitlab@2b7b2f8d01dc6971c8db2458a4316de6d94ff428) ([merge request](gitlab-org/gitlab!141729)) **GitLab Enterprise Edition**
- [Remove code_suggestions_claude21 flag](gitlab-org/gitlab@922a127849bdc6862feb14793bec2c8dddf82839) ([merge request](gitlab-org/gitlab!142517)) **GitLab Enterprise Edition**
- [Use container registry API to fetch a tag](gitlab-org/gitlab@e37476b209127bdef105d9f11454345d6b1bab0e) ([merge request](gitlab-org/gitlab!143624))
- [Update dependency auto-deploy-image to v2.80.1](gitlab-org/gitlab@c1008124419a70d94283c7a1e99d80f2ee9ea623) ([merge request](gitlab-org/gitlab!143454))
- [Update styles for services table](gitlab-org/gitlab@7fa11632bf67fb08a585f6b5682c3bb2f22e0bc2) ([merge request](gitlab-org/gitlab!142324))
- [Remove CRM organizations navigation menu item](gitlab-org/gitlab@1b3027e1e7323d06f79f0eff3fe9fe22869e63c7) ([merge request](gitlab-org/gitlab!142984))
- [Updated URLs for "Issues closed" links in Value Streams Dashboard](gitlab-org/gitlab@ab7eafd3781a1cb6cbbc781d8022870b6ebdc6c0) ([merge request](gitlab-org/gitlab!143142))
- [Migrates full width class](gitlab-org/gitlab@1368185ca396771f676e0e3b354ff1af93a5a44a) ([merge request](gitlab-org/gitlab!143179))
- [Remove projectPath argument from ciCatalogResourcesResolver](gitlab-org/gitlab@d319fbcf5f1dc9c859d19654e15e314e3525768a) ([merge request](gitlab-org/gitlab!143194))
- [Migrates height utility classes](gitlab-org/gitlab@18bde32b1bc886cba1645cb861184e8f69e71cac) ([merge request](gitlab-org/gitlab!143185))
- [Use radio buttons for admin group permission](gitlab-org/gitlab@fc2e88836cd126d592cfa157b19a2d4f5e6190de) ([merge request](gitlab-org/gitlab!143424))
- [Add GlSingleStat to haml](gitlab-org/gitlab@53a51f5d127b3adbb772964cbe8e27ab19d9675f) ([merge request](gitlab-org/gitlab!142682))
- [Remove `scan_result_policy_merge_base_pipeline` feature flag](gitlab-org/gitlab@d9fb7ad67ad4373a76c1d518ec6c18b5b4032b6b) ([merge request](gitlab-org/gitlab!142830))
- [Adds `jira_connect_public_key_storage_enabled` field](gitlab-org/gitlab@8fb21b6930e0f982e831093e11fc566da3354ba0) ([merge request](gitlab-org/gitlab!143265))
- [Custom role UI enhancements](gitlab-org/gitlab@fb3c552029fbb810e7f505714d872b1c3cf584f2) ([merge request](gitlab-org/gitlab!141887)) **GitLab Enterprise Edition**
- [Detect usage of pinned nav item and handle section expanded state](gitlab-org/gitlab@bb5d7e320e4e831b3a063a28c7ea2a6eb848a719) ([merge request](gitlab-org/gitlab!142430))
- [Do not pre-select group import target namespaces](gitlab-org/gitlab@2d7fe46438c6f0a245d86d2c6a8f935d9f7ad69e) ([merge request](gitlab-org/gitlab!142265))
- [Remove use_cloud_connector_lb feature flag](gitlab-org/gitlab@19747da6dcecbe4dfffe35f0785f95e8b4edf7be) ([merge request](gitlab-org/gitlab!142564))
- [Update policy type param for editing to use approval_policy](gitlab-org/gitlab@59a37392c20ed09a398766b4705cbefffe236323) ([merge request](gitlab-org/gitlab!143062)) **GitLab Enterprise Edition**
- [Add limits for license names](gitlab-org/gitlab@5e950bd501f2b8c01ea7dd61598f63f354ba35d1) ([merge request](gitlab-org/gitlab!143137)) **GitLab Enterprise Edition**
- [Migrate float-right to gl-float-right](gitlab-org/gitlab@3ab9200bf7db26f0451ac0da2c7e365cc9ec3cb4) ([merge request](gitlab-org/gitlab!143260))
- [This MR changes schema for external file path](gitlab-org/gitlab@b4a1a4054b96b8cbba04f332541ca8396c48a988) ([merge request](gitlab-org/gitlab!143095)) **GitLab Enterprise Edition**
- [WorkItemDelete mutations handle group](gitlab-org/gitlab@07079c2ba3c8f41b6977267b526dda3f160bb306) by @imskr ([merge request](gitlab-org/gitlab!141044))
- [Add blame data to simple viewer](gitlab-org/gitlab@c160a5c76b6062226a58659d6675eed337b41e71) ([merge request](gitlab-org/gitlab!141377))
- [Hides user checkbox that allows group creation](gitlab-org/gitlab@60410ca9274a55bd1cc7f479eda16a8c7a81417d) ([merge request](gitlab-org/gitlab!138863))
- [Work item - mobile ancestors widget](gitlab-org/gitlab@7c1a99f3dcd6f9deec50cc87e31143410c3d090f) ([merge request](gitlab-org/gitlab!142388))
- [Migrates .align-items-center to .gl-align-items-center](gitlab-org/gitlab@88b103a8c37ae1de9a10f9b2e8153402fb3bb4bb) ([merge request](gitlab-org/gitlab!143183))
- [Refactor FindChangedPaths RPC call for initial commits](gitlab-org/gitlab@b7f95f3c08e0a244aaca29e2079f2398a8888572) ([merge request](gitlab-org/gitlab!143216))
- [Update match_on_inclusion to match_on_inclusion_license](gitlab-org/gitlab@d00eb911298ff2eca9b817157b1c6cfb23c0c77d) ([merge request](gitlab-org/gitlab!141931)) **GitLab Enterprise Edition**
- [Remove help text about creating groups when creating a project](gitlab-org/gitlab@aeff20523fc4e14d2417b8a8bf1e287a1318ca60) ([merge request](gitlab-org/gitlab!142942))
- [Allow local request origin when in dev](gitlab-org/gitlab@b3cf1cb7a89ba04c8afb36095420a0786d7b77b5) ([merge request](gitlab-org/gitlab!143227))
- [Add item_to_preload method in helper and migrations](gitlab-org/gitlab@d32f8908e54c6cf2a0810e21dec024243288ff4e) ([merge request](gitlab-org/gitlab!143035)) **GitLab Enterprise Edition**
- [Clean up caching importer](gitlab-org/gitlab@f97ce7f059e31b1d500e8dde07974585cb292539) by @imskr ([merge request](gitlab-org/gitlab!139395))
- [Remove todo for group_saml/sso_state_spec](gitlab-org/gitlab@93bf5ecfe974f182f412f833a7c30820ff6226cb) ([merge request](gitlab-org/gitlab!143210))
- [Add cleanup to testAuthServer](gitlab-org/gitlab@7b6a08ea48e6af42535697be80ec111510bf8538) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/143200))
- [Use finished deployments in Environments stop actions](gitlab-org/gitlab@0606f196ebddaad6af05477c0dfd7985cb61d013) ([merge request](gitlab-org/gitlab!141216))
- [Migrate .lh-100 to .gl-line-height-1](gitlab-org/gitlab@f5b98ed77ed3af7a3bd69d73035a4527149dd634) ([merge request](gitlab-org/gitlab!143184))
- [Remove sms_send_wait_time feature flag](gitlab-org/gitlab@9cf2df77e3949ca5055768dc7835f3dc24ef5a6c) ([merge request](gitlab-org/gitlab!143181))
- [Migrates flex-wrap](gitlab-org/gitlab@2ccb31526f4081e0f3973e517e7b22fdb40bdd6a) ([merge request](gitlab-org/gitlab!143178))
- [Enable github_import_lock_user_finder feature flag by default](gitlab-org/gitlab@d64dfe1ae2ec8e293fcb29c3b8ad0bad035f9134) ([merge request](gitlab-org/gitlab!143118))
- [Import resources using GitHub Import timeline API](gitlab-org/gitlab@61291d98dadef485f90bc42fab7f119cd4545216) ([merge request](gitlab-org/gitlab!143082))
- [Update dependency auto-deploy-image to v2.80.0](gitlab-org/gitlab@24691372f8048cd102d92e4046371ac11b6edf92) ([merge request](gitlab-org/gitlab!143097))
- [Implementing Trial Discover Page Experiment Stage 1](gitlab-org/gitlab@fcd080a98fd90f4bd9383484bce84fff356002fe) ([merge request](gitlab-org/gitlab!142824)) **GitLab Enterprise Edition**
- [Enable geo_proxy_check_pipeline_refs by default](gitlab-org/gitlab@e3d11a5d43e347388a9b02812399c0f97f847c40) ([merge request](gitlab-org/gitlab!142609)) **GitLab Enterprise Edition**
- [Show find file and permalink shortcut in tooltip](gitlab-org/gitlab@cfbbe8907f01220529218767c606320af5c8fe61) ([merge request](gitlab-org/gitlab!140979))
- [Improve dark-mode theme in sign in/up pages](gitlab-org/gitlab@e0ff9a3a5234365b35b96fbd27a3c3767b4de2fe) ([merge request](gitlab-org/gitlab!142656))
- [Hide keyboard shortcuts in tooltips when disabled](gitlab-org/gitlab@9a084be7f98220a9992d225688c8d2af3de121f7) ([merge request](gitlab-org/gitlab!143067)) **GitLab Enterprise Edition**
- [Update pipeline findings description and report label](gitlab-org/gitlab@5c701bf2d0ee3de1c6b48a8dff013e34e2cc82a7) ([merge request](gitlab-org/gitlab!142783)) **GitLab Enterprise Edition**
- [Migrate existing policy to approval_policy on replace](gitlab-org/gitlab@316ed26c5c494edc6904884deff2eb18603c8210) ([merge request](gitlab-org/gitlab!143055)) **GitLab Enterprise Edition**
- [Use traversal_ids for project search](gitlab-org/gitlab@8464b44673f0e14488eec0163ddfc8ee8ccfb797) ([merge request](gitlab-org/gitlab!142310)) **GitLab Enterprise Edition**
- [Add /remove_parent quick action for work items](gitlab-org/gitlab@5e8b892ef55f79bfd3ce38e3db7ac7ec796b4114) ([merge request](gitlab-org/gitlab!142174))
- [Change Web App Manifest `display` from `browser` to `standalone`](gitlab-org/gitlab@42a65f0ef5e3153104aa20d0a51d1f33720f0ba9) by @LasseRosenow ([merge request](gitlab-org/gitlab!139311))
- [Code dropdown: Migrate to GlDisclosureDropdown](gitlab-org/gitlab@17f29187ce6037235543961f3abf411f7372d2f1) ([merge request](gitlab-org/gitlab!142554))
- [Update dependency auto-deploy-image to v2.79.0](gitlab-org/gitlab@ec5225f8b3d6867dbffb85463305a10ab9de688f) ([merge request](gitlab-org/gitlab!143011))
- [Productize tier_badge experiment](gitlab-org/gitlab@fd8921b74720a5595d496bcebb6e5a917dc383d0) ([merge request](gitlab-org/gitlab!142437)) **GitLab Enterprise Edition**
- [Removes dot from edit board button](gitlab-org/gitlab@3a871d3d1dd664a04df807576d407f234da959a7) ([merge request](gitlab-org/gitlab!142579))
- [Support `approval_policy` in JSON schema](gitlab-org/gitlab@5a11de9d7f7e0aa806e165817c3cddf15e55ce11) ([merge request](gitlab-org/gitlab!142559)) **GitLab Enterprise Edition**
- [Update po files](gitlab-org/gitlab@bdec4bb332900d4fd66460e591866fcec6712a46) ([merge request](gitlab-org/gitlab!142353))
- [Set minimum Redis version in system check to v6.2.0](gitlab-org/gitlab@0586518d4b2662d214323a3783f581283517cd6a) ([merge request](gitlab-org/gitlab!142881))
- [Move runner description field under configuration](gitlab-org/gitlab@a5087149e52de70c075c8be137f40e2edc7ff2e3) ([merge request](gitlab-org/gitlab!142531))
- [Finalize UUID backfilling before column type migration cleanup occurs](gitlab-org/gitlab@e4a4b4b84ffdb62da00016ac0a942e45d89e25c7) ([merge request](gitlab-org/gitlab!142537))
- [Feat(Feature flag): remove key_contacts_management](gitlab-org/gitlab@ad468e2811c4abf31406d64a26f775a97476f66e) ([merge request](gitlab-org/gitlab!142578)) **GitLab Enterprise Edition**
- [Allow workhorse extra config command to have arguments](gitlab-org/gitlab@ab8b42ca5e4a838b900c0577ae9c4de3ce5baebd) ([merge request](gitlab-org/gitlab!142781))
- [Remove the prefix_ci_build_tokens feature flag](gitlab-org/gitlab@02f063d67fc609ec0ba6bed810fa5c9e42ac0976) ([merge request](gitlab-org/gitlab!142622))
- [Add component names to resource item](gitlab-org/gitlab@d04aeea24875dc074b98d94d4e5fabbce188193a) ([merge request](gitlab-org/gitlab!142240))
- [Emoji picker: Migrate dropdown to GlDisclosureDropdown](gitlab-org/gitlab@219529e676209c1e2bf7603d43e43d3dc1b9920a) ([merge request](gitlab-org/gitlab!142201))
- [Update gitlab-pages](gitlab-org/gitlab@a2b061279ca9cb3ce6e2e35a05f4e1357e10ac13) ([merge request](gitlab-org/gitlab!142698))
- [FF use_sync_service_token_worker enabled by default](gitlab-org/gitlab@68d09f6ae753c178bdd82ce64f9702be6a70ef96) ([merge request](gitlab-org/gitlab!142699))
- [Improve specs for GroupSaml::SsoState](gitlab-org/gitlab@1ed9e8e5c7162fe4be3bac3d5103cd3ca9803020) ([merge request](gitlab-org/gitlab!142697)) **GitLab Enterprise Edition**
- [Update vendor/spdx.json to v3.22](gitlab-org/gitlab@3d8092242e6777cb0a2deed1b5cfdf45fc0bd185) ([merge request](gitlab-org/gitlab!142603))
- [Update documentation](gitlab-org/gitlab@6a3397eaa3b79ff95037088dd10271d8d331645b) ([merge request](gitlab-org/gitlab!142568)) **GitLab Enterprise Edition**
- [Excludes Ml::Models from showing up on Experiments](gitlab-org/gitlab@2dd2d56069689ee2df8f932c7d892c6bf54c9ae7) ([merge request](gitlab-org/gitlab!142693))
- [Replace geo empty state illustration](gitlab-org/gitlab@1a94110ac1974d1cc498fbb08e61370f34bdcdb9) ([merge request](gitlab-org/gitlab!142163))
- [Use t.Cleanup for startWorkhorseServerWithConfig startWorkhorseServer](gitlab-org/gitlab@7ec62666145c726ccb605b177314555b2c729b4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142674))
- [Use t.Cleanup in upstream_test](gitlab-org/gitlab@1927032c7566cfa9f4ae6a6f70d954b80c6ec37b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142678))
- [Use t.Cleanup in range_test](gitlab-org/gitlab@1404419fbdbee651ece19810a8675e56701f4fe6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142668))
- [Use t.Cleanup in artifacts_upload_test](gitlab-org/gitlab@63af9c580f6251456a57843ec6b869592915bf39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142673))
- [Add UI polish to issue analytics table](gitlab-org/gitlab@bb7c7d20d6d3fae5cac17b572a00880ed08f79ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142596))
- [Simplify active_since?](gitlab-org/gitlab@2e0a902929195d6a34161d9f4cf30fb21dc6897a) ([merge request](gitlab-org/gitlab!142565)) **GitLab Enterprise Edition**
- [Admin area overview: Update stats component](gitlab-org/gitlab@98cd1f1d06853a26425f405f6835caa35170120a) ([merge request](gitlab-org/gitlab!142026))
- [Update character_set to v1.8.0](gitlab-org/gitlab@e3c95c7d19779fdf63fef16d5586b861edabca81) ([merge request](gitlab-org/gitlab!142606))
- [Copy adjustment for /billings page Duo Pro hand-raise PQL](gitlab-org/gitlab@e77f034f4b01e06c022646d27eb72e48dd9c7a4b) ([merge request](gitlab-org/gitlab!142417)) **GitLab Enterprise Edition**
- [Logs large IN lists](gitlab-org/gitlab@0318918f6e6cf8b20b28d98efdacbac4df32f796) ([merge request](gitlab-org/gitlab!141150))
- [Improvements in vertical spacing sign-in page](gitlab-org/gitlab@279b5ecdabf3fab0dc703a60008a02e51dcf2b51) ([merge request](gitlab-org/gitlab!142139))
- [Expose setting category on Internal Events for migration purposes (FE)](gitlab-org/gitlab@c8eac714d1a7f7d30f22b8410937dcab4060dfdb) ([merge request](gitlab-org/gitlab!142134))
- [This MR adds branch exceptions selector](gitlab-org/gitlab@17b756ad963b82007fc373a35bd31ca20b922681) ([merge request](gitlab-org/gitlab!141725)) **GitLab Enterprise Edition**
- [Improve avatar on vulnerability details page](gitlab-org/gitlab@56ebc823e85f1a65f9b44087808b8a3ef3f04be4) ([merge request](gitlab-org/gitlab!142319)) **GitLab Enterprise Edition**
- [Allow to revert/cherry-pick squashed MRs with FF strategy](gitlab-org/gitlab@2aefaebb9fa10720c64d875113a25c38a0a61b21) ([merge request](gitlab-org/gitlab!142152))
- [Move OWASP 2021 group behind a feature flag](gitlab-org/gitlab@c160b413dbb347f00b1d21b120de752e03f75682) ([merge request](gitlab-org/gitlab!142405)) **GitLab Enterprise Edition**
- [Format analytics dashboards data tables with delimiters](gitlab-org/gitlab@558ec2bb2a60a45f580d04efce4424c25ed97ded) ([merge request](gitlab-org/gitlab!141724)) **GitLab Enterprise Edition**
- [Group overview: Make items keyboard accessibile](gitlab-org/gitlab@1a95102dca6f8f89b8eda140192aa42ce3c00f98) ([merge request](gitlab-org/gitlab!141686))
- [Allow for DNS Zone change in RD Config](gitlab-org/gitlab@a179a8302d4dff4420694bfd4f725125c33a1867) ([merge request](gitlab-org/gitlab!137277)) **GitLab Enterprise Edition**
- [Remove the feature flag prefix_scim_tokens](gitlab-org/gitlab@6b839cbb50f4f316ff7cff0ae6c39c28598dc7f6) ([merge request](gitlab-org/gitlab!142260))
- [Add `includeArchived: true | false` to `groupProjects` graphQL](gitlab-org/gitlab@0aefcb67f23f6200b36216df3bdd0cbd01d6119c) ([merge request](gitlab-org/gitlab!142396))
- [Adds Application Setting](gitlab-org/gitlab@e57dbd6d1e11f4d119a6a6a34c842b0f0b12109f) ([merge request](gitlab-org/gitlab!141998))
- [Add Max Code indexing concurrency setting](gitlab-org/gitlab@320548db5209f6de1aea6683ccb59e6b35d6a29d) ([merge request](gitlab-org/gitlab!139968)) **GitLab Enterprise Edition**
- [Include subgroups in adherence export](gitlab-org/gitlab@663cf26a176803f0f62204e7ad720397f2d505b8) ([merge request](gitlab-org/gitlab!142355)) **GitLab Enterprise Edition**
- [Use content editor's serializer for copy_as_gfm](gitlab-org/gitlab@7a5806a60cef35b7b8a4b7a9d147b05e39c2c585) ([merge request](gitlab-org/gitlab!137152))
- [Allow embedding relative BMP images in markdown](gitlab-org/gitlab@941056e01aacfef380154e05f1d20fa6f14c652b) by @ignapk ([merge request](gitlab-org/gitlab!141711))
- [Spec approval service for instance SAML approval](gitlab-org/gitlab@e8772691fa4ec12267575ce3a28cbd48b2456dd9) ([merge request](gitlab-org/gitlab!142349)) **GitLab Enterprise Edition**
- [Add alert for user signed up with join a project option](gitlab-org/gitlab@6f5082a1e37428bf19db56470332ef25e834b6c7) ([merge request](gitlab-org/gitlab!142063)) **GitLab Enterprise Edition**
- [Enable sbom_occurrences_vulnerabilities FF](gitlab-org/gitlab@e6d73d0cffe3ae32763f7ef5f4026109323cd879) ([merge request](gitlab-org/gitlab!142330)) **GitLab Enterprise Edition**
- [Add a conditional for project or group avatar](gitlab-org/gitlab@cbd7a5caffc73e5e4eca9a6dce1fedb7f4875c79) ([merge request](gitlab-org/gitlab!142059))
- [Migrate milestone actions button to pajamas component](gitlab-org/gitlab@26a12b928452ceef08eb4dfb251821c4fb4c0ae8) ([merge request](gitlab-org/gitlab!142215))
- [Setup cssbundling-rails](gitlab-org/gitlab@fe9450ddb3df5b08dbdc3952042730475f9cf5b7) by @ar-mali ([merge request](gitlab-org/gitlab!140611))
- [Remove node backoffs for deletion and indexing requests](gitlab-org/gitlab@30f7367c64434fcf003e8231b3236865bde076ea) ([merge request](gitlab-org/gitlab!140806)) **GitLab Enterprise Edition**
- [Add a separate target for basic merge request search](gitlab-org/gitlab@c04ae49dc7efc76f03cf10f077cc61992432503b) ([merge request](gitlab-org/gitlab!142165))
- [Update dependency auto-deploy-image to v2.78.0](gitlab-org/gitlab@4b7fc7bd150e9194389a564f20b5089c81d56dd6) ([merge request](gitlab-org/gitlab!142096))
- [Support CS in PossiblyAffectedOccurrencesFinder](gitlab-org/gitlab@5d5fc26dc6ada6afab67d6452a0bc32fa08b88a9) ([merge request](gitlab-org/gitlab!136613)) **GitLab Enterprise Edition**
- [Migrate preview button in group templates](gitlab-org/gitlab@e5b932458bedd129a229330c1d20b477f47262cd) ([merge request](gitlab-org/gitlab!142233))
- [Migrate button in app/views/users/unsubscribes/show.html.haml](gitlab-org/gitlab@eab9965dad05c4bb4bbdecc2c1284d3989f848fb) ([merge request](gitlab-org/gitlab!142226))
- [Removes database migrations up to 15-9-stable-ee](gitlab-org/gitlab@febb89058f437a33ef43b99c37bf7475bd727176) ([merge request](gitlab-org/gitlab!139940))
- [Enable license_compliance_widget_category by default](gitlab-org/gitlab@2b73a3888dc97dc6aea41c2334e4ea24f7904c4b) ([merge request](gitlab-org/gitlab!142221)) **GitLab Enterprise Edition**
- [Noted lack of Duo Chat support in Web IDE on SM](gitlab-org/gitlab@2ff209f93a432be6f5db05208f2786bd3fd15cea) ([merge request](gitlab-org/gitlab!142144))
- [Remove unused file](gitlab-org/gitlab@ba562203256ccc88e86a20492682841a5fcbf2cd) ([merge request](gitlab-org/gitlab!142187))
- [Migrate buttons in awards_block.html.haml](gitlab-org/gitlab@05e418a213d95a62b9f23180e2b98955939d6d41) ([merge request](gitlab-org/gitlab!141930))
- [Update pipeline editor empty state](gitlab-org/gitlab@583b5397af752a4e091549022a7ab155323bea28) ([merge request](gitlab-org/gitlab!141862))
- [Remove true-up validation for cloud licenses](gitlab-org/gitlab@21b71a925518b1321a193cd4ee789c69cae6fb0b) ([merge request](gitlab-org/gitlab!142181)) **GitLab Enterprise Edition**
- [Updated copy for due pro hand-raise PQL on billings page](gitlab-org/gitlab@8d57a39890cc9adab8d6f3f3081bbeebdf6af59a) ([merge request](gitlab-org/gitlab!142013)) **GitLab Enterprise Edition**
- [Show Needs triage instead of DETECTED in finding modals](gitlab-org/gitlab@d0ab583cab1d459f8193e3361955b4ff4982f2f2) ([merge request](gitlab-org/gitlab!142148)) **GitLab Enterprise Edition**
- [Footer links disappear on small viewports](gitlab-org/gitlab@c405c7ce8bb3329b16ed9eff056817cb4eaf0e67) ([merge request](gitlab-org/gitlab!142145))
- [Clean CI usage w/ optional "deep clean" when banning users on GitLab.com](gitlab-org/gitlab@8026a2c3e029d5ef09fe61c2fc50395e92c3bbba) ([merge request](gitlab-org/gitlab!139218)) **GitLab Enterprise Edition**
- [Service accounts can be added to LDAP-synced groups](gitlab-org/gitlab@a2ec5c408808b82c5e75645f59b2fd3b94796bd1) ([merge request](gitlab-org/gitlab!139606)) **GitLab Enterprise Edition**
- [Migrate button in clone_panel to Pajamas component](gitlab-org/gitlab@dc9a45bb9aa8685243efbcbabdb170d665e9373a) ([merge request](gitlab-org/gitlab!142053))
- [Make review emails more readable](gitlab-org/gitlab@9dd833341856783442a5616416c11c43a827efd4) ([merge request](gitlab-org/gitlab!142047))
- [Add index for events to efficiently query user contributions [SYNC]](gitlab-org/gitlab@21a57ae1ba172f69abaeaae75848bd8d33e6a341) by @zzaakiirr ([merge request](gitlab-org/gitlab!141695))
- [Merge request approval widget: Use small button](gitlab-org/gitlab@3a0e33f34e1cd809826f8b0d0f23f1c3d67bfed9) ([merge request](gitlab-org/gitlab!142034))
- [Add approval group rule post endpoint](gitlab-org/gitlab@3a66940fe7a1d8da8dc7f3803a9d938d0885b127) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137894)) **GitLab Enterprise Edition**
- [Show email on the user popover](gitlab-org/gitlab@bcf7ad044b7a82ca3b7f2766f169d64fa7a575a5) ([merge request](gitlab-org/gitlab!141780))
- [Admin area dashboard cleanup](gitlab-org/gitlab@984b596ccbcfab282b2d33e000090fc937dca605) ([merge request](gitlab-org/gitlab!141857))
- [Update pipeline illustrations](gitlab-org/gitlab@beb452d73a7ed6b69228a665a6b28b87e99990f1) ([merge request](gitlab-org/gitlab!139644))
- [Introduce separate targets for global search indexing](gitlab-org/gitlab@5ed63a92c27c9fd42b7ebb9862b6858f1d2da545) ([merge request](gitlab-org/gitlab!141960)) **GitLab Enterprise Edition**
- [Change importing alert to warning](gitlab-org/gitlab@887b3bd82b99b0d5a0b2568ed9bbf228aafc0fc0) ([merge request](gitlab-org/gitlab!141803))
- [Trims input fields in maven dependency proxy settings](gitlab-org/gitlab@7b815e82ff0fe9b81c5d8fc6f5458d4a13125296) ([merge request](gitlab-org/gitlab!141952))
- [Improve Cookie Preferences button on mobile](gitlab-org/gitlab@1cd9aed1b46595f906f4c945e886a2c02912eec9) ([merge request](gitlab-org/gitlab!141893))
- [Assignees button migration](gitlab-org/gitlab@6fa6734b2e4302751245a21ee4872d409c1852fa) ([merge request](gitlab-org/gitlab!141884))
- [Update dependency auto-deploy-image to v2.77.0](gitlab-org/gitlab@39e5659db987adcabcbba7bd08a61a48c960195f) ([merge request](gitlab-org/gitlab!141876))
- [Migrate {hll_counters}_i_code_review_create_mr from hll to int](gitlab-org/gitlab@4023471c70d3c8635eb16ee50ba9b2802327bc16) ([merge request](gitlab-org/gitlab!141809))
- [Add warning when project creation is noone](gitlab-org/gitlab@0e84c60395fd3125d4e6c1df017c90cf91bf94dd) ([merge request](gitlab-org/gitlab!140941))
- [Limit project description in sidebar](gitlab-org/gitlab@cf66e93ba2a73d370f676f0ccb1ee67bb3370e4c) ([merge request](gitlab-org/gitlab!141229))
- [Update project-level analytics settings strings](gitlab-org/gitlab@922e41c45a47a940e89d9fa4d2db54ea6881f60a) ([merge request](gitlab-org/gitlab!141860)) **GitLab Enterprise Edition**
- [Display the related MR's for the pipeline header](gitlab-org/gitlab@4edd170f3e34967a50676dc1c2b6370037ca506c) ([merge request](gitlab-org/gitlab!140501))
- [GitHub importer: Rename "link" as "attachment"](gitlab-org/gitlab@d1cbf58a2ea2842f660bb13dd6a76e0549855ef8) ([merge request](gitlab-org/gitlab!141823))
- [Removing FF persist_failed_pipelines_from_schedules](gitlab-org/gitlab@3760f2305993ba77d6025f7bde68aa4d61f4e7d1) ([merge request](gitlab-org/gitlab!141794))
- [Update FF with actor](gitlab-org/gitlab@b6cadabf8867ec6715919402d5eec847a9bfff2f) ([merge request](gitlab-org/gitlab!141772))
- [Remove feature flag package_metadata_advisory_sync](gitlab-org/gitlab@04340b57b8238686c62f153b7b532220170b2cc9) ([merge request](gitlab-org/gitlab!139889)) **GitLab Enterprise Edition**
- [Update tab name](gitlab-org/gitlab@df336ca1fa572b11b11a95e53cc55933b28afcb7) ([merge request](gitlab-org/gitlab!141654))
- [Fix accessibility issues in spam logs](gitlab-org/gitlab@bf115db011b09654e4333db42867f2903e4a7a9c) ([merge request](gitlab-org/gitlab!141517))
- [Allow multiple requirements for custom abilities](gitlab-org/gitlab@f20987f8646f0a10d5f5babb9e611d4e3d32b1af) ([merge request](gitlab-org/gitlab!141489)) **GitLab Enterprise Edition**
- [Update feature tests](gitlab-org/gitlab@2973d4374965375bb752efce2a23c26ab2c84682) ([merge request](gitlab-org/gitlab!141580))
- [Make security policy stages order take precedence](gitlab-org/gitlab@9a0ccca2011d7b987110477e729c32fec5c77b6e) ([merge request](gitlab-org/gitlab!141501)) **GitLab Enterprise Edition**
- [Remove bitbucket_importer_exponential_backoff feature flag](gitlab-org/gitlab@3eac3717e42b2bbbc731e093f83a236a0034fd93) ([merge request](gitlab-org/gitlab!140041))

### Deprecated (1 change)

- [Add deprecation for Ubuntu 18.04](gitlab-org/gitlab@a236d2772cc54085c2a244398c569c4bc9fc800f) ([merge request](gitlab-org/gitlab!141344))

### Removed (31 changes)

- [Remove repository renamed event code](gitlab-org/gitlab@9ba77596e1c9519347a1ec72e3b5ce370d3dca92) ([merge request](gitlab-org/gitlab!143446)) **GitLab Enterprise Edition**
- [Removes can_approve_deployment? method](gitlab-org/gitlab@bb8cd146893e0fde72fddb73f9cbac17d3c40efe) by @tedtran2019 ([merge request](gitlab-org/gitlab!140591)) **GitLab Enterprise Edition**
- [Delete two Sidekiq reliable_fetcher flags](gitlab-org/gitlab@a7f096ff08a992779de27e6bb15bca0e5f88f0d7) ([merge request](gitlab-org/gitlab!143970))
- [Remove ProjectRepositoryState model](gitlab-org/gitlab@1c368d3e331c428889a75ae902f409b2f9831630) ([merge request](gitlab-org/gitlab!143695)) **GitLab Enterprise Edition**
- [Delete the 'ci_accept_trace' feature flag](gitlab-org/gitlab@01bf571368cd9bdc41b338977f5ca7c5d1335082) ([merge request](gitlab-org/gitlab!144085))
- [Remove members_api_expose_enterprise_users_emails_only feature flag](gitlab-org/gitlab@29fab1a066568fd4f2c40e800ec4d6477ff5a992) ([merge request](gitlab-org/gitlab!144026)) **GitLab Enterprise Edition**
- [Clean up code suggestions non-owner alert](gitlab-org/gitlab@5b788b3251e6a7fb28804223116324a32dde865c) ([merge request](gitlab-org/gitlab!143862)) **GitLab Enterprise Edition**
- [Remove legacy hashed storage migration code](gitlab-org/gitlab@06db6416ec19eaa63a4cea2ec48838873f466fe2) ([merge request](gitlab-org/gitlab!143443)) **GitLab Enterprise Edition**
- [Remove readme_html field from Ci::Catalog::Resource](gitlab-org/gitlab@79fc87ede1465808a2075f0a879e95f69dfa5f1e) ([merge request](gitlab-org/gitlab!143525))
- [Remove bitbucket_server_convert_mentions_to_users](gitlab-org/gitlab@edc46e11a9eb63eddf1b16b4dcbebe9467a7032e) ([merge request](gitlab-org/gitlab!141859))
- [Remove pagination count](gitlab-org/gitlab@e35dc90ddc56c800d6c662e66d0f132982b3cdfa) ([merge request](gitlab-org/gitlab!141640))
- [Remove references to zoekt_indexed_namespaces and drop table](gitlab-org/gitlab@47efd6bfb2fcb2815b4e66c8c1414a319a601f8e) ([merge request](gitlab-org/gitlab!140906))
- [Remove project_overwrite_service_tracking FF](gitlab-org/gitlab@8d32ff1451543c274a7e0852f766ddd349444330) ([merge request](gitlab-org/gitlab!142841))
- [Remove usage of AutoFixWorker](gitlab-org/gitlab@214af62cc432b1ecb9118d39c540720aca0baed5) ([merge request](gitlab-org/gitlab!142046))
- [Remove unused controller code and old view](gitlab-org/gitlab@ad3ffe97c790fdc667e60a658218106358fe2d66) ([merge request](gitlab-org/gitlab!142810))
- [Drop `vulnerabilities` Column From SbomOccurences](gitlab-org/gitlab@49d1113efb9b57025b78ba7a26589f4cce5edaba) ([merge request](gitlab-org/gitlab!142646))
- [Revert "Merge branch '416662-free-storage-limit-alert' into 'master'"](gitlab-org/gitlab@87c1bc3daeace9a922d02fb433d61263346bafd1) ([merge request](gitlab-org/gitlab!142645))
- [refactor: Drop col column 'package_name_pattern_ilike_query' Part 1](gitlab-org/gitlab@09c7e870d6cae0f5ea9fcc2b3e2b97bf7bee39f3) by @gerardo-navarro ([merge request](gitlab-org/gitlab!142299))
- [Remove the GCP technical demo views](gitlab-org/gitlab@040c176be354a0cdb57e84e0b7f84070bb166315) ([merge request](gitlab-org/gitlab!142553))
- [refactor: Remove ignore rule for renamed attr 'container_path_pattern'](gitlab-org/gitlab@8daa5598f62ac9124e56c0d816c80dba3d22e337) by @gerardo-navarro ([merge request](gitlab-org/gitlab!142309))
- [Delete WorkItemUpdateTask mutation](gitlab-org/gitlab@180aa2380cb0968ad577be8460524dd6e1b8fd82) ([merge request](gitlab-org/gitlab!142241))
- [Drop ignored columns from geo_node_statuses table