/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.multiunpacker;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.core.io.VolumeLocator;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.multiunpacker.NextMediaDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class MultiVolumeUnpackerHelper
implements VolumeLocator {
    private InstallData installData;
    private final InstallerFrame frame;
    private static final Logger logger = Logger.getLogger(MultiVolumeUnpackerHelper.class.getName());

    public MultiVolumeUnpackerHelper(InstallData installData, InstallerFrame frame) {
        this.installData = installData;
        this.frame = frame;
    }

    @Override
    public File getVolume(String path, boolean corrupt) throws IOException {
        if (corrupt) {
            Messages messages = this.installData.getMessages();
            JOptionPane.showMessageDialog(this.frame, messages.get("nextmedia.corruptmedia", new Object[0]), messages.get("nextmedia.corruptmedia.title", new Object[0]), 0);
        }
        logger.fine("Enter next media: " + path);
        File volume = new File(path);
        while (!volume.exists() || corrupt) {
            NextMediaDialog nextMediaDialog = new NextMediaDialog((Frame)this.frame, this.installData, path);
            nextMediaDialog.setVisible(true);
            String nextmediainput = nextMediaDialog.getNextMedia();
            if (nextmediainput != null) {
                volume = new File(nextmediainput);
            } else {
                logger.fine("Input from NextMediaDialog was null");
                volume = new File(path);
            }
            if (path.equals(volume.getAbsolutePath()) && corrupt) continue;
            corrupt = false;
        }
        return volume;
    }
}

