# The PEP 484 type hints stub file for the QtSvg module.
#
# Generated by SIP 6.15.0
#
# Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt6.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing, enum

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtGui

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]


class QtSvg(PyQt6.sip.simplewrapper):

    class Option(enum.Enum):
        NoOption = ... # type: QtSvg.Option
        Tiny12FeaturesOnly = ... # type: QtSvg.Option
        AssumeTrustedSource = ... # type: QtSvg.Option
        DisableSMILAnimations = ... # type: QtSvg.Option
        DisableCSSAnimations = ... # type: QtSvg.Option
        DisableAnimations = ... # type: QtSvg.Option


class QSvgGenerator(QtGui.QPaintDevice):

    class SvgVersion(enum.Enum):
        SvgTiny12 = ... # type: QSvgGenerator.SvgVersion
        Svg11 = ... # type: QSvgGenerator.SvgVersion

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, version: 'QSvgGenerator.SvgVersion') -> None: ...

    def svgVersion(self) -> 'QSvgGenerator.SvgVersion': ...
    def metric(self, metric: QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> QtGui.QPaintEngine|None: ...
    @typing.overload
    def setViewBox(self, viewBox: QtCore.QRect) -> None: ...
    @typing.overload
    def setViewBox(self, viewBox: QtCore.QRectF) -> None: ...
    def viewBoxF(self) -> QtCore.QRectF: ...
    def viewBox(self) -> QtCore.QRect: ...
    def setDescription(self, description: str|None) -> None: ...
    def description(self) -> str: ...
    def setTitle(self, title: str|None) -> None: ...
    def title(self) -> str: ...
    def setResolution(self, resolution: int) -> None: ...
    def resolution(self) -> int: ...
    def setOutputDevice(self, outputDevice: QtCore.QIODevice|None) -> None: ...
    def outputDevice(self) -> QtCore.QIODevice|None: ...
    def setFileName(self, fileName: str|None) -> None: ...
    def fileName(self) -> str: ...
    def setSize(self, size: QtCore.QSize) -> None: ...
    def size(self) -> QtCore.QSize: ...


class QSvgRenderer(QtCore.QObject):

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, filename: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, contents: QtCore.QByteArray|bytes|bytearray|memoryview, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, contents: QtCore.QXmlStreamReader|None, parent: QtCore.QObject|None = ...) -> None: ...

    @staticmethod
    def setDefaultOptions(flags: QtSvg.Option) -> None: ...
    def setAnimationEnabled(self, enable: bool) -> None: ...
    def isAnimationEnabled(self) -> bool: ...
    def setOptions(self, flags: QtSvg.Option) -> None: ...
    def options(self) -> QtSvg.Option: ...
    def transformForElement(self, id: str|None) -> QtGui.QTransform: ...
    def setAspectRatioMode(self, mode: QtCore.Qt.AspectRatioMode) -> None: ...
    def aspectRatioMode(self) -> QtCore.Qt.AspectRatioMode: ...
    repaintNeeded: typing.ClassVar[QtCore.pyqtSignal]
    @typing.overload
    def render(self, p: QtGui.QPainter|None) -> None: ...
    @typing.overload
    def render(self, p: QtGui.QPainter|None, bounds: QtCore.QRectF) -> None: ...
    @typing.overload
    def render(self, painter: QtGui.QPainter|None, elementId: str|None, bounds: QtCore.QRectF = ...) -> None: ...
    @typing.overload
    def load(self, filename: str|None) -> bool: ...
    @typing.overload
    def load(self, contents: QtCore.QByteArray|bytes|bytearray|memoryview) -> bool: ...
    @typing.overload
    def load(self, contents: QtCore.QXmlStreamReader|None) -> bool: ...
    def animationDuration(self) -> int: ...
    def setCurrentFrame(self, a0: int) -> None: ...
    def currentFrame(self) -> int: ...
    def setFramesPerSecond(self, num: int) -> None: ...
    def framesPerSecond(self) -> int: ...
    def boundsOnElement(self, id: str|None) -> QtCore.QRectF: ...
    def animated(self) -> bool: ...
    @typing.overload
    def setViewBox(self, viewbox: QtCore.QRect) -> None: ...
    @typing.overload
    def setViewBox(self, viewbox: QtCore.QRectF) -> None: ...
    def viewBoxF(self) -> QtCore.QRectF: ...
    def viewBox(self) -> QtCore.QRect: ...
    def elementExists(self, id: str|None) -> bool: ...
    def defaultSize(self) -> QtCore.QSize: ...
    def isValid(self) -> bool: ...
