(function() {
    var type_impls = Object.fromEntries([["kernel",[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Deref-for-Guard%3C'_,+T,+B%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#243-250\">Source</a><a href=\"#impl-Deref-for-Guard%3C'_,+T,+B%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>, B: <a class=\"trait\" href=\"kernel/sync/lock/trait.Backend.html\" title=\"trait kernel::sync::lock::Backend\">Backend</a>&gt; <a class=\"trait\" href=\"core/ops/deref/trait.Deref.html\" title=\"trait core::ops::deref::Deref\">Deref</a> for <a class=\"struct\" href=\"kernel/sync/lock/struct.Guard.html\" title=\"struct kernel::sync::lock::Guard\">Guard</a>&lt;'_, T, B&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Target\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#244\">Source</a><a href=\"#associatedtype.Target\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/deref/trait.Deref.html#associatedtype.Target\" class=\"associatedtype\">Target</a> = T</h4></section></summary><div class='docblock'>The resulting type after dereferencing.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.deref\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#246-249\">Source</a><a href=\"#method.deref\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/deref/trait.Deref.html#tymethod.deref\" class=\"fn\">deref</a>(&amp;self) -&gt; &amp;Self::<a class=\"associatedtype\" href=\"core/ops/deref/trait.Deref.html#associatedtype.Target\" title=\"type core::ops::deref::Deref::Target\">Target</a></h4></section></summary><div class='docblock'>Dereferences the value.</div></details></div></details>","Deref","kernel::sync::lock::mutex::MutexGuard","kernel::sync::lock::spinlock::SpinLockGuard"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-DerefMut-for-Guard%3C'_,+T,+B%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#252-257\">Source</a><a href=\"#impl-DerefMut-for-Guard%3C'_,+T,+B%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>, B: <a class=\"trait\" href=\"kernel/sync/lock/trait.Backend.html\" title=\"trait kernel::sync::lock::Backend\">Backend</a>&gt; <a class=\"trait\" href=\"core/ops/deref/trait.DerefMut.html\" title=\"trait core::ops::deref::DerefMut\">DerefMut</a> for <a class=\"struct\" href=\"kernel/sync/lock/struct.Guard.html\" title=\"struct kernel::sync::lock::Guard\">Guard</a>&lt;'_, T, B&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.deref_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#253-256\">Source</a><a href=\"#method.deref_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/deref/trait.DerefMut.html#tymethod.deref_mut\" class=\"fn\">deref_mut</a>(&amp;mut self) -&gt; &amp;mut Self::<a class=\"associatedtype\" href=\"core/ops/deref/trait.Deref.html#associatedtype.Target\" title=\"type core::ops::deref::Deref::Target\">Target</a></h4></section></summary><div class='docblock'>Mutably dereferences the value.</div></details></div></details>","DerefMut","kernel::sync::lock::mutex::MutexGuard","kernel::sync::lock::spinlock::SpinLockGuard"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Drop-for-Guard%3C'_,+T,+B%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#259-264\">Source</a><a href=\"#impl-Drop-for-Guard%3C'_,+T,+B%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>, B: <a class=\"trait\" href=\"kernel/sync/lock/trait.Backend.html\" title=\"trait kernel::sync::lock::Backend\">Backend</a>&gt; <a class=\"trait\" href=\"core/ops/drop/trait.Drop.html\" title=\"trait core::ops::drop::Drop\">Drop</a> for <a class=\"struct\" href=\"kernel/sync/lock/struct.Guard.html\" title=\"struct kernel::sync::lock::Guard\">Guard</a>&lt;'_, T, B&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.drop\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#260-263\">Source</a><a href=\"#method.drop\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/drop/trait.Drop.html#tymethod.drop\" class=\"fn\">drop</a>(&amp;mut self)</h4></section></summary><div class='docblock'>Executes the destructor for this type. <a href=\"core/ops/drop/trait.Drop.html#tymethod.drop\">Read more</a></div></details></div></details>","Drop","kernel::sync::lock::mutex::MutexGuard","kernel::sync::lock::spinlock::SpinLockGuard"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Guard%3C'a,+T,+B%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#200-241\">Source</a><a href=\"#impl-Guard%3C'a,+T,+B%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>, B: <a class=\"trait\" href=\"kernel/sync/lock/trait.Backend.html\" title=\"trait kernel::sync::lock::Backend\">Backend</a>&gt; <a class=\"struct\" href=\"kernel/sync/lock/struct.Guard.html\" title=\"struct kernel::sync::lock::Guard\">Guard</a>&lt;'a, T, B&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.lock_ref\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#227-229\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/sync/lock/struct.Guard.html#tymethod.lock_ref\" class=\"fn\">lock_ref</a>(&amp;self) -&gt; &amp;'a <a class=\"struct\" href=\"kernel/sync/lock/struct.Lock.html\" title=\"struct kernel::sync::lock::Lock\">Lock</a>&lt;T, B&gt;</h4></section></summary><div class=\"docblock\"><p>Returns the lock that this guard originates from.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<p>The following example shows how to use <a href=\"kernel/sync/lock/struct.Guard.html#method.lock_ref\" title=\"method kernel::sync::lock::Guard::lock_ref\"><code>Guard::lock_ref()</code></a> to assert the corresponding\nlock is held.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code>\n<span class=\"kw\">fn </span>assert_held&lt;T, B: Backend&gt;(guard: <span class=\"kw-2\">&amp;</span>Guard&lt;<span class=\"lifetime\">'_</span>, T, B&gt;, lock: <span class=\"kw-2\">&amp;</span>Lock&lt;T, B&gt;) {\n    <span class=\"comment\">// Address-equal means the same lock.\n    </span><span class=\"macro\">assert!</span>(core::ptr::eq(guard.lock_ref(), lock));\n}\n\n<span class=\"comment\">// Creates a new lock on the stack.\n</span><span class=\"macro\">stack_pin_init!</span>{\n    <span class=\"kw\">let </span>l = <span class=\"macro\">new_spinlock!</span>(<span class=\"number\">42</span>)\n}\n\n<span class=\"kw\">let </span>g = l.lock();\n\n<span class=\"comment\">// `g` originates from `l`.\n</span>assert_held(<span class=\"kw-2\">&amp;</span>g, <span class=\"kw-2\">&amp;</span>l);</code></pre></div>\n</div></details></div></details>",0,"kernel::sync::lock::mutex::MutexGuard","kernel::sync::lock::spinlock::SpinLockGuard"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Guard%3C'a,+T,+B%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#266-282\">Source</a><a href=\"#impl-Guard%3C'a,+T,+B%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>, B: <a class=\"trait\" href=\"kernel/sync/lock/trait.Backend.html\" title=\"trait kernel::sync::lock::Backend\">Backend</a>&gt; <a class=\"struct\" href=\"kernel/sync/lock/struct.Guard.html\" title=\"struct kernel::sync::lock::Guard\">Guard</a>&lt;'a, T, B&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.new\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#272-281\">Source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"kernel/sync/lock/struct.Guard.html#tymethod.new\" class=\"fn\">new</a>(lock: &amp;'a <a class=\"struct\" href=\"kernel/sync/lock/struct.Lock.html\" title=\"struct kernel::sync::lock::Lock\">Lock</a>&lt;T, B&gt;, state: B::<a class=\"associatedtype\" href=\"kernel/sync/lock/trait.Backend.html#associatedtype.GuardState\" title=\"type kernel::sync::lock::Backend::GuardState\">GuardState</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Constructs a new immutable lock guard.</p>\n<h5 id=\"safety\"><a class=\"doc-anchor\" href=\"#safety\">§</a>Safety</h5>\n<p>The caller must ensure that it owns the lock.</p>\n</div></details></div></details>",0,"kernel::sync::lock::mutex::MutexGuard","kernel::sync::lock::spinlock::SpinLockGuard"],["<section id=\"impl-Sync-for-Guard%3C'_,+T,+B%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/sync/lock.rs.html#198\">Source</a><a href=\"#impl-Sync-for-Guard%3C'_,+T,+B%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.Sync.html\" title=\"trait core::marker::Sync\">Sync</a> + ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>, B: <a class=\"trait\" href=\"kernel/sync/lock/trait.Backend.html\" title=\"trait kernel::sync::lock::Backend\">Backend</a>&gt; <a class=\"trait\" href=\"core/marker/trait.Sync.html\" title=\"trait core::marker::Sync\">Sync</a> for <a class=\"struct\" href=\"kernel/sync/lock/struct.Guard.html\" title=\"struct kernel::sync::lock::Guard\">Guard</a>&lt;'_, T, B&gt;</h3></section>","Sync","kernel::sync::lock::mutex::MutexGuard","kernel::sync::lock::spinlock::SpinLockGuard"]]]]);
    if (window.register_type_impls) {
        window.register_type_impls(type_impls);
    } else {
        window.pending_type_impls = type_impls;
    }
})()
//{"start":55,"fragment_lengths":[10469]}