/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.stats.metrics;

import java.util.Collections;
import java.util.List;
import org.opensearch.performanceanalyzer.commons.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatsType;

public enum CollectorMetrics implements MeasurementSet
{
    EVENT_LOG_FILES_DELETION_TIME("EventLogFilesDeletionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    EVENT_LOG_FILES_DELETED("EventLogFilesDeleted"),
    JVM_THREAD_DUMP_SUCCESSFUL("JvmThreadDumpSuccessful"),
    COLLECTORS_MUTED("CollectorsMutedCount", "namedCount", StatsType.STATS_DATA, Collections.singletonList(Statistics.NAMED_COUNTERS)),
    COLLECTORS_SKIPPED("CollectorSkippedCount", "namedCount", StatsType.STATS_DATA, Collections.singletonList(Statistics.NAMED_COUNTERS)),
    COLLECTORS_SLOW("CollectorSlowCount", "namedCount", StatsType.STATS_DATA, Collections.singletonList(Statistics.NAMED_COUNTERS)),
    OS_METRICS_COLLECTOR_EXECUTION_TIME("OSMetricsCollectorExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    HEAP_METRICS_COLLECTOR_EXECUTION_TIME("HeapMetricsCollectorExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    MOUNTED_PARTITION_METRICS_COLLECTOR_EXECUTION_TIME("MountedPartitionMetricsCollectorExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    DISKS_COLLECTOR_EXECUTION_TIME("DisksCollectorExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    NETWORK_E2E_COLLECTOR_EXECUTION_TIME("NetworkE2ECollectorExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    NETWORK_INTERFACE_COLLECTOR_EXECUTION_TIME("NetworkInterfaceCollectorExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    GC_INFO_COLLECTOR_EXECUTION_TIME("GCInfoCollectorExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    STAT_COLLECTOR_EXECUTION_TIME("StatCollectorExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM);

    private String name;
    private String unit;
    private StatsType statsType;
    private List<Statistics> statsList;

    private CollectorMetrics(String name) {
        this(name, "count", StatsType.STATS_DATA, Collections.singletonList(Statistics.COUNT));
    }

    private CollectorMetrics(String name, String unit, StatsType statsType, Statistics stats) {
        this(name, unit, statsType, Collections.singletonList(stats));
    }

    private CollectorMetrics(String name, String unit, StatsType statsType, List<Statistics> stats) {
        this.name = name;
        this.unit = unit;
        this.statsType = statsType;
        this.statsList = stats;
    }

    public String toString() {
        return this.name + "-" + this.unit;
    }

    @Override
    public StatsType getStatsType() {
        return this.statsType;
    }

    @Override
    public List<Statistics> getStatsList() {
        return this.statsList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }
}

