/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.jvm;

import com.sun.tools.attach.VirtualMachine;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.commons.OSMetricsGeneratorFactory;
import org.opensearch.performanceanalyzer.commons.collectors.ScheduledMetricCollectorsExecutor;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.stats.ServiceMetrics;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;
import org.opensearch.performanceanalyzer.commons.util.Util;
import sun.tools.attach.HotSpotVirtualMachine;

public class ThreadList {
    private static final Map<Long, String> jTidNameMap = new ConcurrentHashMap<Long, String>();
    private static final Map<Long, ThreadState> nativeTidMap = new ConcurrentHashMap<Long, ThreadState>();
    private static final Map<Long, ThreadState> oldNativeTidMap = new ConcurrentHashMap<Long, ThreadState>();
    private static final Map<Long, ThreadState> jTidMap = new ConcurrentHashMap<Long, ThreadState>();
    private static final Map<String, ThreadState> nameMap = new ConcurrentHashMap<String, ThreadState>();
    private static final String pid = OSMetricsGeneratorFactory.getInstance().getPid();
    private static final long MILLIS_PER_SECOND = 1000L;
    static final Logger LOGGER = LogManager.getLogger(ThreadList.class);
    static final int samplingInterval = MetricsConfiguration.CONFIG_MAP.get(ThreadList.class).samplingInterval;
    private static final long minRunInterval = samplingInterval;
    private static final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private static final Pattern linePattern = Pattern.compile("\"([^\"]*)\"");
    private static long lastRunTime = 0L;
    private static Lock vmAttachLock = new ReentrantLock();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<Long, ThreadState> getNativeTidMap(boolean threadContentionMonitoringEnabled) {
        if (threadBean.isThreadContentionMonitoringSupported()) {
            threadBean.setThreadContentionMonitoringEnabled(threadContentionMonitoringEnabled);
        }
        if (vmAttachLock.tryLock()) {
            try {
                if (System.currentTimeMillis() <= lastRunTime + minRunInterval) return new HashMap<Long, ThreadState>(nativeTidMap);
                ThreadList.runThreadDump(pid, new String[0]);
                return new HashMap<Long, ThreadState>(nativeTidMap);
            }
            finally {
                vmAttachLock.unlock();
            }
        } else {
            StatsCollector.instance().logException(StatExceptionCode.JVM_ATTACH_LOCK_ACQUISITION_FAILED);
        }
        return new HashMap<Long, ThreadState>(nativeTidMap);
    }

    public static ThreadState getThreadState(long threadId) {
        ThreadState retVal = jTidMap.get(threadId);
        if (retVal == null) {
            StatsCollector.instance().logException(StatExceptionCode.NO_THREAD_STATE_INFO);
        }
        return retVal;
    }

    private static void runAttachDump(String pid, String[] args) {
        VirtualMachine vm = null;
        try {
            vm = VirtualMachine.attach(pid);
        }
        catch (Exception ex) {
            if (ex.getMessage().contains("java_pid")) {
                StatsCollector.instance().logException(StatExceptionCode.JVM_ATTACH_ERROR_JAVA_PID_FILE_MISSING);
            } else {
                StatsCollector.instance().logException(StatExceptionCode.JVM_ATTACH_ERROR);
            }
            oldNativeTidMap.clear();
            return;
        }
        try (InputStream in = ((HotSpotVirtualMachine)vm).remoteDataDump(args);){
            ThreadList.createMap(in);
        }
        catch (Exception ex) {
            StatsCollector.instance().logException(StatExceptionCode.JVM_ATTACH_ERROR);
            oldNativeTidMap.clear();
        }
        try {
            vm.detach();
            ServiceMetrics.COMMONS_STAT_METRICS_AGGREGATOR.updateStat(StatMetrics.JVM_THREAD_DUMP_SUCCESSFUL, 1);
        }
        catch (Exception ex) {
            StatsCollector.instance().logException(StatExceptionCode.JVM_ATTACH_ERROR);
        }
    }

    public static void parseAllThreadInfos(ThreadInfo[] infos) {
        for (ThreadInfo info : infos) {
            try {
                ThreadList.parseThreadInfo(info);
            }
            catch (Exception ex) {
                StatsCollector.instance().logException(StatExceptionCode.JVM_THREAD_ID_NO_LONGER_EXISTS);
            }
        }
    }

    public static ThreadInfo[] getAllThreadInfos() {
        long[] ids = threadBean.getAllThreadIds();
        return threadBean.getThreadInfo(ids);
    }

    private static void runMXDump() {
        ThreadInfo[] infos = ThreadList.getAllThreadInfos();
        ThreadList.parseAllThreadInfos(infos);
        ThreadHistory.cleanup();
    }

    private static void parseThreadInfo(ThreadInfo info) {
        long id = info.getThreadId();
        String name = info.getThreadName();
        Thread.State state = info.getThreadState();
        long mem = ((com.sun.management.ThreadMXBean)threadBean).getThreadAllocatedBytes(id);
        ThreadState t = jTidMap.get(id);
        if (t == null) {
            return;
        }
        t.heapUsage = mem;
        t.state = state;
        t.blockedCount = info.getBlockedCount();
        t.blockedTime = info.getBlockedTime();
        t.waitedCount = info.getWaitedCount();
        t.waitedTime = info.getWaitedTime();
        ThreadHistory.addBlocked(t.nativeTid, state == Thread.State.BLOCKED ? (long)samplingInterval : 0L);
        ThreadHistory.addWaited(t.nativeTid, state == Thread.State.WAITING || state == Thread.State.TIMED_WAITING ? (long)samplingInterval : 0L);
        long curRunTime = System.currentTimeMillis();
        ThreadState oldt = oldNativeTidMap.get(t.nativeTid);
        if (curRunTime > lastRunTime && oldt != null) {
            CircularLongArray arr;
            t.heapAllocRate = (double)Math.max(t.heapUsage - oldt.heapUsage, 0L) * 1000.0 / (double)(curRunTime - lastRunTime);
            if (t.blockedTime != -1L && t.blockedCount > oldt.blockedCount) {
                t.avgBlockedTime = 0.001 * (double)(t.blockedTime - oldt.blockedTime) / (double)(t.blockedCount - oldt.blockedCount);
            } else if (t.blockedCount == oldt.blockedCount && t.blockedTime > oldt.blockedTime) {
                t.avgBlockedTime = 0.001 * ((double)(t.blockedTime - oldt.blockedTime) + oldt.avgBlockedTime);
            } else {
                arr = ThreadHistory.blockedTidHistoryMap.get(t.nativeTid);
                if (arr != null) {
                    t.avgBlockedTime = 1.0 * arr.getAvgValue() / 1000.0;
                }
            }
            if (t.waitedTime != -1L && t.waitedCount > oldt.waitedCount) {
                t.avgWaitedTime = 0.001 * (double)(t.waitedTime - oldt.waitedTime) / (double)(t.waitedCount - oldt.waitedCount);
            } else if (t.waitedCount == oldt.waitedCount && t.waitedTime > oldt.waitedTime) {
                t.avgWaitedTime = 0.001 * ((double)(t.waitedTime - oldt.waitedTime) + oldt.avgWaitedTime);
            } else {
                arr = ThreadHistory.waitedTidHistoryMap.get(t.nativeTid);
                if (arr != null) {
                    t.avgWaitedTime = 1.0 * arr.getAvgValue() / 1000.0;
                }
            }
        }
        jTidNameMap.put(id, name);
    }

    static void runThreadDump(String pid, String[] args) {
        String currentThreadName = Thread.currentThread().getName();
        assert (currentThreadName.startsWith("pa-collectors-th") || currentThreadName.equals(ScheduledMetricCollectorsExecutor.class.getSimpleName())) : String.format("Thread dump called from a non os collector thread: %s", currentThreadName);
        jTidNameMap.clear();
        oldNativeTidMap.putAll(nativeTidMap);
        nativeTidMap.clear();
        jTidMap.clear();
        nameMap.clear();
        Util.invokePrivileged(() -> ThreadList.runAttachDump(pid, args));
        if (!oldNativeTidMap.isEmpty()) {
            ThreadList.runMXDump();
        }
        lastRunTime = System.currentTimeMillis();
    }

    private static void parseLine(String line) {
        String[] tokens = line.split(" os_prio=[0-9]* ");
        ThreadState t = new ThreadState();
        t.javaTid = -1L;
        Matcher m = linePattern.matcher(tokens[0]);
        if (!m.find()) {
            t.threadName = tokens[0];
        } else {
            t.threadName = m.group(1);
            if (!tokens[0].equals("\"" + t.threadName + "\"")) {
                t.javaTid = Long.parseLong(tokens[0].split(Pattern.quote("\"" + t.threadName + "\" "))[1].split(" ")[0].split("#")[1]);
            }
        }
        for (String token : tokens = tokens[1].split(" ")) {
            String[] keyValuePare = token.split("=");
            if (keyValuePare.length < 2) continue;
            if (t.javaTid == -1L && keyValuePare[0].equals("tid")) {
                t.javaTid = Long.decode(keyValuePare[1]);
            }
            if (!keyValuePare[0].equals("nid")) continue;
            t.nativeTid = Long.decode(keyValuePare[1]);
        }
        t.tState = tokens[2];
        nativeTidMap.put(t.nativeTid, t);
        jTidMap.put(t.javaTid, t);
        nameMap.put(t.threadName, t);
    }

    private static void createMap(InputStream in) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String line = null;
        while ((line = br.readLine()) != null) {
            if (!line.contains("tid=")) continue;
            ThreadList.parseLine(line);
        }
    }

    public static class ThreadState {
        public long javaTid = -1L;
        public long nativeTid = -1L;
        public long heapUsage = -1L;
        public String threadName = "";
        public String tState = "";
        public Thread.State state;
        public long blockedCount = 0L;
        public long blockedTime = 0L;
        public long waitedCount = 0L;
        public long waitedTime = 0L;
        public double heapAllocRate = 0.0;
        public double avgBlockedTime = 0.0;
        public double avgWaitedTime = 0.0;

        ThreadState() {
        }

        public String toString() {
            return "javatid:" + this.javaTid + " nativetid:" + this.nativeTid + " name:" + this.threadName + " state:" + this.tState + "(" + (Object)((Object)this.state) + ")" + " heaprate: " + this.heapAllocRate + " bTime: " + this.avgBlockedTime + ":" + this.blockedCount + " wTime: " + this.avgWaitedTime + ":" + this.waitedCount;
        }
    }

    static class ThreadHistory {
        public static Map<Long, CircularLongArray> blockedTidHistoryMap = new HashMap<Long, CircularLongArray>();
        public static Map<Long, CircularLongArray> waitedTidHistoryMap = new HashMap<Long, CircularLongArray>();
        private static final int HISTORY_SIZE = 60;

        ThreadHistory() {
        }

        public static void addBlocked(long tid, long value) {
            ThreadHistory.add(tid, value, blockedTidHistoryMap);
        }

        public static void addWaited(long tid, long value) {
            ThreadHistory.add(tid, value, waitedTidHistoryMap);
        }

        public static void cleanup() {
            long curTime = System.currentTimeMillis();
            ThreadHistory.cleanUp(curTime, blockedTidHistoryMap);
            ThreadHistory.cleanUp(curTime, waitedTidHistoryMap);
        }

        private static void add(long tid, long value, Map<Long, CircularLongArray> tidHistoryMap) {
            CircularLongArray arr = tidHistoryMap.get(tid);
            if (arr == null) {
                arr = new CircularLongArray(60);
                arr.add(value);
                tidHistoryMap.put(tid, arr);
            } else {
                arr.add(value);
            }
        }

        private static void cleanUp(long curTime, Map<Long, CircularLongArray> tidHistoryMap) {
            Iterator<Map.Entry<Long, CircularLongArray>> it = tidHistoryMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, CircularLongArray> me = it.next();
                CircularLongArray arr = me.getValue();
                if (!((double)(curTime - arr.lastWriteTimestamp) > (double)(60 * samplingInterval) * 1000.0)) continue;
                it.remove();
            }
        }
    }

    static class CircularLongArray {
        ArrayList<Long> list = null;
        public long lastWriteTimestamp;
        private long totalValue;
        private int startidx;
        private int capacity;

        CircularLongArray(int capacity) {
            this.list = new ArrayList(capacity);
            this.capacity = capacity;
            this.totalValue = 0L;
            this.startidx = 0;
            this.lastWriteTimestamp = 0L;
        }

        public boolean add(long e) {
            this.lastWriteTimestamp = System.currentTimeMillis();
            if (this.list.size() < this.capacity) {
                if (this.startidx != 0) {
                    return false;
                }
                this.totalValue += e;
                return this.list.add(e);
            }
            this.totalValue -= this.list.get(this.startidx).longValue();
            this.totalValue += e;
            this.list.set(this.startidx, e);
            this.startidx = (this.startidx + 1) % this.capacity;
            return true;
        }

        public double getAvgValue() {
            return this.list.size() == 0 ? 0.0 : 1.0 * (double)this.totalValue / (double)this.list.size();
        }
    }
}

