/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN990Codec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationState;

public final class KNN990QuantizationStateWriter {
    private final IndexOutput output;
    private List<FieldQuantizationState> fieldQuantizationStates = new ArrayList<FieldQuantizationState>();
    static final String NATIVE_ENGINES_990_KNN_VECTORS_FORMAT_QS_DATA = "NativeEngines990KnnVectorsFormatQSData";

    public KNN990QuantizationStateWriter(SegmentWriteState segmentWriteState) throws IOException {
        String quantizationStateFileName = IndexFileNames.segmentFileName((String)segmentWriteState.segmentInfo.name, (String)segmentWriteState.segmentSuffix, (String)"osknnqstate");
        this.output = segmentWriteState.directory.createOutput(quantizationStateFileName, segmentWriteState.context);
    }

    public void writeHeader(SegmentWriteState segmentWriteState) throws IOException {
        CodecUtil.writeIndexHeader((DataOutput)this.output, (String)NATIVE_ENGINES_990_KNN_VECTORS_FORMAT_QS_DATA, (int)0, (byte[])segmentWriteState.segmentInfo.getId(), (String)segmentWriteState.segmentSuffix);
    }

    public void writeState(int fieldNumber, QuantizationState quantizationState) throws IOException {
        byte[] stateBytes = quantizationState.toByteArray();
        long position = this.output.getFilePointer();
        this.output.writeBytes(stateBytes, stateBytes.length);
        this.fieldQuantizationStates.add(new FieldQuantizationState(fieldNumber, stateBytes, position));
    }

    public void writeFooter() throws IOException {
        long indexStartPosition = this.output.getFilePointer();
        this.output.writeInt(this.fieldQuantizationStates.size());
        for (FieldQuantizationState fieldQuantizationState : this.fieldQuantizationStates) {
            this.output.writeInt(fieldQuantizationState.fieldNumber);
            this.output.writeInt(fieldQuantizationState.stateBytes.length);
            this.output.writeVLong(fieldQuantizationState.position.longValue());
        }
        this.output.writeLong(indexStartPosition);
        this.output.writeInt(-1);
        CodecUtil.writeFooter((IndexOutput)this.output);
    }

    public void closeOutput() throws IOException {
        this.output.close();
    }

    private static class FieldQuantizationState {
        final int fieldNumber;
        final byte[] stateBytes;
        Long position;

        @Generated
        public FieldQuantizationState(int fieldNumber, byte[] stateBytes, Long position) {
            this.fieldNumber = fieldNumber;
            this.stateBytes = stateBytes;
            this.position = position;
        }

        @Generated
        public void setPosition(Long position) {
            this.position = position;
        }
    }
}

