/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.protocol.response.format;

import com.google.gson.Gson;
import lombok.Generated;
import org.opensearch.sql.utils.SerializeUtils;

public final class ErrorFormatter {
    private static final Gson PRETTY_PRINT_GSON = SerializeUtils.getGsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Gson GSON = SerializeUtils.getGsonBuilder().disableHtmlEscaping().create();

    public static String compactFormat(Throwable t) {
        JsonError error = new JsonError(t.getClass().getSimpleName(), t.getMessage());
        return ErrorFormatter.compactJsonify(error);
    }

    public static String prettyFormat(Throwable t) {
        JsonError error = new JsonError(t.getClass().getSimpleName(), t.getMessage());
        return ErrorFormatter.prettyJsonify(error);
    }

    public static String compactJsonify(Object jsonObject) {
        return GSON.toJson(jsonObject);
    }

    public static String prettyJsonify(Object jsonObject) {
        return PRETTY_PRINT_GSON.toJson(jsonObject);
    }

    @Generated
    private ErrorFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class JsonError {
        private final String type;
        private final String reason;

        @Generated
        public JsonError(String type, String reason) {
            this.type = type;
            this.reason = reason;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getReason() {
            return this.reason;
        }
    }
}

