/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.services;

import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.breaker.CircuitBreaker;
import org.opensearch.core.common.breaker.CircuitBreakingException;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.protobufs.BulkRequest;
import org.opensearch.protobufs.BulkResponse;
import org.opensearch.protobufs.services.DocumentServiceGrpc;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.grpc.listeners.BulkRequestActionListener;
import org.opensearch.transport.grpc.proto.request.document.bulk.BulkRequestProtoUtils;
import org.opensearch.transport.grpc.util.CircuitBreakerStreamObserver;
import org.opensearch.transport.grpc.util.GrpcErrorHandler;

public class DocumentServiceImpl
extends DocumentServiceGrpc.DocumentServiceImplBase {
    private static final Logger logger = LogManager.getLogger(DocumentServiceImpl.class);
    private final Client client;
    private final CircuitBreakerService circuitBreakerService;

    public DocumentServiceImpl(Client client, CircuitBreakerService circuitBreakerService) {
        if (client == null) {
            throw new IllegalArgumentException("Client cannot be null");
        }
        if (circuitBreakerService == null) {
            throw new IllegalArgumentException("Circuit breaker service cannot be null");
        }
        this.client = client;
        this.circuitBreakerService = circuitBreakerService;
    }

    public void bulk(BulkRequest request, StreamObserver<BulkResponse> responseObserver) {
        int requestSize = request.getSerializedSize();
        CircuitBreaker breaker = this.circuitBreakerService.getBreaker("in_flight_requests");
        try {
            breaker.addEstimateBytesAndMaybeBreak((long)requestSize, "<grpc_request>");
            CircuitBreakerStreamObserver<BulkResponse> wrappedObserver = new CircuitBreakerStreamObserver<BulkResponse>(responseObserver, this.circuitBreakerService, requestSize);
            org.opensearch.action.bulk.BulkRequest bulkRequest = BulkRequestProtoUtils.prepareRequest(request);
            BulkRequestActionListener listener = new BulkRequestActionListener(wrappedObserver);
            this.client.bulk(bulkRequest, (ActionListener)listener);
        }
        catch (CircuitBreakingException e) {
            logger.debug("Circuit breaker tripped for gRPC bulk request: {}", (Object)e.getMessage());
            StatusRuntimeException grpcError = GrpcErrorHandler.convertToGrpcError((Exception)((Object)e));
            responseObserver.onError((Throwable)grpcError);
        }
        catch (RuntimeException e) {
            breaker.addWithoutBreaking((long)(-requestSize));
            logger.debug("DocumentServiceImpl failed: {} - {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            StatusRuntimeException grpcError = GrpcErrorHandler.convertToGrpcError(e);
            responseObserver.onError((Throwable)grpcError);
        }
    }
}

