/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.document.bulk;

import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.index.VersionType;
import org.opensearch.protobufs.BulkRequest;
import org.opensearch.protobufs.BulkRequestBody;
import org.opensearch.protobufs.DeleteOperation;
import org.opensearch.protobufs.IndexOperation;
import org.opensearch.protobufs.OpType;
import org.opensearch.protobufs.OperationContainer;
import org.opensearch.protobufs.UpdateAction;
import org.opensearch.protobufs.UpdateOperation;
import org.opensearch.protobufs.WriteOperation;
import org.opensearch.script.Script;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.transport.grpc.proto.request.common.FetchSourceContextProtoUtils;
import org.opensearch.transport.grpc.proto.request.common.ScriptProtoUtils;
import org.opensearch.transport.grpc.proto.response.document.common.VersionTypeProtoUtils;

public class BulkRequestParserProtoUtils {
    protected BulkRequestParserProtoUtils() {
    }

    private static String valueOrDefault(String value, String globalDefault) {
        if (Strings.isNullOrEmpty((String)value) && !Strings.isNullOrEmpty((String)globalDefault)) {
            return globalDefault;
        }
        return value;
    }

    private static Boolean valueOrDefault(Boolean value, Boolean globalDefault) {
        if (Objects.isNull(value) && !Objects.isNull(globalDefault)) {
            return globalDefault;
        }
        return value;
    }

    private static BytesReference byteStringToBytesReference(ByteString byteString) {
        if (byteString == null || byteString.isEmpty()) {
            return BytesArray.EMPTY;
        }
        return new BytesArray(byteString.toByteArray());
    }

    static MediaType detectMediaType(BytesReference document) {
        if (document == null || document.length() == 0) {
            return MediaTypeRegistry.JSON;
        }
        BytesRef bytesRef = document.toBytesRef();
        MediaType detectedType = MediaTypeRegistry.mediaTypeFromBytes((byte[])bytesRef.bytes, (int)bytesRef.offset, (int)bytesRef.length);
        return detectedType != null ? detectedType : MediaTypeRegistry.JSON;
    }

    public static DocWriteRequest<?>[] getDocWriteRequests(BulkRequest request, String defaultIndex, String defaultRouting, FetchSourceContext defaultFetchSourceContext, String defaultPipeline, Boolean defaultRequireAlias) {
        List bulkRequestBodyList = request.getBulkRequestBodyList();
        DocWriteRequest[] docWriteRequests = new DocWriteRequest[bulkRequestBodyList.size()];
        for (int i = 0; i < bulkRequestBodyList.size(); ++i) {
            BulkRequestBody bulkRequestBodyEntry = (BulkRequestBody)bulkRequestBodyList.get(i);
            String index = defaultIndex;
            String id = null;
            String routing = BulkRequestParserProtoUtils.valueOrDefault(defaultRouting, request.getRouting());
            FetchSourceContext fetchSourceContext = defaultFetchSourceContext;
            OpType opType = null;
            long version = -3L;
            VersionType versionType = VersionType.INTERNAL;
            long ifSeqNo = -2L;
            long ifPrimaryTerm = 0L;
            int retryOnConflict = 0;
            String pipeline = BulkRequestParserProtoUtils.valueOrDefault(defaultPipeline, request.getPipeline());
            Boolean requireAlias = BulkRequestParserProtoUtils.valueOrDefault(defaultRequireAlias, request.getRequireAlias());
            OperationContainer operationContainer = bulkRequestBodyEntry.getOperationContainer();
            docWriteRequests[i] = switch (operationContainer.getOperationContainerCase()) {
                case OperationContainer.OperationContainerCase.CREATE -> BulkRequestParserProtoUtils.buildCreateRequest(operationContainer.getCreate(), bulkRequestBodyEntry.getObject(), index, id, routing, version, versionType, pipeline, ifSeqNo, ifPrimaryTerm, requireAlias);
                case OperationContainer.OperationContainerCase.INDEX -> BulkRequestParserProtoUtils.buildIndexRequest(operationContainer.getIndex(), bulkRequestBodyEntry.getObject(), opType, index, id, routing, version, versionType, pipeline, ifSeqNo, ifPrimaryTerm, requireAlias);
                case OperationContainer.OperationContainerCase.UPDATE -> {
                    ByteString updateDocBytes = ByteString.EMPTY;
                    if (bulkRequestBodyEntry.hasUpdateAction() && bulkRequestBodyEntry.getUpdateAction().hasDoc()) {
                        updateDocBytes = bulkRequestBodyEntry.getUpdateAction().getDoc();
                    } else if (bulkRequestBodyEntry.hasObject()) {
                        updateDocBytes = bulkRequestBodyEntry.getObject();
                    }
                    yield BulkRequestParserProtoUtils.buildUpdateRequest(operationContainer.getUpdate(), updateDocBytes, bulkRequestBodyEntry, index, id, routing, fetchSourceContext, retryOnConflict, pipeline, ifSeqNo, ifPrimaryTerm, requireAlias);
                }
                case OperationContainer.OperationContainerCase.DELETE -> BulkRequestParserProtoUtils.buildDeleteRequest(operationContainer.getDelete(), index, id, routing, version, versionType, ifSeqNo, ifPrimaryTerm);
                default -> throw new IllegalArgumentException("Invalid BulkRequestBody. An OperationContainer (create, index, update, or delete) must be provided.");
            };
        }
        return docWriteRequests;
    }

    public static IndexRequest buildCreateRequest(WriteOperation createOperation, ByteString documentBytes, String index, String id, String routing, long version, VersionType versionType, String pipeline, long ifSeqNo, long ifPrimaryTerm, boolean requireAlias) {
        if (createOperation.hasXIndex()) {
            index = createOperation.getXIndex();
        }
        id = createOperation.hasXId() ? createOperation.getXId() : id;
        routing = createOperation.hasRouting() ? createOperation.getRouting() : routing;
        pipeline = createOperation.hasPipeline() ? createOperation.getPipeline() : pipeline;
        requireAlias = createOperation.hasRequireAlias() ? createOperation.getRequireAlias() : requireAlias;
        BytesReference documentRef = BulkRequestParserProtoUtils.byteStringToBytesReference(documentBytes);
        MediaType mediaType = BulkRequestParserProtoUtils.detectMediaType(documentRef);
        IndexRequest indexRequest = new IndexRequest(index).id(id).routing(routing).version(version).versionType(versionType).create(true).setPipeline(pipeline).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).source(documentRef, mediaType).setRequireAlias(requireAlias);
        return indexRequest;
    }

    public static IndexRequest buildIndexRequest(IndexOperation indexOperation, ByteString documentBytes, OpType opType, String index, String id, String routing, long version, VersionType versionType, String pipeline, long ifSeqNo, long ifPrimaryTerm, boolean requireAlias) {
        OpType opType2 = opType = indexOperation.hasOpType() ? indexOperation.getOpType() : opType;
        if (indexOperation.hasXIndex()) {
            index = indexOperation.getXIndex();
        }
        id = indexOperation.hasXId() ? indexOperation.getXId() : id;
        routing = indexOperation.hasRouting() ? indexOperation.getRouting() : routing;
        long l = version = indexOperation.hasVersion() ? indexOperation.getVersion() : version;
        if (indexOperation.hasVersionType()) {
            versionType = VersionTypeProtoUtils.fromProto(indexOperation.getVersionType());
        }
        pipeline = indexOperation.hasPipeline() ? indexOperation.getPipeline() : pipeline;
        ifSeqNo = indexOperation.hasIfSeqNo() ? indexOperation.getIfSeqNo() : ifSeqNo;
        ifPrimaryTerm = indexOperation.hasIfPrimaryTerm() ? indexOperation.getIfPrimaryTerm() : ifPrimaryTerm;
        requireAlias = indexOperation.hasRequireAlias() ? indexOperation.getRequireAlias() : requireAlias;
        BytesReference documentRef = BulkRequestParserProtoUtils.byteStringToBytesReference(documentBytes);
        MediaType mediaType = BulkRequestParserProtoUtils.detectMediaType(documentRef);
        IndexRequest indexRequest = opType == null ? new IndexRequest(index).id(id).routing(routing).version(version).versionType(versionType).setPipeline(pipeline).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).source(documentRef, mediaType).setRequireAlias(requireAlias) : new IndexRequest(index).id(id).routing(routing).version(version).versionType(versionType).create(opType == OpType.OP_TYPE_CREATE).setPipeline(pipeline).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).source(documentRef, mediaType).setRequireAlias(requireAlias);
        return indexRequest;
    }

    public static UpdateRequest buildUpdateRequest(UpdateOperation updateOperation, ByteString documentBytes, BulkRequestBody bulkRequestBody, String index, String id, String routing, FetchSourceContext fetchSourceContext, int retryOnConflict, String pipeline, long ifSeqNo, long ifPrimaryTerm, boolean requireAlias) {
        IndexRequest upsertRequest;
        if (updateOperation.hasXIndex()) {
            index = updateOperation.getXIndex();
        }
        id = updateOperation.hasXId() ? updateOperation.getXId() : id;
        routing = updateOperation.hasRouting() ? updateOperation.getRouting() : routing;
        retryOnConflict = updateOperation.hasRetryOnConflict() ? updateOperation.getRetryOnConflict() : retryOnConflict;
        ifSeqNo = updateOperation.hasIfSeqNo() ? updateOperation.getIfSeqNo() : ifSeqNo;
        ifPrimaryTerm = updateOperation.hasIfPrimaryTerm() ? updateOperation.getIfPrimaryTerm() : ifPrimaryTerm;
        requireAlias = updateOperation.hasRequireAlias() ? updateOperation.getRequireAlias() : requireAlias;
        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(index)).id(id).routing(routing).retryOnConflict(retryOnConflict).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).setRequireAlias(requireAlias).routing(routing);
        updateRequest = BulkRequestParserProtoUtils.fromProto(updateRequest, documentBytes, bulkRequestBody, ifSeqNo, ifPrimaryTerm);
        if (fetchSourceContext != null) {
            updateRequest.fetchSource(fetchSourceContext);
        }
        if ((upsertRequest = updateRequest.upsertRequest()) != null) {
            upsertRequest.setPipeline(pipeline);
        }
        return updateRequest;
    }

    static UpdateRequest fromProto(UpdateRequest updateRequest, ByteString documentBytes, BulkRequestBody bulkRequestBody, long ifSeqNoFromOperation, long ifPrimaryTermFromOperation) {
        UpdateAction updateAction;
        long ifSeqNo = ifSeqNoFromOperation;
        long ifPrimaryTerm = ifPrimaryTermFromOperation;
        if (bulkRequestBody.hasUpdateAction()) {
            updateAction = bulkRequestBody.getUpdateAction();
            if (updateAction.hasScript()) {
                Script script = ScriptProtoUtils.parseFromProtoRequest(updateAction.getScript());
                updateRequest.script(script);
            }
            if (updateAction.hasScriptedUpsert()) {
                updateRequest.scriptedUpsert(updateAction.getScriptedUpsert());
            }
            if (updateAction.hasUpsert()) {
                ByteString upsertBytes = updateAction.getUpsert();
                BytesReference upsertRef = BulkRequestParserProtoUtils.byteStringToBytesReference(upsertBytes);
                MediaType upsertMediaType = BulkRequestParserProtoUtils.detectMediaType(upsertRef);
                BytesRef bytesRef = upsertRef.toBytesRef();
                updateRequest.upsert(bytesRef.bytes, bytesRef.offset, bytesRef.length, upsertMediaType);
            }
        }
        if (documentBytes != null && !documentBytes.isEmpty()) {
            BytesReference docRef = BulkRequestParserProtoUtils.byteStringToBytesReference(documentBytes);
            MediaType mediaType = BulkRequestParserProtoUtils.detectMediaType(docRef);
            BytesRef bytesRef = docRef.toBytesRef();
            updateRequest.doc(bytesRef.bytes, bytesRef.offset, bytesRef.length, mediaType);
        }
        if (bulkRequestBody.hasUpdateAction()) {
            updateAction = bulkRequestBody.getUpdateAction();
            if (updateAction.hasDocAsUpsert()) {
                updateRequest.docAsUpsert(updateAction.getDocAsUpsert());
            }
            if (updateAction.hasDetectNoop()) {
                updateRequest.detectNoop(updateAction.getDetectNoop());
            }
            if (updateAction.hasXSource()) {
                updateRequest.fetchSource(FetchSourceContextProtoUtils.fromProto(updateAction.getXSource()));
            }
        }
        updateRequest.setIfSeqNo(ifSeqNo);
        updateRequest.setIfPrimaryTerm(ifPrimaryTerm);
        return updateRequest;
    }

    public static DeleteRequest buildDeleteRequest(DeleteOperation deleteOperation, String index, String id, String routing, long version, VersionType versionType, long ifSeqNo, long ifPrimaryTerm) {
        if (deleteOperation.hasXIndex()) {
            index = deleteOperation.getXIndex();
        }
        id = deleteOperation.hasXId() ? deleteOperation.getXId() : id;
        routing = deleteOperation.hasRouting() ? deleteOperation.getRouting() : routing;
        long l = version = deleteOperation.hasVersion() ? deleteOperation.getVersion() : version;
        if (deleteOperation.hasVersionType()) {
            versionType = VersionTypeProtoUtils.fromProto(deleteOperation.getVersionType());
        }
        ifSeqNo = deleteOperation.hasIfSeqNo() ? deleteOperation.getIfSeqNo() : ifSeqNo;
        ifPrimaryTerm = deleteOperation.hasIfPrimaryTerm() ? deleteOperation.getIfPrimaryTerm() : ifPrimaryTerm;
        DeleteRequest deleteRequest = new DeleteRequest(index).id(id).routing(routing).version(version).versionType(versionType).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm);
        return deleteRequest;
    }
}

