/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filterrewrite;

import org.apache.lucene.util.ArrayUtil;

public final class Ranges {
    byte[][] lowers;
    byte[][] uppers;
    int size;
    int byteLen;
    ArrayUtil.ByteArrayComparator comparator;

    Ranges(byte[][] lowers, byte[][] uppers) {
        this.lowers = lowers;
        this.uppers = uppers;
        assert (lowers.length == uppers.length);
        this.size = lowers.length;
        this.byteLen = lowers[0].length;
        this.comparator = ArrayUtil.getUnsignedComparator((int)this.byteLen);
    }

    public int getSize() {
        return this.size;
    }

    public byte[][] getLowers() {
        return this.lowers;
    }

    public byte[][] getUppers() {
        return this.uppers;
    }

    public int firstRangeIndex(byte[] globalMin, byte[] globalMax) {
        if (this.compareByteValue(this.lowers[0], globalMax) > 0) {
            return -1;
        }
        int i = 0;
        while (this.compareByteValue(this.uppers[i], globalMin) <= 0) {
            if (++i < this.size) continue;
            return -1;
        }
        return i;
    }

    public int compareByteValue(byte[] value1, byte[] value2) {
        return this.comparator.compare(value1, 0, value2, 0);
    }

    public boolean withinLowerBound(byte[] value, byte[] lowerBound) {
        return this.compareByteValue(value, lowerBound) >= 0;
    }

    public boolean withinUpperBound(byte[] value, byte[] upperBound) {
        return this.compareByteValue(value, upperBound) < 0;
    }
}

