/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg.keybox;

import java.io.IOException;
import org.bouncycastle.gpg.keybox.KeyBoxByteBuffer;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class UserID {
    private final long offsetToUserId;
    private final long lengthOfUserId;
    private final int userIdFlags;
    private final int validity;
    private final int reserved;
    private final byte[] userID;

    private UserID(long offsetToUserId, long lengthOfUserId, int userIdFlags, int validity, int reserved, byte[] userID) {
        this.offsetToUserId = offsetToUserId;
        this.lengthOfUserId = lengthOfUserId;
        this.userIdFlags = userIdFlags;
        this.validity = validity;
        this.reserved = reserved;
        this.userID = userID;
    }

    static UserID getInstance(Object src, int base) throws IOException {
        if (src instanceof UserID) {
            return (UserID)src;
        }
        KeyBoxByteBuffer buffer = KeyBoxByteBuffer.wrap(src);
        long offsetToUserId = buffer.u32();
        long lengthOfUserId = buffer.u32();
        int specialUserIdFlags = buffer.u16();
        int validity = buffer.u8();
        int reserved = buffer.u8();
        byte[] userID = buffer.rangeOf((int)((long)base + offsetToUserId), (int)((long)base + offsetToUserId + lengthOfUserId));
        return new UserID(offsetToUserId, lengthOfUserId, specialUserIdFlags, validity, reserved, userID);
    }

    public long getOffsetToUserId() {
        return this.offsetToUserId;
    }

    public long getLengthOfUserId() {
        return this.lengthOfUserId;
    }

    public long getUserIdFlags() {
        return this.userIdFlags;
    }

    public int getValidity() {
        return this.validity;
    }

    public int getReserved() {
        return this.reserved;
    }

    public byte[] getUserID() {
        return Arrays.clone((byte[])this.userID);
    }

    public String getUserIDAsString() {
        return Strings.fromUTF8ByteArray((byte[])this.userID);
    }
}

