/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.CategoryWordTagFactory;
import edu.stanford.nlp.ling.HasCategory;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.StringLabel;

public class CategoryWordTag
extends StringLabel
implements HasCategory,
HasWord,
HasTag {
    private static final long serialVersionUID = -745085381666943254L;
    protected String word;
    protected String tag;
    public static boolean printWordTag = true;
    public static boolean suppressTerminalDetails;

    public CategoryWordTag() {
    }

    public CategoryWordTag(String label) {
        super(label);
    }

    public CategoryWordTag(String category, String word, String tag) {
        super(category);
        this.word = word;
        this.tag = tag;
    }

    public CategoryWordTag(Label oldLabel) {
        super(oldLabel);
        if (oldLabel instanceof HasTag) {
            this.tag = ((HasTag)((Object)oldLabel)).tag();
        }
        if (oldLabel instanceof HasWord) {
            this.word = ((HasWord)((Object)oldLabel)).word();
        }
    }

    public String category() {
        return this.value();
    }

    public void setCategory(String category) {
        this.setValue(category);
    }

    public String word() {
        return this.word;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public String tag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setCategoryWordTag(String category, String word, String tag) {
        this.setCategory(category);
        this.setWord(word);
        this.setTag(tag);
    }

    public String toString() {
        if (this.category() != null) {
            if (this.word() == null || this.tag() == null || !printWordTag || suppressTerminalDetails && (this.word().equals(this.category()) || this.tag().equals(this.category()))) {
                return this.category();
            }
            return this.category() + "[" + this.word() + "/" + this.tag() + "]";
        }
        if (this.tag() == null) {
            return this.word();
        }
        return this.word() + "/" + this.tag();
    }

    public String toString(String mode) {
        if ("full".equals(mode)) {
            return this.category() + "[" + this.word() + "/" + this.tag() + "]";
        }
        return this.toString();
    }

    public void setFromString(String labelStr) {
        throw new UnsupportedOperationException();
    }

    public LabelFactory labelFactory() {
        return LabelFactoryHolder.lf;
    }

    public static LabelFactory factory() {
        return LabelFactoryHolder.lf;
    }

    private static class LabelFactoryHolder {
        private static final LabelFactory lf = new CategoryWordTagFactory();

        private LabelFactoryHolder() {
        }
    }
}

