/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.form.editors.ModifierPanel;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ModifierEditor
extends JPanel
implements ExPropertyEditor {
    public static final String PROP_MODIFIERS = "modifiers";
    public static final String CUSTOM_EDITOR_TYPE = "customEditorType";
    public static final Integer ACCESS_MODIFIERS_CUSTOM_EDITOR = 0;
    public static final Integer OTHERS_MODIFIERS_CUSTOM_EDITOR = 1;
    public static final Integer FULL_CUSTOM_EDITOR = 2;
    private ModifierPanel panel;
    private int mask;
    private int modifier = 0;
    private PropertyEnv env;
    private Object type;
    private Component customComponent;

    public ModifierEditor() {
        this(3583);
    }

    public ModifierEditor(int mask) {
        this.setMask(mask & 0xDFF);
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.openide.explorer.propertysheet.editors.ModifierEditor");
    }

    @Override
    public void addNotify() {
        this.setLayout(new BorderLayout());
        this.panel = new ModifierPanel(this);
        Object type = this.getType();
        this.customComponent = ACCESS_MODIFIERS_CUSTOM_EDITOR.equals(type) ? this.panel.getAccessComponent() : (OTHERS_MODIFIERS_CUSTOM_EDITOR.equals(type) ? this.panel.getModifiersComponent() : this.panel.getCompactComponent());
        this.add(this.customComponent, "Center");
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.panel != null) {
            this.remove(this.customComponent);
            this.panel = null;
        }
    }

    int getMask() {
        return this.mask;
    }

    public void setMask(int mask) {
        if (this.mask != mask) {
            int oldMask = this.mask;
            this.mask = mask & 0xDFF;
            this.firePropertyChange("mask", (Object)oldMask, (Object)mask);
            this.setModifier(this.modifier & mask);
        }
    }

    int getModifier() {
        return this.modifier;
    }

    void setModifier(int modifier) {
        if (this.modifier != modifier) {
            int oldModifier = this.modifier;
            this.modifier = modifier;
            this.firePropertyChange("modifier", (Object)oldModifier, (Object)modifier);
            this.firePropertyChange(PROP_MODIFIERS, (Object)oldModifier, (Object)modifier);
        }
    }

    Object getType() {
        return this.type;
    }

    public void setValue(Object object) throws IllegalArgumentException {
        if (object == null) {
            this.setModifier(0);
            return;
        }
        if (!(object instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        this.setModifier((Integer)object);
    }

    public String getJavaInitializationString() {
        return Integer.toString(this.getModifier());
    }

    public Object getValue() {
        return this.getModifier();
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle rectangle) {
    }

    public String getAsText() {
        return Modifier.toString(this.getModifier());
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int newValue = 0;
        int oldValue = this.modifier;
        StringTokenizer tukac = new StringTokenizer(string, ", ", false);
        while (tukac.hasMoreTokens()) {
            int i;
            String token = tukac.nextToken();
            boolean known = false;
            for (i = 0; i < ModifierPanel.MODIFIER_COUNT; ++i) {
                if ((ModifierPanel.MODIFIER_VALUES[i] & this.mask) == 0 || !token.equals(ModifierPanel.MODIFIER_NAMES[i])) continue;
                if (ModifierPanel.MODIFIER_VALUES[i] == 16 && (newValue & 0x400) != 0 || ModifierPanel.MODIFIER_VALUES[i] == 1024 && (newValue & 0x10) != 0) break;
                newValue |= ModifierPanel.MODIFIER_VALUES[i];
                known = true;
                break;
            }
            if ((newValue & 7) == 0) {
                for (i = 1; i <= 3; ++i) {
                    if ((ModifierPanel.ACCESS_VALUES[i] & this.mask) == 0 || !token.equals(ModifierPanel.ACCESS_NAMES[i])) continue;
                    newValue |= ModifierPanel.ACCESS_VALUES[i];
                    known = true;
                    break;
                }
            }
            if (known) continue;
            IllegalArgumentException x = new IllegalArgumentException("Invalid modifier: " + token);
            String message = MessageFormat.format(ModifierEditor.getString("MSG_IllegalModifierString"), token);
            ErrorManager.getDefault().annotate((Throwable)x, 256, null, message, null, null);
            throw x;
        }
        if (oldValue != newValue) {
            this.modifier = newValue;
            this.firePropertyChange("modifier", (Object)oldValue, (Object)this.modifier);
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.getValue();
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
        this.type = env.getFeatureDescriptor().getValue(CUSTOM_EDITOR_TYPE);
        this.type = this.type == null ? FULL_CUSTOM_EDITOR : (ACCESS_MODIFIERS_CUSTOM_EDITOR.equals(this.type) ? ACCESS_MODIFIERS_CUSTOM_EDITOR : (OTHERS_MODIFIERS_CUSTOM_EDITOR.equals(this.type) ? OTHERS_MODIFIERS_CUSTOM_EDITOR : FULL_CUSTOM_EDITOR));
    }

    private static String getString(String key) {
        return NbBundle.getMessage(ModifierEditor.class, (String)key);
    }
}

