/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.BuildPipelineStagePredecessorCollection;
import com.oracle.bmc.devops.model.BuildPipelineStageRunProgress;
import com.oracle.bmc.devops.model.DeployArtifactOverrideArgumentCollection;
import com.oracle.bmc.devops.model.ExportedVariableCollection;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="buildPipelineStageType")
@JsonFilter(value="explicitlySetFilter")
public final class TriggerDeploymentPipelineStageRunProgress
extends BuildPipelineStageRunProgress {
    @JsonProperty(value="exportedVariables")
    private final ExportedVariableCollection exportedVariables;
    @JsonProperty(value="artifactOverrideParameters")
    private final DeployArtifactOverrideArgumentCollection artifactOverrideParameters;
    @JsonProperty(value="deploymentId")
    private final String deploymentId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public TriggerDeploymentPipelineStageRunProgress(String stageDisplayName, String buildPipelineStageId, Date timeStarted, Date timeFinished, BuildPipelineStageRunProgress.Status status, BuildPipelineStagePredecessorCollection buildPipelineStagePredecessors, ExportedVariableCollection exportedVariables, DeployArtifactOverrideArgumentCollection artifactOverrideParameters, String deploymentId) {
        super(stageDisplayName, buildPipelineStageId, timeStarted, timeFinished, status, buildPipelineStagePredecessors);
        this.exportedVariables = exportedVariables;
        this.artifactOverrideParameters = artifactOverrideParameters;
        this.deploymentId = deploymentId;
    }

    public ExportedVariableCollection getExportedVariables() {
        return this.exportedVariables;
    }

    public DeployArtifactOverrideArgumentCollection getArtifactOverrideParameters() {
        return this.artifactOverrideParameters;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TriggerDeploymentPipelineStageRunProgress(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", exportedVariables=").append(String.valueOf((Object)this.exportedVariables));
        sb.append(", artifactOverrideParameters=").append(String.valueOf((Object)this.artifactOverrideParameters));
        sb.append(", deploymentId=").append(String.valueOf(this.deploymentId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TriggerDeploymentPipelineStageRunProgress)) {
            return false;
        }
        TriggerDeploymentPipelineStageRunProgress other = (TriggerDeploymentPipelineStageRunProgress)((Object)o);
        return Objects.equals((Object)this.exportedVariables, (Object)other.exportedVariables) && Objects.equals((Object)this.artifactOverrideParameters, (Object)other.artifactOverrideParameters) && Objects.equals(this.deploymentId, other.deploymentId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.exportedVariables == null ? 43 : this.exportedVariables.hashCode());
        result = result * 59 + (this.artifactOverrideParameters == null ? 43 : this.artifactOverrideParameters.hashCode());
        result = result * 59 + (this.deploymentId == null ? 43 : this.deploymentId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="stageDisplayName")
        private String stageDisplayName;
        @JsonProperty(value="buildPipelineStageId")
        private String buildPipelineStageId;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="status")
        private BuildPipelineStageRunProgress.Status status;
        @JsonProperty(value="buildPipelineStagePredecessors")
        private BuildPipelineStagePredecessorCollection buildPipelineStagePredecessors;
        @JsonProperty(value="exportedVariables")
        private ExportedVariableCollection exportedVariables;
        @JsonProperty(value="artifactOverrideParameters")
        private DeployArtifactOverrideArgumentCollection artifactOverrideParameters;
        @JsonProperty(value="deploymentId")
        private String deploymentId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder stageDisplayName(String stageDisplayName) {
            this.stageDisplayName = stageDisplayName;
            this.__explicitlySet__.add("stageDisplayName");
            return this;
        }

        public Builder buildPipelineStageId(String buildPipelineStageId) {
            this.buildPipelineStageId = buildPipelineStageId;
            this.__explicitlySet__.add("buildPipelineStageId");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder status(BuildPipelineStageRunProgress.Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder buildPipelineStagePredecessors(BuildPipelineStagePredecessorCollection buildPipelineStagePredecessors) {
            this.buildPipelineStagePredecessors = buildPipelineStagePredecessors;
            this.__explicitlySet__.add("buildPipelineStagePredecessors");
            return this;
        }

        public Builder exportedVariables(ExportedVariableCollection exportedVariables) {
            this.exportedVariables = exportedVariables;
            this.__explicitlySet__.add("exportedVariables");
            return this;
        }

        public Builder artifactOverrideParameters(DeployArtifactOverrideArgumentCollection artifactOverrideParameters) {
            this.artifactOverrideParameters = artifactOverrideParameters;
            this.__explicitlySet__.add("artifactOverrideParameters");
            return this;
        }

        public Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            this.__explicitlySet__.add("deploymentId");
            return this;
        }

        public TriggerDeploymentPipelineStageRunProgress build() {
            TriggerDeploymentPipelineStageRunProgress model = new TriggerDeploymentPipelineStageRunProgress(this.stageDisplayName, this.buildPipelineStageId, this.timeStarted, this.timeFinished, this.status, this.buildPipelineStagePredecessors, this.exportedVariables, this.artifactOverrideParameters, this.deploymentId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TriggerDeploymentPipelineStageRunProgress model) {
            if (model.wasPropertyExplicitlySet("stageDisplayName")) {
                this.stageDisplayName(model.getStageDisplayName());
            }
            if (model.wasPropertyExplicitlySet("buildPipelineStageId")) {
                this.buildPipelineStageId(model.getBuildPipelineStageId());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("buildPipelineStagePredecessors")) {
                this.buildPipelineStagePredecessors(model.getBuildPipelineStagePredecessors());
            }
            if (model.wasPropertyExplicitlySet("exportedVariables")) {
                this.exportedVariables(model.getExportedVariables());
            }
            if (model.wasPropertyExplicitlySet("artifactOverrideParameters")) {
                this.artifactOverrideParameters(model.getArtifactOverrideParameters());
            }
            if (model.wasPropertyExplicitlySet("deploymentId")) {
                this.deploymentId(model.getDeploymentId());
            }
            return this;
        }
    }
}

