/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.CaptureScanner;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.Operators;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.comp.TreeDiffer;
import com.sun.tools.javac.comp.TreeHasher;
import com.sun.tools.javac.jvm.PoolConstant;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.InvalidUtfException;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.lang.model.element.ElementKind;

public class LambdaToMethod
extends TreeTranslator {
    private final Attr attr;
    private final JCDiagnostic.Factory diags;
    private final Log log;
    private final Lower lower;
    private final Names names;
    private final Symtab syms;
    private final Resolve rs;
    private final Operators operators;
    private TreeMaker make;
    private final Types types;
    private final TransTypes transTypes;
    private Env<AttrContext> attrEnv;
    private KlassInfo kInfo;
    private LambdaTranslationContext lambdaContext;
    private Symbol.VarSymbol pendingVar;
    private final boolean dumpLambdaToMethodStats;
    private final boolean forceSerializable;
    private final boolean debugLinesOrVars;
    private final boolean verboseDeduplication;
    private final boolean deduplicateLambdas;
    public static final int FLAG_SERIALIZABLE = 1;
    public static final int FLAG_MARKERS = 2;
    public static final int FLAG_BRIDGES = 4;
    protected static final Context.Key<LambdaToMethod> unlambdaKey = new Context.Key();

    public static LambdaToMethod instance(Context context) {
        LambdaToMethod instance = context.get(unlambdaKey);
        if (instance == null) {
            instance = new LambdaToMethod(context);
        }
        return instance;
    }

    private LambdaToMethod(Context context) {
        context.put(unlambdaKey, this);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.log = Log.instance(context);
        this.lower = Lower.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.rs = Resolve.instance(context);
        this.operators = Operators.instance(context);
        this.make = TreeMaker.instance(context);
        this.types = Types.instance(context);
        this.transTypes = TransTypes.instance(context);
        Options options = Options.instance(context);
        this.dumpLambdaToMethodStats = options.isSet("debug.dumpLambdaToMethodStats");
        this.attr = Attr.instance(context);
        this.forceSerializable = options.isSet("forceSerializable");
        boolean lineDebugInfo = options.isUnset(Option.G_CUSTOM) || options.isSet(Option.G_CUSTOM, "lines");
        boolean varDebugInfo = options.isUnset(Option.G_CUSTOM) ? options.isSet(Option.G) : options.isSet(Option.G_CUSTOM, "vars");
        this.debugLinesOrVars = lineDebugInfo || varDebugInfo;
        this.verboseDeduplication = options.isSet("debug.dumpLambdaToMethodDeduplication");
        this.deduplicateLambdas = options.getBoolean("deduplicateLambdas", true);
    }

    public JCTree translateTopLevelClass(Env<AttrContext> env, JCTree cdef, TreeMaker make) {
        this.make = make;
        this.attrEnv = env;
        return this.translate(cdef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        KlassInfo prevKlassInfo = this.kInfo;
        DiagnosticSource prevSource = this.log.currentSource();
        LambdaTranslationContext prevLambdaContext = this.lambdaContext;
        Symbol.VarSymbol prevPendingVar = this.pendingVar;
        try {
            this.kInfo = new KlassInfo(tree);
            this.log.useSource(tree.sym.sourcefile);
            this.lambdaContext = null;
            this.pendingVar = null;
            super.visitClassDef(tree);
            if (prevLambdaContext != null) {
                tree.sym.owner = prevLambdaContext.translatedSym;
            }
            if (!this.kInfo.deserializeCases.isEmpty()) {
                int prevPos = this.make.pos;
                try {
                    this.make.at(tree);
                    this.kInfo.addMethod(this.makeDeserializeMethod());
                }
                finally {
                    this.make.at(prevPos);
                }
            }
            List newMethods = this.kInfo.appendedMethodList.toList();
            tree.defs = tree.defs.appendList(newMethods);
            for (JCTree lambda : newMethods) {
                tree.sym.members().enter(((JCTree.JCMethodDecl)lambda).sym);
            }
            this.result = tree;
        }
        finally {
            this.kInfo = prevKlassInfo;
            this.log.useSource(prevSource.getFile());
            this.lambdaContext = prevLambdaContext;
            this.pendingVar = prevPendingVar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitLambda(JCTree.JCLambda tree) {
        LambdaTranslationContext localContext = new LambdaTranslationContext(tree);
        Symbol.MethodSymbol sym = localContext.translatedSym;
        Type.MethodType lambdaType = (Type.MethodType)sym.type;
        Symbol owner = tree.owner;
        this.apportionTypeAnnotations(tree, owner::getRawTypeAttributes, owner::setTypeAttributes, sym::setTypeAttributes);
        long ownerFlags = owner.flags();
        if ((ownerFlags & 0x100000L) != 0L) {
            boolean isStaticInit;
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)owner.owner;
            boolean bl = isStaticInit = (ownerFlags & 8L) != 0L;
            this.apportionTypeAnnotations(tree, isStaticInit ? classSymbol::getClassInitTypeAttributes : classSymbol::getInitTypeAttributes, isStaticInit ? classSymbol::setClassInitTypeAttributes : classSymbol::setInitTypeAttributes, sym::appendUniqueTypeAttributes);
        }
        if (this.pendingVar != null && this.pendingVar.getKind() == ElementKind.FIELD) {
            this.apportionTypeAnnotations(tree, this.pendingVar::getRawTypeAttributes, this.pendingVar::setTypeAttributes, sym::appendUniqueTypeAttributes);
        }
        JCTree.JCMethodDecl lambdaDecl = this.make.MethodDef(this.make.Modifiers(sym.flags_field), sym.name, this.make.QualIdent(lambdaType.getReturnType().tsym), List.nil(), localContext.syntheticParams, lambdaType.getThrownTypes() == null ? List.nil() : this.make.Types((List<Type>)lambdaType.getThrownTypes()), null, null);
        lambdaDecl.sym = sym;
        lambdaDecl.type = lambdaType;
        ListBuffer<JCTree.JCExpression> syntheticInits = new ListBuffer<JCTree.JCExpression>();
        if (!sym.isStatic()) {
            syntheticInits.append(this.makeThis((Type)sym.owner.enclClass().asType(), tree.owner.enclClass()));
        }
        for (Symbol symbol : localContext.capturedVars) {
            JCTree.JCExpression captured_local = this.make.Ident(symbol).setType(symbol.type);
            syntheticInits.append(captured_local);
        }
        List<JCTree.JCExpression> indy_args = this.translate(syntheticInits.toList());
        LambdaTranslationContext lambdaTranslationContext = this.lambdaContext;
        try {
            this.lambdaContext = localContext;
            lambdaDecl.body = this.translate(this.makeLambdaBody(tree, lambdaDecl));
        }
        finally {
            this.lambdaContext = lambdaTranslationContext;
        }
        boolean dedupe = false;
        if (this.deduplicateLambdas && !this.debugLinesOrVars && !this.isSerializable(tree)) {
            DedupedLambda dedupedLambda = new DedupedLambda(lambdaDecl.sym, lambdaDecl.body);
            DedupedLambda existing = this.kInfo.dedupedLambdas.putIfAbsent(dedupedLambda, dedupedLambda);
            if (existing != null) {
                sym = existing.symbol;
                dedupe = true;
                if (this.verboseDeduplication) {
                    this.log.note(tree, CompilerProperties.Notes.VerboseL2mDeduplicate(sym));
                }
            }
        }
        if (!dedupe) {
            this.kInfo.addMethod(lambdaDecl);
        }
        this.result = this.makeMetafactoryIndyCall(tree, sym.asHandle(), localContext.translatedSym, indy_args);
    }

    private void apportionTypeAnnotations(JCTree.JCLambda tree, Supplier<List<Attribute.TypeCompound>> source, Consumer<List<Attribute.TypeCompound>> owner, Consumer<List<Attribute.TypeCompound>> lambda) {
        ListBuffer<Attribute.TypeCompound> ownerTypeAnnos = new ListBuffer<Attribute.TypeCompound>();
        ListBuffer<Attribute.TypeCompound> lambdaTypeAnnos = new ListBuffer<Attribute.TypeCompound>();
        for (Attribute.TypeCompound tc : source.get()) {
            if (tc.position.onLambda == tree) {
                lambdaTypeAnnos.append(tc);
                continue;
            }
            ownerTypeAnnos.append(tc);
        }
        if (lambdaTypeAnnos.nonEmpty()) {
            owner.accept(ownerTypeAnnos.toList());
            lambda.accept(lambdaTypeAnnos.toList());
        }
    }

    private JCTree.JCIdent makeThis(Type type, Symbol owner) {
        Symbol.VarSymbol _this = new Symbol.VarSymbol(0x200001010L, this.names._this, type, owner);
        return this.make.Ident(_this);
    }

    @Override
    public void visitReference(JCTree.JCMemberReference tree) {
        JCTree.JCExpression jCExpression;
        Symbol.MethodSymbol refSym = (Symbol.MethodSymbol)tree.sym;
        switch (tree.kind) {
            default: {
                throw new IllegalStateException(null, null);
            }
            case IMPLICIT_INNER: 
            case SUPER: {
                jCExpression = this.makeThis((Type)tree.owner.enclClass().asType(), tree.owner.enclClass());
                break;
            }
            case BOUND: {
                jCExpression = this.attr.makeNullCheck(this.transTypes.coerce(this.attrEnv, tree.getQualifierExpression(), this.types.erasure(tree.sym.owner.type)));
                break;
            }
            case UNBOUND: 
            case STATIC: 
            case TOPLEVEL: 
            case ARRAY_CTOR: {
                jCExpression = null;
            }
        }
        JCTree.JCIdent init = jCExpression;
        List<JCTree.JCExpression> indy_args = init == null ? List.nil() : this.translate(List.of(init));
        this.result = this.makeMetafactoryIndyCall(tree, refSym.asHandle(), refSym, indy_args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        if (this.lambdaContext == null) {
            super.visitIdent(tree);
        } else {
            int prevPos = this.make.pos;
            try {
                this.make.at(tree);
                JCTree ltree = this.lambdaContext.translate(tree);
                if (ltree != null) {
                    this.result = ltree;
                } else {
                    super.visitIdent(tree);
                }
            }
            finally {
                this.make.at(prevPos);
            }
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        Symbol.VarSymbol prevPendingVar = this.pendingVar;
        try {
            this.pendingVar = tree.sym;
            if (this.lambdaContext != null) {
                tree.sym = this.lambdaContext.addLocal(tree.sym);
                tree.init = this.translate(tree.init);
                this.result = tree;
            } else {
                super.visitVarDef(tree);
            }
        }
        finally {
            this.pendingVar = prevPendingVar;
        }
    }

    private JCTree.JCBlock makeLambdaBody(JCTree.JCLambda tree, JCTree.JCMethodDecl lambdaMethodDecl) {
        return tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION ? this.makeLambdaExpressionBody((JCTree.JCExpression)tree.body, lambdaMethodDecl) : this.makeLambdaStatementBody((JCTree.JCBlock)tree.body, lambdaMethodDecl, tree.canCompleteNormally);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCBlock makeLambdaExpressionBody(JCTree.JCExpression expr, JCTree.JCMethodDecl lambdaMethodDecl) {
        Type restype = lambdaMethodDecl.type.getReturnType();
        boolean isLambda_void = expr.type.hasTag(TypeTag.VOID);
        boolean isTarget_void = restype.hasTag(TypeTag.VOID);
        boolean isTarget_Void = this.types.isSameType(restype, this.types.boxedClass((Type)this.syms.voidType).type);
        int prevPos = this.make.pos;
        try {
            if (isTarget_void) {
                JCTree.JCExpressionStatement stat = this.make.at(expr).Exec(expr);
                JCTree.JCBlock jCBlock = this.make.Block(0L, List.of(stat));
                return jCBlock;
            }
            if (isLambda_void && isTarget_Void) {
                ListBuffer<JCTree.JCStatement> stats = new ListBuffer<JCTree.JCStatement>();
                stats.append(this.make.at(expr).Exec(expr));
                stats.append(this.make.Return(this.make.Literal(TypeTag.BOT, null).setType(this.syms.botType)));
                JCTree.JCBlock jCBlock = this.make.Block(0L, stats.toList());
                return jCBlock;
            }
            JCTree.JCBlock jCBlock = this.make.at(expr).Block(0L, List.of(this.make.Return(expr)));
            return jCBlock;
        }
        finally {
            this.make.at(prevPos);
        }
    }

    private JCTree.JCBlock makeLambdaStatementBody(JCTree.JCBlock block, final JCTree.JCMethodDecl lambdaMethodDecl, boolean completeNormally) {
        Type restype = lambdaMethodDecl.type.getReturnType();
        final boolean isTarget_void = restype.hasTag(TypeTag.VOID);
        boolean isTarget_Void = this.types.isSameType(restype, this.types.boxedClass((Type)this.syms.voidType).type);
        class LambdaBodyTranslator
        extends TreeTranslator {
            LambdaBodyTranslator() {
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
                this.result = tree;
            }

            @Override
            public void visitLambda(JCTree.JCLambda tree) {
                this.result = tree;
            }

            @Override
            public void visitReturn(JCTree.JCReturn tree) {
                boolean isLambda_void;
                boolean bl = isLambda_void = tree.expr == null;
                if (isTarget_void && !isLambda_void) {
                    Symbol.VarSymbol loc = new Symbol.VarSymbol(4096L, LambdaToMethod.this.names.fromString("$loc"), tree.expr.type, lambdaMethodDecl.sym);
                    JCTree.JCVariableDecl varDef = LambdaToMethod.this.make.VarDef(loc, tree.expr);
                    this.result = LambdaToMethod.this.make.Block(0L, List.of(varDef, LambdaToMethod.this.make.Return(null)));
                } else {
                    this.result = tree;
                }
            }
        }
        JCTree.JCBlock trans_block = new LambdaBodyTranslator().translate(block);
        if (completeNormally && isTarget_Void) {
            trans_block.stats = trans_block.stats.append(this.make.Return(this.make.Literal(TypeTag.BOT, null).setType(this.syms.botType)));
        }
        return trans_block;
    }

    private JCTree.JCMethodDecl makeDeserializeMethod() {
        ListBuffer<JCTree.JCCase> cases = new ListBuffer<JCTree.JCCase>();
        ListBuffer<JCTree.JCBreak> breaks = new ListBuffer<JCTree.JCBreak>();
        for (Map.Entry entry : this.kInfo.deserializeCases.entrySet()) {
            JCTree.JCBreak br = this.make.Break(null);
            breaks.add(br);
            List<JCTree.JCStatement> stmts = ((ListBuffer)entry.getValue()).append(br).toList();
            cases.add(this.make.Case(JCTree.JCCase.STATEMENT, List.of(this.make.ConstantCaseLabel(this.make.Literal(entry.getKey()))), null, stmts, null));
        }
        JCTree.JCSwitch sw = this.make.Switch(this.deserGetter("getImplMethodName", this.syms.stringType), cases.toList());
        for (JCTree.JCBreak br : breaks) {
            br.target = sw;
        }
        JCTree.JCBlock jCBlock = this.make.Block(0L, List.of(sw, this.make.Throw(this.makeNewClass(this.syms.illegalArgumentExceptionType, List.of(this.make.Literal("Invalid lambda deserialization"))))));
        JCTree.JCMethodDecl deser = this.make.MethodDef(this.make.Modifiers(this.kInfo.deserMethodSym.flags()), this.names.deserializeLambda, this.make.QualIdent(((KlassInfo)this.kInfo).deserMethodSym.getReturnType().tsym), List.nil(), List.of(this.make.VarDef(this.kInfo.deserParamSym, null)), List.nil(), jCBlock, null);
        deser.sym = this.kInfo.deserMethodSym;
        deser.type = ((KlassInfo)this.kInfo).deserMethodSym.type;
        return this.lower.translateMethod(this.attrEnv, deser, this.make);
    }

    JCTree.JCNewClass makeNewClass(Type ctype, List<JCTree.JCExpression> args, Symbol cons) {
        JCTree.JCNewClass tree = this.make.NewClass(null, null, this.make.QualIdent(ctype.tsym), args, null);
        tree.constructor = cons;
        tree.type = ctype;
        return tree;
    }

    JCTree.JCNewClass makeNewClass(Type ctype, List<JCTree.JCExpression> args) {
        return this.makeNewClass(ctype, args, this.rs.resolveConstructor(null, this.attrEnv, ctype, TreeInfo.types(args), List.nil()));
    }

    private void addDeserializationCase(Symbol.MethodHandleSymbol refSym, Type targetType, Symbol.MethodSymbol samSym, JCDiagnostic.DiagnosticPosition pos, List<PoolConstant.LoadableConstant> staticArgs, Type.MethodType indyType) {
        Symbol origMethod;
        String functionalInterfaceClass = this.classSig(targetType);
        String functionalInterfaceMethodName = ((Name)samSym.getSimpleName()).toString();
        String functionalInterfaceMethodSignature = this.typeSig(this.types.erasure(samSym.type));
        Symbol baseMethod = refSym.baseSymbol();
        if (baseMethod != (origMethod = baseMethod.baseSymbol()) && origMethod.owner == this.syms.objectType.tsym) {
            refSym = ((Symbol.MethodSymbol)origMethod).asHandle();
        }
        String implClass = this.classSig(this.types.erasure(refSym.owner.type));
        String implMethodName = refSym.getQualifiedName().toString();
        String implMethodSignature = this.typeSig(this.types.erasure(refSym.type));
        JCTree.JCExpression kindTest = this.eqTest(this.syms.intType, this.deserGetter("getImplMethodKind", this.syms.intType), this.make.Literal(refSym.referenceKind()));
        ListBuffer<JCTree.JCTypeCast> serArgs = new ListBuffer<JCTree.JCTypeCast>();
        int i = 0;
        for (Type t : indyType.getParameterTypes()) {
            List<JCTree.JCExpression> indexAsArg = new ListBuffer<JCTree.JCLiteral>().append(this.make.Literal(i)).toList();
            List<Type> argTypes = new ListBuffer<Type.JCPrimitiveType>().append(this.syms.intType).toList();
            serArgs.add(this.make.TypeCast(this.types.erasure(t), this.deserGetter("getCapturedArg", this.syms.objectType, argTypes, indexAsArg)));
            ++i;
        }
        JCTree.JCIf stmt = this.make.If(this.deserTest(this.deserTest(this.deserTest(this.deserTest(this.deserTest(kindTest, "getFunctionalInterfaceClass", functionalInterfaceClass), "getFunctionalInterfaceMethodName", functionalInterfaceMethodName), "getFunctionalInterfaceMethodSignature", functionalInterfaceMethodSignature), "getImplClass", implClass), "getImplMethodSignature", implMethodSignature), this.make.Return(this.makeIndyCall(pos, this.syms.lambdaMetafactory, this.names.altMetafactory, staticArgs, indyType, serArgs.toList(), samSym.name)), null);
        ListBuffer<JCTree.JCIf> stmts = (ListBuffer<JCTree.JCIf>)this.kInfo.deserializeCases.get(implMethodName);
        if (stmts == null) {
            stmts = new ListBuffer<JCTree.JCIf>();
            this.kInfo.deserializeCases.put(implMethodName, stmts);
        }
        stmts.append(stmt);
    }

    private JCTree.JCExpression eqTest(Type argType, JCTree.JCExpression arg1, JCTree.JCExpression arg2) {
        JCTree.JCBinary testExpr = this.make.Binary(JCTree.Tag.EQ, arg1, arg2);
        testExpr.operator = this.operators.resolveBinary(testExpr, JCTree.Tag.EQ, argType, argType);
        testExpr.setType(this.syms.booleanType);
        return testExpr;
    }

    private JCTree.JCExpression deserTest(JCTree.JCExpression prev, String func, String lit) {
        Type.MethodType eqmt = new Type.MethodType(List.of(this.syms.objectType), this.syms.booleanType, List.nil(), this.syms.methodClass);
        Symbol eqsym = this.rs.resolveQualifiedMethod(null, this.attrEnv, this.syms.objectType, this.names.equals, List.of(this.syms.objectType), List.nil());
        JCTree.JCMethodInvocation eqtest = this.make.Apply(List.nil(), this.make.Select(this.deserGetter(func, this.syms.stringType), eqsym).setType(eqmt), List.of(this.make.Literal(lit)));
        eqtest.setType(this.syms.booleanType);
        JCTree.JCBinary compound = this.make.Binary(JCTree.Tag.AND, prev, eqtest);
        compound.operator = this.operators.resolveBinary(compound, JCTree.Tag.AND, this.syms.booleanType, this.syms.booleanType);
        compound.setType(this.syms.booleanType);
        return compound;
    }

    private JCTree.JCExpression deserGetter(String func, Type type) {
        return this.deserGetter(func, type, List.nil(), List.nil());
    }

    private JCTree.JCExpression deserGetter(String func, Type type, List<Type> argTypes, List<JCTree.JCExpression> args) {
        Type.MethodType getmt = new Type.MethodType(argTypes, type, List.nil(), this.syms.methodClass);
        Symbol getsym = this.rs.resolveQualifiedMethod(null, this.attrEnv, this.syms.serializedLambdaType, this.names.fromString(func), argTypes, List.nil());
        return this.make.Apply(List.nil(), this.make.Select(this.make.Ident(this.kInfo.deserParamSym).setType(this.syms.serializedLambdaType), getsym).setType(getmt), args).setType(type);
    }

    private Symbol.MethodSymbol makePrivateSyntheticMethod(long flags, Name name, Type type, Symbol owner) {
        return new Symbol.MethodSymbol(flags | 0x1000L | 2L, name, type, owner);
    }

    private Type.MethodType typeToMethodType(Type mt) {
        Type type = this.types.erasure(mt);
        return new Type.MethodType(type.getParameterTypes(), type.getReturnType(), type.getThrownTypes(), this.syms.methodClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCExpression makeMetafactoryIndyCall(JCTree.JCFunctionalExpression tree, Symbol.MethodHandleSymbol refSym, Symbol.MethodSymbol nonDedupedRefSym, List<JCTree.JCExpression> indy_args) {
        Name metafactoryName;
        Symbol.MethodSymbol samSym = (Symbol.MethodSymbol)this.types.findDescriptorSymbol(tree.target.tsym);
        List<PoolConstant.LoadableConstant> staticArgs = List.of(this.typeToMethodType(samSym.type), refSym.asHandle(), this.typeToMethodType(tree.getDescriptorType(this.types)));
        ListBuffer<Type> indy_args_types = new ListBuffer<Type>();
        for (JCTree.JCExpression arg : indy_args) {
            indy_args_types.append(arg.type);
        }
        Type.MethodType indyType = new Type.MethodType(indy_args_types.toList(), tree.type, List.nil(), this.syms.methodClass);
        List<Symbol> bridges = this.bridges(tree);
        boolean isSerializable = this.isSerializable(tree);
        boolean needsAltMetafactory = tree.target.isIntersection() || isSerializable || bridges.length() > 1;
        this.dumpStats(tree, needsAltMetafactory, nonDedupedRefSym);
        Name name = metafactoryName = needsAltMetafactory ? this.names.altMetafactory : this.names.metafactory;
        if (needsAltMetafactory) {
            ListBuffer<Type> markers = new ListBuffer<Type>();
            List<Type> targets = tree.target.isIntersection() ? this.types.directSupertypes(tree.target) : List.nil();
            for (Type t : targets) {
                t = this.types.erasure(t);
                if (t.tsym == this.syms.serializableType.tsym || t.tsym == tree.type.tsym || t.tsym == this.syms.objectType.tsym) continue;
                markers.append(t);
            }
            int flags = isSerializable ? 1 : 0;
            boolean hasMarkers = markers.nonEmpty();
            boolean hasBridges = bridges.nonEmpty();
            if (hasMarkers) {
                flags |= 2;
            }
            if (hasBridges) {
                flags |= 4;
            }
            staticArgs = staticArgs.append(PoolConstant.LoadableConstant.Int(flags));
            if (hasMarkers) {
                staticArgs = staticArgs.append(PoolConstant.LoadableConstant.Int(markers.length()));
                staticArgs = staticArgs.appendList(List.convert(PoolConstant.LoadableConstant.class, markers.toList()));
            }
            if (hasBridges) {
                staticArgs = staticArgs.append(PoolConstant.LoadableConstant.Int(bridges.length() - 1));
                for (Symbol s : bridges) {
                    Type s_erasure = s.erasure(this.types);
                    if (this.types.isSameType(s_erasure, samSym.erasure(this.types))) continue;
                    staticArgs = staticArgs.append((Type.MethodType)s.erasure(this.types));
                }
            }
            if (isSerializable) {
                int prevPos = this.make.pos;
                try {
                    this.make.at(this.kInfo.clazz);
                    this.addDeserializationCase(refSym, tree.type, samSym, tree, staticArgs, indyType);
                }
                finally {
                    this.make.at(prevPos);
                }
            }
        }
        return this.makeIndyCall(tree, this.syms.lambdaMetafactory, metafactoryName, staticArgs, indyType, indy_args, samSym.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCExpression makeIndyCall(JCDiagnostic.DiagnosticPosition pos, Type site, Name bsmName, List<PoolConstant.LoadableConstant> staticArgs, Type.MethodType indyType, List<JCTree.JCExpression> indyArgs, Name methName) {
        int prevPos = this.make.pos;
        try {
            this.make.at(pos);
            List<Type> bsm_staticArgs = List.of(this.syms.methodHandleLookupType, this.syms.stringType, this.syms.methodTypeType).appendList(staticArgs.map(this.types::constantType));
            Symbol.MethodSymbol bsm = this.rs.resolveInternalMethod(pos, this.attrEnv, site, bsmName, bsm_staticArgs, List.nil());
            Symbol.DynamicMethodSymbol dynSym = new Symbol.DynamicMethodSymbol(methName, this.syms.noSymbol, bsm.asHandle(), (Type)indyType, staticArgs.toArray(new PoolConstant.LoadableConstant[staticArgs.length()]));
            JCTree.JCFieldAccess qualifier = this.make.Select(this.make.QualIdent(site.tsym), bsmName);
            Symbol.DynamicMethodSymbol existing = this.kInfo.dynMethSyms.putIfAbsent(dynSym.poolKey(this.types), dynSym);
            qualifier.sym = existing != null ? existing : dynSym;
            qualifier.type = indyType.getReturnType();
            JCTree.JCMethodInvocation proxyCall = this.make.Apply(List.nil(), qualifier, indyArgs);
            proxyCall.type = indyType.getReturnType();
            JCTree.JCMethodInvocation jCMethodInvocation = proxyCall;
            return jCMethodInvocation;
        }
        finally {
            this.make.at(prevPos);
        }
    }

    List<Symbol> bridges(JCTree.JCFunctionalExpression tree) {
        Symbol.ClassSymbol csym = this.types.makeFunctionalInterfaceClass(this.attrEnv, this.names.empty, tree.target, 1536L);
        return this.types.functionalInterfaceBridges(csym);
    }

    boolean isSerializable(JCTree.JCFunctionalExpression tree) {
        if (this.forceSerializable) {
            return true;
        }
        return this.types.asSuper(tree.target, this.syms.serializableType.tsym) != null;
    }

    void dumpStats(JCTree.JCFunctionalExpression tree, boolean needsAltMetafactory, Symbol sym) {
        if (this.dumpLambdaToMethodStats) {
            if (tree instanceof JCTree.JCLambda) {
                JCTree.JCLambda lambda = (JCTree.JCLambda)tree;
                this.log.note(tree, this.diags.noteKey(lambda.wasMethodReference ? "mref.stat.1" : "lambda.stat", needsAltMetafactory, sym));
            } else if (tree instanceof JCTree.JCMemberReference) {
                this.log.note(tree, CompilerProperties.Notes.MrefStat(needsAltMetafactory, null));
            }
        }
    }

    private String typeSig(Type type) {
        return this.typeSig(type, false);
    }

    private String typeSig(Type type, boolean allowIllegalSignature) {
        try {
            L2MSignatureGenerator sg = new L2MSignatureGenerator(allowIllegalSignature);
            sg.assembleSig(type);
            return sg.toString();
        }
        catch (Types.SignatureGenerator.InvalidSignatureException ex) {
            Symbol.ClassSymbol c = this.attrEnv.enclClass.sym;
            this.log.error(CompilerProperties.Errors.CannotGenerateClass(c, CompilerProperties.Fragments.IllegalSignature(c, ex.type())));
            return "<ERRONEOUS>";
        }
    }

    private String classSig(Type type) {
        try {
            L2MSignatureGenerator sg = new L2MSignatureGenerator(false);
            sg.assembleClassSig(type);
            return sg.toString();
        }
        catch (Types.SignatureGenerator.InvalidSignatureException ex) {
            Symbol.ClassSymbol c = this.attrEnv.enclClass.sym;
            this.log.error(CompilerProperties.Errors.CannotGenerateClass(c, CompilerProperties.Fragments.IllegalSignature(c, ex.type())));
            return "<ERRONEOUS>";
        }
    }

    private class KlassInfo {
        private ListBuffer<JCTree> appendedMethodList = new ListBuffer();
        private final Map<DedupedLambda, DedupedLambda> dedupedLambdas = new HashMap<DedupedLambda, DedupedLambda>();
        private final Map<Object, Symbol.DynamicMethodSymbol> dynMethSyms = new HashMap<Object, Symbol.DynamicMethodSymbol>();
        private final Map<String, ListBuffer<JCTree.JCStatement>> deserializeCases = new HashMap<String, ListBuffer<JCTree.JCStatement>>();
        private final Symbol.MethodSymbol deserMethodSym;
        private final Symbol.VarSymbol deserParamSym;
        private final JCTree.JCClassDecl clazz;
        private final Map<String, Integer> syntheticNames = new HashMap<String, Integer>();

        private KlassInfo(JCTree.JCClassDecl clazz) {
            this.clazz = clazz;
            Type.MethodType type = new Type.MethodType(List.of(((LambdaToMethod)LambdaToMethod.this).syms.serializedLambdaType), ((LambdaToMethod)LambdaToMethod.this).syms.objectType, List.nil(), ((LambdaToMethod)LambdaToMethod.this).syms.methodClass);
            this.deserMethodSym = LambdaToMethod.this.makePrivateSyntheticMethod(8L, ((LambdaToMethod)LambdaToMethod.this).names.deserializeLambda, type, clazz.sym);
            this.deserParamSym = new Symbol.VarSymbol(16L, LambdaToMethod.this.names.fromString("lambda"), ((LambdaToMethod)LambdaToMethod.this).syms.serializedLambdaType, this.deserMethodSym);
        }

        private void addMethod(JCTree decl) {
            this.appendedMethodList = this.appendedMethodList.prepend(decl);
        }

        int syntheticNameIndex(StringBuilder buf, int start) {
            String temp = buf.toString();
            Integer count = this.syntheticNames.get(temp);
            if (count == null) {
                count = start;
            }
            this.syntheticNames.put(temp, count + 1);
            return count;
        }
    }

    class LambdaTranslationContext {
        final JCTree.JCFunctionalExpression tree;
        final Map<Symbol.VarSymbol, Symbol.VarSymbol> lambdaProxies = new HashMap<Symbol.VarSymbol, Symbol.VarSymbol>();
        final List<Symbol.VarSymbol> capturedVars;
        final Symbol.MethodSymbol translatedSym;
        final List<JCTree.JCVariableDecl> syntheticParams;

        LambdaTranslationContext(JCTree.JCLambda tree) {
            Symbol.VarSymbol trans;
            this.tree = tree;
            Symbol owner = tree.owner;
            if (owner.kind == Kinds.Kind.MTH) {
                final Symbol.MethodSymbol originalOwner = (Symbol.MethodSymbol)owner.clone(owner.owner);
                this.translatedSym = new Symbol.MethodSymbol(0L, null, null, owner.enclClass()){

                    @Override
                    public Symbol.MethodSymbol originalEnclosingMethod() {
                        return originalOwner;
                    }
                };
            } else {
                this.translatedSym = LambdaToMethod.this.makePrivateSyntheticMethod(0L, null, null, owner.enclClass());
            }
            ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer<JCTree.JCVariableDecl>();
            ListBuffer<Symbol.VarSymbol> parameterSymbols = new ListBuffer<Symbol.VarSymbol>();
            LambdaCaptureScanner captureScanner = new LambdaCaptureScanner(tree);
            this.capturedVars = captureScanner.analyzeCaptures();
            for (Symbol.VarSymbol captured : this.capturedVars) {
                trans = this.addSymbol(captured, LambdaSymbolKind.CAPTURED_VAR);
                params.append(LambdaToMethod.this.make.VarDef(trans, null));
                parameterSymbols.add(trans);
            }
            for (JCTree.JCVariableDecl param : tree.params) {
                trans = this.addSymbol(param.sym, LambdaSymbolKind.PARAM);
                params.append(LambdaToMethod.this.make.VarDef(trans, null));
                parameterSymbols.add(trans);
            }
            this.syntheticParams = params.toList();
            this.completeLambdaMethodSymbol(owner, captureScanner.capturesThis);
            this.translatedSym.params = parameterSymbols.toList();
        }

        void completeLambdaMethodSymbol(Symbol owner, boolean thisReferenced) {
            boolean inInterface = owner.enclClass().isInterface();
            Name name = LambdaToMethod.this.isSerializable(this.tree) ? this.serializedLambdaName(owner) : this.lambdaName(owner);
            Type type = LambdaToMethod.this.types.createMethodTypeWithParameters(this.generatedLambdaSig(), TreeInfo.types(this.syntheticParams));
            long flags = 0x2000000001000L | owner.flags_field & 0x800L | owner.owner.flags_field & 0x800L | 2L | (thisReferenced ? (inInterface ? 0x80000000000L : 0L) : 8L);
            this.translatedSym.type = type;
            this.translatedSym.name = name;
            this.translatedSym.flags_field = flags;
        }

        private String serializedLambdaDisambiguation(Symbol owner) {
            StringBuilder buf = new StringBuilder();
            Assert.check(owner.type != null || LambdaToMethod.this.lambdaContext != null);
            if (owner.type != null) {
                buf.append(LambdaToMethod.this.typeSig(owner.type, true));
                buf.append(":");
            }
            buf.append(((LambdaToMethod)LambdaToMethod.this).types.findDescriptorSymbol((Symbol.TypeSymbol)this.tree.type.tsym).owner.flatName());
            buf.append(" ");
            if (LambdaToMethod.this.pendingVar != null) {
                buf.append(LambdaToMethod.this.pendingVar.flatName());
                buf.append("=");
            }
            for (Symbol symbol : this.capturedVars) {
                if (symbol == owner) continue;
                buf.append(LambdaToMethod.this.typeSig(symbol.type, true));
                buf.append(" ");
                buf.append(symbol.flatName());
                buf.append(",");
            }
            return buf.toString();
        }

        private Name lambdaName(Symbol owner) {
            StringBuilder buf = new StringBuilder();
            buf.append(((LambdaToMethod)LambdaToMethod.this).names.lambda);
            buf.append(this.syntheticMethodNameComponent(owner));
            buf.append("$");
            buf.append(LambdaToMethod.this.kInfo.syntheticNameIndex(buf, 0));
            return LambdaToMethod.this.names.fromString(buf.toString());
        }

        String syntheticMethodNameComponent(Symbol owner) {
            long ownerFlags = owner.flags();
            if ((ownerFlags & 0x100000L) != 0L) {
                return (ownerFlags & 8L) != 0L ? "static" : "new";
            }
            if (owner.isConstructor()) {
                return "new";
            }
            return owner.name.toString();
        }

        private Name serializedLambdaName(Symbol owner) {
            StringBuilder buf = new StringBuilder();
            buf.append(((LambdaToMethod)LambdaToMethod.this).names.lambda);
            buf.append(this.syntheticMethodNameComponent(owner));
            buf.append('$');
            String disam = this.serializedLambdaDisambiguation(owner);
            buf.append(Integer.toHexString(disam.hashCode()));
            buf.append('$');
            buf.append(LambdaToMethod.this.kInfo.syntheticNameIndex(buf, 1));
            String result = buf.toString();
            return LambdaToMethod.this.names.fromString(result);
        }

        Symbol.VarSymbol translate(Symbol.VarSymbol sym, LambdaSymbolKind skind) {
            Symbol.VarSymbol ret;
            boolean propagateAnnos = true;
            switch (skind.ordinal()) {
                case 2: {
                    Name name = (sym.flags() & 0x2000000000000L) != 0L ? sym.baseSymbol().name : sym.name;
                    ret = new Symbol.VarSymbol(0x200001010L, name, LambdaToMethod.this.types.erasure(sym.type), this.translatedSym);
                    propagateAnnos = false;
                    break;
                }
                case 1: {
                    ret = new Symbol.VarSymbol(sym.flags() & 0x10L, sym.name, sym.type, this.translatedSym);
                    ret.pos = sym.pos;
                    if (!sym.isExceptionParameter()) break;
                    ret.setData((Object)ElementKind.EXCEPTION_PARAMETER);
                    break;
                }
                case 0: {
                    ret = new Symbol.VarSymbol(sym.flags() & 0x10L | 0x200000000L, sym.name, LambdaToMethod.this.types.erasure(sym.type), this.translatedSym);
                    ret.pos = sym.pos;
                    break;
                }
                default: {
                    Assert.error(skind.name());
                    throw new AssertionError();
                }
            }
            if (ret != sym && propagateAnnos) {
                ret.setDeclarationAttributes(sym.getRawAttributes());
                ret.setTypeAttributes(sym.getRawTypeAttributes());
            }
            return ret;
        }

        Symbol.VarSymbol addLocal(Symbol.VarSymbol sym) {
            return this.addSymbol(sym, LambdaSymbolKind.LOCAL_VAR);
        }

        private Symbol.VarSymbol addSymbol(Symbol.VarSymbol sym, LambdaSymbolKind skind) {
            return this.lambdaProxies.computeIfAbsent(sym, s -> this.translate((Symbol.VarSymbol)s, skind));
        }

        JCTree translate(JCTree.JCIdent lambdaIdent) {
            Symbol tSym = this.lambdaProxies.get(lambdaIdent.sym);
            return tSym != null ? LambdaToMethod.this.make.Ident(tSym).setType(lambdaIdent.type) : null;
        }

        Type generatedLambdaSig() {
            return LambdaToMethod.this.types.erasure(this.tree.getDescriptorType(LambdaToMethod.this.types));
        }

        class LambdaCaptureScanner
        extends CaptureScanner {
            boolean capturesThis;
            Set<Symbol.ClassSymbol> seenClasses;

            LambdaCaptureScanner(JCTree.JCLambda ownerTree) {
                super(ownerTree);
                this.seenClasses = new HashSet<Symbol.ClassSymbol>();
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
                this.seenClasses.add(tree.sym);
                super.visitClassDef(tree);
            }

            @Override
            public void visitIdent(JCTree.JCIdent tree) {
                if (!(tree.sym.isStatic() || tree.sym.owner.kind != Kinds.Kind.TYP || tree.sym.kind != Kinds.Kind.VAR && tree.sym.kind != Kinds.Kind.MTH || this.seenClasses.contains(tree.sym.owner))) {
                    if ((tree.sym.flags() & 0x2000000000000L) != 0L) {
                        this.addFreeVar((Symbol.VarSymbol)tree.sym);
                    } else {
                        this.capturesThis = true;
                    }
                } else {
                    super.visitIdent(tree);
                }
            }

            @Override
            public void visitSelect(JCTree.JCFieldAccess tree) {
                if (!(tree.sym.kind != Kinds.Kind.VAR || tree.sym.name != ((LambdaToMethod)LambdaToMethod.this).names._this && tree.sym.name != ((LambdaToMethod)LambdaToMethod.this).names._super || this.seenClasses.contains(tree.sym.type.tsym))) {
                    this.capturesThis = true;
                }
                super.visitSelect(tree);
            }

            @Override
            public void visitAnnotation(JCTree.JCAnnotation tree) {
            }
        }

        static enum LambdaSymbolKind {
            PARAM,
            LOCAL_VAR,
            CAPTURED_VAR;

        }
    }

    class DedupedLambda {
        private final Symbol.MethodSymbol symbol;
        private final JCTree tree;
        private int hashCode;

        DedupedLambda(Symbol.MethodSymbol symbol, JCTree tree) {
            this.symbol = symbol;
            this.tree = tree;
        }

        public int hashCode() {
            int hashCode = this.hashCode;
            if (hashCode == 0) {
                this.hashCode = hashCode = TreeHasher.hash(LambdaToMethod.this.types, this.tree, this.symbol.params());
            }
            return hashCode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof DedupedLambda)) return false;
            DedupedLambda dedupedLambda = (DedupedLambda)o;
            if (!LambdaToMethod.this.types.isSameType((Type)this.symbol.asType(), (Type)dedupedLambda.symbol.asType())) return false;
            if (!new TreeDiffer(LambdaToMethod.this.types, this.symbol.params(), dedupedLambda.symbol.params()).scan(this.tree, dedupedLambda.tree)) return false;
            return true;
        }
    }

    private class L2MSignatureGenerator
    extends Types.SignatureGenerator {
        StringBuilder sb = new StringBuilder();
        boolean allowIllegalSignatures;

        L2MSignatureGenerator(boolean allowIllegalSignatures) {
            this.allowIllegalSignatures = allowIllegalSignatures;
        }

        @Override
        protected void reportIllegalSignature(Type t) {
            if (!this.allowIllegalSignatures) {
                super.reportIllegalSignature(t);
            }
        }

        @Override
        protected void append(char ch) {
            this.sb.append(ch);
        }

        @Override
        protected void append(byte[] ba) {
            Name name;
            try {
                name = LambdaToMethod.this.names.fromUtf(ba);
            }
            catch (InvalidUtfException e) {
                throw new AssertionError((Object)e);
            }
            this.sb.append(name.toString());
        }

        @Override
        protected void append(Name name) {
            this.sb.append(name.toString());
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

