/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard.fromdb;

import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.persistence.api.PersistenceLocation;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DatabaseTablesPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.EntityClassesPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGeneratorProvider;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ProgressPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPWizard;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.EntityResourcesGenerator;
import org.netbeans.modules.websvc.rest.codegen.EntityResourcesGeneratorFactory;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBeanModel;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceModelBuilder;
import org.netbeans.modules.websvc.rest.spi.MiscUtilities;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.PersistenceHelper;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.rest.wizard.EntityResourcesIterator;
import org.netbeans.modules.websvc.rest.wizard.EntityResourcesSetupPanel;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public final class DatabaseResourceWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel<?>[] panels;
    private static final String PROP_CMP = "wizard-is-cmp";
    public static final String PROP_HELPER = "wizard-helper";
    private static final Lookup.Result<PersistenceGeneratorProvider> PERSISTENCE_PROVIDERS = Lookup.getDefault().lookupResult(PersistenceGeneratorProvider.class);
    private RelatedCMPHelper helper;
    private ProgressPanel progressPanel;
    private PersistenceGenerator generator;

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        Project project = Templates.getProject((WizardDescriptor)wizard);
        this.generator = DatabaseResourceWizardIterator.createPersistenceGenerator("jpa");
        FileObject configFilesFolder = PersistenceLocation.getLocation((Project)project);
        this.helper = new RelatedCMPHelper(project, configFilesFolder, this.generator);
        wizard.putProperty(PROP_HELPER, (Object)this.helper);
        wizard.putProperty(PROP_CMP, (Object)false);
        this.generator.init(wizard);
        SourceGroup[] sourceGroups = SourceGroupSupport.getJavaSourceGroups(project);
        if (Templates.getTargetFolder((WizardDescriptor)wizard) == null && sourceGroups.length > 0) {
            Templates.setTargetFolder((WizardDescriptor)wizard, (FileObject)sourceGroups[0].getRootFolder());
        }
    }

    public Set<?> instantiate() throws IOException {
        if (this.helper.isCreatePU()) {
            Project project = Templates.getProject((WizardDescriptor)this.wizard);
            if (RestUtils.hasSpringSupport(project)) {
                org.netbeans.modules.j2ee.persistence.wizard.Util.addPersistenceUnitToProject((Project)project, (PersistenceUnit)org.netbeans.modules.j2ee.persistence.wizard.Util.buildPersistenceUnitUsingData((Project)project, null, (String)this.helper.getTableSource().getName(), null, null, (String)"1.0"));
            } else {
                org.netbeans.modules.j2ee.persistence.wizard.Util.addPersistenceUnitToProject((Project)project, (PersistenceUnit)org.netbeans.modules.j2ee.persistence.wizard.Util.buildPersistenceUnitUsingData((Project)project, null, (String)this.helper.getTableSource().getName(), null, null));
            }
        }
        final String title = NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_EntityClassesGeneration");
        final ProgressContributor progressContributor = AggregateProgressFactory.createProgressContributor((String)title);
        final AggregateProgressHandle aggregateHandle = AggregateProgressFactory.createHandle((String)title, (ProgressContributor[])new ProgressContributor[]{progressContributor}, null, null);
        this.progressPanel = new ProgressPanel();
        final JComponent progressComponent = AggregateProgressFactory.createProgressComponent((AggregateProgressHandle)aggregateHandle);
        final Runnable r = new Runnable(){
            final /* synthetic */ DatabaseResourceWizardIterator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    aggregateHandle.start();
                    this.this$0.generate(progressContributor);
                }
                catch (IOException ioe) {
                    Logger.getLogger("global").log(Level.INFO, null, ioe);
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ioe.getLocalizedMessage(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
                finally {
                    this.this$0.generator.uninit();
                    aggregateHandle.finish();
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){
            private boolean first = true;
            final /* synthetic */ DatabaseResourceWizardIterator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (!this.first) {
                    RequestProcessor.getDefault().post(r);
                    this.this$0.progressPanel.open(progressComponent, title);
                } else {
                    this.first = false;
                    SwingUtilities.invokeLater(this);
                }
            }
        });
        Object[] params = new Object[5];
        params[0] = "JAX-RS";
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        params[1] = project.getClass().getName();
        J2eeModule j2eeModule = RestUtils.getJ2eeModule(project);
        params[2] = j2eeModule == null ? null : j2eeModule.getModuleVersion() + "(WAR)";
        params[3] = "REST FROM DATABASE";
        LogUtils.logWsWizard((Object[])params);
        return Collections.singleton(DataFolder.findFolder((FileObject)DatabaseResourceWizardIterator.getFolderForPackage(this.helper.getLocation(), this.helper.getPackageName())));
    }

    private static PersistenceGenerator createPersistenceGenerator(String type) {
        assert (type != null);
        Collection providers = PERSISTENCE_PROVIDERS.allInstances();
        for (PersistenceGeneratorProvider provider : providers) {
            if (!type.equals(provider.getGeneratorType())) continue;
            return provider.createGenerator();
        }
        throw new AssertionError((Object)("Could not find a persistence generator of type " + type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void generate(ProgressContributor handle) throws IOException {
        block27: {
            final Project project = Templates.getProject((WizardDescriptor)this.wizard);
            try {
                FileObject restAppPack;
                handle.start(1);
                handle.progress(NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_SavingSchema"));
                this.progressPanel.setText(NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_SavingSchema"));
                FileObject dbschemaFile = this.helper.getDBSchemaFile();
                String extracting = NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_ExtractingEntityClassesAndRelationships");
                handle.progress(extracting);
                this.progressPanel.setText(extracting);
                this.helper.buildBeans();
                this.generator.generateBeans(this.progressPanel, this.helper, dbschemaFile, handle);
                Set<FileObject> files = this.getAffectedFiles(this.generator, this.helper);
                RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
                String restAppPackage = (String)this.wizard.getProperty("restApplicationConfigPackage");
                String restAppClass = (String)this.wizard.getProperty("restApplicatoin");
                handle.progress(NbBundle.getMessage(EntityResourcesIterator.class, (String)"MSG_EnableRestSupport"));
                boolean useJersey = Boolean.TRUE.equals(this.wizard.getProperty("useJersey"));
                if (!useJersey) {
                    RestSupport.RestConfig.IDE.setAppClassName(restAppPackage + "." + restAppClass);
                }
                if (restSupport != null) {
                    restSupport.ensureRestDevelopmentReady(useJersey ? RestSupport.RestConfig.DD : RestSupport.RestConfig.IDE);
                }
                final Set<String> entities = Util.getEntities(project, files);
                if (!RestUtils.hasSpringSupport(project) && MiscUtilities.isJavaEE6AndHigher((Project)project)) {
                    FileObject restAppPack2;
                    SourceGroup[] sourceGroups;
                    String targetPackage = null;
                    String resourcePackage = null;
                    Object controllerPackage = null;
                    FileObject targetResourceFolder = null;
                    SourceGroup targetSourceGroup = null;
                    FileObject targetFolder = (FileObject)this.wizard.getProperty("targetSourceRoot");
                    if (targetFolder != null) {
                        targetPackage = SourceGroupSupport.packageForFolder(targetFolder);
                        resourcePackage = (String)this.wizard.getProperty("resourcePackage");
                        sourceGroups = SourceGroupSupport.getJavaSourceGroups(project);
                        targetSourceGroup = SourceGroupSupport.findSourceGroupForFile(sourceGroups, targetFolder);
                        if (targetSourceGroup != null) {
                            targetResourceFolder = SourceGroupSupport.getFolderForPackage(targetSourceGroup, resourcePackage, true);
                        }
                    } else {
                        targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizard);
                        targetPackage = "";
                        if (targetFolder != null && (targetSourceGroup = SourceGroupSupport.findSourceGroupForFile(sourceGroups = SourceGroupSupport.getJavaSourceGroups(project), targetFolder)) != null) {
                            targetPackage = SourceGroupSupport.getPackageForFolder(targetSourceGroup, targetFolder);
                        }
                        targetPackage = targetPackage.length() == 0 ? "" : targetPackage + ".";
                        resourcePackage = targetPackage + "service";
                        if (targetSourceGroup != null) {
                            targetResourceFolder = SourceGroupSupport.getFolderForPackage(targetSourceGroup, resourcePackage, true);
                        }
                    }
                    FileObject fileObject = restAppPack2 = restAppPackage == null ? null : SourceGroupSupport.getFolderForPackage(targetSourceGroup, restAppPackage, true);
                    if (restAppPack2 != null && restAppClass != null && !useJersey) {
                        RestUtils.createApplicationConfigClass(restSupport, restAppPack2, restAppClass);
                    }
                    if (targetResourceFolder == null) {
                        targetResourceFolder = targetFolder;
                    }
                    assert (!files.isEmpty());
                    final EntityResourceBeanModel[] model = new EntityResourceBeanModel[1];
                    JavaSource.forFileObject((FileObject)files.iterator().next()).runWhenScanFinished((Task)new Task<CompilationController>(){
                        final /* synthetic */ DatabaseResourceWizardIterator this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void run(CompilationController controller) throws Exception {
                            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            EntityResourceModelBuilder builder = new EntityResourceModelBuilder(project, entities);
                            model[0] = builder.build();
                        }
                    }, true).get();
                    Util.generateRESTFacades(project, entities, model[0], targetResourceFolder, resourcePackage);
                    restSupport.configure(new String[]{resourcePackage});
                    break block27;
                }
                assert (!files.isEmpty());
                final EntityResourceBeanModel[] model = new EntityResourceBeanModel[1];
                JavaSource.forFileObject((FileObject)files.iterator().next()).runWhenScanFinished((Task)new Task<CompilationController>(){
                    final /* synthetic */ DatabaseResourceWizardIterator this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run(CompilationController controller) throws Exception {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        EntityResourceModelBuilder builder = new EntityResourceModelBuilder(project, entities);
                        model[0] = builder.build();
                    }
                }, true).get();
                PersistenceHelper.PersistenceUnit pu = new PersistenceHelper(project).getPersistenceUnit();
                FileObject targetFolder = (FileObject)this.wizard.getProperty("targetSourceRoot");
                String targetPackage = null;
                String resourcePackage = null;
                String controllerPackage = null;
                if (targetFolder != null) {
                    targetPackage = SourceGroupSupport.packageForFolder(targetFolder);
                    resourcePackage = (String)this.wizard.getProperty("resourcePackage");
                    controllerPackage = (String)this.wizard.getProperty("controllerPackage");
                } else {
                    SourceGroup[] sourceGroups;
                    targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizard);
                    SourceGroup targetSourceGroup = null;
                    targetPackage = "";
                    if (targetFolder != null && (targetSourceGroup = SourceGroupSupport.findSourceGroupForFile(sourceGroups = SourceGroupSupport.getJavaSourceGroups(project), targetFolder)) != null) {
                        targetPackage = SourceGroupSupport.getPackageForFolder(targetSourceGroup, targetFolder);
                    }
                    targetPackage = targetPackage.length() == 0 ? "" : targetPackage + ".";
                    resourcePackage = targetPackage + "service";
                    controllerPackage = targetPackage + "controller";
                }
                FileObject fileObject = restAppPack = restAppPackage == null ? null : FileUtil.createFolder((FileObject)targetFolder, (String)restAppPackage.replace('.', '/'));
                if (restAppPack != null && restAppClass != null) {
                    GenerationUtils.createClass((FileObject)restAppPack, (String)restAppClass, null);
                }
                EntityResourcesGenerator gen = EntityResourcesGeneratorFactory.newInstance(project);
                gen.initialize(model[0], project, targetFolder, targetPackage, resourcePackage, controllerPackage, pu);
                try {
                    RestUtils.disableRestServicesChangeListner(project);
                    gen.generate(null);
                    restSupport.configure(new String[]{resourcePackage});
                }
                catch (Exception iox) {
                    Exceptions.printStackTrace((Throwable)iox);
                }
                finally {
                    RestUtils.enableRestServicesChangeListner(project);
                }
            }
            catch (InterruptedException e) {
                Logger.getLogger(DatabaseResourceWizardIterator.class.getCanonicalName()).log(Level.INFO, null, e);
                handle.finish();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DatabaseResourceWizardIterator.this.progressPanel.close();
                    }
                });
            }
            catch (ExecutionException e2) {
                Logger.getLogger(DatabaseResourceWizardIterator.class.getCanonicalName()).log(Level.INFO, null, e2);
                {
                    catch (Throwable throwable) {
                        handle.finish();
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                handle.finish();
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
        handle.finish();
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private Set<FileObject> getAffectedFiles(PersistenceGenerator generator, RelatedCMPHelper helper) {
        Set created = generator.createdObjects();
        TableClosure closure = helper.getTableClosure();
        Set tables = closure.getSelectedTables();
        HashSet<FileObject> extension = new HashSet<FileObject>();
        for (Table table : tables) {
            Table.DisabledReason reason;
            if (!table.isDisabled() || !((reason = table.getDisabledReason()) instanceof Table.ExistingDisabledReason)) continue;
            String fqnClass = ((Table.ExistingDisabledReason)reason).getFQClassName();
            try {
                FileObject fileObject = SourceGroupSupport.getFileObjectFromClassName(fqnClass, helper.getProject());
                if (created.contains(fileObject)) continue;
                extension.add(fileObject);
            }
            catch (IOException e) {
                Logger.getLogger("global").log(Level.SEVERE, null, e);
            }
        }
        if (extension.size() == 0) {
            return created;
        }
        extension.addAll(created);
        return extension;
    }

    private WizardDescriptor.Panel<?>[] getPanels() {
        if (this.panels == null) {
            String wizardBundleKey = "Templates/WebServices/RestServicesFromDatabase";
            String wizardTitle = NbBundle.getMessage(EntityResourcesIterator.class, (String)wizardBundleKey);
            Project project = Templates.getProject((WizardDescriptor)this.wizard);
            boolean withoutController = MiscUtilities.isJavaEE6AndHigher((Project)project) || RestUtils.hasSpringSupport(project);
            this.panels = new WizardDescriptor.Panel[]{new DatabaseTablesPanel.WizardPanel(wizardTitle), new EntityClassesPanel.WizardPanel(true, true, false), new EntityResourcesSetupPanel(NbBundle.getMessage(EntityResourcesIterator.class, (String)"LBL_RestResourcesAndClasses"), this.wizard, withoutController)};
            String[] steps = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                if (steps[i] == null) {
                    steps[i] = c.getName();
                }
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private String[] createSteps() {
        String[] res;
        String[] beforeSteps = null;
        Object prop = this.wizard.getProperty("WizardPanel_contentData");
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        int start = 0;
        if (beforeSteps == null || beforeSteps.length == 0) {
            res = new String[this.panels.length];
        } else {
            res = new String[this.panels.length + 1];
            res[0] = beforeSteps[0];
            start = 1;
        }
        for (int i = start; i < res.length; ++i) {
            res[i] = this.panels[i - start].getComponent().getName();
        }
        return res;
    }

    public static FileObject getFolderForPackage(SourceGroup sourceGroup, String packageName) throws IOException {
        Parameters.notNull((CharSequence)"sourceGroup", (Object)sourceGroup);
        Parameters.notNull((CharSequence)"packageName", (Object)packageName);
        String relativePkgName = packageName.replace('.', '/');
        FileObject folder = sourceGroup.getRootFolder().getFileObject(relativePkgName);
        if (folder != null) {
            return folder;
        }
        return FileUtil.createFolder((FileObject)sourceGroup.getRootFolder(), (String)relativePkgName);
    }
}

