/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.common.PortComponentRef;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProvider;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarWebServicesSupport;
import org.netbeans.modules.websvc.api.client.ClientStubDescriptor;
import org.netbeans.modules.websvc.api.client.WebServicesClientConstants;
import org.netbeans.modules.websvc.api.client.WsCompileClientEditorSupport;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportImpl;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EjbJarWebServicesClientSupport
implements WebServicesClientSupportImpl {
    private EjbJarProject project;
    private AntProjectHelper helper;
    private ReferenceHelper referenceHelper;
    private static final String[] WSCOMPILE_CLIENT_FEATURES = new String[]{"datahandleronly", "explicitcontext", "jaxbenumtype", "nodatabinding", "noencodedtypes", "nomultirefs", "norpcstructures", "novalidation", "resolveidref", "searchschema", "serializeinterfaces", "strict", "wsi", "unwrap", "donotoverride", "donotunwrap"};
    private static final List<String> allClientFeatures = Arrays.asList(WSCOMPILE_CLIENT_FEATURES);
    private static final String[] WSCOMPILE_KEY_CLIENT_FEATURES = new String[]{"wsi", "strict", "unwrap", "donotunwrap", "donotoverride", "datahandleronly", "nodatabinding", "norpcstructures", "novalidation", "searchschema"};
    private static final List<String> importantClientFeatures = Arrays.asList(WSCOMPILE_KEY_CLIENT_FEATURES);
    private static final JAXRPCClientStubDescriptor jsr109ClientStub = new JAXRPCClientStubDescriptor("jsr-109_client", NbBundle.getMessage(EjbJarWebServicesSupport.class, (String)"LBL_JSR109ClientStub"), new String[]{"wsi", "strict"});
    private static final JAXRPCClientStubDescriptor jaxrpcClientStub = new JAXRPCClientStubDescriptor("jaxrpc_static_client", NbBundle.getMessage(EjbJarWebServicesSupport.class, (String)"LBL_JAXRPCStaticClientStub"), new String[]{"wsi", "strict"});

    public EjbJarWebServicesClientSupport(EjbJarProject project, AntProjectHelper helper, ReferenceHelper referenceHelper) {
        this.project = project;
        this.helper = helper;
        this.referenceHelper = referenceHelper;
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public ReferenceHelper getReferenceHelper() {
        return this.referenceHelper;
    }

    private boolean updateWsCompileProperties(String serviceName) {
        boolean globalPropertiesChanged = false;
        EditableProperties globalProperties = PropertyUtils.getGlobalProperties();
        if (globalProperties.getProperty("wscompile.tools.classpath") == null) {
            globalProperties.setProperty("wscompile.tools.classpath", "${java.home}\\..\\lib\\tools.jar");
            try {
                PropertyUtils.putGlobalProperties((EditableProperties)globalProperties);
            }
            catch (IOException ex) {
                String mes = "Error saving global properties when adding wscompile.tools.classpath for service '" + serviceName + "'\r\n" + ex.getMessage();
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
            globalPropertiesChanged = true;
        }
        boolean projectPropertiesChanged = false;
        EditableProperties projectProperties = this.helper.getProperties("nbproject/project.properties");
        HashSet<String> wscJars = new HashSet<String>();
        boolean newWscJars = false;
        String wscClientClasspath = projectProperties.getProperty("wscompile.classpath");
        if (wscClientClasspath != null) {
            String[] libs = PropertyUtils.tokenizePath((String)wscClientClasspath);
            for (int i = 0; i < libs.length; ++i) {
                wscJars.add(libs[i]);
            }
        }
        for (int i = 0; i < WebServicesClientConstants.WSCOMPILE_JARS.length; ++i) {
            if (wscJars.contains(WebServicesClientConstants.WSCOMPILE_JARS[i])) continue;
            wscJars.add(WebServicesClientConstants.WSCOMPILE_JARS[i]);
            newWscJars = true;
        }
        if (newWscJars) {
            StringBuffer newClasspathBuf = new StringBuffer(256);
            Iterator iter = wscJars.iterator();
            while (iter.hasNext()) {
                newClasspathBuf.append(((String)iter.next()).toString());
                if (!iter.hasNext()) continue;
                newClasspathBuf.append(":");
            }
            projectProperties.put("wscompile.classpath", newClasspathBuf.toString());
            projectPropertiesChanged = true;
        }
        if (projectProperties.getProperty("wscompile.tools.classpath") == null) {
            projectProperties.setProperty("wscompile.tools.classpath", "${java.home}\\..\\lib\\tools.jar");
            projectPropertiesChanged = true;
        }
        if (projectPropertiesChanged) {
            this.helper.putProperties("nbproject/project.properties", projectProperties);
        }
        return globalPropertiesChanged || projectPropertiesChanged;
    }

    private EjbJar getEjbJar() {
        try {
            return DDProvider.getDefault().getDDRoot(org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJars((Project)this.project)[0].getDeploymentDescriptor());
        }
        catch (IOException e) {
            Logger.getLogger("global").log(Level.INFO, e.getLocalizedMessage());
            return null;
        }
    }

    public FileObject getMetaInf() {
        EjbJarProvider provider = (EjbJarProvider)this.project.getLookup().lookup(EjbJarProvider.class);
        return provider.getMetaInf();
    }

    public FileObject getDeploymentDescriptor() {
        FileObject metaInfFo = this.getMetaInf();
        if (metaInfFo == null) {
            return null;
        }
        return metaInfFo.getFileObject("ejb-jar.xml");
    }

    private String getPackageName(FileObject file) {
        FileObject parent = file.getParent();
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        String packageName = null;
        for (int i = 0; i < groups.length && packageName == null; ++i) {
            packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)parent);
            if (packageName == null) continue;
            packageName = groups[i].getName() + "/" + packageName;
        }
        return packageName + "";
    }

    private FileObject getFileObject(String propname) {
        String prop = this.helper.getStandardPropertyEvaluator().getProperty(propname);
        if (prop != null) {
            return this.helper.resolveFileObject(prop);
        }
        return null;
    }

    public void addServiceClient(String serviceName, String packageName, String sourceUrl, FileObject configFile, ClientStubDescriptor stubDescriptor) {
        this.addServiceClient(serviceName, packageName, sourceUrl, configFile, stubDescriptor, null);
    }

    public void addServiceClient(final String serviceName, final String packageName, final String sourceUrl, FileObject configFile, final ClientStubDescriptor stubDescriptor, final String[] wscompileFeatures) {
        boolean needToSave = (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){
            final /* synthetic */ EjbJarWebServicesClientSupport this$0;
            {
                this.this$0 = this$0;
            }

            public Boolean run() {
                String packagePropertyName;
                String oldPackageName;
                String oldFeatures;
                boolean needsSave = false;
                boolean modifiedProjectProperties = false;
                Element data = this.this$0.helper.getPrimaryConfigurationData(true);
                Document doc = data.getOwnerDocument();
                NodeList nodes = data.getElementsByTagName("web-service-clients");
                Element clientElements = null;
                if (nodes.getLength() == 0) {
                    clientElements = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "web-service-clients");
                    NodeList srcRoots = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "source-roots");
                    assert (srcRoots.getLength() == 1) : "Invalid project.xml.";
                    data.insertBefore(clientElements, srcRoots.item(0));
                } else {
                    clientElements = (Element)nodes.item(0);
                }
                boolean serviceAlreadyAdded = false;
                NodeList clientNameList = clientElements.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "web-service-client-name");
                for (int i = 0; i < clientNameList.getLength(); ++i) {
                    Node n;
                    Element clientNameElement = (Element)clientNameList.item(i);
                    NodeList nl = clientNameElement.getChildNodes();
                    if (nl.getLength() < 1 || (n = nl.item(0)).getNodeType() != 3 || !serviceName.equalsIgnoreCase(n.getNodeValue())) continue;
                    serviceAlreadyAdded = true;
                }
                if (!serviceAlreadyAdded) {
                    Element clientElement = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "web-service-client");
                    clientElements.appendChild(clientElement);
                    Element clientElementName = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "web-service-client-name");
                    clientElement.appendChild(clientElementName);
                    clientElementName.appendChild(doc.createTextNode(serviceName));
                    Element clientElementStubType = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "web-service-stub-type");
                    clientElement.appendChild(clientElementStubType);
                    clientElementStubType.appendChild(doc.createTextNode(stubDescriptor.getName()));
                    Element clientElementSourceUrl = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "client-source-url");
                    clientElement.appendChild(clientElementSourceUrl);
                    clientElementSourceUrl.appendChild(doc.createTextNode(sourceUrl));
                    this.this$0.helper.putPrimaryConfigurationData(data, true);
                    needsSave = true;
                }
                EditableProperties projectProperties = this.this$0.helper.getProperties("nbproject/project.properties");
                String featurePropertyName = "wscompile.client." + serviceName + ".features";
                String defaultFeatures = "wsi, strict";
                if (stubDescriptor instanceof JAXRPCClientStubDescriptor) {
                    JAXRPCClientStubDescriptor stubDesc = (JAXRPCClientStubDescriptor)stubDescriptor;
                    if (wscompileFeatures != null) {
                        stubDesc.setDefaultFeatures(wscompileFeatures);
                    }
                    defaultFeatures = stubDesc.getDefaultFeaturesAsArgument();
                }
                if (!defaultFeatures.equals(oldFeatures = projectProperties.getProperty(featurePropertyName))) {
                    projectProperties.put(featurePropertyName, defaultFeatures);
                    modifiedProjectProperties = true;
                }
                if (!packageName.equals(oldPackageName = projectProperties.getProperty(packagePropertyName = "wscompile.client." + serviceName + ".package"))) {
                    projectProperties.put(packagePropertyName, packageName);
                    modifiedProjectProperties = true;
                }
                if (modifiedProjectProperties) {
                    this.this$0.helper.putProperties("nbproject/project.properties", projectProperties);
                    needsSave = true;
                }
                if (this.this$0.updateWsCompileProperties(serviceName)) {
                    needsSave = true;
                }
                return needsSave;
            }
        });
        if (needToSave) {
            try {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
            catch (IOException ex) {
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EjbJarWebServicesSupport.class, (String)"MSG_ErrorSavingOnWSClientAdd", (Object)serviceName, (Object)ex.getMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
        }
    }

    public FileObject[] getJavaSources() {
        return this.project.getSourceRoots().getRoots();
    }

    public void addServiceClientReference(String serviceName, String fqServiceName, String relativeWsdlPath, String relativeMappingPath, String[] portSEIInfo) {
        FileObject ddFO = this.getDeploymentDescriptor();
        if (ddFO != null) {
            try {
                EjbJar rootDD = DDProvider.getDefault().getDDRoot(org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJars((Project)this.project)[0].getDeploymentDescriptor());
                ServiceRef serviceRef = (ServiceRef)rootDD.findBeanByName("ServiceRef", "ServiceRefName", serviceName);
                if (serviceRef == null) {
                    serviceRef = (ServiceRef)rootDD.addBean("ServiceRef", new String[]{"ServiceRefName", "ServiceInterface", "WsdlFile", "JaxrpcMappingFile"}, (Object[])new String[]{serviceName, fqServiceName, relativeWsdlPath, relativeMappingPath}, "ServiceRefName");
                } else {
                    serviceRef.setServiceInterface(fqServiceName);
                    serviceRef.setWsdlFile(new URI(relativeWsdlPath));
                    serviceRef.setJaxrpcMappingFile(relativeMappingPath);
                }
                PortComponentRef[] portRefArray = new PortComponentRef[portSEIInfo.length];
                for (int pi = 0; pi < portRefArray.length; ++pi) {
                    portRefArray[pi] = (PortComponentRef)serviceRef.createBean("PortComponentRef");
                    portRefArray[pi].setServiceEndpointInterface(portSEIInfo[pi]);
                }
                serviceRef.setPortComponentRef(portRefArray);
                rootDD.write(ddFO);
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.INFO, null, ex);
            }
            catch (NameAlreadyUsedException ex) {
                Logger.getLogger("global").log(Level.INFO, null, ex);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger("global").log(Level.INFO, null, ex);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger("global").log(Level.INFO, null, ex);
            }
        }
    }

    public void removeServiceClient(final String serviceName) {
        boolean needToSave = (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){
            final /* synthetic */ EjbJarWebServicesClientSupport this$0;
            {
                this.this$0 = this$0;
            }

            public Boolean run() {
                boolean needsSave = false;
                String featureProperty = "wscompile.client." + serviceName + ".features";
                String packageProperty = "wscompile.client." + serviceName + ".package";
                EditableProperties ep = this.this$0.helper.getProperties("nbproject/project.properties");
                if (ep.getProperty(featureProperty) != null) {
                    ep.remove((Object)featureProperty);
                    needsSave = true;
                }
                if (ep.getProperty(packageProperty) != null) {
                    ep.remove((Object)packageProperty);
                    needsSave = true;
                }
                if (needsSave) {
                    this.this$0.helper.putProperties("nbproject/project.properties", ep);
                }
                Element data = this.this$0.helper.getPrimaryConfigurationData(true);
                NodeList nodes = data.getElementsByTagName("web-service-clients");
                Element clientElements = null;
                if (nodes.getLength() >= 1) {
                    clientElements = (Element)nodes.item(0);
                    NodeList clientNameList = clientElements.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "web-service-client-name");
                    for (int i = 0; i < clientNameList.getLength(); ++i) {
                        Node n;
                        Element clientNameElement = (Element)clientNameList.item(i);
                        NodeList nl = clientNameElement.getChildNodes();
                        if (nl.getLength() != 1 || (n = nl.item(0)).getNodeType() != 3 || !serviceName.equalsIgnoreCase(n.getNodeValue())) continue;
                        Node serviceNode = clientNameElement.getParentNode();
                        clientElements.removeChild(serviceNode);
                        this.this$0.helper.putPrimaryConfigurationData(data, true);
                        needsSave = true;
                    }
                }
                return needsSave;
            }
        });
        if (needToSave) {
            try {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
            catch (IOException ex) {
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EjbJarWebServicesSupport.class, (String)"MSG_ErrorSavingOnWSClientRemove", (Object)serviceName, (Object)ex.getMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
        }
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        FileObject wsdlFolder = null;
        FileObject metaInf = this.getMetaInf();
        if (metaInf != null) {
            wsdlFolder = metaInf.getFileObject("wsdl");
            if (wsdlFolder == null && create) {
                wsdlFolder = metaInf.createFolder("wsdl");
            }
        } else if (create) {
            Logger.getLogger("global").log(Level.INFO, NbBundle.getMessage(EjbJarWebServicesSupport.class, (String)"MSG_MetaInfNotFoundForWsdlFolder"));
        }
        return wsdlFolder;
    }

    public List<ClientStubDescriptor> getStubDescriptors() {
        ArrayList<ClientStubDescriptor> stubs = new ArrayList<ClientStubDescriptor>(2);
        stubs.add(jaxrpcClientStub);
        return stubs;
    }

    public List<WsCompileClientEditorSupport.ServiceSettings> getServiceClients() {
        ArrayList<WsCompileClientEditorSupport.ServiceSettings> serviceNames = new ArrayList<WsCompileClientEditorSupport.ServiceSettings>();
        Element data = this.helper.getPrimaryConfigurationData(true);
        NodeList nodes = data.getElementsByTagName("web-service-clients");
        EditableProperties projectProperties = this.helper.getProperties("nbproject/project.properties");
        if (nodes.getLength() != 0) {
            Element clientElements = (Element)nodes.item(0);
            NodeList clientNameList = clientElements.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "web-service-client-name");
            for (int i = 0; i < clientNameList.getLength(); ++i) {
                Node n;
                Element clientNameElement = (Element)clientNameList.item(i);
                NodeList nl = clientNameElement.getChildNodes();
                if (nl.getLength() != 1 || (n = nl.item(0)).getNodeType() != 3) continue;
                String serviceName = n.getNodeValue();
                String currentFeatures = projectProperties.getProperty("wscompile.client." + serviceName + ".features");
                if (currentFeatures == null) {
                    currentFeatures = "wsi, strict";
                }
                ClientStubDescriptor stubType = this.getClientStubDescriptor(clientNameElement.getParentNode());
                boolean propVerbose = "true".equalsIgnoreCase(projectProperties.getProperty("wscompile.client." + serviceName + ".verbose"));
                boolean propDebug = "true".equalsIgnoreCase(projectProperties.getProperty("wscompile.client." + serviceName + ".debug"));
                boolean propPrintStackTrace = "true".equalsIgnoreCase(projectProperties.getProperty("wscompile.client." + serviceName + ".xPrintStackTrace"));
                boolean propExtensible = "true".equalsIgnoreCase(projectProperties.getProperty("wscompile.client." + serviceName + ".xSerializable"));
                boolean propOptimize = "true".equalsIgnoreCase(projectProperties.getProperty("wscompile.client." + serviceName + ".optimize"));
                boolean[] options = new boolean[]{propVerbose, propDebug, propPrintStackTrace, propExtensible, propOptimize};
                WsCompileClientEditorSupport.ServiceSettings settings = new WsCompileClientEditorSupport.ServiceSettings(serviceName, stubType, options, currentFeatures, allClientFeatures, importantClientFeatures);
                serviceNames.add(settings);
            }
        }
        return serviceNames;
    }

    private ClientStubDescriptor getClientStubDescriptor(Node parentNode) {
        Node n;
        Element clientStubElement;
        NodeList nl;
        Element parentElement;
        NodeList clientNameList;
        JAXRPCClientStubDescriptor result = null;
        if (parentNode instanceof Element && (clientNameList = (parentElement = (Element)parentNode).getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "web-service-stub-type")).getLength() == 1 && (nl = (clientStubElement = (Element)clientNameList.item(0)).getChildNodes()).getLength() == 1 && (n = nl.item(0)).getNodeType() == 3) {
            String stubName = n.getNodeValue();
            if ("jsr-109_client".equals(stubName)) {
                result = jsr109ClientStub;
            } else if ("jaxrpc_static_client".equals(stubName)) {
                result = jaxrpcClientStub;
            }
        }
        return result;
    }

    public String getWsdlSource(String serviceName) {
        Node n;
        Element fromWsdlElement;
        NodeList nl;
        NodeList fromWsdlList;
        Element data = this.helper.getPrimaryConfigurationData(true);
        String wsdlSource = null;
        Element clientElement = this.getWebServiceClientNode(data, serviceName);
        if (clientElement != null && (fromWsdlList = clientElement.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "client-source-url")).getLength() == 1 && (nl = (fromWsdlElement = (Element)fromWsdlList.item(0)).getChildNodes()).getLength() == 1 && (n = nl.item(0)).getNodeType() == 3) {
            wsdlSource = n.getNodeValue();
        }
        return wsdlSource;
    }

    public void setWsdlSource(String serviceName, String wsdlSource) {
        Element data = this.helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        boolean needsSave = false;
        Element clientElement = this.getWebServiceClientNode(data, serviceName);
        if (clientElement != null) {
            NodeList fromWsdlList = clientElement.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "client-source-url");
            if (fromWsdlList.getLength() > 0) {
                Element fromWsdlElement = (Element)fromWsdlList.item(0);
                NodeList nl = fromWsdlElement.getChildNodes();
                if (nl.getLength() > 0) {
                    Node n = nl.item(0);
                    n.setNodeValue(wsdlSource);
                } else {
                    fromWsdlElement.appendChild(doc.createTextNode(wsdlSource));
                }
            } else {
                Element clientElementSourceUrl = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "client-source-url");
                clientElement.appendChild(clientElementSourceUrl);
                clientElementSourceUrl.appendChild(doc.createTextNode(wsdlSource));
            }
            needsSave = true;
        }
        if (needsSave) {
            try {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
            catch (IOException ex) {
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EjbJarWebServicesSupport.class, (String)"MSG_ErrorSavingOnWSClientAdd", (Object)serviceName, (Object)ex.getMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
        }
    }

    private Element getWebServiceClientNode(Element data, String serviceName) {
        Element clientElement = null;
        NodeList nodes = data.getElementsByTagName("web-service-clients");
        if (nodes.getLength() != 0) {
            Element clientElements = (Element)nodes.item(0);
            NodeList clientNameList = clientElements.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "web-service-client-name");
            for (int i = 0; i < clientNameList.getLength(); ++i) {
                String name;
                Node n;
                Element clientNameElement = (Element)clientNameList.item(i);
                NodeList nl = clientNameElement.getChildNodes();
                if (nl.getLength() != 1 || (n = nl.item(0)).getNodeType() != 3 || !serviceName.equals(name = n.getNodeValue())) continue;
                Node node = clientNameElement.getParentNode();
                clientElement = node instanceof Element ? (Element)node : null;
                break;
            }
        }
        return clientElement;
    }

    public void setProxyJVMOptions(String proxyHost, String proxyPort) {
    }

    public String getServiceRefName(String serviceName) {
        return "service/" + serviceName;
    }

    private static class JAXRPCClientStubDescriptor
    extends ClientStubDescriptor {
        private String[] defaultFeatures;

        public JAXRPCClientStubDescriptor(String name, String displayName, String[] defaultFeatures) {
            super(name, displayName);
            this.defaultFeatures = defaultFeatures;
        }

        public String[] getDefaultFeatures() {
            return this.defaultFeatures;
        }

        public String getDefaultFeaturesAsArgument() {
            StringBuffer buf = new StringBuffer(this.defaultFeatures.length * 32);
            for (int i = 0; i < this.defaultFeatures.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(this.defaultFeatures[i]);
            }
            return buf.toString();
        }

        void setDefaultFeatures(String[] defaultFeatures) {
            this.defaultFeatures = defaultFeatures;
        }
    }
}

