/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.ui;

import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.glassfish.common.GlassFishSettings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class WarnPanel
extends JPanel {
    private final String warning;
    private JCheckBox showAgain;
    private JLabel warningLabel;

    public static void gf312WSWarning(String serverName) {
        boolean showAgain = GlassFishSettings.getGf312WarningShowAgain();
        if (showAgain) {
            String warning = NbBundle.getMessage(WarnPanel.class, (String)"WarnPanel.Gf312WSWarning", (Object)serverName);
            WarnPanel panel = new WarnPanel(warning, showAgain);
            NotifyDescriptor.Message notifyDescriptor = new NotifyDescriptor.Message((Object)panel, -1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            GlassFishSettings.setGf312WarningShowAgain(panel.showAgain());
        }
    }

    public static void gfUnknownVersionWarning(String serverName, String installRoot) {
        if (GlassFishSettings.showWindowSystem()) {
            String warning = NbBundle.getMessage(WarnPanel.class, (String)"WarnPanel.gfUnknownVersionWarning", (Object[])new String[]{serverName, installRoot});
            NotifyDescriptor.Message notifyDescriptor = new NotifyDescriptor.Message((Object)warning, -1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
        }
    }

    public static boolean gfKillWarning(String serverName) {
        boolean showAgain = GlassFishSettings.getGfKillWarningShowAgain();
        if (showAgain) {
            String warning = NbBundle.getMessage(WarnPanel.class, (String)"WarnPanel.GfKillWarning", (Object)serverName);
            String title = NbBundle.getMessage(WarnPanel.class, (String)"WarnPanel.GfKillTitle");
            WarnPanel panel = new WarnPanel(warning, showAgain);
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)panel, title, 0, -1, null, null);
            Object button = DialogDisplayer.getDefault().notify(notifyDescriptor);
            GlassFishSettings.setGfKillWarningShowAgain(panel.showAgain());
            return button == NotifyDescriptor.YES_OPTION;
        }
        return true;
    }

    public WarnPanel(String warning, boolean showAgain) {
        this.warning = warning;
        this.initComponents();
        this.showAgain.setSelected(showAgain);
    }

    public boolean showAgain() {
        return this.showAgain.isSelected();
    }

    private void initComponents() {
        this.warningLabel = new JLabel();
        this.showAgain = new JCheckBox();
        this.setPreferredSize(new Dimension(400, 125));
        this.warningLabel.setText(this.warning);
        this.warningLabel.setVerticalAlignment(1);
        this.warningLabel.setMaximumSize(new Dimension(51, 15));
        this.warningLabel.setMinimumSize(new Dimension(51, 15));
        this.warningLabel.setPreferredSize(new Dimension(51, 15));
        Mnemonics.setLocalizedText((AbstractButton)this.showAgain, (String)NbBundle.getMessage(WarnPanel.class, (String)"WarnPanel.showAgain.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.warningLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.showAgain).addGap(0, 149, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.warningLabel, -1, 80, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showAgain).addContainerGap()));
    }
}

