/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.search.BasicComposition;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.ReplaceTask;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.ui.BasicSearchResultsPanel;
import org.netbeans.modules.search.ui.IssuesPanel;
import org.netbeans.modules.search.ui.ResultsOutlineSupport;
import org.openide.awt.Mnemonics;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class BasicReplaceResultsPanel
extends BasicSearchResultsPanel {
    private JButton replaceButton;

    public BasicReplaceResultsPanel(ResultModel resultModel, BasicComposition composition, Node infoNode) {
        super(resultModel, composition, true, new ResultsOutlineSupport(true, true, resultModel, composition, infoNode));
    }

    @Override
    protected JComponent createLeftComponent() {
        this.replaceButton = new JButton();
        this.replaceButton.addActionListener(e -> this.replace());
        this.replaceButton.setMaximumSize(this.replaceButton.getPreferredSize());
        this.replaceButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResultView.class, (String)"ACS_TEXT_BUTTON_REPLACE"));
        this.updateReplaceButton();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(3, 2, 1));
        buttonPanel.add(this.replaceButton);
        buttonPanel.setMaximumSize(new Dimension((int)buttonPanel.getMaximumSize().getWidth(), (int)buttonPanel.getPreferredSize().getHeight()));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 3));
        leftPanel.add((Component)this.resultsOutlineSupport.getOutlineView());
        leftPanel.add(buttonPanel);
        this.initResultModelListener();
        return leftPanel;
    }

    private void replace() {
        ReplaceTask taskReplace = new ReplaceTask(this.resultModel.getMatchingObjects(), this);
        this.resultsOutlineSupport.clean();
        this.replaceButton.setEnabled(false);
        Manager.getInstance().scheduleReplaceTask(taskReplace);
    }

    private void initResultModelListener() {
        this.resultModel.addPropertyChangeListener(new ModelListener());
    }

    @Override
    public void searchFinished() {
        super.searchFinished();
        if (this.resultModel.isValid()) {
            this.updateReplaceButton();
        }
        if (this.replaceButton.isVisible() && this.replaceButton.isEnabled()) {
            this.replaceButton.requestFocusInWindow();
        }
    }

    private void updateReplaceButton() {
        int matches = this.resultModel.getSelectedMatchesCount();
        Mnemonics.setLocalizedText((AbstractButton)this.replaceButton, (String)NbBundle.getMessage(ResultView.class, (String)"TEXT_BUTTON_REPLACE", (Object)matches));
        this.replaceButton.setEnabled(matches > 0 && this.isFinished());
    }

    public void displayIssuesToUser(ReplaceTask task, String title, String[] problems, boolean reqAtt) {
        Mutex.EVENT.writeAccess(() -> {
            IssuesPanel issuesPanel = new IssuesPanel(title, problems);
            if (isMacLaf) {
                issuesPanel.setBackground(macBackground);
            }
            this.displayIssues(issuesPanel);
            if (!ResultView.getInstance().isOpened()) {
                ResultView.getInstance().open();
            }
            if (reqAtt) {
                ResultView.getInstance().requestAttention(true);
            }
        });
    }

    void displayIssues(IssuesPanel issuesPanel) {
        if (issuesPanel != null) {
            this.showRefreshButton();
            this.removeButtons(this.btnNext, this.btnPrev, this.btnFlatView, this.btnTreeView, this.btnExpand, this.showDetailsButton);
            JPanel p = this.getContentPanel();
            p.removeAll();
            p.add(issuesPanel);
            this.validate();
            this.repaint();
        }
    }

    private void removeButtons(AbstractButton ... abstractButtons) {
        for (AbstractButton ab : abstractButtons) {
            if (ab == null) continue;
            Container c = ab.getParent();
            c.remove(ab);
        }
    }

    public void rescan() {
        BasicComposition bc = new BasicComposition(this.composition.getSearchInfo(), this.composition.getMatcher(), this.composition.getBasicSearchCriteria(), this.composition.getScopeDisplayName());
        Manager.getInstance().scheduleSearchTask(bc, true);
    }

    public void showFinishedInfo() {
        AbstractNode an = new AbstractNode(Children.LEAF);
        an.setIconBaseWithExtension("org/netbeans/modules/search/res/info.png");
        an.setDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_INFO_REPLACE_FINISHED", (Object)this.resultModel.getSelectedMatchesCount()));
        Mutex.EVENT.writeAccess(() -> {
            this.getOutlineView().getOutline().setRootVisible(true);
            this.getExplorerManager().setRootContext((Node)an);
            this.getOutlineView().validate();
            this.getOutlineView().repaint();
            this.btnNext.setEnabled(false);
            this.btnPrev.setEnabled(false);
            this.btnTreeView.setEnabled(false);
            this.btnFlatView.setEnabled(false);
            this.btnExpand.setEnabled(false);
        });
    }

    private class ModelListener
    implements PropertyChangeListener {
        private ModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String pn = evt.getPropertyName();
            if ("valid".equals(pn) && Boolean.FALSE.equals(evt.getNewValue())) {
                BasicReplaceResultsPanel.this.replaceButton.setText(NbBundle.getMessage(ResultView.class, (String)"TEXT_BUTTON_REPLACE_INVALID"));
                BasicReplaceResultsPanel.this.replaceButton.setEnabled(false);
            } else if (BasicReplaceResultsPanel.this.resultModel.isValid()) {
                if ("valid".equals(pn) && Boolean.TRUE.equals(evt.getNewValue())) {
                    BasicReplaceResultsPanel.this.setFinalRootNodeText();
                }
                BasicReplaceResultsPanel.this.updateReplaceButton();
            }
        }
    }
}

