/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.inspect.CSSUtils;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.webkit.RemoteStyleSheetCache;
import org.netbeans.modules.web.inspect.webkit.Utilities;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetBody;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GoToRuleSourceAction
extends AbstractAction {
    private static final RequestProcessor RP = new RequestProcessor(GoToRuleSourceAction.class);
    private final Node node;

    public GoToRuleSourceAction(Node node) {
        this.putValue("Name", NbBundle.getMessage(GoToRuleSourceAction.class, (String)"GoToRuleSourceAction.displayName"));
        this.node = node;
        this.setEnabled(true);
        this.disable();
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        if (RP.isRequestProcessorThread()) {
            Lookup lookup = this.node.getLookup();
            Rule rule = (Rule)lookup.lookup(Rule.class);
            Resource resource = (Resource)lookup.lookup(Resource.class);
            if (resource == null || rule == null) {
                return;
            }
            FileObject fob = resource.toFileObject();
            if (fob == null || fob.isFolder()) {
                StyleSheetBody body = rule.getParentStyleSheet();
                if (body == null) {
                    return;
                }
                fob = RemoteStyleSheetCache.getDefault().getFileObject(body);
                if (fob == null) {
                    return;
                }
            }
            try {
                Source source = Source.create((FileObject)fob);
                ParserManager.parse(Collections.singleton(source), (UserTask)new GoToRuleTask(rule, fob));
            }
            catch (ParseException ex) {
                Logger.getLogger(GoToRuleSourceAction.class.getName()).log(Level.INFO, null, ex);
            }
        } else {
            RP.post(new Runnable(){
                final /* synthetic */ GoToRuleSourceAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.actionPerformed(e);
                }
            });
        }
    }

    final void disable() {
        if (RP.isRequestProcessorThread()) {
            boolean enable;
            Lookup lookup = this.node.getLookup();
            Rule rule = (Rule)lookup.lookup(Rule.class);
            if (rule == null) {
                enable = false;
            } else {
                Resource resource = (Resource)lookup.lookup(Resource.class);
                boolean bl = enable = resource != null && (resource.toFileObject() != null || rule.getParentStyleSheet() != null);
            }
            if (!enable) {
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ GoToRuleSourceAction this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        this.this$0.setEnabled(enable);
                    }
                });
            }
        } else {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    GoToRuleSourceAction.this.disable();
                }
            });
        }
    }

    static class GoToRuleTask
    extends UserTask {
        private final Rule rule;
        private final FileObject fob;

        GoToRuleTask(Rule rule, FileObject fob) {
            this.rule = rule;
            this.fob = fob;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            final boolean[] found = new boolean[1];
            for (final CssParserResult result : Utilities.cssParserResults(resultIterator)) {
                final Model sourceModel = Model.getModel((CssParserResult)result);
                sourceModel.runReadTask(new Model.ModelTask(){
                    final /* synthetic */ GoToRuleTask this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run(StyleSheet styleSheet) {
                        org.netbeans.modules.css.model.api.Rule modelRule = Utilities.findRuleInStyleSheet(sourceModel, styleSheet, this.this$0.rule);
                        if (modelRule != null) {
                            found[0] = true;
                            StyleSheetBody body = this.this$0.rule.getParentStyleSheet();
                            String styleSheetText = body == null ? null : body.getText();
                            int snapshotOffset = modelRule.getStartOffset();
                            final int offset = result.getSnapshot().getOriginalOffset(snapshotOffset);
                            if (!CSSUtils.goToSourceBySourceMap(this.this$0.fob, sourceModel, styleSheetText, offset) && !Utilities.goToMetaSource(modelRule)) {
                                EventQueue.invokeLater(new Runnable(){
                                    final /* synthetic */ 1 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    @Override
                                    public void run() {
                                        CSSUtils.openAtOffset(this.this$1.this$0.fob, offset);
                                    }
                                });
                            }
                        }
                    }
                });
                if (!found[0]) continue;
                break;
            }
        }
    }
}

