/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.netbeans.validation.localization.LocalizationSupport;

final class NumberRange
extends StringValidator {
    private Number max;
    private Number min;

    NumberRange(Number min, Number max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public void validate(Problems problems, String compName, String model) {
        try {
            boolean result;
            double val = Double.parseDouble(model);
            double minn = this.min.doubleValue();
            double maxx = this.max.doubleValue();
            boolean bl = result = val >= minn && val <= maxx;
            if (!result) {
                problems.append(LocalizationSupport.getMessage(NumberRange.class, "VALUE_OUT_OF_RANGE", compName, model, this.min, this.max));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

