/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.netbeans.lib.profiler.wireprotocol.Command;

public class MethodLoadedCommand
extends Command {
    private String className;
    private String methodName;
    private String methodSignature;
    private int classLoaderId;

    public MethodLoadedCommand(String className, int classLoaderId, String methodName, String methodSignature) {
        super(22);
        this.className = className;
        if (classLoaderId == -1) {
            classLoaderId = 0;
        }
        this.classLoaderId = classLoaderId;
        this.methodName = methodName;
        this.methodSignature = methodSignature;
    }

    MethodLoadedCommand() {
        super(22);
    }

    public int getClassLoaderId() {
        return this.classLoaderId;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    @Override
    public String toString() {
        return super.toString() + ", className: " + this.className + ", classLoaderId: " + this.classLoaderId + ", methodName: " + this.methodName + ", methodSignature: " + this.methodSignature;
    }

    @Override
    void readObject(ObjectInputStream in) throws IOException {
        this.className = in.readUTF();
        this.classLoaderId = in.readInt();
        this.methodName = in.readUTF();
        this.methodSignature = in.readUTF();
    }

    @Override
    void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.className);
        out.writeInt(this.classLoaderId);
        out.writeUTF(this.methodName);
        out.writeUTF(this.methodSignature);
    }
}

