/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetComputeClusterRequest
extends BmcRequest<Void> {
    private String computeClusterId;
    private String opcRequestId;

    public String getComputeClusterId() {
        return this.computeClusterId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().computeClusterId(this.computeClusterId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",computeClusterId=").append(String.valueOf(this.computeClusterId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetComputeClusterRequest)) {
            return false;
        }
        GetComputeClusterRequest other = (GetComputeClusterRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.computeClusterId, other.computeClusterId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.computeClusterId == null ? 43 : this.computeClusterId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetComputeClusterRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String computeClusterId = null;
        private String opcRequestId = null;

        public Builder computeClusterId(String computeClusterId) {
            this.computeClusterId = computeClusterId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetComputeClusterRequest o) {
            this.computeClusterId(o.getComputeClusterId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetComputeClusterRequest build() {
            GetComputeClusterRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetComputeClusterRequest buildWithoutInvocationCallback() {
            GetComputeClusterRequest request = new GetComputeClusterRequest();
            request.computeClusterId = this.computeClusterId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

