/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.impl;

import java.io.File;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.v2.SnapshotsWindow;
import org.netbeans.modules.profiler.v2.impl.WeakProcessor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class SnapshotsWindowHelper
implements SnapshotsListener {
    static final WeakProcessor PROCESSOR = new WeakProcessor("Snapshots Window Processor");

    @Override
    public void snapshotTaken(LoadedSnapshot snapshot) {
        if (ProfilerIDESettings.getInstance().getAutoOpenSnapshot()) {
            ResultsManager.getDefault().openSnapshot(snapshot);
        }
        if (ProfilerIDESettings.getInstance().getAutoSaveSnapshot()) {
            ResultsManager.getDefault().saveSnapshot(snapshot);
            if (!ProfilerIDESettings.getInstance().getAutoOpenSnapshot()) {
                ResultsManager.getDefault().closeSnapshot(snapshot);
            }
        }
    }

    @Override
    public void snapshotLoaded(LoadedSnapshot snapshot) {
    }

    @Override
    public void snapshotSaved(final LoadedSnapshot snapshot) {
        this.refreshSnapshots(snapshot);
        PROCESSOR.post(new Runnable(){
            final /* synthetic */ SnapshotsWindowHelper this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                SnapshotsWindow.instance().snapshotSaved(snapshot);
            }
        });
    }

    @Override
    public void snapshotRemoved(LoadedSnapshot snapshot) {
        SnapshotResultsWindow.closeWindow(snapshot);
        this.refreshSnapshots(snapshot);
    }

    private void refreshSnapshots(final LoadedSnapshot snapshot) {
        PROCESSOR.post(new Runnable(){
            final /* synthetic */ SnapshotsWindowHelper this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                FileObject fo;
                File f = snapshot.getFile();
                File p = f == null ? null : f.getParentFile();
                FileObject fileObject = fo = p == null ? null : FileUtil.toFileObject((File)p);
                if (fo != null) {
                    SnapshotsWindow.instance().refreshFolder(fo, true);
                }
            }
        });
    }
}

