/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.duplicates.overview;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeSelectionModel;
import mediathek.config.Daten;
import mediathek.daten.DatenFilm;
import mediathek.gui.duplicates.details.DuplicateFilmDetailsTableFormat;
import mediathek.gui.duplicates.overview.CustomTreeCellRenderer;
import mediathek.tool.EscapeKeyHandler;

public class FilmDuplicateOverviewDialog
extends JDialog {
    private final EventList<DatenFilm> filmList = new BasicEventList();
    private JTree tree;
    private JTable table;
    private JButton okButton;

    public FilmDuplicateOverviewDialog(Window owner) {
        super(owner);
        this.initComponents();
        EscapeKeyHandler.installHandler(this, this::dispose);
        this.okButton.addActionListener(e -> this.dispose());
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Filmduplikate", true);
        List<String> senderList = this.getSenderList();
        for (String sender : senderList) {
            DefaultMutableTreeNode node = this.getDuplicatesForSender(sender);
            if (node.getChildCount() <= 0) continue;
            rootNode.add(node);
        }
        AdvancedTableModel model = GlazedListsSwing.eventTableModelWithThreadProxyList(this.filmList, (TableFormat)new DuplicateFilmDetailsTableFormat());
        this.table.setModel((TableModel)model);
        this.resetColumnWidths();
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.tree.setModel(treeModel);
        TreeSelectionModel selectionModel = this.tree.getSelectionModel();
        selectionModel.setSelectionMode(1);
        this.tree.setCellRenderer(new CustomTreeCellRenderer());
        selectionModel.addTreeSelectionListener(e -> {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object patt0$temp = node.getUserObject();
            if (patt0$temp instanceof DatenFilm) {
                DatenFilm f = (DatenFilm)patt0$temp;
                List<DatenFilm> list = Daten.getInstance().getListeFilme().parallelStream().filter(item -> !item.isLivestream()).filter(item -> item.getUrlNormalQuality().equals(f.getUrlNormalQuality()) && item.getHighQualityUrl().equals(f.getHighQualityUrl())).toList();
                this.filmList.clear();
                this.filmList.addAll(list);
                this.calculateColumnWidths();
            } else {
                this.filmList.clear();
                this.resetColumnWidths();
            }
        });
    }

    private void calculateColumnWidths() {
        this.table.getColumnModel().getColumns().asIterator().forEachRemaining(column -> {
            int preferredWidth = column.getMinWidth();
            int colIdx = column.getModelIndex();
            TableCellRenderer defaultHeaderRenderer = this.table.getTableHeader().getDefaultRenderer();
            TableCellRenderer columnHeaderRenderer = column.getHeaderRenderer();
            if (columnHeaderRenderer == null) {
                columnHeaderRenderer = defaultHeaderRenderer;
            }
            Component header = columnHeaderRenderer.getTableCellRendererComponent(this.table, column.getHeaderValue(), false, false, 0, colIdx);
            int maxWidth = header.getPreferredSize().width;
            for (int row = 0; row < this.table.getRowCount(); ++row) {
                TableCellRenderer cellRenderer = this.table.getCellRenderer(row, colIdx);
                Component c = this.table.prepareRenderer(cellRenderer, row, colIdx);
                int width = c.getPreferredSize().width + this.table.getIntercellSpacing().width;
                if ((preferredWidth = Math.max(preferredWidth, width)) > maxWidth) continue;
                preferredWidth = maxWidth;
                break;
            }
            column.setPreferredWidth(preferredWidth);
        });
        this.table.doLayout();
    }

    private void resetColumnWidths() {
        this.table.getColumnModel().getColumns().asIterator().forEachRemaining(column -> column.setPreferredWidth(90));
        this.table.doLayout();
    }

    private DefaultMutableTreeNode getDuplicatesForSender(String sender) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(sender);
        List<DatenFilm> list = Daten.getInstance().getListeFilme().parallelStream().filter(DatenFilm::isDuplicate).filter(f -> f.getSender().equals(sender)).sorted(Comparator.comparing(DatenFilm::getTitle)).toList();
        for (DatenFilm f2 : list) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(f2);
            root.add(node);
        }
        return root;
    }

    private List<String> getSenderList() {
        return Daten.getInstance().getListeFilme().parallelStream().map(DatenFilm::getSender).distinct().sorted((o1, o2) -> {
            if (o1.equals("ARD") || o1.equals("ZDF")) {
                return 1;
            }
            if (o2.equals("ARD") || o2.equals("ZDF")) {
                return -1;
            }
            return o1.compareTo((String)o2);
        }).toList();
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        JSplitPane splitPane1 = new JSplitPane();
        JScrollPane scrollPane1 = new JScrollPane();
        this.tree = new JTree();
        JScrollPane scrollPane2 = new JScrollPane();
        this.table = new JTable();
        JPanel buttonBar = new JPanel();
        this.okButton = new JButton();
        this.setTitle("\u00dcbersicht aller Duplikate");
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setPreferredSize(new Dimension(640, 480));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        dialogPane.setPreferredSize(new Dimension(800, 600));
        dialogPane.setLayout(new BorderLayout());
        contentPanel.setLayout(new BorderLayout());
        splitPane1.setDividerLocation(350);
        scrollPane1.setViewportView(this.tree);
        splitPane1.setLeftComponent(scrollPane1);
        this.table.setAutoResizeMode(0);
        scrollPane2.setViewportView(this.table);
        splitPane1.setRightComponent(scrollPane2);
        contentPanel.add((Component)splitPane1, "Center");
        dialogPane.add((Component)contentPanel, "Center");
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)buttonBar.getLayout()).columnWidths = new int[]{0, 80};
        ((GridBagLayout)buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0};
        this.okButton.setText("Schlie\u00dfen");
        buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

