//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CXX03___UTILITY_SMALL_BUFFER_H
#define _LIBCPP___CXX03___UTILITY_SMALL_BUFFER_H

#include <__cxx03/__config>
#include <__cxx03/__memory/construct_at.h>
#include <__cxx03/__type_traits/decay.h>
#include <__cxx03/__type_traits/is_trivially_constructible.h>
#include <__cxx03/__type_traits/is_trivially_destructible.h>
#include <__cxx03/__utility/exception_guard.h>
#include <__cxx03/__utility/forward.h>
#include <__cxx03/cstddef>
#include <__cxx03/new>

#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#  pragma GCC system_header
#endif

#endif // _LIBCPP___CXX03___UTILITY_SMALL_BUFFER_H
