/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.WindowKeySchema;

class WindowStoreIteratorWrapper {
    private final KeyValueIterator<Bytes, byte[]> bytesIterator;
    private final long windowSize;
    private final Function<byte[], Long> timestampExtractor;
    private final BiFunction<byte[], Long, Windowed<Bytes>> windowConstructor;

    WindowStoreIteratorWrapper(KeyValueIterator<Bytes, byte[]> bytesIterator, long windowSize) {
        this(bytesIterator, windowSize, WindowKeySchema::extractStoreTimestamp, WindowKeySchema::fromStoreBytesKey);
    }

    WindowStoreIteratorWrapper(KeyValueIterator<Bytes, byte[]> bytesIterator, long windowSize, Function<byte[], Long> timestampExtractor, BiFunction<byte[], Long, Windowed<Bytes>> windowConstructor) {
        this.bytesIterator = bytesIterator;
        this.windowSize = windowSize;
        this.timestampExtractor = timestampExtractor;
        this.windowConstructor = windowConstructor;
    }

    public WindowStoreIterator<byte[]> valuesIterator() {
        return new WrappedWindowStoreIterator(this.bytesIterator, this.timestampExtractor);
    }

    public KeyValueIterator<Windowed<Bytes>, byte[]> keyValueIterator() {
        return new WrappedKeyValueIterator(this.bytesIterator, this.windowSize, this.windowConstructor);
    }

    private static class WrappedWindowStoreIterator
    implements WindowStoreIterator<byte[]> {
        final KeyValueIterator<Bytes, byte[]> bytesIterator;
        final Function<byte[], Long> timestampExtractor;

        WrappedWindowStoreIterator(KeyValueIterator<Bytes, byte[]> bytesIterator, Function<byte[], Long> timestampExtractor) {
            this.bytesIterator = bytesIterator;
            this.timestampExtractor = timestampExtractor;
        }

        @Override
        public Long peekNextKey() {
            return this.timestampExtractor.apply(this.bytesIterator.peekNextKey().get());
        }

        @Override
        public boolean hasNext() {
            return this.bytesIterator.hasNext();
        }

        @Override
        public KeyValue<Long, byte[]> next() {
            KeyValue next = (KeyValue)this.bytesIterator.next();
            long timestamp = this.timestampExtractor.apply(((Bytes)next.key).get());
            return KeyValue.pair(timestamp, (byte[])next.value);
        }

        @Override
        public void close() {
            this.bytesIterator.close();
        }
    }

    private static class WrappedKeyValueIterator
    implements KeyValueIterator<Windowed<Bytes>, byte[]> {
        final KeyValueIterator<Bytes, byte[]> bytesIterator;
        final long windowSize;
        final BiFunction<byte[], Long, Windowed<Bytes>> windowConstructor;

        WrappedKeyValueIterator(KeyValueIterator<Bytes, byte[]> bytesIterator, long windowSize, BiFunction<byte[], Long, Windowed<Bytes>> windowConstructor) {
            this.bytesIterator = bytesIterator;
            this.windowSize = windowSize;
            this.windowConstructor = windowConstructor;
        }

        @Override
        public Windowed<Bytes> peekNextKey() {
            byte[] nextKey = this.bytesIterator.peekNextKey().get();
            return this.windowConstructor.apply(nextKey, this.windowSize);
        }

        @Override
        public boolean hasNext() {
            return this.bytesIterator.hasNext();
        }

        @Override
        public KeyValue<Windowed<Bytes>, byte[]> next() {
            KeyValue next = (KeyValue)this.bytesIterator.next();
            return KeyValue.pair(this.windowConstructor.apply(((Bytes)next.key).get(), this.windowSize), (byte[])next.value);
        }

        @Override
        public void close() {
            this.bytesIterator.close();
        }
    }
}

