/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.TreeMap;
import javajs.api.GenericColor;
import javajs.util.CU;
import javajs.util.SB;
import jspecview.common.ColorParameters;
import jspecview.common.JSVFileManager;
import jspecview.common.ScriptToken;
import jspecview.java.AwtParameters;
import jspecview.source.XMLParser;

public class DisplaySchemesProcessor {
    private final String newLine = System.getProperty("line.separator");
    private String fileName = "displaySchemes.xml";
    private TreeMap<String, ColorParameters> displaySchemes = new TreeMap();
    private XMLParser parser;
    private static /* synthetic */ int[] $SWITCH_TABLE$jspecview$common$ScriptToken;

    public ColorParameters loadDefault() {
        AwtParameters awtParameters = (AwtParameters)new AwtParameters().setName("Default");
        awtParameters.displayFontName = "default";
        awtParameters.setColor(ScriptToken.TITLECOLOR, ColorParameters.BLACK);
        awtParameters.setColor(ScriptToken.UNITSCOLOR, ColorParameters.BLACK);
        awtParameters.setColor(ScriptToken.SCALECOLOR, ColorParameters.BLACK);
        awtParameters.setColor(ScriptToken.COORDINATESCOLOR, ColorParameters.BLACK);
        awtParameters.setColor(ScriptToken.PEAKTABCOLOR, ColorParameters.RED);
        awtParameters.setColor(ScriptToken.HIGHLIGHTCOLOR, ColorParameters.DARK_GRAY);
        awtParameters.setColor(ScriptToken.GRIDCOLOR, ColorParameters.BLACK);
        awtParameters.setColor(ScriptToken.PLOTCOLOR, ColorParameters.BLACK);
        awtParameters.setColor(ScriptToken.PLOTAREACOLOR, ColorParameters.WHITE);
        awtParameters.setColor(ScriptToken.BACKGROUNDCOLOR, ColorParameters.WHITE);
        awtParameters.setColor(ScriptToken.INTEGRALPLOTCOLOR, ColorParameters.RED);
        this.displaySchemes.put("Default", awtParameters);
        return awtParameters;
    }

    public ColorParameters getDefaultScheme() {
        ColorParameters colorParameters = this.displaySchemes.get("Default");
        if (colorParameters == null) {
            colorParameters = this.loadDefault();
        }
        return colorParameters;
    }

    public void store() throws Exception {
        this.serializeDisplaySchemes(new BufferedWriter(new FileWriter(this.fileName)));
    }

    public TreeMap<String, ColorParameters> getDisplaySchemes() {
        return this.displaySchemes;
    }

    public boolean load(InputStream inputStream) {
        try {
            return this.load(JSVFileManager.getBufferedReaderForInputStream(inputStream));
        }
        catch (Exception exception) {
            System.out.println("DisplaySchemeProcessor ignored: " + exception.getMessage());
            return false;
        }
    }

    public boolean load(String string) {
        this.fileName = string;
        if (!new File(this.fileName).exists()) {
            System.out.println("DisplaySchemeProcessor ignored: " + string + " does not exist.");
            return false;
        }
        try {
            BufferedReader bufferedReader = JSVFileManager.getBufferedReaderFromName(this.fileName);
            return this.load(bufferedReader);
        }
        catch (Exception exception) {
            System.out.println("DisplaySchemeProcessor ignored: " + exception.getMessage());
            return false;
        }
    }

    public boolean load(BufferedReader bufferedReader) throws Exception {
        this.parser = new XMLParser(bufferedReader);
        String string = "Default";
        ColorParameters colorParameters = null;
        try {
            while (this.parser.hasNext()) {
                Object object;
                if (this.parser.nextEvent() != 1) continue;
                String string2 = this.parser.getTagName();
                if (string2.equals("displayschemes")) {
                    string = this.parser.getAttrValue("default");
                }
                if (string2.equals("displayscheme")) {
                    object = this.parser.getAttrValue("name");
                    colorParameters = (ColorParameters)new AwtParameters().setName((String)object);
                    if (((String)object).equals(string)) {
                        colorParameters.isDefault = true;
                    }
                    this.displaySchemes.put((String)object, colorParameters);
                }
                if (colorParameters == null) continue;
                if (string2.equals("font")) {
                    String string3 = this.parser.getAttrValue("face");
                    if (string3.length() <= 0) continue;
                    colorParameters.displayFontName = string3;
                    continue;
                }
                if (string2.equals("coordinateColor")) {
                    string2 = "coordinatesColor";
                }
                if ((object = ScriptToken.getScriptToken(string2)) == ScriptToken.UNKNOWN) continue;
                GenericColor genericColor = this.getColor(colorParameters);
                if (genericColor == null) {
                    String string4;
                    switch (DisplaySchemesProcessor.$SWITCH_TABLE$jspecview$common$ScriptToken()[((Enum)object).ordinal()]) {
                        default: {
                            string4 = null;
                            break;
                        }
                        case 83: {
                            string4 = "#0000ff";
                            break;
                        }
                        case 9: {
                            string4 = "#ff0000";
                            break;
                        }
                        case 52: {
                            string4 = "#ff0000";
                            break;
                        }
                        case 26: {
                            string4 = "#808080";
                            break;
                        }
                        case 61: {
                            string4 = "#660000";
                            break;
                        }
                        case 85: {
                            string4 = "#ff0000";
                            break;
                        }
                        case 22: {
                            string4 = "#4e4c4c";
                            break;
                        }
                        case 55: {
                            string4 = "#ff9900";
                            break;
                        }
                        case 54: {
                            string4 = "#333333";
                            break;
                        }
                        case 5: {
                            string4 = "#c0c0c0";
                        }
                    }
                    if (string4 != null) {
                        genericColor = colorParameters.getColorFromString(string4);
                    }
                }
                if (genericColor == null) continue;
                colorParameters.setColor((ScriptToken)((Object)object), genericColor);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private GenericColor getColor(ColorParameters colorParameters) {
        String string = this.parser.getAttrValueLC("hex");
        return string.length() == 0 || string.equals("default") ? null : colorParameters.getColorFromString(string);
    }

    public void serializeDisplaySchemes(Writer writer) throws Exception {
        if (this.displaySchemes.size() == 0) {
            return;
        }
        SB sB = new SB();
        String string = "";
        for (ColorParameters object2 : this.displaySchemes.values()) {
            if (object2.isDefault) {
                string = object2.name;
            }
            sB.append("\t<displayScheme name=\"" + object2.name + "\">").append(this.newLine);
            sB.append("\t\t<font face=\"" + object2.displayFontName + "\"/>").append(this.newLine);
            this.writeColor(sB, object2, "titleColor", ScriptToken.TITLECOLOR);
            this.writeColor(sB, object2, "scaleColor", ScriptToken.SCALECOLOR);
            this.writeColor(sB, object2, "unitsColor", ScriptToken.UNITSCOLOR);
            this.writeColor(sB, object2, "coordinatesColor", ScriptToken.COORDINATESCOLOR);
            this.writeColor(sB, object2, "highlightColor", ScriptToken.HIGHLIGHTCOLOR);
            this.writeColor(sB, object2, "peakTabColor", ScriptToken.PEAKTABCOLOR);
            this.writeColor(sB, object2, "gridColor", ScriptToken.GRIDCOLOR);
            this.writeColor(sB, object2, "plotColor", ScriptToken.PLOTCOLOR);
            this.writeColor(sB, object2, "plotAreaColor", ScriptToken.PLOTAREACOLOR);
            this.writeColor(sB, object2, "backgroundColor", ScriptToken.BACKGROUNDCOLOR);
            sB.append("\t</displayScheme>").append(this.newLine);
        }
        sB.append("</displaySchemes>");
        SB sB2 = new SB();
        sB2.append("<?xml version=\"1.0\"?>" + this.newLine);
        sB2.append("<displaySchemes default=\"" + string + "\">" + this.newLine);
        sB2.append(sB.toString());
        writer.write(sB2.toString());
        writer.flush();
        writer.close();
    }

    private void writeColor(SB sB, ColorParameters colorParameters, String string, ScriptToken scriptToken) {
        sB.append("\t\t<" + string + " hex=\"" + CU.toRGBHexString(colorParameters.getElementColor(scriptToken)) + "\"/>").append(this.newLine);
    }

    public boolean loadDefaultXML() {
        return this.load("displaySchemes.xml") || this.load(this.getClass().getResourceAsStream("resources/displaySchemes.xml"));
    }

    static /* synthetic */ int[] $SWITCH_TABLE$jspecview$common$ScriptToken() {
        if ($SWITCH_TABLE$jspecview$common$ScriptToken != null) {
            return $SWITCH_TABLE$jspecview$common$ScriptToken;
        }
        int[] nArray = new int[ScriptToken.values().length];
        try {
            nArray[ScriptToken.APPLETID.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.APPLETREADYCALLBACKFUNCTIONNAME.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.AUTOINTEGRATE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.BACKGROUNDCOLOR.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.CLOSE.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.COMPOUNDMENUON.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.COORDCALLBACKFUNCTIONNAME.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.COORDINATESCOLOR.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.COORDINATESON.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.DEBUG.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.DEFAULTLOADSCRIPT.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.DEFAULTNMRNORMALIZATION.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.DISPLAY1D.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.DISPLAY2D.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.DISPLAYFONTNAME.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.ENABLEZOOM.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.ENDINDEX.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.FINDX.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.GETPROPERTY.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.GETSOLUTIONCOLOR.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.GRIDCOLOR.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.GRIDON.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.HELP.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.HIDDEN.ordinal()] = 25;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.HIGHLIGHT.ordinal()] = 27;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.HIGHLIGHTCOLOR.ordinal()] = 26;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.INTEGRALOFFSET.ordinal()] = 28;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.INTEGRALPLOTCOLOR.ordinal()] = 32;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.INTEGRALRANGE.ordinal()] = 29;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.INTEGRATE.ordinal()] = 30;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.INTEGRATION.ordinal()] = 31;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.INTEGRATIONRATIOS.ordinal()] = 33;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.INTERFACE.ordinal()] = 34;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.INVERTY.ordinal()] = 35;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.IRMODE.ordinal()] = 36;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.JMOL.ordinal()] = 37;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.JSV.ordinal()] = 38;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.LABEL.ordinal()] = 39;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.LINK.ordinal()] = 40;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.LOAD.ordinal()] = 41;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.LOADFILECALLBACKFUNCTIONNAME.ordinal()] = 42;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.LOADIMAGINARY.ordinal()] = 43;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.MENUON.ordinal()] = 44;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.OBSCURE.ordinal()] = 45;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.OVERLAY.ordinal()] = 46;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.OVERLAYSTACKED.ordinal()] = 47;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.PEAK.ordinal()] = 48;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.PEAKCALLBACKFUNCTIONNAME.ordinal()] = 49;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.PEAKLIST.ordinal()] = 50;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.PEAKOVERCOLOR.ordinal()] = 51;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.PEAKTABCOLOR.ordinal()] = 52;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.PEAKTABSON.ordinal()] = 53;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.PLOTAREACOLOR.ordinal()] = 54;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.PLOTCOLOR.ordinal()] = 55;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.PLOTCOLORS.ordinal()] = 56;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.POINTSONLY.ordinal()] = 57;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.PRINT.ordinal()] = 58;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.REVERSEPLOT.ordinal()] = 59;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SCALEBY.ordinal()] = 60;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SCALECOLOR.ordinal()] = 61;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SCRIPT.ordinal()] = 62;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SELECT.ordinal()] = 63;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SETPEAK.ordinal()] = 64;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SETX.ordinal()] = 65;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SHIFTX.ordinal()] = 66;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SHOWERRORS.ordinal()] = 67;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SHOWINTEGRATION.ordinal()] = 68;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SHOWMEASUREMENTS.ordinal()] = 69;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SHOWMENU.ordinal()] = 70;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SHOWPEAKLIST.ordinal()] = 71;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SHOWPROPERTIES.ordinal()] = 72;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SHOWSOURCE.ordinal()] = 73;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SPECTRUM.ordinal()] = 74;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SPECTRUMNUMBER.ordinal()] = 75;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.STACKOFFSETY.ordinal()] = 76;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.STARTINDEX.ordinal()] = 77;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SYNCCALLBACKFUNCTIONNAME.ordinal()] = 78;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.SYNCID.ordinal()] = 79;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.TEST.ordinal()] = 80;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.TITLEBOLDON.ordinal()] = 82;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.TITLECOLOR.ordinal()] = 83;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.TITLEFONTNAME.ordinal()] = 84;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.TITLEON.ordinal()] = 81;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.UNITSCOLOR.ordinal()] = 85;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.UNKNOWN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.VERSION.ordinal()] = 86;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.VIEW.ordinal()] = 87;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.WINDOW.ordinal()] = 93;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.WRITE.ordinal()] = 94;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.XSCALEON.ordinal()] = 88;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.XUNITSON.ordinal()] = 89;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.YSCALE.ordinal()] = 90;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.YSCALEON.ordinal()] = 91;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.YUNITSON.ordinal()] = 92;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.ZOOM.ordinal()] = 95;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.ZOOMBOXCOLOR.ordinal()] = 96;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScriptToken.ZOOMBOXCOLOR2.ordinal()] = 97;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$jspecview$common$ScriptToken = nArray;
        return nArray;
    }
}

