---
stage: Runtime
group: Geo
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 選択的同期
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab Self-Managed

{{< /details >}}

Geoは選択的な同期をサポートしています。これにより、管理者はどのプロジェクトを**セカンダリ**サイトで同期するかを選択できます。プロジェクトのサブセットは、グループまたはストレージシャードのいずれかによって選択できます。前者は、ユーザーのサブセットに属するデータのみをレプリケートすることにより、転送コストとストレージコストを削減するのに理想的です。後者は、大規模なGitLabインスタンスにGeoを段階的に展開するのに適しています。

{{< alert type="note" >}}

Geoの同期ロジックは、[ドキュメント](../_index.md)に概説されています。ソリューションとドキュメントは、随時変更される可能性があります。プライバシー法およびサイバーセキュリティ法、ならびに適用される貿易管理法に関して、継続的に法的義務を独自に判断する必要があります。

{{< /alert >}}

選択的同期:

1. **セカンダリ**サイトからの権限を制限しません。
1. ユーザーが、選択的な同期に含まれていないプロジェクトリポジトリを表示、操作、クローン作成、およびプッシュすることを妨げません。
   - 詳細については、[セカンダリサイトのGeoプロキシ](../secondary_proxy/_index.md)を参照してください。
1. **セカンダリ**サイトからプロジェクトメタデータを隠しません。
   - GeoはPostgreSQLのレプリケーションに依存しているため、すべてのプロジェクトメタデータは**セカンダリ**サイトにレプリケートされますが、選択されていないリポジトリはセカンダリサイトに存在しません。
1. Geoイベントログ用に生成されるイベントの数を減らしません。
   - いずれかの**セカンダリ**サイトが存在する限り、**プライマリ**サイトはイベントを生成します。選択的な同期の制限は、**セカンダリ**サイトに実装され、**プライマリ**サイトには実装されません。

## レプリケートされていないリポジトリでのGit操作 {#git-operations-on-unreplicated-repositories}

HTTP(S)およびSSH経由のGitクローン、プル、およびプッシュ操作は、**プライマリ**サイトには存在するが、**セカンダリ**サイトには存在しないリポジトリでサポートされています。この状況は、次の場合に発生する可能性があります:

- 選択的な同期に、リポジトリに添付されたプロジェクトが含まれていない。
- リポジトリはアクティブにレプリケートされていますが、まだ完了していません。
