﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/elasticache/ElastiCache_EXPORTS.h>
#include <aws/elasticache/model/Authentication.h>
#include <aws/elasticache/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace ElastiCache {
namespace Model {
class DeleteUserResult {
 public:
  AWS_ELASTICACHE_API DeleteUserResult() = default;
  AWS_ELASTICACHE_API DeleteUserResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_ELASTICACHE_API DeleteUserResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The ID of the user.</p>
   */
  inline const Aws::String& GetUserId() const { return m_userId; }
  template <typename UserIdT = Aws::String>
  void SetUserId(UserIdT&& value) {
    m_userIdHasBeenSet = true;
    m_userId = std::forward<UserIdT>(value);
  }
  template <typename UserIdT = Aws::String>
  DeleteUserResult& WithUserId(UserIdT&& value) {
    SetUserId(std::forward<UserIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The username of the user.</p>
   */
  inline const Aws::String& GetUserName() const { return m_userName; }
  template <typename UserNameT = Aws::String>
  void SetUserName(UserNameT&& value) {
    m_userNameHasBeenSet = true;
    m_userName = std::forward<UserNameT>(value);
  }
  template <typename UserNameT = Aws::String>
  DeleteUserResult& WithUserName(UserNameT&& value) {
    SetUserName(std::forward<UserNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
   */
  inline const Aws::String& GetStatus() const { return m_status; }
  template <typename StatusT = Aws::String>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::String>
  DeleteUserResult& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The options are valkey or redis.</p>
   */
  inline const Aws::String& GetEngine() const { return m_engine; }
  template <typename EngineT = Aws::String>
  void SetEngine(EngineT&& value) {
    m_engineHasBeenSet = true;
    m_engine = std::forward<EngineT>(value);
  }
  template <typename EngineT = Aws::String>
  DeleteUserResult& WithEngine(EngineT&& value) {
    SetEngine(std::forward<EngineT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The minimum engine version required, which is Redis OSS 6.0</p>
   */
  inline const Aws::String& GetMinimumEngineVersion() const { return m_minimumEngineVersion; }
  template <typename MinimumEngineVersionT = Aws::String>
  void SetMinimumEngineVersion(MinimumEngineVersionT&& value) {
    m_minimumEngineVersionHasBeenSet = true;
    m_minimumEngineVersion = std::forward<MinimumEngineVersionT>(value);
  }
  template <typename MinimumEngineVersionT = Aws::String>
  DeleteUserResult& WithMinimumEngineVersion(MinimumEngineVersionT&& value) {
    SetMinimumEngineVersion(std::forward<MinimumEngineVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Access permissions string used for this user.</p>
   */
  inline const Aws::String& GetAccessString() const { return m_accessString; }
  template <typename AccessStringT = Aws::String>
  void SetAccessString(AccessStringT&& value) {
    m_accessStringHasBeenSet = true;
    m_accessString = std::forward<AccessStringT>(value);
  }
  template <typename AccessStringT = Aws::String>
  DeleteUserResult& WithAccessString(AccessStringT&& value) {
    SetAccessString(std::forward<AccessStringT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Returns a list of the user group IDs the user belongs to.</p>
   */
  inline const Aws::Vector<Aws::String>& GetUserGroupIds() const { return m_userGroupIds; }
  template <typename UserGroupIdsT = Aws::Vector<Aws::String>>
  void SetUserGroupIds(UserGroupIdsT&& value) {
    m_userGroupIdsHasBeenSet = true;
    m_userGroupIds = std::forward<UserGroupIdsT>(value);
  }
  template <typename UserGroupIdsT = Aws::Vector<Aws::String>>
  DeleteUserResult& WithUserGroupIds(UserGroupIdsT&& value) {
    SetUserGroupIds(std::forward<UserGroupIdsT>(value));
    return *this;
  }
  template <typename UserGroupIdsT = Aws::String>
  DeleteUserResult& AddUserGroupIds(UserGroupIdsT&& value) {
    m_userGroupIdsHasBeenSet = true;
    m_userGroupIds.emplace_back(std::forward<UserGroupIdsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Denotes whether the user requires a password to authenticate.</p>
   */
  inline const Authentication& GetAuthentication() const { return m_authentication; }
  template <typename AuthenticationT = Authentication>
  void SetAuthentication(AuthenticationT&& value) {
    m_authenticationHasBeenSet = true;
    m_authentication = std::forward<AuthenticationT>(value);
  }
  template <typename AuthenticationT = Authentication>
  DeleteUserResult& WithAuthentication(AuthenticationT&& value) {
    SetAuthentication(std::forward<AuthenticationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the user.</p>
   */
  inline const Aws::String& GetARN() const { return m_aRN; }
  template <typename ARNT = Aws::String>
  void SetARN(ARNT&& value) {
    m_aRNHasBeenSet = true;
    m_aRN = std::forward<ARNT>(value);
  }
  template <typename ARNT = Aws::String>
  DeleteUserResult& WithARN(ARNT&& value) {
    SetARN(std::forward<ARNT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DeleteUserResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_userId;

  Aws::String m_userName;

  Aws::String m_status;

  Aws::String m_engine;

  Aws::String m_minimumEngineVersion;

  Aws::String m_accessString;

  Aws::Vector<Aws::String> m_userGroupIds;

  Authentication m_authentication;

  Aws::String m_aRN;

  ResponseMetadata m_responseMetadata;
  bool m_userIdHasBeenSet = false;
  bool m_userNameHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_engineHasBeenSet = false;
  bool m_minimumEngineVersionHasBeenSet = false;
  bool m_accessStringHasBeenSet = false;
  bool m_userGroupIdsHasBeenSet = false;
  bool m_authenticationHasBeenSet = false;
  bool m_aRNHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace ElastiCache
}  // namespace Aws
