﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lambda/LambdaRequest.h>
#include <aws/lambda/Lambda_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace Lambda {
namespace Model {

/**
 */
class RemoveLayerVersionPermissionRequest : public LambdaRequest {
 public:
  AWS_LAMBDA_API RemoveLayerVersionPermissionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "RemoveLayerVersionPermission"; }

  AWS_LAMBDA_API Aws::String SerializePayload() const override;

  AWS_LAMBDA_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The name or Amazon Resource Name (ARN) of the layer.</p>
   */
  inline const Aws::String& GetLayerName() const { return m_layerName; }
  inline bool LayerNameHasBeenSet() const { return m_layerNameHasBeenSet; }
  template <typename LayerNameT = Aws::String>
  void SetLayerName(LayerNameT&& value) {
    m_layerNameHasBeenSet = true;
    m_layerName = std::forward<LayerNameT>(value);
  }
  template <typename LayerNameT = Aws::String>
  RemoveLayerVersionPermissionRequest& WithLayerName(LayerNameT&& value) {
    SetLayerName(std::forward<LayerNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version number.</p>
   */
  inline long long GetVersionNumber() const { return m_versionNumber; }
  inline bool VersionNumberHasBeenSet() const { return m_versionNumberHasBeenSet; }
  inline void SetVersionNumber(long long value) {
    m_versionNumberHasBeenSet = true;
    m_versionNumber = value;
  }
  inline RemoveLayerVersionPermissionRequest& WithVersionNumber(long long value) {
    SetVersionNumber(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier that was specified when the statement was added.</p>
   */
  inline const Aws::String& GetStatementId() const { return m_statementId; }
  inline bool StatementIdHasBeenSet() const { return m_statementIdHasBeenSet; }
  template <typename StatementIdT = Aws::String>
  void SetStatementId(StatementIdT&& value) {
    m_statementIdHasBeenSet = true;
    m_statementId = std::forward<StatementIdT>(value);
  }
  template <typename StatementIdT = Aws::String>
  RemoveLayerVersionPermissionRequest& WithStatementId(StatementIdT&& value) {
    SetStatementId(std::forward<StatementIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Only update the policy if the revision ID matches the ID specified. Use this
   * option to avoid modifying a policy that has changed since you last read it.</p>
   */
  inline const Aws::String& GetRevisionId() const { return m_revisionId; }
  inline bool RevisionIdHasBeenSet() const { return m_revisionIdHasBeenSet; }
  template <typename RevisionIdT = Aws::String>
  void SetRevisionId(RevisionIdT&& value) {
    m_revisionIdHasBeenSet = true;
    m_revisionId = std::forward<RevisionIdT>(value);
  }
  template <typename RevisionIdT = Aws::String>
  RemoveLayerVersionPermissionRequest& WithRevisionId(RevisionIdT&& value) {
    SetRevisionId(std::forward<RevisionIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_layerName;

  long long m_versionNumber{0};

  Aws::String m_statementId;

  Aws::String m_revisionId;
  bool m_layerNameHasBeenSet = false;
  bool m_versionNumberHasBeenSet = false;
  bool m_statementIdHasBeenSet = false;
  bool m_revisionIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Lambda
}  // namespace Aws
