/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing;

import java.util.Arrays;
import java.util.List;
import org.opensearch.action.bulk.BulkShardRequest;
import org.opensearch.action.support.replication.ReplicatedWriteRequest;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.common.collect.Tuple;
import org.opensearch.core.common.Strings;
import org.opensearch.http.HttpRequest;
import org.opensearch.rest.RestRequest;
import org.opensearch.tasks.Task;
import org.opensearch.telemetry.tracing.SpanContext;
import org.opensearch.telemetry.tracing.SpanCreationContext;
import org.opensearch.telemetry.tracing.attributes.Attributes;
import org.opensearch.transport.TcpChannel;
import org.opensearch.transport.Transport;

@InternalApi
public final class SpanBuilder {
    private static final List<String> HEADERS_TO_BE_ADDED_AS_ATTRIBUTES = Arrays.asList("trace");
    private static final String SEPARATOR = " ";

    private SpanBuilder() {
    }

    public static SpanCreationContext from(HttpRequest request) {
        return SpanCreationContext.server().name(SpanBuilder.createSpanName(request)).attributes(SpanBuilder.buildSpanAttributes(request));
    }

    public static SpanCreationContext from(RestRequest request) {
        return SpanCreationContext.client().name(SpanBuilder.createSpanName(request)).attributes(SpanBuilder.buildSpanAttributes(request));
    }

    public static SpanCreationContext from(String action, Transport.Connection connection) {
        return SpanCreationContext.server().name(SpanBuilder.createSpanName(action, connection)).attributes(SpanBuilder.buildSpanAttributes(action, connection));
    }

    public static SpanCreationContext from(String spanName, String nodeId, ReplicatedWriteRequest request) {
        return SpanCreationContext.server().name(spanName).attributes(SpanBuilder.buildSpanAttributes(nodeId, request));
    }

    private static String createSpanName(HttpRequest httpRequest) {
        Tuple<String, String> uriParts = SpanBuilder.splitUri(httpRequest.uri());
        String path = (String)uriParts.v1();
        return httpRequest.method().name() + SEPARATOR + path;
    }

    private static Attributes buildSpanAttributes(HttpRequest httpRequest) {
        Attributes attributes = Attributes.create().addAttribute("http.uri", httpRequest.uri()).addAttribute("http.method", httpRequest.method().name()).addAttribute("http.version", httpRequest.protocolVersion().name());
        SpanBuilder.populateHeader(httpRequest, attributes);
        Tuple<String, String> uriParts = SpanBuilder.splitUri(httpRequest.uri());
        String query = (String)uriParts.v2();
        if (!query.isBlank()) {
            attributes.addAttribute("url.query", query);
        }
        return attributes;
    }

    private static Tuple<String, String> splitUri(String uri) {
        int index = uri.indexOf(63);
        if (index >= 0 && index < uri.length() - 1) {
            String path = uri.substring(0, index);
            String query = uri.substring(index + 1);
            return new Tuple((Object)path, (Object)query);
        }
        return new Tuple((Object)uri, (Object)"");
    }

    private static void populateHeader(HttpRequest httpRequest, Attributes attributes) {
        HEADERS_TO_BE_ADDED_AS_ATTRIBUTES.forEach(x -> {
            if (httpRequest.getHeaders() != null && httpRequest.getHeaders().get(x) != null && !httpRequest.getHeaders().get(x).isEmpty()) {
                attributes.addAttribute(x, Strings.collectionToCommaDelimitedString((Iterable)httpRequest.getHeaders().get(x)));
            }
        });
    }

    private static String createSpanName(RestRequest restRequest) {
        Object spanName = "rest_request";
        if (restRequest != null) {
            try {
                String methodName = restRequest.method().name();
                String rawPath = restRequest.rawPath();
                spanName = methodName + SEPARATOR + rawPath;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return spanName;
    }

    private static Attributes buildSpanAttributes(RestRequest restRequest) {
        if (restRequest != null) {
            Attributes attributes = Attributes.create().addAttribute("rest.request_id", restRequest.getRequestId()).addAttribute("rest.raw_path", restRequest.rawPath());
            Tuple<String, String> uriParts = SpanBuilder.splitUri(restRequest.uri());
            String query = (String)uriParts.v2();
            if (!query.isBlank()) {
                attributes.addAttribute("url.query", query);
            }
            return attributes;
        }
        return Attributes.EMPTY;
    }

    private static String createSpanName(String action, Transport.Connection connection) {
        return action + SEPARATOR + (connection.getNode() != null ? connection.getNode().getHostAddress() : null);
    }

    private static Attributes buildSpanAttributes(String action, Transport.Connection connection) {
        Attributes attributes = Attributes.create().addAttribute("action", action);
        if (connection != null && connection.getNode() != null) {
            attributes.addAttribute("target_host", connection.getNode().getHostAddress());
        }
        return attributes;
    }

    public static SpanCreationContext from(String action, TcpChannel tcpChannel) {
        return SpanCreationContext.server().name(SpanBuilder.createSpanName(action, tcpChannel)).attributes(SpanBuilder.buildSpanAttributes(action, tcpChannel));
    }

    private static String createSpanName(String action, TcpChannel tcpChannel) {
        return action + SEPARATOR + (tcpChannel.getRemoteAddress() != null ? tcpChannel.getRemoteAddress().getHostString() : tcpChannel.getLocalAddress().getHostString());
    }

    private static Attributes buildSpanAttributes(String action, TcpChannel tcpChannel) {
        Attributes attributes = Attributes.create().addAttribute("action", action);
        attributes.addAttribute("host", tcpChannel.getLocalAddress().getHostString());
        return attributes;
    }

    private static Attributes buildSpanAttributes(String nodeId, ReplicatedWriteRequest request) {
        Attributes attributes = Attributes.create().addAttribute("node_id", nodeId).addAttribute("refresh_policy", request.getRefreshPolicy().getValue());
        if (request.shardId() != null) {
            attributes.addAttribute("index", request.shardId().getIndexName()).addAttribute("shard_id", (long)request.shardId().getId());
        }
        if (request instanceof BulkShardRequest) {
            attributes.addAttribute("bulk_request_items", (long)((BulkShardRequest)request).items().length);
        }
        return attributes;
    }

    public static SpanCreationContext from(String spanName, SpanContext parentSpan) {
        return SpanCreationContext.server().name(spanName).parent(parentSpan);
    }

    public static SpanCreationContext from(Task task, String actionName) {
        return SpanCreationContext.server().name(SpanBuilder.createSpanName(task, actionName)).attributes(SpanBuilder.buildSpanAttributes(task, actionName));
    }

    private static Attributes buildSpanAttributes(Task task, String actionName) {
        Attributes attributes = Attributes.create().addAttribute("action", actionName);
        if (task != null) {
            attributes.addAttribute("task_id", task.getId());
            if (task.getParentTaskId() != null && task.getParentTaskId().isSet()) {
                attributes.addAttribute("parent_task_id", task.getParentTaskId().getId());
            }
        }
        return attributes;
    }

    private static String createSpanName(Task task, String actionName) {
        if (task != null) {
            return task.getType() + SEPARATOR + task.getAction();
        }
        return actionName;
    }
}

