! 
!     Copyright (c) 2017-2018, NVIDIA CORPORATION.  All rights reserved.
!
! NVIDIA CORPORATION and its licensors retain all intellectual property
! and proprietary rights in and to this software, related documentation
! and any modifications thereto.  Any use, reproduction, disclosure or
! distribution of this software and related documentation without an express
! license agreement from NVIDIA CORPORATION is strictly prohibited.
! 

!          THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT
!   WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT
!   NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR
!   FITNESS FOR A PARTICULAR PURPOSE.
!
! cudaError types, taken from CUDA driver_types.h
!
!* Copyright 1993-2008 NVIDIA Corporation.  All rights reserved.
!
!* NOTICE TO USER:   
!
!* This source code is subject to NVIDIA ownership rights under U.S. and 
!* international Copyright laws.  Users and possessors of this source code 
!* are hereby granted a nonexclusive, royalty-free license to use this code 
!* in individual and commercial software.
!
!* NVIDIA MAKES NO REPRESENTATION ABOUT THE SUITABILITY OF THIS SOURCE 
!* CODE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR 
!* IMPLIED WARRANTY OF ANY KIND.  NVIDIA DISCLAIMS ALL WARRANTIES WITH 
!* REGARD TO THIS SOURCE CODE, INCLUDING ALL IMPLIED WARRANTIES OF 
!* MERCHANTABILITY, NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
!* IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL, 
!* OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS 
!* OF USE, DATA OR PROFITS,  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE 
!* OR OTHER TORTIOUS ACTION,  ARISING OUT OF OR IN CONNECTION WITH THE USE 
!* OR PERFORMANCE OF THIS SOURCE CODE.  
!
!* U.S. Government End Users.   This source code is a "commercial item" as 
!* that term is defined at  48 C.F.R. 2.101 (OCT 1995), consisting  of 
!* "commercial computer  software"  and "commercial computer software 
!* documentation" as such terms are  used in 48 C.F.R. 12.212 (SEPT 1995) 
!* and is provided to the U.S. Government only as a commercial end item.  
!* Consistent with 48 C.F.R.12.212 and 48 C.F.R. 227.7202-1 through 
!* 227.7202-4 (JUNE 1995), all U.S. Government End Users acquire the 
!* source code with only those rights set forth herein. 
!
!* Any use of this source code in individual and commercial software must 
!* include, in the user documentation and internal comments to the code,
!* the above Disclaimer and U.S. Government End Users Notice.
!
enum, bind(c)
  enumerator :: cudaSuccess = 0
  enumerator cudaErrorInvalidValue ! 1
  enumerator cudaErrorMemoryAllocation ! 2
  enumerator cudaErrorInitializationError ! 3
  enumerator cudaErrorCudartUnloading ! 4
  enumerator cudaErrorProfilerDisabled ! 5
  enumerator cudaErrorProfilerNotInitialized ! 6
  enumerator cudaErrorProfilerAlreadyStarted ! 7
  enumerator cudaErrorProfilerAlreadyStopped ! 8
  enumerator cudaErrorInvalidConfiguration ! 9
  enumerator :: cudaErrorInvalidPitchValue = 12
  enumerator cudaErrorInvalidSymbol ! 13
  enumerator :: cudaErrorInvalidHostPointer = 16
  enumerator cudaErrorInvalidDevicePointer ! 17
  enumerator cudaErrorInvalidTexture ! 18
  enumerator cudaErrorInvalidTextureBinding ! 19
  enumerator cudaErrorInvalidChannelDescriptor ! 20
  enumerator cudaErrorInvalidMemcpyDirection ! 21
  enumerator cudaErrorAddressOfConstant ! 22
  enumerator cudaErrorTextureFetchFailed ! 23
  enumerator cudaErrorTextureNotBound ! 24
  enumerator cudaErrorSynchronizationError ! 25
  enumerator cudaErrorInvalidFilterSetting ! 26
  enumerator cudaErrorInvalidNormSetting ! 27
  enumerator cudaErrorMixedDeviceExecution ! 28
  enumerator :: cudaErrorNotYetImplemented = 31
  enumerator cudaErrorMemoryValueTooLarge ! 32
  enumerator :: cudaErrorInsufficientDriver = 35
  enumerator :: cudaErrorInvalidSurface = 37
  enumerator :: cudaErrorDuplicateVariableName = 43
  enumerator cudaErrorDuplicateTextureName ! 44
  enumerator cudaErrorDuplicateSurfaceName ! 45
  enumerator cudaErrorDevicesUnavailable ! 46
  enumerator :: cudaErrorIncompatibleDriverContext = 49
  enumerator :: cudaErrorMissingConfiguration = 52
  enumerator :: cudaErrorPriorLaunchFailure = 53
  enumerator :: cudaErrorLaunchMaxDepthExceeded = 65
  enumerator cudaErrorLaunchFileScopedTex ! 66
  enumerator cudaErrorLaunchFileScopedSurf ! 67
  enumerator cudaErrorSyncDepthExceeded ! 68
  enumerator cudaErrorLaunchPendingCountExceeded ! 69
  enumerator :: cudaErrorInvalidDeviceFunction = 98
  enumerator :: cudaErrorNoDevice = 100
  enumerator cudaErrorInvalidDevice
  enumerator :: cudaErrorStartupFailure = 127
  enumerator :: cudaErrorInvalidKernelImage = 200
  enumerator cudaErrorDeviceUninitialized ! 201
  enumerator :: cudaErrorMapBufferObjectFailed = 205
  enumerator cudaErrorUnmapBufferObjectFailed ! 206
  enumerator cudaErrorArrayIsMapped ! 207
  enumerator cudaErrorAlreadyMapped ! 208
  enumerator cudaErrorNoKernelImageForDevice ! 209
  enumerator cudaErrorAlreadyAcquired ! 210
  enumerator cudaErrorNotMapped ! 211
  enumerator cudaErrorNotMappedAsArray ! 212
  enumerator cudaErrorNotMappedAsPointer ! 213
  enumerator cudaErrorECCUncorrectable ! 214
  enumerator cudaErrorUnsupportedLimit ! 215
  enumerator cudaErrorDeviceAlreadyInUse ! 216
  enumerator cudaErrorPeerAccessUnsupported ! 217
  enumerator cudaErrorInvalidPtx ! 218
  enumerator cudaErrorInvalidGraphicsContext ! 219
  enumerator cudaErrorNvlinkUncorrectable ! 220
  enumerator cudaErrorJitCompilerNotFound ! 221
  enumerator :: cudaErrorInvalidSource = 300
  enumerator cudaErrorFileNotFound ! 301
  enumerator cudaErrorSharedObjectSymbolNotFound ! 302
  enumerator cudaErrorSharedObjectInitFailed ! 303
  enumerator cudaErrorOperatingSystem ! 304
  enumerator :: cudaErrorInvalidResourceHandle = 400
  enumerator cudaErrorIllegalState ! 401
  enumerator :: cudaErrorSymbolNotFound = 500
  enumerator :: cudaErrorNotReady = 600
  enumerator :: cudaErrorIllegalAddress = 700
  enumerator cudaErrorLaunchOutOfResources ! 701
  enumerator cudaErrorLaunchTimeout ! 702
  enumerator cudaErrorLaunchIncompatibleTexturing ! 703
  enumerator cudaErrorPeerAccessAlreadyEnabled ! 704
  enumerator cudaErrorPeerAccessNotEnabled ! 705
  enumerator :: cudaErrorSetOnActiveProcess = 708
  enumerator cudaErrorContextIsDestroyed ! 709
  enumerator cudaErrorAssert ! 710
  enumerator cudaErrorTooManyPeers ! 711
  enumerator cudaErrorHostMemoryAlreadyRegistered ! 712
  enumerator cudaErrorHostMemoryNotRegistered ! 713
  enumerator cudaErrorHardwareStackError ! 714
  enumerator cudaErrorIllegalInstruction ! 715
  enumerator cudaErrorMisalignedAddress ! 716
  enumerator cudaErrorInvalidAddressSpace ! 717
  enumerator cudaErrorInvalidPc ! 718
  enumerator cudaErrorLaunchFailure ! 719
  enumerator cudaErrorCooperativeLaunchTooLarge ! 720
  enumerator :: cudaErrorNotPermitted = 800
  enumerator cudaErrorNotSupported ! 801
  enumerator cudaErrorSystemNotReady ! 802
  enumerator cudaErrorSystemDriverMismatch ! 803
  enumerator cudaErrorCompatNotSupportedOnDevice ! 804
  enumerator :: cudaErrorStreamCaptureUnsupported = 900
  enumerator cudaErrorStreamCaptureInvalidated ! 901
  enumerator cudaErrorStreamCaptureMerge ! 902
  enumerator cudaErrorStreamCaptureUnmatched ! 903
  enumerator cudaErrorStreamCaptureUnjoined ! 904
  enumerator cudaErrorStreamCaptureIsolation ! 905
  enumerator cudaErrorStreamCaptureImplicit ! 906
  enumerator cudaErrorCapturedEvent ! 907
  enumerator cudaErrorStreamCaptureWrongThread ! 908
  enumerator cudaErrorTimeout ! 909
  enumerator cudaErrorGraphExecUpdateFailure ! 910
  enumerator :: cudaErrorUnknown = 999
  enumerator :: cudaErrorApiFailureBase = 10000
end enum

enum, bind(c)
  enumerator :: cudaMemoryTypeUnregistered = 0
  enumerator cudaMemoryTypeHost
  enumerator cudaMemoryTypeDevice
  enumerator cudaMemoryTypeManaged
end enum

enum, bind(c)
  enumerator :: cudaMemcpyHostToHost = 0
  enumerator cudaMemcpyHostToDevice
  enumerator cudaMemcpyDeviceToHost
  enumerator cudaMemcpyDeviceToDevice
  enumerator cudaMemcpyDefault
end enum

enum, bind(c)
  enumerator :: cudaChannelFormatKindSigned = 0
  enumerator cudaChannelFormatKindUnsigned
  enumerator cudaChannelFormatKindFloat
  enumerator cudaChannelFormatKindNone
end enum

enum, bind(c)
  enumerator :: cudaFuncCachePreferNone = 0
  enumerator cudaFuncCachePreferShared
  enumerator cudaFuncCachePreferL1
  enumerator cudaFuncCachePreferEqual
end enum

enum, bind(c)
  enumerator :: cudaFuncAttributeMaxDynamicSharedMemorySize = 8
  enumerator cudaFuncAttributePreferredSharedMemoryCarveout
  enumerator cudaFuncAttributeMax
end enum

enum, bind(c)
  enumerator :: cudaSharedmemCarveoutDefault   = -1
  enumerator :: cudaSharedmemCarveoutMaxL1     = 0  
  enumerator :: cudaSharedmemCarveoutMaxShared = 100
end enum

enum, bind(c)
  enumerator :: cudaLimitStackSize = 0
  enumerator cudaLimitPrintfFifoSize
  enumerator cudaLimitMallocHeapSize
  enumerator cudaLimitDevRuntimeSyncDepth
  enumerator cudaLimitDevRuntimePendingLaunchCount
  enumerator cudaLimitMaxL2FetchGranularity
  enumerator cudaLimitPersistingL2CacheSize
end enum
  
enum, bind(c)
  enumerator :: cudaMemAdviseSetReadMostly = 1
  enumerator cudaMemAdviseUnsetReadMostly
  enumerator cudaMemAdviseSetPreferredLocation
  enumerator cudaMemAdviseUnsetPreferredLocation
  enumerator cudaMemAdviseSetAccessedBy
  enumerator cudaMemAdviseUnsetAccessedBy
end enum

enum, bind(c)
  enumerator :: cudaMemLocationTypeInvalid = 0
  enumerator cudaMemLocationTypeNone = 0
  enumerator cudaMemLocationTypeDevice
  enumerator cudaMemLocationTypeHost
  enumerator cudaMemLocationTypeHostNuma
  enumerator cudaMemLocationTypeHostNumaCurrent
end enum

enum, bind(c)
  enumerator :: cudaMemRangeAttributeReadMostly = 1
  enumerator cudaMemRangeAttributePreferredLocation
  enumerator cudaMemRangeAttributeAccessedBy
  enumerator cudaMemRangeAttributeLastPrefetchLocation
end enum

enum, bind(c)
  enumerator :: cudaAccessPropertyNormal   = 0
  enumerator cudaAccessPropertyStreaming
  enumerator cudaAccessPropertyPersisting
end enum

enum, bind(c)
  enumerator :: cudaAddressModeWrap   = 0
  enumerator cudaAddressModeClamp
  enumerator cudaAddressModeMirror
  enumerator cudaAddressModeBorder
end enum
  
enum, bind(c)
  enumerator :: cudaFilterModePoint   = 0
  enumerator cudaFilterModeLinear
end enum

enum, bind(c)
  enumerator :: cudaSharedMemBankSizeDefault = 0
  enumerator cudaSharedMemBankSizeFourByte
  enumerator cudaSharedMemBankSizeEightByte
end enum

enum, bind(c)
  enumerator :: cudaReadModeElementType   = 0
  enumerator cudaReadModeNormalizedFloat
end enum

enum, bind(c)
  enumerator :: cudaComputeModeDefault   = 0
  enumerator cudaComputeModeExclusive
  enumerator cudaComputeModeProhibited
  enumerator cudaComputeModeExclusiveProcess
end enum

enum, bind(c)
  enumerator :: cudaDevAttrMaxThreadsPerBlock               = 1
  enumerator :: cudaDevAttrMaxBlockDimX                     = 2
  enumerator :: cudaDevAttrMaxBlockDimY                     = 3
  enumerator :: cudaDevAttrMaxBlockDimZ                     = 4
  enumerator :: cudaDevAttrMaxGridDimX                      = 5
  enumerator :: cudaDevAttrMaxGridDimY                      = 6
  enumerator :: cudaDevAttrMaxGridDimZ                      = 7
  enumerator :: cudaDevAttrMaxSharedMemoryPerBlock          = 8
  enumerator :: cudaDevAttrTotalConstantMemory              = 9
  enumerator :: cudaDevAttrWarpSize                         = 10
  enumerator :: cudaDevAttrMaxPitch                         = 11
  enumerator :: cudaDevAttrMaxRegistersPerBlock             = 12
  enumerator :: cudaDevAttrClockRate                        = 13
  enumerator :: cudaDevAttrTextureAlignment                 = 14
  enumerator :: cudaDevAttrGpuOverlap                       = 15
  enumerator :: cudaDevAttrMultiProcessorCount              = 16
  enumerator :: cudaDevAttrKernelExecTimeout                = 17
  enumerator :: cudaDevAttrIntegrated                       = 18
  enumerator :: cudaDevAttrCanMapHostMemory                 = 19
  enumerator :: cudaDevAttrComputeMode                      = 20
  enumerator :: cudaDevAttrMaxTexture1DWidth                = 21
  enumerator :: cudaDevAttrMaxTexture2DWidth                = 22
  enumerator :: cudaDevAttrMaxTexture2DHeight               = 23
  enumerator :: cudaDevAttrMaxTexture3DWidth                = 24
  enumerator :: cudaDevAttrMaxTexture3DHeight               = 25
  enumerator :: cudaDevAttrMaxTexture3DDepth                = 26
  enumerator :: cudaDevAttrMaxTexture2DLayeredWidth         = 27
  enumerator :: cudaDevAttrMaxTexture2DLayeredHeight        = 28
  enumerator :: cudaDevAttrMaxTexture2DLayeredLayers        = 29
  enumerator :: cudaDevAttrSurfaceAlignment                 = 30
  enumerator :: cudaDevAttrConcurrentKernels                = 31
  enumerator :: cudaDevAttrEccEnabled                       = 32
  enumerator :: cudaDevAttrPciBusId                         = 33
  enumerator :: cudaDevAttrPciDeviceId                      = 34
  enumerator :: cudaDevAttrTccDriver                        = 35
  enumerator :: cudaDevAttrMemoryClockRate                  = 36
  enumerator :: cudaDevAttrGlobalMemoryBusWidth             = 37
  enumerator :: cudaDevAttrL2CacheSize                      = 38
  enumerator :: cudaDevAttrMaxThreadsPerMultiProcessor      = 39
  enumerator :: cudaDevAttrAsyncEngineCount                 = 40
  enumerator :: cudaDevAttrUnifiedAddressing                = 41
  enumerator :: cudaDevAttrMaxTexture1DLayeredWidth         = 42
  enumerator :: cudaDevAttrMaxTexture1DLayeredLayers        = 43
  enumerator :: cudaDevAttrMaxTexture2DGatherWidth          = 45
  enumerator :: cudaDevAttrMaxTexture2DGatherHeight         = 46
  enumerator :: cudaDevAttrMaxTexture3DWidthAlt             = 47
  enumerator :: cudaDevAttrMaxTexture3DHeightAlt            = 48
  enumerator :: cudaDevAttrMaxTexture3DDepthAlt             = 49
  enumerator :: cudaDevAttrPciDomainId                      = 50
  enumerator :: cudaDevAttrTexturePitchAlignment            = 51
  enumerator :: cudaDevAttrMaxTextureCubemapWidth           = 52
  enumerator :: cudaDevAttrMaxTextureCubemapLayeredWidth    = 53
  enumerator :: cudaDevAttrMaxTextureCubemapLayeredLayers   = 54
  enumerator :: cudaDevAttrMaxSurface1DWidth                = 55
  enumerator :: cudaDevAttrMaxSurface2DWidth                = 56
  enumerator :: cudaDevAttrMaxSurface2DHeight               = 57
  enumerator :: cudaDevAttrMaxSurface3DWidth                = 58
  enumerator :: cudaDevAttrMaxSurface3DHeight               = 59
  enumerator :: cudaDevAttrMaxSurface3DDepth                = 60
  enumerator :: cudaDevAttrMaxSurface1DLayeredWidth         = 61
  enumerator :: cudaDevAttrMaxSurface1DLayeredLayers        = 62
  enumerator :: cudaDevAttrMaxSurface2DLayeredWidth         = 63
  enumerator :: cudaDevAttrMaxSurface2DLayeredHeight        = 64
  enumerator :: cudaDevAttrMaxSurface2DLayeredLayers        = 65
  enumerator :: cudaDevAttrMaxSurfaceCubemapWidth           = 66
  enumerator :: cudaDevAttrMaxSurfaceCubemapLayeredWidth    = 67
  enumerator :: cudaDevAttrMaxSurfaceCubemapLayeredLayers   = 68
  enumerator :: cudaDevAttrMaxTexture1DLinearWidth          = 69
  enumerator :: cudaDevAttrMaxTexture2DLinearWidth          = 70
  enumerator :: cudaDevAttrMaxTexture2DLinearHeight         = 71
  enumerator :: cudaDevAttrMaxTexture2DLinearPitch          = 72
  enumerator :: cudaDevAttrMaxTexture2DMipmappedWidth       = 73
  enumerator :: cudaDevAttrMaxTexture2DMipmappedHeight      = 74
  enumerator :: cudaDevAttrComputeCapabilityMajor           = 75
  enumerator :: cudaDevAttrComputeCapabilityMinor           = 76
  enumerator :: cudaDevAttrMaxTexture1DMipmappedWidth       = 77
  enumerator :: cudaDevAttrStreamPrioritiesSupported        = 78
  enumerator :: cudaDevAttrGlobalL1CacheSupported           = 79
  enumerator :: cudaDevAttrLocalL1CacheSupported            = 80
  enumerator :: cudaDevAttrMaxSharedMemoryPerMultiprocessor = 81
  enumerator :: cudaDevAttrMaxRegistersPerMultiprocessor    = 82
  enumerator :: cudaDevAttrManagedMemory                    = 83
  enumerator :: cudaDevAttrIsMultiGpuBoard                  = 84
  enumerator :: cudaDevAttrMultiGpuBoardGroupID             = 85
  enumerator :: cudaDevAttrHostNativeAtomicSupported        = 86
  enumerator :: cudaDevAttrSingleToDoublePrecisionPerfRatio = 87
  enumerator :: cudaDevAttrPageableMemoryAccess             = 88
  enumerator :: cudaDevAttrConcurrentManagedAccess          = 89
  enumerator :: cudaDevAttrComputePreemptionSupported       = 90
  enumerator :: cudaDevAttrCanUseHostPointerForRegisteredMem= 91
  enumerator :: cudaDevAttrReserved92                       = 92
  enumerator :: cudaDevAttrReserved93                       = 93
  enumerator :: cudaDevAttrReserved94                       = 94
  enumerator :: cudaDevAttrCooperativeLaunch                = 95
  enumerator :: cudaDevAttrCooperativeMultiDeviceLaunch     = 96
  enumerator :: cudaDevAttrMaxSharedMemoryPerBlockOptin     = 97
  enumerator :: cudaDevAttrCanFlushRemoteWrites             = 98
  enumerator :: cudaDevAttrHostRegisterSupported            = 99
  enumerator :: cudaDevAttrPageableMemoryAccessUsesHostPageTables = 100
  enumerator :: cudaDevAttrDirectManagedMemAccessFromHost   = 101
  enumerator :: cudaDevAttrMaxBlocksPerMultiprocessor       = 106
  enumerator :: cudaDevAttrMaxPersistingL2CacheSize         = 108
  enumerator :: cudaDevAttrMaxAccessPolicyWindowSize        = 109
  enumerator :: cudaDevAttrReservedSharedMemoryPerBlock     = 111
  enumerator :: cudaDevAttrSparseCudaArraySupported         = 112
  enumerator :: cudaDevAttrHostRegisterReadOnlySupported    = 113
  enumerator :: cudaDevAttrMaxTimelineSemaphoreInteropSupported = 114
  enumerator :: cudaDevAttrMemoryPoolsSupported             = 115
  enumerator :: cudaDevAttrGPUDirectRDMASupported           = 116
  enumerator :: cudaDevAttrGPUDirectRDMAFlushWritesOptions  = 117
  enumerator :: cudaDevAttrGPUDirectRDMAWritesOrdering      = 118
  enumerator :: cudaDevAttrMemoryPoolSupportedHandleTypes   = 119
  enumerator :: cudaDevAttrClusterLaunch                    = 120
  enumerator :: cudaDevAttrDeferredMappingCudaArraySupported    = 121
  enumerator :: cudaDevAttrReserved122                      = 122
  enumerator :: cudaDevAttrReserved123                      = 123
  enumerator :: cudaDevAttrReserved124                      = 124
  enumerator :: cudaDevAttrIpcEventSupport                  = 125
  enumerator :: cudaDevAttrMemSyncDomainCount               = 126
  enumerator :: cudaDevAttrReserved127                      = 127
  enumerator :: cudaDevAttrReserved128                      = 128
  enumerator :: cudaDevAttrReserved129                      = 129
  enumerator :: cudaDevAttrNumaConfig                       = 130
  enumerator :: cudaDevAttrNumaId                           = 131
  enumerator :: cudaDevAttrReserved132                      = 132
  enumerator :: cudaDevAttrMpsEnabled                       = 133
  enumerator :: cudaDevAttrHostNumaId                       = 134
  enumerator :: cudaDevAttrD3D12CigSupported                = 135
  enumerator :: cudaDevAttrVulkanCigSupported               = 138
  enumerator :: cudaDevAttrGpuPciDeviceId                   = 139
  enumerator :: cudaDevAttrGpuPciSubsystemId                = 140
  enumerator :: cudaDevAttrReserved141                      = 141
  enumerator :: cudaDevAttrHostNumaMemoryPoolsSupported     = 142
  enumerator :: cudaDevAttrHostNumaMultinodeIpcSupported    = 143
  enumerator :: cudaDevAttrHostMemoryPoolsSupported         = 144
  enumerator :: cudaDevAttrReserved145                      = 145
  enumerator :: cudaDevAttrOnlyPartialHostNativeAtomicSupported = 147
  enumerator cudaDevAttrMax
end enum

enum, bind(c)
  enumerator :: cudaStreamCaptureStatusNone   = 0
  enumerator cudaStreamCaptureStatusActive
  enumerator cudaStreamCaptureStatusInvalidated
end enum

enum, bind(c)
  enumerator :: cudaStreamCaptureModeGlobal   = 0
  enumerator cudaStreamCaptureModeThreadLocal
  enumerator cudaStreamCaptureModeRelaxed
end enum

enum, bind(c)
  enumerator :: cudaSyncPolicyAuto   = 1
  enumerator cudaSyncPolicySpin
  enumerator cudaSyncPolicyYield
  enumerator cudaSyncPolicyBlockingSync
end enum

integer, parameter :: cudaHostAllocDefault       = 0
integer, parameter :: cudaHostAllocPortable      = 1
integer, parameter :: cudaHostAllocMapped        = 2
integer, parameter :: cudaHostAllocWriteCombined = 4

integer, parameter :: cudaHostRegisterDefault    = 0
integer, parameter :: cudaHostRegisterPortable   = 1
integer, parameter :: cudaHostRegisterMapped     = 2
integer, parameter :: cudaHostRegisterIoMemory   = 4

integer, parameter :: cudaPeerAccessDefault      = 0

integer, parameter :: cudaDeviceScheduleAuto     = 0
integer, parameter :: cudaDeviceScheduleSpin     = 1
integer, parameter :: cudaDeviceScheduleYield    = 2
integer, parameter :: cudaDeviceBlockingSync     = 4
integer, parameter :: cudaDeviceScheduleBlockingSync = 4
integer, parameter :: cudaDeviceMapHost          = 8

integer, parameter :: cudaStreamDefault          = 0
integer, parameter :: cudaStreamNonBlocking      = 1

integer, parameter :: cudaEventDefault           = 0
integer, parameter :: cudaEventBlockingSync      = 1
integer, parameter :: cudaEventDisableTiming     = 2
integer, parameter :: cudaEventInterprocess      = 4

integer, parameter :: cudaTextureType1D          = 1
integer, parameter :: cudaTextureType2D          = 2
integer, parameter :: cudaTextureType3D          = 3

integer, parameter :: cudaMemAttachGlobal        = 1
integer, parameter :: cudaMemAttachHost          = 2
integer, parameter :: cudaMemAttachSingle        = 4

integer, parameter :: cudaOccupancyDefault       = 0
integer, parameter :: cudaOccupancyDisableCachingOverride = 1

integer, parameter :: cudaCpuDeviceId            = -1
integer, parameter :: cudaInvalidDeviceId        = -2

enum, bind(c)
  enumerator :: cudaMemPoolReuseFollowEventDependencies   = 1
  enumerator cudaMemPoolReuseAllowOpportunistic
  enumerator cudaMemPoolReuseAllowInternalDependencies
  enumerator cudaMemPoolAttrReleaseThreshold
end enum

enum, bind(c) ! cudaDeviceP2PAttr
  ! A relative value indicating the performance of the link between two devices
  enumerator :: cudaDevP2PAttrPerformanceRank              = 1 
  ! Peer access is enabled
  enumerator :: cudaDevP2PAttrAccessSupported              = 2
  ! Native atomic operation over the link supported
  enumerator :: cudaDevP2PAttrNativeAtomicSupported        = 3
  ! Accessing CUDA arrays over the link supported
  enumerator :: cudaDevP2PAttrCudaArrayAccessSupported     = 4
end enum

enum, bind(c) ! cudaLaunchAttributeID
  enumerator :: cudaLaunchAttributeIgnore	= 0
  enumerator cudaLaunchAttributeAccessPolicyWindow
  enumerator cudaLaunchAttributeCooperative
  enumerator cudaLaunchAttributeSynchronizationPolicy
  enumerator cudaLaunchAttributeClusterDimension
  enumerator cudaLaunchAttributeClusterSchedulingPolicyPreference
  enumerator cudaLaunchAttributeProgrammaticStreamSerialization
  enumerator cudaLaunchAttributeProgrammaticEvent
  enumerator cudaLaunchAttributePriority
end enum

enum, bind(c) !CUgraphInstantiate_flags
  ! Automatically free memory allocated in a graph before relaunching.
  enumerator :: CUDA_GRAPH_INSTANTIATE_FLAG_AUTO_FREE_ON_LAUNCH = 1
  ! Automatically upload the graph after instantiaton.
  enumerator :: CUDA_GRAPH_INSTANTIATE_FLAG_UPLOAD = 2
  ! Instantiate the graph to be launchable from the device.
  enumerator :: CUDA_GRAPH_INSTANTIATE_FLAG_DEVICE_LAUNCH = 4
  ! Run the graph using the per-node priority attributes rather than the priority of the stream it is launched into.
  enumerator :: CUDA_GRAPH_INSTANTIATE_FLAG_USE_NODE_PRIORITY = 8
end enum
